/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A resource that represents the background job that imports asset frames.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ImportJob}
 */
public final class ImportJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ImportJob)
    ImportJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportJob.newBuilder() to construct.
  private ImportJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportJob() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    assetSource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ImportJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ImportJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ImportJob.class,
            com.google.cloud.migrationcenter.v1.ImportJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumerates possible states of an import job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.ImportJob.ImportJobState}
   */
  public enum ImportJobState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_UNSPECIFIED = 0;</code>
     */
    IMPORT_JOB_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The import job is pending.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_PENDING = 1;</code>
     */
    IMPORT_JOB_STATE_PENDING(1),
    /**
     *
     *
     * <pre>
     * The processing of the import job is ongoing.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_RUNNING = 2;</code>
     */
    IMPORT_JOB_STATE_RUNNING(2),
    /**
     *
     *
     * <pre>
     * The import job processing has completed.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_COMPLETED = 3;</code>
     */
    IMPORT_JOB_STATE_COMPLETED(3),
    /**
     *
     *
     * <pre>
     * The import job failed to be processed.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_FAILED = 4;</code>
     */
    IMPORT_JOB_STATE_FAILED(4),
    /**
     *
     *
     * <pre>
     * The import job is being validated.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_VALIDATING = 5;</code>
     */
    IMPORT_JOB_STATE_VALIDATING(5),
    /**
     *
     *
     * <pre>
     * The import job contains blocking errors.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_FAILED_VALIDATION = 6;</code>
     */
    IMPORT_JOB_STATE_FAILED_VALIDATION(6),
    /**
     *
     *
     * <pre>
     * The validation of the job completed with no blocking errors.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_READY = 7;</code>
     */
    IMPORT_JOB_STATE_READY(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int IMPORT_JOB_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The import job is pending.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_PENDING = 1;</code>
     */
    public static final int IMPORT_JOB_STATE_PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The processing of the import job is ongoing.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_RUNNING = 2;</code>
     */
    public static final int IMPORT_JOB_STATE_RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The import job processing has completed.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_COMPLETED = 3;</code>
     */
    public static final int IMPORT_JOB_STATE_COMPLETED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The import job failed to be processed.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_FAILED = 4;</code>
     */
    public static final int IMPORT_JOB_STATE_FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The import job is being validated.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_VALIDATING = 5;</code>
     */
    public static final int IMPORT_JOB_STATE_VALIDATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The import job contains blocking errors.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_FAILED_VALIDATION = 6;</code>
     */
    public static final int IMPORT_JOB_STATE_FAILED_VALIDATION_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The validation of the job completed with no blocking errors.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_READY = 7;</code>
     */
    public static final int IMPORT_JOB_STATE_READY_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportJobState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ImportJobState forNumber(int value) {
      switch (value) {
        case 0:
          return IMPORT_JOB_STATE_UNSPECIFIED;
        case 1:
          return IMPORT_JOB_STATE_PENDING;
        case 2:
          return IMPORT_JOB_STATE_RUNNING;
        case 3:
          return IMPORT_JOB_STATE_COMPLETED;
        case 4:
          return IMPORT_JOB_STATE_FAILED;
        case 5:
          return IMPORT_JOB_STATE_VALIDATING;
        case 6:
          return IMPORT_JOB_STATE_FAILED_VALIDATION;
        case 7:
          return IMPORT_JOB_STATE_READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ImportJobState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ImportJobState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ImportJobState>() {
          public ImportJobState findValueByNumber(int number) {
            return ImportJobState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.ImportJob.getDescriptor().getEnumTypes().get(0);
    }

    private static final ImportJobState[] VALUES = values();

    public static ImportJobState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ImportJobState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.ImportJob.ImportJobState)
  }

  private int reportCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object report_;

  public enum ReportCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VALIDATION_REPORT(10),
    EXECUTION_REPORT(11),
    REPORT_NOT_SET(0);
    private final int value;

    private ReportCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReportCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReportCase forNumber(int value) {
      switch (value) {
        case 10:
          return VALIDATION_REPORT;
        case 11:
          return EXECUTION_REPORT;
        case 0:
          return REPORT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReportCase getReportCase() {
    return ReportCase.forNumber(reportCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full name of the import job.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full name of the import job.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User-friendly display name. Maximum length is 63 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-friendly display name. Maximum length is 63 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int COMPLETE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp completeTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completeTime field is set.
   */
  @java.lang.Override
  public boolean hasCompleteTime() {
    return completeTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCompleteTime() {
    return completeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completeTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the import job was completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCompleteTimeOrBuilder() {
    return completeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completeTime_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState getState() {
    com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState result =
        com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState.forNumber(state_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState.UNRECOGNIZED
        : result;
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.migrationcenter.v1.MigrationCenterProto
                .internal_static_google_cloud_migrationcenter_v1_ImportJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ASSET_SOURCE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object assetSource_ = "";
  /**
   *
   *
   * <pre>
   * Required. Reference to a source.
   * </pre>
   *
   * <code>
   * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The assetSource.
   */
  @java.lang.Override
  public java.lang.String getAssetSource() {
    java.lang.Object ref = assetSource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assetSource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Reference to a source.
   * </pre>
   *
   * <code>
   * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for assetSource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAssetSourceBytes() {
    java.lang.Object ref = assetSource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      assetSource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATION_REPORT_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Output only. The report with the validation results of the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the validationReport field is set.
   */
  @java.lang.Override
  public boolean hasValidationReport() {
    return reportCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Output only. The report with the validation results of the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The validationReport.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ValidationReport getValidationReport() {
    if (reportCase_ == 10) {
      return (com.google.cloud.migrationcenter.v1.ValidationReport) report_;
    }
    return com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The report with the validation results of the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ValidationReportOrBuilder
      getValidationReportOrBuilder() {
    if (reportCase_ == 10) {
      return (com.google.cloud.migrationcenter.v1.ValidationReport) report_;
    }
    return com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
  }

  public static final int EXECUTION_REPORT_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Output only. The report with the results of running the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the executionReport field is set.
   */
  @java.lang.Override
  public boolean hasExecutionReport() {
    return reportCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Output only. The report with the results of running the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The executionReport.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ExecutionReport getExecutionReport() {
    if (reportCase_ == 11) {
      return (com.google.cloud.migrationcenter.v1.ExecutionReport) report_;
    }
    return com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The report with the results of running the import job.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ExecutionReportOrBuilder
      getExecutionReportOrBuilder() {
    if (reportCase_ == 11) {
      return (com.google.cloud.migrationcenter.v1.ExecutionReport) report_;
    }
    return com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (completeTime_ != null) {
      output.writeMessage(5, getCompleteTime());
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState.IMPORT_JOB_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, state_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetSource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, assetSource_);
    }
    if (reportCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.migrationcenter.v1.ValidationReport) report_);
    }
    if (reportCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.migrationcenter.v1.ExecutionReport) report_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (completeTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCompleteTime());
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState.IMPORT_JOB_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetSource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, assetSource_);
    }
    if (reportCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.migrationcenter.v1.ValidationReport) report_);
    }
    if (reportCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.migrationcenter.v1.ExecutionReport) report_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ImportJob)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ImportJob other =
        (com.google.cloud.migrationcenter.v1.ImportJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasCompleteTime() != other.hasCompleteTime()) return false;
    if (hasCompleteTime()) {
      if (!getCompleteTime().equals(other.getCompleteTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getAssetSource().equals(other.getAssetSource())) return false;
    if (!getReportCase().equals(other.getReportCase())) return false;
    switch (reportCase_) {
      case 10:
        if (!getValidationReport().equals(other.getValidationReport())) return false;
        break;
      case 11:
        if (!getExecutionReport().equals(other.getExecutionReport())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasCompleteTime()) {
      hash = (37 * hash) + COMPLETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCompleteTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ASSET_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getAssetSource().hashCode();
    switch (reportCase_) {
      case 10:
        hash = (37 * hash) + VALIDATION_REPORT_FIELD_NUMBER;
        hash = (53 * hash) + getValidationReport().hashCode();
        break;
      case 11:
        hash = (37 * hash) + EXECUTION_REPORT_FIELD_NUMBER;
        hash = (53 * hash) + getExecutionReport().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ImportJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource that represents the background job that imports asset frames.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ImportJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ImportJob)
      com.google.cloud.migrationcenter.v1.ImportJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ImportJob.class,
              com.google.cloud.migrationcenter.v1.ImportJob.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ImportJob.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      completeTime_ = null;
      if (completeTimeBuilder_ != null) {
        completeTimeBuilder_.dispose();
        completeTimeBuilder_ = null;
      }
      state_ = 0;
      internalGetMutableLabels().clear();
      assetSource_ = "";
      if (validationReportBuilder_ != null) {
        validationReportBuilder_.clear();
      }
      if (executionReportBuilder_ != null) {
        executionReportBuilder_.clear();
      }
      reportCase_ = 0;
      report_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportJob getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ImportJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportJob build() {
      com.google.cloud.migrationcenter.v1.ImportJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportJob buildPartial() {
      com.google.cloud.migrationcenter.v1.ImportJob result =
          new com.google.cloud.migrationcenter.v1.ImportJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ImportJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.completeTime_ =
            completeTimeBuilder_ == null ? completeTime_ : completeTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.assetSource_ = assetSource_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.ImportJob result) {
      result.reportCase_ = reportCase_;
      result.report_ = this.report_;
      if (reportCase_ == 10 && validationReportBuilder_ != null) {
        result.report_ = validationReportBuilder_.build();
      }
      if (reportCase_ == 11 && executionReportBuilder_ != null) {
        result.report_ = executionReportBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ImportJob) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ImportJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ImportJob other) {
      if (other == com.google.cloud.migrationcenter.v1.ImportJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasCompleteTime()) {
        mergeCompleteTime(other.getCompleteTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (!other.getAssetSource().isEmpty()) {
        assetSource_ = other.assetSource_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      switch (other.getReportCase()) {
        case VALIDATION_REPORT:
          {
            mergeValidationReport(other.getValidationReport());
            break;
          }
        case EXECUTION_REPORT:
          {
            mergeExecutionReport(other.getExecutionReport());
            break;
          }
        case REPORT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCompleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                assetSource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(
                    getValidationReportFieldBuilder().getBuilder(), extensionRegistry);
                reportCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getExecutionReportFieldBuilder().getBuilder(), extensionRegistry);
                reportCase_ = 11;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int reportCase_ = 0;
    private java.lang.Object report_;

    public ReportCase getReportCase() {
      return ReportCase.forNumber(reportCase_);
    }

    public Builder clearReport() {
      reportCase_ = 0;
      report_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full name of the import job.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the import job.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the import job.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the import job.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the import job.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp completeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        completeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the completeTime field is set.
     */
    public boolean hasCompleteTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completeTime.
     */
    public com.google.protobuf.Timestamp getCompleteTime() {
      if (completeTimeBuilder_ == null) {
        return completeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completeTime_;
      } else {
        return completeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompleteTime(com.google.protobuf.Timestamp value) {
      if (completeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completeTime_ = value;
      } else {
        completeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (completeTimeBuilder_ == null) {
        completeTime_ = builderForValue.build();
      } else {
        completeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCompleteTime(com.google.protobuf.Timestamp value) {
      if (completeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && completeTime_ != null
            && completeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCompleteTimeBuilder().mergeFrom(value);
        } else {
          completeTime_ = value;
        }
      } else {
        completeTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompleteTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      completeTime_ = null;
      if (completeTimeBuilder_ != null) {
        completeTimeBuilder_.dispose();
        completeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCompleteTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCompleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCompleteTimeOrBuilder() {
      if (completeTimeBuilder_ != null) {
        return completeTimeBuilder_.getMessageOrBuilder();
      } else {
        return completeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the import job was completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCompleteTimeFieldBuilder() {
      if (completeTimeBuilder_ == null) {
        completeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCompleteTime(), getParentForChildren(), isClean());
        completeTime_ = null;
      }
      return completeTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState getState() {
      com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState result =
          com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState.forNumber(state_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.migrationcenter.v1.ImportJob.ImportJobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.lang.Object assetSource_ = "";
    /**
     *
     *
     * <pre>
     * Required. Reference to a source.
     * </pre>
     *
     * <code>
     * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The assetSource.
     */
    public java.lang.String getAssetSource() {
      java.lang.Object ref = assetSource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assetSource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to a source.
     * </pre>
     *
     * <code>
     * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for assetSource.
     */
    public com.google.protobuf.ByteString getAssetSourceBytes() {
      java.lang.Object ref = assetSource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assetSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to a source.
     * </pre>
     *
     * <code>
     * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The assetSource to set.
     * @return This builder for chaining.
     */
    public Builder setAssetSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      assetSource_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to a source.
     * </pre>
     *
     * <code>
     * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssetSource() {
      assetSource_ = getDefaultInstance().getAssetSource();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to a source.
     * </pre>
     *
     * <code>
     * string asset_source = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for assetSource to set.
     * @return This builder for chaining.
     */
    public Builder setAssetSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      assetSource_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ValidationReport,
            com.google.cloud.migrationcenter.v1.ValidationReport.Builder,
            com.google.cloud.migrationcenter.v1.ValidationReportOrBuilder>
        validationReportBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the validationReport field is set.
     */
    @java.lang.Override
    public boolean hasValidationReport() {
      return reportCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The validationReport.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ValidationReport getValidationReport() {
      if (validationReportBuilder_ == null) {
        if (reportCase_ == 10) {
          return (com.google.cloud.migrationcenter.v1.ValidationReport) report_;
        }
        return com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
      } else {
        if (reportCase_ == 10) {
          return validationReportBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setValidationReport(com.google.cloud.migrationcenter.v1.ValidationReport value) {
      if (validationReportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        report_ = value;
        onChanged();
      } else {
        validationReportBuilder_.setMessage(value);
      }
      reportCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setValidationReport(
        com.google.cloud.migrationcenter.v1.ValidationReport.Builder builderForValue) {
      if (validationReportBuilder_ == null) {
        report_ = builderForValue.build();
        onChanged();
      } else {
        validationReportBuilder_.setMessage(builderForValue.build());
      }
      reportCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeValidationReport(
        com.google.cloud.migrationcenter.v1.ValidationReport value) {
      if (validationReportBuilder_ == null) {
        if (reportCase_ == 10
            && report_
                != com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance()) {
          report_ =
              com.google.cloud.migrationcenter.v1.ValidationReport.newBuilder(
                      (com.google.cloud.migrationcenter.v1.ValidationReport) report_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          report_ = value;
        }
        onChanged();
      } else {
        if (reportCase_ == 10) {
          validationReportBuilder_.mergeFrom(value);
        } else {
          validationReportBuilder_.setMessage(value);
        }
      }
      reportCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearValidationReport() {
      if (validationReportBuilder_ == null) {
        if (reportCase_ == 10) {
          reportCase_ = 0;
          report_ = null;
          onChanged();
        }
      } else {
        if (reportCase_ == 10) {
          reportCase_ = 0;
          report_ = null;
        }
        validationReportBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ValidationReport.Builder
        getValidationReportBuilder() {
      return getValidationReportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ValidationReportOrBuilder
        getValidationReportOrBuilder() {
      if ((reportCase_ == 10) && (validationReportBuilder_ != null)) {
        return validationReportBuilder_.getMessageOrBuilder();
      } else {
        if (reportCase_ == 10) {
          return (com.google.cloud.migrationcenter.v1.ValidationReport) report_;
        }
        return com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the validation results of the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ValidationReport validation_report = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ValidationReport,
            com.google.cloud.migrationcenter.v1.ValidationReport.Builder,
            com.google.cloud.migrationcenter.v1.ValidationReportOrBuilder>
        getValidationReportFieldBuilder() {
      if (validationReportBuilder_ == null) {
        if (!(reportCase_ == 10)) {
          report_ = com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
        }
        validationReportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ValidationReport,
                com.google.cloud.migrationcenter.v1.ValidationReport.Builder,
                com.google.cloud.migrationcenter.v1.ValidationReportOrBuilder>(
                (com.google.cloud.migrationcenter.v1.ValidationReport) report_,
                getParentForChildren(),
                isClean());
        report_ = null;
      }
      reportCase_ = 10;
      onChanged();
      return validationReportBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ExecutionReport,
            com.google.cloud.migrationcenter.v1.ExecutionReport.Builder,
            com.google.cloud.migrationcenter.v1.ExecutionReportOrBuilder>
        executionReportBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the executionReport field is set.
     */
    @java.lang.Override
    public boolean hasExecutionReport() {
      return reportCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The executionReport.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ExecutionReport getExecutionReport() {
      if (executionReportBuilder_ == null) {
        if (reportCase_ == 11) {
          return (com.google.cloud.migrationcenter.v1.ExecutionReport) report_;
        }
        return com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance();
      } else {
        if (reportCase_ == 11) {
          return executionReportBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExecutionReport(com.google.cloud.migrationcenter.v1.ExecutionReport value) {
      if (executionReportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        report_ = value;
        onChanged();
      } else {
        executionReportBuilder_.setMessage(value);
      }
      reportCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExecutionReport(
        com.google.cloud.migrationcenter.v1.ExecutionReport.Builder builderForValue) {
      if (executionReportBuilder_ == null) {
        report_ = builderForValue.build();
        onChanged();
      } else {
        executionReportBuilder_.setMessage(builderForValue.build());
      }
      reportCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExecutionReport(com.google.cloud.migrationcenter.v1.ExecutionReport value) {
      if (executionReportBuilder_ == null) {
        if (reportCase_ == 11
            && report_
                != com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance()) {
          report_ =
              com.google.cloud.migrationcenter.v1.ExecutionReport.newBuilder(
                      (com.google.cloud.migrationcenter.v1.ExecutionReport) report_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          report_ = value;
        }
        onChanged();
      } else {
        if (reportCase_ == 11) {
          executionReportBuilder_.mergeFrom(value);
        } else {
          executionReportBuilder_.setMessage(value);
        }
      }
      reportCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExecutionReport() {
      if (executionReportBuilder_ == null) {
        if (reportCase_ == 11) {
          reportCase_ = 0;
          report_ = null;
          onChanged();
        }
      } else {
        if (reportCase_ == 11) {
          reportCase_ = 0;
          report_ = null;
        }
        executionReportBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ExecutionReport.Builder getExecutionReportBuilder() {
      return getExecutionReportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ExecutionReportOrBuilder
        getExecutionReportOrBuilder() {
      if ((reportCase_ == 11) && (executionReportBuilder_ != null)) {
        return executionReportBuilder_.getMessageOrBuilder();
      } else {
        if (reportCase_ == 11) {
          return (com.google.cloud.migrationcenter.v1.ExecutionReport) report_;
        }
        return com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The report with the results of running the import job.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ExecutionReport execution_report = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ExecutionReport,
            com.google.cloud.migrationcenter.v1.ExecutionReport.Builder,
            com.google.cloud.migrationcenter.v1.ExecutionReportOrBuilder>
        getExecutionReportFieldBuilder() {
      if (executionReportBuilder_ == null) {
        if (!(reportCase_ == 11)) {
          report_ = com.google.cloud.migrationcenter.v1.ExecutionReport.getDefaultInstance();
        }
        executionReportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ExecutionReport,
                com.google.cloud.migrationcenter.v1.ExecutionReport.Builder,
                com.google.cloud.migrationcenter.v1.ExecutionReportOrBuilder>(
                (com.google.cloud.migrationcenter.v1.ExecutionReport) report_,
                getParentForChildren(),
                isClean());
        report_ = null;
      }
      reportCase_ = 11;
      onChanged();
      return executionReportBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ImportJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ImportJob)
  private static final com.google.cloud.migrationcenter.v1.ImportJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ImportJob();
  }

  public static com.google.cloud.migrationcenter.v1.ImportJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportJob> PARSER =
      new com.google.protobuf.AbstractParser<ImportJob>() {
        @java.lang.Override
        public ImportJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
