/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A resource that reports the import job errors at row level.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ImportRowError}
 */
public final class ImportRowError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ImportRowError)
    ImportRowErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportRowError.newBuilder() to construct.
  private ImportRowError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportRowError() {
    vmName_ = "";
    vmUuid_ = "";
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportRowError();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ImportRowError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ImportRowError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ImportRowError.class,
            com.google.cloud.migrationcenter.v1.ImportRowError.Builder.class);
  }

  public static final int ROW_NUMBER_FIELD_NUMBER = 1;
  private int rowNumber_ = 0;
  /**
   *
   *
   * <pre>
   * The row number where the error was detected.
   * </pre>
   *
   * <code>int32 row_number = 1 [deprecated = true];</code>
   *
   * @deprecated google.cloud.migrationcenter.v1.ImportRowError.row_number is deprecated. See
   *     google/cloud/migrationcenter/v1/migrationcenter.proto;l=3572
   * @return The rowNumber.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getRowNumber() {
    return rowNumber_;
  }

  public static final int VM_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vmName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the VM in the row.
   * </pre>
   *
   * <code>string vm_name = 2;</code>
   *
   * @return The vmName.
   */
  @java.lang.Override
  public java.lang.String getVmName() {
    java.lang.Object ref = vmName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vmName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the VM in the row.
   * </pre>
   *
   * <code>string vm_name = 2;</code>
   *
   * @return The bytes for vmName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVmNameBytes() {
    java.lang.Object ref = vmName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vmName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_UUID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vmUuid_ = "";
  /**
   *
   *
   * <pre>
   * The VM UUID.
   * </pre>
   *
   * <code>string vm_uuid = 3;</code>
   *
   * @return The vmUuid.
   */
  @java.lang.Override
  public java.lang.String getVmUuid() {
    java.lang.Object ref = vmUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vmUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The VM UUID.
   * </pre>
   *
   * <code>string vm_uuid = 3;</code>
   *
   * @return The bytes for vmUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVmUuidBytes() {
    java.lang.Object ref = vmUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vmUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERRORS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.ImportError> errors_;
  /**
   *
   *
   * <pre>
   * The list of errors detected in the row.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.ImportError> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * The list of errors detected in the row.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * The list of errors detected in the row.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of errors detected in the row.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportError getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of errors detected in the row.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (rowNumber_ != 0) {
      output.writeInt32(1, rowNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vmName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, vmName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vmUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, vmUuid_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(4, errors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (rowNumber_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, rowNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vmName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, vmName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vmUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, vmUuid_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, errors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ImportRowError)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ImportRowError other =
        (com.google.cloud.migrationcenter.v1.ImportRowError) obj;

    if (getRowNumber() != other.getRowNumber()) return false;
    if (!getVmName().equals(other.getVmName())) return false;
    if (!getVmUuid().equals(other.getVmUuid())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROW_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getRowNumber();
    hash = (37 * hash) + VM_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getVmName().hashCode();
    hash = (37 * hash) + VM_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getVmUuid().hashCode();
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ImportRowError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource that reports the import job errors at row level.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ImportRowError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ImportRowError)
      com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportRowError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportRowError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ImportRowError.class,
              com.google.cloud.migrationcenter.v1.ImportRowError.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ImportRowError.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rowNumber_ = 0;
      vmName_ = "";
      vmUuid_ = "";
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportRowError_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportRowError getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ImportRowError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportRowError build() {
      com.google.cloud.migrationcenter.v1.ImportRowError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportRowError buildPartial() {
      com.google.cloud.migrationcenter.v1.ImportRowError result =
          new com.google.cloud.migrationcenter.v1.ImportRowError(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.ImportRowError result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ImportRowError result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rowNumber_ = rowNumber_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.vmName_ = vmName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.vmUuid_ = vmUuid_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ImportRowError) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ImportRowError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ImportRowError other) {
      if (other == com.google.cloud.migrationcenter.v1.ImportRowError.getDefaultInstance())
        return this;
      if (other.getRowNumber() != 0) {
        setRowNumber(other.getRowNumber());
      }
      if (!other.getVmName().isEmpty()) {
        vmName_ = other.vmName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getVmUuid().isEmpty()) {
        vmUuid_ = other.vmUuid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000008);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                rowNumber_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                vmName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                vmUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.migrationcenter.v1.ImportError m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ImportError.parser(),
                        extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int rowNumber_;
    /**
     *
     *
     * <pre>
     * The row number where the error was detected.
     * </pre>
     *
     * <code>int32 row_number = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.migrationcenter.v1.ImportRowError.row_number is deprecated. See
     *     google/cloud/migrationcenter/v1/migrationcenter.proto;l=3572
     * @return The rowNumber.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getRowNumber() {
      return rowNumber_;
    }
    /**
     *
     *
     * <pre>
     * The row number where the error was detected.
     * </pre>
     *
     * <code>int32 row_number = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.migrationcenter.v1.ImportRowError.row_number is deprecated. See
     *     google/cloud/migrationcenter/v1/migrationcenter.proto;l=3572
     * @param value The rowNumber to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setRowNumber(int value) {

      rowNumber_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The row number where the error was detected.
     * </pre>
     *
     * <code>int32 row_number = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.migrationcenter.v1.ImportRowError.row_number is deprecated. See
     *     google/cloud/migrationcenter/v1/migrationcenter.proto;l=3572
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearRowNumber() {
      bitField0_ = (bitField0_ & ~0x00000001);
      rowNumber_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object vmName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the VM in the row.
     * </pre>
     *
     * <code>string vm_name = 2;</code>
     *
     * @return The vmName.
     */
    public java.lang.String getVmName() {
      java.lang.Object ref = vmName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vmName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the VM in the row.
     * </pre>
     *
     * <code>string vm_name = 2;</code>
     *
     * @return The bytes for vmName.
     */
    public com.google.protobuf.ByteString getVmNameBytes() {
      java.lang.Object ref = vmName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vmName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the VM in the row.
     * </pre>
     *
     * <code>string vm_name = 2;</code>
     *
     * @param value The vmName to set.
     * @return This builder for chaining.
     */
    public Builder setVmName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vmName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the VM in the row.
     * </pre>
     *
     * <code>string vm_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmName() {
      vmName_ = getDefaultInstance().getVmName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the VM in the row.
     * </pre>
     *
     * <code>string vm_name = 2;</code>
     *
     * @param value The bytes for vmName to set.
     * @return This builder for chaining.
     */
    public Builder setVmNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vmName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object vmUuid_ = "";
    /**
     *
     *
     * <pre>
     * The VM UUID.
     * </pre>
     *
     * <code>string vm_uuid = 3;</code>
     *
     * @return The vmUuid.
     */
    public java.lang.String getVmUuid() {
      java.lang.Object ref = vmUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vmUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VM UUID.
     * </pre>
     *
     * <code>string vm_uuid = 3;</code>
     *
     * @return The bytes for vmUuid.
     */
    public com.google.protobuf.ByteString getVmUuidBytes() {
      java.lang.Object ref = vmUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vmUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VM UUID.
     * </pre>
     *
     * <code>string vm_uuid = 3;</code>
     *
     * @param value The vmUuid to set.
     * @return This builder for chaining.
     */
    public Builder setVmUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vmUuid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM UUID.
     * </pre>
     *
     * <code>string vm_uuid = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmUuid() {
      vmUuid_ = getDefaultInstance().getVmUuid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM UUID.
     * </pre>
     *
     * <code>string vm_uuid = 3;</code>
     *
     * @param value The bytes for vmUuid to set.
     * @return This builder for chaining.
     */
    public Builder setVmUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vmUuid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.ImportError> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        errors_ = new java.util.ArrayList<com.google.cloud.migrationcenter.v1.ImportError>(errors_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportError,
            com.google.cloud.migrationcenter.v1.ImportError.Builder,
            com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportError> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder setErrors(int index, com.google.cloud.migrationcenter.v1.ImportError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder setErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder addErrors(com.google.cloud.migrationcenter.v1.ImportError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder addErrors(int index, com.google.cloud.migrationcenter.v1.ImportError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder addErrors(
        com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder addErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.ImportError> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.ImportError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.migrationcenter.v1.ImportError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of errors detected in the row.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError errors = 4;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportError.Builder>
        getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportError,
            com.google.cloud.migrationcenter.v1.ImportError.Builder,
            com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ImportError,
                com.google.cloud.migrationcenter.v1.ImportError.Builder,
                com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ImportRowError)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ImportRowError)
  private static final com.google.cloud.migrationcenter.v1.ImportRowError DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ImportRowError();
  }

  public static com.google.cloud.migrationcenter.v1.ImportRowError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportRowError> PARSER =
      new com.google.protobuf.AbstractParser<ImportRowError>() {
        @java.lang.Override
        public ImportRowError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportRowError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportRowError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportRowError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
