/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Details of the machine architecture.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.MachineArchitectureDetails}
 */
public final class MachineArchitectureDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.MachineArchitectureDetails)
    MachineArchitectureDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MachineArchitectureDetails.newBuilder() to construct.
  private MachineArchitectureDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MachineArchitectureDetails() {
    cpuArchitecture_ = "";
    cpuName_ = "";
    vendor_ = "";
    firmwareType_ = 0;
    hyperthreading_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MachineArchitectureDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_MachineArchitectureDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_MachineArchitectureDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.class,
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Firmware type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType}
   */
  public enum FirmwareType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified or unknown.
     * </pre>
     *
     * <code>FIRMWARE_TYPE_UNSPECIFIED = 0;</code>
     */
    FIRMWARE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * BIOS firmware.
     * </pre>
     *
     * <code>BIOS = 1;</code>
     */
    BIOS(1),
    /**
     *
     *
     * <pre>
     * EFI firmware.
     * </pre>
     *
     * <code>EFI = 2;</code>
     */
    EFI(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified or unknown.
     * </pre>
     *
     * <code>FIRMWARE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FIRMWARE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * BIOS firmware.
     * </pre>
     *
     * <code>BIOS = 1;</code>
     */
    public static final int BIOS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * EFI firmware.
     * </pre>
     *
     * <code>EFI = 2;</code>
     */
    public static final int EFI_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FirmwareType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FirmwareType forNumber(int value) {
      switch (value) {
        case 0:
          return FIRMWARE_TYPE_UNSPECIFIED;
        case 1:
          return BIOS;
        case 2:
          return EFI;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FirmwareType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FirmwareType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FirmwareType>() {
          public FirmwareType findValueByNumber(int number) {
            return FirmwareType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FirmwareType[] VALUES = values();

    public static FirmwareType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FirmwareType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType)
  }

  /**
   *
   *
   * <pre>
   * CPU hyper-threading support.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading}
   */
  public enum CpuHyperThreading implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified or unknown.
     * </pre>
     *
     * <code>CPU_HYPER_THREADING_UNSPECIFIED = 0;</code>
     */
    CPU_HYPER_THREADING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Hyper-threading is disabled.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    DISABLED(1),
    /**
     *
     *
     * <pre>
     * Hyper-threading is enabled.
     * </pre>
     *
     * <code>ENABLED = 2;</code>
     */
    ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified or unknown.
     * </pre>
     *
     * <code>CPU_HYPER_THREADING_UNSPECIFIED = 0;</code>
     */
    public static final int CPU_HYPER_THREADING_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Hyper-threading is disabled.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    public static final int DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Hyper-threading is enabled.
     * </pre>
     *
     * <code>ENABLED = 2;</code>
     */
    public static final int ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CpuHyperThreading valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CpuHyperThreading forNumber(int value) {
      switch (value) {
        case 0:
          return CPU_HYPER_THREADING_UNSPECIFIED;
        case 1:
          return DISABLED;
        case 2:
          return ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CpuHyperThreading>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CpuHyperThreading>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CpuHyperThreading>() {
              public CpuHyperThreading findValueByNumber(int number) {
                return CpuHyperThreading.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final CpuHyperThreading[] VALUES = values();

    public static CpuHyperThreading valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CpuHyperThreading(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading)
  }

  public static final int CPU_ARCHITECTURE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cpuArchitecture_ = "";
  /**
   *
   *
   * <pre>
   * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
   * </pre>
   *
   * <code>string cpu_architecture = 1;</code>
   *
   * @return The cpuArchitecture.
   */
  @java.lang.Override
  public java.lang.String getCpuArchitecture() {
    java.lang.Object ref = cpuArchitecture_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuArchitecture_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
   * </pre>
   *
   * <code>string cpu_architecture = 1;</code>
   *
   * @return The bytes for cpuArchitecture.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuArchitectureBytes() {
    java.lang.Object ref = cpuArchitecture_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuArchitecture_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CPU_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cpuName_ = "";
  /**
   *
   *
   * <pre>
   * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
   * </pre>
   *
   * <code>string cpu_name = 2;</code>
   *
   * @return The cpuName.
   */
  @java.lang.Override
  public java.lang.String getCpuName() {
    java.lang.Object ref = cpuName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
   * </pre>
   *
   * <code>string cpu_name = 2;</code>
   *
   * @return The bytes for cpuName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuNameBytes() {
    java.lang.Object ref = cpuName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VENDOR_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vendor_ = "";
  /**
   *
   *
   * <pre>
   * Hardware vendor.
   * </pre>
   *
   * <code>string vendor = 3;</code>
   *
   * @return The vendor.
   */
  @java.lang.Override
  public java.lang.String getVendor() {
    java.lang.Object ref = vendor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vendor_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Hardware vendor.
   * </pre>
   *
   * <code>string vendor = 3;</code>
   *
   * @return The bytes for vendor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVendorBytes() {
    java.lang.Object ref = vendor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vendor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CPU_THREAD_COUNT_FIELD_NUMBER = 4;
  private int cpuThreadCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of CPU threads allocated to the machine.
   * </pre>
   *
   * <code>int32 cpu_thread_count = 4;</code>
   *
   * @return The cpuThreadCount.
   */
  @java.lang.Override
  public int getCpuThreadCount() {
    return cpuThreadCount_;
  }

  public static final int CPU_SOCKET_COUNT_FIELD_NUMBER = 5;
  private int cpuSocketCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of processor sockets allocated to the machine.
   * </pre>
   *
   * <code>int32 cpu_socket_count = 5;</code>
   *
   * @return The cpuSocketCount.
   */
  @java.lang.Override
  public int getCpuSocketCount() {
    return cpuSocketCount_;
  }

  public static final int BIOS_FIELD_NUMBER = 6;
  private com.google.cloud.migrationcenter.v1.BiosDetails bios_;
  /**
   *
   *
   * <pre>
   * BIOS Details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
   *
   * @return Whether the bios field is set.
   */
  @java.lang.Override
  public boolean hasBios() {
    return bios_ != null;
  }
  /**
   *
   *
   * <pre>
   * BIOS Details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
   *
   * @return The bios.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.BiosDetails getBios() {
    return bios_ == null
        ? com.google.cloud.migrationcenter.v1.BiosDetails.getDefaultInstance()
        : bios_;
  }
  /**
   *
   *
   * <pre>
   * BIOS Details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.BiosDetailsOrBuilder getBiosOrBuilder() {
    return bios_ == null
        ? com.google.cloud.migrationcenter.v1.BiosDetails.getDefaultInstance()
        : bios_;
  }

  public static final int FIRMWARE_TYPE_FIELD_NUMBER = 7;
  private int firmwareType_ = 0;
  /**
   *
   *
   * <pre>
   * Firmware type.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for firmwareType.
   */
  @java.lang.Override
  public int getFirmwareTypeValue() {
    return firmwareType_;
  }
  /**
   *
   *
   * <pre>
   * Firmware type.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
   * </code>
   *
   * @return The firmwareType.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType
      getFirmwareType() {
    com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType result =
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType.forNumber(
            firmwareType_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType.UNRECOGNIZED
        : result;
  }

  public static final int HYPERTHREADING_FIELD_NUMBER = 8;
  private int hyperthreading_ = 0;
  /**
   *
   *
   * <pre>
   * CPU hyper-threading support.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
   * </code>
   *
   * @return The enum numeric value on the wire for hyperthreading.
   */
  @java.lang.Override
  public int getHyperthreadingValue() {
    return hyperthreading_;
  }
  /**
   *
   *
   * <pre>
   * CPU hyper-threading support.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
   * </code>
   *
   * @return The hyperthreading.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
      getHyperthreading() {
    com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading result =
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading.forNumber(
            hyperthreading_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuArchitecture_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cpuArchitecture_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cpuName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vendor_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, vendor_);
    }
    if (cpuThreadCount_ != 0) {
      output.writeInt32(4, cpuThreadCount_);
    }
    if (cpuSocketCount_ != 0) {
      output.writeInt32(5, cpuSocketCount_);
    }
    if (bios_ != null) {
      output.writeMessage(6, getBios());
    }
    if (firmwareType_
        != com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType
            .FIRMWARE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, firmwareType_);
    }
    if (hyperthreading_
        != com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
            .CPU_HYPER_THREADING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, hyperthreading_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuArchitecture_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cpuArchitecture_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cpuName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vendor_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, vendor_);
    }
    if (cpuThreadCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, cpuThreadCount_);
    }
    if (cpuSocketCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, cpuSocketCount_);
    }
    if (bios_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBios());
    }
    if (firmwareType_
        != com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType
            .FIRMWARE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, firmwareType_);
    }
    if (hyperthreading_
        != com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
            .CPU_HYPER_THREADING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, hyperthreading_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.MachineArchitectureDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.MachineArchitectureDetails other =
        (com.google.cloud.migrationcenter.v1.MachineArchitectureDetails) obj;

    if (!getCpuArchitecture().equals(other.getCpuArchitecture())) return false;
    if (!getCpuName().equals(other.getCpuName())) return false;
    if (!getVendor().equals(other.getVendor())) return false;
    if (getCpuThreadCount() != other.getCpuThreadCount()) return false;
    if (getCpuSocketCount() != other.getCpuSocketCount()) return false;
    if (hasBios() != other.hasBios()) return false;
    if (hasBios()) {
      if (!getBios().equals(other.getBios())) return false;
    }
    if (firmwareType_ != other.firmwareType_) return false;
    if (hyperthreading_ != other.hyperthreading_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CPU_ARCHITECTURE_FIELD_NUMBER;
    hash = (53 * hash) + getCpuArchitecture().hashCode();
    hash = (37 * hash) + CPU_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getCpuName().hashCode();
    hash = (37 * hash) + VENDOR_FIELD_NUMBER;
    hash = (53 * hash) + getVendor().hashCode();
    hash = (37 * hash) + CPU_THREAD_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCpuThreadCount();
    hash = (37 * hash) + CPU_SOCKET_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCpuSocketCount();
    if (hasBios()) {
      hash = (37 * hash) + BIOS_FIELD_NUMBER;
      hash = (53 * hash) + getBios().hashCode();
    }
    hash = (37 * hash) + FIRMWARE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + firmwareType_;
    hash = (37 * hash) + HYPERTHREADING_FIELD_NUMBER;
    hash = (53 * hash) + hyperthreading_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.MachineArchitectureDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of the machine architecture.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.MachineArchitectureDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.MachineArchitectureDetails)
      com.google.cloud.migrationcenter.v1.MachineArchitectureDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachineArchitectureDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachineArchitectureDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.class,
              com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cpuArchitecture_ = "";
      cpuName_ = "";
      vendor_ = "";
      cpuThreadCount_ = 0;
      cpuSocketCount_ = 0;
      bios_ = null;
      if (biosBuilder_ != null) {
        biosBuilder_.dispose();
        biosBuilder_ = null;
      }
      firmwareType_ = 0;
      hyperthreading_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachineArchitectureDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails
        getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails build() {
      com.google.cloud.migrationcenter.v1.MachineArchitectureDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails buildPartial() {
      com.google.cloud.migrationcenter.v1.MachineArchitectureDetails result =
          new com.google.cloud.migrationcenter.v1.MachineArchitectureDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cpuArchitecture_ = cpuArchitecture_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cpuName_ = cpuName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.vendor_ = vendor_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cpuThreadCount_ = cpuThreadCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.cpuSocketCount_ = cpuSocketCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.bios_ = biosBuilder_ == null ? bios_ : biosBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.firmwareType_ = firmwareType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.hyperthreading_ = hyperthreading_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.MachineArchitectureDetails) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.MachineArchitectureDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.MachineArchitectureDetails other) {
      if (other
          == com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDefaultInstance())
        return this;
      if (!other.getCpuArchitecture().isEmpty()) {
        cpuArchitecture_ = other.cpuArchitecture_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCpuName().isEmpty()) {
        cpuName_ = other.cpuName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getVendor().isEmpty()) {
        vendor_ = other.vendor_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getCpuThreadCount() != 0) {
        setCpuThreadCount(other.getCpuThreadCount());
      }
      if (other.getCpuSocketCount() != 0) {
        setCpuSocketCount(other.getCpuSocketCount());
      }
      if (other.hasBios()) {
        mergeBios(other.getBios());
      }
      if (other.firmwareType_ != 0) {
        setFirmwareTypeValue(other.getFirmwareTypeValue());
      }
      if (other.hyperthreading_ != 0) {
        setHyperthreadingValue(other.getHyperthreadingValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                cpuArchitecture_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                cpuName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                vendor_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                cpuThreadCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                cpuSocketCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getBiosFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                firmwareType_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                hyperthreading_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object cpuArchitecture_ = "";
    /**
     *
     *
     * <pre>
     * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
     * </pre>
     *
     * <code>string cpu_architecture = 1;</code>
     *
     * @return The cpuArchitecture.
     */
    public java.lang.String getCpuArchitecture() {
      java.lang.Object ref = cpuArchitecture_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuArchitecture_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
     * </pre>
     *
     * <code>string cpu_architecture = 1;</code>
     *
     * @return The bytes for cpuArchitecture.
     */
    public com.google.protobuf.ByteString getCpuArchitectureBytes() {
      java.lang.Object ref = cpuArchitecture_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuArchitecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
     * </pre>
     *
     * <code>string cpu_architecture = 1;</code>
     *
     * @param value The cpuArchitecture to set.
     * @return This builder for chaining.
     */
    public Builder setCpuArchitecture(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cpuArchitecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
     * </pre>
     *
     * <code>string cpu_architecture = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuArchitecture() {
      cpuArchitecture_ = getDefaultInstance().getCpuArchitecture();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
     * </pre>
     *
     * <code>string cpu_architecture = 1;</code>
     *
     * @param value The bytes for cpuArchitecture to set.
     * @return This builder for chaining.
     */
    public Builder setCpuArchitectureBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cpuArchitecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object cpuName_ = "";
    /**
     *
     *
     * <pre>
     * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
     * </pre>
     *
     * <code>string cpu_name = 2;</code>
     *
     * @return The cpuName.
     */
    public java.lang.String getCpuName() {
      java.lang.Object ref = cpuName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
     * </pre>
     *
     * <code>string cpu_name = 2;</code>
     *
     * @return The bytes for cpuName.
     */
    public com.google.protobuf.ByteString getCpuNameBytes() {
      java.lang.Object ref = cpuName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
     * </pre>
     *
     * <code>string cpu_name = 2;</code>
     *
     * @param value The cpuName to set.
     * @return This builder for chaining.
     */
    public Builder setCpuName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cpuName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
     * </pre>
     *
     * <code>string cpu_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuName() {
      cpuName_ = getDefaultInstance().getCpuName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
     * </pre>
     *
     * <code>string cpu_name = 2;</code>
     *
     * @param value The bytes for cpuName to set.
     * @return This builder for chaining.
     */
    public Builder setCpuNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cpuName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object vendor_ = "";
    /**
     *
     *
     * <pre>
     * Hardware vendor.
     * </pre>
     *
     * <code>string vendor = 3;</code>
     *
     * @return The vendor.
     */
    public java.lang.String getVendor() {
      java.lang.Object ref = vendor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vendor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Hardware vendor.
     * </pre>
     *
     * <code>string vendor = 3;</code>
     *
     * @return The bytes for vendor.
     */
    public com.google.protobuf.ByteString getVendorBytes() {
      java.lang.Object ref = vendor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vendor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Hardware vendor.
     * </pre>
     *
     * <code>string vendor = 3;</code>
     *
     * @param value The vendor to set.
     * @return This builder for chaining.
     */
    public Builder setVendor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vendor_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hardware vendor.
     * </pre>
     *
     * <code>string vendor = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVendor() {
      vendor_ = getDefaultInstance().getVendor();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hardware vendor.
     * </pre>
     *
     * <code>string vendor = 3;</code>
     *
     * @param value The bytes for vendor to set.
     * @return This builder for chaining.
     */
    public Builder setVendorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vendor_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int cpuThreadCount_;
    /**
     *
     *
     * <pre>
     * Number of CPU threads allocated to the machine.
     * </pre>
     *
     * <code>int32 cpu_thread_count = 4;</code>
     *
     * @return The cpuThreadCount.
     */
    @java.lang.Override
    public int getCpuThreadCount() {
      return cpuThreadCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of CPU threads allocated to the machine.
     * </pre>
     *
     * <code>int32 cpu_thread_count = 4;</code>
     *
     * @param value The cpuThreadCount to set.
     * @return This builder for chaining.
     */
    public Builder setCpuThreadCount(int value) {

      cpuThreadCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of CPU threads allocated to the machine.
     * </pre>
     *
     * <code>int32 cpu_thread_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuThreadCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cpuThreadCount_ = 0;
      onChanged();
      return this;
    }

    private int cpuSocketCount_;
    /**
     *
     *
     * <pre>
     * Number of processor sockets allocated to the machine.
     * </pre>
     *
     * <code>int32 cpu_socket_count = 5;</code>
     *
     * @return The cpuSocketCount.
     */
    @java.lang.Override
    public int getCpuSocketCount() {
      return cpuSocketCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of processor sockets allocated to the machine.
     * </pre>
     *
     * <code>int32 cpu_socket_count = 5;</code>
     *
     * @param value The cpuSocketCount to set.
     * @return This builder for chaining.
     */
    public Builder setCpuSocketCount(int value) {

      cpuSocketCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of processor sockets allocated to the machine.
     * </pre>
     *
     * <code>int32 cpu_socket_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuSocketCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      cpuSocketCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.BiosDetails bios_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.BiosDetails,
            com.google.cloud.migrationcenter.v1.BiosDetails.Builder,
            com.google.cloud.migrationcenter.v1.BiosDetailsOrBuilder>
        biosBuilder_;
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     *
     * @return Whether the bios field is set.
     */
    public boolean hasBios() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     *
     * @return The bios.
     */
    public com.google.cloud.migrationcenter.v1.BiosDetails getBios() {
      if (biosBuilder_ == null) {
        return bios_ == null
            ? com.google.cloud.migrationcenter.v1.BiosDetails.getDefaultInstance()
            : bios_;
      } else {
        return biosBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    public Builder setBios(com.google.cloud.migrationcenter.v1.BiosDetails value) {
      if (biosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bios_ = value;
      } else {
        biosBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    public Builder setBios(
        com.google.cloud.migrationcenter.v1.BiosDetails.Builder builderForValue) {
      if (biosBuilder_ == null) {
        bios_ = builderForValue.build();
      } else {
        biosBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    public Builder mergeBios(com.google.cloud.migrationcenter.v1.BiosDetails value) {
      if (biosBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && bios_ != null
            && bios_ != com.google.cloud.migrationcenter.v1.BiosDetails.getDefaultInstance()) {
          getBiosBuilder().mergeFrom(value);
        } else {
          bios_ = value;
        }
      } else {
        biosBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    public Builder clearBios() {
      bitField0_ = (bitField0_ & ~0x00000020);
      bios_ = null;
      if (biosBuilder_ != null) {
        biosBuilder_.dispose();
        biosBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.BiosDetails.Builder getBiosBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getBiosFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.BiosDetailsOrBuilder getBiosOrBuilder() {
      if (biosBuilder_ != null) {
        return biosBuilder_.getMessageOrBuilder();
      } else {
        return bios_ == null
            ? com.google.cloud.migrationcenter.v1.BiosDetails.getDefaultInstance()
            : bios_;
      }
    }
    /**
     *
     *
     * <pre>
     * BIOS Details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.BiosDetails bios = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.BiosDetails,
            com.google.cloud.migrationcenter.v1.BiosDetails.Builder,
            com.google.cloud.migrationcenter.v1.BiosDetailsOrBuilder>
        getBiosFieldBuilder() {
      if (biosBuilder_ == null) {
        biosBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.BiosDetails,
                com.google.cloud.migrationcenter.v1.BiosDetails.Builder,
                com.google.cloud.migrationcenter.v1.BiosDetailsOrBuilder>(
                getBios(), getParentForChildren(), isClean());
        bios_ = null;
      }
      return biosBuilder_;
    }

    private int firmwareType_ = 0;
    /**
     *
     *
     * <pre>
     * Firmware type.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for firmwareType.
     */
    @java.lang.Override
    public int getFirmwareTypeValue() {
      return firmwareType_;
    }
    /**
     *
     *
     * <pre>
     * Firmware type.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for firmwareType to set.
     * @return This builder for chaining.
     */
    public Builder setFirmwareTypeValue(int value) {
      firmwareType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Firmware type.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
     * </code>
     *
     * @return The firmwareType.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType
        getFirmwareType() {
      com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType result =
          com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType.forNumber(
              firmwareType_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Firmware type.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
     * </code>
     *
     * @param value The firmwareType to set.
     * @return This builder for chaining.
     */
    public Builder setFirmwareType(
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      firmwareType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Firmware type.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType firmware_type = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFirmwareType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      firmwareType_ = 0;
      onChanged();
      return this;
    }

    private int hyperthreading_ = 0;
    /**
     *
     *
     * <pre>
     * CPU hyper-threading support.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for hyperthreading.
     */
    @java.lang.Override
    public int getHyperthreadingValue() {
      return hyperthreading_;
    }
    /**
     *
     *
     * <pre>
     * CPU hyper-threading support.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
     * </code>
     *
     * @param value The enum numeric value on the wire for hyperthreading to set.
     * @return This builder for chaining.
     */
    public Builder setHyperthreadingValue(int value) {
      hyperthreading_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU hyper-threading support.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
     * </code>
     *
     * @return The hyperthreading.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
        getHyperthreading() {
      com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading result =
          com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
              .forNumber(hyperthreading_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * CPU hyper-threading support.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
     * </code>
     *
     * @param value The hyperthreading to set.
     * @return This builder for chaining.
     */
    public Builder setHyperthreading(
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      hyperthreading_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU hyper-threading support.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading hyperthreading = 8;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHyperthreading() {
      bitField0_ = (bitField0_ & ~0x00000080);
      hyperthreading_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.MachineArchitectureDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.MachineArchitectureDetails)
  private static final com.google.cloud.migrationcenter.v1.MachineArchitectureDetails
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.MachineArchitectureDetails();
  }

  public static com.google.cloud.migrationcenter.v1.MachineArchitectureDetails
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MachineArchitectureDetails> PARSER =
      new com.google.protobuf.AbstractParser<MachineArchitectureDetails>() {
        @java.lang.Override
        public MachineArchitectureDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MachineArchitectureDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MachineArchitectureDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
