/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Details of a machine.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.MachineDetails}
 */
public final class MachineDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.MachineDetails)
    MachineDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MachineDetails.newBuilder() to construct.
  private MachineDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MachineDetails() {
    uuid_ = "";
    machineName_ = "";
    powerState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MachineDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_MachineDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_MachineDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.MachineDetails.class,
            com.google.cloud.migrationcenter.v1.MachineDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Machine power state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.MachineDetails.PowerState}
   */
  public enum PowerState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Power state is unknown.
     * </pre>
     *
     * <code>POWER_STATE_UNSPECIFIED = 0;</code>
     */
    POWER_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The machine is preparing to enter the ACTIVE state. An instance may enter
     * the PENDING state when it launches for the first time, or when it is
     * started after being in the SUSPENDED state.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The machine is active.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The machine is being turned off.
     * </pre>
     *
     * <code>SUSPENDING = 3;</code>
     */
    SUSPENDING(3),
    /**
     *
     *
     * <pre>
     * The machine is off.
     * </pre>
     *
     * <code>SUSPENDED = 4;</code>
     */
    SUSPENDED(4),
    /**
     *
     *
     * <pre>
     * The machine is being deleted from the hosting platform.
     * </pre>
     *
     * <code>DELETING = 5;</code>
     */
    DELETING(5),
    /**
     *
     *
     * <pre>
     * The machine is deleted from the hosting platform.
     * </pre>
     *
     * <code>DELETED = 6;</code>
     */
    DELETED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Power state is unknown.
     * </pre>
     *
     * <code>POWER_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int POWER_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The machine is preparing to enter the ACTIVE state. An instance may enter
     * the PENDING state when it launches for the first time, or when it is
     * started after being in the SUSPENDED state.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The machine is active.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The machine is being turned off.
     * </pre>
     *
     * <code>SUSPENDING = 3;</code>
     */
    public static final int SUSPENDING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The machine is off.
     * </pre>
     *
     * <code>SUSPENDED = 4;</code>
     */
    public static final int SUSPENDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The machine is being deleted from the hosting platform.
     * </pre>
     *
     * <code>DELETING = 5;</code>
     */
    public static final int DELETING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The machine is deleted from the hosting platform.
     * </pre>
     *
     * <code>DELETED = 6;</code>
     */
    public static final int DELETED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PowerState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PowerState forNumber(int value) {
      switch (value) {
        case 0:
          return POWER_STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return ACTIVE;
        case 3:
          return SUSPENDING;
        case 4:
          return SUSPENDED;
        case 5:
          return DELETING;
        case 6:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PowerState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PowerState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PowerState>() {
          public PowerState findValueByNumber(int number) {
            return PowerState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MachineDetails.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PowerState[] VALUES = values();

    public static PowerState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PowerState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.MachineDetails.PowerState)
  }

  public static final int UUID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uuid_ = "";
  /**
   *
   *
   * <pre>
   * Machine unique identifier.
   * </pre>
   *
   * <code>string uuid = 1;</code>
   *
   * @return The uuid.
   */
  @java.lang.Override
  public java.lang.String getUuid() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Machine unique identifier.
   * </pre>
   *
   * <code>string uuid = 1;</code>
   *
   * @return The bytes for uuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUuidBytes() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineName_ = "";
  /**
   *
   *
   * <pre>
   * Machine name.
   * </pre>
   *
   * <code>string machine_name = 2;</code>
   *
   * @return The machineName.
   */
  @java.lang.Override
  public java.lang.String getMachineName() {
    java.lang.Object ref = machineName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Machine name.
   * </pre>
   *
   * <code>string machine_name = 2;</code>
   *
   * @return The bytes for machineName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineNameBytes() {
    java.lang.Object ref = machineName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Machine creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Machine creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Machine creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int CORE_COUNT_FIELD_NUMBER = 4;
  private int coreCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of CPU cores in the machine. Must be non-negative.
   * </pre>
   *
   * <code>int32 core_count = 4;</code>
   *
   * @return The coreCount.
   */
  @java.lang.Override
  public int getCoreCount() {
    return coreCount_;
  }

  public static final int MEMORY_MB_FIELD_NUMBER = 5;
  private int memoryMb_ = 0;
  /**
   *
   *
   * <pre>
   * The amount of memory in the machine. Must be non-negative.
   * </pre>
   *
   * <code>int32 memory_mb = 5;</code>
   *
   * @return The memoryMb.
   */
  @java.lang.Override
  public int getMemoryMb() {
    return memoryMb_;
  }

  public static final int POWER_STATE_FIELD_NUMBER = 6;
  private int powerState_ = 0;
  /**
   *
   *
   * <pre>
   * Power state of the machine.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
   *
   * @return The enum numeric value on the wire for powerState.
   */
  @java.lang.Override
  public int getPowerStateValue() {
    return powerState_;
  }
  /**
   *
   *
   * <pre>
   * Power state of the machine.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
   *
   * @return The powerState.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDetails.PowerState getPowerState() {
    com.google.cloud.migrationcenter.v1.MachineDetails.PowerState result =
        com.google.cloud.migrationcenter.v1.MachineDetails.PowerState.forNumber(powerState_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.MachineDetails.PowerState.UNRECOGNIZED
        : result;
  }

  public static final int ARCHITECTURE_FIELD_NUMBER = 7;
  private com.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture_;
  /**
   *
   *
   * <pre>
   * Architecture details (vendor, CPU architecture).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
   *
   * @return Whether the architecture field is set.
   */
  @java.lang.Override
  public boolean hasArchitecture() {
    return architecture_ != null;
  }
  /**
   *
   *
   * <pre>
   * Architecture details (vendor, CPU architecture).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
   *
   * @return The architecture.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails getArchitecture() {
    return architecture_ == null
        ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDefaultInstance()
        : architecture_;
  }
  /**
   *
   *
   * <pre>
   * Architecture details (vendor, CPU architecture).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineArchitectureDetailsOrBuilder
      getArchitectureOrBuilder() {
    return architecture_ == null
        ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDefaultInstance()
        : architecture_;
  }

  public static final int GUEST_OS_FIELD_NUMBER = 8;
  private com.google.cloud.migrationcenter.v1.GuestOsDetails guestOs_;
  /**
   *
   *
   * <pre>
   * Guest OS information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
   *
   * @return Whether the guestOs field is set.
   */
  @java.lang.Override
  public boolean hasGuestOs() {
    return guestOs_ != null;
  }
  /**
   *
   *
   * <pre>
   * Guest OS information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
   *
   * @return The guestOs.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestOsDetails getGuestOs() {
    return guestOs_ == null
        ? com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance()
        : guestOs_;
  }
  /**
   *
   *
   * <pre>
   * Guest OS information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestOsDetailsOrBuilder getGuestOsOrBuilder() {
    return guestOs_ == null
        ? com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance()
        : guestOs_;
  }

  public static final int NETWORK_FIELD_NUMBER = 9;
  private com.google.cloud.migrationcenter.v1.MachineNetworkDetails network_;
  /**
   *
   *
   * <pre>
   * Network details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return network_ != null;
  }
  /**
   *
   *
   * <pre>
   * Network details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineNetworkDetails getNetwork() {
    return network_ == null
        ? com.google.cloud.migrationcenter.v1.MachineNetworkDetails.getDefaultInstance()
        : network_;
  }
  /**
   *
   *
   * <pre>
   * Network details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineNetworkDetailsOrBuilder getNetworkOrBuilder() {
    return network_ == null
        ? com.google.cloud.migrationcenter.v1.MachineNetworkDetails.getDefaultInstance()
        : network_;
  }

  public static final int DISKS_FIELD_NUMBER = 10;
  private com.google.cloud.migrationcenter.v1.MachineDiskDetails disks_;
  /**
   *
   *
   * <pre>
   * Disk details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
   *
   * @return Whether the disks field is set.
   */
  @java.lang.Override
  public boolean hasDisks() {
    return disks_ != null;
  }
  /**
   *
   *
   * <pre>
   * Disk details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
   *
   * @return The disks.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDiskDetails getDisks() {
    return disks_ == null
        ? com.google.cloud.migrationcenter.v1.MachineDiskDetails.getDefaultInstance()
        : disks_;
  }
  /**
   *
   *
   * <pre>
   * Disk details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDiskDetailsOrBuilder getDisksOrBuilder() {
    return disks_ == null
        ? com.google.cloud.migrationcenter.v1.MachineDiskDetails.getDefaultInstance()
        : disks_;
  }

  public static final int PLATFORM_FIELD_NUMBER = 11;
  private com.google.cloud.migrationcenter.v1.PlatformDetails platform_;
  /**
   *
   *
   * <pre>
   * Platform specific information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
   *
   * @return Whether the platform field is set.
   */
  @java.lang.Override
  public boolean hasPlatform() {
    return platform_ != null;
  }
  /**
   *
   *
   * <pre>
   * Platform specific information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
   *
   * @return The platform.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PlatformDetails getPlatform() {
    return platform_ == null
        ? com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance()
        : platform_;
  }
  /**
   *
   *
   * <pre>
   * Platform specific information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PlatformDetailsOrBuilder getPlatformOrBuilder() {
    return platform_ == null
        ? com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance()
        : platform_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uuid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, machineName_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (coreCount_ != 0) {
      output.writeInt32(4, coreCount_);
    }
    if (memoryMb_ != 0) {
      output.writeInt32(5, memoryMb_);
    }
    if (powerState_
        != com.google.cloud.migrationcenter.v1.MachineDetails.PowerState.POWER_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, powerState_);
    }
    if (architecture_ != null) {
      output.writeMessage(7, getArchitecture());
    }
    if (guestOs_ != null) {
      output.writeMessage(8, getGuestOs());
    }
    if (network_ != null) {
      output.writeMessage(9, getNetwork());
    }
    if (disks_ != null) {
      output.writeMessage(10, getDisks());
    }
    if (platform_ != null) {
      output.writeMessage(11, getPlatform());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uuid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, machineName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (coreCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, coreCount_);
    }
    if (memoryMb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, memoryMb_);
    }
    if (powerState_
        != com.google.cloud.migrationcenter.v1.MachineDetails.PowerState.POWER_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, powerState_);
    }
    if (architecture_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getArchitecture());
    }
    if (guestOs_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getGuestOs());
    }
    if (network_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getNetwork());
    }
    if (disks_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDisks());
    }
    if (platform_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getPlatform());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.MachineDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.MachineDetails other =
        (com.google.cloud.migrationcenter.v1.MachineDetails) obj;

    if (!getUuid().equals(other.getUuid())) return false;
    if (!getMachineName().equals(other.getMachineName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getCoreCount() != other.getCoreCount()) return false;
    if (getMemoryMb() != other.getMemoryMb()) return false;
    if (powerState_ != other.powerState_) return false;
    if (hasArchitecture() != other.hasArchitecture()) return false;
    if (hasArchitecture()) {
      if (!getArchitecture().equals(other.getArchitecture())) return false;
    }
    if (hasGuestOs() != other.hasGuestOs()) return false;
    if (hasGuestOs()) {
      if (!getGuestOs().equals(other.getGuestOs())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasDisks() != other.hasDisks()) return false;
    if (hasDisks()) {
      if (!getDisks().equals(other.getDisks())) return false;
    }
    if (hasPlatform() != other.hasPlatform()) return false;
    if (hasPlatform()) {
      if (!getPlatform().equals(other.getPlatform())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + UUID_FIELD_NUMBER;
    hash = (53 * hash) + getUuid().hashCode();
    hash = (37 * hash) + MACHINE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMachineName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + CORE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCoreCount();
    hash = (37 * hash) + MEMORY_MB_FIELD_NUMBER;
    hash = (53 * hash) + getMemoryMb();
    hash = (37 * hash) + POWER_STATE_FIELD_NUMBER;
    hash = (53 * hash) + powerState_;
    if (hasArchitecture()) {
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
    }
    if (hasGuestOs()) {
      hash = (37 * hash) + GUEST_OS_FIELD_NUMBER;
      hash = (53 * hash) + getGuestOs().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasDisks()) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDisks().hashCode();
    }
    if (hasPlatform()) {
      hash = (37 * hash) + PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getPlatform().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.MachineDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of a machine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.MachineDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.MachineDetails)
      com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachineDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachineDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.MachineDetails.class,
              com.google.cloud.migrationcenter.v1.MachineDetails.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.MachineDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      uuid_ = "";
      machineName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      coreCount_ = 0;
      memoryMb_ = 0;
      powerState_ = 0;
      architecture_ = null;
      if (architectureBuilder_ != null) {
        architectureBuilder_.dispose();
        architectureBuilder_ = null;
      }
      guestOs_ = null;
      if (guestOsBuilder_ != null) {
        guestOsBuilder_.dispose();
        guestOsBuilder_ = null;
      }
      network_ = null;
      if (networkBuilder_ != null) {
        networkBuilder_.dispose();
        networkBuilder_ = null;
      }
      disks_ = null;
      if (disksBuilder_ != null) {
        disksBuilder_.dispose();
        disksBuilder_ = null;
      }
      platform_ = null;
      if (platformBuilder_ != null) {
        platformBuilder_.dispose();
        platformBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachineDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetails getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetails build() {
      com.google.cloud.migrationcenter.v1.MachineDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetails buildPartial() {
      com.google.cloud.migrationcenter.v1.MachineDetails result =
          new com.google.cloud.migrationcenter.v1.MachineDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.MachineDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.uuid_ = uuid_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.machineName_ = machineName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.coreCount_ = coreCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.memoryMb_ = memoryMb_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.powerState_ = powerState_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.architecture_ =
            architectureBuilder_ == null ? architecture_ : architectureBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.guestOs_ = guestOsBuilder_ == null ? guestOs_ : guestOsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.network_ = networkBuilder_ == null ? network_ : networkBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.disks_ = disksBuilder_ == null ? disks_ : disksBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.platform_ = platformBuilder_ == null ? platform_ : platformBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.MachineDetails) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.MachineDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.MachineDetails other) {
      if (other == com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance())
        return this;
      if (!other.getUuid().isEmpty()) {
        uuid_ = other.uuid_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMachineName().isEmpty()) {
        machineName_ = other.machineName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getCoreCount() != 0) {
        setCoreCount(other.getCoreCount());
      }
      if (other.getMemoryMb() != 0) {
        setMemoryMb(other.getMemoryMb());
      }
      if (other.powerState_ != 0) {
        setPowerStateValue(other.getPowerStateValue());
      }
      if (other.hasArchitecture()) {
        mergeArchitecture(other.getArchitecture());
      }
      if (other.hasGuestOs()) {
        mergeGuestOs(other.getGuestOs());
      }
      if (other.hasNetwork()) {
        mergeNetwork(other.getNetwork());
      }
      if (other.hasDisks()) {
        mergeDisks(other.getDisks());
      }
      if (other.hasPlatform()) {
        mergePlatform(other.getPlatform());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                uuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                machineName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                coreCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                memoryMb_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                powerState_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getArchitectureFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getGuestOsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getNetworkFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getDisksFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getPlatformFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object uuid_ = "";
    /**
     *
     *
     * <pre>
     * Machine unique identifier.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     *
     * @return The uuid.
     */
    public java.lang.String getUuid() {
      java.lang.Object ref = uuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine unique identifier.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     *
     * @return The bytes for uuid.
     */
    public com.google.protobuf.ByteString getUuidBytes() {
      java.lang.Object ref = uuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine unique identifier.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     *
     * @param value The uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uuid_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine unique identifier.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUuid() {
      uuid_ = getDefaultInstance().getUuid();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine unique identifier.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     *
     * @param value The bytes for uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uuid_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object machineName_ = "";
    /**
     *
     *
     * <pre>
     * Machine name.
     * </pre>
     *
     * <code>string machine_name = 2;</code>
     *
     * @return The machineName.
     */
    public java.lang.String getMachineName() {
      java.lang.Object ref = machineName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine name.
     * </pre>
     *
     * <code>string machine_name = 2;</code>
     *
     * @return The bytes for machineName.
     */
    public com.google.protobuf.ByteString getMachineNameBytes() {
      java.lang.Object ref = machineName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine name.
     * </pre>
     *
     * <code>string machine_name = 2;</code>
     *
     * @param value The machineName to set.
     * @return This builder for chaining.
     */
    public Builder setMachineName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine name.
     * </pre>
     *
     * <code>string machine_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineName() {
      machineName_ = getDefaultInstance().getMachineName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine name.
     * </pre>
     *
     * <code>string machine_name = 2;</code>
     *
     * @param value The bytes for machineName to set.
     * @return This builder for chaining.
     */
    public Builder setMachineNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine creation time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int coreCount_;
    /**
     *
     *
     * <pre>
     * Number of CPU cores in the machine. Must be non-negative.
     * </pre>
     *
     * <code>int32 core_count = 4;</code>
     *
     * @return The coreCount.
     */
    @java.lang.Override
    public int getCoreCount() {
      return coreCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of CPU cores in the machine. Must be non-negative.
     * </pre>
     *
     * <code>int32 core_count = 4;</code>
     *
     * @param value The coreCount to set.
     * @return This builder for chaining.
     */
    public Builder setCoreCount(int value) {

      coreCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of CPU cores in the machine. Must be non-negative.
     * </pre>
     *
     * <code>int32 core_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCoreCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      coreCount_ = 0;
      onChanged();
      return this;
    }

    private int memoryMb_;
    /**
     *
     *
     * <pre>
     * The amount of memory in the machine. Must be non-negative.
     * </pre>
     *
     * <code>int32 memory_mb = 5;</code>
     *
     * @return The memoryMb.
     */
    @java.lang.Override
    public int getMemoryMb() {
      return memoryMb_;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory in the machine. Must be non-negative.
     * </pre>
     *
     * <code>int32 memory_mb = 5;</code>
     *
     * @param value The memoryMb to set.
     * @return This builder for chaining.
     */
    public Builder setMemoryMb(int value) {

      memoryMb_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory in the machine. Must be non-negative.
     * </pre>
     *
     * <code>int32 memory_mb = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemoryMb() {
      bitField0_ = (bitField0_ & ~0x00000010);
      memoryMb_ = 0;
      onChanged();
      return this;
    }

    private int powerState_ = 0;
    /**
     *
     *
     * <pre>
     * Power state of the machine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
     *
     * @return The enum numeric value on the wire for powerState.
     */
    @java.lang.Override
    public int getPowerStateValue() {
      return powerState_;
    }
    /**
     *
     *
     * <pre>
     * Power state of the machine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
     *
     * @param value The enum numeric value on the wire for powerState to set.
     * @return This builder for chaining.
     */
    public Builder setPowerStateValue(int value) {
      powerState_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Power state of the machine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
     *
     * @return The powerState.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetails.PowerState getPowerState() {
      com.google.cloud.migrationcenter.v1.MachineDetails.PowerState result =
          com.google.cloud.migrationcenter.v1.MachineDetails.PowerState.forNumber(powerState_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.MachineDetails.PowerState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Power state of the machine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
     *
     * @param value The powerState to set.
     * @return This builder for chaining.
     */
    public Builder setPowerState(
        com.google.cloud.migrationcenter.v1.MachineDetails.PowerState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      powerState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Power state of the machine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails.PowerState power_state = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPowerState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      powerState_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetails,
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetailsOrBuilder>
        architectureBuilder_;
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     *
     * @return Whether the architecture field is set.
     */
    public boolean hasArchitecture() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     *
     * @return The architecture.
     */
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails getArchitecture() {
      if (architectureBuilder_ == null) {
        return architecture_ == null
            ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDefaultInstance()
            : architecture_;
      } else {
        return architectureBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    public Builder setArchitecture(
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails value) {
      if (architectureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        architecture_ = value;
      } else {
        architectureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    public Builder setArchitecture(
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder builderForValue) {
      if (architectureBuilder_ == null) {
        architecture_ = builderForValue.build();
      } else {
        architectureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    public Builder mergeArchitecture(
        com.google.cloud.migrationcenter.v1.MachineArchitectureDetails value) {
      if (architectureBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && architecture_ != null
            && architecture_
                != com.google.cloud.migrationcenter.v1.MachineArchitectureDetails
                    .getDefaultInstance()) {
          getArchitectureBuilder().mergeFrom(value);
        } else {
          architecture_ = value;
        }
      } else {
        architectureBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    public Builder clearArchitecture() {
      bitField0_ = (bitField0_ & ~0x00000040);
      architecture_ = null;
      if (architectureBuilder_ != null) {
        architectureBuilder_.dispose();
        architectureBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder
        getArchitectureBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getArchitectureFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineArchitectureDetailsOrBuilder
        getArchitectureOrBuilder() {
      if (architectureBuilder_ != null) {
        return architectureBuilder_.getMessageOrBuilder();
      } else {
        return architecture_ == null
            ? com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.getDefaultInstance()
            : architecture_;
      }
    }
    /**
     *
     *
     * <pre>
     * Architecture details (vendor, CPU architecture).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineArchitectureDetails architecture = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetails,
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineArchitectureDetailsOrBuilder>
        getArchitectureFieldBuilder() {
      if (architectureBuilder_ == null) {
        architectureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.MachineArchitectureDetails,
                com.google.cloud.migrationcenter.v1.MachineArchitectureDetails.Builder,
                com.google.cloud.migrationcenter.v1.MachineArchitectureDetailsOrBuilder>(
                getArchitecture(), getParentForChildren(), isClean());
        architecture_ = null;
      }
      return architectureBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.GuestOsDetails guestOs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GuestOsDetails,
            com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder,
            com.google.cloud.migrationcenter.v1.GuestOsDetailsOrBuilder>
        guestOsBuilder_;
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     *
     * @return Whether the guestOs field is set.
     */
    public boolean hasGuestOs() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     *
     * @return The guestOs.
     */
    public com.google.cloud.migrationcenter.v1.GuestOsDetails getGuestOs() {
      if (guestOsBuilder_ == null) {
        return guestOs_ == null
            ? com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance()
            : guestOs_;
      } else {
        return guestOsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    public Builder setGuestOs(com.google.cloud.migrationcenter.v1.GuestOsDetails value) {
      if (guestOsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        guestOs_ = value;
      } else {
        guestOsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    public Builder setGuestOs(
        com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder builderForValue) {
      if (guestOsBuilder_ == null) {
        guestOs_ = builderForValue.build();
      } else {
        guestOsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    public Builder mergeGuestOs(com.google.cloud.migrationcenter.v1.GuestOsDetails value) {
      if (guestOsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && guestOs_ != null
            && guestOs_
                != com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance()) {
          getGuestOsBuilder().mergeFrom(value);
        } else {
          guestOs_ = value;
        }
      } else {
        guestOsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    public Builder clearGuestOs() {
      bitField0_ = (bitField0_ & ~0x00000080);
      guestOs_ = null;
      if (guestOsBuilder_ != null) {
        guestOsBuilder_.dispose();
        guestOsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    public com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder getGuestOsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getGuestOsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    public com.google.cloud.migrationcenter.v1.GuestOsDetailsOrBuilder getGuestOsOrBuilder() {
      if (guestOsBuilder_ != null) {
        return guestOsBuilder_.getMessageOrBuilder();
      } else {
        return guestOs_ == null
            ? com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance()
            : guestOs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Guest OS information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestOsDetails guest_os = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GuestOsDetails,
            com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder,
            com.google.cloud.migrationcenter.v1.GuestOsDetailsOrBuilder>
        getGuestOsFieldBuilder() {
      if (guestOsBuilder_ == null) {
        guestOsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.GuestOsDetails,
                com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder,
                com.google.cloud.migrationcenter.v1.GuestOsDetailsOrBuilder>(
                getGuestOs(), getParentForChildren(), isClean());
        guestOs_ = null;
      }
      return guestOsBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.MachineNetworkDetails network_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineNetworkDetails,
            com.google.cloud.migrationcenter.v1.MachineNetworkDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineNetworkDetailsOrBuilder>
        networkBuilder_;
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     *
     * @return The network.
     */
    public com.google.cloud.migrationcenter.v1.MachineNetworkDetails getNetwork() {
      if (networkBuilder_ == null) {
        return network_ == null
            ? com.google.cloud.migrationcenter.v1.MachineNetworkDetails.getDefaultInstance()
            : network_;
      } else {
        return networkBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    public Builder setNetwork(com.google.cloud.migrationcenter.v1.MachineNetworkDetails value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        network_ = value;
      } else {
        networkBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    public Builder setNetwork(
        com.google.cloud.migrationcenter.v1.MachineNetworkDetails.Builder builderForValue) {
      if (networkBuilder_ == null) {
        network_ = builderForValue.build();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    public Builder mergeNetwork(com.google.cloud.migrationcenter.v1.MachineNetworkDetails value) {
      if (networkBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && network_ != null
            && network_
                != com.google.cloud.migrationcenter.v1.MachineNetworkDetails.getDefaultInstance()) {
          getNetworkBuilder().mergeFrom(value);
        } else {
          network_ = value;
        }
      } else {
        networkBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    public Builder clearNetwork() {
      bitField0_ = (bitField0_ & ~0x00000100);
      network_ = null;
      if (networkBuilder_ != null) {
        networkBuilder_.dispose();
        networkBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineNetworkDetails.Builder getNetworkBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getNetworkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineNetworkDetailsOrBuilder
        getNetworkOrBuilder() {
      if (networkBuilder_ != null) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        return network_ == null
            ? com.google.cloud.migrationcenter.v1.MachineNetworkDetails.getDefaultInstance()
            : network_;
      }
    }
    /**
     *
     *
     * <pre>
     * Network details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineNetworkDetails network = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineNetworkDetails,
            com.google.cloud.migrationcenter.v1.MachineNetworkDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineNetworkDetailsOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.MachineNetworkDetails,
                com.google.cloud.migrationcenter.v1.MachineNetworkDetails.Builder,
                com.google.cloud.migrationcenter.v1.MachineNetworkDetailsOrBuilder>(
                getNetwork(), getParentForChildren(), isClean());
        network_ = null;
      }
      return networkBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.MachineDiskDetails disks_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineDiskDetails,
            com.google.cloud.migrationcenter.v1.MachineDiskDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineDiskDetailsOrBuilder>
        disksBuilder_;
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     *
     * @return Whether the disks field is set.
     */
    public boolean hasDisks() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     *
     * @return The disks.
     */
    public com.google.cloud.migrationcenter.v1.MachineDiskDetails getDisks() {
      if (disksBuilder_ == null) {
        return disks_ == null
            ? com.google.cloud.migrationcenter.v1.MachineDiskDetails.getDefaultInstance()
            : disks_;
      } else {
        return disksBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    public Builder setDisks(com.google.cloud.migrationcenter.v1.MachineDiskDetails value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        disks_ = value;
      } else {
        disksBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    public Builder setDisks(
        com.google.cloud.migrationcenter.v1.MachineDiskDetails.Builder builderForValue) {
      if (disksBuilder_ == null) {
        disks_ = builderForValue.build();
      } else {
        disksBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    public Builder mergeDisks(com.google.cloud.migrationcenter.v1.MachineDiskDetails value) {
      if (disksBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && disks_ != null
            && disks_
                != com.google.cloud.migrationcenter.v1.MachineDiskDetails.getDefaultInstance()) {
          getDisksBuilder().mergeFrom(value);
        } else {
          disks_ = value;
        }
      } else {
        disksBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    public Builder clearDisks() {
      bitField0_ = (bitField0_ & ~0x00000200);
      disks_ = null;
      if (disksBuilder_ != null) {
        disksBuilder_.dispose();
        disksBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineDiskDetails.Builder getDisksBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDisksFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineDiskDetailsOrBuilder getDisksOrBuilder() {
      if (disksBuilder_ != null) {
        return disksBuilder_.getMessageOrBuilder();
      } else {
        return disks_ == null
            ? com.google.cloud.migrationcenter.v1.MachineDiskDetails.getDefaultInstance()
            : disks_;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDiskDetails disks = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineDiskDetails,
            com.google.cloud.migrationcenter.v1.MachineDiskDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineDiskDetailsOrBuilder>
        getDisksFieldBuilder() {
      if (disksBuilder_ == null) {
        disksBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.MachineDiskDetails,
                com.google.cloud.migrationcenter.v1.MachineDiskDetails.Builder,
                com.google.cloud.migrationcenter.v1.MachineDiskDetailsOrBuilder>(
                getDisks(), getParentForChildren(), isClean());
        disks_ = null;
      }
      return disksBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.PlatformDetails platform_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PlatformDetails,
            com.google.cloud.migrationcenter.v1.PlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.PlatformDetailsOrBuilder>
        platformBuilder_;
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     *
     * @return Whether the platform field is set.
     */
    public boolean hasPlatform() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     *
     * @return The platform.
     */
    public com.google.cloud.migrationcenter.v1.PlatformDetails getPlatform() {
      if (platformBuilder_ == null) {
        return platform_ == null
            ? com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance()
            : platform_;
      } else {
        return platformBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    public Builder setPlatform(com.google.cloud.migrationcenter.v1.PlatformDetails value) {
      if (platformBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platform_ = value;
      } else {
        platformBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    public Builder setPlatform(
        com.google.cloud.migrationcenter.v1.PlatformDetails.Builder builderForValue) {
      if (platformBuilder_ == null) {
        platform_ = builderForValue.build();
      } else {
        platformBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    public Builder mergePlatform(com.google.cloud.migrationcenter.v1.PlatformDetails value) {
      if (platformBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && platform_ != null
            && platform_
                != com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance()) {
          getPlatformBuilder().mergeFrom(value);
        } else {
          platform_ = value;
        }
      } else {
        platformBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    public Builder clearPlatform() {
      bitField0_ = (bitField0_ & ~0x00000400);
      platform_ = null;
      if (platformBuilder_ != null) {
        platformBuilder_.dispose();
        platformBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    public com.google.cloud.migrationcenter.v1.PlatformDetails.Builder getPlatformBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getPlatformFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    public com.google.cloud.migrationcenter.v1.PlatformDetailsOrBuilder getPlatformOrBuilder() {
      if (platformBuilder_ != null) {
        return platformBuilder_.getMessageOrBuilder();
      } else {
        return platform_ == null
            ? com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance()
            : platform_;
      }
    }
    /**
     *
     *
     * <pre>
     * Platform specific information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PlatformDetails platform = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PlatformDetails,
            com.google.cloud.migrationcenter.v1.PlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.PlatformDetailsOrBuilder>
        getPlatformFieldBuilder() {
      if (platformBuilder_ == null) {
        platformBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.PlatformDetails,
                com.google.cloud.migrationcenter.v1.PlatformDetails.Builder,
                com.google.cloud.migrationcenter.v1.PlatformDetailsOrBuilder>(
                getPlatform(), getParentForChildren(), isClean());
        platform_ = null;
      }
      return platformBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.MachineDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.MachineDetails)
  private static final com.google.cloud.migrationcenter.v1.MachineDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.MachineDetails();
  }

  public static com.google.cloud.migrationcenter.v1.MachineDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MachineDetails> PARSER =
      new com.google.protobuf.AbstractParser<MachineDetails>() {
        @java.lang.Override
        public MachineDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MachineDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MachineDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
