/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * The type of machines to consider when calculating virtual machine migration
 * insights and recommendations.
 * Not all machine types are available in all zones and regions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.MachinePreferences}
 */
public final class MachinePreferences extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.MachinePreferences)
    MachinePreferencesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MachinePreferences.newBuilder() to construct.
  private MachinePreferences(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MachinePreferences() {
    allowedMachineSeries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MachinePreferences();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_MachinePreferences_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_MachinePreferences_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.MachinePreferences.class,
            com.google.cloud.migrationcenter.v1.MachinePreferences.Builder.class);
  }

  public static final int ALLOWED_MACHINE_SERIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.MachineSeries> allowedMachineSeries_;
  /**
   *
   *
   * <pre>
   * Compute Engine machine series to consider for insights and recommendations.
   * If empty, no restriction is applied on the machine series.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.MachineSeries>
      getAllowedMachineSeriesList() {
    return allowedMachineSeries_;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine series to consider for insights and recommendations.
   * If empty, no restriction is applied on the machine series.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>
      getAllowedMachineSeriesOrBuilderList() {
    return allowedMachineSeries_;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine series to consider for insights and recommendations.
   * If empty, no restriction is applied on the machine series.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
   * </code>
   */
  @java.lang.Override
  public int getAllowedMachineSeriesCount() {
    return allowedMachineSeries_.size();
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine series to consider for insights and recommendations.
   * If empty, no restriction is applied on the machine series.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineSeries getAllowedMachineSeries(int index) {
    return allowedMachineSeries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine series to consider for insights and recommendations.
   * If empty, no restriction is applied on the machine series.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder
      getAllowedMachineSeriesOrBuilder(int index) {
    return allowedMachineSeries_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < allowedMachineSeries_.size(); i++) {
      output.writeMessage(1, allowedMachineSeries_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < allowedMachineSeries_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, allowedMachineSeries_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.MachinePreferences)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.MachinePreferences other =
        (com.google.cloud.migrationcenter.v1.MachinePreferences) obj;

    if (!getAllowedMachineSeriesList().equals(other.getAllowedMachineSeriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedMachineSeriesCount() > 0) {
      hash = (37 * hash) + ALLOWED_MACHINE_SERIES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedMachineSeriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.MachinePreferences prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The type of machines to consider when calculating virtual machine migration
   * insights and recommendations.
   * Not all machine types are available in all zones and regions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.MachinePreferences}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.MachinePreferences)
      com.google.cloud.migrationcenter.v1.MachinePreferencesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachinePreferences_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachinePreferences_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.MachinePreferences.class,
              com.google.cloud.migrationcenter.v1.MachinePreferences.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.MachinePreferences.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (allowedMachineSeriesBuilder_ == null) {
        allowedMachineSeries_ = java.util.Collections.emptyList();
      } else {
        allowedMachineSeries_ = null;
        allowedMachineSeriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_MachinePreferences_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachinePreferences getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.MachinePreferences.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachinePreferences build() {
      com.google.cloud.migrationcenter.v1.MachinePreferences result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachinePreferences buildPartial() {
      com.google.cloud.migrationcenter.v1.MachinePreferences result =
          new com.google.cloud.migrationcenter.v1.MachinePreferences(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.MachinePreferences result) {
      if (allowedMachineSeriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          allowedMachineSeries_ = java.util.Collections.unmodifiableList(allowedMachineSeries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.allowedMachineSeries_ = allowedMachineSeries_;
      } else {
        result.allowedMachineSeries_ = allowedMachineSeriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.MachinePreferences result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.MachinePreferences) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.MachinePreferences) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.MachinePreferences other) {
      if (other == com.google.cloud.migrationcenter.v1.MachinePreferences.getDefaultInstance())
        return this;
      if (allowedMachineSeriesBuilder_ == null) {
        if (!other.allowedMachineSeries_.isEmpty()) {
          if (allowedMachineSeries_.isEmpty()) {
            allowedMachineSeries_ = other.allowedMachineSeries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAllowedMachineSeriesIsMutable();
            allowedMachineSeries_.addAll(other.allowedMachineSeries_);
          }
          onChanged();
        }
      } else {
        if (!other.allowedMachineSeries_.isEmpty()) {
          if (allowedMachineSeriesBuilder_.isEmpty()) {
            allowedMachineSeriesBuilder_.dispose();
            allowedMachineSeriesBuilder_ = null;
            allowedMachineSeries_ = other.allowedMachineSeries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            allowedMachineSeriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAllowedMachineSeriesFieldBuilder()
                    : null;
          } else {
            allowedMachineSeriesBuilder_.addAllMessages(other.allowedMachineSeries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.migrationcenter.v1.MachineSeries m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.MachineSeries.parser(),
                        extensionRegistry);
                if (allowedMachineSeriesBuilder_ == null) {
                  ensureAllowedMachineSeriesIsMutable();
                  allowedMachineSeries_.add(m);
                } else {
                  allowedMachineSeriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.migrationcenter.v1.MachineSeries>
        allowedMachineSeries_ = java.util.Collections.emptyList();

    private void ensureAllowedMachineSeriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedMachineSeries_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.MachineSeries>(
                allowedMachineSeries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineSeries,
            com.google.cloud.migrationcenter.v1.MachineSeries.Builder,
            com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>
        allowedMachineSeriesBuilder_;

    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.MachineSeries>
        getAllowedMachineSeriesList() {
      if (allowedMachineSeriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(allowedMachineSeries_);
      } else {
        return allowedMachineSeriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public int getAllowedMachineSeriesCount() {
      if (allowedMachineSeriesBuilder_ == null) {
        return allowedMachineSeries_.size();
      } else {
        return allowedMachineSeriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.MachineSeries getAllowedMachineSeries(int index) {
      if (allowedMachineSeriesBuilder_ == null) {
        return allowedMachineSeries_.get(index);
      } else {
        return allowedMachineSeriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder setAllowedMachineSeries(
        int index, com.google.cloud.migrationcenter.v1.MachineSeries value) {
      if (allowedMachineSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.set(index, value);
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder setAllowedMachineSeries(
        int index, com.google.cloud.migrationcenter.v1.MachineSeries.Builder builderForValue) {
      if (allowedMachineSeriesBuilder_ == null) {
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.set(index, builderForValue.build());
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder addAllowedMachineSeries(
        com.google.cloud.migrationcenter.v1.MachineSeries value) {
      if (allowedMachineSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.add(value);
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder addAllowedMachineSeries(
        int index, com.google.cloud.migrationcenter.v1.MachineSeries value) {
      if (allowedMachineSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.add(index, value);
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder addAllowedMachineSeries(
        com.google.cloud.migrationcenter.v1.MachineSeries.Builder builderForValue) {
      if (allowedMachineSeriesBuilder_ == null) {
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.add(builderForValue.build());
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder addAllowedMachineSeries(
        int index, com.google.cloud.migrationcenter.v1.MachineSeries.Builder builderForValue) {
      if (allowedMachineSeriesBuilder_ == null) {
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.add(index, builderForValue.build());
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder addAllAllowedMachineSeries(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.MachineSeries> values) {
      if (allowedMachineSeriesBuilder_ == null) {
        ensureAllowedMachineSeriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedMachineSeries_);
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder clearAllowedMachineSeries() {
      if (allowedMachineSeriesBuilder_ == null) {
        allowedMachineSeries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public Builder removeAllowedMachineSeries(int index) {
      if (allowedMachineSeriesBuilder_ == null) {
        ensureAllowedMachineSeriesIsMutable();
        allowedMachineSeries_.remove(index);
        onChanged();
      } else {
        allowedMachineSeriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.MachineSeries.Builder getAllowedMachineSeriesBuilder(
        int index) {
      return getAllowedMachineSeriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder
        getAllowedMachineSeriesOrBuilder(int index) {
      if (allowedMachineSeriesBuilder_ == null) {
        return allowedMachineSeries_.get(index);
      } else {
        return allowedMachineSeriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>
        getAllowedMachineSeriesOrBuilderList() {
      if (allowedMachineSeriesBuilder_ != null) {
        return allowedMachineSeriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(allowedMachineSeries_);
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.MachineSeries.Builder
        addAllowedMachineSeriesBuilder() {
      return getAllowedMachineSeriesFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.MachineSeries.Builder addAllowedMachineSeriesBuilder(
        int index) {
      return getAllowedMachineSeriesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series to consider for insights and recommendations.
     * If empty, no restriction is applied on the machine series.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.MachineSeries allowed_machine_series = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.MachineSeries.Builder>
        getAllowedMachineSeriesBuilderList() {
      return getAllowedMachineSeriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineSeries,
            com.google.cloud.migrationcenter.v1.MachineSeries.Builder,
            com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>
        getAllowedMachineSeriesFieldBuilder() {
      if (allowedMachineSeriesBuilder_ == null) {
        allowedMachineSeriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.MachineSeries,
                com.google.cloud.migrationcenter.v1.MachineSeries.Builder,
                com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>(
                allowedMachineSeries_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        allowedMachineSeries_ = null;
      }
      return allowedMachineSeriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.MachinePreferences)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.MachinePreferences)
  private static final com.google.cloud.migrationcenter.v1.MachinePreferences DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.MachinePreferences();
  }

  public static com.google.cloud.migrationcenter.v1.MachinePreferences getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MachinePreferences> PARSER =
      new com.google.protobuf.AbstractParser<MachinePreferences>() {
        @java.lang.Override
        public MachinePreferences parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MachinePreferences> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MachinePreferences> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachinePreferences getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
