/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Details of network address.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.NetworkAddress}
 */
public final class NetworkAddress extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.NetworkAddress)
    NetworkAddressOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkAddress.newBuilder() to construct.
  private NetworkAddress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkAddress() {
    ipAddress_ = "";
    subnetMask_ = "";
    bcast_ = "";
    fqdn_ = "";
    assignment_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkAddress();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_NetworkAddress_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_NetworkAddress_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.NetworkAddress.class,
            com.google.cloud.migrationcenter.v1.NetworkAddress.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Network address assignment.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment}
   */
  public enum AddressAssignment implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown (default value).
     * </pre>
     *
     * <code>ADDRESS_ASSIGNMENT_UNSPECIFIED = 0;</code>
     */
    ADDRESS_ASSIGNMENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Staticly assigned IP.
     * </pre>
     *
     * <code>ADDRESS_ASSIGNMENT_STATIC = 1;</code>
     */
    ADDRESS_ASSIGNMENT_STATIC(1),
    /**
     *
     *
     * <pre>
     * Dynamically assigned IP (DHCP).
     * </pre>
     *
     * <code>ADDRESS_ASSIGNMENT_DHCP = 2;</code>
     */
    ADDRESS_ASSIGNMENT_DHCP(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown (default value).
     * </pre>
     *
     * <code>ADDRESS_ASSIGNMENT_UNSPECIFIED = 0;</code>
     */
    public static final int ADDRESS_ASSIGNMENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Staticly assigned IP.
     * </pre>
     *
     * <code>ADDRESS_ASSIGNMENT_STATIC = 1;</code>
     */
    public static final int ADDRESS_ASSIGNMENT_STATIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Dynamically assigned IP (DHCP).
     * </pre>
     *
     * <code>ADDRESS_ASSIGNMENT_DHCP = 2;</code>
     */
    public static final int ADDRESS_ASSIGNMENT_DHCP_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AddressAssignment valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AddressAssignment forNumber(int value) {
      switch (value) {
        case 0:
          return ADDRESS_ASSIGNMENT_UNSPECIFIED;
        case 1:
          return ADDRESS_ASSIGNMENT_STATIC;
        case 2:
          return ADDRESS_ASSIGNMENT_DHCP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AddressAssignment>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AddressAssignment>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AddressAssignment>() {
              public AddressAssignment findValueByNumber(int number) {
                return AddressAssignment.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.NetworkAddress.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AddressAssignment[] VALUES = values();

    public static AddressAssignment valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AddressAssignment(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment)
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipAddress_ = "";
  /**
   *
   *
   * <pre>
   * Assigned or configured IP Address.
   * </pre>
   *
   * <code>string ip_address = 1;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Assigned or configured IP Address.
   * </pre>
   *
   * <code>string ip_address = 1;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNET_MASK_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetMask_ = "";
  /**
   *
   *
   * <pre>
   * Subnet mask.
   * </pre>
   *
   * <code>string subnet_mask = 2;</code>
   *
   * @return The subnetMask.
   */
  @java.lang.Override
  public java.lang.String getSubnetMask() {
    java.lang.Object ref = subnetMask_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetMask_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Subnet mask.
   * </pre>
   *
   * <code>string subnet_mask = 2;</code>
   *
   * @return The bytes for subnetMask.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetMaskBytes() {
    java.lang.Object ref = subnetMask_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetMask_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BCAST_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bcast_ = "";
  /**
   *
   *
   * <pre>
   * Broadcast address.
   * </pre>
   *
   * <code>string bcast = 3;</code>
   *
   * @return The bcast.
   */
  @java.lang.Override
  public java.lang.String getBcast() {
    java.lang.Object ref = bcast_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bcast_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Broadcast address.
   * </pre>
   *
   * <code>string bcast = 3;</code>
   *
   * @return The bytes for bcast.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBcastBytes() {
    java.lang.Object ref = bcast_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bcast_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FQDN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fqdn_ = "";
  /**
   *
   *
   * <pre>
   * Fully qualified domain name.
   * </pre>
   *
   * <code>string fqdn = 4;</code>
   *
   * @return The fqdn.
   */
  @java.lang.Override
  public java.lang.String getFqdn() {
    java.lang.Object ref = fqdn_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fqdn_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fully qualified domain name.
   * </pre>
   *
   * <code>string fqdn = 4;</code>
   *
   * @return The bytes for fqdn.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFqdnBytes() {
    java.lang.Object ref = fqdn_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fqdn_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSIGNMENT_FIELD_NUMBER = 5;
  private int assignment_ = 0;
  /**
   *
   *
   * <pre>
   * Whether DHCP is used to assign addresses.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;</code>
   *
   * @return The enum numeric value on the wire for assignment.
   */
  @java.lang.Override
  public int getAssignmentValue() {
    return assignment_;
  }
  /**
   *
   *
   * <pre>
   * Whether DHCP is used to assign addresses.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;</code>
   *
   * @return The assignment.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment getAssignment() {
    com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment result =
        com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment.forNumber(assignment_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ipAddress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetMask_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subnetMask_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bcast_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, bcast_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fqdn_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fqdn_);
    }
    if (assignment_
        != com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment
            .ADDRESS_ASSIGNMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, assignment_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ipAddress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetMask_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subnetMask_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bcast_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, bcast_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fqdn_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fqdn_);
    }
    if (assignment_
        != com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment
            .ADDRESS_ASSIGNMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, assignment_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.NetworkAddress)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.NetworkAddress other =
        (com.google.cloud.migrationcenter.v1.NetworkAddress) obj;

    if (!getIpAddress().equals(other.getIpAddress())) return false;
    if (!getSubnetMask().equals(other.getSubnetMask())) return false;
    if (!getBcast().equals(other.getBcast())) return false;
    if (!getFqdn().equals(other.getFqdn())) return false;
    if (assignment_ != other.assignment_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getIpAddress().hashCode();
    hash = (37 * hash) + SUBNET_MASK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetMask().hashCode();
    hash = (37 * hash) + BCAST_FIELD_NUMBER;
    hash = (53 * hash) + getBcast().hashCode();
    hash = (37 * hash) + FQDN_FIELD_NUMBER;
    hash = (53 * hash) + getFqdn().hashCode();
    hash = (37 * hash) + ASSIGNMENT_FIELD_NUMBER;
    hash = (53 * hash) + assignment_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.NetworkAddress prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of network address.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.NetworkAddress}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.NetworkAddress)
      com.google.cloud.migrationcenter.v1.NetworkAddressOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_NetworkAddress_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_NetworkAddress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.NetworkAddress.class,
              com.google.cloud.migrationcenter.v1.NetworkAddress.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.NetworkAddress.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ipAddress_ = "";
      subnetMask_ = "";
      bcast_ = "";
      fqdn_ = "";
      assignment_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_NetworkAddress_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkAddress getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.NetworkAddress.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkAddress build() {
      com.google.cloud.migrationcenter.v1.NetworkAddress result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkAddress buildPartial() {
      com.google.cloud.migrationcenter.v1.NetworkAddress result =
          new com.google.cloud.migrationcenter.v1.NetworkAddress(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.NetworkAddress result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ipAddress_ = ipAddress_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.subnetMask_ = subnetMask_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bcast_ = bcast_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fqdn_ = fqdn_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.assignment_ = assignment_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.NetworkAddress) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.NetworkAddress) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.NetworkAddress other) {
      if (other == com.google.cloud.migrationcenter.v1.NetworkAddress.getDefaultInstance())
        return this;
      if (!other.getIpAddress().isEmpty()) {
        ipAddress_ = other.ipAddress_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSubnetMask().isEmpty()) {
        subnetMask_ = other.subnetMask_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getBcast().isEmpty()) {
        bcast_ = other.bcast_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFqdn().isEmpty()) {
        fqdn_ = other.fqdn_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.assignment_ != 0) {
        setAssignmentValue(other.getAssignmentValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                ipAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                subnetMask_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                bcast_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                fqdn_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                assignment_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object ipAddress_ = "";
    /**
     *
     *
     * <pre>
     * Assigned or configured IP Address.
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Assigned or configured IP Address.
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Assigned or configured IP Address.
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assigned or configured IP Address.
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {
      ipAddress_ = getDefaultInstance().getIpAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assigned or configured IP Address.
     * </pre>
     *
     * <code>string ip_address = 1;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object subnetMask_ = "";
    /**
     *
     *
     * <pre>
     * Subnet mask.
     * </pre>
     *
     * <code>string subnet_mask = 2;</code>
     *
     * @return The subnetMask.
     */
    public java.lang.String getSubnetMask() {
      java.lang.Object ref = subnetMask_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetMask_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnet mask.
     * </pre>
     *
     * <code>string subnet_mask = 2;</code>
     *
     * @return The bytes for subnetMask.
     */
    public com.google.protobuf.ByteString getSubnetMaskBytes() {
      java.lang.Object ref = subnetMask_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetMask_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnet mask.
     * </pre>
     *
     * <code>string subnet_mask = 2;</code>
     *
     * @param value The subnetMask to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetMask(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetMask_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Subnet mask.
     * </pre>
     *
     * <code>string subnet_mask = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetMask() {
      subnetMask_ = getDefaultInstance().getSubnetMask();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Subnet mask.
     * </pre>
     *
     * <code>string subnet_mask = 2;</code>
     *
     * @param value The bytes for subnetMask to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetMaskBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetMask_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object bcast_ = "";
    /**
     *
     *
     * <pre>
     * Broadcast address.
     * </pre>
     *
     * <code>string bcast = 3;</code>
     *
     * @return The bcast.
     */
    public java.lang.String getBcast() {
      java.lang.Object ref = bcast_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bcast_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Broadcast address.
     * </pre>
     *
     * <code>string bcast = 3;</code>
     *
     * @return The bytes for bcast.
     */
    public com.google.protobuf.ByteString getBcastBytes() {
      java.lang.Object ref = bcast_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bcast_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Broadcast address.
     * </pre>
     *
     * <code>string bcast = 3;</code>
     *
     * @param value The bcast to set.
     * @return This builder for chaining.
     */
    public Builder setBcast(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bcast_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Broadcast address.
     * </pre>
     *
     * <code>string bcast = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBcast() {
      bcast_ = getDefaultInstance().getBcast();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Broadcast address.
     * </pre>
     *
     * <code>string bcast = 3;</code>
     *
     * @param value The bytes for bcast to set.
     * @return This builder for chaining.
     */
    public Builder setBcastBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bcast_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object fqdn_ = "";
    /**
     *
     *
     * <pre>
     * Fully qualified domain name.
     * </pre>
     *
     * <code>string fqdn = 4;</code>
     *
     * @return The fqdn.
     */
    public java.lang.String getFqdn() {
      java.lang.Object ref = fqdn_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fqdn_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified domain name.
     * </pre>
     *
     * <code>string fqdn = 4;</code>
     *
     * @return The bytes for fqdn.
     */
    public com.google.protobuf.ByteString getFqdnBytes() {
      java.lang.Object ref = fqdn_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fqdn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified domain name.
     * </pre>
     *
     * <code>string fqdn = 4;</code>
     *
     * @param value The fqdn to set.
     * @return This builder for chaining.
     */
    public Builder setFqdn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fqdn_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified domain name.
     * </pre>
     *
     * <code>string fqdn = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFqdn() {
      fqdn_ = getDefaultInstance().getFqdn();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified domain name.
     * </pre>
     *
     * <code>string fqdn = 4;</code>
     *
     * @param value The bytes for fqdn to set.
     * @return This builder for chaining.
     */
    public Builder setFqdnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fqdn_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int assignment_ = 0;
    /**
     *
     *
     * <pre>
     * Whether DHCP is used to assign addresses.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for assignment.
     */
    @java.lang.Override
    public int getAssignmentValue() {
      return assignment_;
    }
    /**
     *
     *
     * <pre>
     * Whether DHCP is used to assign addresses.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for assignment to set.
     * @return This builder for chaining.
     */
    public Builder setAssignmentValue(int value) {
      assignment_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether DHCP is used to assign addresses.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;
     * </code>
     *
     * @return The assignment.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment getAssignment() {
      com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment result =
          com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment.forNumber(
              assignment_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Whether DHCP is used to assign addresses.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;
     * </code>
     *
     * @param value The assignment to set.
     * @return This builder for chaining.
     */
    public Builder setAssignment(
        com.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      assignment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether DHCP is used to assign addresses.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment assignment = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssignment() {
      bitField0_ = (bitField0_ & ~0x00000010);
      assignment_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.NetworkAddress)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.NetworkAddress)
  private static final com.google.cloud.migrationcenter.v1.NetworkAddress DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.NetworkAddress();
  }

  public static com.google.cloud.migrationcenter.v1.NetworkAddress getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkAddress> PARSER =
      new com.google.protobuf.AbstractParser<NetworkAddress>() {
        @java.lang.Override
        public NetworkAddress parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkAddress> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkAddress> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.NetworkAddress getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
