/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/** Protobuf type {@code google.cloud.migrationcenter.v1.NetworkConnection} */
public final class NetworkConnection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.NetworkConnection)
    NetworkConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkConnection.newBuilder() to construct.
  private NetworkConnection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkConnection() {
    protocol_ = "";
    localIpAddress_ = "";
    remoteIpAddress_ = "";
    state_ = 0;
    processName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkConnection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_NetworkConnection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_NetworkConnection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.NetworkConnection.class,
            com.google.cloud.migrationcenter.v1.NetworkConnection.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Network connection state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.NetworkConnection.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Connection state is unknown or unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The connection is being opened.
     * </pre>
     *
     * <code>OPENING = 1;</code>
     */
    OPENING(1),
    /**
     *
     *
     * <pre>
     * The connection is open.
     * </pre>
     *
     * <code>OPEN = 2;</code>
     */
    OPEN(2),
    /**
     *
     *
     * <pre>
     * Listening for incoming connections.
     * </pre>
     *
     * <code>LISTEN = 3;</code>
     */
    LISTEN(3),
    /**
     *
     *
     * <pre>
     * The connection is being closed.
     * </pre>
     *
     * <code>CLOSING = 4;</code>
     */
    CLOSING(4),
    /**
     *
     *
     * <pre>
     * The connection is closed.
     * </pre>
     *
     * <code>CLOSED = 5;</code>
     */
    CLOSED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Connection state is unknown or unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The connection is being opened.
     * </pre>
     *
     * <code>OPENING = 1;</code>
     */
    public static final int OPENING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The connection is open.
     * </pre>
     *
     * <code>OPEN = 2;</code>
     */
    public static final int OPEN_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Listening for incoming connections.
     * </pre>
     *
     * <code>LISTEN = 3;</code>
     */
    public static final int LISTEN_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The connection is being closed.
     * </pre>
     *
     * <code>CLOSING = 4;</code>
     */
    public static final int CLOSING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The connection is closed.
     * </pre>
     *
     * <code>CLOSED = 5;</code>
     */
    public static final int CLOSED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return OPENING;
        case 2:
          return OPEN;
        case 3:
          return LISTEN;
        case 4:
          return CLOSING;
        case 5:
          return CLOSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.NetworkConnection.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.NetworkConnection.State)
  }

  public static final int PROTOCOL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protocol_ = "";
  /**
   *
   *
   * <pre>
   * Connection protocol (e.g. TCP/UDP).
   * </pre>
   *
   * <code>string protocol = 1;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Connection protocol (e.g. TCP/UDP).
   * </pre>
   *
   * <code>string protocol = 1;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_IP_ADDRESS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object localIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * Local IP address.
   * </pre>
   *
   * <code>string local_ip_address = 2;</code>
   *
   * @return The localIpAddress.
   */
  @java.lang.Override
  public java.lang.String getLocalIpAddress() {
    java.lang.Object ref = localIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      localIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Local IP address.
   * </pre>
   *
   * <code>string local_ip_address = 2;</code>
   *
   * @return The bytes for localIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocalIpAddressBytes() {
    java.lang.Object ref = localIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      localIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_PORT_FIELD_NUMBER = 3;
  private int localPort_ = 0;
  /**
   *
   *
   * <pre>
   * Local port.
   * </pre>
   *
   * <code>int32 local_port = 3;</code>
   *
   * @return The localPort.
   */
  @java.lang.Override
  public int getLocalPort() {
    return localPort_;
  }

  public static final int REMOTE_IP_ADDRESS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * Remote IP address.
   * </pre>
   *
   * <code>string remote_ip_address = 4;</code>
   *
   * @return The remoteIpAddress.
   */
  @java.lang.Override
  public java.lang.String getRemoteIpAddress() {
    java.lang.Object ref = remoteIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Remote IP address.
   * </pre>
   *
   * <code>string remote_ip_address = 4;</code>
   *
   * @return The bytes for remoteIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRemoteIpAddressBytes() {
    java.lang.Object ref = remoteIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_PORT_FIELD_NUMBER = 5;
  private int remotePort_ = 0;
  /**
   *
   *
   * <pre>
   * Remote port.
   * </pre>
   *
   * <code>int32 remote_port = 5;</code>
   *
   * @return The remotePort.
   */
  @java.lang.Override
  public int getRemotePort() {
    return remotePort_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Network connection state.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Network connection state.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.NetworkConnection.State getState() {
    com.google.cloud.migrationcenter.v1.NetworkConnection.State result =
        com.google.cloud.migrationcenter.v1.NetworkConnection.State.forNumber(state_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.NetworkConnection.State.UNRECOGNIZED
        : result;
  }

  public static final int PID_FIELD_NUMBER = 7;
  private long pid_ = 0L;
  /**
   *
   *
   * <pre>
   * Process ID.
   * </pre>
   *
   * <code>int64 pid = 7;</code>
   *
   * @return The pid.
   */
  @java.lang.Override
  public long getPid() {
    return pid_;
  }

  public static final int PROCESS_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object processName_ = "";
  /**
   *
   *
   * <pre>
   * Process or service name.
   * </pre>
   *
   * <code>string process_name = 8;</code>
   *
   * @return The processName.
   */
  @java.lang.Override
  public java.lang.String getProcessName() {
    java.lang.Object ref = processName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      processName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Process or service name.
   * </pre>
   *
   * <code>string process_name = 8;</code>
   *
   * @return The bytes for processName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProcessNameBytes() {
    java.lang.Object ref = processName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      processName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, protocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(localIpAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, localIpAddress_);
    }
    if (localPort_ != 0) {
      output.writeInt32(3, localPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteIpAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, remoteIpAddress_);
    }
    if (remotePort_ != 0) {
      output.writeInt32(5, remotePort_);
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.NetworkConnection.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, state_);
    }
    if (pid_ != 0L) {
      output.writeInt64(7, pid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, processName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, protocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(localIpAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, localIpAddress_);
    }
    if (localPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, localPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteIpAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, remoteIpAddress_);
    }
    if (remotePort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, remotePort_);
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.NetworkConnection.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (pid_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, pid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, processName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.NetworkConnection)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.NetworkConnection other =
        (com.google.cloud.migrationcenter.v1.NetworkConnection) obj;

    if (!getProtocol().equals(other.getProtocol())) return false;
    if (!getLocalIpAddress().equals(other.getLocalIpAddress())) return false;
    if (getLocalPort() != other.getLocalPort()) return false;
    if (!getRemoteIpAddress().equals(other.getRemoteIpAddress())) return false;
    if (getRemotePort() != other.getRemotePort()) return false;
    if (state_ != other.state_) return false;
    if (getPid() != other.getPid()) return false;
    if (!getProcessName().equals(other.getProcessName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    hash = (37 * hash) + LOCAL_IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getLocalIpAddress().hashCode();
    hash = (37 * hash) + LOCAL_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getLocalPort();
    hash = (37 * hash) + REMOTE_IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getRemoteIpAddress().hashCode();
    hash = (37 * hash) + REMOTE_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getRemotePort();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + PID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPid());
    hash = (37 * hash) + PROCESS_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getProcessName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.NetworkConnection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.migrationcenter.v1.NetworkConnection} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.NetworkConnection)
      com.google.cloud.migrationcenter.v1.NetworkConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_NetworkConnection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_NetworkConnection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.NetworkConnection.class,
              com.google.cloud.migrationcenter.v1.NetworkConnection.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.NetworkConnection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      protocol_ = "";
      localIpAddress_ = "";
      localPort_ = 0;
      remoteIpAddress_ = "";
      remotePort_ = 0;
      state_ = 0;
      pid_ = 0L;
      processName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_NetworkConnection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkConnection getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.NetworkConnection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkConnection build() {
      com.google.cloud.migrationcenter.v1.NetworkConnection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkConnection buildPartial() {
      com.google.cloud.migrationcenter.v1.NetworkConnection result =
          new com.google.cloud.migrationcenter.v1.NetworkConnection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.NetworkConnection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.protocol_ = protocol_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.localIpAddress_ = localIpAddress_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.localPort_ = localPort_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.remoteIpAddress_ = remoteIpAddress_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.remotePort_ = remotePort_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pid_ = pid_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.processName_ = processName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.NetworkConnection) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.NetworkConnection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.NetworkConnection other) {
      if (other == com.google.cloud.migrationcenter.v1.NetworkConnection.getDefaultInstance())
        return this;
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLocalIpAddress().isEmpty()) {
        localIpAddress_ = other.localIpAddress_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getLocalPort() != 0) {
        setLocalPort(other.getLocalPort());
      }
      if (!other.getRemoteIpAddress().isEmpty()) {
        remoteIpAddress_ = other.remoteIpAddress_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getRemotePort() != 0) {
        setRemotePort(other.getRemotePort());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getPid() != 0L) {
        setPid(other.getPid());
      }
      if (!other.getProcessName().isEmpty()) {
        processName_ = other.processName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                protocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                localIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                localPort_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                remoteIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                remotePort_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                pid_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                processName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * Connection protocol (e.g. TCP/UDP).
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Connection protocol (e.g. TCP/UDP).
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @return The bytes for protocol.
     */
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Connection protocol (e.g. TCP/UDP).
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protocol_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection protocol (e.g. TCP/UDP).
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {
      protocol_ = getDefaultInstance().getProtocol();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection protocol (e.g. TCP/UDP).
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protocol_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object localIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * Local IP address.
     * </pre>
     *
     * <code>string local_ip_address = 2;</code>
     *
     * @return The localIpAddress.
     */
    public java.lang.String getLocalIpAddress() {
      java.lang.Object ref = localIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        localIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Local IP address.
     * </pre>
     *
     * <code>string local_ip_address = 2;</code>
     *
     * @return The bytes for localIpAddress.
     */
    public com.google.protobuf.ByteString getLocalIpAddressBytes() {
      java.lang.Object ref = localIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        localIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Local IP address.
     * </pre>
     *
     * <code>string local_ip_address = 2;</code>
     *
     * @param value The localIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setLocalIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      localIpAddress_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Local IP address.
     * </pre>
     *
     * <code>string local_ip_address = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalIpAddress() {
      localIpAddress_ = getDefaultInstance().getLocalIpAddress();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Local IP address.
     * </pre>
     *
     * <code>string local_ip_address = 2;</code>
     *
     * @param value The bytes for localIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setLocalIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      localIpAddress_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int localPort_;
    /**
     *
     *
     * <pre>
     * Local port.
     * </pre>
     *
     * <code>int32 local_port = 3;</code>
     *
     * @return The localPort.
     */
    @java.lang.Override
    public int getLocalPort() {
      return localPort_;
    }
    /**
     *
     *
     * <pre>
     * Local port.
     * </pre>
     *
     * <code>int32 local_port = 3;</code>
     *
     * @param value The localPort to set.
     * @return This builder for chaining.
     */
    public Builder setLocalPort(int value) {

      localPort_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Local port.
     * </pre>
     *
     * <code>int32 local_port = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalPort() {
      bitField0_ = (bitField0_ & ~0x00000004);
      localPort_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object remoteIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * Remote IP address.
     * </pre>
     *
     * <code>string remote_ip_address = 4;</code>
     *
     * @return The remoteIpAddress.
     */
    public java.lang.String getRemoteIpAddress() {
      java.lang.Object ref = remoteIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Remote IP address.
     * </pre>
     *
     * <code>string remote_ip_address = 4;</code>
     *
     * @return The bytes for remoteIpAddress.
     */
    public com.google.protobuf.ByteString getRemoteIpAddressBytes() {
      java.lang.Object ref = remoteIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Remote IP address.
     * </pre>
     *
     * <code>string remote_ip_address = 4;</code>
     *
     * @param value The remoteIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteIpAddress_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Remote IP address.
     * </pre>
     *
     * <code>string remote_ip_address = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteIpAddress() {
      remoteIpAddress_ = getDefaultInstance().getRemoteIpAddress();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Remote IP address.
     * </pre>
     *
     * <code>string remote_ip_address = 4;</code>
     *
     * @param value The bytes for remoteIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteIpAddress_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int remotePort_;
    /**
     *
     *
     * <pre>
     * Remote port.
     * </pre>
     *
     * <code>int32 remote_port = 5;</code>
     *
     * @return The remotePort.
     */
    @java.lang.Override
    public int getRemotePort() {
      return remotePort_;
    }
    /**
     *
     *
     * <pre>
     * Remote port.
     * </pre>
     *
     * <code>int32 remote_port = 5;</code>
     *
     * @param value The remotePort to set.
     * @return This builder for chaining.
     */
    public Builder setRemotePort(int value) {

      remotePort_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Remote port.
     * </pre>
     *
     * <code>int32 remote_port = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemotePort() {
      bitField0_ = (bitField0_ & ~0x00000010);
      remotePort_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Network connection state.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Network connection state.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network connection state.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.NetworkConnection.State getState() {
      com.google.cloud.migrationcenter.v1.NetworkConnection.State result =
          com.google.cloud.migrationcenter.v1.NetworkConnection.State.forNumber(state_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.NetworkConnection.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Network connection state.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.migrationcenter.v1.NetworkConnection.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network connection state.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NetworkConnection.State state = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private long pid_;
    /**
     *
     *
     * <pre>
     * Process ID.
     * </pre>
     *
     * <code>int64 pid = 7;</code>
     *
     * @return The pid.
     */
    @java.lang.Override
    public long getPid() {
      return pid_;
    }
    /**
     *
     *
     * <pre>
     * Process ID.
     * </pre>
     *
     * <code>int64 pid = 7;</code>
     *
     * @param value The pid to set.
     * @return This builder for chaining.
     */
    public Builder setPid(long value) {

      pid_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process ID.
     * </pre>
     *
     * <code>int64 pid = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPid() {
      bitField0_ = (bitField0_ & ~0x00000040);
      pid_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object processName_ = "";
    /**
     *
     *
     * <pre>
     * Process or service name.
     * </pre>
     *
     * <code>string process_name = 8;</code>
     *
     * @return The processName.
     */
    public java.lang.String getProcessName() {
      java.lang.Object ref = processName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        processName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Process or service name.
     * </pre>
     *
     * <code>string process_name = 8;</code>
     *
     * @return The bytes for processName.
     */
    public com.google.protobuf.ByteString getProcessNameBytes() {
      java.lang.Object ref = processName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        processName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Process or service name.
     * </pre>
     *
     * <code>string process_name = 8;</code>
     *
     * @param value The processName to set.
     * @return This builder for chaining.
     */
    public Builder setProcessName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      processName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process or service name.
     * </pre>
     *
     * <code>string process_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessName() {
      processName_ = getDefaultInstance().getProcessName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process or service name.
     * </pre>
     *
     * <code>string process_name = 8;</code>
     *
     * @param value The bytes for processName to set.
     * @return This builder for chaining.
     */
    public Builder setProcessNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      processName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.NetworkConnection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.NetworkConnection)
  private static final com.google.cloud.migrationcenter.v1.NetworkConnection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.NetworkConnection();
  }

  public static com.google.cloud.migrationcenter.v1.NetworkConnection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkConnection> PARSER =
      new com.google.protobuf.AbstractParser<NetworkConnection>() {
        @java.lang.Override
        public NetworkConnection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkConnection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkConnection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.NetworkConnection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
