/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Information about the platform.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.PlatformDetails}
 */
public final class PlatformDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.PlatformDetails)
    PlatformDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PlatformDetails.newBuilder() to construct.
  private PlatformDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PlatformDetails() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PlatformDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_PlatformDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_PlatformDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.PlatformDetails.class,
            com.google.cloud.migrationcenter.v1.PlatformDetails.Builder.class);
  }

  private int vendorDetailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object vendorDetails_;

  public enum VendorDetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VMWARE_DETAILS(1),
    AWS_EC2_DETAILS(2),
    AZURE_VM_DETAILS(3),
    GENERIC_DETAILS(4),
    PHYSICAL_DETAILS(5),
    VENDORDETAILS_NOT_SET(0);
    private final int value;

    private VendorDetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VendorDetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static VendorDetailsCase forNumber(int value) {
      switch (value) {
        case 1:
          return VMWARE_DETAILS;
        case 2:
          return AWS_EC2_DETAILS;
        case 3:
          return AZURE_VM_DETAILS;
        case 4:
          return GENERIC_DETAILS;
        case 5:
          return PHYSICAL_DETAILS;
        case 0:
          return VENDORDETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public VendorDetailsCase getVendorDetailsCase() {
    return VendorDetailsCase.forNumber(vendorDetailsCase_);
  }

  public static final int VMWARE_DETAILS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * VMware specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
   *
   * @return Whether the vmwareDetails field is set.
   */
  @java.lang.Override
  public boolean hasVmwareDetails() {
    return vendorDetailsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * VMware specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
   *
   * @return The vmwareDetails.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwarePlatformDetails getVmwareDetails() {
    if (vendorDetailsCase_ == 1) {
      return (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * VMware specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwarePlatformDetailsOrBuilder
      getVmwareDetailsOrBuilder() {
    if (vendorDetailsCase_ == 1) {
      return (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance();
  }

  public static final int AWS_EC2_DETAILS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * AWS EC2 specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
   *
   * @return Whether the awsEc2Details field is set.
   */
  @java.lang.Override
  public boolean hasAwsEc2Details() {
    return vendorDetailsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * AWS EC2 specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
   *
   * @return The awsEc2Details.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails getAwsEc2Details() {
    if (vendorDetailsCase_ == 2) {
      return (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * AWS EC2 specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetailsOrBuilder
      getAwsEc2DetailsOrBuilder() {
    if (vendorDetailsCase_ == 2) {
      return (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance();
  }

  public static final int AZURE_VM_DETAILS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Azure VM specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
   *
   * @return Whether the azureVmDetails field is set.
   */
  @java.lang.Override
  public boolean hasAzureVmDetails() {
    return vendorDetailsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Azure VM specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
   *
   * @return The azureVmDetails.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails getAzureVmDetails() {
    if (vendorDetailsCase_ == 3) {
      return (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Azure VM specific details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AzureVmPlatformDetailsOrBuilder
      getAzureVmDetailsOrBuilder() {
    if (vendorDetailsCase_ == 3) {
      return (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.getDefaultInstance();
  }

  public static final int GENERIC_DETAILS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Generic platform details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
   *
   * @return Whether the genericDetails field is set.
   */
  @java.lang.Override
  public boolean hasGenericDetails() {
    return vendorDetailsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Generic platform details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
   *
   * @return The genericDetails.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GenericPlatformDetails getGenericDetails() {
    if (vendorDetailsCase_ == 4) {
      return (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.GenericPlatformDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Generic platform details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GenericPlatformDetailsOrBuilder
      getGenericDetailsOrBuilder() {
    if (vendorDetailsCase_ == 4) {
      return (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.GenericPlatformDetails.getDefaultInstance();
  }

  public static final int PHYSICAL_DETAILS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Physical machines platform details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
   *
   * @return Whether the physicalDetails field is set.
   */
  @java.lang.Override
  public boolean hasPhysicalDetails() {
    return vendorDetailsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Physical machines platform details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
   *
   * @return The physicalDetails.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails getPhysicalDetails() {
    if (vendorDetailsCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Physical machines platform details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PhysicalPlatformDetailsOrBuilder
      getPhysicalDetailsOrBuilder() {
    if (vendorDetailsCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_;
    }
    return com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (vendorDetailsCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (vendorDetailsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_);
    }
    if (vendorDetailsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.PlatformDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.PlatformDetails other =
        (com.google.cloud.migrationcenter.v1.PlatformDetails) obj;

    if (!getVendorDetailsCase().equals(other.getVendorDetailsCase())) return false;
    switch (vendorDetailsCase_) {
      case 1:
        if (!getVmwareDetails().equals(other.getVmwareDetails())) return false;
        break;
      case 2:
        if (!getAwsEc2Details().equals(other.getAwsEc2Details())) return false;
        break;
      case 3:
        if (!getAzureVmDetails().equals(other.getAzureVmDetails())) return false;
        break;
      case 4:
        if (!getGenericDetails().equals(other.getGenericDetails())) return false;
        break;
      case 5:
        if (!getPhysicalDetails().equals(other.getPhysicalDetails())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (vendorDetailsCase_) {
      case 1:
        hash = (37 * hash) + VMWARE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getVmwareDetails().hashCode();
        break;
      case 2:
        hash = (37 * hash) + AWS_EC2_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getAwsEc2Details().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AZURE_VM_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getAzureVmDetails().hashCode();
        break;
      case 4:
        hash = (37 * hash) + GENERIC_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getGenericDetails().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PHYSICAL_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getPhysicalDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.PlatformDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about the platform.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.PlatformDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.PlatformDetails)
      com.google.cloud.migrationcenter.v1.PlatformDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_PlatformDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_PlatformDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.PlatformDetails.class,
              com.google.cloud.migrationcenter.v1.PlatformDetails.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.PlatformDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (vmwareDetailsBuilder_ != null) {
        vmwareDetailsBuilder_.clear();
      }
      if (awsEc2DetailsBuilder_ != null) {
        awsEc2DetailsBuilder_.clear();
      }
      if (azureVmDetailsBuilder_ != null) {
        azureVmDetailsBuilder_.clear();
      }
      if (genericDetailsBuilder_ != null) {
        genericDetailsBuilder_.clear();
      }
      if (physicalDetailsBuilder_ != null) {
        physicalDetailsBuilder_.clear();
      }
      vendorDetailsCase_ = 0;
      vendorDetails_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_PlatformDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.PlatformDetails getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.PlatformDetails build() {
      com.google.cloud.migrationcenter.v1.PlatformDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.PlatformDetails buildPartial() {
      com.google.cloud.migrationcenter.v1.PlatformDetails result =
          new com.google.cloud.migrationcenter.v1.PlatformDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.PlatformDetails result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.PlatformDetails result) {
      result.vendorDetailsCase_ = vendorDetailsCase_;
      result.vendorDetails_ = this.vendorDetails_;
      if (vendorDetailsCase_ == 1 && vmwareDetailsBuilder_ != null) {
        result.vendorDetails_ = vmwareDetailsBuilder_.build();
      }
      if (vendorDetailsCase_ == 2 && awsEc2DetailsBuilder_ != null) {
        result.vendorDetails_ = awsEc2DetailsBuilder_.build();
      }
      if (vendorDetailsCase_ == 3 && azureVmDetailsBuilder_ != null) {
        result.vendorDetails_ = azureVmDetailsBuilder_.build();
      }
      if (vendorDetailsCase_ == 4 && genericDetailsBuilder_ != null) {
        result.vendorDetails_ = genericDetailsBuilder_.build();
      }
      if (vendorDetailsCase_ == 5 && physicalDetailsBuilder_ != null) {
        result.vendorDetails_ = physicalDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.PlatformDetails) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.PlatformDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.PlatformDetails other) {
      if (other == com.google.cloud.migrationcenter.v1.PlatformDetails.getDefaultInstance())
        return this;
      switch (other.getVendorDetailsCase()) {
        case VMWARE_DETAILS:
          {
            mergeVmwareDetails(other.getVmwareDetails());
            break;
          }
        case AWS_EC2_DETAILS:
          {
            mergeAwsEc2Details(other.getAwsEc2Details());
            break;
          }
        case AZURE_VM_DETAILS:
          {
            mergeAzureVmDetails(other.getAzureVmDetails());
            break;
          }
        case GENERIC_DETAILS:
          {
            mergeGenericDetails(other.getGenericDetails());
            break;
          }
        case PHYSICAL_DETAILS:
          {
            mergePhysicalDetails(other.getPhysicalDetails());
            break;
          }
        case VENDORDETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getVmwareDetailsFieldBuilder().getBuilder(), extensionRegistry);
                vendorDetailsCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAwsEc2DetailsFieldBuilder().getBuilder(), extensionRegistry);
                vendorDetailsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAzureVmDetailsFieldBuilder().getBuilder(), extensionRegistry);
                vendorDetailsCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getGenericDetailsFieldBuilder().getBuilder(), extensionRegistry);
                vendorDetailsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPhysicalDetailsFieldBuilder().getBuilder(), extensionRegistry);
                vendorDetailsCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int vendorDetailsCase_ = 0;
    private java.lang.Object vendorDetails_;

    public VendorDetailsCase getVendorDetailsCase() {
      return VendorDetailsCase.forNumber(vendorDetailsCase_);
    }

    public Builder clearVendorDetails() {
      vendorDetailsCase_ = 0;
      vendorDetails_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.VmwarePlatformDetails,
            com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.VmwarePlatformDetailsOrBuilder>
        vmwareDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     *
     * @return Whether the vmwareDetails field is set.
     */
    @java.lang.Override
    public boolean hasVmwareDetails() {
      return vendorDetailsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     *
     * @return The vmwareDetails.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwarePlatformDetails getVmwareDetails() {
      if (vmwareDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 1) {
          return (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance();
      } else {
        if (vendorDetailsCase_ == 1) {
          return vmwareDetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    public Builder setVmwareDetails(
        com.google.cloud.migrationcenter.v1.VmwarePlatformDetails value) {
      if (vmwareDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vendorDetails_ = value;
        onChanged();
      } else {
        vmwareDetailsBuilder_.setMessage(value);
      }
      vendorDetailsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    public Builder setVmwareDetails(
        com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.Builder builderForValue) {
      if (vmwareDetailsBuilder_ == null) {
        vendorDetails_ = builderForValue.build();
        onChanged();
      } else {
        vmwareDetailsBuilder_.setMessage(builderForValue.build());
      }
      vendorDetailsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    public Builder mergeVmwareDetails(
        com.google.cloud.migrationcenter.v1.VmwarePlatformDetails value) {
      if (vmwareDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 1
            && vendorDetails_
                != com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance()) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vendorDetails_ = value;
        }
        onChanged();
      } else {
        if (vendorDetailsCase_ == 1) {
          vmwareDetailsBuilder_.mergeFrom(value);
        } else {
          vmwareDetailsBuilder_.setMessage(value);
        }
      }
      vendorDetailsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    public Builder clearVmwareDetails() {
      if (vmwareDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 1) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
          onChanged();
        }
      } else {
        if (vendorDetailsCase_ == 1) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
        }
        vmwareDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    public com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.Builder
        getVmwareDetailsBuilder() {
      return getVmwareDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwarePlatformDetailsOrBuilder
        getVmwareDetailsOrBuilder() {
      if ((vendorDetailsCase_ == 1) && (vmwareDetailsBuilder_ != null)) {
        return vmwareDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (vendorDetailsCase_ == 1) {
          return (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * VMware specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwarePlatformDetails vmware_details = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.VmwarePlatformDetails,
            com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.VmwarePlatformDetailsOrBuilder>
        getVmwareDetailsFieldBuilder() {
      if (vmwareDetailsBuilder_ == null) {
        if (!(vendorDetailsCase_ == 1)) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.getDefaultInstance();
        }
        vmwareDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.VmwarePlatformDetails,
                com.google.cloud.migrationcenter.v1.VmwarePlatformDetails.Builder,
                com.google.cloud.migrationcenter.v1.VmwarePlatformDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.VmwarePlatformDetails) vendorDetails_,
                getParentForChildren(),
                isClean());
        vendorDetails_ = null;
      }
      vendorDetailsCase_ = 1;
      onChanged();
      return vmwareDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails,
            com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetailsOrBuilder>
        awsEc2DetailsBuilder_;
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     *
     * @return Whether the awsEc2Details field is set.
     */
    @java.lang.Override
    public boolean hasAwsEc2Details() {
      return vendorDetailsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     *
     * @return The awsEc2Details.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails getAwsEc2Details() {
      if (awsEc2DetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 2) {
          return (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance();
      } else {
        if (vendorDetailsCase_ == 2) {
          return awsEc2DetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    public Builder setAwsEc2Details(
        com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails value) {
      if (awsEc2DetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vendorDetails_ = value;
        onChanged();
      } else {
        awsEc2DetailsBuilder_.setMessage(value);
      }
      vendorDetailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    public Builder setAwsEc2Details(
        com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.Builder builderForValue) {
      if (awsEc2DetailsBuilder_ == null) {
        vendorDetails_ = builderForValue.build();
        onChanged();
      } else {
        awsEc2DetailsBuilder_.setMessage(builderForValue.build());
      }
      vendorDetailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    public Builder mergeAwsEc2Details(
        com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails value) {
      if (awsEc2DetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 2
            && vendorDetails_
                != com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance()) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vendorDetails_ = value;
        }
        onChanged();
      } else {
        if (vendorDetailsCase_ == 2) {
          awsEc2DetailsBuilder_.mergeFrom(value);
        } else {
          awsEc2DetailsBuilder_.setMessage(value);
        }
      }
      vendorDetailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    public Builder clearAwsEc2Details() {
      if (awsEc2DetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 2) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
          onChanged();
        }
      } else {
        if (vendorDetailsCase_ == 2) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
        }
        awsEc2DetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.Builder
        getAwsEc2DetailsBuilder() {
      return getAwsEc2DetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetailsOrBuilder
        getAwsEc2DetailsOrBuilder() {
      if ((vendorDetailsCase_ == 2) && (awsEc2DetailsBuilder_ != null)) {
        return awsEc2DetailsBuilder_.getMessageOrBuilder();
      } else {
        if (vendorDetailsCase_ == 2) {
          return (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * AWS EC2 specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails aws_ec2_details = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails,
            com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetailsOrBuilder>
        getAwsEc2DetailsFieldBuilder() {
      if (awsEc2DetailsBuilder_ == null) {
        if (!(vendorDetailsCase_ == 2)) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.getDefaultInstance();
        }
        awsEc2DetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails,
                com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails.Builder,
                com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.AwsEc2PlatformDetails) vendorDetails_,
                getParentForChildren(),
                isClean());
        vendorDetails_ = null;
      }
      vendorDetailsCase_ = 2;
      onChanged();
      return awsEc2DetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails,
            com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.AzureVmPlatformDetailsOrBuilder>
        azureVmDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     *
     * @return Whether the azureVmDetails field is set.
     */
    @java.lang.Override
    public boolean hasAzureVmDetails() {
      return vendorDetailsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     *
     * @return The azureVmDetails.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails getAzureVmDetails() {
      if (azureVmDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 3) {
          return (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.getDefaultInstance();
      } else {
        if (vendorDetailsCase_ == 3) {
          return azureVmDetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    public Builder setAzureVmDetails(
        com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails value) {
      if (azureVmDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vendorDetails_ = value;
        onChanged();
      } else {
        azureVmDetailsBuilder_.setMessage(value);
      }
      vendorDetailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    public Builder setAzureVmDetails(
        com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.Builder builderForValue) {
      if (azureVmDetailsBuilder_ == null) {
        vendorDetails_ = builderForValue.build();
        onChanged();
      } else {
        azureVmDetailsBuilder_.setMessage(builderForValue.build());
      }
      vendorDetailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    public Builder mergeAzureVmDetails(
        com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails value) {
      if (azureVmDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 3
            && vendorDetails_
                != com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails
                    .getDefaultInstance()) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vendorDetails_ = value;
        }
        onChanged();
      } else {
        if (vendorDetailsCase_ == 3) {
          azureVmDetailsBuilder_.mergeFrom(value);
        } else {
          azureVmDetailsBuilder_.setMessage(value);
        }
      }
      vendorDetailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    public Builder clearAzureVmDetails() {
      if (azureVmDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 3) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
          onChanged();
        }
      } else {
        if (vendorDetailsCase_ == 3) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
        }
        azureVmDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    public com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.Builder
        getAzureVmDetailsBuilder() {
      return getAzureVmDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AzureVmPlatformDetailsOrBuilder
        getAzureVmDetailsOrBuilder() {
      if ((vendorDetailsCase_ == 3) && (azureVmDetailsBuilder_ != null)) {
        return azureVmDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (vendorDetailsCase_ == 3) {
          return (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Azure VM specific details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.AzureVmPlatformDetails azure_vm_details = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails,
            com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.AzureVmPlatformDetailsOrBuilder>
        getAzureVmDetailsFieldBuilder() {
      if (azureVmDetailsBuilder_ == null) {
        if (!(vendorDetailsCase_ == 3)) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.getDefaultInstance();
        }
        azureVmDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails,
                com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails.Builder,
                com.google.cloud.migrationcenter.v1.AzureVmPlatformDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.AzureVmPlatformDetails) vendorDetails_,
                getParentForChildren(),
                isClean());
        vendorDetails_ = null;
      }
      vendorDetailsCase_ = 3;
      onChanged();
      return azureVmDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GenericPlatformDetails,
            com.google.cloud.migrationcenter.v1.GenericPlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.GenericPlatformDetailsOrBuilder>
        genericDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     *
     * @return Whether the genericDetails field is set.
     */
    @java.lang.Override
    public boolean hasGenericDetails() {
      return vendorDetailsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     *
     * @return The genericDetails.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GenericPlatformDetails getGenericDetails() {
      if (genericDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 4) {
          return (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.GenericPlatformDetails.getDefaultInstance();
      } else {
        if (vendorDetailsCase_ == 4) {
          return genericDetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.GenericPlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    public Builder setGenericDetails(
        com.google.cloud.migrationcenter.v1.GenericPlatformDetails value) {
      if (genericDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vendorDetails_ = value;
        onChanged();
      } else {
        genericDetailsBuilder_.setMessage(value);
      }
      vendorDetailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    public Builder setGenericDetails(
        com.google.cloud.migrationcenter.v1.GenericPlatformDetails.Builder builderForValue) {
      if (genericDetailsBuilder_ == null) {
        vendorDetails_ = builderForValue.build();
        onChanged();
      } else {
        genericDetailsBuilder_.setMessage(builderForValue.build());
      }
      vendorDetailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    public Builder mergeGenericDetails(
        com.google.cloud.migrationcenter.v1.GenericPlatformDetails value) {
      if (genericDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 4
            && vendorDetails_
                != com.google.cloud.migrationcenter.v1.GenericPlatformDetails
                    .getDefaultInstance()) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.GenericPlatformDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vendorDetails_ = value;
        }
        onChanged();
      } else {
        if (vendorDetailsCase_ == 4) {
          genericDetailsBuilder_.mergeFrom(value);
        } else {
          genericDetailsBuilder_.setMessage(value);
        }
      }
      vendorDetailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    public Builder clearGenericDetails() {
      if (genericDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 4) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
          onChanged();
        }
      } else {
        if (vendorDetailsCase_ == 4) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
        }
        genericDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.GenericPlatformDetails.Builder
        getGenericDetailsBuilder() {
      return getGenericDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GenericPlatformDetailsOrBuilder
        getGenericDetailsOrBuilder() {
      if ((vendorDetailsCase_ == 4) && (genericDetailsBuilder_ != null)) {
        return genericDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (vendorDetailsCase_ == 4) {
          return (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.GenericPlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Generic platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GenericPlatformDetails generic_details = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GenericPlatformDetails,
            com.google.cloud.migrationcenter.v1.GenericPlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.GenericPlatformDetailsOrBuilder>
        getGenericDetailsFieldBuilder() {
      if (genericDetailsBuilder_ == null) {
        if (!(vendorDetailsCase_ == 4)) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.GenericPlatformDetails.getDefaultInstance();
        }
        genericDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.GenericPlatformDetails,
                com.google.cloud.migrationcenter.v1.GenericPlatformDetails.Builder,
                com.google.cloud.migrationcenter.v1.GenericPlatformDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.GenericPlatformDetails) vendorDetails_,
                getParentForChildren(),
                isClean());
        vendorDetails_ = null;
      }
      vendorDetailsCase_ = 4;
      onChanged();
      return genericDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails,
            com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.PhysicalPlatformDetailsOrBuilder>
        physicalDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     *
     * @return Whether the physicalDetails field is set.
     */
    @java.lang.Override
    public boolean hasPhysicalDetails() {
      return vendorDetailsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     *
     * @return The physicalDetails.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails getPhysicalDetails() {
      if (physicalDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.getDefaultInstance();
      } else {
        if (vendorDetailsCase_ == 5) {
          return physicalDetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    public Builder setPhysicalDetails(
        com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails value) {
      if (physicalDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vendorDetails_ = value;
        onChanged();
      } else {
        physicalDetailsBuilder_.setMessage(value);
      }
      vendorDetailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    public Builder setPhysicalDetails(
        com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.Builder builderForValue) {
      if (physicalDetailsBuilder_ == null) {
        vendorDetails_ = builderForValue.build();
        onChanged();
      } else {
        physicalDetailsBuilder_.setMessage(builderForValue.build());
      }
      vendorDetailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    public Builder mergePhysicalDetails(
        com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails value) {
      if (physicalDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 5
            && vendorDetails_
                != com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails
                    .getDefaultInstance()) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vendorDetails_ = value;
        }
        onChanged();
      } else {
        if (vendorDetailsCase_ == 5) {
          physicalDetailsBuilder_.mergeFrom(value);
        } else {
          physicalDetailsBuilder_.setMessage(value);
        }
      }
      vendorDetailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    public Builder clearPhysicalDetails() {
      if (physicalDetailsBuilder_ == null) {
        if (vendorDetailsCase_ == 5) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
          onChanged();
        }
      } else {
        if (vendorDetailsCase_ == 5) {
          vendorDetailsCase_ = 0;
          vendorDetails_ = null;
        }
        physicalDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.Builder
        getPhysicalDetailsBuilder() {
      return getPhysicalDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.PhysicalPlatformDetailsOrBuilder
        getPhysicalDetailsOrBuilder() {
      if ((vendorDetailsCase_ == 5) && (physicalDetailsBuilder_ != null)) {
        return physicalDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (vendorDetailsCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_;
        }
        return com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Physical machines platform details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.PhysicalPlatformDetails physical_details = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails,
            com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.Builder,
            com.google.cloud.migrationcenter.v1.PhysicalPlatformDetailsOrBuilder>
        getPhysicalDetailsFieldBuilder() {
      if (physicalDetailsBuilder_ == null) {
        if (!(vendorDetailsCase_ == 5)) {
          vendorDetails_ =
              com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.getDefaultInstance();
        }
        physicalDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails,
                com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails.Builder,
                com.google.cloud.migrationcenter.v1.PhysicalPlatformDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.PhysicalPlatformDetails) vendorDetails_,
                getParentForChildren(),
                isClean());
        vendorDetails_ = null;
      }
      vendorDetailsCase_ = 5;
      onChanged();
      return physicalDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.PlatformDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.PlatformDetails)
  private static final com.google.cloud.migrationcenter.v1.PlatformDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.PlatformDetails();
  }

  public static com.google.cloud.migrationcenter.v1.PlatformDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PlatformDetails> PARSER =
      new com.google.protobuf.AbstractParser<PlatformDetails>() {
        @java.lang.Override
        public PlatformDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PlatformDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PlatformDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PlatformDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
