/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * The groups and associated preference sets on which
 * we can generate reports.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ReportConfig}
 */
public final class ReportConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportConfig)
    ReportConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportConfig.newBuilder() to construct.
  private ReportConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportConfig() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    groupPreferencesetAssignments_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ReportConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ReportConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ReportConfig.class,
            com.google.cloud.migrationcenter.v1.ReportConfig.Builder.class);
  }

  public interface GroupPreferenceSetAssignmentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the group.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The group.
     */
    java.lang.String getGroup();
    /**
     *
     *
     * <pre>
     * Required. Name of the group.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for group.
     */
    com.google.protobuf.ByteString getGroupBytes();

    /**
     *
     *
     * <pre>
     * Required. Name of the Preference Set.
     * </pre>
     *
     * <code>
     * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The preferenceSet.
     */
    java.lang.String getPreferenceSet();
    /**
     *
     *
     * <pre>
     * Required. Name of the Preference Set.
     * </pre>
     *
     * <code>
     * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for preferenceSet.
     */
    com.google.protobuf.ByteString getPreferenceSetBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents a combination of a group with a preference set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment}
   */
  public static final class GroupPreferenceSetAssignment
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)
      GroupPreferenceSetAssignmentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroupPreferenceSetAssignment.newBuilder() to construct.
    private GroupPreferenceSetAssignment(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroupPreferenceSetAssignment() {
      group_ = "";
      preferenceSet_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroupPreferenceSetAssignment();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportConfig_GroupPreferenceSetAssignment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportConfig_GroupPreferenceSetAssignment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.class,
              com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
                  .class);
    }

    public static final int GROUP_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object group_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the group.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The group.
     */
    @java.lang.Override
    public java.lang.String getGroup() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        group_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the group.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for group.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupBytes() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        group_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PREFERENCE_SET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object preferenceSet_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Preference Set.
     * </pre>
     *
     * <code>
     * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The preferenceSet.
     */
    @java.lang.Override
    public java.lang.String getPreferenceSet() {
      java.lang.Object ref = preferenceSet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        preferenceSet_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Preference Set.
     * </pre>
     *
     * <code>
     * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for preferenceSet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPreferenceSetBytes() {
      java.lang.Object ref = preferenceSet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        preferenceSet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, group_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preferenceSet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, preferenceSet_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, group_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preferenceSet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, preferenceSet_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment other =
          (com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment) obj;

      if (!getGroup().equals(other.getGroup())) return false;
      if (!getPreferenceSet().equals(other.getPreferenceSet())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getGroup().hashCode();
      hash = (37 * hash) + PREFERENCE_SET_FIELD_NUMBER;
      hash = (53 * hash) + getPreferenceSet().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a combination of a group with a preference set.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignmentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportConfig_GroupPreferenceSetAssignment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportConfig_GroupPreferenceSetAssignment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.class,
                com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        group_ = "";
        preferenceSet_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportConfig_GroupPreferenceSetAssignment_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment build() {
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
          buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment result =
            new com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.group_ = group_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.preferenceSet_ = preferenceSet_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
                .getDefaultInstance()) return this;
        if (!other.getGroup().isEmpty()) {
          group_ = other.group_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPreferenceSet().isEmpty()) {
          preferenceSet_ = other.preferenceSet_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  group_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  preferenceSet_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object group_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the group.
       * </pre>
       *
       * <code>
       * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The group.
       */
      public java.lang.String getGroup() {
        java.lang.Object ref = group_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          group_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the group.
       * </pre>
       *
       * <code>
       * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for group.
       */
      public com.google.protobuf.ByteString getGroupBytes() {
        java.lang.Object ref = group_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          group_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the group.
       * </pre>
       *
       * <code>
       * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The group to set.
       * @return This builder for chaining.
       */
      public Builder setGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        group_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the group.
       * </pre>
       *
       * <code>
       * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroup() {
        group_ = getDefaultInstance().getGroup();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the group.
       * </pre>
       *
       * <code>
       * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for group to set.
       * @return This builder for chaining.
       */
      public Builder setGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        group_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object preferenceSet_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the Preference Set.
       * </pre>
       *
       * <code>
       * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The preferenceSet.
       */
      public java.lang.String getPreferenceSet() {
        java.lang.Object ref = preferenceSet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          preferenceSet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Preference Set.
       * </pre>
       *
       * <code>
       * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for preferenceSet.
       */
      public com.google.protobuf.ByteString getPreferenceSetBytes() {
        java.lang.Object ref = preferenceSet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          preferenceSet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Preference Set.
       * </pre>
       *
       * <code>
       * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The preferenceSet to set.
       * @return This builder for chaining.
       */
      public Builder setPreferenceSet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        preferenceSet_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Preference Set.
       * </pre>
       *
       * <code>
       * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreferenceSet() {
        preferenceSet_ = getDefaultInstance().getPreferenceSet();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Preference Set.
       * </pre>
       *
       * <code>
       * string preference_set = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for preferenceSet to set.
       * @return This builder for chaining.
       */
      public Builder setPreferenceSetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        preferenceSet_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment)
    private static final com.google.cloud.migrationcenter.v1.ReportConfig
            .GroupPreferenceSetAssignment
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment();
    }

    public static com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroupPreferenceSetAssignment> PARSER =
        new com.google.protobuf.AbstractParser<GroupPreferenceSetAssignment>() {
          @java.lang.Override
          public GroupPreferenceSetAssignment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroupPreferenceSetAssignment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroupPreferenceSetAssignment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of resource.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of resource.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User-friendly display name. Maximum length is 63 characters.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-friendly display name. Maximum length is 63 characters.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Free-text description.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Free-text description.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUP_PREFERENCESET_ASSIGNMENTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment>
      groupPreferencesetAssignments_;
  /**
   *
   *
   * <pre>
   * Required. Collection of combinations of groups and preference sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment>
      getGroupPreferencesetAssignmentsList() {
    return groupPreferencesetAssignments_;
  }
  /**
   *
   *
   * <pre>
   * Required. Collection of combinations of groups and preference sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.migrationcenter.v1.ReportConfig
                  .GroupPreferenceSetAssignmentOrBuilder>
      getGroupPreferencesetAssignmentsOrBuilderList() {
    return groupPreferencesetAssignments_;
  }
  /**
   *
   *
   * <pre>
   * Required. Collection of combinations of groups and preference sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getGroupPreferencesetAssignmentsCount() {
    return groupPreferencesetAssignments_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Collection of combinations of groups and preference sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
      getGroupPreferencesetAssignments(int index) {
    return groupPreferencesetAssignments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Collection of combinations of groups and preference sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignmentOrBuilder
      getGroupPreferencesetAssignmentsOrBuilder(int index) {
    return groupPreferencesetAssignments_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    for (int i = 0; i < groupPreferencesetAssignments_.size(); i++) {
      output.writeMessage(6, groupPreferencesetAssignments_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    for (int i = 0; i < groupPreferencesetAssignments_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, groupPreferencesetAssignments_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ReportConfig other =
        (com.google.cloud.migrationcenter.v1.ReportConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getGroupPreferencesetAssignmentsList()
        .equals(other.getGroupPreferencesetAssignmentsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getGroupPreferencesetAssignmentsCount() > 0) {
      hash = (37 * hash) + GROUP_PREFERENCESET_ASSIGNMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getGroupPreferencesetAssignmentsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ReportConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The groups and associated preference sets on which
   * we can generate reports.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportConfig)
      com.google.cloud.migrationcenter.v1.ReportConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportConfig.class,
              com.google.cloud.migrationcenter.v1.ReportConfig.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ReportConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      displayName_ = "";
      description_ = "";
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        groupPreferencesetAssignments_ = java.util.Collections.emptyList();
      } else {
        groupPreferencesetAssignments_ = null;
        groupPreferencesetAssignmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportConfig getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ReportConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportConfig build() {
      com.google.cloud.migrationcenter.v1.ReportConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportConfig buildPartial() {
      com.google.cloud.migrationcenter.v1.ReportConfig result =
          new com.google.cloud.migrationcenter.v1.ReportConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.ReportConfig result) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          groupPreferencesetAssignments_ =
              java.util.Collections.unmodifiableList(groupPreferencesetAssignments_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.groupPreferencesetAssignments_ = groupPreferencesetAssignments_;
      } else {
        result.groupPreferencesetAssignments_ = groupPreferencesetAssignmentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ReportConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ReportConfig) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ReportConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ReportConfig other) {
      if (other == com.google.cloud.migrationcenter.v1.ReportConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        if (!other.groupPreferencesetAssignments_.isEmpty()) {
          if (groupPreferencesetAssignments_.isEmpty()) {
            groupPreferencesetAssignments_ = other.groupPreferencesetAssignments_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureGroupPreferencesetAssignmentsIsMutable();
            groupPreferencesetAssignments_.addAll(other.groupPreferencesetAssignments_);
          }
          onChanged();
        }
      } else {
        if (!other.groupPreferencesetAssignments_.isEmpty()) {
          if (groupPreferencesetAssignmentsBuilder_.isEmpty()) {
            groupPreferencesetAssignmentsBuilder_.dispose();
            groupPreferencesetAssignmentsBuilder_ = null;
            groupPreferencesetAssignments_ = other.groupPreferencesetAssignments_;
            bitField0_ = (bitField0_ & ~0x00000020);
            groupPreferencesetAssignmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroupPreferencesetAssignmentsFieldBuilder()
                    : null;
          } else {
            groupPreferencesetAssignmentsBuilder_.addAllMessages(
                other.groupPreferencesetAssignments_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ReportConfig
                            .GroupPreferenceSetAssignment.parser(),
                        extensionRegistry);
                if (groupPreferencesetAssignmentsBuilder_ == null) {
                  ensureGroupPreferencesetAssignmentsIsMutable();
                  groupPreferencesetAssignments_.add(m);
                } else {
                  groupPreferencesetAssignmentsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of resource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of resource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of resource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of resource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of resource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Free-text description.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-text description.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-text description.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-text description.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-text description.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment>
        groupPreferencesetAssignments_ = java.util.Collections.emptyList();

    private void ensureGroupPreferencesetAssignmentsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        groupPreferencesetAssignments_ =
            new java.util.ArrayList<
                com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment>(
                groupPreferencesetAssignments_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment,
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder,
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignmentOrBuilder>
        groupPreferencesetAssignmentsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment>
        getGroupPreferencesetAssignmentsList() {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groupPreferencesetAssignments_);
      } else {
        return groupPreferencesetAssignmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getGroupPreferencesetAssignmentsCount() {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        return groupPreferencesetAssignments_.size();
      } else {
        return groupPreferencesetAssignmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
        getGroupPreferencesetAssignments(int index) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        return groupPreferencesetAssignments_.get(index);
      } else {
        return groupPreferencesetAssignmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGroupPreferencesetAssignments(
        int index,
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment value) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.set(index, value);
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGroupPreferencesetAssignments(
        int index,
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
            builderForValue) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.set(index, builderForValue.build());
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addGroupPreferencesetAssignments(
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment value) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.add(value);
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addGroupPreferencesetAssignments(
        int index,
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment value) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.add(index, value);
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addGroupPreferencesetAssignments(
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
            builderForValue) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.add(builderForValue.build());
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addGroupPreferencesetAssignments(
        int index,
        com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
            builderForValue) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.add(index, builderForValue.build());
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllGroupPreferencesetAssignments(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment>
            values) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        ensureGroupPreferencesetAssignmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, groupPreferencesetAssignments_);
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearGroupPreferencesetAssignments() {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        groupPreferencesetAssignments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeGroupPreferencesetAssignments(int index) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        ensureGroupPreferencesetAssignmentsIsMutable();
        groupPreferencesetAssignments_.remove(index);
        onChanged();
      } else {
        groupPreferencesetAssignmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
        getGroupPreferencesetAssignmentsBuilder(int index) {
      return getGroupPreferencesetAssignmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignmentOrBuilder
        getGroupPreferencesetAssignmentsOrBuilder(int index) {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        return groupPreferencesetAssignments_.get(index);
      } else {
        return groupPreferencesetAssignmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportConfig
                    .GroupPreferenceSetAssignmentOrBuilder>
        getGroupPreferencesetAssignmentsOrBuilderList() {
      if (groupPreferencesetAssignmentsBuilder_ != null) {
        return groupPreferencesetAssignmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groupPreferencesetAssignments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
        addGroupPreferencesetAssignmentsBuilder() {
      return getGroupPreferencesetAssignmentsFieldBuilder()
          .addBuilder(
              com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder
        addGroupPreferencesetAssignmentsBuilder(int index) {
      return getGroupPreferencesetAssignmentsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Collection of combinations of groups and preference sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment group_preferenceset_assignments = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder>
        getGroupPreferencesetAssignmentsBuilderList() {
      return getGroupPreferencesetAssignmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment,
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment.Builder,
            com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignmentOrBuilder>
        getGroupPreferencesetAssignmentsFieldBuilder() {
      if (groupPreferencesetAssignmentsBuilder_ == null) {
        groupPreferencesetAssignmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment,
                com.google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
                    .Builder,
                com.google.cloud.migrationcenter.v1.ReportConfig
                    .GroupPreferenceSetAssignmentOrBuilder>(
                groupPreferencesetAssignments_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        groupPreferencesetAssignments_ = null;
      }
      return groupPreferencesetAssignmentsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportConfig)
  private static final com.google.cloud.migrationcenter.v1.ReportConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportConfig();
  }

  public static com.google.cloud.migrationcenter.v1.ReportConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportConfig> PARSER =
      new com.google.protobuf.AbstractParser<ReportConfig>() {
        @java.lang.Override
        public ReportConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
