/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Describes the Summary view of a Report, which contains aggregated values
 * for all the groups and preference sets included in this Report.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary}
 */
public final class ReportSummary extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary)
    ReportSummaryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportSummary.newBuilder() to construct.
  private ReportSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportSummary() {
    groupFindings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportSummary();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ReportSummary_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ReportSummary_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ReportSummary.class,
            com.google.cloud.migrationcenter.v1.ReportSummary.Builder.class);
  }

  public interface ChartDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.ChartData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>
        getDataPointsList();
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint getDataPoints(int index);
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    int getDataPointsCount();
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder>
        getDataPointsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder
        getDataPointsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Describes a collection of data points rendered as a Chart.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.ChartData}
   */
  public static final class ChartData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.ChartData)
      ChartDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChartData.newBuilder() to construct.
    private ChartData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChartData() {
      dataPoints_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChartData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder.class);
    }

    public interface DataPointOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The X-axis label for this data point.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return The label.
       */
      java.lang.String getLabel();
      /**
       *
       *
       * <pre>
       * The X-axis label for this data point.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return The bytes for label.
       */
      com.google.protobuf.ByteString getLabelBytes();

      /**
       *
       *
       * <pre>
       * The Y-axis value for this data point.
       * </pre>
       *
       * <code>double value = 2;</code>
       *
       * @return The value.
       */
      double getValue();
    }
    /**
     *
     *
     * <pre>
     * Describes a single data point in the Chart.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint}
     */
    public static final class DataPoint extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint)
        DataPointOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DataPoint.newBuilder() to construct.
      private DataPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DataPoint() {
        label_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DataPoint();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_DataPoint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_DataPoint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
                    .class);
      }

      public static final int LABEL_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object label_ = "";
      /**
       *
       *
       * <pre>
       * The X-axis label for this data point.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return The label.
       */
      @java.lang.Override
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The X-axis label for this data point.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return The bytes for label.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private double value_ = 0D;
      /**
       *
       *
       * <pre>
       * The Y-axis value for this data point.
       * </pre>
       *
       * <code>double value = 2;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public double getValue() {
        return value_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, label_);
        }
        if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
          output.writeDouble(2, value_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, label_);
        }
        if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, value_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint)) {
          return super.equals(obj);
        }
        com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint other =
            (com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint) obj;

        if (!getLabel().equals(other.getLabel())) return false;
        if (java.lang.Double.doubleToLongBits(getValue())
            != java.lang.Double.doubleToLongBits(other.getValue())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LABEL_FIELD_NUMBER;
        hash = (53 * hash) + getLabel().hashCode();
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getValue()));
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Describes a single data point in the Chart.
       * </pre>
       *
       * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint)
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_DataPoint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_DataPoint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.class,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          label_ = "";
          value_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_DataPoint_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
            getDefaultInstanceForType() {
          return com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint build() {
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
            buildPartial() {
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint result =
              new com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.label_ = label_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = value_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint) {
            return mergeFrom(
                (com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint other) {
          if (other
              == com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
                  .getDefaultInstance()) return this;
          if (!other.getLabel().isEmpty()) {
            label_ = other.label_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getValue() != 0D) {
            setValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    label_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 17:
                  {
                    value_ = input.readDouble();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 17
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object label_ = "";
        /**
         *
         *
         * <pre>
         * The X-axis label for this data point.
         * </pre>
         *
         * <code>string label = 1;</code>
         *
         * @return The label.
         */
        public java.lang.String getLabel() {
          java.lang.Object ref = label_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            label_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The X-axis label for this data point.
         * </pre>
         *
         * <code>string label = 1;</code>
         *
         * @return The bytes for label.
         */
        public com.google.protobuf.ByteString getLabelBytes() {
          java.lang.Object ref = label_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            label_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The X-axis label for this data point.
         * </pre>
         *
         * <code>string label = 1;</code>
         *
         * @param value The label to set.
         * @return This builder for chaining.
         */
        public Builder setLabel(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          label_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The X-axis label for this data point.
         * </pre>
         *
         * <code>string label = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLabel() {
          label_ = getDefaultInstance().getLabel();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The X-axis label for this data point.
         * </pre>
         *
         * <code>string label = 1;</code>
         *
         * @param value The bytes for label to set.
         * @return This builder for chaining.
         */
        public Builder setLabelBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          label_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private double value_;
        /**
         *
         *
         * <pre>
         * The Y-axis value for this data point.
         * </pre>
         *
         * <code>double value = 2;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public double getValue() {
          return value_;
        }
        /**
         *
         *
         * <pre>
         * The Y-axis value for this data point.
         * </pre>
         *
         * <code>double value = 2;</code>
         *
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(double value) {

          value_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The Y-axis value for this data point.
         * </pre>
         *
         * <code>double value = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint)
      private static final com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint();
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DataPoint> PARSER =
          new com.google.protobuf.AbstractParser<DataPoint>() {
            @java.lang.Override
            public DataPoint parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DataPoint> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DataPoint> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DATA_POINTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>
        dataPoints_;
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>
        getDataPointsList() {
      return dataPoints_;
    }
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder>
        getDataPointsOrBuilderList() {
      return dataPoints_;
    }
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    @java.lang.Override
    public int getDataPointsCount() {
      return dataPoints_.size();
    }
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint getDataPoints(
        int index) {
      return dataPoints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Each data point in the chart is represented as a name-value pair
     * with the name being the x-axis label, and the value being the y-axis
     * value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder
        getDataPointsOrBuilder(int index) {
      return dataPoints_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dataPoints_.size(); i++) {
        output.writeMessage(1, dataPoints_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dataPoints_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, dataPoints_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.ChartData)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.ChartData other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.ChartData) obj;

      if (!getDataPointsList().equals(other.getDataPointsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDataPointsCount() > 0) {
        hash = (37 * hash) + DATA_POINTS_FIELD_NUMBER;
        hash = (53 * hash) + getDataPointsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.ChartData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes a collection of data points rendered as a Chart.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.ChartData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.ChartData)
        com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dataPointsBuilder_ == null) {
          dataPoints_ = java.util.Collections.emptyList();
        } else {
          dataPoints_ = null;
          dataPointsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ChartData_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.ChartData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.ChartData result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.ChartData(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData result) {
        if (dataPointsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dataPoints_ = java.util.Collections.unmodifiableList(dataPoints_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dataPoints_ = dataPoints_;
        } else {
          result.dataPoints_ = dataPointsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.ReportSummary.ChartData) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.ReportSummary.ChartData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ReportSummary.ChartData other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.getDefaultInstance())
          return this;
        if (dataPointsBuilder_ == null) {
          if (!other.dataPoints_.isEmpty()) {
            if (dataPoints_.isEmpty()) {
              dataPoints_ = other.dataPoints_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDataPointsIsMutable();
              dataPoints_.addAll(other.dataPoints_);
            }
            onChanged();
          }
        } else {
          if (!other.dataPoints_.isEmpty()) {
            if (dataPointsBuilder_.isEmpty()) {
              dataPointsBuilder_.dispose();
              dataPointsBuilder_ = null;
              dataPoints_ = other.dataPoints_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dataPointsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDataPointsFieldBuilder()
                      : null;
            } else {
              dataPointsBuilder_.addAllMessages(other.dataPoints_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
                              .parser(),
                          extensionRegistry);
                  if (dataPointsBuilder_ == null) {
                    ensureDataPointsIsMutable();
                    dataPoints_.add(m);
                  } else {
                    dataPointsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>
          dataPoints_ = java.util.Collections.emptyList();

      private void ensureDataPointsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dataPoints_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>(
                  dataPoints_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder>
          dataPointsBuilder_;

      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>
          getDataPointsList() {
        if (dataPointsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dataPoints_);
        } else {
          return dataPointsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public int getDataPointsCount() {
        if (dataPointsBuilder_ == null) {
          return dataPoints_.size();
        } else {
          return dataPointsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint getDataPoints(
          int index) {
        if (dataPointsBuilder_ == null) {
          return dataPoints_.get(index);
        } else {
          return dataPointsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder setDataPoints(
          int index, com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint value) {
        if (dataPointsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataPointsIsMutable();
          dataPoints_.set(index, value);
          onChanged();
        } else {
          dataPointsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder setDataPoints(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
              builderForValue) {
        if (dataPointsBuilder_ == null) {
          ensureDataPointsIsMutable();
          dataPoints_.set(index, builderForValue.build());
          onChanged();
        } else {
          dataPointsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder addDataPoints(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint value) {
        if (dataPointsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataPointsIsMutable();
          dataPoints_.add(value);
          onChanged();
        } else {
          dataPointsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder addDataPoints(
          int index, com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint value) {
        if (dataPointsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataPointsIsMutable();
          dataPoints_.add(index, value);
          onChanged();
        } else {
          dataPointsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder addDataPoints(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
              builderForValue) {
        if (dataPointsBuilder_ == null) {
          ensureDataPointsIsMutable();
          dataPoints_.add(builderForValue.build());
          onChanged();
        } else {
          dataPointsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder addDataPoints(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
              builderForValue) {
        if (dataPointsBuilder_ == null) {
          ensureDataPointsIsMutable();
          dataPoints_.add(index, builderForValue.build());
          onChanged();
        } else {
          dataPointsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder addAllDataPoints(
          java.lang.Iterable<
                  ? extends com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint>
              values) {
        if (dataPointsBuilder_ == null) {
          ensureDataPointsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataPoints_);
          onChanged();
        } else {
          dataPointsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder clearDataPoints() {
        if (dataPointsBuilder_ == null) {
          dataPoints_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dataPointsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public Builder removeDataPoints(int index) {
        if (dataPointsBuilder_ == null) {
          ensureDataPointsIsMutable();
          dataPoints_.remove(index);
          onChanged();
        } else {
          dataPointsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
          getDataPointsBuilder(int index) {
        return getDataPointsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder
          getDataPointsOrBuilder(int index) {
        if (dataPointsBuilder_ == null) {
          return dataPoints_.get(index);
        } else {
          return dataPointsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder>
          getDataPointsOrBuilderList() {
        if (dataPointsBuilder_ != null) {
          return dataPointsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dataPoints_);
        }
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
          addDataPointsBuilder() {
        return getDataPointsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder
          addDataPointsBuilder(int index) {
        return getDataPointsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Each data point in the chart is represented as a name-value pair
       * with the name being the x-axis label, and the value being the y-axis
       * value.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint data_points = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder>
          getDataPointsBuilderList() {
        return getDataPointsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder>
          getDataPointsFieldBuilder() {
        if (dataPointsBuilder_ == null) {
          dataPointsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPointOrBuilder>(
                  dataPoints_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          dataPoints_ = null;
        }
        return dataPointsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.ChartData)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.ChartData)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.ChartData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportSummary.ChartData();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ChartData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChartData> PARSER =
        new com.google.protobuf.AbstractParser<ChartData>() {
          @java.lang.Override
          public ChartData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChartData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChartData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UtilizationChartDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Aggregate value which falls into the "Used" bucket.
     * </pre>
     *
     * <code>int64 used = 1;</code>
     *
     * @return The used.
     */
    long getUsed();

    /**
     *
     *
     * <pre>
     * Aggregate value which falls into the "Free" bucket.
     * </pre>
     *
     * <code>int64 free = 2;</code>
     *
     * @return The free.
     */
    long getFree();
  }
  /**
   *
   *
   * <pre>
   * Utilization Chart is a specific type of visualization which displays
   * a metric classified into "Used" and "Free" buckets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData}
   */
  public static final class UtilizationChartData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData)
      UtilizationChartDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UtilizationChartData.newBuilder() to construct.
    private UtilizationChartData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UtilizationChartData() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UtilizationChartData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_UtilizationChartData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_UtilizationChartData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder.class);
    }

    public static final int USED_FIELD_NUMBER = 1;
    private long used_ = 0L;
    /**
     *
     *
     * <pre>
     * Aggregate value which falls into the "Used" bucket.
     * </pre>
     *
     * <code>int64 used = 1;</code>
     *
     * @return The used.
     */
    @java.lang.Override
    public long getUsed() {
      return used_;
    }

    public static final int FREE_FIELD_NUMBER = 2;
    private long free_ = 0L;
    /**
     *
     *
     * <pre>
     * Aggregate value which falls into the "Free" bucket.
     * </pre>
     *
     * <code>int64 free = 2;</code>
     *
     * @return The free.
     */
    @java.lang.Override
    public long getFree() {
      return free_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (used_ != 0L) {
        output.writeInt64(1, used_);
      }
      if (free_ != 0L) {
        output.writeInt64(2, free_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (used_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, used_);
      }
      if (free_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, free_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData) obj;

      if (getUsed() != other.getUsed()) return false;
      if (getFree() != other.getFree()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUsed());
      hash = (37 * hash) + FREE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFree());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Utilization Chart is a specific type of visualization which displays
     * a metric classified into "Used" and "Free" buckets.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData)
        com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_UtilizationChartData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_UtilizationChartData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        used_ = 0L;
        free_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_UtilizationChartData_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.used_ = used_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.free_ = free_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                .getDefaultInstance()) return this;
        if (other.getUsed() != 0L) {
          setUsed(other.getUsed());
        }
        if (other.getFree() != 0L) {
          setFree(other.getFree());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  used_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  free_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long used_;
      /**
       *
       *
       * <pre>
       * Aggregate value which falls into the "Used" bucket.
       * </pre>
       *
       * <code>int64 used = 1;</code>
       *
       * @return The used.
       */
      @java.lang.Override
      public long getUsed() {
        return used_;
      }
      /**
       *
       *
       * <pre>
       * Aggregate value which falls into the "Used" bucket.
       * </pre>
       *
       * <code>int64 used = 1;</code>
       *
       * @param value The used to set.
       * @return This builder for chaining.
       */
      public Builder setUsed(long value) {

        used_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Aggregate value which falls into the "Used" bucket.
       * </pre>
       *
       * <code>int64 used = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsed() {
        bitField0_ = (bitField0_ & ~0x00000001);
        used_ = 0L;
        onChanged();
        return this;
      }

      private long free_;
      /**
       *
       *
       * <pre>
       * Aggregate value which falls into the "Free" bucket.
       * </pre>
       *
       * <code>int64 free = 2;</code>
       *
       * @return The free.
       */
      @java.lang.Override
      public long getFree() {
        return free_;
      }
      /**
       *
       *
       * <pre>
       * Aggregate value which falls into the "Free" bucket.
       * </pre>
       *
       * <code>int64 free = 2;</code>
       *
       * @param value The free to set.
       * @return This builder for chaining.
       */
      public Builder setFree(long value) {

        free_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Aggregate value which falls into the "Free" bucket.
       * </pre>
       *
       * <code>int64 free = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFree() {
        bitField0_ = (bitField0_ & ~0x00000002);
        free_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UtilizationChartData> PARSER =
        new com.google.protobuf.AbstractParser<UtilizationChartData>() {
          @java.lang.Override
          public UtilizationChartData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UtilizationChartData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UtilizationChartData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HistogramChartDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>
        getBucketsList();
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket getBuckets(
        int index);
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    int getBucketsCount();
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                    .BucketOrBuilder>
        getBucketsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.BucketOrBuilder
        getBucketsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A Histogram Chart shows a distribution of values into buckets, showing
   * a count of values which fall into a bucket.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData}
   */
  public static final class HistogramChartData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData)
      HistogramChartDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HistogramChartData.newBuilder() to construct.
    private HistogramChartData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HistogramChartData() {
      buckets_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HistogramChartData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder.class);
    }

    public interface BucketOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Lower bound - inclusive.
       * </pre>
       *
       * <code>int64 lower_bound = 1;</code>
       *
       * @return The lowerBound.
       */
      long getLowerBound();

      /**
       *
       *
       * <pre>
       * Upper bound - exclusive.
       * </pre>
       *
       * <code>int64 upper_bound = 2;</code>
       *
       * @return The upperBound.
       */
      long getUpperBound();

      /**
       *
       *
       * <pre>
       * Count of items in the bucket.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      long getCount();
    }
    /**
     *
     *
     * <pre>
     * A histogram bucket with a lower and upper bound, and a count of items
     * with a field value between those bounds.
     * The lower bound is inclusive and the upper bound is exclusive.
     * Lower bound may be -infinity and upper bound may be infinity.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket}
     */
    public static final class Bucket extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)
        BucketOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Bucket.newBuilder() to construct.
      private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Bucket() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Bucket();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_Bucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_Bucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
                    .class);
      }

      public static final int LOWER_BOUND_FIELD_NUMBER = 1;
      private long lowerBound_ = 0L;
      /**
       *
       *
       * <pre>
       * Lower bound - inclusive.
       * </pre>
       *
       * <code>int64 lower_bound = 1;</code>
       *
       * @return The lowerBound.
       */
      @java.lang.Override
      public long getLowerBound() {
        return lowerBound_;
      }

      public static final int UPPER_BOUND_FIELD_NUMBER = 2;
      private long upperBound_ = 0L;
      /**
       *
       *
       * <pre>
       * Upper bound - exclusive.
       * </pre>
       *
       * <code>int64 upper_bound = 2;</code>
       *
       * @return The upperBound.
       */
      @java.lang.Override
      public long getUpperBound() {
        return upperBound_;
      }

      public static final int COUNT_FIELD_NUMBER = 3;
      private long count_ = 0L;
      /**
       *
       *
       * <pre>
       * Count of items in the bucket.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (lowerBound_ != 0L) {
          output.writeInt64(1, lowerBound_);
        }
        if (upperBound_ != 0L) {
          output.writeInt64(2, upperBound_);
        }
        if (count_ != 0L) {
          output.writeInt64(3, count_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (lowerBound_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, lowerBound_);
        }
        if (upperBound_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, upperBound_);
        }
        if (count_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, count_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)) {
          return super.equals(obj);
        }
        com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket other =
            (com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket) obj;

        if (getLowerBound() != other.getLowerBound()) return false;
        if (getUpperBound() != other.getUpperBound()) return false;
        if (getCount() != other.getCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLowerBound());
        hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUpperBound());
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A histogram bucket with a lower and upper bound, and a count of items
       * with a field value between those bounds.
       * The lower bound is inclusive and the upper bound is exclusive.
       * Lower bound may be -infinity and upper bound may be infinity.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.BucketOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_Bucket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_Bucket_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.class,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          lowerBound_ = 0L;
          upperBound_ = 0L;
          count_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_Bucket_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
            getDefaultInstanceForType() {
          return com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket build() {
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
            buildPartial() {
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket result =
              new com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.lowerBound_ = lowerBound_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.upperBound_ = upperBound_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.count_ = count_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket) {
            return mergeFrom(
                (com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket other) {
          if (other
              == com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
                  .getDefaultInstance()) return this;
          if (other.getLowerBound() != 0L) {
            setLowerBound(other.getLowerBound());
          }
          if (other.getUpperBound() != 0L) {
            setUpperBound(other.getUpperBound());
          }
          if (other.getCount() != 0L) {
            setCount(other.getCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    lowerBound_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    upperBound_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    count_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long lowerBound_;
        /**
         *
         *
         * <pre>
         * Lower bound - inclusive.
         * </pre>
         *
         * <code>int64 lower_bound = 1;</code>
         *
         * @return The lowerBound.
         */
        @java.lang.Override
        public long getLowerBound() {
          return lowerBound_;
        }
        /**
         *
         *
         * <pre>
         * Lower bound - inclusive.
         * </pre>
         *
         * <code>int64 lower_bound = 1;</code>
         *
         * @param value The lowerBound to set.
         * @return This builder for chaining.
         */
        public Builder setLowerBound(long value) {

          lowerBound_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Lower bound - inclusive.
         * </pre>
         *
         * <code>int64 lower_bound = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLowerBound() {
          bitField0_ = (bitField0_ & ~0x00000001);
          lowerBound_ = 0L;
          onChanged();
          return this;
        }

        private long upperBound_;
        /**
         *
         *
         * <pre>
         * Upper bound - exclusive.
         * </pre>
         *
         * <code>int64 upper_bound = 2;</code>
         *
         * @return The upperBound.
         */
        @java.lang.Override
        public long getUpperBound() {
          return upperBound_;
        }
        /**
         *
         *
         * <pre>
         * Upper bound - exclusive.
         * </pre>
         *
         * <code>int64 upper_bound = 2;</code>
         *
         * @param value The upperBound to set.
         * @return This builder for chaining.
         */
        public Builder setUpperBound(long value) {

          upperBound_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Upper bound - exclusive.
         * </pre>
         *
         * <code>int64 upper_bound = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUpperBound() {
          bitField0_ = (bitField0_ & ~0x00000002);
          upperBound_ = 0L;
          onChanged();
          return this;
        }

        private long count_;
        /**
         *
         *
         * <pre>
         * Count of items in the bucket.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return The count.
         */
        @java.lang.Override
        public long getCount() {
          return count_;
        }
        /**
         *
         *
         * <pre>
         * Count of items in the bucket.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(long value) {

          count_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Count of items in the bucket.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          count_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket)
      private static final com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .Bucket
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket();
      }

      public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Bucket> PARSER =
          new com.google.protobuf.AbstractParser<Bucket>() {
            @java.lang.Override
            public Bucket parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Bucket> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Bucket> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int BUCKETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>
        buckets_;
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>
        getBucketsList() {
      return buckets_;
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                    .BucketOrBuilder>
        getBucketsOrBuilderList() {
      return buckets_;
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public int getBucketsCount() {
      return buckets_.size();
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket getBuckets(
        int index) {
      return buckets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.BucketOrBuilder
        getBucketsOrBuilder(int index) {
      return buckets_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < buckets_.size(); i++) {
        output.writeMessage(1, buckets_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < buckets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, buckets_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData) obj;

      if (!getBucketsList().equals(other.getBucketsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getBucketsCount() > 0) {
        hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getBucketsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Histogram Chart shows a distribution of values into buckets, showing
     * a count of values which fall into a bucket.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData)
        com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder.class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (bucketsBuilder_ == null) {
          buckets_ = java.util.Collections.emptyList();
        } else {
          buckets_ = null;
          bucketsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_HistogramChartData_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData result) {
        if (bucketsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            buckets_ = java.util.Collections.unmodifiableList(buckets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.buckets_ = buckets_;
        } else {
          result.buckets_ = bucketsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                .getDefaultInstance()) return this;
        if (bucketsBuilder_ == null) {
          if (!other.buckets_.isEmpty()) {
            if (buckets_.isEmpty()) {
              buckets_ = other.buckets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBucketsIsMutable();
              buckets_.addAll(other.buckets_);
            }
            onChanged();
          }
        } else {
          if (!other.buckets_.isEmpty()) {
            if (bucketsBuilder_.isEmpty()) {
              bucketsBuilder_.dispose();
              bucketsBuilder_ = null;
              buckets_ = other.buckets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              bucketsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getBucketsFieldBuilder()
                      : null;
            } else {
              bucketsBuilder_.addAllMessages(other.buckets_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                              .Bucket.parser(),
                          extensionRegistry);
                  if (bucketsBuilder_ == null) {
                    ensureBucketsIsMutable();
                    buckets_.add(m);
                  } else {
                    bucketsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>
          buckets_ = java.util.Collections.emptyList();

      private void ensureBucketsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          buckets_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>(
                  buckets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.BucketOrBuilder>
          bucketsBuilder_;

      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>
          getBucketsList() {
        if (bucketsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(buckets_);
        } else {
          return bucketsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public int getBucketsCount() {
        if (bucketsBuilder_ == null) {
          return buckets_.size();
        } else {
          return bucketsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket getBuckets(
          int index) {
        if (bucketsBuilder_ == null) {
          return buckets_.get(index);
        } else {
          return bucketsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder setBuckets(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket value) {
        if (bucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketsIsMutable();
          buckets_.set(index, value);
          onChanged();
        } else {
          bucketsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder setBuckets(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
              builderForValue) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.set(index, builderForValue.build());
          onChanged();
        } else {
          bucketsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket value) {
        if (bucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketsIsMutable();
          buckets_.add(value);
          onChanged();
        } else {
          bucketsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket value) {
        if (bucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketsIsMutable();
          buckets_.add(index, value);
          onChanged();
        } else {
          bucketsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
              builderForValue) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.add(builderForValue.build());
          onChanged();
        } else {
          bucketsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
              builderForValue) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.add(index, builderForValue.build());
          onChanged();
        } else {
          bucketsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder addAllBuckets(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket>
              values) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buckets_);
          onChanged();
        } else {
          bucketsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder clearBuckets() {
        if (bucketsBuilder_ == null) {
          buckets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          bucketsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public Builder removeBuckets(int index) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.remove(index);
          onChanged();
        } else {
          bucketsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
          getBucketsBuilder(int index) {
        return getBucketsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.BucketOrBuilder
          getBucketsOrBuilder(int index) {
        if (bucketsBuilder_ == null) {
          return buckets_.get(index);
        } else {
          return bucketsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                      .BucketOrBuilder>
          getBucketsOrBuilderList() {
        if (bucketsBuilder_ != null) {
          return bucketsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(buckets_);
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
          addBucketsBuilder() {
        return getBucketsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder
          addBucketsBuilder(int index) {
        return getBucketsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket buckets = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder>
          getBucketsBuilderList() {
        return getBucketsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.BucketOrBuilder>
          getBucketsFieldBuilder() {
        if (bucketsBuilder_ == null) {
          bucketsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
                      .Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                      .BucketOrBuilder>(
                  buckets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          buckets_ = null;
        }
        return bucketsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HistogramChartData> PARSER =
        new com.google.protobuf.AbstractParser<HistogramChartData>() {
          @java.lang.Override
          public HistogramChartData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HistogramChartData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HistogramChartData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AssetAggregateStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Sum of the memory in bytes of all the assets in this collection.
     * </pre>
     *
     * <code>int64 total_memory_bytes = 1;</code>
     *
     * @return The totalMemoryBytes.
     */
    long getTotalMemoryBytes();

    /**
     *
     *
     * <pre>
     * Sum of persistent storage in bytes of all the assets in this collection.
     * </pre>
     *
     * <code>int64 total_storage_bytes = 2;</code>
     *
     * @return The totalStorageBytes.
     */
    long getTotalStorageBytes();

    /**
     *
     *
     * <pre>
     * Sum of the CPU core count of all the assets in this collection.
     * </pre>
     *
     * <code>int64 total_cores = 3;</code>
     *
     * @return The totalCores.
     */
    long getTotalCores();

    /**
     *
     *
     * <pre>
     * Count of the number of unique assets in this collection.
     * </pre>
     *
     * <code>int64 total_assets = 4;</code>
     *
     * @return The totalAssets.
     */
    long getTotalAssets();

    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
     * </code>
     *
     * @return Whether the memoryUtilizationChart field is set.
     */
    boolean hasMemoryUtilizationChart();
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
     * </code>
     *
     * @return The memoryUtilizationChart.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        getMemoryUtilizationChart();
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder
        getMemoryUtilizationChartOrBuilder();

    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
     * </code>
     *
     * @return Whether the storageUtilizationChart field is set.
     */
    boolean hasStorageUtilizationChart();
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
     * </code>
     *
     * @return The storageUtilizationChart.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        getStorageUtilizationChart();
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder
        getStorageUtilizationChartOrBuilder();

    /**
     *
     *
     * <pre>
     * Count of assets grouped by Operating System families.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
     *
     * @return Whether the operatingSystem field is set.
     */
    boolean hasOperatingSystem();
    /**
     *
     *
     * <pre>
     * Count of assets grouped by Operating System families.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
     *
     * @return The operatingSystem.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.ChartData getOperatingSystem();
    /**
     *
     *
     * <pre>
     * Count of assets grouped by Operating System families.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder
        getOperatingSystemOrBuilder();

    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of CPU core counts.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
     * </code>
     *
     * @return Whether the coreCountHistogram field is set.
     */
    boolean hasCoreCountHistogram();
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of CPU core counts.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
     * </code>
     *
     * @return The coreCountHistogram.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData getCoreCountHistogram();
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of CPU core counts.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
        getCoreCountHistogramOrBuilder();

    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
     * </code>
     *
     * @return Whether the memoryBytesHistogram field is set.
     */
    boolean hasMemoryBytesHistogram();
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
     * </code>
     *
     * @return The memoryBytesHistogram.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData getMemoryBytesHistogram();
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
        getMemoryBytesHistogramOrBuilder();

    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
     * </code>
     *
     * @return Whether the storageBytesHistogram field is set.
     */
    boolean hasStorageBytesHistogram();
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
     * </code>
     *
     * @return The storageBytesHistogram.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData getStorageBytesHistogram();
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
        getStorageBytesHistogramOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Aggregate statistics for a collection of assets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats}
   */
  public static final class AssetAggregateStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats)
      AssetAggregateStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AssetAggregateStats.newBuilder() to construct.
    private AssetAggregateStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AssetAggregateStats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AssetAggregateStats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_AssetAggregateStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_AssetAggregateStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder.class);
    }

    public static final int TOTAL_MEMORY_BYTES_FIELD_NUMBER = 1;
    private long totalMemoryBytes_ = 0L;
    /**
     *
     *
     * <pre>
     * Sum of the memory in bytes of all the assets in this collection.
     * </pre>
     *
     * <code>int64 total_memory_bytes = 1;</code>
     *
     * @return The totalMemoryBytes.
     */
    @java.lang.Override
    public long getTotalMemoryBytes() {
      return totalMemoryBytes_;
    }

    public static final int TOTAL_STORAGE_BYTES_FIELD_NUMBER = 2;
    private long totalStorageBytes_ = 0L;
    /**
     *
     *
     * <pre>
     * Sum of persistent storage in bytes of all the assets in this collection.
     * </pre>
     *
     * <code>int64 total_storage_bytes = 2;</code>
     *
     * @return The totalStorageBytes.
     */
    @java.lang.Override
    public long getTotalStorageBytes() {
      return totalStorageBytes_;
    }

    public static final int TOTAL_CORES_FIELD_NUMBER = 3;
    private long totalCores_ = 0L;
    /**
     *
     *
     * <pre>
     * Sum of the CPU core count of all the assets in this collection.
     * </pre>
     *
     * <code>int64 total_cores = 3;</code>
     *
     * @return The totalCores.
     */
    @java.lang.Override
    public long getTotalCores() {
      return totalCores_;
    }

    public static final int TOTAL_ASSETS_FIELD_NUMBER = 4;
    private long totalAssets_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of the number of unique assets in this collection.
     * </pre>
     *
     * <code>int64 total_assets = 4;</code>
     *
     * @return The totalAssets.
     */
    @java.lang.Override
    public long getTotalAssets() {
      return totalAssets_;
    }

    public static final int MEMORY_UTILIZATION_CHART_FIELD_NUMBER = 5;
    private com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        memoryUtilizationChart_;
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
     * </code>
     *
     * @return Whether the memoryUtilizationChart field is set.
     */
    @java.lang.Override
    public boolean hasMemoryUtilizationChart() {
      return memoryUtilizationChart_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
     * </code>
     *
     * @return The memoryUtilizationChart.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        getMemoryUtilizationChart() {
      return memoryUtilizationChart_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
              .getDefaultInstance()
          : memoryUtilizationChart_;
    }
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder
        getMemoryUtilizationChartOrBuilder() {
      return memoryUtilizationChart_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
              .getDefaultInstance()
          : memoryUtilizationChart_;
    }

    public static final int STORAGE_UTILIZATION_CHART_FIELD_NUMBER = 6;
    private com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        storageUtilizationChart_;
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
     * </code>
     *
     * @return Whether the storageUtilizationChart field is set.
     */
    @java.lang.Override
    public boolean hasStorageUtilizationChart() {
      return storageUtilizationChart_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
     * </code>
     *
     * @return The storageUtilizationChart.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
        getStorageUtilizationChart() {
      return storageUtilizationChart_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
              .getDefaultInstance()
          : storageUtilizationChart_;
    }
    /**
     *
     *
     * <pre>
     * Total memory split into Used/Free buckets.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder
        getStorageUtilizationChartOrBuilder() {
      return storageUtilizationChart_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
              .getDefaultInstance()
          : storageUtilizationChart_;
    }

    public static final int OPERATING_SYSTEM_FIELD_NUMBER = 7;
    private com.google.cloud.migrationcenter.v1.ReportSummary.ChartData operatingSystem_;
    /**
     *
     *
     * <pre>
     * Count of assets grouped by Operating System families.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
     *
     * @return Whether the operatingSystem field is set.
     */
    @java.lang.Override
    public boolean hasOperatingSystem() {
      return operatingSystem_ != null;
    }
    /**
     *
     *
     * <pre>
     * Count of assets grouped by Operating System families.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
     *
     * @return The operatingSystem.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData getOperatingSystem() {
      return operatingSystem_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.getDefaultInstance()
          : operatingSystem_;
    }
    /**
     *
     *
     * <pre>
     * Count of assets grouped by Operating System families.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder
        getOperatingSystemOrBuilder() {
      return operatingSystem_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.getDefaultInstance()
          : operatingSystem_;
    }

    public static final int CORE_COUNT_HISTOGRAM_FIELD_NUMBER = 8;
    private com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        coreCountHistogram_;
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of CPU core counts.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
     * </code>
     *
     * @return Whether the coreCountHistogram field is set.
     */
    @java.lang.Override
    public boolean hasCoreCountHistogram() {
      return coreCountHistogram_ != null;
    }
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of CPU core counts.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
     * </code>
     *
     * @return The coreCountHistogram.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        getCoreCountHistogram() {
      return coreCountHistogram_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .getDefaultInstance()
          : coreCountHistogram_;
    }
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of CPU core counts.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
        getCoreCountHistogramOrBuilder() {
      return coreCountHistogram_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .getDefaultInstance()
          : coreCountHistogram_;
    }

    public static final int MEMORY_BYTES_HISTOGRAM_FIELD_NUMBER = 9;
    private com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        memoryBytesHistogram_;
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
     * </code>
     *
     * @return Whether the memoryBytesHistogram field is set.
     */
    @java.lang.Override
    public boolean hasMemoryBytesHistogram() {
      return memoryBytesHistogram_ != null;
    }
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
     * </code>
     *
     * @return The memoryBytesHistogram.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        getMemoryBytesHistogram() {
      return memoryBytesHistogram_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .getDefaultInstance()
          : memoryBytesHistogram_;
    }
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
        getMemoryBytesHistogramOrBuilder() {
      return memoryBytesHistogram_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .getDefaultInstance()
          : memoryBytesHistogram_;
    }

    public static final int STORAGE_BYTES_HISTOGRAM_FIELD_NUMBER = 10;
    private com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        storageBytesHistogram_;
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
     * </code>
     *
     * @return Whether the storageBytesHistogram field is set.
     */
    @java.lang.Override
    public boolean hasStorageBytesHistogram() {
      return storageBytesHistogram_ != null;
    }
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
     * </code>
     *
     * @return The storageBytesHistogram.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
        getStorageBytesHistogram() {
      return storageBytesHistogram_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .getDefaultInstance()
          : storageBytesHistogram_;
    }
    /**
     *
     *
     * <pre>
     * Histogram showing a distribution of memory sizes.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
        getStorageBytesHistogramOrBuilder() {
      return storageBytesHistogram_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
              .getDefaultInstance()
          : storageBytesHistogram_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (totalMemoryBytes_ != 0L) {
        output.writeInt64(1, totalMemoryBytes_);
      }
      if (totalStorageBytes_ != 0L) {
        output.writeInt64(2, totalStorageBytes_);
      }
      if (totalCores_ != 0L) {
        output.writeInt64(3, totalCores_);
      }
      if (totalAssets_ != 0L) {
        output.writeInt64(4, totalAssets_);
      }
      if (memoryUtilizationChart_ != null) {
        output.writeMessage(5, getMemoryUtilizationChart());
      }
      if (storageUtilizationChart_ != null) {
        output.writeMessage(6, getStorageUtilizationChart());
      }
      if (operatingSystem_ != null) {
        output.writeMessage(7, getOperatingSystem());
      }
      if (coreCountHistogram_ != null) {
        output.writeMessage(8, getCoreCountHistogram());
      }
      if (memoryBytesHistogram_ != null) {
        output.writeMessage(9, getMemoryBytesHistogram());
      }
      if (storageBytesHistogram_ != null) {
        output.writeMessage(10, getStorageBytesHistogram());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (totalMemoryBytes_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, totalMemoryBytes_);
      }
      if (totalStorageBytes_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, totalStorageBytes_);
      }
      if (totalCores_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, totalCores_);
      }
      if (totalAssets_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, totalAssets_);
      }
      if (memoryUtilizationChart_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, getMemoryUtilizationChart());
      }
      if (storageUtilizationChart_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, getStorageUtilizationChart());
      }
      if (operatingSystem_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOperatingSystem());
      }
      if (coreCountHistogram_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCoreCountHistogram());
      }
      if (memoryBytesHistogram_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMemoryBytesHistogram());
      }
      if (storageBytesHistogram_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, getStorageBytesHistogram());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats) obj;

      if (getTotalMemoryBytes() != other.getTotalMemoryBytes()) return false;
      if (getTotalStorageBytes() != other.getTotalStorageBytes()) return false;
      if (getTotalCores() != other.getTotalCores()) return false;
      if (getTotalAssets() != other.getTotalAssets()) return false;
      if (hasMemoryUtilizationChart() != other.hasMemoryUtilizationChart()) return false;
      if (hasMemoryUtilizationChart()) {
        if (!getMemoryUtilizationChart().equals(other.getMemoryUtilizationChart())) return false;
      }
      if (hasStorageUtilizationChart() != other.hasStorageUtilizationChart()) return false;
      if (hasStorageUtilizationChart()) {
        if (!getStorageUtilizationChart().equals(other.getStorageUtilizationChart())) return false;
      }
      if (hasOperatingSystem() != other.hasOperatingSystem()) return false;
      if (hasOperatingSystem()) {
        if (!getOperatingSystem().equals(other.getOperatingSystem())) return false;
      }
      if (hasCoreCountHistogram() != other.hasCoreCountHistogram()) return false;
      if (hasCoreCountHistogram()) {
        if (!getCoreCountHistogram().equals(other.getCoreCountHistogram())) return false;
      }
      if (hasMemoryBytesHistogram() != other.hasMemoryBytesHistogram()) return false;
      if (hasMemoryBytesHistogram()) {
        if (!getMemoryBytesHistogram().equals(other.getMemoryBytesHistogram())) return false;
      }
      if (hasStorageBytesHistogram() != other.hasStorageBytesHistogram()) return false;
      if (hasStorageBytesHistogram()) {
        if (!getStorageBytesHistogram().equals(other.getStorageBytesHistogram())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOTAL_MEMORY_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalMemoryBytes());
      hash = (37 * hash) + TOTAL_STORAGE_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalStorageBytes());
      hash = (37 * hash) + TOTAL_CORES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalCores());
      hash = (37 * hash) + TOTAL_ASSETS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalAssets());
      if (hasMemoryUtilizationChart()) {
        hash = (37 * hash) + MEMORY_UTILIZATION_CHART_FIELD_NUMBER;
        hash = (53 * hash) + getMemoryUtilizationChart().hashCode();
      }
      if (hasStorageUtilizationChart()) {
        hash = (37 * hash) + STORAGE_UTILIZATION_CHART_FIELD_NUMBER;
        hash = (53 * hash) + getStorageUtilizationChart().hashCode();
      }
      if (hasOperatingSystem()) {
        hash = (37 * hash) + OPERATING_SYSTEM_FIELD_NUMBER;
        hash = (53 * hash) + getOperatingSystem().hashCode();
      }
      if (hasCoreCountHistogram()) {
        hash = (37 * hash) + CORE_COUNT_HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getCoreCountHistogram().hashCode();
      }
      if (hasMemoryBytesHistogram()) {
        hash = (37 * hash) + MEMORY_BYTES_HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getMemoryBytesHistogram().hashCode();
      }
      if (hasStorageBytesHistogram()) {
        hash = (37 * hash) + STORAGE_BYTES_HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getStorageBytesHistogram().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for a collection of assets.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats)
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_AssetAggregateStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_AssetAggregateStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        totalMemoryBytes_ = 0L;
        totalStorageBytes_ = 0L;
        totalCores_ = 0L;
        totalAssets_ = 0L;
        memoryUtilizationChart_ = null;
        if (memoryUtilizationChartBuilder_ != null) {
          memoryUtilizationChartBuilder_.dispose();
          memoryUtilizationChartBuilder_ = null;
        }
        storageUtilizationChart_ = null;
        if (storageUtilizationChartBuilder_ != null) {
          storageUtilizationChartBuilder_.dispose();
          storageUtilizationChartBuilder_ = null;
        }
        operatingSystem_ = null;
        if (operatingSystemBuilder_ != null) {
          operatingSystemBuilder_.dispose();
          operatingSystemBuilder_ = null;
        }
        coreCountHistogram_ = null;
        if (coreCountHistogramBuilder_ != null) {
          coreCountHistogramBuilder_.dispose();
          coreCountHistogramBuilder_ = null;
        }
        memoryBytesHistogram_ = null;
        if (memoryBytesHistogramBuilder_ != null) {
          memoryBytesHistogramBuilder_.dispose();
          memoryBytesHistogramBuilder_ = null;
        }
        storageBytesHistogram_ = null;
        if (storageBytesHistogramBuilder_ != null) {
          storageBytesHistogramBuilder_.dispose();
          storageBytesHistogramBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_AssetAggregateStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.totalMemoryBytes_ = totalMemoryBytes_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.totalStorageBytes_ = totalStorageBytes_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.totalCores_ = totalCores_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.totalAssets_ = totalAssets_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.memoryUtilizationChart_ =
              memoryUtilizationChartBuilder_ == null
                  ? memoryUtilizationChart_
                  : memoryUtilizationChartBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.storageUtilizationChart_ =
              storageUtilizationChartBuilder_ == null
                  ? storageUtilizationChart_
                  : storageUtilizationChartBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.operatingSystem_ =
              operatingSystemBuilder_ == null ? operatingSystem_ : operatingSystemBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.coreCountHistogram_ =
              coreCountHistogramBuilder_ == null
                  ? coreCountHistogram_
                  : coreCountHistogramBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.memoryBytesHistogram_ =
              memoryBytesHistogramBuilder_ == null
                  ? memoryBytesHistogram_
                  : memoryBytesHistogramBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.storageBytesHistogram_ =
              storageBytesHistogramBuilder_ == null
                  ? storageBytesHistogram_
                  : storageBytesHistogramBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                .getDefaultInstance()) return this;
        if (other.getTotalMemoryBytes() != 0L) {
          setTotalMemoryBytes(other.getTotalMemoryBytes());
        }
        if (other.getTotalStorageBytes() != 0L) {
          setTotalStorageBytes(other.getTotalStorageBytes());
        }
        if (other.getTotalCores() != 0L) {
          setTotalCores(other.getTotalCores());
        }
        if (other.getTotalAssets() != 0L) {
          setTotalAssets(other.getTotalAssets());
        }
        if (other.hasMemoryUtilizationChart()) {
          mergeMemoryUtilizationChart(other.getMemoryUtilizationChart());
        }
        if (other.hasStorageUtilizationChart()) {
          mergeStorageUtilizationChart(other.getStorageUtilizationChart());
        }
        if (other.hasOperatingSystem()) {
          mergeOperatingSystem(other.getOperatingSystem());
        }
        if (other.hasCoreCountHistogram()) {
          mergeCoreCountHistogram(other.getCoreCountHistogram());
        }
        if (other.hasMemoryBytesHistogram()) {
          mergeMemoryBytesHistogram(other.getMemoryBytesHistogram());
        }
        if (other.hasStorageBytesHistogram()) {
          mergeStorageBytesHistogram(other.getStorageBytesHistogram());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  totalMemoryBytes_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  totalStorageBytes_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  totalCores_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  totalAssets_ = input.readInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getMemoryUtilizationChartFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getStorageUtilizationChartFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getOperatingSystemFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getCoreCountHistogramFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getMemoryBytesHistogramFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(
                      getStorageBytesHistogramFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long totalMemoryBytes_;
      /**
       *
       *
       * <pre>
       * Sum of the memory in bytes of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_memory_bytes = 1;</code>
       *
       * @return The totalMemoryBytes.
       */
      @java.lang.Override
      public long getTotalMemoryBytes() {
        return totalMemoryBytes_;
      }
      /**
       *
       *
       * <pre>
       * Sum of the memory in bytes of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_memory_bytes = 1;</code>
       *
       * @param value The totalMemoryBytes to set.
       * @return This builder for chaining.
       */
      public Builder setTotalMemoryBytes(long value) {

        totalMemoryBytes_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the memory in bytes of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_memory_bytes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalMemoryBytes() {
        bitField0_ = (bitField0_ & ~0x00000001);
        totalMemoryBytes_ = 0L;
        onChanged();
        return this;
      }

      private long totalStorageBytes_;
      /**
       *
       *
       * <pre>
       * Sum of persistent storage in bytes of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_storage_bytes = 2;</code>
       *
       * @return The totalStorageBytes.
       */
      @java.lang.Override
      public long getTotalStorageBytes() {
        return totalStorageBytes_;
      }
      /**
       *
       *
       * <pre>
       * Sum of persistent storage in bytes of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_storage_bytes = 2;</code>
       *
       * @param value The totalStorageBytes to set.
       * @return This builder for chaining.
       */
      public Builder setTotalStorageBytes(long value) {

        totalStorageBytes_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of persistent storage in bytes of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_storage_bytes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalStorageBytes() {
        bitField0_ = (bitField0_ & ~0x00000002);
        totalStorageBytes_ = 0L;
        onChanged();
        return this;
      }

      private long totalCores_;
      /**
       *
       *
       * <pre>
       * Sum of the CPU core count of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_cores = 3;</code>
       *
       * @return The totalCores.
       */
      @java.lang.Override
      public long getTotalCores() {
        return totalCores_;
      }
      /**
       *
       *
       * <pre>
       * Sum of the CPU core count of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_cores = 3;</code>
       *
       * @param value The totalCores to set.
       * @return This builder for chaining.
       */
      public Builder setTotalCores(long value) {

        totalCores_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the CPU core count of all the assets in this collection.
       * </pre>
       *
       * <code>int64 total_cores = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalCores() {
        bitField0_ = (bitField0_ & ~0x00000004);
        totalCores_ = 0L;
        onChanged();
        return this;
      }

      private long totalAssets_;
      /**
       *
       *
       * <pre>
       * Count of the number of unique assets in this collection.
       * </pre>
       *
       * <code>int64 total_assets = 4;</code>
       *
       * @return The totalAssets.
       */
      @java.lang.Override
      public long getTotalAssets() {
        return totalAssets_;
      }
      /**
       *
       *
       * <pre>
       * Count of the number of unique assets in this collection.
       * </pre>
       *
       * <code>int64 total_assets = 4;</code>
       *
       * @param value The totalAssets to set.
       * @return This builder for chaining.
       */
      public Builder setTotalAssets(long value) {

        totalAssets_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of the number of unique assets in this collection.
       * </pre>
       *
       * <code>int64 total_assets = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalAssets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        totalAssets_ = 0L;
        onChanged();
        return this;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
          memoryUtilizationChart_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder>
          memoryUtilizationChartBuilder_;
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       *
       * @return Whether the memoryUtilizationChart field is set.
       */
      public boolean hasMemoryUtilizationChart() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       *
       * @return The memoryUtilizationChart.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
          getMemoryUtilizationChart() {
        if (memoryUtilizationChartBuilder_ == null) {
          return memoryUtilizationChart_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                  .getDefaultInstance()
              : memoryUtilizationChart_;
        } else {
          return memoryUtilizationChartBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      public Builder setMemoryUtilizationChart(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData value) {
        if (memoryUtilizationChartBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          memoryUtilizationChart_ = value;
        } else {
          memoryUtilizationChartBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      public Builder setMemoryUtilizationChart(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder
              builderForValue) {
        if (memoryUtilizationChartBuilder_ == null) {
          memoryUtilizationChart_ = builderForValue.build();
        } else {
          memoryUtilizationChartBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      public Builder mergeMemoryUtilizationChart(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData value) {
        if (memoryUtilizationChartBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && memoryUtilizationChart_ != null
              && memoryUtilizationChart_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                      .getDefaultInstance()) {
            getMemoryUtilizationChartBuilder().mergeFrom(value);
          } else {
            memoryUtilizationChart_ = value;
          }
        } else {
          memoryUtilizationChartBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      public Builder clearMemoryUtilizationChart() {
        bitField0_ = (bitField0_ & ~0x00000010);
        memoryUtilizationChart_ = null;
        if (memoryUtilizationChartBuilder_ != null) {
          memoryUtilizationChartBuilder_.dispose();
          memoryUtilizationChartBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder
          getMemoryUtilizationChartBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getMemoryUtilizationChartFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder
          getMemoryUtilizationChartOrBuilder() {
        if (memoryUtilizationChartBuilder_ != null) {
          return memoryUtilizationChartBuilder_.getMessageOrBuilder();
        } else {
          return memoryUtilizationChart_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                  .getDefaultInstance()
              : memoryUtilizationChart_;
        }
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData memory_utilization_chart = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder>
          getMemoryUtilizationChartFieldBuilder() {
        if (memoryUtilizationChartBuilder_ == null) {
          memoryUtilizationChartBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData,
                  com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder>(
                  getMemoryUtilizationChart(), getParentForChildren(), isClean());
          memoryUtilizationChart_ = null;
        }
        return memoryUtilizationChartBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
          storageUtilizationChart_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder>
          storageUtilizationChartBuilder_;
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       *
       * @return Whether the storageUtilizationChart field is set.
       */
      public boolean hasStorageUtilizationChart() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       *
       * @return The storageUtilizationChart.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
          getStorageUtilizationChart() {
        if (storageUtilizationChartBuilder_ == null) {
          return storageUtilizationChart_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                  .getDefaultInstance()
              : storageUtilizationChart_;
        } else {
          return storageUtilizationChartBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      public Builder setStorageUtilizationChart(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData value) {
        if (storageUtilizationChartBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          storageUtilizationChart_ = value;
        } else {
          storageUtilizationChartBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      public Builder setStorageUtilizationChart(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder
              builderForValue) {
        if (storageUtilizationChartBuilder_ == null) {
          storageUtilizationChart_ = builderForValue.build();
        } else {
          storageUtilizationChartBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      public Builder mergeStorageUtilizationChart(
          com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData value) {
        if (storageUtilizationChartBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && storageUtilizationChart_ != null
              && storageUtilizationChart_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                      .getDefaultInstance()) {
            getStorageUtilizationChartBuilder().mergeFrom(value);
          } else {
            storageUtilizationChart_ = value;
          }
        } else {
          storageUtilizationChartBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      public Builder clearStorageUtilizationChart() {
        bitField0_ = (bitField0_ & ~0x00000020);
        storageUtilizationChart_ = null;
        if (storageUtilizationChartBuilder_ != null) {
          storageUtilizationChartBuilder_.dispose();
          storageUtilizationChartBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder
          getStorageUtilizationChartBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getStorageUtilizationChartFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder
          getStorageUtilizationChartOrBuilder() {
        if (storageUtilizationChartBuilder_ != null) {
          return storageUtilizationChartBuilder_.getMessageOrBuilder();
        } else {
          return storageUtilizationChart_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
                  .getDefaultInstance()
              : storageUtilizationChart_;
        }
      }
      /**
       *
       *
       * <pre>
       * Total memory split into Used/Free buckets.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData storage_utilization_chart = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder>
          getStorageUtilizationChartFieldBuilder() {
        if (storageUtilizationChartBuilder_ == null) {
          storageUtilizationChartBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData,
                  com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartDataOrBuilder>(
                  getStorageUtilizationChart(), getParentForChildren(), isClean());
          storageUtilizationChart_ = null;
        }
        return storageUtilizationChartBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.ChartData operatingSystem_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder>
          operatingSystemBuilder_;
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       *
       * @return Whether the operatingSystem field is set.
       */
      public boolean hasOperatingSystem() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       *
       * @return The operatingSystem.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData getOperatingSystem() {
        if (operatingSystemBuilder_ == null) {
          return operatingSystem_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.getDefaultInstance()
              : operatingSystem_;
        } else {
          return operatingSystemBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      public Builder setOperatingSystem(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData value) {
        if (operatingSystemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operatingSystem_ = value;
        } else {
          operatingSystemBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      public Builder setOperatingSystem(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder builderForValue) {
        if (operatingSystemBuilder_ == null) {
          operatingSystem_ = builderForValue.build();
        } else {
          operatingSystemBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      public Builder mergeOperatingSystem(
          com.google.cloud.migrationcenter.v1.ReportSummary.ChartData value) {
        if (operatingSystemBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && operatingSystem_ != null
              && operatingSystem_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.ChartData
                      .getDefaultInstance()) {
            getOperatingSystemBuilder().mergeFrom(value);
          } else {
            operatingSystem_ = value;
          }
        } else {
          operatingSystemBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      public Builder clearOperatingSystem() {
        bitField0_ = (bitField0_ & ~0x00000040);
        operatingSystem_ = null;
        if (operatingSystemBuilder_ != null) {
          operatingSystemBuilder_.dispose();
          operatingSystemBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder
          getOperatingSystemBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getOperatingSystemFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder
          getOperatingSystemOrBuilder() {
        if (operatingSystemBuilder_ != null) {
          return operatingSystemBuilder_.getMessageOrBuilder();
        } else {
          return operatingSystem_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.getDefaultInstance()
              : operatingSystem_;
        }
      }
      /**
       *
       *
       * <pre>
       * Count of assets grouped by Operating System families.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.ChartData operating_system = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder>
          getOperatingSystemFieldBuilder() {
        if (operatingSystemBuilder_ == null) {
          operatingSystemBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartData.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ChartDataOrBuilder>(
                  getOperatingSystem(), getParentForChildren(), isClean());
          operatingSystem_ = null;
        }
        return operatingSystemBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          coreCountHistogram_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>
          coreCountHistogramBuilder_;
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       *
       * @return Whether the coreCountHistogram field is set.
       */
      public boolean hasCoreCountHistogram() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       *
       * @return The coreCountHistogram.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          getCoreCountHistogram() {
        if (coreCountHistogramBuilder_ == null) {
          return coreCountHistogram_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                  .getDefaultInstance()
              : coreCountHistogram_;
        } else {
          return coreCountHistogramBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      public Builder setCoreCountHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData value) {
        if (coreCountHistogramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          coreCountHistogram_ = value;
        } else {
          coreCountHistogramBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      public Builder setCoreCountHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder
              builderForValue) {
        if (coreCountHistogramBuilder_ == null) {
          coreCountHistogram_ = builderForValue.build();
        } else {
          coreCountHistogramBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      public Builder mergeCoreCountHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData value) {
        if (coreCountHistogramBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && coreCountHistogram_ != null
              && coreCountHistogram_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                      .getDefaultInstance()) {
            getCoreCountHistogramBuilder().mergeFrom(value);
          } else {
            coreCountHistogram_ = value;
          }
        } else {
          coreCountHistogramBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      public Builder clearCoreCountHistogram() {
        bitField0_ = (bitField0_ & ~0x00000080);
        coreCountHistogram_ = null;
        if (coreCountHistogramBuilder_ != null) {
          coreCountHistogramBuilder_.dispose();
          coreCountHistogramBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder
          getCoreCountHistogramBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getCoreCountHistogramFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
          getCoreCountHistogramOrBuilder() {
        if (coreCountHistogramBuilder_ != null) {
          return coreCountHistogramBuilder_.getMessageOrBuilder();
        } else {
          return coreCountHistogram_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                  .getDefaultInstance()
              : coreCountHistogram_;
        }
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of CPU core counts.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData core_count_histogram = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>
          getCoreCountHistogramFieldBuilder() {
        if (coreCountHistogramBuilder_ == null) {
          coreCountHistogramBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>(
                  getCoreCountHistogram(), getParentForChildren(), isClean());
          coreCountHistogram_ = null;
        }
        return coreCountHistogramBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          memoryBytesHistogram_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>
          memoryBytesHistogramBuilder_;
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       *
       * @return Whether the memoryBytesHistogram field is set.
       */
      public boolean hasMemoryBytesHistogram() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       *
       * @return The memoryBytesHistogram.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          getMemoryBytesHistogram() {
        if (memoryBytesHistogramBuilder_ == null) {
          return memoryBytesHistogram_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                  .getDefaultInstance()
              : memoryBytesHistogram_;
        } else {
          return memoryBytesHistogramBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      public Builder setMemoryBytesHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData value) {
        if (memoryBytesHistogramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          memoryBytesHistogram_ = value;
        } else {
          memoryBytesHistogramBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      public Builder setMemoryBytesHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder
              builderForValue) {
        if (memoryBytesHistogramBuilder_ == null) {
          memoryBytesHistogram_ = builderForValue.build();
        } else {
          memoryBytesHistogramBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      public Builder mergeMemoryBytesHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData value) {
        if (memoryBytesHistogramBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && memoryBytesHistogram_ != null
              && memoryBytesHistogram_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                      .getDefaultInstance()) {
            getMemoryBytesHistogramBuilder().mergeFrom(value);
          } else {
            memoryBytesHistogram_ = value;
          }
        } else {
          memoryBytesHistogramBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      public Builder clearMemoryBytesHistogram() {
        bitField0_ = (bitField0_ & ~0x00000100);
        memoryBytesHistogram_ = null;
        if (memoryBytesHistogramBuilder_ != null) {
          memoryBytesHistogramBuilder_.dispose();
          memoryBytesHistogramBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder
          getMemoryBytesHistogramBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getMemoryBytesHistogramFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
          getMemoryBytesHistogramOrBuilder() {
        if (memoryBytesHistogramBuilder_ != null) {
          return memoryBytesHistogramBuilder_.getMessageOrBuilder();
        } else {
          return memoryBytesHistogram_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                  .getDefaultInstance()
              : memoryBytesHistogram_;
        }
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData memory_bytes_histogram = 9;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>
          getMemoryBytesHistogramFieldBuilder() {
        if (memoryBytesHistogramBuilder_ == null) {
          memoryBytesHistogramBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>(
                  getMemoryBytesHistogram(), getParentForChildren(), isClean());
          memoryBytesHistogram_ = null;
        }
        return memoryBytesHistogramBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          storageBytesHistogram_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>
          storageBytesHistogramBuilder_;
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       *
       * @return Whether the storageBytesHistogram field is set.
       */
      public boolean hasStorageBytesHistogram() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       *
       * @return The storageBytesHistogram.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
          getStorageBytesHistogram() {
        if (storageBytesHistogramBuilder_ == null) {
          return storageBytesHistogram_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                  .getDefaultInstance()
              : storageBytesHistogram_;
        } else {
          return storageBytesHistogramBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      public Builder setStorageBytesHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData value) {
        if (storageBytesHistogramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          storageBytesHistogram_ = value;
        } else {
          storageBytesHistogramBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      public Builder setStorageBytesHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder
              builderForValue) {
        if (storageBytesHistogramBuilder_ == null) {
          storageBytesHistogram_ = builderForValue.build();
        } else {
          storageBytesHistogramBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      public Builder mergeStorageBytesHistogram(
          com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData value) {
        if (storageBytesHistogramBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && storageBytesHistogram_ != null
              && storageBytesHistogram_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                      .getDefaultInstance()) {
            getStorageBytesHistogramBuilder().mergeFrom(value);
          } else {
            storageBytesHistogram_ = value;
          }
        } else {
          storageBytesHistogramBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      public Builder clearStorageBytesHistogram() {
        bitField0_ = (bitField0_ & ~0x00000200);
        storageBytesHistogram_ = null;
        if (storageBytesHistogramBuilder_ != null) {
          storageBytesHistogramBuilder_.dispose();
          storageBytesHistogramBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder
          getStorageBytesHistogramBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getStorageBytesHistogramFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder
          getStorageBytesHistogramOrBuilder() {
        if (storageBytesHistogramBuilder_ != null) {
          return storageBytesHistogramBuilder_.getMessageOrBuilder();
        } else {
          return storageBytesHistogram_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
                  .getDefaultInstance()
              : storageBytesHistogram_;
        }
      }
      /**
       *
       *
       * <pre>
       * Histogram showing a distribution of memory sizes.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData storage_bytes_histogram = 10;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>
          getStorageBytesHistogramFieldBuilder() {
        if (storageBytesHistogramBuilder_ == null) {
          storageBytesHistogramBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.HistogramChartDataOrBuilder>(
                  getStorageBytesHistogram(), getParentForChildren(), isClean());
          storageBytesHistogram_ = null;
        }
        return storageBytesHistogramBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AssetAggregateStats> PARSER =
        new com.google.protobuf.AbstractParser<AssetAggregateStats>() {
          @java.lang.Override
          public AssetAggregateStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AssetAggregateStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AssetAggregateStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MachineSeriesAllocationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Machine Series (e.g. "E2", "N2")
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
     *
     * @return Whether the machineSeries field is set.
     */
    boolean hasMachineSeries();
    /**
     *
     *
     * <pre>
     * The Machine Series (e.g. "E2", "N2")
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
     *
     * @return The machineSeries.
     */
    com.google.cloud.migrationcenter.v1.MachineSeries getMachineSeries();
    /**
     *
     *
     * <pre>
     * The Machine Series (e.g. "E2", "N2")
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
     */
    com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder getMachineSeriesOrBuilder();

    /**
     *
     *
     * <pre>
     * Count of assets allocated to this machine series.
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    long getAllocatedAssetCount();
  }
  /**
   *
   *
   * <pre>
   * Represents a data point tracking the count of assets allocated for a
   * specific Machine Series.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation}
   */
  public static final class MachineSeriesAllocation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation)
      MachineSeriesAllocationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MachineSeriesAllocation.newBuilder() to construct.
    private MachineSeriesAllocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MachineSeriesAllocation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MachineSeriesAllocation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_MachineSeriesAllocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_MachineSeriesAllocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
                  .class);
    }

    public static final int MACHINE_SERIES_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.MachineSeries machineSeries_;
    /**
     *
     *
     * <pre>
     * The Machine Series (e.g. "E2", "N2")
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
     *
     * @return Whether the machineSeries field is set.
     */
    @java.lang.Override
    public boolean hasMachineSeries() {
      return machineSeries_ != null;
    }
    /**
     *
     *
     * <pre>
     * The Machine Series (e.g. "E2", "N2")
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
     *
     * @return The machineSeries.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineSeries getMachineSeries() {
      return machineSeries_ == null
          ? com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance()
          : machineSeries_;
    }
    /**
     *
     *
     * <pre>
     * The Machine Series (e.g. "E2", "N2")
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder getMachineSeriesOrBuilder() {
      return machineSeries_ == null
          ? com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance()
          : machineSeries_;
    }

    public static final int ALLOCATED_ASSET_COUNT_FIELD_NUMBER = 2;
    private long allocatedAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of assets allocated to this machine series.
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    @java.lang.Override
    public long getAllocatedAssetCount() {
      return allocatedAssetCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (machineSeries_ != null) {
        output.writeMessage(1, getMachineSeries());
      }
      if (allocatedAssetCount_ != 0L) {
        output.writeInt64(2, allocatedAssetCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (machineSeries_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMachineSeries());
      }
      if (allocatedAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, allocatedAssetCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation) obj;

      if (hasMachineSeries() != other.hasMachineSeries()) return false;
      if (hasMachineSeries()) {
        if (!getMachineSeries().equals(other.getMachineSeries())) return false;
      }
      if (getAllocatedAssetCount() != other.getAllocatedAssetCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMachineSeries()) {
        hash = (37 * hash) + MACHINE_SERIES_FIELD_NUMBER;
        hash = (53 * hash) + getMachineSeries().hashCode();
      }
      hash = (37 * hash) + ALLOCATED_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedAssetCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a data point tracking the count of assets allocated for a
     * specific Machine Series.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation)
        com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_MachineSeriesAllocation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_MachineSeriesAllocation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineSeries_ = null;
        if (machineSeriesBuilder_ != null) {
          machineSeriesBuilder_.dispose();
          machineSeriesBuilder_ = null;
        }
        allocatedAssetCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_MachineSeriesAllocation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
          buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.machineSeries_ =
              machineSeriesBuilder_ == null ? machineSeries_ : machineSeriesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allocatedAssetCount_ = allocatedAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
                .getDefaultInstance()) return this;
        if (other.hasMachineSeries()) {
          mergeMachineSeries(other.getMachineSeries());
        }
        if (other.getAllocatedAssetCount() != 0L) {
          setAllocatedAssetCount(other.getAllocatedAssetCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMachineSeriesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  allocatedAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.MachineSeries machineSeries_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.MachineSeries,
              com.google.cloud.migrationcenter.v1.MachineSeries.Builder,
              com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>
          machineSeriesBuilder_;
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       *
       * @return Whether the machineSeries field is set.
       */
      public boolean hasMachineSeries() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       *
       * @return The machineSeries.
       */
      public com.google.cloud.migrationcenter.v1.MachineSeries getMachineSeries() {
        if (machineSeriesBuilder_ == null) {
          return machineSeries_ == null
              ? com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance()
              : machineSeries_;
        } else {
          return machineSeriesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      public Builder setMachineSeries(com.google.cloud.migrationcenter.v1.MachineSeries value) {
        if (machineSeriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          machineSeries_ = value;
        } else {
          machineSeriesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      public Builder setMachineSeries(
          com.google.cloud.migrationcenter.v1.MachineSeries.Builder builderForValue) {
        if (machineSeriesBuilder_ == null) {
          machineSeries_ = builderForValue.build();
        } else {
          machineSeriesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      public Builder mergeMachineSeries(com.google.cloud.migrationcenter.v1.MachineSeries value) {
        if (machineSeriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && machineSeries_ != null
              && machineSeries_
                  != com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance()) {
            getMachineSeriesBuilder().mergeFrom(value);
          } else {
            machineSeries_ = value;
          }
        } else {
          machineSeriesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      public Builder clearMachineSeries() {
        bitField0_ = (bitField0_ & ~0x00000001);
        machineSeries_ = null;
        if (machineSeriesBuilder_ != null) {
          machineSeriesBuilder_.dispose();
          machineSeriesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.MachineSeries.Builder getMachineSeriesBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMachineSeriesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder
          getMachineSeriesOrBuilder() {
        if (machineSeriesBuilder_ != null) {
          return machineSeriesBuilder_.getMessageOrBuilder();
        } else {
          return machineSeries_ == null
              ? com.google.cloud.migrationcenter.v1.MachineSeries.getDefaultInstance()
              : machineSeries_;
        }
      }
      /**
       *
       *
       * <pre>
       * The Machine Series (e.g. "E2", "N2")
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.MachineSeries machine_series = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.MachineSeries,
              com.google.cloud.migrationcenter.v1.MachineSeries.Builder,
              com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>
          getMachineSeriesFieldBuilder() {
        if (machineSeriesBuilder_ == null) {
          machineSeriesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.MachineSeries,
                  com.google.cloud.migrationcenter.v1.MachineSeries.Builder,
                  com.google.cloud.migrationcenter.v1.MachineSeriesOrBuilder>(
                  getMachineSeries(), getParentForChildren(), isClean());
          machineSeries_ = null;
        }
        return machineSeriesBuilder_;
      }

      private long allocatedAssetCount_;
      /**
       *
       *
       * <pre>
       * Count of assets allocated to this machine series.
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return The allocatedAssetCount.
       */
      @java.lang.Override
      public long getAllocatedAssetCount() {
        return allocatedAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of assets allocated to this machine series.
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @param value The allocatedAssetCount to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedAssetCount(long value) {

        allocatedAssetCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets allocated to this machine series.
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allocatedAssetCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MachineSeriesAllocation> PARSER =
        new com.google.protobuf.AbstractParser<MachineSeriesAllocation>() {
          @java.lang.Override
          public MachineSeriesAllocation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MachineSeriesAllocation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MachineSeriesAllocation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ComputeEngineFindingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return A list containing the allocatedRegions.
     */
    java.util.List<java.lang.String> getAllocatedRegionsList();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return The count of allocatedRegions.
     */
    int getAllocatedRegionsCount();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allocatedRegions at the given index.
     */
    java.lang.String getAllocatedRegions(int index);
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allocatedRegions at the given index.
     */
    com.google.protobuf.ByteString getAllocatedRegionsBytes(int index);

    /**
     *
     *
     * <pre>
     * Count of assets which were allocated.
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    long getAllocatedAssetCount();

    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>
        getMachineSeriesAllocationsList();
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        getMachineSeriesAllocations(int index);
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    int getMachineSeriesAllocationsCount();
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder>
        getMachineSeriesAllocationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder
        getMachineSeriesAllocationsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @return A list containing the allocatedDiskTypes.
     */
    java.util.List<com.google.cloud.migrationcenter.v1.PersistentDiskType>
        getAllocatedDiskTypesList();
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @return The count of allocatedDiskTypes.
     */
    int getAllocatedDiskTypesCount();
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The allocatedDiskTypes at the given index.
     */
    com.google.cloud.migrationcenter.v1.PersistentDiskType getAllocatedDiskTypes(int index);
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for allocatedDiskTypes.
     */
    java.util.List<java.lang.Integer> getAllocatedDiskTypesValueList();
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allocatedDiskTypes at the given index.
     */
    int getAllocatedDiskTypesValue(int index);
  }
  /**
   *
   *
   * <pre>
   * A set of findings that applies to assets destined for Compute Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding}
   */
  public static final class ComputeEngineFinding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding)
      ComputeEngineFindingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ComputeEngineFinding.newBuilder() to construct.
    private ComputeEngineFinding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ComputeEngineFinding() {
      allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      machineSeriesAllocations_ = java.util.Collections.emptyList();
      allocatedDiskTypes_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ComputeEngineFinding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ComputeEngineFinding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ComputeEngineFinding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder.class);
    }

    public static final int ALLOCATED_REGIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allocatedRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return A list containing the allocatedRegions.
     */
    public com.google.protobuf.ProtocolStringList getAllocatedRegionsList() {
      return allocatedRegions_;
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return The count of allocatedRegions.
     */
    public int getAllocatedRegionsCount() {
      return allocatedRegions_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allocatedRegions at the given index.
     */
    public java.lang.String getAllocatedRegions(int index) {
      return allocatedRegions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated.
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allocatedRegions at the given index.
     */
    public com.google.protobuf.ByteString getAllocatedRegionsBytes(int index) {
      return allocatedRegions_.getByteString(index);
    }

    public static final int ALLOCATED_ASSET_COUNT_FIELD_NUMBER = 2;
    private long allocatedAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of assets which were allocated.
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    @java.lang.Override
    public long getAllocatedAssetCount() {
      return allocatedAssetCount_;
    }

    public static final int MACHINE_SERIES_ALLOCATIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>
        machineSeriesAllocations_;
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>
        getMachineSeriesAllocationsList() {
      return machineSeriesAllocations_;
    }
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder>
        getMachineSeriesAllocationsOrBuilderList() {
      return machineSeriesAllocations_;
    }
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public int getMachineSeriesAllocationsCount() {
      return machineSeriesAllocations_.size();
    }
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
        getMachineSeriesAllocations(int index) {
      return machineSeriesAllocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Distribution of assets based on the Machine Series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder
        getMachineSeriesAllocationsOrBuilder(int index) {
      return machineSeriesAllocations_.get(index);
    }

    public static final int ALLOCATED_DISK_TYPES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> allocatedDiskTypes_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.migrationcenter.v1.PersistentDiskType>
        allocatedDiskTypes_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.cloud.migrationcenter.v1.PersistentDiskType>() {
              public com.google.cloud.migrationcenter.v1.PersistentDiskType convert(
                  java.lang.Integer from) {
                com.google.cloud.migrationcenter.v1.PersistentDiskType result =
                    com.google.cloud.migrationcenter.v1.PersistentDiskType.forNumber(from);
                return result == null
                    ? com.google.cloud.migrationcenter.v1.PersistentDiskType.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @return A list containing the allocatedDiskTypes.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.migrationcenter.v1.PersistentDiskType>
        getAllocatedDiskTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.migrationcenter.v1.PersistentDiskType>(
          allocatedDiskTypes_, allocatedDiskTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @return The count of allocatedDiskTypes.
     */
    @java.lang.Override
    public int getAllocatedDiskTypesCount() {
      return allocatedDiskTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The allocatedDiskTypes at the given index.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.PersistentDiskType getAllocatedDiskTypes(int index) {
      return allocatedDiskTypes_converter_.convert(allocatedDiskTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for allocatedDiskTypes.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getAllocatedDiskTypesValueList() {
      return allocatedDiskTypes_;
    }
    /**
     *
     *
     * <pre>
     * Set of disk types allocated to assets.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allocatedDiskTypes at the given index.
     */
    @java.lang.Override
    public int getAllocatedDiskTypesValue(int index) {
      return allocatedDiskTypes_.get(index);
    }

    private int allocatedDiskTypesMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < allocatedRegions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allocatedRegions_.getRaw(i));
      }
      if (allocatedAssetCount_ != 0L) {
        output.writeInt64(2, allocatedAssetCount_);
      }
      for (int i = 0; i < machineSeriesAllocations_.size(); i++) {
        output.writeMessage(3, machineSeriesAllocations_.get(i));
      }
      if (getAllocatedDiskTypesList().size() > 0) {
        output.writeUInt32NoTag(34);
        output.writeUInt32NoTag(allocatedDiskTypesMemoizedSerializedSize);
      }
      for (int i = 0; i < allocatedDiskTypes_.size(); i++) {
        output.writeEnumNoTag(allocatedDiskTypes_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < allocatedRegions_.size(); i++) {
          dataSize += computeStringSizeNoTag(allocatedRegions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllocatedRegionsList().size();
      }
      if (allocatedAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, allocatedAssetCount_);
      }
      for (int i = 0; i < machineSeriesAllocations_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, machineSeriesAllocations_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allocatedDiskTypes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  allocatedDiskTypes_.get(i));
        }
        size += dataSize;
        if (!getAllocatedDiskTypesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        allocatedDiskTypesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding) obj;

      if (!getAllocatedRegionsList().equals(other.getAllocatedRegionsList())) return false;
      if (getAllocatedAssetCount() != other.getAllocatedAssetCount()) return false;
      if (!getMachineSeriesAllocationsList().equals(other.getMachineSeriesAllocationsList()))
        return false;
      if (!allocatedDiskTypes_.equals(other.allocatedDiskTypes_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllocatedRegionsCount() > 0) {
        hash = (37 * hash) + ALLOCATED_REGIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAllocatedRegionsList().hashCode();
      }
      hash = (37 * hash) + ALLOCATED_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedAssetCount());
      if (getMachineSeriesAllocationsCount() > 0) {
        hash = (37 * hash) + MACHINE_SERIES_ALLOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getMachineSeriesAllocationsList().hashCode();
      }
      if (getAllocatedDiskTypesCount() > 0) {
        hash = (37 * hash) + ALLOCATED_DISK_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + allocatedDiskTypes_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to assets destined for Compute Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding)
        com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ComputeEngineFinding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ComputeEngineFinding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        allocatedAssetCount_ = 0L;
        if (machineSeriesAllocationsBuilder_ == null) {
          machineSeriesAllocations_ = java.util.Collections.emptyList();
        } else {
          machineSeriesAllocations_ = null;
          machineSeriesAllocationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        allocatedDiskTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_ComputeEngineFinding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding result) {
        if (machineSeriesAllocationsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            machineSeriesAllocations_ =
                java.util.Collections.unmodifiableList(machineSeriesAllocations_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.machineSeriesAllocations_ = machineSeriesAllocations_;
        } else {
          result.machineSeriesAllocations_ = machineSeriesAllocationsBuilder_.build();
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          allocatedDiskTypes_ = java.util.Collections.unmodifiableList(allocatedDiskTypes_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.allocatedDiskTypes_ = allocatedDiskTypes_;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          allocatedRegions_.makeImmutable();
          result.allocatedRegions_ = allocatedRegions_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allocatedAssetCount_ = allocatedAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
                .getDefaultInstance()) return this;
        if (!other.allocatedRegions_.isEmpty()) {
          if (allocatedRegions_.isEmpty()) {
            allocatedRegions_ = other.allocatedRegions_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAllocatedRegionsIsMutable();
            allocatedRegions_.addAll(other.allocatedRegions_);
          }
          onChanged();
        }
        if (other.getAllocatedAssetCount() != 0L) {
          setAllocatedAssetCount(other.getAllocatedAssetCount());
        }
        if (machineSeriesAllocationsBuilder_ == null) {
          if (!other.machineSeriesAllocations_.isEmpty()) {
            if (machineSeriesAllocations_.isEmpty()) {
              machineSeriesAllocations_ = other.machineSeriesAllocations_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureMachineSeriesAllocationsIsMutable();
              machineSeriesAllocations_.addAll(other.machineSeriesAllocations_);
            }
            onChanged();
          }
        } else {
          if (!other.machineSeriesAllocations_.isEmpty()) {
            if (machineSeriesAllocationsBuilder_.isEmpty()) {
              machineSeriesAllocationsBuilder_.dispose();
              machineSeriesAllocationsBuilder_ = null;
              machineSeriesAllocations_ = other.machineSeriesAllocations_;
              bitField0_ = (bitField0_ & ~0x00000004);
              machineSeriesAllocationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMachineSeriesAllocationsFieldBuilder()
                      : null;
            } else {
              machineSeriesAllocationsBuilder_.addAllMessages(other.machineSeriesAllocations_);
            }
          }
        }
        if (!other.allocatedDiskTypes_.isEmpty()) {
          if (allocatedDiskTypes_.isEmpty()) {
            allocatedDiskTypes_ = other.allocatedDiskTypes_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAllocatedDiskTypesIsMutable();
            allocatedDiskTypes_.addAll(other.allocatedDiskTypes_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllocatedRegionsIsMutable();
                  allocatedRegions_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  allocatedAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
                              .parser(),
                          extensionRegistry);
                  if (machineSeriesAllocationsBuilder_ == null) {
                    ensureMachineSeriesAllocationsIsMutable();
                    machineSeriesAllocations_.add(m);
                  } else {
                    machineSeriesAllocationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 32:
                {
                  int tmpRaw = input.readEnum();
                  ensureAllocatedDiskTypesIsMutable();
                  allocatedDiskTypes_.add(tmpRaw);
                  break;
                } // case 32
              case 34:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureAllocatedDiskTypesIsMutable();
                    allocatedDiskTypes_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList allocatedRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllocatedRegionsIsMutable() {
        if (!allocatedRegions_.isModifiable()) {
          allocatedRegions_ = new com.google.protobuf.LazyStringArrayList(allocatedRegions_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return A list containing the allocatedRegions.
       */
      public com.google.protobuf.ProtocolStringList getAllocatedRegionsList() {
        allocatedRegions_.makeImmutable();
        return allocatedRegions_;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return The count of allocatedRegions.
       */
      public int getAllocatedRegionsCount() {
        return allocatedRegions_.size();
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allocatedRegions at the given index.
       */
      public java.lang.String getAllocatedRegions(int index) {
        return allocatedRegions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allocatedRegions at the given index.
       */
      public com.google.protobuf.ByteString getAllocatedRegionsBytes(int index) {
        return allocatedRegions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The allocatedRegions to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedRegions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param value The allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedRegions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param values The allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllocatedRegions(java.lang.Iterable<java.lang.String> values) {
        ensureAllocatedRegionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allocatedRegions_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedRegions() {
        allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated.
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param value The bytes of the allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedRegionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long allocatedAssetCount_;
      /**
       *
       *
       * <pre>
       * Count of assets which were allocated.
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return The allocatedAssetCount.
       */
      @java.lang.Override
      public long getAllocatedAssetCount() {
        return allocatedAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of assets which were allocated.
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @param value The allocatedAssetCount to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedAssetCount(long value) {

        allocatedAssetCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets which were allocated.
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allocatedAssetCount_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>
          machineSeriesAllocations_ = java.util.Collections.emptyList();

      private void ensureMachineSeriesAllocationsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          machineSeriesAllocations_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>(
                  machineSeriesAllocations_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation,
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder>
          machineSeriesAllocationsBuilder_;

      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>
          getMachineSeriesAllocationsList() {
        if (machineSeriesAllocationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(machineSeriesAllocations_);
        } else {
          return machineSeriesAllocationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public int getMachineSeriesAllocationsCount() {
        if (machineSeriesAllocationsBuilder_ == null) {
          return machineSeriesAllocations_.size();
        } else {
          return machineSeriesAllocationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
          getMachineSeriesAllocations(int index) {
        if (machineSeriesAllocationsBuilder_ == null) {
          return machineSeriesAllocations_.get(index);
        } else {
          return machineSeriesAllocationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder setMachineSeriesAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation value) {
        if (machineSeriesAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.set(index, value);
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder setMachineSeriesAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
              builderForValue) {
        if (machineSeriesAllocationsBuilder_ == null) {
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.set(index, builderForValue.build());
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder addMachineSeriesAllocations(
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation value) {
        if (machineSeriesAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.add(value);
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder addMachineSeriesAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation value) {
        if (machineSeriesAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.add(index, value);
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder addMachineSeriesAllocations(
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
              builderForValue) {
        if (machineSeriesAllocationsBuilder_ == null) {
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.add(builderForValue.build());
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder addMachineSeriesAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
              builderForValue) {
        if (machineSeriesAllocationsBuilder_ == null) {
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.add(index, builderForValue.build());
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder addAllMachineSeriesAllocations(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation>
              values) {
        if (machineSeriesAllocationsBuilder_ == null) {
          ensureMachineSeriesAllocationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, machineSeriesAllocations_);
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder clearMachineSeriesAllocations() {
        if (machineSeriesAllocationsBuilder_ == null) {
          machineSeriesAllocations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public Builder removeMachineSeriesAllocations(int index) {
        if (machineSeriesAllocationsBuilder_ == null) {
          ensureMachineSeriesAllocationsIsMutable();
          machineSeriesAllocations_.remove(index);
          onChanged();
        } else {
          machineSeriesAllocationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
          getMachineSeriesAllocationsBuilder(int index) {
        return getMachineSeriesAllocationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder
          getMachineSeriesAllocationsOrBuilder(int index) {
        if (machineSeriesAllocationsBuilder_ == null) {
          return machineSeriesAllocations_.get(index);
        } else {
          return machineSeriesAllocationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.ReportSummary
                      .MachineSeriesAllocationOrBuilder>
          getMachineSeriesAllocationsOrBuilderList() {
        if (machineSeriesAllocationsBuilder_ != null) {
          return machineSeriesAllocationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(machineSeriesAllocations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
          addMachineSeriesAllocationsBuilder() {
        return getMachineSeriesAllocationsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder
          addMachineSeriesAllocationsBuilder(int index) {
        return getMachineSeriesAllocationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Distribution of assets based on the Machine Series.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation machine_series_allocations = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder>
          getMachineSeriesAllocationsBuilderList() {
        return getMachineSeriesAllocationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation,
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocationOrBuilder>
          getMachineSeriesAllocationsFieldBuilder() {
        if (machineSeriesAllocationsBuilder_ == null) {
          machineSeriesAllocationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation,
                  com.google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary
                      .MachineSeriesAllocationOrBuilder>(
                  machineSeriesAllocations_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          machineSeriesAllocations_ = null;
        }
        return machineSeriesAllocationsBuilder_;
      }

      private java.util.List<java.lang.Integer> allocatedDiskTypes_ =
          java.util.Collections.emptyList();

      private void ensureAllocatedDiskTypesIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          allocatedDiskTypes_ = new java.util.ArrayList<java.lang.Integer>(allocatedDiskTypes_);
          bitField0_ |= 0x00000008;
        }
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @return A list containing the allocatedDiskTypes.
       */
      public java.util.List<com.google.cloud.migrationcenter.v1.PersistentDiskType>
          getAllocatedDiskTypesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.migrationcenter.v1.PersistentDiskType>(
            allocatedDiskTypes_, allocatedDiskTypes_converter_);
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @return The count of allocatedDiskTypes.
       */
      public int getAllocatedDiskTypesCount() {
        return allocatedDiskTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The allocatedDiskTypes at the given index.
       */
      public com.google.cloud.migrationcenter.v1.PersistentDiskType getAllocatedDiskTypes(
          int index) {
        return allocatedDiskTypes_converter_.convert(allocatedDiskTypes_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The allocatedDiskTypes to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedDiskTypes(
          int index, com.google.cloud.migrationcenter.v1.PersistentDiskType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedDiskTypesIsMutable();
        allocatedDiskTypes_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param value The allocatedDiskTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedDiskTypes(
          com.google.cloud.migrationcenter.v1.PersistentDiskType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedDiskTypesIsMutable();
        allocatedDiskTypes_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param values The allocatedDiskTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllocatedDiskTypes(
          java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.PersistentDiskType>
              values) {
        ensureAllocatedDiskTypesIsMutable();
        for (com.google.cloud.migrationcenter.v1.PersistentDiskType value : values) {
          allocatedDiskTypes_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedDiskTypes() {
        allocatedDiskTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for allocatedDiskTypes.
       */
      public java.util.List<java.lang.Integer> getAllocatedDiskTypesValueList() {
        return java.util.Collections.unmodifiableList(allocatedDiskTypes_);
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of allocatedDiskTypes at the given index.
       */
      public int getAllocatedDiskTypesValue(int index) {
        return allocatedDiskTypes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for allocatedDiskTypes to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedDiskTypesValue(int index, int value) {
        ensureAllocatedDiskTypesIsMutable();
        allocatedDiskTypes_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for allocatedDiskTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedDiskTypesValue(int value) {
        ensureAllocatedDiskTypesIsMutable();
        allocatedDiskTypes_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of disk types allocated to assets.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.PersistentDiskType allocated_disk_types = 4;
       * </code>
       *
       * @param values The enum numeric values on the wire for allocatedDiskTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllocatedDiskTypesValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureAllocatedDiskTypesIsMutable();
        for (int value : values) {
          allocatedDiskTypes_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ComputeEngineFinding> PARSER =
        new com.google.protobuf.AbstractParser<ComputeEngineFinding>() {
          @java.lang.Override
          public ComputeEngineFinding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ComputeEngineFinding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ComputeEngineFinding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VmwareEngineFindingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return A list containing the allocatedRegions.
     */
    java.util.List<java.lang.String> getAllocatedRegionsList();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return The count of allocatedRegions.
     */
    int getAllocatedRegionsCount();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allocatedRegions at the given index.
     */
    java.lang.String getAllocatedRegions(int index);
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allocatedRegions at the given index.
     */
    com.google.protobuf.ByteString getAllocatedRegionsBytes(int index);

    /**
     *
     *
     * <pre>
     * Count of assets which are allocated
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    long getAllocatedAssetCount();

    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>
        getNodeAllocationsList();
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation getNodeAllocations(
        int index);
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    int getNodeAllocationsCount();
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder>
        getNodeAllocationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder
        getNodeAllocationsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A set of findings that applies to assets destined for VMWare Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding}
   */
  public static final class VmwareEngineFinding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding)
      VmwareEngineFindingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VmwareEngineFinding.newBuilder() to construct.
    private VmwareEngineFinding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VmwareEngineFinding() {
      allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nodeAllocations_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VmwareEngineFinding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareEngineFinding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareEngineFinding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder.class);
    }

    public static final int ALLOCATED_REGIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allocatedRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return A list containing the allocatedRegions.
     */
    public com.google.protobuf.ProtocolStringList getAllocatedRegionsList() {
      return allocatedRegions_;
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return The count of allocatedRegions.
     */
    public int getAllocatedRegionsCount() {
      return allocatedRegions_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allocatedRegions at the given index.
     */
    public java.lang.String getAllocatedRegions(int index) {
      return allocatedRegions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets were allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allocatedRegions at the given index.
     */
    public com.google.protobuf.ByteString getAllocatedRegionsBytes(int index) {
      return allocatedRegions_.getByteString(index);
    }

    public static final int ALLOCATED_ASSET_COUNT_FIELD_NUMBER = 2;
    private long allocatedAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of assets which are allocated
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    @java.lang.Override
    public long getAllocatedAssetCount() {
      return allocatedAssetCount_;
    }

    public static final int NODE_ALLOCATIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>
        nodeAllocations_;
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>
        getNodeAllocationsList() {
      return nodeAllocations_;
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder>
        getNodeAllocationsOrBuilderList() {
      return nodeAllocations_;
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public int getNodeAllocationsCount() {
      return nodeAllocations_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
        getNodeAllocations(int index) {
      return nodeAllocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder
        getNodeAllocationsOrBuilder(int index) {
      return nodeAllocations_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < allocatedRegions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allocatedRegions_.getRaw(i));
      }
      if (allocatedAssetCount_ != 0L) {
        output.writeInt64(2, allocatedAssetCount_);
      }
      for (int i = 0; i < nodeAllocations_.size(); i++) {
        output.writeMessage(3, nodeAllocations_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < allocatedRegions_.size(); i++) {
          dataSize += computeStringSizeNoTag(allocatedRegions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllocatedRegionsList().size();
      }
      if (allocatedAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, allocatedAssetCount_);
      }
      for (int i = 0; i < nodeAllocations_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, nodeAllocations_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding) obj;

      if (!getAllocatedRegionsList().equals(other.getAllocatedRegionsList())) return false;
      if (getAllocatedAssetCount() != other.getAllocatedAssetCount()) return false;
      if (!getNodeAllocationsList().equals(other.getNodeAllocationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllocatedRegionsCount() > 0) {
        hash = (37 * hash) + ALLOCATED_REGIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAllocatedRegionsList().hashCode();
      }
      hash = (37 * hash) + ALLOCATED_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedAssetCount());
      if (getNodeAllocationsCount() > 0) {
        hash = (37 * hash) + NODE_ALLOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getNodeAllocationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to assets destined for VMWare Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding)
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareEngineFinding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareEngineFinding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        allocatedAssetCount_ = 0L;
        if (nodeAllocationsBuilder_ == null) {
          nodeAllocations_ = java.util.Collections.emptyList();
        } else {
          nodeAllocations_ = null;
          nodeAllocationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareEngineFinding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding result) {
        if (nodeAllocationsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            nodeAllocations_ = java.util.Collections.unmodifiableList(nodeAllocations_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.nodeAllocations_ = nodeAllocations_;
        } else {
          result.nodeAllocations_ = nodeAllocationsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          allocatedRegions_.makeImmutable();
          result.allocatedRegions_ = allocatedRegions_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allocatedAssetCount_ = allocatedAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
                .getDefaultInstance()) return this;
        if (!other.allocatedRegions_.isEmpty()) {
          if (allocatedRegions_.isEmpty()) {
            allocatedRegions_ = other.allocatedRegions_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAllocatedRegionsIsMutable();
            allocatedRegions_.addAll(other.allocatedRegions_);
          }
          onChanged();
        }
        if (other.getAllocatedAssetCount() != 0L) {
          setAllocatedAssetCount(other.getAllocatedAssetCount());
        }
        if (nodeAllocationsBuilder_ == null) {
          if (!other.nodeAllocations_.isEmpty()) {
            if (nodeAllocations_.isEmpty()) {
              nodeAllocations_ = other.nodeAllocations_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureNodeAllocationsIsMutable();
              nodeAllocations_.addAll(other.nodeAllocations_);
            }
            onChanged();
          }
        } else {
          if (!other.nodeAllocations_.isEmpty()) {
            if (nodeAllocationsBuilder_.isEmpty()) {
              nodeAllocationsBuilder_.dispose();
              nodeAllocationsBuilder_ = null;
              nodeAllocations_ = other.nodeAllocations_;
              bitField0_ = (bitField0_ & ~0x00000004);
              nodeAllocationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNodeAllocationsFieldBuilder()
                      : null;
            } else {
              nodeAllocationsBuilder_.addAllMessages(other.nodeAllocations_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllocatedRegionsIsMutable();
                  allocatedRegions_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  allocatedAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
                              .parser(),
                          extensionRegistry);
                  if (nodeAllocationsBuilder_ == null) {
                    ensureNodeAllocationsIsMutable();
                    nodeAllocations_.add(m);
                  } else {
                    nodeAllocationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList allocatedRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllocatedRegionsIsMutable() {
        if (!allocatedRegions_.isModifiable()) {
          allocatedRegions_ = new com.google.protobuf.LazyStringArrayList(allocatedRegions_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return A list containing the allocatedRegions.
       */
      public com.google.protobuf.ProtocolStringList getAllocatedRegionsList() {
        allocatedRegions_.makeImmutable();
        return allocatedRegions_;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return The count of allocatedRegions.
       */
      public int getAllocatedRegionsCount() {
        return allocatedRegions_.size();
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allocatedRegions at the given index.
       */
      public java.lang.String getAllocatedRegions(int index) {
        return allocatedRegions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allocatedRegions at the given index.
       */
      public com.google.protobuf.ByteString getAllocatedRegionsBytes(int index) {
        return allocatedRegions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The allocatedRegions to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedRegions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param value The allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedRegions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param values The allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllocatedRegions(java.lang.Iterable<java.lang.String> values) {
        ensureAllocatedRegionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allocatedRegions_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedRegions() {
        allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets were allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param value The bytes of the allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedRegionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long allocatedAssetCount_;
      /**
       *
       *
       * <pre>
       * Count of assets which are allocated
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return The allocatedAssetCount.
       */
      @java.lang.Override
      public long getAllocatedAssetCount() {
        return allocatedAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of assets which are allocated
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @param value The allocatedAssetCount to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedAssetCount(long value) {

        allocatedAssetCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets which are allocated
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allocatedAssetCount_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>
          nodeAllocations_ = java.util.Collections.emptyList();

      private void ensureNodeAllocationsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          nodeAllocations_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>(
                  nodeAllocations_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder>
          nodeAllocationsBuilder_;

      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>
          getNodeAllocationsList() {
        if (nodeAllocationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(nodeAllocations_);
        } else {
          return nodeAllocationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public int getNodeAllocationsCount() {
        if (nodeAllocationsBuilder_ == null) {
          return nodeAllocations_.size();
        } else {
          return nodeAllocationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
          getNodeAllocations(int index) {
        if (nodeAllocationsBuilder_ == null) {
          return nodeAllocations_.get(index);
        } else {
          return nodeAllocationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder setNodeAllocations(
          int index, com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation value) {
        if (nodeAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.set(index, value);
          onChanged();
        } else {
          nodeAllocationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder setNodeAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
              builderForValue) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.set(index, builderForValue.build());
          onChanged();
        } else {
          nodeAllocationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation value) {
        if (nodeAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(value);
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          int index, com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation value) {
        if (nodeAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(index, value);
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
              builderForValue) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(builderForValue.build());
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
              builderForValue) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(index, builderForValue.build());
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addAllNodeAllocations(
          java.lang.Iterable<
                  ? extends com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation>
              values) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodeAllocations_);
          onChanged();
        } else {
          nodeAllocationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder clearNodeAllocations() {
        if (nodeAllocationsBuilder_ == null) {
          nodeAllocations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          nodeAllocationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder removeNodeAllocations(int index) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.remove(index);
          onChanged();
        } else {
          nodeAllocationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
          getNodeAllocationsBuilder(int index) {
        return getNodeAllocationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder
          getNodeAllocationsOrBuilder(int index) {
        if (nodeAllocationsBuilder_ == null) {
          return nodeAllocations_.get(index);
        } else {
          return nodeAllocationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder>
          getNodeAllocationsOrBuilderList() {
        if (nodeAllocationsBuilder_ != null) {
          return nodeAllocationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(nodeAllocations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
          addNodeAllocationsBuilder() {
        return getNodeAllocationsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
          addNodeAllocationsBuilder(int index) {
        return getNodeAllocationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation node_allocations = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder>
          getNodeAllocationsBuilderList() {
        return getNodeAllocationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder>
          getNodeAllocationsFieldBuilder() {
        if (nodeAllocationsBuilder_ == null) {
          nodeAllocationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation,
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder>(
                  nodeAllocations_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          nodeAllocations_ = null;
        }
        return nodeAllocationsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VmwareEngineFinding> PARSER =
        new com.google.protobuf.AbstractParser<VmwareEngineFinding>() {
          @java.lang.Override
          public VmwareEngineFinding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VmwareEngineFinding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VmwareEngineFinding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VmwareNodeAllocationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * VMWare node type, e.g. "ve1-standard-72"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
     *
     * @return Whether the vmwareNode field is set.
     */
    boolean hasVmwareNode();
    /**
     *
     *
     * <pre>
     * VMWare node type, e.g. "ve1-standard-72"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
     *
     * @return The vmwareNode.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode getVmwareNode();
    /**
     *
     *
     * <pre>
     * VMWare node type, e.g. "ve1-standard-72"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder getVmwareNodeOrBuilder();

    /**
     *
     *
     * <pre>
     * Count of this node type to be provisioned
     * </pre>
     *
     * <code>int64 node_count = 2;</code>
     *
     * @return The nodeCount.
     */
    long getNodeCount();

    /**
     *
     *
     * <pre>
     * Count of assets allocated to these nodes
     * </pre>
     *
     * <code>int64 allocated_asset_count = 3;</code>
     *
     * @return The allocatedAssetCount.
     */
    long getAllocatedAssetCount();
  }
  /**
   *
   *
   * <pre>
   * Represents assets allocated to a specific VMWare Node type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation}
   */
  public static final class VmwareNodeAllocation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation)
      VmwareNodeAllocationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VmwareNodeAllocation.newBuilder() to construct.
    private VmwareNodeAllocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VmwareNodeAllocation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VmwareNodeAllocation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNodeAllocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNodeAllocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder.class);
    }

    public static final int VMWARE_NODE_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmwareNode_;
    /**
     *
     *
     * <pre>
     * VMWare node type, e.g. "ve1-standard-72"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
     *
     * @return Whether the vmwareNode field is set.
     */
    @java.lang.Override
    public boolean hasVmwareNode() {
      return vmwareNode_ != null;
    }
    /**
     *
     *
     * <pre>
     * VMWare node type, e.g. "ve1-standard-72"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
     *
     * @return The vmwareNode.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode getVmwareNode() {
      return vmwareNode_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.getDefaultInstance()
          : vmwareNode_;
    }
    /**
     *
     *
     * <pre>
     * VMWare node type, e.g. "ve1-standard-72"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder
        getVmwareNodeOrBuilder() {
      return vmwareNode_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.getDefaultInstance()
          : vmwareNode_;
    }

    public static final int NODE_COUNT_FIELD_NUMBER = 2;
    private long nodeCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of this node type to be provisioned
     * </pre>
     *
     * <code>int64 node_count = 2;</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public long getNodeCount() {
      return nodeCount_;
    }

    public static final int ALLOCATED_ASSET_COUNT_FIELD_NUMBER = 3;
    private long allocatedAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of assets allocated to these nodes
     * </pre>
     *
     * <code>int64 allocated_asset_count = 3;</code>
     *
     * @return The allocatedAssetCount.
     */
    @java.lang.Override
    public long getAllocatedAssetCount() {
      return allocatedAssetCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (vmwareNode_ != null) {
        output.writeMessage(1, getVmwareNode());
      }
      if (nodeCount_ != 0L) {
        output.writeInt64(2, nodeCount_);
      }
      if (allocatedAssetCount_ != 0L) {
        output.writeInt64(3, allocatedAssetCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (vmwareNode_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getVmwareNode());
      }
      if (nodeCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, nodeCount_);
      }
      if (allocatedAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, allocatedAssetCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation) obj;

      if (hasVmwareNode() != other.hasVmwareNode()) return false;
      if (hasVmwareNode()) {
        if (!getVmwareNode().equals(other.getVmwareNode())) return false;
      }
      if (getNodeCount() != other.getNodeCount()) return false;
      if (getAllocatedAssetCount() != other.getAllocatedAssetCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasVmwareNode()) {
        hash = (37 * hash) + VMWARE_NODE_FIELD_NUMBER;
        hash = (53 * hash) + getVmwareNode().hashCode();
      }
      hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNodeCount());
      hash = (37 * hash) + ALLOCATED_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedAssetCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents assets allocated to a specific VMWare Node type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation)
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNodeAllocation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNodeAllocation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        vmwareNode_ = null;
        if (vmwareNodeBuilder_ != null) {
          vmwareNodeBuilder_.dispose();
          vmwareNodeBuilder_ = null;
        }
        nodeCount_ = 0L;
        allocatedAssetCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNodeAllocation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.vmwareNode_ =
              vmwareNodeBuilder_ == null ? vmwareNode_ : vmwareNodeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.nodeCount_ = nodeCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.allocatedAssetCount_ = allocatedAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
                .getDefaultInstance()) return this;
        if (other.hasVmwareNode()) {
          mergeVmwareNode(other.getVmwareNode());
        }
        if (other.getNodeCount() != 0L) {
          setNodeCount(other.getNodeCount());
        }
        if (other.getAllocatedAssetCount() != 0L) {
          setAllocatedAssetCount(other.getAllocatedAssetCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getVmwareNodeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  nodeCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  allocatedAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmwareNode_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder>
          vmwareNodeBuilder_;
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       *
       * @return Whether the vmwareNode field is set.
       */
      public boolean hasVmwareNode() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       *
       * @return The vmwareNode.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode getVmwareNode() {
        if (vmwareNodeBuilder_ == null) {
          return vmwareNode_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.getDefaultInstance()
              : vmwareNode_;
        } else {
          return vmwareNodeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      public Builder setVmwareNode(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode value) {
        if (vmwareNodeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vmwareNode_ = value;
        } else {
          vmwareNodeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      public Builder setVmwareNode(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder builderForValue) {
        if (vmwareNodeBuilder_ == null) {
          vmwareNode_ = builderForValue.build();
        } else {
          vmwareNodeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      public Builder mergeVmwareNode(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode value) {
        if (vmwareNodeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && vmwareNode_ != null
              && vmwareNode_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
                      .getDefaultInstance()) {
            getVmwareNodeBuilder().mergeFrom(value);
          } else {
            vmwareNode_ = value;
          }
        } else {
          vmwareNodeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      public Builder clearVmwareNode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        vmwareNode_ = null;
        if (vmwareNodeBuilder_ != null) {
          vmwareNodeBuilder_.dispose();
          vmwareNodeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder
          getVmwareNodeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getVmwareNodeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder
          getVmwareNodeOrBuilder() {
        if (vmwareNodeBuilder_ != null) {
          return vmwareNodeBuilder_.getMessageOrBuilder();
        } else {
          return vmwareNode_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.getDefaultInstance()
              : vmwareNode_;
        }
      }
      /**
       *
       *
       * <pre>
       * VMWare node type, e.g. "ve1-standard-72"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode vmware_node = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder>
          getVmwareNodeFieldBuilder() {
        if (vmwareNodeBuilder_ == null) {
          vmwareNodeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode,
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder>(
                  getVmwareNode(), getParentForChildren(), isClean());
          vmwareNode_ = null;
        }
        return vmwareNodeBuilder_;
      }

      private long nodeCount_;
      /**
       *
       *
       * <pre>
       * Count of this node type to be provisioned
       * </pre>
       *
       * <code>int64 node_count = 2;</code>
       *
       * @return The nodeCount.
       */
      @java.lang.Override
      public long getNodeCount() {
        return nodeCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of this node type to be provisioned
       * </pre>
       *
       * <code>int64 node_count = 2;</code>
       *
       * @param value The nodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setNodeCount(long value) {

        nodeCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of this node type to be provisioned
       * </pre>
       *
       * <code>int64 node_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNodeCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        nodeCount_ = 0L;
        onChanged();
        return this;
      }

      private long allocatedAssetCount_;
      /**
       *
       *
       * <pre>
       * Count of assets allocated to these nodes
       * </pre>
       *
       * <code>int64 allocated_asset_count = 3;</code>
       *
       * @return The allocatedAssetCount.
       */
      @java.lang.Override
      public long getAllocatedAssetCount() {
        return allocatedAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of assets allocated to these nodes
       * </pre>
       *
       * <code>int64 allocated_asset_count = 3;</code>
       *
       * @param value The allocatedAssetCount to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedAssetCount(long value) {

        allocatedAssetCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets allocated to these nodes
       * </pre>
       *
       * <code>int64 allocated_asset_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allocatedAssetCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VmwareNodeAllocation> PARSER =
        new com.google.protobuf.AbstractParser<VmwareNodeAllocation>() {
          @java.lang.Override
          public VmwareNodeAllocation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VmwareNodeAllocation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VmwareNodeAllocation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VmwareNodeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.VmwareNode)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
     * on the displayName of
     * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
     * </pre>
     *
     * <code>string code = 1;</code>
     *
     * @return The code.
     */
    java.lang.String getCode();
    /**
     *
     *
     * <pre>
     * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
     * on the displayName of
     * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
     * </pre>
     *
     * <code>string code = 1;</code>
     *
     * @return The bytes for code.
     */
    com.google.protobuf.ByteString getCodeBytes();
  }
  /**
   *
   *
   * <pre>
   * A VMWare Engine Node
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.VmwareNode}
   */
  public static final class VmwareNode extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.VmwareNode)
      VmwareNodeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VmwareNode.newBuilder() to construct.
    private VmwareNode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VmwareNode() {
      code_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VmwareNode();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder.class);
    }

    public static final int CODE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object code_ = "";
    /**
     *
     *
     * <pre>
     * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
     * on the displayName of
     * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
     * </pre>
     *
     * <code>string code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
     * on the displayName of
     * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
     * </pre>
     *
     * <code>string code = 1;</code>
     *
     * @return The bytes for code.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, code_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, code_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode) obj;

      if (!getCode().equals(other.getCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A VMWare Engine Node
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.VmwareNode}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.VmwareNode)
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        code_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_VmwareNode_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.code_ = code_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode.getDefaultInstance())
          return this;
        if (!other.getCode().isEmpty()) {
          code_ = other.code_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  code_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object code_ = "";
      /**
       *
       *
       * <pre>
       * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
       * on the displayName of
       * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
       * </pre>
       *
       * <code>string code = 1;</code>
       *
       * @return The code.
       */
      public java.lang.String getCode() {
        java.lang.Object ref = code_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          code_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
       * on the displayName of
       * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
       * </pre>
       *
       * <code>string code = 1;</code>
       *
       * @return The bytes for code.
       */
      public com.google.protobuf.ByteString getCodeBytes() {
        java.lang.Object ref = code_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          code_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
       * on the displayName of
       * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
       * </pre>
       *
       * <code>string code = 1;</code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        code_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
       * on the displayName of
       * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
       * </pre>
       *
       * <code>string code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {
        code_ = getDefaultInstance().getCode();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
       * on the displayName of
       * cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
       * </pre>
       *
       * <code>string code = 1;</code>
       *
       * @param value The bytes for code to set.
       * @return This builder for chaining.
       */
      public Builder setCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        code_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.VmwareNode)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.VmwareNode)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VmwareNode> PARSER =
        new com.google.protobuf.AbstractParser<VmwareNode>() {
          @java.lang.Override
          public VmwareNode parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VmwareNode> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VmwareNode> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SoleTenantFindingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return A list containing the allocatedRegions.
     */
    java.util.List<java.lang.String> getAllocatedRegionsList();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return The count of allocatedRegions.
     */
    int getAllocatedRegionsCount();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allocatedRegions at the given index.
     */
    java.lang.String getAllocatedRegions(int index);
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allocatedRegions at the given index.
     */
    com.google.protobuf.ByteString getAllocatedRegionsBytes(int index);

    /**
     *
     *
     * <pre>
     * Count of assets which are allocated
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    long getAllocatedAssetCount();

    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>
        getNodeAllocationsList();
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation getNodeAllocations(
        int index);
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    int getNodeAllocationsCount();
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder>
        getNodeAllocationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder
        getNodeAllocationsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A set of findings that applies to assets destined for Sole-Tenant nodes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding}
   */
  public static final class SoleTenantFinding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding)
      SoleTenantFindingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SoleTenantFinding.newBuilder() to construct.
    private SoleTenantFinding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SoleTenantFinding() {
      allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nodeAllocations_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SoleTenantFinding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantFinding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantFinding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder.class);
    }

    public static final int ALLOCATED_REGIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allocatedRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return A list containing the allocatedRegions.
     */
    public com.google.protobuf.ProtocolStringList getAllocatedRegionsList() {
      return allocatedRegions_;
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @return The count of allocatedRegions.
     */
    public int getAllocatedRegionsCount() {
      return allocatedRegions_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allocatedRegions at the given index.
     */
    public java.lang.String getAllocatedRegions(int index) {
      return allocatedRegions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Set of regions in which the assets are allocated
     * </pre>
     *
     * <code>repeated string allocated_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allocatedRegions at the given index.
     */
    public com.google.protobuf.ByteString getAllocatedRegionsBytes(int index) {
      return allocatedRegions_.getByteString(index);
    }

    public static final int ALLOCATED_ASSET_COUNT_FIELD_NUMBER = 2;
    private long allocatedAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of assets which are allocated
     * </pre>
     *
     * <code>int64 allocated_asset_count = 2;</code>
     *
     * @return The allocatedAssetCount.
     */
    @java.lang.Override
    public long getAllocatedAssetCount() {
      return allocatedAssetCount_;
    }

    public static final int NODE_ALLOCATIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>
        nodeAllocations_;
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>
        getNodeAllocationsList() {
      return nodeAllocations_;
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder>
        getNodeAllocationsOrBuilderList() {
      return nodeAllocations_;
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public int getNodeAllocationsCount() {
      return nodeAllocations_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        getNodeAllocations(int index) {
      return nodeAllocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Set of per-nodetype allocation records
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder
        getNodeAllocationsOrBuilder(int index) {
      return nodeAllocations_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < allocatedRegions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allocatedRegions_.getRaw(i));
      }
      if (allocatedAssetCount_ != 0L) {
        output.writeInt64(2, allocatedAssetCount_);
      }
      for (int i = 0; i < nodeAllocations_.size(); i++) {
        output.writeMessage(3, nodeAllocations_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < allocatedRegions_.size(); i++) {
          dataSize += computeStringSizeNoTag(allocatedRegions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllocatedRegionsList().size();
      }
      if (allocatedAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, allocatedAssetCount_);
      }
      for (int i = 0; i < nodeAllocations_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, nodeAllocations_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding) obj;

      if (!getAllocatedRegionsList().equals(other.getAllocatedRegionsList())) return false;
      if (getAllocatedAssetCount() != other.getAllocatedAssetCount()) return false;
      if (!getNodeAllocationsList().equals(other.getNodeAllocationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllocatedRegionsCount() > 0) {
        hash = (37 * hash) + ALLOCATED_REGIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAllocatedRegionsList().hashCode();
      }
      hash = (37 * hash) + ALLOCATED_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedAssetCount());
      if (getNodeAllocationsCount() > 0) {
        hash = (37 * hash) + NODE_ALLOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getNodeAllocationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to assets destined for Sole-Tenant nodes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding)
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantFinding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantFinding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder.class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        allocatedAssetCount_ = 0L;
        if (nodeAllocationsBuilder_ == null) {
          nodeAllocations_ = java.util.Collections.emptyList();
        } else {
          nodeAllocations_ = null;
          nodeAllocationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantFinding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding result) {
        if (nodeAllocationsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            nodeAllocations_ = java.util.Collections.unmodifiableList(nodeAllocations_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.nodeAllocations_ = nodeAllocations_;
        } else {
          result.nodeAllocations_ = nodeAllocationsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          allocatedRegions_.makeImmutable();
          result.allocatedRegions_ = allocatedRegions_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allocatedAssetCount_ = allocatedAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
                .getDefaultInstance()) return this;
        if (!other.allocatedRegions_.isEmpty()) {
          if (allocatedRegions_.isEmpty()) {
            allocatedRegions_ = other.allocatedRegions_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAllocatedRegionsIsMutable();
            allocatedRegions_.addAll(other.allocatedRegions_);
          }
          onChanged();
        }
        if (other.getAllocatedAssetCount() != 0L) {
          setAllocatedAssetCount(other.getAllocatedAssetCount());
        }
        if (nodeAllocationsBuilder_ == null) {
          if (!other.nodeAllocations_.isEmpty()) {
            if (nodeAllocations_.isEmpty()) {
              nodeAllocations_ = other.nodeAllocations_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureNodeAllocationsIsMutable();
              nodeAllocations_.addAll(other.nodeAllocations_);
            }
            onChanged();
          }
        } else {
          if (!other.nodeAllocations_.isEmpty()) {
            if (nodeAllocationsBuilder_.isEmpty()) {
              nodeAllocationsBuilder_.dispose();
              nodeAllocationsBuilder_ = null;
              nodeAllocations_ = other.nodeAllocations_;
              bitField0_ = (bitField0_ & ~0x00000004);
              nodeAllocationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNodeAllocationsFieldBuilder()
                      : null;
            } else {
              nodeAllocationsBuilder_.addAllMessages(other.nodeAllocations_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllocatedRegionsIsMutable();
                  allocatedRegions_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  allocatedAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
                              .parser(),
                          extensionRegistry);
                  if (nodeAllocationsBuilder_ == null) {
                    ensureNodeAllocationsIsMutable();
                    nodeAllocations_.add(m);
                  } else {
                    nodeAllocationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList allocatedRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllocatedRegionsIsMutable() {
        if (!allocatedRegions_.isModifiable()) {
          allocatedRegions_ = new com.google.protobuf.LazyStringArrayList(allocatedRegions_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return A list containing the allocatedRegions.
       */
      public com.google.protobuf.ProtocolStringList getAllocatedRegionsList() {
        allocatedRegions_.makeImmutable();
        return allocatedRegions_;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return The count of allocatedRegions.
       */
      public int getAllocatedRegionsCount() {
        return allocatedRegions_.size();
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allocatedRegions at the given index.
       */
      public java.lang.String getAllocatedRegions(int index) {
        return allocatedRegions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allocatedRegions at the given index.
       */
      public com.google.protobuf.ByteString getAllocatedRegionsBytes(int index) {
        return allocatedRegions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The allocatedRegions to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedRegions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param value The allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedRegions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param values The allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllocatedRegions(java.lang.Iterable<java.lang.String> values) {
        ensureAllocatedRegionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allocatedRegions_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedRegions() {
        allocatedRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of regions in which the assets are allocated
       * </pre>
       *
       * <code>repeated string allocated_regions = 1;</code>
       *
       * @param value The bytes of the allocatedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllocatedRegionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllocatedRegionsIsMutable();
        allocatedRegions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long allocatedAssetCount_;
      /**
       *
       *
       * <pre>
       * Count of assets which are allocated
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return The allocatedAssetCount.
       */
      @java.lang.Override
      public long getAllocatedAssetCount() {
        return allocatedAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of assets which are allocated
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @param value The allocatedAssetCount to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedAssetCount(long value) {

        allocatedAssetCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets which are allocated
       * </pre>
       *
       * <code>int64 allocated_asset_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allocatedAssetCount_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>
          nodeAllocations_ = java.util.Collections.emptyList();

      private void ensureNodeAllocationsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          nodeAllocations_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>(
                  nodeAllocations_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder>
          nodeAllocationsBuilder_;

      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>
          getNodeAllocationsList() {
        if (nodeAllocationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(nodeAllocations_);
        } else {
          return nodeAllocationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public int getNodeAllocationsCount() {
        if (nodeAllocationsBuilder_ == null) {
          return nodeAllocations_.size();
        } else {
          return nodeAllocationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
          getNodeAllocations(int index) {
        if (nodeAllocationsBuilder_ == null) {
          return nodeAllocations_.get(index);
        } else {
          return nodeAllocationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder setNodeAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation value) {
        if (nodeAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.set(index, value);
          onChanged();
        } else {
          nodeAllocationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder setNodeAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
              builderForValue) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.set(index, builderForValue.build());
          onChanged();
        } else {
          nodeAllocationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation value) {
        if (nodeAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(value);
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation value) {
        if (nodeAllocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(index, value);
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
              builderForValue) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(builderForValue.build());
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addNodeAllocations(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
              builderForValue) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.add(index, builderForValue.build());
          onChanged();
        } else {
          nodeAllocationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder addAllNodeAllocations(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation>
              values) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodeAllocations_);
          onChanged();
        } else {
          nodeAllocationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder clearNodeAllocations() {
        if (nodeAllocationsBuilder_ == null) {
          nodeAllocations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          nodeAllocationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public Builder removeNodeAllocations(int index) {
        if (nodeAllocationsBuilder_ == null) {
          ensureNodeAllocationsIsMutable();
          nodeAllocations_.remove(index);
          onChanged();
        } else {
          nodeAllocationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
          getNodeAllocationsBuilder(int index) {
        return getNodeAllocationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder
          getNodeAllocationsOrBuilder(int index) {
        if (nodeAllocationsBuilder_ == null) {
          return nodeAllocations_.get(index);
        } else {
          return nodeAllocationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.ReportSummary
                      .SoleTenantNodeAllocationOrBuilder>
          getNodeAllocationsOrBuilderList() {
        if (nodeAllocationsBuilder_ != null) {
          return nodeAllocationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(nodeAllocations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
          addNodeAllocationsBuilder() {
        return getNodeAllocationsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
          addNodeAllocationsBuilder(int index) {
        return getNodeAllocationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Set of per-nodetype allocation records
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation node_allocations = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder>
          getNodeAllocationsBuilderList() {
        return getNodeAllocationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder>
          getNodeAllocationsFieldBuilder() {
        if (nodeAllocationsBuilder_ == null) {
          nodeAllocationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation,
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
                      .Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary
                      .SoleTenantNodeAllocationOrBuilder>(
                  nodeAllocations_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          nodeAllocations_ = null;
        }
        return nodeAllocationsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SoleTenantFinding> PARSER =
        new com.google.protobuf.AbstractParser<SoleTenantFinding>() {
          @java.lang.Override
          public SoleTenantFinding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SoleTenantFinding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SoleTenantFinding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SoleTenantNodeAllocationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Sole Tenant node type, e.g. "m3-node-128-3904"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
     *
     * @return Whether the node field is set.
     */
    boolean hasNode();
    /**
     *
     *
     * <pre>
     * Sole Tenant node type, e.g. "m3-node-128-3904"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
     *
     * @return The node.
     */
    com.google.cloud.migrationcenter.v1.SoleTenantNodeType getNode();
    /**
     *
     *
     * <pre>
     * Sole Tenant node type, e.g. "m3-node-128-3904"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
     */
    com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder getNodeOrBuilder();

    /**
     *
     *
     * <pre>
     * Count of this node type to be provisioned
     * </pre>
     *
     * <code>int64 node_count = 2;</code>
     *
     * @return The nodeCount.
     */
    long getNodeCount();

    /**
     *
     *
     * <pre>
     * Count of assets allocated to these nodes
     * </pre>
     *
     * <code>int64 allocated_asset_count = 3;</code>
     *
     * @return The allocatedAssetCount.
     */
    long getAllocatedAssetCount();
  }
  /**
   *
   *
   * <pre>
   * Represents the assets allocated to a specific Sole-Tenant node type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation}
   */
  public static final class SoleTenantNodeAllocation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation)
      SoleTenantNodeAllocationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SoleTenantNodeAllocation.newBuilder() to construct.
    private SoleTenantNodeAllocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SoleTenantNodeAllocation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SoleTenantNodeAllocation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantNodeAllocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantNodeAllocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
                  .class);
    }

    public static final int NODE_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.SoleTenantNodeType node_;
    /**
     *
     *
     * <pre>
     * Sole Tenant node type, e.g. "m3-node-128-3904"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
     *
     * @return Whether the node field is set.
     */
    @java.lang.Override
    public boolean hasNode() {
      return node_ != null;
    }
    /**
     *
     *
     * <pre>
     * Sole Tenant node type, e.g. "m3-node-128-3904"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
     *
     * @return The node.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeType getNode() {
      return node_ == null
          ? com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance()
          : node_;
    }
    /**
     *
     *
     * <pre>
     * Sole Tenant node type, e.g. "m3-node-128-3904"
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder getNodeOrBuilder() {
      return node_ == null
          ? com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance()
          : node_;
    }

    public static final int NODE_COUNT_FIELD_NUMBER = 2;
    private long nodeCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of this node type to be provisioned
     * </pre>
     *
     * <code>int64 node_count = 2;</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public long getNodeCount() {
      return nodeCount_;
    }

    public static final int ALLOCATED_ASSET_COUNT_FIELD_NUMBER = 3;
    private long allocatedAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of assets allocated to these nodes
     * </pre>
     *
     * <code>int64 allocated_asset_count = 3;</code>
     *
     * @return The allocatedAssetCount.
     */
    @java.lang.Override
    public long getAllocatedAssetCount() {
      return allocatedAssetCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (node_ != null) {
        output.writeMessage(1, getNode());
      }
      if (nodeCount_ != 0L) {
        output.writeInt64(2, nodeCount_);
      }
      if (allocatedAssetCount_ != 0L) {
        output.writeInt64(3, allocatedAssetCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (node_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getNode());
      }
      if (nodeCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, nodeCount_);
      }
      if (allocatedAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, allocatedAssetCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation) obj;

      if (hasNode() != other.hasNode()) return false;
      if (hasNode()) {
        if (!getNode().equals(other.getNode())) return false;
      }
      if (getNodeCount() != other.getNodeCount()) return false;
      if (getAllocatedAssetCount() != other.getAllocatedAssetCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasNode()) {
        hash = (37 * hash) + NODE_FIELD_NUMBER;
        hash = (53 * hash) + getNode().hashCode();
      }
      hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNodeCount());
      hash = (37 * hash) + ALLOCATED_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedAssetCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the assets allocated to a specific Sole-Tenant node type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation)
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantNodeAllocation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantNodeAllocation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        node_ = null;
        if (nodeBuilder_ != null) {
          nodeBuilder_.dispose();
          nodeBuilder_ = null;
        }
        nodeCount_ = 0L;
        allocatedAssetCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_SoleTenantNodeAllocation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
          buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.node_ = nodeBuilder_ == null ? node_ : nodeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.nodeCount_ = nodeCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.allocatedAssetCount_ = allocatedAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
                .getDefaultInstance()) return this;
        if (other.hasNode()) {
          mergeNode(other.getNode());
        }
        if (other.getNodeCount() != 0L) {
          setNodeCount(other.getNodeCount());
        }
        if (other.getAllocatedAssetCount() != 0L) {
          setAllocatedAssetCount(other.getAllocatedAssetCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getNodeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  nodeCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  allocatedAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.SoleTenantNodeType node_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.SoleTenantNodeType,
              com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder,
              com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>
          nodeBuilder_;
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       *
       * @return Whether the node field is set.
       */
      public boolean hasNode() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       *
       * @return The node.
       */
      public com.google.cloud.migrationcenter.v1.SoleTenantNodeType getNode() {
        if (nodeBuilder_ == null) {
          return node_ == null
              ? com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance()
              : node_;
        } else {
          return nodeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      public Builder setNode(com.google.cloud.migrationcenter.v1.SoleTenantNodeType value) {
        if (nodeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          node_ = value;
        } else {
          nodeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      public Builder setNode(
          com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder builderForValue) {
        if (nodeBuilder_ == null) {
          node_ = builderForValue.build();
        } else {
          nodeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      public Builder mergeNode(com.google.cloud.migrationcenter.v1.SoleTenantNodeType value) {
        if (nodeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && node_ != null
              && node_
                  != com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance()) {
            getNodeBuilder().mergeFrom(value);
          } else {
            node_ = value;
          }
        } else {
          nodeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      public Builder clearNode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        node_ = null;
        if (nodeBuilder_ != null) {
          nodeBuilder_.dispose();
          nodeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder getNodeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getNodeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder getNodeOrBuilder() {
        if (nodeBuilder_ != null) {
          return nodeBuilder_.getMessageOrBuilder();
        } else {
          return node_ == null
              ? com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance()
              : node_;
        }
      }
      /**
       *
       *
       * <pre>
       * Sole Tenant node type, e.g. "m3-node-128-3904"
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.SoleTenantNodeType node = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.SoleTenantNodeType,
              com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder,
              com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>
          getNodeFieldBuilder() {
        if (nodeBuilder_ == null) {
          nodeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.SoleTenantNodeType,
                  com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder,
                  com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>(
                  getNode(), getParentForChildren(), isClean());
          node_ = null;
        }
        return nodeBuilder_;
      }

      private long nodeCount_;
      /**
       *
       *
       * <pre>
       * Count of this node type to be provisioned
       * </pre>
       *
       * <code>int64 node_count = 2;</code>
       *
       * @return The nodeCount.
       */
      @java.lang.Override
      public long getNodeCount() {
        return nodeCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of this node type to be provisioned
       * </pre>
       *
       * <code>int64 node_count = 2;</code>
       *
       * @param value The nodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setNodeCount(long value) {

        nodeCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of this node type to be provisioned
       * </pre>
       *
       * <code>int64 node_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNodeCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        nodeCount_ = 0L;
        onChanged();
        return this;
      }

      private long allocatedAssetCount_;
      /**
       *
       *
       * <pre>
       * Count of assets allocated to these nodes
       * </pre>
       *
       * <code>int64 allocated_asset_count = 3;</code>
       *
       * @return The allocatedAssetCount.
       */
      @java.lang.Override
      public long getAllocatedAssetCount() {
        return allocatedAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of assets allocated to these nodes
       * </pre>
       *
       * <code>int64 allocated_asset_count = 3;</code>
       *
       * @param value The allocatedAssetCount to set.
       * @return This builder for chaining.
       */
      public Builder setAllocatedAssetCount(long value) {

        allocatedAssetCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of assets allocated to these nodes
       * </pre>
       *
       * <code>int64 allocated_asset_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllocatedAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allocatedAssetCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SoleTenantNodeAllocation> PARSER =
        new com.google.protobuf.AbstractParser<SoleTenantNodeAllocation>() {
          @java.lang.Override
          public SoleTenantNodeAllocation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SoleTenantNodeAllocation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SoleTenantNodeAllocation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroupPreferenceSetFindingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Display Name of the Preference Set
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Display Name of the Preference Set
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Description for the Preference Set.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Description for the Preference Set.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * A set of preferences that applies to all machines in the context.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
     * </code>
     *
     * @return Whether the machinePreferences field is set.
     */
    boolean hasMachinePreferences();
    /**
     *
     *
     * <pre>
     * A set of preferences that applies to all machines in the context.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
     * </code>
     *
     * @return The machinePreferences.
     */
    com.google.cloud.migrationcenter.v1.VirtualMachinePreferences getMachinePreferences();
    /**
     *
     *
     * <pre>
     * A set of preferences that applies to all machines in the context.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder
        getMachinePreferencesOrBuilder();

    /**
     *
     *
     * <pre>
     * Total monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_total = 4;</code>
     *
     * @return Whether the monthlyCostTotal field is set.
     */
    boolean hasMonthlyCostTotal();
    /**
     *
     *
     * <pre>
     * Total monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_total = 4;</code>
     *
     * @return The monthlyCostTotal.
     */
    com.google.type.Money getMonthlyCostTotal();
    /**
     *
     *
     * <pre>
     * Total monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_total = 4;</code>
     */
    com.google.type.MoneyOrBuilder getMonthlyCostTotalOrBuilder();

    /**
     *
     *
     * <pre>
     * Compute monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_compute = 5;</code>
     *
     * @return Whether the monthlyCostCompute field is set.
     */
    boolean hasMonthlyCostCompute();
    /**
     *
     *
     * <pre>
     * Compute monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_compute = 5;</code>
     *
     * @return The monthlyCostCompute.
     */
    com.google.type.Money getMonthlyCostCompute();
    /**
     *
     *
     * <pre>
     * Compute monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_compute = 5;</code>
     */
    com.google.type.MoneyOrBuilder getMonthlyCostComputeOrBuilder();

    /**
     *
     *
     * <pre>
     * Licensing monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_os_license = 6;</code>
     *
     * @return Whether the monthlyCostOsLicense field is set.
     */
    boolean hasMonthlyCostOsLicense();
    /**
     *
     *
     * <pre>
     * Licensing monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_os_license = 6;</code>
     *
     * @return The monthlyCostOsLicense.
     */
    com.google.type.Money getMonthlyCostOsLicense();
    /**
     *
     *
     * <pre>
     * Licensing monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_os_license = 6;</code>
     */
    com.google.type.MoneyOrBuilder getMonthlyCostOsLicenseOrBuilder();

    /**
     *
     *
     * <pre>
     * Network Egress monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
     *
     * @return Whether the monthlyCostNetworkEgress field is set.
     */
    boolean hasMonthlyCostNetworkEgress();
    /**
     *
     *
     * <pre>
     * Network Egress monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
     *
     * @return The monthlyCostNetworkEgress.
     */
    com.google.type.Money getMonthlyCostNetworkEgress();
    /**
     *
     *
     * <pre>
     * Network Egress monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
     */
    com.google.type.MoneyOrBuilder getMonthlyCostNetworkEgressOrBuilder();

    /**
     *
     *
     * <pre>
     * Storage monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_storage = 8;</code>
     *
     * @return Whether the monthlyCostStorage field is set.
     */
    boolean hasMonthlyCostStorage();
    /**
     *
     *
     * <pre>
     * Storage monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_storage = 8;</code>
     *
     * @return The monthlyCostStorage.
     */
    com.google.type.Money getMonthlyCostStorage();
    /**
     *
     *
     * <pre>
     * Storage monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_storage = 8;</code>
     */
    com.google.type.MoneyOrBuilder getMonthlyCostStorageOrBuilder();

    /**
     *
     *
     * <pre>
     * Miscellaneous monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_other = 9;</code>
     *
     * @return Whether the monthlyCostOther field is set.
     */
    boolean hasMonthlyCostOther();
    /**
     *
     *
     * <pre>
     * Miscellaneous monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_other = 9;</code>
     *
     * @return The monthlyCostOther.
     */
    com.google.type.Money getMonthlyCostOther();
    /**
     *
     *
     * <pre>
     * Miscellaneous monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_other = 9;</code>
     */
    com.google.type.MoneyOrBuilder getMonthlyCostOtherOrBuilder();

    /**
     *
     *
     * <pre>
     * A set of findings that applies to Compute Engine machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
     * </code>
     *
     * @return Whether the computeEngineFinding field is set.
     */
    boolean hasComputeEngineFinding();
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Compute Engine machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
     * </code>
     *
     * @return The computeEngineFinding.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        getComputeEngineFinding();
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Compute Engine machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder
        getComputeEngineFindingOrBuilder();

    /**
     *
     *
     * <pre>
     * A set of findings that applies to VMWare machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
     * </code>
     *
     * @return Whether the vmwareEngineFinding field is set.
     */
    boolean hasVmwareEngineFinding();
    /**
     *
     *
     * <pre>
     * A set of findings that applies to VMWare machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
     * </code>
     *
     * @return The vmwareEngineFinding.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding getVmwareEngineFinding();
    /**
     *
     *
     * <pre>
     * A set of findings that applies to VMWare machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder
        getVmwareEngineFindingOrBuilder();

    /**
     *
     *
     * <pre>
     * A set of findings that applies to Sole-Tenant machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
     * </code>
     *
     * @return Whether the soleTenantFinding field is set.
     */
    boolean hasSoleTenantFinding();
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Sole-Tenant machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
     * </code>
     *
     * @return The soleTenantFinding.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding getSoleTenantFinding();
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Sole-Tenant machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder
        getSoleTenantFindingOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Summary Findings for a specific Group/PreferenceSet combination.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding}
   */
  public static final class GroupPreferenceSetFinding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding)
      GroupPreferenceSetFindingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroupPreferenceSetFinding.newBuilder() to construct.
    private GroupPreferenceSetFinding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroupPreferenceSetFinding() {
      displayName_ = "";
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroupPreferenceSetFinding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupPreferenceSetFinding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupPreferenceSetFinding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
                  .class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display Name of the Preference Set
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Display Name of the Preference Set
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description for the Preference Set.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description for the Preference Set.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MACHINE_PREFERENCES_FIELD_NUMBER = 3;
    private com.google.cloud.migrationcenter.v1.VirtualMachinePreferences machinePreferences_;
    /**
     *
     *
     * <pre>
     * A set of preferences that applies to all machines in the context.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
     * </code>
     *
     * @return Whether the machinePreferences field is set.
     */
    @java.lang.Override
    public boolean hasMachinePreferences() {
      return machinePreferences_ != null;
    }
    /**
     *
     *
     * <pre>
     * A set of preferences that applies to all machines in the context.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
     * </code>
     *
     * @return The machinePreferences.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences getMachinePreferences() {
      return machinePreferences_ == null
          ? com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.getDefaultInstance()
          : machinePreferences_;
    }
    /**
     *
     *
     * <pre>
     * A set of preferences that applies to all machines in the context.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder
        getMachinePreferencesOrBuilder() {
      return machinePreferences_ == null
          ? com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.getDefaultInstance()
          : machinePreferences_;
    }

    public static final int MONTHLY_COST_TOTAL_FIELD_NUMBER = 4;
    private com.google.type.Money monthlyCostTotal_;
    /**
     *
     *
     * <pre>
     * Total monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_total = 4;</code>
     *
     * @return Whether the monthlyCostTotal field is set.
     */
    @java.lang.Override
    public boolean hasMonthlyCostTotal() {
      return monthlyCostTotal_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_total = 4;</code>
     *
     * @return The monthlyCostTotal.
     */
    @java.lang.Override
    public com.google.type.Money getMonthlyCostTotal() {
      return monthlyCostTotal_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostTotal_;
    }
    /**
     *
     *
     * <pre>
     * Total monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_total = 4;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMonthlyCostTotalOrBuilder() {
      return monthlyCostTotal_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostTotal_;
    }

    public static final int MONTHLY_COST_COMPUTE_FIELD_NUMBER = 5;
    private com.google.type.Money monthlyCostCompute_;
    /**
     *
     *
     * <pre>
     * Compute monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_compute = 5;</code>
     *
     * @return Whether the monthlyCostCompute field is set.
     */
    @java.lang.Override
    public boolean hasMonthlyCostCompute() {
      return monthlyCostCompute_ != null;
    }
    /**
     *
     *
     * <pre>
     * Compute monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_compute = 5;</code>
     *
     * @return The monthlyCostCompute.
     */
    @java.lang.Override
    public com.google.type.Money getMonthlyCostCompute() {
      return monthlyCostCompute_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostCompute_;
    }
    /**
     *
     *
     * <pre>
     * Compute monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_compute = 5;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMonthlyCostComputeOrBuilder() {
      return monthlyCostCompute_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostCompute_;
    }

    public static final int MONTHLY_COST_OS_LICENSE_FIELD_NUMBER = 6;
    private com.google.type.Money monthlyCostOsLicense_;
    /**
     *
     *
     * <pre>
     * Licensing monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_os_license = 6;</code>
     *
     * @return Whether the monthlyCostOsLicense field is set.
     */
    @java.lang.Override
    public boolean hasMonthlyCostOsLicense() {
      return monthlyCostOsLicense_ != null;
    }
    /**
     *
     *
     * <pre>
     * Licensing monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_os_license = 6;</code>
     *
     * @return The monthlyCostOsLicense.
     */
    @java.lang.Override
    public com.google.type.Money getMonthlyCostOsLicense() {
      return monthlyCostOsLicense_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostOsLicense_;
    }
    /**
     *
     *
     * <pre>
     * Licensing monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_os_license = 6;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMonthlyCostOsLicenseOrBuilder() {
      return monthlyCostOsLicense_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostOsLicense_;
    }

    public static final int MONTHLY_COST_NETWORK_EGRESS_FIELD_NUMBER = 7;
    private com.google.type.Money monthlyCostNetworkEgress_;
    /**
     *
     *
     * <pre>
     * Network Egress monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
     *
     * @return Whether the monthlyCostNetworkEgress field is set.
     */
    @java.lang.Override
    public boolean hasMonthlyCostNetworkEgress() {
      return monthlyCostNetworkEgress_ != null;
    }
    /**
     *
     *
     * <pre>
     * Network Egress monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
     *
     * @return The monthlyCostNetworkEgress.
     */
    @java.lang.Override
    public com.google.type.Money getMonthlyCostNetworkEgress() {
      return monthlyCostNetworkEgress_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostNetworkEgress_;
    }
    /**
     *
     *
     * <pre>
     * Network Egress monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMonthlyCostNetworkEgressOrBuilder() {
      return monthlyCostNetworkEgress_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostNetworkEgress_;
    }

    public static final int MONTHLY_COST_STORAGE_FIELD_NUMBER = 8;
    private com.google.type.Money monthlyCostStorage_;
    /**
     *
     *
     * <pre>
     * Storage monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_storage = 8;</code>
     *
     * @return Whether the monthlyCostStorage field is set.
     */
    @java.lang.Override
    public boolean hasMonthlyCostStorage() {
      return monthlyCostStorage_ != null;
    }
    /**
     *
     *
     * <pre>
     * Storage monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_storage = 8;</code>
     *
     * @return The monthlyCostStorage.
     */
    @java.lang.Override
    public com.google.type.Money getMonthlyCostStorage() {
      return monthlyCostStorage_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostStorage_;
    }
    /**
     *
     *
     * <pre>
     * Storage monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_storage = 8;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMonthlyCostStorageOrBuilder() {
      return monthlyCostStorage_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostStorage_;
    }

    public static final int MONTHLY_COST_OTHER_FIELD_NUMBER = 9;
    private com.google.type.Money monthlyCostOther_;
    /**
     *
     *
     * <pre>
     * Miscellaneous monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_other = 9;</code>
     *
     * @return Whether the monthlyCostOther field is set.
     */
    @java.lang.Override
    public boolean hasMonthlyCostOther() {
      return monthlyCostOther_ != null;
    }
    /**
     *
     *
     * <pre>
     * Miscellaneous monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_other = 9;</code>
     *
     * @return The monthlyCostOther.
     */
    @java.lang.Override
    public com.google.type.Money getMonthlyCostOther() {
      return monthlyCostOther_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostOther_;
    }
    /**
     *
     *
     * <pre>
     * Miscellaneous monthly cost for this preference set.
     * </pre>
     *
     * <code>.google.type.Money monthly_cost_other = 9;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMonthlyCostOtherOrBuilder() {
      return monthlyCostOther_ == null
          ? com.google.type.Money.getDefaultInstance()
          : monthlyCostOther_;
    }

    public static final int COMPUTE_ENGINE_FINDING_FIELD_NUMBER = 10;
    private com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        computeEngineFinding_;
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Compute Engine machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
     * </code>
     *
     * @return Whether the computeEngineFinding field is set.
     */
    @java.lang.Override
    public boolean hasComputeEngineFinding() {
      return computeEngineFinding_ != null;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Compute Engine machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
     * </code>
     *
     * @return The computeEngineFinding.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
        getComputeEngineFinding() {
      return computeEngineFinding_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
              .getDefaultInstance()
          : computeEngineFinding_;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Compute Engine machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder
        getComputeEngineFindingOrBuilder() {
      return computeEngineFinding_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
              .getDefaultInstance()
          : computeEngineFinding_;
    }

    public static final int VMWARE_ENGINE_FINDING_FIELD_NUMBER = 11;
    private com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        vmwareEngineFinding_;
    /**
     *
     *
     * <pre>
     * A set of findings that applies to VMWare machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
     * </code>
     *
     * @return Whether the vmwareEngineFinding field is set.
     */
    @java.lang.Override
    public boolean hasVmwareEngineFinding() {
      return vmwareEngineFinding_ != null;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to VMWare machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
     * </code>
     *
     * @return The vmwareEngineFinding.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
        getVmwareEngineFinding() {
      return vmwareEngineFinding_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
              .getDefaultInstance()
          : vmwareEngineFinding_;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to VMWare machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder
        getVmwareEngineFindingOrBuilder() {
      return vmwareEngineFinding_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
              .getDefaultInstance()
          : vmwareEngineFinding_;
    }

    public static final int SOLE_TENANT_FINDING_FIELD_NUMBER = 12;
    private com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding soleTenantFinding_;
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Sole-Tenant machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
     * </code>
     *
     * @return Whether the soleTenantFinding field is set.
     */
    @java.lang.Override
    public boolean hasSoleTenantFinding() {
      return soleTenantFinding_ != null;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Sole-Tenant machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
     * </code>
     *
     * @return The soleTenantFinding.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
        getSoleTenantFinding() {
      return soleTenantFinding_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.getDefaultInstance()
          : soleTenantFinding_;
    }
    /**
     *
     *
     * <pre>
     * A set of findings that applies to Sole-Tenant machines in the input.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder
        getSoleTenantFindingOrBuilder() {
      return soleTenantFinding_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.getDefaultInstance()
          : soleTenantFinding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (machinePreferences_ != null) {
        output.writeMessage(3, getMachinePreferences());
      }
      if (monthlyCostTotal_ != null) {
        output.writeMessage(4, getMonthlyCostTotal());
      }
      if (monthlyCostCompute_ != null) {
        output.writeMessage(5, getMonthlyCostCompute());
      }
      if (monthlyCostOsLicense_ != null) {
        output.writeMessage(6, getMonthlyCostOsLicense());
      }
      if (monthlyCostNetworkEgress_ != null) {
        output.writeMessage(7, getMonthlyCostNetworkEgress());
      }
      if (monthlyCostStorage_ != null) {
        output.writeMessage(8, getMonthlyCostStorage());
      }
      if (monthlyCostOther_ != null) {
        output.writeMessage(9, getMonthlyCostOther());
      }
      if (computeEngineFinding_ != null) {
        output.writeMessage(10, getComputeEngineFinding());
      }
      if (vmwareEngineFinding_ != null) {
        output.writeMessage(11, getVmwareEngineFinding());
      }
      if (soleTenantFinding_ != null) {
        output.writeMessage(12, getSoleTenantFinding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (machinePreferences_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMachinePreferences());
      }
      if (monthlyCostTotal_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMonthlyCostTotal());
      }
      if (monthlyCostCompute_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMonthlyCostCompute());
      }
      if (monthlyCostOsLicense_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMonthlyCostOsLicense());
      }
      if (monthlyCostNetworkEgress_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, getMonthlyCostNetworkEgress());
      }
      if (monthlyCostStorage_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(8, getMonthlyCostStorage());
      }
      if (monthlyCostOther_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMonthlyCostOther());
      }
      if (computeEngineFinding_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(10, getComputeEngineFinding());
      }
      if (vmwareEngineFinding_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(11, getVmwareEngineFinding());
      }
      if (soleTenantFinding_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(12, getSoleTenantFinding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasMachinePreferences() != other.hasMachinePreferences()) return false;
      if (hasMachinePreferences()) {
        if (!getMachinePreferences().equals(other.getMachinePreferences())) return false;
      }
      if (hasMonthlyCostTotal() != other.hasMonthlyCostTotal()) return false;
      if (hasMonthlyCostTotal()) {
        if (!getMonthlyCostTotal().equals(other.getMonthlyCostTotal())) return false;
      }
      if (hasMonthlyCostCompute() != other.hasMonthlyCostCompute()) return false;
      if (hasMonthlyCostCompute()) {
        if (!getMonthlyCostCompute().equals(other.getMonthlyCostCompute())) return false;
      }
      if (hasMonthlyCostOsLicense() != other.hasMonthlyCostOsLicense()) return false;
      if (hasMonthlyCostOsLicense()) {
        if (!getMonthlyCostOsLicense().equals(other.getMonthlyCostOsLicense())) return false;
      }
      if (hasMonthlyCostNetworkEgress() != other.hasMonthlyCostNetworkEgress()) return false;
      if (hasMonthlyCostNetworkEgress()) {
        if (!getMonthlyCostNetworkEgress().equals(other.getMonthlyCostNetworkEgress()))
          return false;
      }
      if (hasMonthlyCostStorage() != other.hasMonthlyCostStorage()) return false;
      if (hasMonthlyCostStorage()) {
        if (!getMonthlyCostStorage().equals(other.getMonthlyCostStorage())) return false;
      }
      if (hasMonthlyCostOther() != other.hasMonthlyCostOther()) return false;
      if (hasMonthlyCostOther()) {
        if (!getMonthlyCostOther().equals(other.getMonthlyCostOther())) return false;
      }
      if (hasComputeEngineFinding() != other.hasComputeEngineFinding()) return false;
      if (hasComputeEngineFinding()) {
        if (!getComputeEngineFinding().equals(other.getComputeEngineFinding())) return false;
      }
      if (hasVmwareEngineFinding() != other.hasVmwareEngineFinding()) return false;
      if (hasVmwareEngineFinding()) {
        if (!getVmwareEngineFinding().equals(other.getVmwareEngineFinding())) return false;
      }
      if (hasSoleTenantFinding() != other.hasSoleTenantFinding()) return false;
      if (hasSoleTenantFinding()) {
        if (!getSoleTenantFinding().equals(other.getSoleTenantFinding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasMachinePreferences()) {
        hash = (37 * hash) + MACHINE_PREFERENCES_FIELD_NUMBER;
        hash = (53 * hash) + getMachinePreferences().hashCode();
      }
      if (hasMonthlyCostTotal()) {
        hash = (37 * hash) + MONTHLY_COST_TOTAL_FIELD_NUMBER;
        hash = (53 * hash) + getMonthlyCostTotal().hashCode();
      }
      if (hasMonthlyCostCompute()) {
        hash = (37 * hash) + MONTHLY_COST_COMPUTE_FIELD_NUMBER;
        hash = (53 * hash) + getMonthlyCostCompute().hashCode();
      }
      if (hasMonthlyCostOsLicense()) {
        hash = (37 * hash) + MONTHLY_COST_OS_LICENSE_FIELD_NUMBER;
        hash = (53 * hash) + getMonthlyCostOsLicense().hashCode();
      }
      if (hasMonthlyCostNetworkEgress()) {
        hash = (37 * hash) + MONTHLY_COST_NETWORK_EGRESS_FIELD_NUMBER;
        hash = (53 * hash) + getMonthlyCostNetworkEgress().hashCode();
      }
      if (hasMonthlyCostStorage()) {
        hash = (37 * hash) + MONTHLY_COST_STORAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMonthlyCostStorage().hashCode();
      }
      if (hasMonthlyCostOther()) {
        hash = (37 * hash) + MONTHLY_COST_OTHER_FIELD_NUMBER;
        hash = (53 * hash) + getMonthlyCostOther().hashCode();
      }
      if (hasComputeEngineFinding()) {
        hash = (37 * hash) + COMPUTE_ENGINE_FINDING_FIELD_NUMBER;
        hash = (53 * hash) + getComputeEngineFinding().hashCode();
      }
      if (hasVmwareEngineFinding()) {
        hash = (37 * hash) + VMWARE_ENGINE_FINDING_FIELD_NUMBER;
        hash = (53 * hash) + getVmwareEngineFinding().hashCode();
      }
      if (hasSoleTenantFinding()) {
        hash = (37 * hash) + SOLE_TENANT_FINDING_FIELD_NUMBER;
        hash = (53 * hash) + getSoleTenantFinding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Summary Findings for a specific Group/PreferenceSet combination.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding)
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFindingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupPreferenceSetFinding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupPreferenceSetFinding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        description_ = "";
        machinePreferences_ = null;
        if (machinePreferencesBuilder_ != null) {
          machinePreferencesBuilder_.dispose();
          machinePreferencesBuilder_ = null;
        }
        monthlyCostTotal_ = null;
        if (monthlyCostTotalBuilder_ != null) {
          monthlyCostTotalBuilder_.dispose();
          monthlyCostTotalBuilder_ = null;
        }
        monthlyCostCompute_ = null;
        if (monthlyCostComputeBuilder_ != null) {
          monthlyCostComputeBuilder_.dispose();
          monthlyCostComputeBuilder_ = null;
        }
        monthlyCostOsLicense_ = null;
        if (monthlyCostOsLicenseBuilder_ != null) {
          monthlyCostOsLicenseBuilder_.dispose();
          monthlyCostOsLicenseBuilder_ = null;
        }
        monthlyCostNetworkEgress_ = null;
        if (monthlyCostNetworkEgressBuilder_ != null) {
          monthlyCostNetworkEgressBuilder_.dispose();
          monthlyCostNetworkEgressBuilder_ = null;
        }
        monthlyCostStorage_ = null;
        if (monthlyCostStorageBuilder_ != null) {
          monthlyCostStorageBuilder_.dispose();
          monthlyCostStorageBuilder_ = null;
        }
        monthlyCostOther_ = null;
        if (monthlyCostOtherBuilder_ != null) {
          monthlyCostOtherBuilder_.dispose();
          monthlyCostOtherBuilder_ = null;
        }
        computeEngineFinding_ = null;
        if (computeEngineFindingBuilder_ != null) {
          computeEngineFindingBuilder_.dispose();
          computeEngineFindingBuilder_ = null;
        }
        vmwareEngineFinding_ = null;
        if (vmwareEngineFindingBuilder_ != null) {
          vmwareEngineFindingBuilder_.dispose();
          vmwareEngineFindingBuilder_ = null;
        }
        soleTenantFinding_ = null;
        if (soleTenantFindingBuilder_ != null) {
          soleTenantFindingBuilder_.dispose();
          soleTenantFindingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupPreferenceSetFinding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
          buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.machinePreferences_ =
              machinePreferencesBuilder_ == null
                  ? machinePreferences_
                  : machinePreferencesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.monthlyCostTotal_ =
              monthlyCostTotalBuilder_ == null
                  ? monthlyCostTotal_
                  : monthlyCostTotalBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.monthlyCostCompute_ =
              monthlyCostComputeBuilder_ == null
                  ? monthlyCostCompute_
                  : monthlyCostComputeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.monthlyCostOsLicense_ =
              monthlyCostOsLicenseBuilder_ == null
                  ? monthlyCostOsLicense_
                  : monthlyCostOsLicenseBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.monthlyCostNetworkEgress_ =
              monthlyCostNetworkEgressBuilder_ == null
                  ? monthlyCostNetworkEgress_
                  : monthlyCostNetworkEgressBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.monthlyCostStorage_ =
              monthlyCostStorageBuilder_ == null
                  ? monthlyCostStorage_
                  : monthlyCostStorageBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.monthlyCostOther_ =
              monthlyCostOtherBuilder_ == null
                  ? monthlyCostOther_
                  : monthlyCostOtherBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.computeEngineFinding_ =
              computeEngineFindingBuilder_ == null
                  ? computeEngineFinding_
                  : computeEngineFindingBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.vmwareEngineFinding_ =
              vmwareEngineFindingBuilder_ == null
                  ? vmwareEngineFinding_
                  : vmwareEngineFindingBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.soleTenantFinding_ =
              soleTenantFindingBuilder_ == null
                  ? soleTenantFinding_
                  : soleTenantFindingBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
                .getDefaultInstance()) return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasMachinePreferences()) {
          mergeMachinePreferences(other.getMachinePreferences());
        }
        if (other.hasMonthlyCostTotal()) {
          mergeMonthlyCostTotal(other.getMonthlyCostTotal());
        }
        if (other.hasMonthlyCostCompute()) {
          mergeMonthlyCostCompute(other.getMonthlyCostCompute());
        }
        if (other.hasMonthlyCostOsLicense()) {
          mergeMonthlyCostOsLicense(other.getMonthlyCostOsLicense());
        }
        if (other.hasMonthlyCostNetworkEgress()) {
          mergeMonthlyCostNetworkEgress(other.getMonthlyCostNetworkEgress());
        }
        if (other.hasMonthlyCostStorage()) {
          mergeMonthlyCostStorage(other.getMonthlyCostStorage());
        }
        if (other.hasMonthlyCostOther()) {
          mergeMonthlyCostOther(other.getMonthlyCostOther());
        }
        if (other.hasComputeEngineFinding()) {
          mergeComputeEngineFinding(other.getComputeEngineFinding());
        }
        if (other.hasVmwareEngineFinding()) {
          mergeVmwareEngineFinding(other.getVmwareEngineFinding());
        }
        if (other.hasSoleTenantFinding()) {
          mergeSoleTenantFinding(other.getSoleTenantFinding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getMachinePreferencesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getMonthlyCostTotalFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getMonthlyCostComputeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getMonthlyCostOsLicenseFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getMonthlyCostNetworkEgressFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getMonthlyCostStorageFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getMonthlyCostOtherFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(
                      getComputeEngineFindingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 82
              case 90:
                {
                  input.readMessage(
                      getVmwareEngineFindingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000400;
                  break;
                } // case 90
              case 98:
                {
                  input.readMessage(
                      getSoleTenantFindingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000800;
                  break;
                } // case 98
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Display Name of the Preference Set
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display Name of the Preference Set
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display Name of the Preference Set
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display Name of the Preference Set
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display Name of the Preference Set
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Description for the Preference Set.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description for the Preference Set.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description for the Preference Set.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description for the Preference Set.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description for the Preference Set.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.migrationcenter.v1.VirtualMachinePreferences machinePreferences_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferences,
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder,
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder>
          machinePreferencesBuilder_;
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       *
       * @return Whether the machinePreferences field is set.
       */
      public boolean hasMachinePreferences() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       *
       * @return The machinePreferences.
       */
      public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences getMachinePreferences() {
        if (machinePreferencesBuilder_ == null) {
          return machinePreferences_ == null
              ? com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.getDefaultInstance()
              : machinePreferences_;
        } else {
          return machinePreferencesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      public Builder setMachinePreferences(
          com.google.cloud.migrationcenter.v1.VirtualMachinePreferences value) {
        if (machinePreferencesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          machinePreferences_ = value;
        } else {
          machinePreferencesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      public Builder setMachinePreferences(
          com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder builderForValue) {
        if (machinePreferencesBuilder_ == null) {
          machinePreferences_ = builderForValue.build();
        } else {
          machinePreferencesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      public Builder mergeMachinePreferences(
          com.google.cloud.migrationcenter.v1.VirtualMachinePreferences value) {
        if (machinePreferencesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && machinePreferences_ != null
              && machinePreferences_
                  != com.google.cloud.migrationcenter.v1.VirtualMachinePreferences
                      .getDefaultInstance()) {
            getMachinePreferencesBuilder().mergeFrom(value);
          } else {
            machinePreferences_ = value;
          }
        } else {
          machinePreferencesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      public Builder clearMachinePreferences() {
        bitField0_ = (bitField0_ & ~0x00000004);
        machinePreferences_ = null;
        if (machinePreferencesBuilder_ != null) {
          machinePreferencesBuilder_.dispose();
          machinePreferencesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder
          getMachinePreferencesBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getMachinePreferencesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder
          getMachinePreferencesOrBuilder() {
        if (machinePreferencesBuilder_ != null) {
          return machinePreferencesBuilder_.getMessageOrBuilder();
        } else {
          return machinePreferences_ == null
              ? com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.getDefaultInstance()
              : machinePreferences_;
        }
      }
      /**
       *
       *
       * <pre>
       * A set of preferences that applies to all machines in the context.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.VirtualMachinePreferences machine_preferences = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferences,
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder,
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder>
          getMachinePreferencesFieldBuilder() {
        if (machinePreferencesBuilder_ == null) {
          machinePreferencesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.VirtualMachinePreferences,
                  com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder,
                  com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder>(
                  getMachinePreferences(), getParentForChildren(), isClean());
          machinePreferences_ = null;
        }
        return machinePreferencesBuilder_;
      }

      private com.google.type.Money monthlyCostTotal_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          monthlyCostTotalBuilder_;
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       *
       * @return Whether the monthlyCostTotal field is set.
       */
      public boolean hasMonthlyCostTotal() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       *
       * @return The monthlyCostTotal.
       */
      public com.google.type.Money getMonthlyCostTotal() {
        if (monthlyCostTotalBuilder_ == null) {
          return monthlyCostTotal_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostTotal_;
        } else {
          return monthlyCostTotalBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      public Builder setMonthlyCostTotal(com.google.type.Money value) {
        if (monthlyCostTotalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monthlyCostTotal_ = value;
        } else {
          monthlyCostTotalBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      public Builder setMonthlyCostTotal(com.google.type.Money.Builder builderForValue) {
        if (monthlyCostTotalBuilder_ == null) {
          monthlyCostTotal_ = builderForValue.build();
        } else {
          monthlyCostTotalBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      public Builder mergeMonthlyCostTotal(com.google.type.Money value) {
        if (monthlyCostTotalBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && monthlyCostTotal_ != null
              && monthlyCostTotal_ != com.google.type.Money.getDefaultInstance()) {
            getMonthlyCostTotalBuilder().mergeFrom(value);
          } else {
            monthlyCostTotal_ = value;
          }
        } else {
          monthlyCostTotalBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      public Builder clearMonthlyCostTotal() {
        bitField0_ = (bitField0_ & ~0x00000008);
        monthlyCostTotal_ = null;
        if (monthlyCostTotalBuilder_ != null) {
          monthlyCostTotalBuilder_.dispose();
          monthlyCostTotalBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      public com.google.type.Money.Builder getMonthlyCostTotalBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getMonthlyCostTotalFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      public com.google.type.MoneyOrBuilder getMonthlyCostTotalOrBuilder() {
        if (monthlyCostTotalBuilder_ != null) {
          return monthlyCostTotalBuilder_.getMessageOrBuilder();
        } else {
          return monthlyCostTotal_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostTotal_;
        }
      }
      /**
       *
       *
       * <pre>
       * Total monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_total = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getMonthlyCostTotalFieldBuilder() {
        if (monthlyCostTotalBuilder_ == null) {
          monthlyCostTotalBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getMonthlyCostTotal(), getParentForChildren(), isClean());
          monthlyCostTotal_ = null;
        }
        return monthlyCostTotalBuilder_;
      }

      private com.google.type.Money monthlyCostCompute_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          monthlyCostComputeBuilder_;
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       *
       * @return Whether the monthlyCostCompute field is set.
       */
      public boolean hasMonthlyCostCompute() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       *
       * @return The monthlyCostCompute.
       */
      public com.google.type.Money getMonthlyCostCompute() {
        if (monthlyCostComputeBuilder_ == null) {
          return monthlyCostCompute_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostCompute_;
        } else {
          return monthlyCostComputeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      public Builder setMonthlyCostCompute(com.google.type.Money value) {
        if (monthlyCostComputeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monthlyCostCompute_ = value;
        } else {
          monthlyCostComputeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      public Builder setMonthlyCostCompute(com.google.type.Money.Builder builderForValue) {
        if (monthlyCostComputeBuilder_ == null) {
          monthlyCostCompute_ = builderForValue.build();
        } else {
          monthlyCostComputeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      public Builder mergeMonthlyCostCompute(com.google.type.Money value) {
        if (monthlyCostComputeBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && monthlyCostCompute_ != null
              && monthlyCostCompute_ != com.google.type.Money.getDefaultInstance()) {
            getMonthlyCostComputeBuilder().mergeFrom(value);
          } else {
            monthlyCostCompute_ = value;
          }
        } else {
          monthlyCostComputeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      public Builder clearMonthlyCostCompute() {
        bitField0_ = (bitField0_ & ~0x00000010);
        monthlyCostCompute_ = null;
        if (monthlyCostComputeBuilder_ != null) {
          monthlyCostComputeBuilder_.dispose();
          monthlyCostComputeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      public com.google.type.Money.Builder getMonthlyCostComputeBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getMonthlyCostComputeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      public com.google.type.MoneyOrBuilder getMonthlyCostComputeOrBuilder() {
        if (monthlyCostComputeBuilder_ != null) {
          return monthlyCostComputeBuilder_.getMessageOrBuilder();
        } else {
          return monthlyCostCompute_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostCompute_;
        }
      }
      /**
       *
       *
       * <pre>
       * Compute monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_compute = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getMonthlyCostComputeFieldBuilder() {
        if (monthlyCostComputeBuilder_ == null) {
          monthlyCostComputeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getMonthlyCostCompute(), getParentForChildren(), isClean());
          monthlyCostCompute_ = null;
        }
        return monthlyCostComputeBuilder_;
      }

      private com.google.type.Money monthlyCostOsLicense_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          monthlyCostOsLicenseBuilder_;
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       *
       * @return Whether the monthlyCostOsLicense field is set.
       */
      public boolean hasMonthlyCostOsLicense() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       *
       * @return The monthlyCostOsLicense.
       */
      public com.google.type.Money getMonthlyCostOsLicense() {
        if (monthlyCostOsLicenseBuilder_ == null) {
          return monthlyCostOsLicense_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostOsLicense_;
        } else {
          return monthlyCostOsLicenseBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      public Builder setMonthlyCostOsLicense(com.google.type.Money value) {
        if (monthlyCostOsLicenseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monthlyCostOsLicense_ = value;
        } else {
          monthlyCostOsLicenseBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      public Builder setMonthlyCostOsLicense(com.google.type.Money.Builder builderForValue) {
        if (monthlyCostOsLicenseBuilder_ == null) {
          monthlyCostOsLicense_ = builderForValue.build();
        } else {
          monthlyCostOsLicenseBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      public Builder mergeMonthlyCostOsLicense(com.google.type.Money value) {
        if (monthlyCostOsLicenseBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && monthlyCostOsLicense_ != null
              && monthlyCostOsLicense_ != com.google.type.Money.getDefaultInstance()) {
            getMonthlyCostOsLicenseBuilder().mergeFrom(value);
          } else {
            monthlyCostOsLicense_ = value;
          }
        } else {
          monthlyCostOsLicenseBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      public Builder clearMonthlyCostOsLicense() {
        bitField0_ = (bitField0_ & ~0x00000020);
        monthlyCostOsLicense_ = null;
        if (monthlyCostOsLicenseBuilder_ != null) {
          monthlyCostOsLicenseBuilder_.dispose();
          monthlyCostOsLicenseBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      public com.google.type.Money.Builder getMonthlyCostOsLicenseBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getMonthlyCostOsLicenseFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      public com.google.type.MoneyOrBuilder getMonthlyCostOsLicenseOrBuilder() {
        if (monthlyCostOsLicenseBuilder_ != null) {
          return monthlyCostOsLicenseBuilder_.getMessageOrBuilder();
        } else {
          return monthlyCostOsLicense_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostOsLicense_;
        }
      }
      /**
       *
       *
       * <pre>
       * Licensing monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_os_license = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getMonthlyCostOsLicenseFieldBuilder() {
        if (monthlyCostOsLicenseBuilder_ == null) {
          monthlyCostOsLicenseBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getMonthlyCostOsLicense(), getParentForChildren(), isClean());
          monthlyCostOsLicense_ = null;
        }
        return monthlyCostOsLicenseBuilder_;
      }

      private com.google.type.Money monthlyCostNetworkEgress_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          monthlyCostNetworkEgressBuilder_;
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       *
       * @return Whether the monthlyCostNetworkEgress field is set.
       */
      public boolean hasMonthlyCostNetworkEgress() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       *
       * @return The monthlyCostNetworkEgress.
       */
      public com.google.type.Money getMonthlyCostNetworkEgress() {
        if (monthlyCostNetworkEgressBuilder_ == null) {
          return monthlyCostNetworkEgress_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostNetworkEgress_;
        } else {
          return monthlyCostNetworkEgressBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      public Builder setMonthlyCostNetworkEgress(com.google.type.Money value) {
        if (monthlyCostNetworkEgressBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monthlyCostNetworkEgress_ = value;
        } else {
          monthlyCostNetworkEgressBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      public Builder setMonthlyCostNetworkEgress(com.google.type.Money.Builder builderForValue) {
        if (monthlyCostNetworkEgressBuilder_ == null) {
          monthlyCostNetworkEgress_ = builderForValue.build();
        } else {
          monthlyCostNetworkEgressBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      public Builder mergeMonthlyCostNetworkEgress(com.google.type.Money value) {
        if (monthlyCostNetworkEgressBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && monthlyCostNetworkEgress_ != null
              && monthlyCostNetworkEgress_ != com.google.type.Money.getDefaultInstance()) {
            getMonthlyCostNetworkEgressBuilder().mergeFrom(value);
          } else {
            monthlyCostNetworkEgress_ = value;
          }
        } else {
          monthlyCostNetworkEgressBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      public Builder clearMonthlyCostNetworkEgress() {
        bitField0_ = (bitField0_ & ~0x00000040);
        monthlyCostNetworkEgress_ = null;
        if (monthlyCostNetworkEgressBuilder_ != null) {
          monthlyCostNetworkEgressBuilder_.dispose();
          monthlyCostNetworkEgressBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      public com.google.type.Money.Builder getMonthlyCostNetworkEgressBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getMonthlyCostNetworkEgressFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      public com.google.type.MoneyOrBuilder getMonthlyCostNetworkEgressOrBuilder() {
        if (monthlyCostNetworkEgressBuilder_ != null) {
          return monthlyCostNetworkEgressBuilder_.getMessageOrBuilder();
        } else {
          return monthlyCostNetworkEgress_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostNetworkEgress_;
        }
      }
      /**
       *
       *
       * <pre>
       * Network Egress monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_network_egress = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getMonthlyCostNetworkEgressFieldBuilder() {
        if (monthlyCostNetworkEgressBuilder_ == null) {
          monthlyCostNetworkEgressBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getMonthlyCostNetworkEgress(), getParentForChildren(), isClean());
          monthlyCostNetworkEgress_ = null;
        }
        return monthlyCostNetworkEgressBuilder_;
      }

      private com.google.type.Money monthlyCostStorage_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          monthlyCostStorageBuilder_;
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       *
       * @return Whether the monthlyCostStorage field is set.
       */
      public boolean hasMonthlyCostStorage() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       *
       * @return The monthlyCostStorage.
       */
      public com.google.type.Money getMonthlyCostStorage() {
        if (monthlyCostStorageBuilder_ == null) {
          return monthlyCostStorage_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostStorage_;
        } else {
          return monthlyCostStorageBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      public Builder setMonthlyCostStorage(com.google.type.Money value) {
        if (monthlyCostStorageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monthlyCostStorage_ = value;
        } else {
          monthlyCostStorageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      public Builder setMonthlyCostStorage(com.google.type.Money.Builder builderForValue) {
        if (monthlyCostStorageBuilder_ == null) {
          monthlyCostStorage_ = builderForValue.build();
        } else {
          monthlyCostStorageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      public Builder mergeMonthlyCostStorage(com.google.type.Money value) {
        if (monthlyCostStorageBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && monthlyCostStorage_ != null
              && monthlyCostStorage_ != com.google.type.Money.getDefaultInstance()) {
            getMonthlyCostStorageBuilder().mergeFrom(value);
          } else {
            monthlyCostStorage_ = value;
          }
        } else {
          monthlyCostStorageBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      public Builder clearMonthlyCostStorage() {
        bitField0_ = (bitField0_ & ~0x00000080);
        monthlyCostStorage_ = null;
        if (monthlyCostStorageBuilder_ != null) {
          monthlyCostStorageBuilder_.dispose();
          monthlyCostStorageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      public com.google.type.Money.Builder getMonthlyCostStorageBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getMonthlyCostStorageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      public com.google.type.MoneyOrBuilder getMonthlyCostStorageOrBuilder() {
        if (monthlyCostStorageBuilder_ != null) {
          return monthlyCostStorageBuilder_.getMessageOrBuilder();
        } else {
          return monthlyCostStorage_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostStorage_;
        }
      }
      /**
       *
       *
       * <pre>
       * Storage monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_storage = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getMonthlyCostStorageFieldBuilder() {
        if (monthlyCostStorageBuilder_ == null) {
          monthlyCostStorageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getMonthlyCostStorage(), getParentForChildren(), isClean());
          monthlyCostStorage_ = null;
        }
        return monthlyCostStorageBuilder_;
      }

      private com.google.type.Money monthlyCostOther_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          monthlyCostOtherBuilder_;
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       *
       * @return Whether the monthlyCostOther field is set.
       */
      public boolean hasMonthlyCostOther() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       *
       * @return The monthlyCostOther.
       */
      public com.google.type.Money getMonthlyCostOther() {
        if (monthlyCostOtherBuilder_ == null) {
          return monthlyCostOther_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostOther_;
        } else {
          return monthlyCostOtherBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      public Builder setMonthlyCostOther(com.google.type.Money value) {
        if (monthlyCostOtherBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monthlyCostOther_ = value;
        } else {
          monthlyCostOtherBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      public Builder setMonthlyCostOther(com.google.type.Money.Builder builderForValue) {
        if (monthlyCostOtherBuilder_ == null) {
          monthlyCostOther_ = builderForValue.build();
        } else {
          monthlyCostOtherBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      public Builder mergeMonthlyCostOther(com.google.type.Money value) {
        if (monthlyCostOtherBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && monthlyCostOther_ != null
              && monthlyCostOther_ != com.google.type.Money.getDefaultInstance()) {
            getMonthlyCostOtherBuilder().mergeFrom(value);
          } else {
            monthlyCostOther_ = value;
          }
        } else {
          monthlyCostOtherBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      public Builder clearMonthlyCostOther() {
        bitField0_ = (bitField0_ & ~0x00000100);
        monthlyCostOther_ = null;
        if (monthlyCostOtherBuilder_ != null) {
          monthlyCostOtherBuilder_.dispose();
          monthlyCostOtherBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      public com.google.type.Money.Builder getMonthlyCostOtherBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getMonthlyCostOtherFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      public com.google.type.MoneyOrBuilder getMonthlyCostOtherOrBuilder() {
        if (monthlyCostOtherBuilder_ != null) {
          return monthlyCostOtherBuilder_.getMessageOrBuilder();
        } else {
          return monthlyCostOther_ == null
              ? com.google.type.Money.getDefaultInstance()
              : monthlyCostOther_;
        }
      }
      /**
       *
       *
       * <pre>
       * Miscellaneous monthly cost for this preference set.
       * </pre>
       *
       * <code>.google.type.Money monthly_cost_other = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getMonthlyCostOtherFieldBuilder() {
        if (monthlyCostOtherBuilder_ == null) {
          monthlyCostOtherBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getMonthlyCostOther(), getParentForChildren(), isClean());
          monthlyCostOther_ = null;
        }
        return monthlyCostOtherBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
          computeEngineFinding_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder>
          computeEngineFindingBuilder_;
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       *
       * @return Whether the computeEngineFinding field is set.
       */
      public boolean hasComputeEngineFinding() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       *
       * @return The computeEngineFinding.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
          getComputeEngineFinding() {
        if (computeEngineFindingBuilder_ == null) {
          return computeEngineFinding_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
                  .getDefaultInstance()
              : computeEngineFinding_;
        } else {
          return computeEngineFindingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      public Builder setComputeEngineFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding value) {
        if (computeEngineFindingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          computeEngineFinding_ = value;
        } else {
          computeEngineFindingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      public Builder setComputeEngineFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder
              builderForValue) {
        if (computeEngineFindingBuilder_ == null) {
          computeEngineFinding_ = builderForValue.build();
        } else {
          computeEngineFindingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      public Builder mergeComputeEngineFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding value) {
        if (computeEngineFindingBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && computeEngineFinding_ != null
              && computeEngineFinding_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
                      .getDefaultInstance()) {
            getComputeEngineFindingBuilder().mergeFrom(value);
          } else {
            computeEngineFinding_ = value;
          }
        } else {
          computeEngineFindingBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      public Builder clearComputeEngineFinding() {
        bitField0_ = (bitField0_ & ~0x00000200);
        computeEngineFinding_ = null;
        if (computeEngineFindingBuilder_ != null) {
          computeEngineFindingBuilder_.dispose();
          computeEngineFindingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder
          getComputeEngineFindingBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getComputeEngineFindingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder
          getComputeEngineFindingOrBuilder() {
        if (computeEngineFindingBuilder_ != null) {
          return computeEngineFindingBuilder_.getMessageOrBuilder();
        } else {
          return computeEngineFinding_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
                  .getDefaultInstance()
              : computeEngineFinding_;
        }
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Compute Engine machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding compute_engine_finding = 10;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder>
          getComputeEngineFindingFieldBuilder() {
        if (computeEngineFindingBuilder_ == null) {
          computeEngineFindingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFindingOrBuilder>(
                  getComputeEngineFinding(), getParentForChildren(), isClean());
          computeEngineFinding_ = null;
        }
        return computeEngineFindingBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
          vmwareEngineFinding_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder>
          vmwareEngineFindingBuilder_;
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       *
       * @return Whether the vmwareEngineFinding field is set.
       */
      public boolean hasVmwareEngineFinding() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       *
       * @return The vmwareEngineFinding.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
          getVmwareEngineFinding() {
        if (vmwareEngineFindingBuilder_ == null) {
          return vmwareEngineFinding_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
                  .getDefaultInstance()
              : vmwareEngineFinding_;
        } else {
          return vmwareEngineFindingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      public Builder setVmwareEngineFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding value) {
        if (vmwareEngineFindingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vmwareEngineFinding_ = value;
        } else {
          vmwareEngineFindingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      public Builder setVmwareEngineFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder
              builderForValue) {
        if (vmwareEngineFindingBuilder_ == null) {
          vmwareEngineFinding_ = builderForValue.build();
        } else {
          vmwareEngineFindingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      public Builder mergeVmwareEngineFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding value) {
        if (vmwareEngineFindingBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)
              && vmwareEngineFinding_ != null
              && vmwareEngineFinding_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
                      .getDefaultInstance()) {
            getVmwareEngineFindingBuilder().mergeFrom(value);
          } else {
            vmwareEngineFinding_ = value;
          }
        } else {
          vmwareEngineFindingBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      public Builder clearVmwareEngineFinding() {
        bitField0_ = (bitField0_ & ~0x00000400);
        vmwareEngineFinding_ = null;
        if (vmwareEngineFindingBuilder_ != null) {
          vmwareEngineFindingBuilder_.dispose();
          vmwareEngineFindingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder
          getVmwareEngineFindingBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getVmwareEngineFindingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder
          getVmwareEngineFindingOrBuilder() {
        if (vmwareEngineFindingBuilder_ != null) {
          return vmwareEngineFindingBuilder_.getMessageOrBuilder();
        } else {
          return vmwareEngineFinding_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
                  .getDefaultInstance()
              : vmwareEngineFinding_;
        }
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to VMWare machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding vmware_engine_finding = 11;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder>
          getVmwareEngineFindingFieldBuilder() {
        if (vmwareEngineFindingBuilder_ == null) {
          vmwareEngineFindingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding,
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFindingOrBuilder>(
                  getVmwareEngineFinding(), getParentForChildren(), isClean());
          vmwareEngineFinding_ = null;
        }
        return vmwareEngineFindingBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
          soleTenantFinding_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder>
          soleTenantFindingBuilder_;
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       *
       * @return Whether the soleTenantFinding field is set.
       */
      public boolean hasSoleTenantFinding() {
        return ((bitField0_ & 0x00000800) != 0);
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       *
       * @return The soleTenantFinding.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
          getSoleTenantFinding() {
        if (soleTenantFindingBuilder_ == null) {
          return soleTenantFinding_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
                  .getDefaultInstance()
              : soleTenantFinding_;
        } else {
          return soleTenantFindingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      public Builder setSoleTenantFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding value) {
        if (soleTenantFindingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          soleTenantFinding_ = value;
        } else {
          soleTenantFindingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      public Builder setSoleTenantFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder
              builderForValue) {
        if (soleTenantFindingBuilder_ == null) {
          soleTenantFinding_ = builderForValue.build();
        } else {
          soleTenantFindingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      public Builder mergeSoleTenantFinding(
          com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding value) {
        if (soleTenantFindingBuilder_ == null) {
          if (((bitField0_ & 0x00000800) != 0)
              && soleTenantFinding_ != null
              && soleTenantFinding_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
                      .getDefaultInstance()) {
            getSoleTenantFindingBuilder().mergeFrom(value);
          } else {
            soleTenantFinding_ = value;
          }
        } else {
          soleTenantFindingBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      public Builder clearSoleTenantFinding() {
        bitField0_ = (bitField0_ & ~0x00000800);
        soleTenantFinding_ = null;
        if (soleTenantFindingBuilder_ != null) {
          soleTenantFindingBuilder_.dispose();
          soleTenantFindingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder
          getSoleTenantFindingBuilder() {
        bitField0_ |= 0x00000800;
        onChanged();
        return getSoleTenantFindingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder
          getSoleTenantFindingOrBuilder() {
        if (soleTenantFindingBuilder_ != null) {
          return soleTenantFindingBuilder_.getMessageOrBuilder();
        } else {
          return soleTenantFinding_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
                  .getDefaultInstance()
              : soleTenantFinding_;
        }
      }
      /**
       *
       *
       * <pre>
       * A set of findings that applies to Sole-Tenant machines in the input.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding sole_tenant_finding = 12;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder>
          getSoleTenantFindingFieldBuilder() {
        if (soleTenantFindingBuilder_ == null) {
          soleTenantFindingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding,
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFindingOrBuilder>(
                  getSoleTenantFinding(), getParentForChildren(), isClean());
          soleTenantFinding_ = null;
        }
        return soleTenantFindingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroupPreferenceSetFinding> PARSER =
        new com.google.protobuf.AbstractParser<GroupPreferenceSetFinding>() {
          @java.lang.Override
          public GroupPreferenceSetFinding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroupPreferenceSetFinding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroupPreferenceSetFinding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroupFindingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.ReportSummary.GroupFinding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Display Name for the Group.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Display Name for the Group.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Description for the Group.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Description for the Group.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Summary statistics for all the assets in this group.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
     * </code>
     *
     * @return Whether the assetAggregateStats field is set.
     */
    boolean hasAssetAggregateStats();
    /**
     *
     *
     * <pre>
     * Summary statistics for all the assets in this group.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
     * </code>
     *
     * @return The assetAggregateStats.
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats getAssetAggregateStats();
    /**
     *
     *
     * <pre>
     * Summary statistics for all the assets in this group.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder
        getAssetAggregateStatsOrBuilder();

    /**
     *
     *
     * <pre>
     * This field is deprecated, do not rely on it having a value.
     * </pre>
     *
     * <code>int64 overlapping_asset_count = 4 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.overlapping_asset_count is
     *     deprecated. See google/cloud/migrationcenter/v1/migrationcenter.proto;l=4038
     * @return The overlappingAssetCount.
     */
    @java.lang.Deprecated
    long getOverlappingAssetCount();

    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>
        getPreferenceSetFindingsList();
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        getPreferenceSetFindings(int index);
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    int getPreferenceSetFindingsCount();
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary
                    .GroupPreferenceSetFindingOrBuilder>
        getPreferenceSetFindingsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFindingOrBuilder
        getPreferenceSetFindingsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Summary Findings for a specific Group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.GroupFinding}
   */
  public static final class GroupFinding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ReportSummary.GroupFinding)
      GroupFindingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroupFinding.newBuilder() to construct.
    private GroupFinding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroupFinding() {
      displayName_ = "";
      description_ = "";
      preferenceSetFindings_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroupFinding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupFinding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupFinding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder.class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display Name for the Group.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Display Name for the Group.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description for the Group.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description for the Group.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ASSET_AGGREGATE_STATS_FIELD_NUMBER = 3;
    private com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        assetAggregateStats_;
    /**
     *
     *
     * <pre>
     * Summary statistics for all the assets in this group.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
     * </code>
     *
     * @return Whether the assetAggregateStats field is set.
     */
    @java.lang.Override
    public boolean hasAssetAggregateStats() {
      return assetAggregateStats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Summary statistics for all the assets in this group.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
     * </code>
     *
     * @return The assetAggregateStats.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        getAssetAggregateStats() {
      return assetAggregateStats_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
              .getDefaultInstance()
          : assetAggregateStats_;
    }
    /**
     *
     *
     * <pre>
     * Summary statistics for all the assets in this group.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder
        getAssetAggregateStatsOrBuilder() {
      return assetAggregateStats_ == null
          ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
              .getDefaultInstance()
          : assetAggregateStats_;
    }

    public static final int OVERLAPPING_ASSET_COUNT_FIELD_NUMBER = 4;
    private long overlappingAssetCount_ = 0L;
    /**
     *
     *
     * <pre>
     * This field is deprecated, do not rely on it having a value.
     * </pre>
     *
     * <code>int64 overlapping_asset_count = 4 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.overlapping_asset_count is
     *     deprecated. See google/cloud/migrationcenter/v1/migrationcenter.proto;l=4038
     * @return The overlappingAssetCount.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public long getOverlappingAssetCount() {
      return overlappingAssetCount_;
    }

    public static final int PREFERENCE_SET_FINDINGS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>
        preferenceSetFindings_;
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>
        getPreferenceSetFindingsList() {
      return preferenceSetFindings_;
    }
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.ReportSummary
                    .GroupPreferenceSetFindingOrBuilder>
        getPreferenceSetFindingsOrBuilderList() {
      return preferenceSetFindings_;
    }
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    @java.lang.Override
    public int getPreferenceSetFindingsCount() {
      return preferenceSetFindings_.size();
    }
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
        getPreferenceSetFindings(int index) {
      return preferenceSetFindings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Findings for each of the PreferenceSets for this group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFindingOrBuilder
        getPreferenceSetFindingsOrBuilder(int index) {
      return preferenceSetFindings_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (assetAggregateStats_ != null) {
        output.writeMessage(3, getAssetAggregateStats());
      }
      if (overlappingAssetCount_ != 0L) {
        output.writeInt64(4, overlappingAssetCount_);
      }
      for (int i = 0; i < preferenceSetFindings_.size(); i++) {
        output.writeMessage(5, preferenceSetFindings_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (assetAggregateStats_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAssetAggregateStats());
      }
      if (overlappingAssetCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, overlappingAssetCount_);
      }
      for (int i = 0; i < preferenceSetFindings_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, preferenceSetFindings_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding other =
          (com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasAssetAggregateStats() != other.hasAssetAggregateStats()) return false;
      if (hasAssetAggregateStats()) {
        if (!getAssetAggregateStats().equals(other.getAssetAggregateStats())) return false;
      }
      if (getOverlappingAssetCount() != other.getOverlappingAssetCount()) return false;
      if (!getPreferenceSetFindingsList().equals(other.getPreferenceSetFindingsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasAssetAggregateStats()) {
        hash = (37 * hash) + ASSET_AGGREGATE_STATS_FIELD_NUMBER;
        hash = (53 * hash) + getAssetAggregateStats().hashCode();
      }
      hash = (37 * hash) + OVERLAPPING_ASSET_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOverlappingAssetCount());
      if (getPreferenceSetFindingsCount() > 0) {
        hash = (37 * hash) + PREFERENCE_SET_FINDINGS_FIELD_NUMBER;
        hash = (53 * hash) + getPreferenceSetFindingsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Summary Findings for a specific Group.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary.GroupFinding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary.GroupFinding)
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupFinding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupFinding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.class,
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        description_ = "";
        assetAggregateStats_ = null;
        if (assetAggregateStatsBuilder_ != null) {
          assetAggregateStatsBuilder_.dispose();
          assetAggregateStatsBuilder_ = null;
        }
        overlappingAssetCount_ = 0L;
        if (preferenceSetFindingsBuilder_ == null) {
          preferenceSetFindings_ = java.util.Collections.emptyList();
        } else {
          preferenceSetFindings_ = null;
          preferenceSetFindingsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_ReportSummary_GroupFinding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding build() {
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding buildPartial() {
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding result =
            new com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding result) {
        if (preferenceSetFindingsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            preferenceSetFindings_ = java.util.Collections.unmodifiableList(preferenceSetFindings_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.preferenceSetFindings_ = preferenceSetFindings_;
        } else {
          result.preferenceSetFindings_ = preferenceSetFindingsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.assetAggregateStats_ =
              assetAggregateStatsBuilder_ == null
                  ? assetAggregateStats_
                  : assetAggregateStatsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.overlappingAssetCount_ = overlappingAssetCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding other) {
        if (other
            == com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasAssetAggregateStats()) {
          mergeAssetAggregateStats(other.getAssetAggregateStats());
        }
        if (other.getOverlappingAssetCount() != 0L) {
          setOverlappingAssetCount(other.getOverlappingAssetCount());
        }
        if (preferenceSetFindingsBuilder_ == null) {
          if (!other.preferenceSetFindings_.isEmpty()) {
            if (preferenceSetFindings_.isEmpty()) {
              preferenceSetFindings_ = other.preferenceSetFindings_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensurePreferenceSetFindingsIsMutable();
              preferenceSetFindings_.addAll(other.preferenceSetFindings_);
            }
            onChanged();
          }
        } else {
          if (!other.preferenceSetFindings_.isEmpty()) {
            if (preferenceSetFindingsBuilder_.isEmpty()) {
              preferenceSetFindingsBuilder_.dispose();
              preferenceSetFindingsBuilder_ = null;
              preferenceSetFindings_ = other.preferenceSetFindings_;
              bitField0_ = (bitField0_ & ~0x00000010);
              preferenceSetFindingsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPreferenceSetFindingsFieldBuilder()
                      : null;
            } else {
              preferenceSetFindingsBuilder_.addAllMessages(other.preferenceSetFindings_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getAssetAggregateStatsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  overlappingAssetCount_ = input.readInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.ReportSummary
                              .GroupPreferenceSetFinding.parser(),
                          extensionRegistry);
                  if (preferenceSetFindingsBuilder_ == null) {
                    ensurePreferenceSetFindingsIsMutable();
                    preferenceSetFindings_.add(m);
                  } else {
                    preferenceSetFindingsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Display Name for the Group.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display Name for the Group.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display Name for the Group.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display Name for the Group.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display Name for the Group.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Description for the Group.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description for the Group.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description for the Group.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description for the Group.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description for the Group.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
          assetAggregateStats_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats,
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder>
          assetAggregateStatsBuilder_;
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       *
       * @return Whether the assetAggregateStats field is set.
       */
      public boolean hasAssetAggregateStats() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       *
       * @return The assetAggregateStats.
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
          getAssetAggregateStats() {
        if (assetAggregateStatsBuilder_ == null) {
          return assetAggregateStats_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                  .getDefaultInstance()
              : assetAggregateStats_;
        } else {
          return assetAggregateStatsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      public Builder setAssetAggregateStats(
          com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats value) {
        if (assetAggregateStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          assetAggregateStats_ = value;
        } else {
          assetAggregateStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      public Builder setAssetAggregateStats(
          com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder
              builderForValue) {
        if (assetAggregateStatsBuilder_ == null) {
          assetAggregateStats_ = builderForValue.build();
        } else {
          assetAggregateStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      public Builder mergeAssetAggregateStats(
          com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats value) {
        if (assetAggregateStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && assetAggregateStats_ != null
              && assetAggregateStats_
                  != com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                      .getDefaultInstance()) {
            getAssetAggregateStatsBuilder().mergeFrom(value);
          } else {
            assetAggregateStats_ = value;
          }
        } else {
          assetAggregateStatsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      public Builder clearAssetAggregateStats() {
        bitField0_ = (bitField0_ & ~0x00000004);
        assetAggregateStats_ = null;
        if (assetAggregateStatsBuilder_ != null) {
          assetAggregateStatsBuilder_.dispose();
          assetAggregateStatsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder
          getAssetAggregateStatsBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getAssetAggregateStatsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder
          getAssetAggregateStatsOrBuilder() {
        if (assetAggregateStatsBuilder_ != null) {
          return assetAggregateStatsBuilder_.getMessageOrBuilder();
        } else {
          return assetAggregateStats_ == null
              ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                  .getDefaultInstance()
              : assetAggregateStats_;
        }
      }
      /**
       *
       *
       * <pre>
       * Summary statistics for all the assets in this group.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats asset_aggregate_stats = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats,
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder>
          getAssetAggregateStatsFieldBuilder() {
        if (assetAggregateStatsBuilder_ == null) {
          assetAggregateStatsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats,
                  com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder>(
                  getAssetAggregateStats(), getParentForChildren(), isClean());
          assetAggregateStats_ = null;
        }
        return assetAggregateStatsBuilder_;
      }

      private long overlappingAssetCount_;
      /**
       *
       *
       * <pre>
       * This field is deprecated, do not rely on it having a value.
       * </pre>
       *
       * <code>int64 overlapping_asset_count = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.overlapping_asset_count is
       *     deprecated. See google/cloud/migrationcenter/v1/migrationcenter.proto;l=4038
       * @return The overlappingAssetCount.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public long getOverlappingAssetCount() {
        return overlappingAssetCount_;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated, do not rely on it having a value.
       * </pre>
       *
       * <code>int64 overlapping_asset_count = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.overlapping_asset_count is
       *     deprecated. See google/cloud/migrationcenter/v1/migrationcenter.proto;l=4038
       * @param value The overlappingAssetCount to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setOverlappingAssetCount(long value) {

        overlappingAssetCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated, do not rely on it having a value.
       * </pre>
       *
       * <code>int64 overlapping_asset_count = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.overlapping_asset_count is
       *     deprecated. See google/cloud/migrationcenter/v1/migrationcenter.proto;l=4038
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearOverlappingAssetCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        overlappingAssetCount_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>
          preferenceSetFindings_ = java.util.Collections.emptyList();

      private void ensurePreferenceSetFindingsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          preferenceSetFindings_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>(
                  preferenceSetFindings_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFindingOrBuilder>
          preferenceSetFindingsBuilder_;

      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>
          getPreferenceSetFindingsList() {
        if (preferenceSetFindingsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(preferenceSetFindings_);
        } else {
          return preferenceSetFindingsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public int getPreferenceSetFindingsCount() {
        if (preferenceSetFindingsBuilder_ == null) {
          return preferenceSetFindings_.size();
        } else {
          return preferenceSetFindingsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
          getPreferenceSetFindings(int index) {
        if (preferenceSetFindingsBuilder_ == null) {
          return preferenceSetFindings_.get(index);
        } else {
          return preferenceSetFindingsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder setPreferenceSetFindings(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding value) {
        if (preferenceSetFindingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.set(index, value);
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder setPreferenceSetFindings(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
              builderForValue) {
        if (preferenceSetFindingsBuilder_ == null) {
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.set(index, builderForValue.build());
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder addPreferenceSetFindings(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding value) {
        if (preferenceSetFindingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.add(value);
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder addPreferenceSetFindings(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding value) {
        if (preferenceSetFindingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.add(index, value);
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder addPreferenceSetFindings(
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
              builderForValue) {
        if (preferenceSetFindingsBuilder_ == null) {
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.add(builderForValue.build());
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder addPreferenceSetFindings(
          int index,
          com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
              builderForValue) {
        if (preferenceSetFindingsBuilder_ == null) {
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.add(index, builderForValue.build());
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder addAllPreferenceSetFindings(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding>
              values) {
        if (preferenceSetFindingsBuilder_ == null) {
          ensurePreferenceSetFindingsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, preferenceSetFindings_);
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder clearPreferenceSetFindings() {
        if (preferenceSetFindingsBuilder_ == null) {
          preferenceSetFindings_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public Builder removePreferenceSetFindings(int index) {
        if (preferenceSetFindingsBuilder_ == null) {
          ensurePreferenceSetFindingsIsMutable();
          preferenceSetFindings_.remove(index);
          onChanged();
        } else {
          preferenceSetFindingsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
          getPreferenceSetFindingsBuilder(int index) {
        return getPreferenceSetFindingsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFindingOrBuilder
          getPreferenceSetFindingsOrBuilder(int index) {
        if (preferenceSetFindingsBuilder_ == null) {
          return preferenceSetFindings_.get(index);
        } else {
          return preferenceSetFindingsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.ReportSummary
                      .GroupPreferenceSetFindingOrBuilder>
          getPreferenceSetFindingsOrBuilderList() {
        if (preferenceSetFindingsBuilder_ != null) {
          return preferenceSetFindingsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(preferenceSetFindings_);
        }
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
          addPreferenceSetFindingsBuilder() {
        return getPreferenceSetFindingsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder
          addPreferenceSetFindingsBuilder(int index) {
        return getPreferenceSetFindingsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Findings for each of the PreferenceSets for this group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding preference_set_findings = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder>
          getPreferenceSetFindingsBuilderList() {
        return getPreferenceSetFindingsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.Builder,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFindingOrBuilder>
          getPreferenceSetFindingsFieldBuilder() {
        if (preferenceSetFindingsBuilder_ == null) {
          preferenceSetFindingsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding,
                  com.google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
                      .Builder,
                  com.google.cloud.migrationcenter.v1.ReportSummary
                      .GroupPreferenceSetFindingOrBuilder>(
                  preferenceSetFindings_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          preferenceSetFindings_ = null;
        }
        return preferenceSetFindingsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary.GroupFinding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary.GroupFinding)
    private static final com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding();
    }

    public static com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroupFinding> PARSER =
        new com.google.protobuf.AbstractParser<GroupFinding>() {
          @java.lang.Override
          public GroupFinding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroupFinding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroupFinding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ALL_ASSETS_STATS_FIELD_NUMBER = 1;
  private com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats allAssetsStats_;
  /**
   *
   *
   * <pre>
   * Aggregate statistics for all the assets across all the groups.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
   * </code>
   *
   * @return Whether the allAssetsStats field is set.
   */
  @java.lang.Override
  public boolean hasAllAssetsStats() {
    return allAssetsStats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Aggregate statistics for all the assets across all the groups.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
   * </code>
   *
   * @return The allAssetsStats.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats getAllAssetsStats() {
    return allAssetsStats_ == null
        ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.getDefaultInstance()
        : allAssetsStats_;
  }
  /**
   *
   *
   * <pre>
   * Aggregate statistics for all the assets across all the groups.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder
      getAllAssetsStatsOrBuilder() {
    return allAssetsStats_ == null
        ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.getDefaultInstance()
        : allAssetsStats_;
  }

  public static final int GROUP_FINDINGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding>
      groupFindings_;
  /**
   *
   *
   * <pre>
   * Findings for each Group included in this report.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding>
      getGroupFindingsList() {
    return groupFindings_;
  }
  /**
   *
   *
   * <pre>
   * Findings for each Group included in this report.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder>
      getGroupFindingsOrBuilderList() {
    return groupFindings_;
  }
  /**
   *
   *
   * <pre>
   * Findings for each Group included in this report.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
   * </code>
   */
  @java.lang.Override
  public int getGroupFindingsCount() {
    return groupFindings_.size();
  }
  /**
   *
   *
   * <pre>
   * Findings for each Group included in this report.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding getGroupFindings(
      int index) {
    return groupFindings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Findings for each Group included in this report.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder
      getGroupFindingsOrBuilder(int index) {
    return groupFindings_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (allAssetsStats_ != null) {
      output.writeMessage(1, getAllAssetsStats());
    }
    for (int i = 0; i < groupFindings_.size(); i++) {
      output.writeMessage(2, groupFindings_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (allAssetsStats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAllAssetsStats());
    }
    for (int i = 0; i < groupFindings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, groupFindings_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ReportSummary)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ReportSummary other =
        (com.google.cloud.migrationcenter.v1.ReportSummary) obj;

    if (hasAllAssetsStats() != other.hasAllAssetsStats()) return false;
    if (hasAllAssetsStats()) {
      if (!getAllAssetsStats().equals(other.getAllAssetsStats())) return false;
    }
    if (!getGroupFindingsList().equals(other.getGroupFindingsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAllAssetsStats()) {
      hash = (37 * hash) + ALL_ASSETS_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getAllAssetsStats().hashCode();
    }
    if (getGroupFindingsCount() > 0) {
      hash = (37 * hash) + GROUP_FINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getGroupFindingsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ReportSummary prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the Summary view of a Report, which contains aggregated values
   * for all the groups and preference sets included in this Report.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ReportSummary}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ReportSummary)
      com.google.cloud.migrationcenter.v1.ReportSummaryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ReportSummary.class,
              com.google.cloud.migrationcenter.v1.ReportSummary.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ReportSummary.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allAssetsStats_ = null;
      if (allAssetsStatsBuilder_ != null) {
        allAssetsStatsBuilder_.dispose();
        allAssetsStatsBuilder_ = null;
      }
      if (groupFindingsBuilder_ == null) {
        groupFindings_ = java.util.Collections.emptyList();
      } else {
        groupFindings_ = null;
        groupFindingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ReportSummary_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ReportSummary.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary build() {
      com.google.cloud.migrationcenter.v1.ReportSummary result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ReportSummary buildPartial() {
      com.google.cloud.migrationcenter.v1.ReportSummary result =
          new com.google.cloud.migrationcenter.v1.ReportSummary(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.ReportSummary result) {
      if (groupFindingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          groupFindings_ = java.util.Collections.unmodifiableList(groupFindings_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.groupFindings_ = groupFindings_;
      } else {
        result.groupFindings_ = groupFindingsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ReportSummary result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allAssetsStats_ =
            allAssetsStatsBuilder_ == null ? allAssetsStats_ : allAssetsStatsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ReportSummary) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ReportSummary) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ReportSummary other) {
      if (other == com.google.cloud.migrationcenter.v1.ReportSummary.getDefaultInstance())
        return this;
      if (other.hasAllAssetsStats()) {
        mergeAllAssetsStats(other.getAllAssetsStats());
      }
      if (groupFindingsBuilder_ == null) {
        if (!other.groupFindings_.isEmpty()) {
          if (groupFindings_.isEmpty()) {
            groupFindings_ = other.groupFindings_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureGroupFindingsIsMutable();
            groupFindings_.addAll(other.groupFindings_);
          }
          onChanged();
        }
      } else {
        if (!other.groupFindings_.isEmpty()) {
          if (groupFindingsBuilder_.isEmpty()) {
            groupFindingsBuilder_.dispose();
            groupFindingsBuilder_ = null;
            groupFindings_ = other.groupFindings_;
            bitField0_ = (bitField0_ & ~0x00000002);
            groupFindingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroupFindingsFieldBuilder()
                    : null;
          } else {
            groupFindingsBuilder_.addAllMessages(other.groupFindings_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAllAssetsStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.parser(),
                        extensionRegistry);
                if (groupFindingsBuilder_ == null) {
                  ensureGroupFindingsIsMutable();
                  groupFindings_.add(m);
                } else {
                  groupFindingsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats allAssetsStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats,
            com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder,
            com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder>
        allAssetsStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     *
     * @return Whether the allAssetsStats field is set.
     */
    public boolean hasAllAssetsStats() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     *
     * @return The allAssetsStats.
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
        getAllAssetsStats() {
      if (allAssetsStatsBuilder_ == null) {
        return allAssetsStats_ == null
            ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                .getDefaultInstance()
            : allAssetsStats_;
      } else {
        return allAssetsStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    public Builder setAllAssetsStats(
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats value) {
      if (allAssetsStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        allAssetsStats_ = value;
      } else {
        allAssetsStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    public Builder setAllAssetsStats(
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder
            builderForValue) {
      if (allAssetsStatsBuilder_ == null) {
        allAssetsStats_ = builderForValue.build();
      } else {
        allAssetsStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    public Builder mergeAllAssetsStats(
        com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats value) {
      if (allAssetsStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && allAssetsStats_ != null
            && allAssetsStats_
                != com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                    .getDefaultInstance()) {
          getAllAssetsStatsBuilder().mergeFrom(value);
        } else {
          allAssetsStats_ = value;
        }
      } else {
        allAssetsStatsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    public Builder clearAllAssetsStats() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allAssetsStats_ = null;
      if (allAssetsStatsBuilder_ != null) {
        allAssetsStatsBuilder_.dispose();
        allAssetsStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder
        getAllAssetsStatsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAllAssetsStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder
        getAllAssetsStatsOrBuilder() {
      if (allAssetsStatsBuilder_ != null) {
        return allAssetsStatsBuilder_.getMessageOrBuilder();
      } else {
        return allAssetsStats_ == null
            ? com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
                .getDefaultInstance()
            : allAssetsStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregate statistics for all the assets across all the groups.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats all_assets_stats = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats,
            com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder,
            com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder>
        getAllAssetsStatsFieldBuilder() {
      if (allAssetsStatsBuilder_ == null) {
        allAssetsStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats,
                com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.Builder,
                com.google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStatsOrBuilder>(
                getAllAssetsStats(), getParentForChildren(), isClean());
        allAssetsStats_ = null;
      }
      return allAssetsStatsBuilder_;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding>
        groupFindings_ = java.util.Collections.emptyList();

    private void ensureGroupFindingsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        groupFindings_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding>(
                groupFindings_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding,
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder,
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder>
        groupFindingsBuilder_;

    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding>
        getGroupFindingsList() {
      if (groupFindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groupFindings_);
      } else {
        return groupFindingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public int getGroupFindingsCount() {
      if (groupFindingsBuilder_ == null) {
        return groupFindings_.size();
      } else {
        return groupFindingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding getGroupFindings(
        int index) {
      if (groupFindingsBuilder_ == null) {
        return groupFindings_.get(index);
      } else {
        return groupFindingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder setGroupFindings(
        int index, com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding value) {
      if (groupFindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupFindingsIsMutable();
        groupFindings_.set(index, value);
        onChanged();
      } else {
        groupFindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder setGroupFindings(
        int index,
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder builderForValue) {
      if (groupFindingsBuilder_ == null) {
        ensureGroupFindingsIsMutable();
        groupFindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        groupFindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder addGroupFindings(
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding value) {
      if (groupFindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupFindingsIsMutable();
        groupFindings_.add(value);
        onChanged();
      } else {
        groupFindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder addGroupFindings(
        int index, com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding value) {
      if (groupFindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupFindingsIsMutable();
        groupFindings_.add(index, value);
        onChanged();
      } else {
        groupFindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder addGroupFindings(
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder builderForValue) {
      if (groupFindingsBuilder_ == null) {
        ensureGroupFindingsIsMutable();
        groupFindings_.add(builderForValue.build());
        onChanged();
      } else {
        groupFindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder addGroupFindings(
        int index,
        com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder builderForValue) {
      if (groupFindingsBuilder_ == null) {
        ensureGroupFindingsIsMutable();
        groupFindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        groupFindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder addAllGroupFindings(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding>
            values) {
      if (groupFindingsBuilder_ == null) {
        ensureGroupFindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groupFindings_);
        onChanged();
      } else {
        groupFindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder clearGroupFindings() {
      if (groupFindingsBuilder_ == null) {
        groupFindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        groupFindingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public Builder removeGroupFindings(int index) {
      if (groupFindingsBuilder_ == null) {
        ensureGroupFindingsIsMutable();
        groupFindings_.remove(index);
        onChanged();
      } else {
        groupFindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder
        getGroupFindingsBuilder(int index) {
      return getGroupFindingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder
        getGroupFindingsOrBuilder(int index) {
      if (groupFindingsBuilder_ == null) {
        return groupFindings_.get(index);
      } else {
        return groupFindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder>
        getGroupFindingsOrBuilderList() {
      if (groupFindingsBuilder_ != null) {
        return groupFindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groupFindings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder
        addGroupFindingsBuilder() {
      return getGroupFindingsFieldBuilder()
          .addBuilder(
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder
        addGroupFindingsBuilder(int index) {
      return getGroupFindingsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Findings for each Group included in this report.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.ReportSummary.GroupFinding group_findings = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder>
        getGroupFindingsBuilderList() {
      return getGroupFindingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding,
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder,
            com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder>
        getGroupFindingsFieldBuilder() {
      if (groupFindingsBuilder_ == null) {
        groupFindingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding,
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.Builder,
                com.google.cloud.migrationcenter.v1.ReportSummary.GroupFindingOrBuilder>(
                groupFindings_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        groupFindings_ = null;
      }
      return groupFindingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ReportSummary)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ReportSummary)
  private static final com.google.cloud.migrationcenter.v1.ReportSummary DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ReportSummary();
  }

  public static com.google.cloud.migrationcenter.v1.ReportSummary getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportSummary> PARSER =
      new com.google.protobuf.AbstractParser<ReportSummary>() {
        @java.lang.Override
        public ReportSummary parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportSummary> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportSummary> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ReportSummary getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
