/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Guest OS running service details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.RunningService}
 */
public final class RunningService extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.RunningService)
    RunningServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunningService.newBuilder() to construct.
  private RunningService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunningService() {
    serviceName_ = "";
    state_ = 0;
    startMode_ = 0;
    exePath_ = "";
    cmdline_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunningService();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_RunningService_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_RunningService_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.RunningService.class,
            com.google.cloud.migrationcenter.v1.RunningService.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Service state (OS-agnostic).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.RunningService.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Service state unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Service is active.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Service is paused.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * Service is stopped.
     * </pre>
     *
     * <code>STOPPED = 3;</code>
     */
    STOPPED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Service state unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Service is active.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Service is paused.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Service is stopped.
     * </pre>
     *
     * <code>STOPPED = 3;</code>
     */
    public static final int STOPPED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return PAUSED;
        case 3:
          return STOPPED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.RunningService.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.RunningService.State)
  }

  /**
   *
   *
   * <pre>
   * Service start mode (OS-agnostic).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.RunningService.StartMode}
   */
  public enum StartMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Start mode unspecified.
     * </pre>
     *
     * <code>START_MODE_UNSPECIFIED = 0;</code>
     */
    START_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The service is a device driver started by the system loader.
     * </pre>
     *
     * <code>BOOT = 1;</code>
     */
    BOOT(1),
    /**
     *
     *
     * <pre>
     * The service is a device driver started by the IOInitSystem function.
     * </pre>
     *
     * <code>SYSTEM = 2;</code>
     */
    SYSTEM(2),
    /**
     *
     *
     * <pre>
     * The service is started by the operating system, at system start-up
     * </pre>
     *
     * <code>AUTO = 3;</code>
     */
    AUTO(3),
    /**
     *
     *
     * <pre>
     * The service is started only manually, by a user.
     * </pre>
     *
     * <code>MANUAL = 4;</code>
     */
    MANUAL(4),
    /**
     *
     *
     * <pre>
     * The service is disabled.
     * </pre>
     *
     * <code>DISABLED = 5;</code>
     */
    DISABLED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Start mode unspecified.
     * </pre>
     *
     * <code>START_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int START_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The service is a device driver started by the system loader.
     * </pre>
     *
     * <code>BOOT = 1;</code>
     */
    public static final int BOOT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The service is a device driver started by the IOInitSystem function.
     * </pre>
     *
     * <code>SYSTEM = 2;</code>
     */
    public static final int SYSTEM_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The service is started by the operating system, at system start-up
     * </pre>
     *
     * <code>AUTO = 3;</code>
     */
    public static final int AUTO_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The service is started only manually, by a user.
     * </pre>
     *
     * <code>MANUAL = 4;</code>
     */
    public static final int MANUAL_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The service is disabled.
     * </pre>
     *
     * <code>DISABLED = 5;</code>
     */
    public static final int DISABLED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StartMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StartMode forNumber(int value) {
      switch (value) {
        case 0:
          return START_MODE_UNSPECIFIED;
        case 1:
          return BOOT;
        case 2:
          return SYSTEM;
        case 3:
          return AUTO;
        case 4:
          return MANUAL;
        case 5:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StartMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StartMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<StartMode>() {
          public StartMode findValueByNumber(int number) {
            return StartMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.RunningService.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final StartMode[] VALUES = values();

    public static StartMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StartMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.RunningService.StartMode)
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * Service name.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Service name.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Service state (OS-agnostic).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Service state (OS-agnostic).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.RunningService.State getState() {
    com.google.cloud.migrationcenter.v1.RunningService.State result =
        com.google.cloud.migrationcenter.v1.RunningService.State.forNumber(state_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.RunningService.State.UNRECOGNIZED
        : result;
  }

  public static final int START_MODE_FIELD_NUMBER = 3;
  private int startMode_ = 0;
  /**
   *
   *
   * <pre>
   * Service start mode (OS-agnostic).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
   *
   * @return The enum numeric value on the wire for startMode.
   */
  @java.lang.Override
  public int getStartModeValue() {
    return startMode_;
  }
  /**
   *
   *
   * <pre>
   * Service start mode (OS-agnostic).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
   *
   * @return The startMode.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.RunningService.StartMode getStartMode() {
    com.google.cloud.migrationcenter.v1.RunningService.StartMode result =
        com.google.cloud.migrationcenter.v1.RunningService.StartMode.forNumber(startMode_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.RunningService.StartMode.UNRECOGNIZED
        : result;
  }

  public static final int EXE_PATH_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object exePath_ = "";
  /**
   *
   *
   * <pre>
   * Service binary path.
   * </pre>
   *
   * <code>string exe_path = 4;</code>
   *
   * @return The exePath.
   */
  @java.lang.Override
  public java.lang.String getExePath() {
    java.lang.Object ref = exePath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      exePath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Service binary path.
   * </pre>
   *
   * <code>string exe_path = 4;</code>
   *
   * @return The bytes for exePath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExePathBytes() {
    java.lang.Object ref = exePath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      exePath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CMDLINE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cmdline_ = "";
  /**
   *
   *
   * <pre>
   * Service command line.
   * </pre>
   *
   * <code>string cmdline = 5;</code>
   *
   * @return The cmdline.
   */
  @java.lang.Override
  public java.lang.String getCmdline() {
    java.lang.Object ref = cmdline_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cmdline_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Service command line.
   * </pre>
   *
   * <code>string cmdline = 5;</code>
   *
   * @return The bytes for cmdline.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCmdlineBytes() {
    java.lang.Object ref = cmdline_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cmdline_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PID_FIELD_NUMBER = 6;
  private long pid_ = 0L;
  /**
   *
   *
   * <pre>
   * Service pid.
   * </pre>
   *
   * <code>int64 pid = 6;</code>
   *
   * @return The pid.
   */
  @java.lang.Override
  public long getPid() {
    return pid_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceName_);
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.RunningService.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (startMode_
        != com.google.cloud.migrationcenter.v1.RunningService.StartMode.START_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, startMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exePath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, exePath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cmdline_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, cmdline_);
    }
    if (pid_ != 0L) {
      output.writeInt64(6, pid_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceName_);
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.RunningService.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (startMode_
        != com.google.cloud.migrationcenter.v1.RunningService.StartMode.START_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, startMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exePath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, exePath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cmdline_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, cmdline_);
    }
    if (pid_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, pid_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.RunningService)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.RunningService other =
        (com.google.cloud.migrationcenter.v1.RunningService) obj;

    if (!getServiceName().equals(other.getServiceName())) return false;
    if (state_ != other.state_) return false;
    if (startMode_ != other.startMode_) return false;
    if (!getExePath().equals(other.getExePath())) return false;
    if (!getCmdline().equals(other.getCmdline())) return false;
    if (getPid() != other.getPid()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + START_MODE_FIELD_NUMBER;
    hash = (53 * hash) + startMode_;
    hash = (37 * hash) + EXE_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getExePath().hashCode();
    hash = (37 * hash) + CMDLINE_FIELD_NUMBER;
    hash = (53 * hash) + getCmdline().hashCode();
    hash = (37 * hash) + PID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPid());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.RunningService parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.RunningService prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Guest OS running service details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.RunningService}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.RunningService)
      com.google.cloud.migrationcenter.v1.RunningServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_RunningService_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_RunningService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.RunningService.class,
              com.google.cloud.migrationcenter.v1.RunningService.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.RunningService.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceName_ = "";
      state_ = 0;
      startMode_ = 0;
      exePath_ = "";
      cmdline_ = "";
      pid_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_RunningService_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.RunningService getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.RunningService.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.RunningService build() {
      com.google.cloud.migrationcenter.v1.RunningService result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.RunningService buildPartial() {
      com.google.cloud.migrationcenter.v1.RunningService result =
          new com.google.cloud.migrationcenter.v1.RunningService(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.RunningService result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceName_ = serviceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.startMode_ = startMode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.exePath_ = exePath_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.cmdline_ = cmdline_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pid_ = pid_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.RunningService) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.RunningService) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.RunningService other) {
      if (other == com.google.cloud.migrationcenter.v1.RunningService.getDefaultInstance())
        return this;
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.startMode_ != 0) {
        setStartModeValue(other.getStartModeValue());
      }
      if (!other.getExePath().isEmpty()) {
        exePath_ = other.exePath_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getCmdline().isEmpty()) {
        cmdline_ = other.cmdline_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getPid() != 0L) {
        setPid(other.getPid());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                startMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                exePath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                cmdline_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                pid_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * Service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Service state (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Service state (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service state (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.RunningService.State getState() {
      com.google.cloud.migrationcenter.v1.RunningService.State result =
          com.google.cloud.migrationcenter.v1.RunningService.State.forNumber(state_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.RunningService.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Service state (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.migrationcenter.v1.RunningService.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service state (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private int startMode_ = 0;
    /**
     *
     *
     * <pre>
     * Service start mode (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
     *
     * @return The enum numeric value on the wire for startMode.
     */
    @java.lang.Override
    public int getStartModeValue() {
      return startMode_;
    }
    /**
     *
     *
     * <pre>
     * Service start mode (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
     *
     * @param value The enum numeric value on the wire for startMode to set.
     * @return This builder for chaining.
     */
    public Builder setStartModeValue(int value) {
      startMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service start mode (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
     *
     * @return The startMode.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.RunningService.StartMode getStartMode() {
      com.google.cloud.migrationcenter.v1.RunningService.StartMode result =
          com.google.cloud.migrationcenter.v1.RunningService.StartMode.forNumber(startMode_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.RunningService.StartMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Service start mode (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
     *
     * @param value The startMode to set.
     * @return This builder for chaining.
     */
    public Builder setStartMode(
        com.google.cloud.migrationcenter.v1.RunningService.StartMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      startMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service start mode (OS-agnostic).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RunningService.StartMode start_mode = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      startMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object exePath_ = "";
    /**
     *
     *
     * <pre>
     * Service binary path.
     * </pre>
     *
     * <code>string exe_path = 4;</code>
     *
     * @return The exePath.
     */
    public java.lang.String getExePath() {
      java.lang.Object ref = exePath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exePath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service binary path.
     * </pre>
     *
     * <code>string exe_path = 4;</code>
     *
     * @return The bytes for exePath.
     */
    public com.google.protobuf.ByteString getExePathBytes() {
      java.lang.Object ref = exePath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service binary path.
     * </pre>
     *
     * <code>string exe_path = 4;</code>
     *
     * @param value The exePath to set.
     * @return This builder for chaining.
     */
    public Builder setExePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      exePath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service binary path.
     * </pre>
     *
     * <code>string exe_path = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExePath() {
      exePath_ = getDefaultInstance().getExePath();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service binary path.
     * </pre>
     *
     * <code>string exe_path = 4;</code>
     *
     * @param value The bytes for exePath to set.
     * @return This builder for chaining.
     */
    public Builder setExePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      exePath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object cmdline_ = "";
    /**
     *
     *
     * <pre>
     * Service command line.
     * </pre>
     *
     * <code>string cmdline = 5;</code>
     *
     * @return The cmdline.
     */
    public java.lang.String getCmdline() {
      java.lang.Object ref = cmdline_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cmdline_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service command line.
     * </pre>
     *
     * <code>string cmdline = 5;</code>
     *
     * @return The bytes for cmdline.
     */
    public com.google.protobuf.ByteString getCmdlineBytes() {
      java.lang.Object ref = cmdline_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cmdline_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service command line.
     * </pre>
     *
     * <code>string cmdline = 5;</code>
     *
     * @param value The cmdline to set.
     * @return This builder for chaining.
     */
    public Builder setCmdline(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cmdline_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service command line.
     * </pre>
     *
     * <code>string cmdline = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCmdline() {
      cmdline_ = getDefaultInstance().getCmdline();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service command line.
     * </pre>
     *
     * <code>string cmdline = 5;</code>
     *
     * @param value The bytes for cmdline to set.
     * @return This builder for chaining.
     */
    public Builder setCmdlineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cmdline_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long pid_;
    /**
     *
     *
     * <pre>
     * Service pid.
     * </pre>
     *
     * <code>int64 pid = 6;</code>
     *
     * @return The pid.
     */
    @java.lang.Override
    public long getPid() {
      return pid_;
    }
    /**
     *
     *
     * <pre>
     * Service pid.
     * </pre>
     *
     * <code>int64 pid = 6;</code>
     *
     * @param value The pid to set.
     * @return This builder for chaining.
     */
    public Builder setPid(long value) {

      pid_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service pid.
     * </pre>
     *
     * <code>int64 pid = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPid() {
      bitField0_ = (bitField0_ & ~0x00000020);
      pid_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.RunningService)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.RunningService)
  private static final com.google.cloud.migrationcenter.v1.RunningService DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.RunningService();
  }

  public static com.google.cloud.migrationcenter.v1.RunningService getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunningService> PARSER =
      new com.google.protobuf.AbstractParser<RunningService>() {
        @java.lang.Override
        public RunningService parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunningService> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunningService> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.RunningService getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
