/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * The sizing optimization strategy preferences of a virtual machine. This
 * strategy, in addition to actual usage data of the virtual machine, can help
 * determine the recommended shape on the target platform.
 * </pre>
 *
 * Protobuf enum {@code google.cloud.migrationcenter.v1.SizingOptimizationStrategy}
 */
public enum SizingOptimizationStrategy implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Unspecified (default value).
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED = 0;</code>
   */
  SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * No optimization applied. Virtual machine sizing matches as closely as
   * possible the machine shape on the source site, not considering any actual
   * performance data.
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE = 1;</code>
   */
  SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE(1),
  /**
   *
   *
   * <pre>
   * Virtual machine sizing will match the reported usage and shape, with some
   * slack. This a good value to start with.
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_MODERATE = 2;</code>
   */
  SIZING_OPTIMIZATION_STRATEGY_MODERATE(2),
  /**
   *
   *
   * <pre>
   * Virtual machine sizing will match the reported usage, with little slack.
   * Using this option can help reduce costs.
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE = 3;</code>
   */
  SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE(3),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Unspecified (default value).
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED = 0;</code>
   */
  public static final int SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * No optimization applied. Virtual machine sizing matches as closely as
   * possible the machine shape on the source site, not considering any actual
   * performance data.
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE = 1;</code>
   */
  public static final int SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Virtual machine sizing will match the reported usage and shape, with some
   * slack. This a good value to start with.
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_MODERATE = 2;</code>
   */
  public static final int SIZING_OPTIMIZATION_STRATEGY_MODERATE_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Virtual machine sizing will match the reported usage, with little slack.
   * Using this option can help reduce costs.
   * </pre>
   *
   * <code>SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE = 3;</code>
   */
  public static final int SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE_VALUE = 3;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static SizingOptimizationStrategy valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static SizingOptimizationStrategy forNumber(int value) {
    switch (value) {
      case 0:
        return SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED;
      case 1:
        return SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE;
      case 2:
        return SIZING_OPTIMIZATION_STRATEGY_MODERATE;
      case 3:
        return SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<SizingOptimizationStrategy>
      internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<SizingOptimizationStrategy>
      internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SizingOptimizationStrategy>() {
            public SizingOptimizationStrategy findValueByNumber(int number) {
              return SizingOptimizationStrategy.forNumber(number);
            }
          };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto.getDescriptor()
        .getEnumTypes()
        .get(7);
  }

  private static final SizingOptimizationStrategy[] VALUES = values();

  public static SizingOptimizationStrategy valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private SizingOptimizationStrategy(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.SizingOptimizationStrategy)
}
