/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Preferences concerning Sole Tenancy nodes and VMs.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.SoleTenancyPreferences}
 */
public final class SoleTenancyPreferences extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.SoleTenancyPreferences)
    SoleTenancyPreferencesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SoleTenancyPreferences.newBuilder() to construct.
  private SoleTenancyPreferences(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SoleTenancyPreferences() {
    hostMaintenancePolicy_ = 0;
    commitmentPlan_ = 0;
    nodeTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SoleTenancyPreferences();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_SoleTenancyPreferences_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_SoleTenancyPreferences_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.class,
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Sole Tenancy nodes maintenance policy.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy}
   */
  public enum HostMaintenancePolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_UNSPECIFIED = 0;</code>
     */
    HOST_MAINTENANCE_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Default host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_DEFAULT = 1;</code>
     */
    HOST_MAINTENANCE_POLICY_DEFAULT(1),
    /**
     *
     *
     * <pre>
     * Restart in place host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE = 2;</code>
     */
    HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE(2),
    /**
     *
     *
     * <pre>
     * Migrate within node group host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP = 3;</code>
     */
    HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int HOST_MAINTENANCE_POLICY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_DEFAULT = 1;</code>
     */
    public static final int HOST_MAINTENANCE_POLICY_DEFAULT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Restart in place host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE = 2;</code>
     */
    public static final int HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Migrate within node group host maintenance policy.
     * </pre>
     *
     * <code>HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP = 3;</code>
     */
    public static final int HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HostMaintenancePolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HostMaintenancePolicy forNumber(int value) {
      switch (value) {
        case 0:
          return HOST_MAINTENANCE_POLICY_UNSPECIFIED;
        case 1:
          return HOST_MAINTENANCE_POLICY_DEFAULT;
        case 2:
          return HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE;
        case 3:
          return HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HostMaintenancePolicy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HostMaintenancePolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<HostMaintenancePolicy>() {
              public HostMaintenancePolicy findValueByNumber(int number) {
                return HostMaintenancePolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final HostMaintenancePolicy[] VALUES = values();

    public static HostMaintenancePolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HostMaintenancePolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy)
  }

  /**
   *
   *
   * <pre>
   * Type of committed use discount.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan}
   */
  public enum CommitmentPlan implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified commitment plan.
     * </pre>
     *
     * <code>COMMITMENT_PLAN_UNSPECIFIED = 0;</code>
     */
    COMMITMENT_PLAN_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * No commitment plan (on-demand usage).
     * </pre>
     *
     * <code>ON_DEMAND = 1;</code>
     */
    ON_DEMAND(1),
    /**
     *
     *
     * <pre>
     * 1 year commitment.
     * </pre>
     *
     * <code>COMMITMENT_1_YEAR = 2;</code>
     */
    COMMITMENT_1_YEAR(2),
    /**
     *
     *
     * <pre>
     * 3 years commitment.
     * </pre>
     *
     * <code>COMMITMENT_3_YEAR = 3;</code>
     */
    COMMITMENT_3_YEAR(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified commitment plan.
     * </pre>
     *
     * <code>COMMITMENT_PLAN_UNSPECIFIED = 0;</code>
     */
    public static final int COMMITMENT_PLAN_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * No commitment plan (on-demand usage).
     * </pre>
     *
     * <code>ON_DEMAND = 1;</code>
     */
    public static final int ON_DEMAND_VALUE = 1;
    /**
     *
     *
     * <pre>
     * 1 year commitment.
     * </pre>
     *
     * <code>COMMITMENT_1_YEAR = 2;</code>
     */
    public static final int COMMITMENT_1_YEAR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * 3 years commitment.
     * </pre>
     *
     * <code>COMMITMENT_3_YEAR = 3;</code>
     */
    public static final int COMMITMENT_3_YEAR_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CommitmentPlan valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CommitmentPlan forNumber(int value) {
      switch (value) {
        case 0:
          return COMMITMENT_PLAN_UNSPECIFIED;
        case 1:
          return ON_DEMAND;
        case 2:
          return COMMITMENT_1_YEAR;
        case 3:
          return COMMITMENT_3_YEAR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan>() {
          public CommitmentPlan findValueByNumber(int number) {
            return CommitmentPlan.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final CommitmentPlan[] VALUES = values();

    public static CommitmentPlan valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CommitmentPlan(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan)
  }

  public static final int CPU_OVERCOMMIT_RATIO_FIELD_NUMBER = 1;
  private double cpuOvercommitRatio_ = 0D;
  /**
   *
   *
   * <pre>
   * CPU overcommit ratio.
   * Acceptable values are between 1.0 and 2.0 inclusive.
   * </pre>
   *
   * <code>double cpu_overcommit_ratio = 1;</code>
   *
   * @return The cpuOvercommitRatio.
   */
  @java.lang.Override
  public double getCpuOvercommitRatio() {
    return cpuOvercommitRatio_;
  }

  public static final int HOST_MAINTENANCE_POLICY_FIELD_NUMBER = 2;
  private int hostMaintenancePolicy_ = 0;
  /**
   *
   *
   * <pre>
   * Sole Tenancy nodes maintenance policy.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for hostMaintenancePolicy.
   */
  @java.lang.Override
  public int getHostMaintenancePolicyValue() {
    return hostMaintenancePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Sole Tenancy nodes maintenance policy.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
   * </code>
   *
   * @return The hostMaintenancePolicy.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
      getHostMaintenancePolicy() {
    com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy result =
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy.forNumber(
            hostMaintenancePolicy_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
            .UNRECOGNIZED
        : result;
  }

  public static final int COMMITMENT_PLAN_FIELD_NUMBER = 3;
  private int commitmentPlan_ = 0;
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for commitmentPlan.
   */
  @java.lang.Override
  public int getCommitmentPlanValue() {
    return commitmentPlan_;
  }
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
   * </code>
   *
   * @return The commitmentPlan.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan
      getCommitmentPlan() {
    com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan result =
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan.forNumber(
            commitmentPlan_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan.UNRECOGNIZED
        : result;
  }

  public static final int NODE_TYPES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.SoleTenantNodeType> nodeTypes_;
  /**
   *
   *
   * <pre>
   * A list of sole tenant node types.
   * An empty list means that all possible node types will be considered.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.SoleTenantNodeType> getNodeTypesList() {
    return nodeTypes_;
  }
  /**
   *
   *
   * <pre>
   * A list of sole tenant node types.
   * An empty list means that all possible node types will be considered.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>
      getNodeTypesOrBuilderList() {
    return nodeTypes_;
  }
  /**
   *
   *
   * <pre>
   * A list of sole tenant node types.
   * An empty list means that all possible node types will be considered.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
   */
  @java.lang.Override
  public int getNodeTypesCount() {
    return nodeTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of sole tenant node types.
   * An empty list means that all possible node types will be considered.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenantNodeType getNodeTypes(int index) {
    return nodeTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of sole tenant node types.
   * An empty list means that all possible node types will be considered.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder getNodeTypesOrBuilder(
      int index) {
    return nodeTypes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Double.doubleToRawLongBits(cpuOvercommitRatio_) != 0) {
      output.writeDouble(1, cpuOvercommitRatio_);
    }
    if (hostMaintenancePolicy_
        != com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
            .HOST_MAINTENANCE_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, hostMaintenancePolicy_);
    }
    if (commitmentPlan_
        != com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, commitmentPlan_);
    }
    for (int i = 0; i < nodeTypes_.size(); i++) {
      output.writeMessage(4, nodeTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(cpuOvercommitRatio_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, cpuOvercommitRatio_);
    }
    if (hostMaintenancePolicy_
        != com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
            .HOST_MAINTENANCE_POLICY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, hostMaintenancePolicy_);
    }
    if (commitmentPlan_
        != com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, commitmentPlan_);
    }
    for (int i = 0; i < nodeTypes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, nodeTypes_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.SoleTenancyPreferences)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.SoleTenancyPreferences other =
        (com.google.cloud.migrationcenter.v1.SoleTenancyPreferences) obj;

    if (java.lang.Double.doubleToLongBits(getCpuOvercommitRatio())
        != java.lang.Double.doubleToLongBits(other.getCpuOvercommitRatio())) return false;
    if (hostMaintenancePolicy_ != other.hostMaintenancePolicy_) return false;
    if (commitmentPlan_ != other.commitmentPlan_) return false;
    if (!getNodeTypesList().equals(other.getNodeTypesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CPU_OVERCOMMIT_RATIO_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCpuOvercommitRatio()));
    hash = (37 * hash) + HOST_MAINTENANCE_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + hostMaintenancePolicy_;
    hash = (37 * hash) + COMMITMENT_PLAN_FIELD_NUMBER;
    hash = (53 * hash) + commitmentPlan_;
    if (getNodeTypesCount() > 0) {
      hash = (37 * hash) + NODE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getNodeTypesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.SoleTenancyPreferences prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Preferences concerning Sole Tenancy nodes and VMs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.SoleTenancyPreferences}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.SoleTenancyPreferences)
      com.google.cloud.migrationcenter.v1.SoleTenancyPreferencesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_SoleTenancyPreferences_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_SoleTenancyPreferences_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.class,
              com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cpuOvercommitRatio_ = 0D;
      hostMaintenancePolicy_ = 0;
      commitmentPlan_ = 0;
      if (nodeTypesBuilder_ == null) {
        nodeTypes_ = java.util.Collections.emptyList();
      } else {
        nodeTypes_ = null;
        nodeTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_SoleTenancyPreferences_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences build() {
      com.google.cloud.migrationcenter.v1.SoleTenancyPreferences result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences buildPartial() {
      com.google.cloud.migrationcenter.v1.SoleTenancyPreferences result =
          new com.google.cloud.migrationcenter.v1.SoleTenancyPreferences(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences result) {
      if (nodeTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          nodeTypes_ = java.util.Collections.unmodifiableList(nodeTypes_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.nodeTypes_ = nodeTypes_;
      } else {
        result.nodeTypes_ = nodeTypesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.SoleTenancyPreferences result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cpuOvercommitRatio_ = cpuOvercommitRatio_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.hostMaintenancePolicy_ = hostMaintenancePolicy_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.commitmentPlan_ = commitmentPlan_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.SoleTenancyPreferences) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.SoleTenancyPreferences) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.SoleTenancyPreferences other) {
      if (other == com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDefaultInstance())
        return this;
      if (other.getCpuOvercommitRatio() != 0D) {
        setCpuOvercommitRatio(other.getCpuOvercommitRatio());
      }
      if (other.hostMaintenancePolicy_ != 0) {
        setHostMaintenancePolicyValue(other.getHostMaintenancePolicyValue());
      }
      if (other.commitmentPlan_ != 0) {
        setCommitmentPlanValue(other.getCommitmentPlanValue());
      }
      if (nodeTypesBuilder_ == null) {
        if (!other.nodeTypes_.isEmpty()) {
          if (nodeTypes_.isEmpty()) {
            nodeTypes_ = other.nodeTypes_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureNodeTypesIsMutable();
            nodeTypes_.addAll(other.nodeTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.nodeTypes_.isEmpty()) {
          if (nodeTypesBuilder_.isEmpty()) {
            nodeTypesBuilder_.dispose();
            nodeTypesBuilder_ = null;
            nodeTypes_ = other.nodeTypes_;
            bitField0_ = (bitField0_ & ~0x00000008);
            nodeTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodeTypesFieldBuilder()
                    : null;
          } else {
            nodeTypesBuilder_.addAllMessages(other.nodeTypes_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                cpuOvercommitRatio_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 16:
              {
                hostMaintenancePolicy_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                commitmentPlan_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.migrationcenter.v1.SoleTenantNodeType m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.SoleTenantNodeType.parser(),
                        extensionRegistry);
                if (nodeTypesBuilder_ == null) {
                  ensureNodeTypesIsMutable();
                  nodeTypes_.add(m);
                } else {
                  nodeTypesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double cpuOvercommitRatio_;
    /**
     *
     *
     * <pre>
     * CPU overcommit ratio.
     * Acceptable values are between 1.0 and 2.0 inclusive.
     * </pre>
     *
     * <code>double cpu_overcommit_ratio = 1;</code>
     *
     * @return The cpuOvercommitRatio.
     */
    @java.lang.Override
    public double getCpuOvercommitRatio() {
      return cpuOvercommitRatio_;
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit ratio.
     * Acceptable values are between 1.0 and 2.0 inclusive.
     * </pre>
     *
     * <code>double cpu_overcommit_ratio = 1;</code>
     *
     * @param value The cpuOvercommitRatio to set.
     * @return This builder for chaining.
     */
    public Builder setCpuOvercommitRatio(double value) {

      cpuOvercommitRatio_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit ratio.
     * Acceptable values are between 1.0 and 2.0 inclusive.
     * </pre>
     *
     * <code>double cpu_overcommit_ratio = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuOvercommitRatio() {
      bitField0_ = (bitField0_ & ~0x00000001);
      cpuOvercommitRatio_ = 0D;
      onChanged();
      return this;
    }

    private int hostMaintenancePolicy_ = 0;
    /**
     *
     *
     * <pre>
     * Sole Tenancy nodes maintenance policy.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for hostMaintenancePolicy.
     */
    @java.lang.Override
    public int getHostMaintenancePolicyValue() {
      return hostMaintenancePolicy_;
    }
    /**
     *
     *
     * <pre>
     * Sole Tenancy nodes maintenance policy.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for hostMaintenancePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setHostMaintenancePolicyValue(int value) {
      hostMaintenancePolicy_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sole Tenancy nodes maintenance policy.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
     * </code>
     *
     * @return The hostMaintenancePolicy.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
        getHostMaintenancePolicy() {
      com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy result =
          com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
              .forNumber(hostMaintenancePolicy_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Sole Tenancy nodes maintenance policy.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
     * </code>
     *
     * @param value The hostMaintenancePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setHostMaintenancePolicy(
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      hostMaintenancePolicy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sole Tenancy nodes maintenance policy.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy host_maintenance_policy = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostMaintenancePolicy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      hostMaintenancePolicy_ = 0;
      onChanged();
      return this;
    }

    private int commitmentPlan_ = 0;
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for commitmentPlan.
     */
    @java.lang.Override
    public int getCommitmentPlanValue() {
      return commitmentPlan_;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for commitmentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentPlanValue(int value) {
      commitmentPlan_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
     * </code>
     *
     * @return The commitmentPlan.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan
        getCommitmentPlan() {
      com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan result =
          com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan.forNumber(
              commitmentPlan_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
     * </code>
     *
     * @param value The commitmentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentPlan(
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      commitmentPlan_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan commitment_plan = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitmentPlan() {
      bitField0_ = (bitField0_ & ~0x00000004);
      commitmentPlan_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.SoleTenantNodeType> nodeTypes_ =
        java.util.Collections.emptyList();

    private void ensureNodeTypesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        nodeTypes_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.SoleTenantNodeType>(
                nodeTypes_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.SoleTenantNodeType,
            com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder,
            com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>
        nodeTypesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.SoleTenantNodeType>
        getNodeTypesList() {
      if (nodeTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodeTypes_);
      } else {
        return nodeTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public int getNodeTypesCount() {
      if (nodeTypesBuilder_ == null) {
        return nodeTypes_.size();
      } else {
        return nodeTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeType getNodeTypes(int index) {
      if (nodeTypesBuilder_ == null) {
        return nodeTypes_.get(index);
      } else {
        return nodeTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder setNodeTypes(
        int index, com.google.cloud.migrationcenter.v1.SoleTenantNodeType value) {
      if (nodeTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeTypesIsMutable();
        nodeTypes_.set(index, value);
        onChanged();
      } else {
        nodeTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder setNodeTypes(
        int index, com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder builderForValue) {
      if (nodeTypesBuilder_ == null) {
        ensureNodeTypesIsMutable();
        nodeTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodeTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder addNodeTypes(com.google.cloud.migrationcenter.v1.SoleTenantNodeType value) {
      if (nodeTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeTypesIsMutable();
        nodeTypes_.add(value);
        onChanged();
      } else {
        nodeTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder addNodeTypes(
        int index, com.google.cloud.migrationcenter.v1.SoleTenantNodeType value) {
      if (nodeTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeTypesIsMutable();
        nodeTypes_.add(index, value);
        onChanged();
      } else {
        nodeTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder addNodeTypes(
        com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder builderForValue) {
      if (nodeTypesBuilder_ == null) {
        ensureNodeTypesIsMutable();
        nodeTypes_.add(builderForValue.build());
        onChanged();
      } else {
        nodeTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder addNodeTypes(
        int index, com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder builderForValue) {
      if (nodeTypesBuilder_ == null) {
        ensureNodeTypesIsMutable();
        nodeTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodeTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder addAllNodeTypes(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.SoleTenantNodeType>
            values) {
      if (nodeTypesBuilder_ == null) {
        ensureNodeTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodeTypes_);
        onChanged();
      } else {
        nodeTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder clearNodeTypes() {
      if (nodeTypesBuilder_ == null) {
        nodeTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        nodeTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public Builder removeNodeTypes(int index) {
      if (nodeTypesBuilder_ == null) {
        ensureNodeTypesIsMutable();
        nodeTypes_.remove(index);
        onChanged();
      } else {
        nodeTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder getNodeTypesBuilder(
        int index) {
      return getNodeTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder getNodeTypesOrBuilder(
        int index) {
      if (nodeTypesBuilder_ == null) {
        return nodeTypes_.get(index);
      } else {
        return nodeTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>
        getNodeTypesOrBuilderList() {
      if (nodeTypesBuilder_ != null) {
        return nodeTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodeTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder addNodeTypesBuilder() {
      return getNodeTypesFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder addNodeTypesBuilder(
        int index) {
      return getNodeTypesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.migrationcenter.v1.SoleTenantNodeType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of sole tenant node types.
     * An empty list means that all possible node types will be considered.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.SoleTenantNodeType node_types = 4;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder>
        getNodeTypesBuilderList() {
      return getNodeTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.SoleTenantNodeType,
            com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder,
            com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>
        getNodeTypesFieldBuilder() {
      if (nodeTypesBuilder_ == null) {
        nodeTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.SoleTenantNodeType,
                com.google.cloud.migrationcenter.v1.SoleTenantNodeType.Builder,
                com.google.cloud.migrationcenter.v1.SoleTenantNodeTypeOrBuilder>(
                nodeTypes_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        nodeTypes_ = null;
      }
      return nodeTypesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.SoleTenancyPreferences)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.SoleTenancyPreferences)
  private static final com.google.cloud.migrationcenter.v1.SoleTenancyPreferences DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.SoleTenancyPreferences();
  }

  public static com.google.cloud.migrationcenter.v1.SoleTenancyPreferences getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SoleTenancyPreferences> PARSER =
      new com.google.protobuf.AbstractParser<SoleTenancyPreferences>() {
        @java.lang.Override
        public SoleTenancyPreferences parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SoleTenancyPreferences> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SoleTenancyPreferences> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
