/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A resource that aggregates errors across import job files.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ValidationReport}
 */
public final class ValidationReport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ValidationReport)
    ValidationReportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValidationReport.newBuilder() to construct.
  private ValidationReport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValidationReport() {
    fileValidations_ = java.util.Collections.emptyList();
    jobErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValidationReport();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ValidationReport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ValidationReport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ValidationReport.class,
            com.google.cloud.migrationcenter.v1.ValidationReport.Builder.class);
  }

  public static final int FILE_VALIDATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.FileValidationReport> fileValidations_;
  /**
   *
   *
   * <pre>
   * List of errors found in files.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.FileValidationReport>
      getFileValidationsList() {
    return fileValidations_;
  }
  /**
   *
   *
   * <pre>
   * List of errors found in files.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder>
      getFileValidationsOrBuilderList() {
    return fileValidations_;
  }
  /**
   *
   *
   * <pre>
   * List of errors found in files.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
   * </code>
   */
  @java.lang.Override
  public int getFileValidationsCount() {
    return fileValidations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of errors found in files.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FileValidationReport getFileValidations(int index) {
    return fileValidations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of errors found in files.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder
      getFileValidationsOrBuilder(int index) {
    return fileValidations_.get(index);
  }

  public static final int JOB_ERRORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.ImportError> jobErrors_;
  /**
   *
   *
   * <pre>
   * List of job level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.ImportError> getJobErrorsList() {
    return jobErrors_;
  }
  /**
   *
   *
   * <pre>
   * List of job level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
      getJobErrorsOrBuilderList() {
    return jobErrors_;
  }
  /**
   *
   *
   * <pre>
   * List of job level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
   */
  @java.lang.Override
  public int getJobErrorsCount() {
    return jobErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * List of job level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportError getJobErrors(int index) {
    return jobErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of job level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder getJobErrorsOrBuilder(int index) {
    return jobErrors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < fileValidations_.size(); i++) {
      output.writeMessage(1, fileValidations_.get(i));
    }
    for (int i = 0; i < jobErrors_.size(); i++) {
      output.writeMessage(2, jobErrors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < fileValidations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fileValidations_.get(i));
    }
    for (int i = 0; i < jobErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, jobErrors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ValidationReport)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ValidationReport other =
        (com.google.cloud.migrationcenter.v1.ValidationReport) obj;

    if (!getFileValidationsList().equals(other.getFileValidationsList())) return false;
    if (!getJobErrorsList().equals(other.getJobErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFileValidationsCount() > 0) {
      hash = (37 * hash) + FILE_VALIDATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFileValidationsList().hashCode();
    }
    if (getJobErrorsCount() > 0) {
      hash = (37 * hash) + JOB_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getJobErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ValidationReport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource that aggregates errors across import job files.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ValidationReport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ValidationReport)
      com.google.cloud.migrationcenter.v1.ValidationReportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ValidationReport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ValidationReport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ValidationReport.class,
              com.google.cloud.migrationcenter.v1.ValidationReport.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ValidationReport.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (fileValidationsBuilder_ == null) {
        fileValidations_ = java.util.Collections.emptyList();
      } else {
        fileValidations_ = null;
        fileValidationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (jobErrorsBuilder_ == null) {
        jobErrors_ = java.util.Collections.emptyList();
      } else {
        jobErrors_ = null;
        jobErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ValidationReport_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ValidationReport getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ValidationReport build() {
      com.google.cloud.migrationcenter.v1.ValidationReport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ValidationReport buildPartial() {
      com.google.cloud.migrationcenter.v1.ValidationReport result =
          new com.google.cloud.migrationcenter.v1.ValidationReport(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.ValidationReport result) {
      if (fileValidationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          fileValidations_ = java.util.Collections.unmodifiableList(fileValidations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.fileValidations_ = fileValidations_;
      } else {
        result.fileValidations_ = fileValidationsBuilder_.build();
      }
      if (jobErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          jobErrors_ = java.util.Collections.unmodifiableList(jobErrors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.jobErrors_ = jobErrors_;
      } else {
        result.jobErrors_ = jobErrorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ValidationReport result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ValidationReport) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ValidationReport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ValidationReport other) {
      if (other == com.google.cloud.migrationcenter.v1.ValidationReport.getDefaultInstance())
        return this;
      if (fileValidationsBuilder_ == null) {
        if (!other.fileValidations_.isEmpty()) {
          if (fileValidations_.isEmpty()) {
            fileValidations_ = other.fileValidations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFileValidationsIsMutable();
            fileValidations_.addAll(other.fileValidations_);
          }
          onChanged();
        }
      } else {
        if (!other.fileValidations_.isEmpty()) {
          if (fileValidationsBuilder_.isEmpty()) {
            fileValidationsBuilder_.dispose();
            fileValidationsBuilder_ = null;
            fileValidations_ = other.fileValidations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fileValidationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFileValidationsFieldBuilder()
                    : null;
          } else {
            fileValidationsBuilder_.addAllMessages(other.fileValidations_);
          }
        }
      }
      if (jobErrorsBuilder_ == null) {
        if (!other.jobErrors_.isEmpty()) {
          if (jobErrors_.isEmpty()) {
            jobErrors_ = other.jobErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureJobErrorsIsMutable();
            jobErrors_.addAll(other.jobErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.jobErrors_.isEmpty()) {
          if (jobErrorsBuilder_.isEmpty()) {
            jobErrorsBuilder_.dispose();
            jobErrorsBuilder_ = null;
            jobErrors_ = other.jobErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            jobErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getJobErrorsFieldBuilder()
                    : null;
          } else {
            jobErrorsBuilder_.addAllMessages(other.jobErrors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.migrationcenter.v1.FileValidationReport m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.FileValidationReport.parser(),
                        extensionRegistry);
                if (fileValidationsBuilder_ == null) {
                  ensureFileValidationsIsMutable();
                  fileValidations_.add(m);
                } else {
                  fileValidationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.migrationcenter.v1.ImportError m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ImportError.parser(),
                        extensionRegistry);
                if (jobErrorsBuilder_ == null) {
                  ensureJobErrorsIsMutable();
                  jobErrors_.add(m);
                } else {
                  jobErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.migrationcenter.v1.FileValidationReport>
        fileValidations_ = java.util.Collections.emptyList();

    private void ensureFileValidationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fileValidations_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.FileValidationReport>(
                fileValidations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.FileValidationReport,
            com.google.cloud.migrationcenter.v1.FileValidationReport.Builder,
            com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder>
        fileValidationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.FileValidationReport>
        getFileValidationsList() {
      if (fileValidationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fileValidations_);
      } else {
        return fileValidationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public int getFileValidationsCount() {
      if (fileValidationsBuilder_ == null) {
        return fileValidations_.size();
      } else {
        return fileValidationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FileValidationReport getFileValidations(int index) {
      if (fileValidationsBuilder_ == null) {
        return fileValidations_.get(index);
      } else {
        return fileValidationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder setFileValidations(
        int index, com.google.cloud.migrationcenter.v1.FileValidationReport value) {
      if (fileValidationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileValidationsIsMutable();
        fileValidations_.set(index, value);
        onChanged();
      } else {
        fileValidationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder setFileValidations(
        int index,
        com.google.cloud.migrationcenter.v1.FileValidationReport.Builder builderForValue) {
      if (fileValidationsBuilder_ == null) {
        ensureFileValidationsIsMutable();
        fileValidations_.set(index, builderForValue.build());
        onChanged();
      } else {
        fileValidationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder addFileValidations(
        com.google.cloud.migrationcenter.v1.FileValidationReport value) {
      if (fileValidationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileValidationsIsMutable();
        fileValidations_.add(value);
        onChanged();
      } else {
        fileValidationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder addFileValidations(
        int index, com.google.cloud.migrationcenter.v1.FileValidationReport value) {
      if (fileValidationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileValidationsIsMutable();
        fileValidations_.add(index, value);
        onChanged();
      } else {
        fileValidationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder addFileValidations(
        com.google.cloud.migrationcenter.v1.FileValidationReport.Builder builderForValue) {
      if (fileValidationsBuilder_ == null) {
        ensureFileValidationsIsMutable();
        fileValidations_.add(builderForValue.build());
        onChanged();
      } else {
        fileValidationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder addFileValidations(
        int index,
        com.google.cloud.migrationcenter.v1.FileValidationReport.Builder builderForValue) {
      if (fileValidationsBuilder_ == null) {
        ensureFileValidationsIsMutable();
        fileValidations_.add(index, builderForValue.build());
        onChanged();
      } else {
        fileValidationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder addAllFileValidations(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.FileValidationReport>
            values) {
      if (fileValidationsBuilder_ == null) {
        ensureFileValidationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileValidations_);
        onChanged();
      } else {
        fileValidationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder clearFileValidations() {
      if (fileValidationsBuilder_ == null) {
        fileValidations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fileValidationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public Builder removeFileValidations(int index) {
      if (fileValidationsBuilder_ == null) {
        ensureFileValidationsIsMutable();
        fileValidations_.remove(index);
        onChanged();
      } else {
        fileValidationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FileValidationReport.Builder
        getFileValidationsBuilder(int index) {
      return getFileValidationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder
        getFileValidationsOrBuilder(int index) {
      if (fileValidationsBuilder_ == null) {
        return fileValidations_.get(index);
      } else {
        return fileValidationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder>
        getFileValidationsOrBuilderList() {
      if (fileValidationsBuilder_ != null) {
        return fileValidationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fileValidations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FileValidationReport.Builder
        addFileValidationsBuilder() {
      return getFileValidationsFieldBuilder()
          .addBuilder(
              com.google.cloud.migrationcenter.v1.FileValidationReport.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FileValidationReport.Builder
        addFileValidationsBuilder(int index) {
      return getFileValidationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.migrationcenter.v1.FileValidationReport.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of errors found in files.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.FileValidationReport file_validations = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.FileValidationReport.Builder>
        getFileValidationsBuilderList() {
      return getFileValidationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.FileValidationReport,
            com.google.cloud.migrationcenter.v1.FileValidationReport.Builder,
            com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder>
        getFileValidationsFieldBuilder() {
      if (fileValidationsBuilder_ == null) {
        fileValidationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.FileValidationReport,
                com.google.cloud.migrationcenter.v1.FileValidationReport.Builder,
                com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder>(
                fileValidations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        fileValidations_ = null;
      }
      return fileValidationsBuilder_;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.ImportError> jobErrors_ =
        java.util.Collections.emptyList();

    private void ensureJobErrorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        jobErrors_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.ImportError>(jobErrors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportError,
            com.google.cloud.migrationcenter.v1.ImportError.Builder,
            com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        jobErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportError> getJobErrorsList() {
      if (jobErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(jobErrors_);
      } else {
        return jobErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public int getJobErrorsCount() {
      if (jobErrorsBuilder_ == null) {
        return jobErrors_.size();
      } else {
        return jobErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError getJobErrors(int index) {
      if (jobErrorsBuilder_ == null) {
        return jobErrors_.get(index);
      } else {
        return jobErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder setJobErrors(int index, com.google.cloud.migrationcenter.v1.ImportError value) {
      if (jobErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobErrorsIsMutable();
        jobErrors_.set(index, value);
        onChanged();
      } else {
        jobErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder setJobErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (jobErrorsBuilder_ == null) {
        ensureJobErrorsIsMutable();
        jobErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        jobErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder addJobErrors(com.google.cloud.migrationcenter.v1.ImportError value) {
      if (jobErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobErrorsIsMutable();
        jobErrors_.add(value);
        onChanged();
      } else {
        jobErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder addJobErrors(int index, com.google.cloud.migrationcenter.v1.ImportError value) {
      if (jobErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobErrorsIsMutable();
        jobErrors_.add(index, value);
        onChanged();
      } else {
        jobErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder addJobErrors(
        com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (jobErrorsBuilder_ == null) {
        ensureJobErrorsIsMutable();
        jobErrors_.add(builderForValue.build());
        onChanged();
      } else {
        jobErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder addJobErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (jobErrorsBuilder_ == null) {
        ensureJobErrorsIsMutable();
        jobErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        jobErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder addAllJobErrors(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.ImportError> values) {
      if (jobErrorsBuilder_ == null) {
        ensureJobErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jobErrors_);
        onChanged();
      } else {
        jobErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder clearJobErrors() {
      if (jobErrorsBuilder_ == null) {
        jobErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        jobErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public Builder removeJobErrors(int index) {
      if (jobErrorsBuilder_ == null) {
        ensureJobErrorsIsMutable();
        jobErrors_.remove(index);
        onChanged();
      } else {
        jobErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder getJobErrorsBuilder(int index) {
      return getJobErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder getJobErrorsOrBuilder(
        int index) {
      if (jobErrorsBuilder_ == null) {
        return jobErrors_.get(index);
      } else {
        return jobErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        getJobErrorsOrBuilderList() {
      if (jobErrorsBuilder_ != null) {
        return jobErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(jobErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder addJobErrorsBuilder() {
      return getJobErrorsFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.ImportError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder addJobErrorsBuilder(int index) {
      return getJobErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.migrationcenter.v1.ImportError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of job level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError job_errors = 2;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportError.Builder>
        getJobErrorsBuilderList() {
      return getJobErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportError,
            com.google.cloud.migrationcenter.v1.ImportError.Builder,
            com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        getJobErrorsFieldBuilder() {
      if (jobErrorsBuilder_ == null) {
        jobErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ImportError,
                com.google.cloud.migrationcenter.v1.ImportError.Builder,
                com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>(
                jobErrors_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        jobErrors_ = null;
      }
      return jobErrorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ValidationReport)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ValidationReport)
  private static final com.google.cloud.migrationcenter.v1.ValidationReport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ValidationReport();
  }

  public static com.google.cloud.migrationcenter.v1.ValidationReport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValidationReport> PARSER =
      new com.google.protobuf.AbstractParser<ValidationReport>() {
        @java.lang.Override
        public ValidationReport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ValidationReport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValidationReport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ValidationReport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
