/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * VirtualMachinePreferences enables you to create sets of assumptions, for
 * example, a geographical location and pricing track, for your migrated virtual
 * machines. The set of preferences influence recommendations for migrating
 * virtual machine assets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.VirtualMachinePreferences}
 */
public final class VirtualMachinePreferences extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.VirtualMachinePreferences)
    VirtualMachinePreferencesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VirtualMachinePreferences.newBuilder() to construct.
  private VirtualMachinePreferences(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VirtualMachinePreferences() {
    targetProduct_ = 0;
    commitmentPlan_ = 0;
    sizingOptimizationStrategy_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VirtualMachinePreferences();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_VirtualMachinePreferences_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_VirtualMachinePreferences_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.class,
            com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder.class);
  }

  public static final int TARGET_PRODUCT_FIELD_NUMBER = 2;
  private int targetProduct_ = 0;
  /**
   *
   *
   * <pre>
   * Target product for assets using this preference set.
   * Specify either target product or business goal, but
   * not both.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;</code>
   *
   * @return The enum numeric value on the wire for targetProduct.
   */
  @java.lang.Override
  public int getTargetProductValue() {
    return targetProduct_;
  }
  /**
   *
   *
   * <pre>
   * Target product for assets using this preference set.
   * Specify either target product or business goal, but
   * not both.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;</code>
   *
   * @return The targetProduct.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct getTargetProduct() {
    com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct result =
        com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct.forNumber(targetProduct_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct.UNRECOGNIZED
        : result;
  }

  public static final int REGION_PREFERENCES_FIELD_NUMBER = 3;
  private com.google.cloud.migrationcenter.v1.RegionPreferences regionPreferences_;
  /**
   *
   *
   * <pre>
   * Region preferences for assets using this preference set.
   * If you are unsure which value to set, the migration service API region is
   * often a good value to start with.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
   *
   * @return Whether the regionPreferences field is set.
   */
  @java.lang.Override
  public boolean hasRegionPreferences() {
    return regionPreferences_ != null;
  }
  /**
   *
   *
   * <pre>
   * Region preferences for assets using this preference set.
   * If you are unsure which value to set, the migration service API region is
   * often a good value to start with.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
   *
   * @return The regionPreferences.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.RegionPreferences getRegionPreferences() {
    return regionPreferences_ == null
        ? com.google.cloud.migrationcenter.v1.RegionPreferences.getDefaultInstance()
        : regionPreferences_;
  }
  /**
   *
   *
   * <pre>
   * Region preferences for assets using this preference set.
   * If you are unsure which value to set, the migration service API region is
   * often a good value to start with.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.RegionPreferencesOrBuilder
      getRegionPreferencesOrBuilder() {
    return regionPreferences_ == null
        ? com.google.cloud.migrationcenter.v1.RegionPreferences.getDefaultInstance()
        : regionPreferences_;
  }

  public static final int COMMITMENT_PLAN_FIELD_NUMBER = 4;
  private int commitmentPlan_ = 0;
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
   *
   * @return The enum numeric value on the wire for commitmentPlan.
   */
  @java.lang.Override
  public int getCommitmentPlanValue() {
    return commitmentPlan_;
  }
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
   *
   * @return The commitmentPlan.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.CommitmentPlan getCommitmentPlan() {
    com.google.cloud.migrationcenter.v1.CommitmentPlan result =
        com.google.cloud.migrationcenter.v1.CommitmentPlan.forNumber(commitmentPlan_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.CommitmentPlan.UNRECOGNIZED
        : result;
  }

  public static final int SIZING_OPTIMIZATION_STRATEGY_FIELD_NUMBER = 5;
  private int sizingOptimizationStrategy_ = 0;
  /**
   *
   *
   * <pre>
   * Sizing optimization strategy specifies the preferred strategy used when
   * extrapolating usage data to calculate insights and recommendations for a
   * virtual machine.
   * If you are unsure which value to set, a moderate sizing optimization
   * strategy is often a good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for sizingOptimizationStrategy.
   */
  @java.lang.Override
  public int getSizingOptimizationStrategyValue() {
    return sizingOptimizationStrategy_;
  }
  /**
   *
   *
   * <pre>
   * Sizing optimization strategy specifies the preferred strategy used when
   * extrapolating usage data to calculate insights and recommendations for a
   * virtual machine.
   * If you are unsure which value to set, a moderate sizing optimization
   * strategy is often a good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
   * </code>
   *
   * @return The sizingOptimizationStrategy.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy
      getSizingOptimizationStrategy() {
    com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy result =
        com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy.forNumber(
            sizingOptimizationStrategy_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy.UNRECOGNIZED
        : result;
  }

  public static final int COMPUTE_ENGINE_PREFERENCES_FIELD_NUMBER = 6;
  private com.google.cloud.migrationcenter.v1.ComputeEnginePreferences computeEnginePreferences_;
  /**
   *
   *
   * <pre>
   * Compute Engine preferences concern insights and recommendations for Compute
   * Engine target.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
   * </code>
   *
   * @return Whether the computeEnginePreferences field is set.
   */
  @java.lang.Override
  public boolean hasComputeEnginePreferences() {
    return computeEnginePreferences_ != null;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine preferences concern insights and recommendations for Compute
   * Engine target.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
   * </code>
   *
   * @return The computeEnginePreferences.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ComputeEnginePreferences
      getComputeEnginePreferences() {
    return computeEnginePreferences_ == null
        ? com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.getDefaultInstance()
        : computeEnginePreferences_;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine preferences concern insights and recommendations for Compute
   * Engine target.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ComputeEnginePreferencesOrBuilder
      getComputeEnginePreferencesOrBuilder() {
    return computeEnginePreferences_ == null
        ? com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.getDefaultInstance()
        : computeEnginePreferences_;
  }

  public static final int VMWARE_ENGINE_PREFERENCES_FIELD_NUMBER = 7;
  private com.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmwareEnginePreferences_;
  /**
   *
   *
   * <pre>
   * Preferences concerning insights and recommendations for
   * Google Cloud VMware Engine.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
   * </code>
   *
   * @return Whether the vmwareEnginePreferences field is set.
   */
  @java.lang.Override
  public boolean hasVmwareEnginePreferences() {
    return vmwareEnginePreferences_ != null;
  }
  /**
   *
   *
   * <pre>
   * Preferences concerning insights and recommendations for
   * Google Cloud VMware Engine.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
   * </code>
   *
   * @return The vmwareEnginePreferences.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences getVmwareEnginePreferences() {
    return vmwareEnginePreferences_ == null
        ? com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDefaultInstance()
        : vmwareEnginePreferences_;
  }
  /**
   *
   *
   * <pre>
   * Preferences concerning insights and recommendations for
   * Google Cloud VMware Engine.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareEnginePreferencesOrBuilder
      getVmwareEnginePreferencesOrBuilder() {
    return vmwareEnginePreferences_ == null
        ? com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDefaultInstance()
        : vmwareEnginePreferences_;
  }

  public static final int SOLE_TENANCY_PREFERENCES_FIELD_NUMBER = 8;
  private com.google.cloud.migrationcenter.v1.SoleTenancyPreferences soleTenancyPreferences_;
  /**
   *
   *
   * <pre>
   * Preferences concerning Sole Tenant nodes and virtual machines.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
   * </code>
   *
   * @return Whether the soleTenancyPreferences field is set.
   */
  @java.lang.Override
  public boolean hasSoleTenancyPreferences() {
    return soleTenancyPreferences_ != null;
  }
  /**
   *
   *
   * <pre>
   * Preferences concerning Sole Tenant nodes and virtual machines.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
   * </code>
   *
   * @return The soleTenancyPreferences.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences getSoleTenancyPreferences() {
    return soleTenancyPreferences_ == null
        ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDefaultInstance()
        : soleTenancyPreferences_;
  }
  /**
   *
   *
   * <pre>
   * Preferences concerning Sole Tenant nodes and virtual machines.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.SoleTenancyPreferencesOrBuilder
      getSoleTenancyPreferencesOrBuilder() {
    return soleTenancyPreferences_ == null
        ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDefaultInstance()
        : soleTenancyPreferences_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (targetProduct_
        != com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct
            .COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, targetProduct_);
    }
    if (regionPreferences_ != null) {
      output.writeMessage(3, getRegionPreferences());
    }
    if (commitmentPlan_
        != com.google.cloud.migrationcenter.v1.CommitmentPlan.COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, commitmentPlan_);
    }
    if (sizingOptimizationStrategy_
        != com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy
            .SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, sizingOptimizationStrategy_);
    }
    if (computeEnginePreferences_ != null) {
      output.writeMessage(6, getComputeEnginePreferences());
    }
    if (vmwareEnginePreferences_ != null) {
      output.writeMessage(7, getVmwareEnginePreferences());
    }
    if (soleTenancyPreferences_ != null) {
      output.writeMessage(8, getSoleTenancyPreferences());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (targetProduct_
        != com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct
            .COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, targetProduct_);
    }
    if (regionPreferences_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRegionPreferences());
    }
    if (commitmentPlan_
        != com.google.cloud.migrationcenter.v1.CommitmentPlan.COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, commitmentPlan_);
    }
    if (sizingOptimizationStrategy_
        != com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy
            .SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, sizingOptimizationStrategy_);
    }
    if (computeEnginePreferences_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getComputeEnginePreferences());
    }
    if (vmwareEnginePreferences_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getVmwareEnginePreferences());
    }
    if (soleTenancyPreferences_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSoleTenancyPreferences());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.VirtualMachinePreferences)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.VirtualMachinePreferences other =
        (com.google.cloud.migrationcenter.v1.VirtualMachinePreferences) obj;

    if (targetProduct_ != other.targetProduct_) return false;
    if (hasRegionPreferences() != other.hasRegionPreferences()) return false;
    if (hasRegionPreferences()) {
      if (!getRegionPreferences().equals(other.getRegionPreferences())) return false;
    }
    if (commitmentPlan_ != other.commitmentPlan_) return false;
    if (sizingOptimizationStrategy_ != other.sizingOptimizationStrategy_) return false;
    if (hasComputeEnginePreferences() != other.hasComputeEnginePreferences()) return false;
    if (hasComputeEnginePreferences()) {
      if (!getComputeEnginePreferences().equals(other.getComputeEnginePreferences())) return false;
    }
    if (hasVmwareEnginePreferences() != other.hasVmwareEnginePreferences()) return false;
    if (hasVmwareEnginePreferences()) {
      if (!getVmwareEnginePreferences().equals(other.getVmwareEnginePreferences())) return false;
    }
    if (hasSoleTenancyPreferences() != other.hasSoleTenancyPreferences()) return false;
    if (hasSoleTenancyPreferences()) {
      if (!getSoleTenancyPreferences().equals(other.getSoleTenancyPreferences())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_PRODUCT_FIELD_NUMBER;
    hash = (53 * hash) + targetProduct_;
    if (hasRegionPreferences()) {
      hash = (37 * hash) + REGION_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getRegionPreferences().hashCode();
    }
    hash = (37 * hash) + COMMITMENT_PLAN_FIELD_NUMBER;
    hash = (53 * hash) + commitmentPlan_;
    hash = (37 * hash) + SIZING_OPTIMIZATION_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + sizingOptimizationStrategy_;
    if (hasComputeEnginePreferences()) {
      hash = (37 * hash) + COMPUTE_ENGINE_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getComputeEnginePreferences().hashCode();
    }
    if (hasVmwareEnginePreferences()) {
      hash = (37 * hash) + VMWARE_ENGINE_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getVmwareEnginePreferences().hashCode();
    }
    if (hasSoleTenancyPreferences()) {
      hash = (37 * hash) + SOLE_TENANCY_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getSoleTenancyPreferences().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.VirtualMachinePreferences prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * VirtualMachinePreferences enables you to create sets of assumptions, for
   * example, a geographical location and pricing track, for your migrated virtual
   * machines. The set of preferences influence recommendations for migrating
   * virtual machine assets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.VirtualMachinePreferences}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.VirtualMachinePreferences)
      com.google.cloud.migrationcenter.v1.VirtualMachinePreferencesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VirtualMachinePreferences_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VirtualMachinePreferences_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.class,
              com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      targetProduct_ = 0;
      regionPreferences_ = null;
      if (regionPreferencesBuilder_ != null) {
        regionPreferencesBuilder_.dispose();
        regionPreferencesBuilder_ = null;
      }
      commitmentPlan_ = 0;
      sizingOptimizationStrategy_ = 0;
      computeEnginePreferences_ = null;
      if (computeEnginePreferencesBuilder_ != null) {
        computeEnginePreferencesBuilder_.dispose();
        computeEnginePreferencesBuilder_ = null;
      }
      vmwareEnginePreferences_ = null;
      if (vmwareEnginePreferencesBuilder_ != null) {
        vmwareEnginePreferencesBuilder_.dispose();
        vmwareEnginePreferencesBuilder_ = null;
      }
      soleTenancyPreferences_ = null;
      if (soleTenancyPreferencesBuilder_ != null) {
        soleTenancyPreferencesBuilder_.dispose();
        soleTenancyPreferencesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VirtualMachinePreferences_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences
        getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences build() {
      com.google.cloud.migrationcenter.v1.VirtualMachinePreferences result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences buildPartial() {
      com.google.cloud.migrationcenter.v1.VirtualMachinePreferences result =
          new com.google.cloud.migrationcenter.v1.VirtualMachinePreferences(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.migrationcenter.v1.VirtualMachinePreferences result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.targetProduct_ = targetProduct_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.regionPreferences_ =
            regionPreferencesBuilder_ == null
                ? regionPreferences_
                : regionPreferencesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.commitmentPlan_ = commitmentPlan_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sizingOptimizationStrategy_ = sizingOptimizationStrategy_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.computeEnginePreferences_ =
            computeEnginePreferencesBuilder_ == null
                ? computeEnginePreferences_
                : computeEnginePreferencesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.vmwareEnginePreferences_ =
            vmwareEnginePreferencesBuilder_ == null
                ? vmwareEnginePreferences_
                : vmwareEnginePreferencesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.soleTenancyPreferences_ =
            soleTenancyPreferencesBuilder_ == null
                ? soleTenancyPreferences_
                : soleTenancyPreferencesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.VirtualMachinePreferences) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.VirtualMachinePreferences) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.VirtualMachinePreferences other) {
      if (other
          == com.google.cloud.migrationcenter.v1.VirtualMachinePreferences.getDefaultInstance())
        return this;
      if (other.targetProduct_ != 0) {
        setTargetProductValue(other.getTargetProductValue());
      }
      if (other.hasRegionPreferences()) {
        mergeRegionPreferences(other.getRegionPreferences());
      }
      if (other.commitmentPlan_ != 0) {
        setCommitmentPlanValue(other.getCommitmentPlanValue());
      }
      if (other.sizingOptimizationStrategy_ != 0) {
        setSizingOptimizationStrategyValue(other.getSizingOptimizationStrategyValue());
      }
      if (other.hasComputeEnginePreferences()) {
        mergeComputeEnginePreferences(other.getComputeEnginePreferences());
      }
      if (other.hasVmwareEnginePreferences()) {
        mergeVmwareEnginePreferences(other.getVmwareEnginePreferences());
      }
      if (other.hasSoleTenancyPreferences()) {
        mergeSoleTenancyPreferences(other.getSoleTenancyPreferences());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 16:
              {
                targetProduct_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getRegionPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                commitmentPlan_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 40:
              {
                sizingOptimizationStrategy_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getComputeEnginePreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getVmwareEnginePreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSoleTenancyPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int targetProduct_ = 0;
    /**
     *
     *
     * <pre>
     * Target product for assets using this preference set.
     * Specify either target product or business goal, but
     * not both.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for targetProduct.
     */
    @java.lang.Override
    public int getTargetProductValue() {
      return targetProduct_;
    }
    /**
     *
     *
     * <pre>
     * Target product for assets using this preference set.
     * Specify either target product or business goal, but
     * not both.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for targetProduct to set.
     * @return This builder for chaining.
     */
    public Builder setTargetProductValue(int value) {
      targetProduct_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target product for assets using this preference set.
     * Specify either target product or business goal, but
     * not both.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;
     * </code>
     *
     * @return The targetProduct.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct getTargetProduct() {
      com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct result =
          com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct.forNumber(
              targetProduct_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Target product for assets using this preference set.
     * Specify either target product or business goal, but
     * not both.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;
     * </code>
     *
     * @param value The targetProduct to set.
     * @return This builder for chaining.
     */
    public Builder setTargetProduct(
        com.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      targetProduct_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target product for assets using this preference set.
     * Specify either target product or business goal, but
     * not both.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct target_product = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetProduct() {
      bitField0_ = (bitField0_ & ~0x00000001);
      targetProduct_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.RegionPreferences regionPreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.RegionPreferences,
            com.google.cloud.migrationcenter.v1.RegionPreferences.Builder,
            com.google.cloud.migrationcenter.v1.RegionPreferencesOrBuilder>
        regionPreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     *
     * @return Whether the regionPreferences field is set.
     */
    public boolean hasRegionPreferences() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     *
     * @return The regionPreferences.
     */
    public com.google.cloud.migrationcenter.v1.RegionPreferences getRegionPreferences() {
      if (regionPreferencesBuilder_ == null) {
        return regionPreferences_ == null
            ? com.google.cloud.migrationcenter.v1.RegionPreferences.getDefaultInstance()
            : regionPreferences_;
      } else {
        return regionPreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    public Builder setRegionPreferences(
        com.google.cloud.migrationcenter.v1.RegionPreferences value) {
      if (regionPreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        regionPreferences_ = value;
      } else {
        regionPreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    public Builder setRegionPreferences(
        com.google.cloud.migrationcenter.v1.RegionPreferences.Builder builderForValue) {
      if (regionPreferencesBuilder_ == null) {
        regionPreferences_ = builderForValue.build();
      } else {
        regionPreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    public Builder mergeRegionPreferences(
        com.google.cloud.migrationcenter.v1.RegionPreferences value) {
      if (regionPreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && regionPreferences_ != null
            && regionPreferences_
                != com.google.cloud.migrationcenter.v1.RegionPreferences.getDefaultInstance()) {
          getRegionPreferencesBuilder().mergeFrom(value);
        } else {
          regionPreferences_ = value;
        }
      } else {
        regionPreferencesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    public Builder clearRegionPreferences() {
      bitField0_ = (bitField0_ & ~0x00000002);
      regionPreferences_ = null;
      if (regionPreferencesBuilder_ != null) {
        regionPreferencesBuilder_.dispose();
        regionPreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    public com.google.cloud.migrationcenter.v1.RegionPreferences.Builder
        getRegionPreferencesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRegionPreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    public com.google.cloud.migrationcenter.v1.RegionPreferencesOrBuilder
        getRegionPreferencesOrBuilder() {
      if (regionPreferencesBuilder_ != null) {
        return regionPreferencesBuilder_.getMessageOrBuilder();
      } else {
        return regionPreferences_ == null
            ? com.google.cloud.migrationcenter.v1.RegionPreferences.getDefaultInstance()
            : regionPreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Region preferences for assets using this preference set.
     * If you are unsure which value to set, the migration service API region is
     * often a good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.RegionPreferences region_preferences = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.RegionPreferences,
            com.google.cloud.migrationcenter.v1.RegionPreferences.Builder,
            com.google.cloud.migrationcenter.v1.RegionPreferencesOrBuilder>
        getRegionPreferencesFieldBuilder() {
      if (regionPreferencesBuilder_ == null) {
        regionPreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.RegionPreferences,
                com.google.cloud.migrationcenter.v1.RegionPreferences.Builder,
                com.google.cloud.migrationcenter.v1.RegionPreferencesOrBuilder>(
                getRegionPreferences(), getParentForChildren(), isClean());
        regionPreferences_ = null;
      }
      return regionPreferencesBuilder_;
    }

    private int commitmentPlan_ = 0;
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
     *
     * @return The enum numeric value on the wire for commitmentPlan.
     */
    @java.lang.Override
    public int getCommitmentPlanValue() {
      return commitmentPlan_;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
     *
     * @param value The enum numeric value on the wire for commitmentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentPlanValue(int value) {
      commitmentPlan_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
     *
     * @return The commitmentPlan.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.CommitmentPlan getCommitmentPlan() {
      com.google.cloud.migrationcenter.v1.CommitmentPlan result =
          com.google.cloud.migrationcenter.v1.CommitmentPlan.forNumber(commitmentPlan_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.CommitmentPlan.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
     *
     * @param value The commitmentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentPlan(com.google.cloud.migrationcenter.v1.CommitmentPlan value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      commitmentPlan_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.CommitmentPlan commitment_plan = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitmentPlan() {
      bitField0_ = (bitField0_ & ~0x00000004);
      commitmentPlan_ = 0;
      onChanged();
      return this;
    }

    private int sizingOptimizationStrategy_ = 0;
    /**
     *
     *
     * <pre>
     * Sizing optimization strategy specifies the preferred strategy used when
     * extrapolating usage data to calculate insights and recommendations for a
     * virtual machine.
     * If you are unsure which value to set, a moderate sizing optimization
     * strategy is often a good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for sizingOptimizationStrategy.
     */
    @java.lang.Override
    public int getSizingOptimizationStrategyValue() {
      return sizingOptimizationStrategy_;
    }
    /**
     *
     *
     * <pre>
     * Sizing optimization strategy specifies the preferred strategy used when
     * extrapolating usage data to calculate insights and recommendations for a
     * virtual machine.
     * If you are unsure which value to set, a moderate sizing optimization
     * strategy is often a good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for sizingOptimizationStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setSizingOptimizationStrategyValue(int value) {
      sizingOptimizationStrategy_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sizing optimization strategy specifies the preferred strategy used when
     * extrapolating usage data to calculate insights and recommendations for a
     * virtual machine.
     * If you are unsure which value to set, a moderate sizing optimization
     * strategy is often a good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
     * </code>
     *
     * @return The sizingOptimizationStrategy.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy
        getSizingOptimizationStrategy() {
      com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy result =
          com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy.forNumber(
              sizingOptimizationStrategy_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Sizing optimization strategy specifies the preferred strategy used when
     * extrapolating usage data to calculate insights and recommendations for a
     * virtual machine.
     * If you are unsure which value to set, a moderate sizing optimization
     * strategy is often a good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
     * </code>
     *
     * @param value The sizingOptimizationStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setSizingOptimizationStrategy(
        com.google.cloud.migrationcenter.v1.SizingOptimizationStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      sizingOptimizationStrategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sizing optimization strategy specifies the preferred strategy used when
     * extrapolating usage data to calculate insights and recommendations for a
     * virtual machine.
     * If you are unsure which value to set, a moderate sizing optimization
     * strategy is often a good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.SizingOptimizationStrategy sizing_optimization_strategy = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSizingOptimizationStrategy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      sizingOptimizationStrategy_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.ComputeEnginePreferences computeEnginePreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ComputeEnginePreferences,
            com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.Builder,
            com.google.cloud.migrationcenter.v1.ComputeEnginePreferencesOrBuilder>
        computeEnginePreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     *
     * @return Whether the computeEnginePreferences field is set.
     */
    public boolean hasComputeEnginePreferences() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     *
     * @return The computeEnginePreferences.
     */
    public com.google.cloud.migrationcenter.v1.ComputeEnginePreferences
        getComputeEnginePreferences() {
      if (computeEnginePreferencesBuilder_ == null) {
        return computeEnginePreferences_ == null
            ? com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.getDefaultInstance()
            : computeEnginePreferences_;
      } else {
        return computeEnginePreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    public Builder setComputeEnginePreferences(
        com.google.cloud.migrationcenter.v1.ComputeEnginePreferences value) {
      if (computeEnginePreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        computeEnginePreferences_ = value;
      } else {
        computeEnginePreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    public Builder setComputeEnginePreferences(
        com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.Builder builderForValue) {
      if (computeEnginePreferencesBuilder_ == null) {
        computeEnginePreferences_ = builderForValue.build();
      } else {
        computeEnginePreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    public Builder mergeComputeEnginePreferences(
        com.google.cloud.migrationcenter.v1.ComputeEnginePreferences value) {
      if (computeEnginePreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && computeEnginePreferences_ != null
            && computeEnginePreferences_
                != com.google.cloud.migrationcenter.v1.ComputeEnginePreferences
                    .getDefaultInstance()) {
          getComputeEnginePreferencesBuilder().mergeFrom(value);
        } else {
          computeEnginePreferences_ = value;
        }
      } else {
        computeEnginePreferencesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    public Builder clearComputeEnginePreferences() {
      bitField0_ = (bitField0_ & ~0x00000010);
      computeEnginePreferences_ = null;
      if (computeEnginePreferencesBuilder_ != null) {
        computeEnginePreferencesBuilder_.dispose();
        computeEnginePreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.Builder
        getComputeEnginePreferencesBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getComputeEnginePreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeEnginePreferencesOrBuilder
        getComputeEnginePreferencesOrBuilder() {
      if (computeEnginePreferencesBuilder_ != null) {
        return computeEnginePreferencesBuilder_.getMessageOrBuilder();
      } else {
        return computeEnginePreferences_ == null
            ? com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.getDefaultInstance()
            : computeEnginePreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine preferences concern insights and recommendations for Compute
     * Engine target.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ComputeEnginePreferences compute_engine_preferences = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ComputeEnginePreferences,
            com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.Builder,
            com.google.cloud.migrationcenter.v1.ComputeEnginePreferencesOrBuilder>
        getComputeEnginePreferencesFieldBuilder() {
      if (computeEnginePreferencesBuilder_ == null) {
        computeEnginePreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ComputeEnginePreferences,
                com.google.cloud.migrationcenter.v1.ComputeEnginePreferences.Builder,
                com.google.cloud.migrationcenter.v1.ComputeEnginePreferencesOrBuilder>(
                getComputeEnginePreferences(), getParentForChildren(), isClean());
        computeEnginePreferences_ = null;
      }
      return computeEnginePreferencesBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmwareEnginePreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferences,
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder,
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferencesOrBuilder>
        vmwareEnginePreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     *
     * @return Whether the vmwareEnginePreferences field is set.
     */
    public boolean hasVmwareEnginePreferences() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     *
     * @return The vmwareEnginePreferences.
     */
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences
        getVmwareEnginePreferences() {
      if (vmwareEnginePreferencesBuilder_ == null) {
        return vmwareEnginePreferences_ == null
            ? com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDefaultInstance()
            : vmwareEnginePreferences_;
      } else {
        return vmwareEnginePreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    public Builder setVmwareEnginePreferences(
        com.google.cloud.migrationcenter.v1.VmwareEnginePreferences value) {
      if (vmwareEnginePreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vmwareEnginePreferences_ = value;
      } else {
        vmwareEnginePreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    public Builder setVmwareEnginePreferences(
        com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder builderForValue) {
      if (vmwareEnginePreferencesBuilder_ == null) {
        vmwareEnginePreferences_ = builderForValue.build();
      } else {
        vmwareEnginePreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    public Builder mergeVmwareEnginePreferences(
        com.google.cloud.migrationcenter.v1.VmwareEnginePreferences value) {
      if (vmwareEnginePreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && vmwareEnginePreferences_ != null
            && vmwareEnginePreferences_
                != com.google.cloud.migrationcenter.v1.VmwareEnginePreferences
                    .getDefaultInstance()) {
          getVmwareEnginePreferencesBuilder().mergeFrom(value);
        } else {
          vmwareEnginePreferences_ = value;
        }
      } else {
        vmwareEnginePreferencesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    public Builder clearVmwareEnginePreferences() {
      bitField0_ = (bitField0_ & ~0x00000020);
      vmwareEnginePreferences_ = null;
      if (vmwareEnginePreferencesBuilder_ != null) {
        vmwareEnginePreferencesBuilder_.dispose();
        vmwareEnginePreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder
        getVmwareEnginePreferencesBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getVmwareEnginePreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferencesOrBuilder
        getVmwareEnginePreferencesOrBuilder() {
      if (vmwareEnginePreferencesBuilder_ != null) {
        return vmwareEnginePreferencesBuilder_.getMessageOrBuilder();
      } else {
        return vmwareEnginePreferences_ == null
            ? com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDefaultInstance()
            : vmwareEnginePreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning insights and recommendations for
     * Google Cloud VMware Engine.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareEnginePreferences vmware_engine_preferences = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferences,
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder,
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferencesOrBuilder>
        getVmwareEnginePreferencesFieldBuilder() {
      if (vmwareEnginePreferencesBuilder_ == null) {
        vmwareEnginePreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.VmwareEnginePreferences,
                com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder,
                com.google.cloud.migrationcenter.v1.VmwareEnginePreferencesOrBuilder>(
                getVmwareEnginePreferences(), getParentForChildren(), isClean());
        vmwareEnginePreferences_ = null;
      }
      return vmwareEnginePreferencesBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.SoleTenancyPreferences soleTenancyPreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferences,
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder,
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferencesOrBuilder>
        soleTenancyPreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     *
     * @return Whether the soleTenancyPreferences field is set.
     */
    public boolean hasSoleTenancyPreferences() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     *
     * @return The soleTenancyPreferences.
     */
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences getSoleTenancyPreferences() {
      if (soleTenancyPreferencesBuilder_ == null) {
        return soleTenancyPreferences_ == null
            ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDefaultInstance()
            : soleTenancyPreferences_;
      } else {
        return soleTenancyPreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    public Builder setSoleTenancyPreferences(
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences value) {
      if (soleTenancyPreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        soleTenancyPreferences_ = value;
      } else {
        soleTenancyPreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    public Builder setSoleTenancyPreferences(
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder builderForValue) {
      if (soleTenancyPreferencesBuilder_ == null) {
        soleTenancyPreferences_ = builderForValue.build();
      } else {
        soleTenancyPreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    public Builder mergeSoleTenancyPreferences(
        com.google.cloud.migrationcenter.v1.SoleTenancyPreferences value) {
      if (soleTenancyPreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && soleTenancyPreferences_ != null
            && soleTenancyPreferences_
                != com.google.cloud.migrationcenter.v1.SoleTenancyPreferences
                    .getDefaultInstance()) {
          getSoleTenancyPreferencesBuilder().mergeFrom(value);
        } else {
          soleTenancyPreferences_ = value;
        }
      } else {
        soleTenancyPreferencesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    public Builder clearSoleTenancyPreferences() {
      bitField0_ = (bitField0_ & ~0x00000040);
      soleTenancyPreferences_ = null;
      if (soleTenancyPreferencesBuilder_ != null) {
        soleTenancyPreferencesBuilder_.dispose();
        soleTenancyPreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder
        getSoleTenancyPreferencesBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSoleTenancyPreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.SoleTenancyPreferencesOrBuilder
        getSoleTenancyPreferencesOrBuilder() {
      if (soleTenancyPreferencesBuilder_ != null) {
        return soleTenancyPreferencesBuilder_.getMessageOrBuilder();
      } else {
        return soleTenancyPreferences_ == null
            ? com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.getDefaultInstance()
            : soleTenancyPreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Preferences concerning Sole Tenant nodes and virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.SoleTenancyPreferences sole_tenancy_preferences = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferences,
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder,
            com.google.cloud.migrationcenter.v1.SoleTenancyPreferencesOrBuilder>
        getSoleTenancyPreferencesFieldBuilder() {
      if (soleTenancyPreferencesBuilder_ == null) {
        soleTenancyPreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.SoleTenancyPreferences,
                com.google.cloud.migrationcenter.v1.SoleTenancyPreferences.Builder,
                com.google.cloud.migrationcenter.v1.SoleTenancyPreferencesOrBuilder>(
                getSoleTenancyPreferences(), getParentForChildren(), isClean());
        soleTenancyPreferences_ = null;
      }
      return soleTenancyPreferencesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.VirtualMachinePreferences)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.VirtualMachinePreferences)
  private static final com.google.cloud.migrationcenter.v1.VirtualMachinePreferences
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.VirtualMachinePreferences();
  }

  public static com.google.cloud.migrationcenter.v1.VirtualMachinePreferences getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VirtualMachinePreferences> PARSER =
      new com.google.protobuf.AbstractParser<VirtualMachinePreferences>() {
        @java.lang.Override
        public VirtualMachinePreferences parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VirtualMachinePreferences> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VirtualMachinePreferences> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VirtualMachinePreferences getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
