/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * VMware disk config details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.VmwareDiskConfig}
 */
public final class VmwareDiskConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.VmwareDiskConfig)
    VmwareDiskConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VmwareDiskConfig.newBuilder() to construct.
  private VmwareDiskConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VmwareDiskConfig() {
    backingType_ = 0;
    vmdkMode_ = 0;
    rdmCompatibility_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VmwareDiskConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_VmwareDiskConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_VmwareDiskConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.VmwareDiskConfig.class,
            com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * VMDK backing type possible values.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType}
   */
  public enum BackingType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>BACKING_TYPE_UNSPECIFIED = 0;</code>
     */
    BACKING_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Flat v1.
     * </pre>
     *
     * <code>BACKING_TYPE_FLAT_V1 = 1;</code>
     */
    BACKING_TYPE_FLAT_V1(1),
    /**
     *
     *
     * <pre>
     * Flat v2.
     * </pre>
     *
     * <code>BACKING_TYPE_FLAT_V2 = 2;</code>
     */
    BACKING_TYPE_FLAT_V2(2),
    /**
     *
     *
     * <pre>
     * Persistent memory, also known as Non-Volatile Memory (NVM).
     * </pre>
     *
     * <code>BACKING_TYPE_PMEM = 3;</code>
     */
    BACKING_TYPE_PMEM(3),
    /**
     *
     *
     * <pre>
     * Raw Disk Memory v1.
     * </pre>
     *
     * <code>BACKING_TYPE_RDM_V1 = 4;</code>
     */
    BACKING_TYPE_RDM_V1(4),
    /**
     *
     *
     * <pre>
     * Raw Disk Memory v2.
     * </pre>
     *
     * <code>BACKING_TYPE_RDM_V2 = 5;</code>
     */
    BACKING_TYPE_RDM_V2(5),
    /**
     *
     *
     * <pre>
     * SEsparse is a snapshot format introduced in vSphere 5.5 for large disks.
     * </pre>
     *
     * <code>BACKING_TYPE_SESPARSE = 6;</code>
     */
    BACKING_TYPE_SESPARSE(6),
    /**
     *
     *
     * <pre>
     * SEsparse v1.
     * </pre>
     *
     * <code>BACKING_TYPE_SESPARSE_V1 = 7;</code>
     */
    BACKING_TYPE_SESPARSE_V1(7),
    /**
     *
     *
     * <pre>
     * SEsparse v1.
     * </pre>
     *
     * <code>BACKING_TYPE_SESPARSE_V2 = 8;</code>
     */
    BACKING_TYPE_SESPARSE_V2(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>BACKING_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int BACKING_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Flat v1.
     * </pre>
     *
     * <code>BACKING_TYPE_FLAT_V1 = 1;</code>
     */
    public static final int BACKING_TYPE_FLAT_V1_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Flat v2.
     * </pre>
     *
     * <code>BACKING_TYPE_FLAT_V2 = 2;</code>
     */
    public static final int BACKING_TYPE_FLAT_V2_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Persistent memory, also known as Non-Volatile Memory (NVM).
     * </pre>
     *
     * <code>BACKING_TYPE_PMEM = 3;</code>
     */
    public static final int BACKING_TYPE_PMEM_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Raw Disk Memory v1.
     * </pre>
     *
     * <code>BACKING_TYPE_RDM_V1 = 4;</code>
     */
    public static final int BACKING_TYPE_RDM_V1_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Raw Disk Memory v2.
     * </pre>
     *
     * <code>BACKING_TYPE_RDM_V2 = 5;</code>
     */
    public static final int BACKING_TYPE_RDM_V2_VALUE = 5;
    /**
     *
     *
     * <pre>
     * SEsparse is a snapshot format introduced in vSphere 5.5 for large disks.
     * </pre>
     *
     * <code>BACKING_TYPE_SESPARSE = 6;</code>
     */
    public static final int BACKING_TYPE_SESPARSE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * SEsparse v1.
     * </pre>
     *
     * <code>BACKING_TYPE_SESPARSE_V1 = 7;</code>
     */
    public static final int BACKING_TYPE_SESPARSE_V1_VALUE = 7;
    /**
     *
     *
     * <pre>
     * SEsparse v1.
     * </pre>
     *
     * <code>BACKING_TYPE_SESPARSE_V2 = 8;</code>
     */
    public static final int BACKING_TYPE_SESPARSE_V2_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BackingType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BackingType forNumber(int value) {
      switch (value) {
        case 0:
          return BACKING_TYPE_UNSPECIFIED;
        case 1:
          return BACKING_TYPE_FLAT_V1;
        case 2:
          return BACKING_TYPE_FLAT_V2;
        case 3:
          return BACKING_TYPE_PMEM;
        case 4:
          return BACKING_TYPE_RDM_V1;
        case 5:
          return BACKING_TYPE_RDM_V2;
        case 6:
          return BACKING_TYPE_SESPARSE;
        case 7:
          return BACKING_TYPE_SESPARSE_V1;
        case 8:
          return BACKING_TYPE_SESPARSE_V2;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BackingType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BackingType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BackingType>() {
          public BackingType findValueByNumber(int number) {
            return BackingType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final BackingType[] VALUES = values();

    public static BackingType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BackingType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType)
  }

  /**
   *
   *
   * <pre>
   * VMDK disk mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode}
   */
  public enum VmdkMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * VMDK disk mode unspecified or unknown.
     * </pre>
     *
     * <code>VMDK_MODE_UNSPECIFIED = 0;</code>
     */
    VMDK_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Dependent disk mode.
     * </pre>
     *
     * <code>DEPENDENT = 1;</code>
     */
    DEPENDENT(1),
    /**
     *
     *
     * <pre>
     * Independent - Persistent disk mode.
     * </pre>
     *
     * <code>INDEPENDENT_PERSISTENT = 2;</code>
     */
    INDEPENDENT_PERSISTENT(2),
    /**
     *
     *
     * <pre>
     * Independent - Nonpersistent disk mode.
     * </pre>
     *
     * <code>INDEPENDENT_NONPERSISTENT = 3;</code>
     */
    INDEPENDENT_NONPERSISTENT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * VMDK disk mode unspecified or unknown.
     * </pre>
     *
     * <code>VMDK_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int VMDK_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Dependent disk mode.
     * </pre>
     *
     * <code>DEPENDENT = 1;</code>
     */
    public static final int DEPENDENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Independent - Persistent disk mode.
     * </pre>
     *
     * <code>INDEPENDENT_PERSISTENT = 2;</code>
     */
    public static final int INDEPENDENT_PERSISTENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Independent - Nonpersistent disk mode.
     * </pre>
     *
     * <code>INDEPENDENT_NONPERSISTENT = 3;</code>
     */
    public static final int INDEPENDENT_NONPERSISTENT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VmdkMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VmdkMode forNumber(int value) {
      switch (value) {
        case 0:
          return VMDK_MODE_UNSPECIFIED;
        case 1:
          return DEPENDENT;
        case 2:
          return INDEPENDENT_PERSISTENT;
        case 3:
          return INDEPENDENT_NONPERSISTENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VmdkMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VmdkMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VmdkMode>() {
          public VmdkMode findValueByNumber(int number) {
            return VmdkMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final VmdkMode[] VALUES = values();

    public static VmdkMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VmdkMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode)
  }

  /**
   *
   *
   * <pre>
   * RDM compatibility mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility}
   */
  public enum RdmCompatibility implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Compatibility mode unspecified or unknown.
     * </pre>
     *
     * <code>RDM_COMPATIBILITY_UNSPECIFIED = 0;</code>
     */
    RDM_COMPATIBILITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Physical compatibility mode.
     * </pre>
     *
     * <code>PHYSICAL_COMPATIBILITY = 1;</code>
     */
    PHYSICAL_COMPATIBILITY(1),
    /**
     *
     *
     * <pre>
     * Virtual compatibility mode.
     * </pre>
     *
     * <code>VIRTUAL_COMPATIBILITY = 2;</code>
     */
    VIRTUAL_COMPATIBILITY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Compatibility mode unspecified or unknown.
     * </pre>
     *
     * <code>RDM_COMPATIBILITY_UNSPECIFIED = 0;</code>
     */
    public static final int RDM_COMPATIBILITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Physical compatibility mode.
     * </pre>
     *
     * <code>PHYSICAL_COMPATIBILITY = 1;</code>
     */
    public static final int PHYSICAL_COMPATIBILITY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Virtual compatibility mode.
     * </pre>
     *
     * <code>VIRTUAL_COMPATIBILITY = 2;</code>
     */
    public static final int VIRTUAL_COMPATIBILITY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RdmCompatibility valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RdmCompatibility forNumber(int value) {
      switch (value) {
        case 0:
          return RDM_COMPATIBILITY_UNSPECIFIED;
        case 1:
          return PHYSICAL_COMPATIBILITY;
        case 2:
          return VIRTUAL_COMPATIBILITY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RdmCompatibility> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RdmCompatibility>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RdmCompatibility>() {
              public RdmCompatibility findValueByNumber(int number) {
                return RdmCompatibility.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final RdmCompatibility[] VALUES = values();

    public static RdmCompatibility valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RdmCompatibility(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility)
  }

  public static final int BACKING_TYPE_FIELD_NUMBER = 1;
  private int backingType_ = 0;
  /**
   *
   *
   * <pre>
   * VMDK backing type.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
   *
   * @return The enum numeric value on the wire for backingType.
   */
  @java.lang.Override
  public int getBackingTypeValue() {
    return backingType_;
  }
  /**
   *
   *
   * <pre>
   * VMDK backing type.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
   *
   * @return The backingType.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType getBackingType() {
    com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType result =
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType.forNumber(backingType_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType.UNRECOGNIZED
        : result;
  }

  public static final int SHARED_FIELD_NUMBER = 2;
  private boolean shared_ = false;
  /**
   *
   *
   * <pre>
   * Is VMDK shared with other VMs.
   * </pre>
   *
   * <code>bool shared = 2;</code>
   *
   * @return The shared.
   */
  @java.lang.Override
  public boolean getShared() {
    return shared_;
  }

  public static final int VMDK_MODE_FIELD_NUMBER = 3;
  private int vmdkMode_ = 0;
  /**
   *
   *
   * <pre>
   * VMDK disk mode.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
   *
   * @return The enum numeric value on the wire for vmdkMode.
   */
  @java.lang.Override
  public int getVmdkModeValue() {
    return vmdkMode_;
  }
  /**
   *
   *
   * <pre>
   * VMDK disk mode.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
   *
   * @return The vmdkMode.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode getVmdkMode() {
    com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode result =
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode.forNumber(vmdkMode_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode.UNRECOGNIZED
        : result;
  }

  public static final int RDM_COMPATIBILITY_FIELD_NUMBER = 4;
  private int rdmCompatibility_ = 0;
  /**
   *
   *
   * <pre>
   * RDM compatibility mode.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for rdmCompatibility.
   */
  @java.lang.Override
  public int getRdmCompatibilityValue() {
    return rdmCompatibility_;
  }
  /**
   *
   *
   * <pre>
   * RDM compatibility mode.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
   * </code>
   *
   * @return The rdmCompatibility.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility
      getRdmCompatibility() {
    com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility result =
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility.forNumber(
            rdmCompatibility_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (backingType_
        != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType.BACKING_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, backingType_);
    }
    if (shared_ != false) {
      output.writeBool(2, shared_);
    }
    if (vmdkMode_
        != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode.VMDK_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, vmdkMode_);
    }
    if (rdmCompatibility_
        != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility
            .RDM_COMPATIBILITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, rdmCompatibility_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (backingType_
        != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType.BACKING_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, backingType_);
    }
    if (shared_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, shared_);
    }
    if (vmdkMode_
        != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode.VMDK_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, vmdkMode_);
    }
    if (rdmCompatibility_
        != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility
            .RDM_COMPATIBILITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, rdmCompatibility_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.VmwareDiskConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.VmwareDiskConfig other =
        (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) obj;

    if (backingType_ != other.backingType_) return false;
    if (getShared() != other.getShared()) return false;
    if (vmdkMode_ != other.vmdkMode_) return false;
    if (rdmCompatibility_ != other.rdmCompatibility_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BACKING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + backingType_;
    hash = (37 * hash) + SHARED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getShared());
    hash = (37 * hash) + VMDK_MODE_FIELD_NUMBER;
    hash = (53 * hash) + vmdkMode_;
    hash = (37 * hash) + RDM_COMPATIBILITY_FIELD_NUMBER;
    hash = (53 * hash) + rdmCompatibility_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.VmwareDiskConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * VMware disk config details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.VmwareDiskConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.VmwareDiskConfig)
      com.google.cloud.migrationcenter.v1.VmwareDiskConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VmwareDiskConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VmwareDiskConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.VmwareDiskConfig.class,
              com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.VmwareDiskConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      backingType_ = 0;
      shared_ = false;
      vmdkMode_ = 0;
      rdmCompatibility_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VmwareDiskConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig build() {
      com.google.cloud.migrationcenter.v1.VmwareDiskConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig buildPartial() {
      com.google.cloud.migrationcenter.v1.VmwareDiskConfig result =
          new com.google.cloud.migrationcenter.v1.VmwareDiskConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.VmwareDiskConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.backingType_ = backingType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.shared_ = shared_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.vmdkMode_ = vmdkMode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rdmCompatibility_ = rdmCompatibility_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.VmwareDiskConfig) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.VmwareDiskConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.VmwareDiskConfig other) {
      if (other == com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance())
        return this;
      if (other.backingType_ != 0) {
        setBackingTypeValue(other.getBackingTypeValue());
      }
      if (other.getShared() != false) {
        setShared(other.getShared());
      }
      if (other.vmdkMode_ != 0) {
        setVmdkModeValue(other.getVmdkModeValue());
      }
      if (other.rdmCompatibility_ != 0) {
        setRdmCompatibilityValue(other.getRdmCompatibilityValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                backingType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                shared_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                vmdkMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                rdmCompatibility_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int backingType_ = 0;
    /**
     *
     *
     * <pre>
     * VMDK backing type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
     *
     * @return The enum numeric value on the wire for backingType.
     */
    @java.lang.Override
    public int getBackingTypeValue() {
      return backingType_;
    }
    /**
     *
     *
     * <pre>
     * VMDK backing type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for backingType to set.
     * @return This builder for chaining.
     */
    public Builder setBackingTypeValue(int value) {
      backingType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMDK backing type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
     *
     * @return The backingType.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType getBackingType() {
      com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType result =
          com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType.forNumber(backingType_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * VMDK backing type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
     *
     * @param value The backingType to set.
     * @return This builder for chaining.
     */
    public Builder setBackingType(
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      backingType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMDK backing type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType backing_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackingType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      backingType_ = 0;
      onChanged();
      return this;
    }

    private boolean shared_;
    /**
     *
     *
     * <pre>
     * Is VMDK shared with other VMs.
     * </pre>
     *
     * <code>bool shared = 2;</code>
     *
     * @return The shared.
     */
    @java.lang.Override
    public boolean getShared() {
      return shared_;
    }
    /**
     *
     *
     * <pre>
     * Is VMDK shared with other VMs.
     * </pre>
     *
     * <code>bool shared = 2;</code>
     *
     * @param value The shared to set.
     * @return This builder for chaining.
     */
    public Builder setShared(boolean value) {

      shared_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is VMDK shared with other VMs.
     * </pre>
     *
     * <code>bool shared = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShared() {
      bitField0_ = (bitField0_ & ~0x00000002);
      shared_ = false;
      onChanged();
      return this;
    }

    private int vmdkMode_ = 0;
    /**
     *
     *
     * <pre>
     * VMDK disk mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
     *
     * @return The enum numeric value on the wire for vmdkMode.
     */
    @java.lang.Override
    public int getVmdkModeValue() {
      return vmdkMode_;
    }
    /**
     *
     *
     * <pre>
     * VMDK disk mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
     *
     * @param value The enum numeric value on the wire for vmdkMode to set.
     * @return This builder for chaining.
     */
    public Builder setVmdkModeValue(int value) {
      vmdkMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMDK disk mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
     *
     * @return The vmdkMode.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode getVmdkMode() {
      com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode result =
          com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode.forNumber(vmdkMode_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * VMDK disk mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
     *
     * @param value The vmdkMode to set.
     * @return This builder for chaining.
     */
    public Builder setVmdkMode(
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      vmdkMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMDK disk mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode vmdk_mode = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmdkMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      vmdkMode_ = 0;
      onChanged();
      return this;
    }

    private int rdmCompatibility_ = 0;
    /**
     *
     *
     * <pre>
     * RDM compatibility mode.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for rdmCompatibility.
     */
    @java.lang.Override
    public int getRdmCompatibilityValue() {
      return rdmCompatibility_;
    }
    /**
     *
     *
     * <pre>
     * RDM compatibility mode.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for rdmCompatibility to set.
     * @return This builder for chaining.
     */
    public Builder setRdmCompatibilityValue(int value) {
      rdmCompatibility_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RDM compatibility mode.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
     * </code>
     *
     * @return The rdmCompatibility.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility
        getRdmCompatibility() {
      com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility result =
          com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility.forNumber(
              rdmCompatibility_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * RDM compatibility mode.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
     * </code>
     *
     * @param value The rdmCompatibility to set.
     * @return This builder for chaining.
     */
    public Builder setRdmCompatibility(
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      rdmCompatibility_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RDM compatibility mode.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility rdm_compatibility = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRdmCompatibility() {
      bitField0_ = (bitField0_ & ~0x00000008);
      rdmCompatibility_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.VmwareDiskConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.VmwareDiskConfig)
  private static final com.google.cloud.migrationcenter.v1.VmwareDiskConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.VmwareDiskConfig();
  }

  public static com.google.cloud.migrationcenter.v1.VmwareDiskConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VmwareDiskConfig> PARSER =
      new com.google.protobuf.AbstractParser<VmwareDiskConfig>() {
        @java.lang.Override
        public VmwareDiskConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VmwareDiskConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VmwareDiskConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareDiskConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
