/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * The user preferences relating to Google Cloud VMware Engine target platform.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.VmwareEnginePreferences}
 */
public final class VmwareEnginePreferences extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.VmwareEnginePreferences)
    VmwareEnginePreferencesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VmwareEnginePreferences.newBuilder() to construct.
  private VmwareEnginePreferences(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VmwareEnginePreferences() {
    commitmentPlan_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VmwareEnginePreferences();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_VmwareEnginePreferences_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_VmwareEnginePreferences_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.class,
            com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of committed use discount.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan}
   */
  public enum CommitmentPlan implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified commitment plan.
     * </pre>
     *
     * <code>COMMITMENT_PLAN_UNSPECIFIED = 0;</code>
     */
    COMMITMENT_PLAN_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * No commitment plan (on-demand usage).
     * </pre>
     *
     * <code>ON_DEMAND = 1;</code>
     */
    ON_DEMAND(1),
    /**
     *
     *
     * <pre>
     * 1 year commitment (monthly payments).
     * </pre>
     *
     * <code>COMMITMENT_1_YEAR_MONTHLY_PAYMENTS = 2;</code>
     */
    COMMITMENT_1_YEAR_MONTHLY_PAYMENTS(2),
    /**
     *
     *
     * <pre>
     * 3 year commitment (monthly payments).
     * </pre>
     *
     * <code>COMMITMENT_3_YEAR_MONTHLY_PAYMENTS = 3;</code>
     */
    COMMITMENT_3_YEAR_MONTHLY_PAYMENTS(3),
    /**
     *
     *
     * <pre>
     * 1 year commitment (upfront payment).
     * </pre>
     *
     * <code>COMMITMENT_1_YEAR_UPFRONT_PAYMENT = 4;</code>
     */
    COMMITMENT_1_YEAR_UPFRONT_PAYMENT(4),
    /**
     *
     *
     * <pre>
     * 3 years commitment (upfront payment).
     * </pre>
     *
     * <code>COMMITMENT_3_YEAR_UPFRONT_PAYMENT = 5;</code>
     */
    COMMITMENT_3_YEAR_UPFRONT_PAYMENT(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified commitment plan.
     * </pre>
     *
     * <code>COMMITMENT_PLAN_UNSPECIFIED = 0;</code>
     */
    public static final int COMMITMENT_PLAN_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * No commitment plan (on-demand usage).
     * </pre>
     *
     * <code>ON_DEMAND = 1;</code>
     */
    public static final int ON_DEMAND_VALUE = 1;
    /**
     *
     *
     * <pre>
     * 1 year commitment (monthly payments).
     * </pre>
     *
     * <code>COMMITMENT_1_YEAR_MONTHLY_PAYMENTS = 2;</code>
     */
    public static final int COMMITMENT_1_YEAR_MONTHLY_PAYMENTS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * 3 year commitment (monthly payments).
     * </pre>
     *
     * <code>COMMITMENT_3_YEAR_MONTHLY_PAYMENTS = 3;</code>
     */
    public static final int COMMITMENT_3_YEAR_MONTHLY_PAYMENTS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * 1 year commitment (upfront payment).
     * </pre>
     *
     * <code>COMMITMENT_1_YEAR_UPFRONT_PAYMENT = 4;</code>
     */
    public static final int COMMITMENT_1_YEAR_UPFRONT_PAYMENT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * 3 years commitment (upfront payment).
     * </pre>
     *
     * <code>COMMITMENT_3_YEAR_UPFRONT_PAYMENT = 5;</code>
     */
    public static final int COMMITMENT_3_YEAR_UPFRONT_PAYMENT_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CommitmentPlan valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CommitmentPlan forNumber(int value) {
      switch (value) {
        case 0:
          return COMMITMENT_PLAN_UNSPECIFIED;
        case 1:
          return ON_DEMAND;
        case 2:
          return COMMITMENT_1_YEAR_MONTHLY_PAYMENTS;
        case 3:
          return COMMITMENT_3_YEAR_MONTHLY_PAYMENTS;
        case 4:
          return COMMITMENT_1_YEAR_UPFRONT_PAYMENT;
        case 5:
          return COMMITMENT_3_YEAR_UPFRONT_PAYMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CommitmentPlan>() {
          public CommitmentPlan findValueByNumber(int number) {
            return CommitmentPlan.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final CommitmentPlan[] VALUES = values();

    public static CommitmentPlan valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CommitmentPlan(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan)
  }

  public static final int CPU_OVERCOMMIT_RATIO_FIELD_NUMBER = 1;
  private double cpuOvercommitRatio_ = 0D;
  /**
   *
   *
   * <pre>
   * CPU overcommit ratio.
   * Acceptable values are between 1.0 and 8.0, with 0.1 increment.
   * </pre>
   *
   * <code>double cpu_overcommit_ratio = 1;</code>
   *
   * @return The cpuOvercommitRatio.
   */
  @java.lang.Override
  public double getCpuOvercommitRatio() {
    return cpuOvercommitRatio_;
  }

  public static final int MEMORY_OVERCOMMIT_RATIO_FIELD_NUMBER = 2;
  private double memoryOvercommitRatio_ = 0D;
  /**
   *
   *
   * <pre>
   * Memory overcommit ratio.
   * Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
   * </pre>
   *
   * <code>double memory_overcommit_ratio = 2;</code>
   *
   * @return The memoryOvercommitRatio.
   */
  @java.lang.Override
  public double getMemoryOvercommitRatio() {
    return memoryOvercommitRatio_;
  }

  public static final int STORAGE_DEDUPLICATION_COMPRESSION_RATIO_FIELD_NUMBER = 3;
  private double storageDeduplicationCompressionRatio_ = 0D;
  /**
   *
   *
   * <pre>
   * The Deduplication and Compression ratio is based on the logical (Used
   * Before) space required to store data before applying deduplication and
   * compression, in relation to the physical (Used After) space required after
   * applying deduplication and compression. Specifically, the ratio is the Used
   * Before space divided by the Used After space. For example, if the Used
   * Before space is 3 GB, but the physical Used After space is 1 GB, the
   * deduplication and compression ratio is 3x. Acceptable values are
   * between 1.0 and 4.0.
   * </pre>
   *
   * <code>double storage_deduplication_compression_ratio = 3;</code>
   *
   * @return The storageDeduplicationCompressionRatio.
   */
  @java.lang.Override
  public double getStorageDeduplicationCompressionRatio() {
    return storageDeduplicationCompressionRatio_;
  }

  public static final int COMMITMENT_PLAN_FIELD_NUMBER = 4;
  private int commitmentPlan_ = 0;
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for commitmentPlan.
   */
  @java.lang.Override
  public int getCommitmentPlanValue() {
    return commitmentPlan_;
  }
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
   * </code>
   *
   * @return The commitmentPlan.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan
      getCommitmentPlan() {
    com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan result =
        com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan.forNumber(
            commitmentPlan_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Double.doubleToRawLongBits(cpuOvercommitRatio_) != 0) {
      output.writeDouble(1, cpuOvercommitRatio_);
    }
    if (java.lang.Double.doubleToRawLongBits(memoryOvercommitRatio_) != 0) {
      output.writeDouble(2, memoryOvercommitRatio_);
    }
    if (java.lang.Double.doubleToRawLongBits(storageDeduplicationCompressionRatio_) != 0) {
      output.writeDouble(3, storageDeduplicationCompressionRatio_);
    }
    if (commitmentPlan_
        != com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, commitmentPlan_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(cpuOvercommitRatio_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, cpuOvercommitRatio_);
    }
    if (java.lang.Double.doubleToRawLongBits(memoryOvercommitRatio_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, memoryOvercommitRatio_);
    }
    if (java.lang.Double.doubleToRawLongBits(storageDeduplicationCompressionRatio_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              3, storageDeduplicationCompressionRatio_);
    }
    if (commitmentPlan_
        != com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan
            .COMMITMENT_PLAN_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, commitmentPlan_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.VmwareEnginePreferences)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.VmwareEnginePreferences other =
        (com.google.cloud.migrationcenter.v1.VmwareEnginePreferences) obj;

    if (java.lang.Double.doubleToLongBits(getCpuOvercommitRatio())
        != java.lang.Double.doubleToLongBits(other.getCpuOvercommitRatio())) return false;
    if (java.lang.Double.doubleToLongBits(getMemoryOvercommitRatio())
        != java.lang.Double.doubleToLongBits(other.getMemoryOvercommitRatio())) return false;
    if (java.lang.Double.doubleToLongBits(getStorageDeduplicationCompressionRatio())
        != java.lang.Double.doubleToLongBits(other.getStorageDeduplicationCompressionRatio()))
      return false;
    if (commitmentPlan_ != other.commitmentPlan_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CPU_OVERCOMMIT_RATIO_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCpuOvercommitRatio()));
    hash = (37 * hash) + MEMORY_OVERCOMMIT_RATIO_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getMemoryOvercommitRatio()));
    hash = (37 * hash) + STORAGE_DEDUPLICATION_COMPRESSION_RATIO_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getStorageDeduplicationCompressionRatio()));
    hash = (37 * hash) + COMMITMENT_PLAN_FIELD_NUMBER;
    hash = (53 * hash) + commitmentPlan_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.VmwareEnginePreferences prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The user preferences relating to Google Cloud VMware Engine target platform.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.VmwareEnginePreferences}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.VmwareEnginePreferences)
      com.google.cloud.migrationcenter.v1.VmwareEnginePreferencesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VmwareEnginePreferences_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VmwareEnginePreferences_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.class,
              com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cpuOvercommitRatio_ = 0D;
      memoryOvercommitRatio_ = 0D;
      storageDeduplicationCompressionRatio_ = 0D;
      commitmentPlan_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_VmwareEnginePreferences_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences build() {
      com.google.cloud.migrationcenter.v1.VmwareEnginePreferences result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences buildPartial() {
      com.google.cloud.migrationcenter.v1.VmwareEnginePreferences result =
          new com.google.cloud.migrationcenter.v1.VmwareEnginePreferences(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.VmwareEnginePreferences result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cpuOvercommitRatio_ = cpuOvercommitRatio_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.memoryOvercommitRatio_ = memoryOvercommitRatio_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.storageDeduplicationCompressionRatio_ = storageDeduplicationCompressionRatio_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.commitmentPlan_ = commitmentPlan_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.VmwareEnginePreferences) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.VmwareEnginePreferences) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.VmwareEnginePreferences other) {
      if (other == com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.getDefaultInstance())
        return this;
      if (other.getCpuOvercommitRatio() != 0D) {
        setCpuOvercommitRatio(other.getCpuOvercommitRatio());
      }
      if (other.getMemoryOvercommitRatio() != 0D) {
        setMemoryOvercommitRatio(other.getMemoryOvercommitRatio());
      }
      if (other.getStorageDeduplicationCompressionRatio() != 0D) {
        setStorageDeduplicationCompressionRatio(other.getStorageDeduplicationCompressionRatio());
      }
      if (other.commitmentPlan_ != 0) {
        setCommitmentPlanValue(other.getCommitmentPlanValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                cpuOvercommitRatio_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 17:
              {
                memoryOvercommitRatio_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
            case 25:
              {
                storageDeduplicationCompressionRatio_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 32:
              {
                commitmentPlan_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double cpuOvercommitRatio_;
    /**
     *
     *
     * <pre>
     * CPU overcommit ratio.
     * Acceptable values are between 1.0 and 8.0, with 0.1 increment.
     * </pre>
     *
     * <code>double cpu_overcommit_ratio = 1;</code>
     *
     * @return The cpuOvercommitRatio.
     */
    @java.lang.Override
    public double getCpuOvercommitRatio() {
      return cpuOvercommitRatio_;
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit ratio.
     * Acceptable values are between 1.0 and 8.0, with 0.1 increment.
     * </pre>
     *
     * <code>double cpu_overcommit_ratio = 1;</code>
     *
     * @param value The cpuOvercommitRatio to set.
     * @return This builder for chaining.
     */
    public Builder setCpuOvercommitRatio(double value) {

      cpuOvercommitRatio_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit ratio.
     * Acceptable values are between 1.0 and 8.0, with 0.1 increment.
     * </pre>
     *
     * <code>double cpu_overcommit_ratio = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuOvercommitRatio() {
      bitField0_ = (bitField0_ & ~0x00000001);
      cpuOvercommitRatio_ = 0D;
      onChanged();
      return this;
    }

    private double memoryOvercommitRatio_;
    /**
     *
     *
     * <pre>
     * Memory overcommit ratio.
     * Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
     * </pre>
     *
     * <code>double memory_overcommit_ratio = 2;</code>
     *
     * @return The memoryOvercommitRatio.
     */
    @java.lang.Override
    public double getMemoryOvercommitRatio() {
      return memoryOvercommitRatio_;
    }
    /**
     *
     *
     * <pre>
     * Memory overcommit ratio.
     * Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
     * </pre>
     *
     * <code>double memory_overcommit_ratio = 2;</code>
     *
     * @param value The memoryOvercommitRatio to set.
     * @return This builder for chaining.
     */
    public Builder setMemoryOvercommitRatio(double value) {

      memoryOvercommitRatio_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Memory overcommit ratio.
     * Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
     * </pre>
     *
     * <code>double memory_overcommit_ratio = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemoryOvercommitRatio() {
      bitField0_ = (bitField0_ & ~0x00000002);
      memoryOvercommitRatio_ = 0D;
      onChanged();
      return this;
    }

    private double storageDeduplicationCompressionRatio_;
    /**
     *
     *
     * <pre>
     * The Deduplication and Compression ratio is based on the logical (Used
     * Before) space required to store data before applying deduplication and
     * compression, in relation to the physical (Used After) space required after
     * applying deduplication and compression. Specifically, the ratio is the Used
     * Before space divided by the Used After space. For example, if the Used
     * Before space is 3 GB, but the physical Used After space is 1 GB, the
     * deduplication and compression ratio is 3x. Acceptable values are
     * between 1.0 and 4.0.
     * </pre>
     *
     * <code>double storage_deduplication_compression_ratio = 3;</code>
     *
     * @return The storageDeduplicationCompressionRatio.
     */
    @java.lang.Override
    public double getStorageDeduplicationCompressionRatio() {
      return storageDeduplicationCompressionRatio_;
    }
    /**
     *
     *
     * <pre>
     * The Deduplication and Compression ratio is based on the logical (Used
     * Before) space required to store data before applying deduplication and
     * compression, in relation to the physical (Used After) space required after
     * applying deduplication and compression. Specifically, the ratio is the Used
     * Before space divided by the Used After space. For example, if the Used
     * Before space is 3 GB, but the physical Used After space is 1 GB, the
     * deduplication and compression ratio is 3x. Acceptable values are
     * between 1.0 and 4.0.
     * </pre>
     *
     * <code>double storage_deduplication_compression_ratio = 3;</code>
     *
     * @param value The storageDeduplicationCompressionRatio to set.
     * @return This builder for chaining.
     */
    public Builder setStorageDeduplicationCompressionRatio(double value) {

      storageDeduplicationCompressionRatio_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Deduplication and Compression ratio is based on the logical (Used
     * Before) space required to store data before applying deduplication and
     * compression, in relation to the physical (Used After) space required after
     * applying deduplication and compression. Specifically, the ratio is the Used
     * Before space divided by the Used After space. For example, if the Used
     * Before space is 3 GB, but the physical Used After space is 1 GB, the
     * deduplication and compression ratio is 3x. Acceptable values are
     * between 1.0 and 4.0.
     * </pre>
     *
     * <code>double storage_deduplication_compression_ratio = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageDeduplicationCompressionRatio() {
      bitField0_ = (bitField0_ & ~0x00000004);
      storageDeduplicationCompressionRatio_ = 0D;
      onChanged();
      return this;
    }

    private int commitmentPlan_ = 0;
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for commitmentPlan.
     */
    @java.lang.Override
    public int getCommitmentPlanValue() {
      return commitmentPlan_;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for commitmentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentPlanValue(int value) {
      commitmentPlan_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
     * </code>
     *
     * @return The commitmentPlan.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan
        getCommitmentPlan() {
      com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan result =
          com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan.forNumber(
              commitmentPlan_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
     * </code>
     *
     * @param value The commitmentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setCommitmentPlan(
        com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      commitmentPlan_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment plan to consider when calculating costs for virtual machine
     * insights and recommendations.
     * If you are unsure which value to set, a 3 year commitment plan is often a
     * good value to start with.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitmentPlan() {
      bitField0_ = (bitField0_ & ~0x00000008);
      commitmentPlan_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.VmwareEnginePreferences)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.VmwareEnginePreferences)
  private static final com.google.cloud.migrationcenter.v1.VmwareEnginePreferences DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.VmwareEnginePreferences();
  }

  public static com.google.cloud.migrationcenter.v1.VmwareEnginePreferences getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VmwareEnginePreferences> PARSER =
      new com.google.protobuf.AbstractParser<VmwareEnginePreferences>() {
        @java.lang.Override
        public VmwareEnginePreferences parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VmwareEnginePreferences> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VmwareEnginePreferences> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareEnginePreferences getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
