/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

public interface VmwareEnginePreferencesOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.VmwareEnginePreferences)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * CPU overcommit ratio.
   * Acceptable values are between 1.0 and 8.0, with 0.1 increment.
   * </pre>
   *
   * <code>double cpu_overcommit_ratio = 1;</code>
   *
   * @return The cpuOvercommitRatio.
   */
  double getCpuOvercommitRatio();

  /**
   *
   *
   * <pre>
   * Memory overcommit ratio.
   * Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
   * </pre>
   *
   * <code>double memory_overcommit_ratio = 2;</code>
   *
   * @return The memoryOvercommitRatio.
   */
  double getMemoryOvercommitRatio();

  /**
   *
   *
   * <pre>
   * The Deduplication and Compression ratio is based on the logical (Used
   * Before) space required to store data before applying deduplication and
   * compression, in relation to the physical (Used After) space required after
   * applying deduplication and compression. Specifically, the ratio is the Used
   * Before space divided by the Used After space. For example, if the Used
   * Before space is 3 GB, but the physical Used After space is 1 GB, the
   * deduplication and compression ratio is 3x. Acceptable values are
   * between 1.0 and 4.0.
   * </pre>
   *
   * <code>double storage_deduplication_compression_ratio = 3;</code>
   *
   * @return The storageDeduplicationCompressionRatio.
   */
  double getStorageDeduplicationCompressionRatio();

  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for commitmentPlan.
   */
  int getCommitmentPlanValue();
  /**
   *
   *
   * <pre>
   * Commitment plan to consider when calculating costs for virtual machine
   * insights and recommendations.
   * If you are unsure which value to set, a 3 year commitment plan is often a
   * good value to start with.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan commitment_plan = 4;
   * </code>
   *
   * @return The commitmentPlan.
   */
  com.google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan getCommitmentPlan();
}
