/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metricsscope.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetricsScopeName
implements ResourceName {
    private static final PathTemplate METRICS_SCOPE = PathTemplate.createWithoutUrlEncoding((String)"locations/global/metricsScope/{metrics_scope}");
    private volatile Map<String, String> fieldValuesMap;
    private final String metricsScope;

    @Deprecated
    protected MetricsScopeName() {
        this.metricsScope = null;
    }

    private MetricsScopeName(Builder builder) {
        this.metricsScope = (String)Preconditions.checkNotNull((Object)builder.getMetricsScope());
    }

    public String getMetricsScope() {
        return this.metricsScope;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetricsScopeName of(String metricsScope) {
        return MetricsScopeName.newBuilder().setMetricsScope(metricsScope).build();
    }

    public static String format(String metricsScope) {
        return MetricsScopeName.newBuilder().setMetricsScope(metricsScope).build().toString();
    }

    public static MetricsScopeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = METRICS_SCOPE.validatedMatch(formattedString, "MetricsScopeName.parse: formattedString not in valid format");
        return MetricsScopeName.of((String)matchMap.get("metrics_scope"));
    }

    public static List<MetricsScopeName> parseList(List<String> formattedStrings) {
        ArrayList<MetricsScopeName> list = new ArrayList<MetricsScopeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetricsScopeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetricsScopeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetricsScopeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return METRICS_SCOPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetricsScopeName metricsScopeName = this;
            synchronized (metricsScopeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.metricsScope != null) {
                        fieldMapBuilder.put((Object)"metrics_scope", (Object)this.metricsScope);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return METRICS_SCOPE.instantiate(new String[]{"metrics_scope", this.metricsScope});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MetricsScopeName that = (MetricsScopeName)o;
            return Objects.equals(this.metricsScope, that.metricsScope);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.metricsScope);
    }

    public static class Builder {
        private String metricsScope;

        protected Builder() {
        }

        public String getMetricsScope() {
            return this.metricsScope;
        }

        public Builder setMetricsScope(String metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        private Builder(MetricsScopeName metricsScopeName) {
            this.metricsScope = metricsScopeName.metricsScope;
        }

        public MetricsScopeName build() {
            return new MetricsScopeName(this);
        }
    }
}

