/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metricsscope.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MonitoredProjectName
implements ResourceName {
    private static final PathTemplate METRICS_SCOPE_PROJECT = PathTemplate.createWithoutUrlEncoding((String)"locations/global/metricsScopes/{metrics_scope}/projects/{project}");
    private volatile Map<String, String> fieldValuesMap;
    private final String metricsScope;
    private final String project;

    @Deprecated
    protected MonitoredProjectName() {
        this.metricsScope = null;
        this.project = null;
    }

    private MonitoredProjectName(Builder builder) {
        this.metricsScope = (String)Preconditions.checkNotNull((Object)builder.getMetricsScope());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public String getMetricsScope() {
        return this.metricsScope;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MonitoredProjectName of(String metricsScope, String project) {
        return MonitoredProjectName.newBuilder().setMetricsScope(metricsScope).setProject(project).build();
    }

    public static String format(String metricsScope, String project) {
        return MonitoredProjectName.newBuilder().setMetricsScope(metricsScope).setProject(project).build().toString();
    }

    public static MonitoredProjectName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = METRICS_SCOPE_PROJECT.validatedMatch(formattedString, "MonitoredProjectName.parse: formattedString not in valid format");
        return MonitoredProjectName.of((String)matchMap.get("metrics_scope"), (String)matchMap.get("project"));
    }

    public static List<MonitoredProjectName> parseList(List<String> formattedStrings) {
        ArrayList<MonitoredProjectName> list = new ArrayList<MonitoredProjectName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MonitoredProjectName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MonitoredProjectName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MonitoredProjectName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return METRICS_SCOPE_PROJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MonitoredProjectName monitoredProjectName = this;
            synchronized (monitoredProjectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.metricsScope != null) {
                        fieldMapBuilder.put((Object)"metrics_scope", (Object)this.metricsScope);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return METRICS_SCOPE_PROJECT.instantiate(new String[]{"metrics_scope", this.metricsScope, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MonitoredProjectName that = (MonitoredProjectName)o;
            return Objects.equals(this.metricsScope, that.metricsScope) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.metricsScope);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class Builder {
        private String metricsScope;
        private String project;

        protected Builder() {
        }

        public String getMetricsScope() {
            return this.metricsScope;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setMetricsScope(String metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(MonitoredProjectName monitoredProjectName) {
            this.metricsScope = monitoredProjectName.metricsScope;
            this.project = monitoredProjectName.project;
        }

        public MonitoredProjectName build() {
            return new MonitoredProjectName(this);
        }
    }
}

