/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.monitoring.v3.MetricDescriptorNameType;
import java.util.Map;

public class MetricDescriptorName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metricDescriptors/{metric_descriptor=**}");
    private final String project;
    private final String metricDescriptor;

    public String getProject() {
        return this.project;
    }

    public String getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricDescriptorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.metricDescriptor = (String)Preconditions.checkNotNull((Object)builder.getMetricDescriptor());
    }

    public static MetricDescriptorName create(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build();
    }

    public static MetricDescriptorName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MetricDescriptorName.parse: formattedString not in valid format");
        return MetricDescriptorName.create((String)matchMap.get("project"), (String)matchMap.get("metric_descriptor"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return MetricDescriptorNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "metric_descriptor", this.metricDescriptor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricDescriptorName) {
            MetricDescriptorName that = (MetricDescriptorName)o;
            return this.project.equals(that.project) && this.metricDescriptor.equals(that.metricDescriptor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.metricDescriptor.hashCode();
    }

    public static class Builder {
        private String project;
        private String metricDescriptor;

        public String getProject() {
            return this.project;
        }

        public String getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMetricDescriptor(String metricDescriptor) {
            this.metricDescriptor = metricDescriptor;
            return this;
        }

        private Builder() {
        }

        private Builder(MetricDescriptorName metricDescriptorName) {
            this.project = metricDescriptorName.project;
            this.metricDescriptor = metricDescriptorName.metricDescriptor;
        }

        public MetricDescriptorName build() {
            return new MetricDescriptorName(this);
        }
    }
}

