/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NotificationChannelDescriptorName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/notificationChannelDescriptors/{channel_descriptor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String channelDescriptor;

    public String getProject() {
        return this.project;
    }

    public String getChannelDescriptor() {
        return this.channelDescriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private NotificationChannelDescriptorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.channelDescriptor = (String)Preconditions.checkNotNull((Object)builder.getChannelDescriptor());
    }

    public static NotificationChannelDescriptorName of(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build();
    }

    public static String format(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build().toString();
    }

    public static NotificationChannelDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "NotificationChannelDescriptorName.parse: formattedString not in valid format");
        return NotificationChannelDescriptorName.of((String)matchMap.get("project"), (String)matchMap.get("channel_descriptor"));
    }

    public static List<NotificationChannelDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationChannelDescriptorName> list = new ArrayList<NotificationChannelDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationChannelDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationChannelDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationChannelDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationChannelDescriptorName notificationChannelDescriptorName = this;
            synchronized (notificationChannelDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"channelDescriptor", (Object)this.channelDescriptor);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("NotificationChannelDescriptorName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "channel_descriptor", this.channelDescriptor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NotificationChannelDescriptorName) {
            NotificationChannelDescriptorName that = (NotificationChannelDescriptorName)o;
            return this.project.equals(that.project) && this.channelDescriptor.equals(that.channelDescriptor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.channelDescriptor.hashCode();
    }

    public static class Builder {
        private String project;
        private String channelDescriptor;

        public String getProject() {
            return this.project;
        }

        public String getChannelDescriptor() {
            return this.channelDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setChannelDescriptor(String channelDescriptor) {
            this.channelDescriptor = channelDescriptor;
            return this;
        }

        private Builder() {
        }

        private Builder(NotificationChannelDescriptorName notificationChannelDescriptorName) {
            this.project = notificationChannelDescriptorName.project;
            this.channelDescriptor = notificationChannelDescriptorName.channelDescriptor;
        }

        public NotificationChannelDescriptorName build() {
            return new NotificationChannelDescriptorName(this);
        }
    }
}

