/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AlertPolicyConditionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/alertPolicies/{alert_policy}/conditions/{condition}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String alertPolicy;
    private final String condition;

    public String getProject() {
        return this.project;
    }

    public String getAlertPolicy() {
        return this.alertPolicy;
    }

    public String getCondition() {
        return this.condition;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AlertPolicyConditionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.alertPolicy = (String)Preconditions.checkNotNull((Object)builder.getAlertPolicy());
        this.condition = (String)Preconditions.checkNotNull((Object)builder.getCondition());
    }

    public static AlertPolicyConditionName of(String project, String alertPolicy, String condition) {
        return AlertPolicyConditionName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).setCondition(condition).build();
    }

    public static String format(String project, String alertPolicy, String condition) {
        return AlertPolicyConditionName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).setCondition(condition).build().toString();
    }

    public static AlertPolicyConditionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AlertPolicyConditionName.parse: formattedString not in valid format");
        return AlertPolicyConditionName.of((String)matchMap.get("project"), (String)matchMap.get("alert_policy"), (String)matchMap.get("condition"));
    }

    public static List<AlertPolicyConditionName> parseList(List<String> formattedStrings) {
        ArrayList<AlertPolicyConditionName> list = new ArrayList<AlertPolicyConditionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AlertPolicyConditionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AlertPolicyConditionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AlertPolicyConditionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AlertPolicyConditionName alertPolicyConditionName = this;
            synchronized (alertPolicyConditionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"alertPolicy", (Object)this.alertPolicy);
                    fieldMapBuilder.put((Object)"condition", (Object)this.condition);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("AlertPolicyConditionName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "alert_policy", this.alertPolicy, "condition", this.condition});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AlertPolicyConditionName) {
            AlertPolicyConditionName that = (AlertPolicyConditionName)o;
            return this.project.equals(that.project) && this.alertPolicy.equals(that.alertPolicy) && this.condition.equals(that.condition);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.alertPolicy.hashCode();
        h *= 1000003;
        return h ^= this.condition.hashCode();
    }

    public static class Builder {
        private String project;
        private String alertPolicy;
        private String condition;

        public String getProject() {
            return this.project;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public String getCondition() {
            return this.condition;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        public Builder setCondition(String condition) {
            this.condition = condition;
            return this;
        }

        private Builder() {
        }

        private Builder(AlertPolicyConditionName alertPolicyConditionName) {
            this.project = alertPolicyConditionName.project;
            this.alertPolicy = alertPolicyConditionName.alertPolicy;
            this.condition = alertPolicyConditionName.condition;
        }

        public AlertPolicyConditionName build() {
            return new AlertPolicyConditionName(this);
        }
    }
}

