// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric.proto

package com.google.monitoring.v3;

/**
 * <pre>
 * A collection of data points that describes the time-varying values
 * of a metric. A time series is identified by a combination of a
 * fully-specified monitored resource and a fully-specified metric.
 * This type is used for both listing and creating time series.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.TimeSeries}
 */
public  final class TimeSeries extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.TimeSeries)
    TimeSeriesOrBuilder {
private static final long serialVersionUID = 0L;
  // Use TimeSeries.newBuilder() to construct.
  private TimeSeries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private TimeSeries() {
    metricKind_ = 0;
    valueType_ = 0;
    points_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private TimeSeries(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            com.google.api.Metric.Builder subBuilder = null;
            if (metric_ != null) {
              subBuilder = metric_.toBuilder();
            }
            metric_ = input.readMessage(com.google.api.Metric.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(metric_);
              metric_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            com.google.api.MonitoredResource.Builder subBuilder = null;
            if (resource_ != null) {
              subBuilder = resource_.toBuilder();
            }
            resource_ = input.readMessage(com.google.api.MonitoredResource.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(resource_);
              resource_ = subBuilder.buildPartial();
            }

            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            metricKind_ = rawValue;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            valueType_ = rawValue;
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              points_ = new java.util.ArrayList<com.google.monitoring.v3.Point>();
              mutable_bitField0_ |= 0x00000010;
            }
            points_.add(
                input.readMessage(com.google.monitoring.v3.Point.parser(), extensionRegistry));
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        points_ = java.util.Collections.unmodifiableList(points_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.monitoring.v3.MetricProto.internal_static_google_monitoring_v3_TimeSeries_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricProto.internal_static_google_monitoring_v3_TimeSeries_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.TimeSeries.class, com.google.monitoring.v3.TimeSeries.Builder.class);
  }

  private int bitField0_;
  public static final int METRIC_FIELD_NUMBER = 1;
  private com.google.api.Metric metric_;
  /**
   * <pre>
   * The associated metric. A fully-specified metric used to identify the time
   * series.
   * </pre>
   *
   * <code>.google.api.Metric metric = 1;</code>
   */
  public boolean hasMetric() {
    return metric_ != null;
  }
  /**
   * <pre>
   * The associated metric. A fully-specified metric used to identify the time
   * series.
   * </pre>
   *
   * <code>.google.api.Metric metric = 1;</code>
   */
  public com.google.api.Metric getMetric() {
    return metric_ == null ? com.google.api.Metric.getDefaultInstance() : metric_;
  }
  /**
   * <pre>
   * The associated metric. A fully-specified metric used to identify the time
   * series.
   * </pre>
   *
   * <code>.google.api.Metric metric = 1;</code>
   */
  public com.google.api.MetricOrBuilder getMetricOrBuilder() {
    return getMetric();
  }

  public static final int RESOURCE_FIELD_NUMBER = 2;
  private com.google.api.MonitoredResource resource_;
  /**
   * <pre>
   * The associated resource. A fully-specified monitored resource used to
   * identify the time series.
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 2;</code>
   */
  public boolean hasResource() {
    return resource_ != null;
  }
  /**
   * <pre>
   * The associated resource. A fully-specified monitored resource used to
   * identify the time series.
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 2;</code>
   */
  public com.google.api.MonitoredResource getResource() {
    return resource_ == null ? com.google.api.MonitoredResource.getDefaultInstance() : resource_;
  }
  /**
   * <pre>
   * The associated resource. A fully-specified monitored resource used to
   * identify the time series.
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 2;</code>
   */
  public com.google.api.MonitoredResourceOrBuilder getResourceOrBuilder() {
    return getResource();
  }

  public static final int METRIC_KIND_FIELD_NUMBER = 3;
  private int metricKind_;
  /**
   * <pre>
   * The metric kind of the time series. When listing time series, this metric
   * kind might be different from the metric kind of the associated metric if
   * this time series is an alignment or reduction of other time series.
   * When creating a time series, this field is optional. If present, it must be
   * the same as the metric kind of the associated metric. If the associated
   * metric's descriptor must be auto-created, then this field specifies the
   * metric kind of the new descriptor and must be either `GAUGE` (the default)
   * or `CUMULATIVE`.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
   */
  public int getMetricKindValue() {
    return metricKind_;
  }
  /**
   * <pre>
   * The metric kind of the time series. When listing time series, this metric
   * kind might be different from the metric kind of the associated metric if
   * this time series is an alignment or reduction of other time series.
   * When creating a time series, this field is optional. If present, it must be
   * the same as the metric kind of the associated metric. If the associated
   * metric's descriptor must be auto-created, then this field specifies the
   * metric kind of the new descriptor and must be either `GAUGE` (the default)
   * or `CUMULATIVE`.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
   */
  public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
    com.google.api.MetricDescriptor.MetricKind result = com.google.api.MetricDescriptor.MetricKind.valueOf(metricKind_);
    return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 4;
  private int valueType_;
  /**
   * <pre>
   * The value type of the time series. When listing time series, this value
   * type might be different from the value type of the associated metric if
   * this time series is an alignment or reduction of other time series.
   * When creating a time series, this field is optional. If present, it must be
   * the same as the type of the data in the `points` field.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
   */
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   * <pre>
   * The value type of the time series. When listing time series, this value
   * type might be different from the value type of the associated metric if
   * this time series is an alignment or reduction of other time series.
   * When creating a time series, this field is optional. If present, it must be
   * the same as the type of the data in the `points` field.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
   */
  public com.google.api.MetricDescriptor.ValueType getValueType() {
    com.google.api.MetricDescriptor.ValueType result = com.google.api.MetricDescriptor.ValueType.valueOf(valueType_);
    return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
  }

  public static final int POINTS_FIELD_NUMBER = 5;
  private java.util.List<com.google.monitoring.v3.Point> points_;
  /**
   * <pre>
   * The data points of this time series. When listing time series, the order of
   * the points is specified by the list method.
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  public java.util.List<com.google.monitoring.v3.Point> getPointsList() {
    return points_;
  }
  /**
   * <pre>
   * The data points of this time series. When listing time series, the order of
   * the points is specified by the list method.
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  public java.util.List<? extends com.google.monitoring.v3.PointOrBuilder> 
      getPointsOrBuilderList() {
    return points_;
  }
  /**
   * <pre>
   * The data points of this time series. When listing time series, the order of
   * the points is specified by the list method.
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  public int getPointsCount() {
    return points_.size();
  }
  /**
   * <pre>
   * The data points of this time series. When listing time series, the order of
   * the points is specified by the list method.
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  public com.google.monitoring.v3.Point getPoints(int index) {
    return points_.get(index);
  }
  /**
   * <pre>
   * The data points of this time series. When listing time series, the order of
   * the points is specified by the list method.
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  public com.google.monitoring.v3.PointOrBuilder getPointsOrBuilder(
      int index) {
    return points_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (metric_ != null) {
      output.writeMessage(1, getMetric());
    }
    if (resource_ != null) {
      output.writeMessage(2, getResource());
    }
    if (metricKind_ != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, metricKind_);
    }
    if (valueType_ != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, valueType_);
    }
    for (int i = 0; i < points_.size(); i++) {
      output.writeMessage(5, points_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (metric_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getMetric());
    }
    if (resource_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getResource());
    }
    if (metricKind_ != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, metricKind_);
    }
    if (valueType_ != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, valueType_);
    }
    for (int i = 0; i < points_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, points_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.TimeSeries)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.TimeSeries other = (com.google.monitoring.v3.TimeSeries) obj;

    boolean result = true;
    result = result && (hasMetric() == other.hasMetric());
    if (hasMetric()) {
      result = result && getMetric()
          .equals(other.getMetric());
    }
    result = result && (hasResource() == other.hasResource());
    if (hasResource()) {
      result = result && getResource()
          .equals(other.getResource());
    }
    result = result && metricKind_ == other.metricKind_;
    result = result && valueType_ == other.valueType_;
    result = result && getPointsList()
        .equals(other.getPointsList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMetric()) {
      hash = (37 * hash) + METRIC_FIELD_NUMBER;
      hash = (53 * hash) + getMetric().hashCode();
    }
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    hash = (37 * hash) + METRIC_KIND_FIELD_NUMBER;
    hash = (53 * hash) + metricKind_;
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    if (getPointsCount() > 0) {
      hash = (37 * hash) + POINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPointsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.monitoring.v3.TimeSeries parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.monitoring.v3.TimeSeries parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.monitoring.v3.TimeSeries prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A collection of data points that describes the time-varying values
   * of a metric. A time series is identified by a combination of a
   * fully-specified monitored resource and a fully-specified metric.
   * This type is used for both listing and creating time series.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TimeSeries}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TimeSeries)
      com.google.monitoring.v3.TimeSeriesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.monitoring.v3.MetricProto.internal_static_google_monitoring_v3_TimeSeries_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto.internal_static_google_monitoring_v3_TimeSeries_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TimeSeries.class, com.google.monitoring.v3.TimeSeries.Builder.class);
    }

    // Construct using com.google.monitoring.v3.TimeSeries.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getPointsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      if (metricBuilder_ == null) {
        metric_ = null;
      } else {
        metric_ = null;
        metricBuilder_ = null;
      }
      if (resourceBuilder_ == null) {
        resource_ = null;
      } else {
        resource_ = null;
        resourceBuilder_ = null;
      }
      metricKind_ = 0;

      valueType_ = 0;

      if (pointsBuilder_ == null) {
        points_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        pointsBuilder_.clear();
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.monitoring.v3.MetricProto.internal_static_google_monitoring_v3_TimeSeries_descriptor;
    }

    public com.google.monitoring.v3.TimeSeries getDefaultInstanceForType() {
      return com.google.monitoring.v3.TimeSeries.getDefaultInstance();
    }

    public com.google.monitoring.v3.TimeSeries build() {
      com.google.monitoring.v3.TimeSeries result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.monitoring.v3.TimeSeries buildPartial() {
      com.google.monitoring.v3.TimeSeries result = new com.google.monitoring.v3.TimeSeries(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (metricBuilder_ == null) {
        result.metric_ = metric_;
      } else {
        result.metric_ = metricBuilder_.build();
      }
      if (resourceBuilder_ == null) {
        result.resource_ = resource_;
      } else {
        result.resource_ = resourceBuilder_.build();
      }
      result.metricKind_ = metricKind_;
      result.valueType_ = valueType_;
      if (pointsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          points_ = java.util.Collections.unmodifiableList(points_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.points_ = points_;
      } else {
        result.points_ = pointsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.TimeSeries) {
        return mergeFrom((com.google.monitoring.v3.TimeSeries)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.TimeSeries other) {
      if (other == com.google.monitoring.v3.TimeSeries.getDefaultInstance()) return this;
      if (other.hasMetric()) {
        mergeMetric(other.getMetric());
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (other.metricKind_ != 0) {
        setMetricKindValue(other.getMetricKindValue());
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (pointsBuilder_ == null) {
        if (!other.points_.isEmpty()) {
          if (points_.isEmpty()) {
            points_ = other.points_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensurePointsIsMutable();
            points_.addAll(other.points_);
          }
          onChanged();
        }
      } else {
        if (!other.points_.isEmpty()) {
          if (pointsBuilder_.isEmpty()) {
            pointsBuilder_.dispose();
            pointsBuilder_ = null;
            points_ = other.points_;
            bitField0_ = (bitField0_ & ~0x00000010);
            pointsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getPointsFieldBuilder() : null;
          } else {
            pointsBuilder_.addAllMessages(other.points_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.TimeSeries parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.monitoring.v3.TimeSeries) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.api.Metric metric_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.Metric, com.google.api.Metric.Builder, com.google.api.MetricOrBuilder> metricBuilder_;
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public boolean hasMetric() {
      return metricBuilder_ != null || metric_ != null;
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public com.google.api.Metric getMetric() {
      if (metricBuilder_ == null) {
        return metric_ == null ? com.google.api.Metric.getDefaultInstance() : metric_;
      } else {
        return metricBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder setMetric(com.google.api.Metric value) {
      if (metricBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metric_ = value;
        onChanged();
      } else {
        metricBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder setMetric(
        com.google.api.Metric.Builder builderForValue) {
      if (metricBuilder_ == null) {
        metric_ = builderForValue.build();
        onChanged();
      } else {
        metricBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder mergeMetric(com.google.api.Metric value) {
      if (metricBuilder_ == null) {
        if (metric_ != null) {
          metric_ =
            com.google.api.Metric.newBuilder(metric_).mergeFrom(value).buildPartial();
        } else {
          metric_ = value;
        }
        onChanged();
      } else {
        metricBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder clearMetric() {
      if (metricBuilder_ == null) {
        metric_ = null;
        onChanged();
      } else {
        metric_ = null;
        metricBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public com.google.api.Metric.Builder getMetricBuilder() {
      
      onChanged();
      return getMetricFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public com.google.api.MetricOrBuilder getMetricOrBuilder() {
      if (metricBuilder_ != null) {
        return metricBuilder_.getMessageOrBuilder();
      } else {
        return metric_ == null ?
            com.google.api.Metric.getDefaultInstance() : metric_;
      }
    }
    /**
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.Metric, com.google.api.Metric.Builder, com.google.api.MetricOrBuilder> 
        getMetricFieldBuilder() {
      if (metricBuilder_ == null) {
        metricBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Metric, com.google.api.Metric.Builder, com.google.api.MetricOrBuilder>(
                getMetric(),
                getParentForChildren(),
                isClean());
        metric_ = null;
      }
      return metricBuilder_;
    }

    private com.google.api.MonitoredResource resource_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.MonitoredResource, com.google.api.MonitoredResource.Builder, com.google.api.MonitoredResourceOrBuilder> resourceBuilder_;
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public boolean hasResource() {
      return resourceBuilder_ != null || resource_ != null;
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public com.google.api.MonitoredResource getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null ? com.google.api.MonitoredResource.getDefaultInstance() : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder setResource(com.google.api.MonitoredResource value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        resourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder setResource(
        com.google.api.MonitoredResource.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder mergeResource(com.google.api.MonitoredResource value) {
      if (resourceBuilder_ == null) {
        if (resource_ != null) {
          resource_ =
            com.google.api.MonitoredResource.newBuilder(resource_).mergeFrom(value).buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        resourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder clearResource() {
      if (resourceBuilder_ == null) {
        resource_ = null;
        onChanged();
      } else {
        resource_ = null;
        resourceBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public com.google.api.MonitoredResource.Builder getResourceBuilder() {
      
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public com.google.api.MonitoredResourceOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null ?
            com.google.api.MonitoredResource.getDefaultInstance() : resource_;
      }
    }
    /**
     * <pre>
     * The associated resource. A fully-specified monitored resource used to
     * identify the time series.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.MonitoredResource, com.google.api.MonitoredResource.Builder, com.google.api.MonitoredResourceOrBuilder> 
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource, com.google.api.MonitoredResource.Builder, com.google.api.MonitoredResourceOrBuilder>(
                getResource(),
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private int metricKind_ = 0;
    /**
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     */
    public int getMetricKindValue() {
      return metricKind_;
    }
    /**
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     */
    public Builder setMetricKindValue(int value) {
      metricKind_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     */
    public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
      com.google.api.MetricDescriptor.MetricKind result = com.google.api.MetricDescriptor.MetricKind.valueOf(metricKind_);
      return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     */
    public Builder setMetricKind(com.google.api.MetricDescriptor.MetricKind value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      metricKind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     */
    public Builder clearMetricKind() {
      
      metricKind_ = 0;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     */
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     */
    public com.google.api.MetricDescriptor.ValueType getValueType() {
      com.google.api.MetricDescriptor.ValueType result = com.google.api.MetricDescriptor.ValueType.valueOf(valueType_);
      return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     */
    public Builder setValueType(com.google.api.MetricDescriptor.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     */
    public Builder clearValueType() {
      
      valueType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.monitoring.v3.Point> points_ =
      java.util.Collections.emptyList();
    private void ensurePointsIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        points_ = new java.util.ArrayList<com.google.monitoring.v3.Point>(points_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.monitoring.v3.Point, com.google.monitoring.v3.Point.Builder, com.google.monitoring.v3.PointOrBuilder> pointsBuilder_;

    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public java.util.List<com.google.monitoring.v3.Point> getPointsList() {
      if (pointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(points_);
      } else {
        return pointsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public int getPointsCount() {
      if (pointsBuilder_ == null) {
        return points_.size();
      } else {
        return pointsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point getPoints(int index) {
      if (pointsBuilder_ == null) {
        return points_.get(index);
      } else {
        return pointsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder setPoints(
        int index, com.google.monitoring.v3.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.set(index, value);
        onChanged();
      } else {
        pointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder setPoints(
        int index, com.google.monitoring.v3.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.set(index, builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(com.google.monitoring.v3.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.add(value);
        onChanged();
      } else {
        pointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(
        int index, com.google.monitoring.v3.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.add(index, value);
        onChanged();
      } else {
        pointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(
        com.google.monitoring.v3.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.add(builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(
        int index, com.google.monitoring.v3.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.add(index, builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addAllPoints(
        java.lang.Iterable<? extends com.google.monitoring.v3.Point> values) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, points_);
        onChanged();
      } else {
        pointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder clearPoints() {
      if (pointsBuilder_ == null) {
        points_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        pointsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder removePoints(int index) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.remove(index);
        onChanged();
      } else {
        pointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point.Builder getPointsBuilder(
        int index) {
      return getPointsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.PointOrBuilder getPointsOrBuilder(
        int index) {
      if (pointsBuilder_ == null) {
        return points_.get(index);  } else {
        return pointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.PointOrBuilder> 
         getPointsOrBuilderList() {
      if (pointsBuilder_ != null) {
        return pointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(points_);
      }
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point.Builder addPointsBuilder() {
      return getPointsFieldBuilder().addBuilder(
          com.google.monitoring.v3.Point.getDefaultInstance());
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point.Builder addPointsBuilder(
        int index) {
      return getPointsFieldBuilder().addBuilder(
          index, com.google.monitoring.v3.Point.getDefaultInstance());
    }
    /**
     * <pre>
     * The data points of this time series. When listing time series, the order of
     * the points is specified by the list method.
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public java.util.List<com.google.monitoring.v3.Point.Builder> 
         getPointsBuilderList() {
      return getPointsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.monitoring.v3.Point, com.google.monitoring.v3.Point.Builder, com.google.monitoring.v3.PointOrBuilder> 
        getPointsFieldBuilder() {
      if (pointsBuilder_ == null) {
        pointsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.Point, com.google.monitoring.v3.Point.Builder, com.google.monitoring.v3.PointOrBuilder>(
                points_,
                ((bitField0_ & 0x00000010) == 0x00000010),
                getParentForChildren(),
                isClean());
        points_ = null;
      }
      return pointsBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TimeSeries)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.TimeSeries)
  private static final com.google.monitoring.v3.TimeSeries DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.TimeSeries();
  }

  public static com.google.monitoring.v3.TimeSeries getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeries>
      PARSER = new com.google.protobuf.AbstractParser<TimeSeries>() {
    public TimeSeries parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new TimeSeries(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<TimeSeries> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeries> getParserForType() {
    return PARSER;
  }

  public com.google.monitoring.v3.TimeSeries getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

