/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AlertPolicyName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/alertPolicies/{alert_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String alertPolicy;

    public String getProject() {
        return this.project;
    }

    public String getAlertPolicy() {
        return this.alertPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AlertPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.alertPolicy = (String)Preconditions.checkNotNull((Object)builder.getAlertPolicy());
    }

    public static AlertPolicyName of(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build();
    }

    public static String format(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build().toString();
    }

    public static AlertPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AlertPolicyName.parse: formattedString not in valid format");
        return AlertPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("alert_policy"));
    }

    public static List<AlertPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AlertPolicyName> list = new ArrayList<AlertPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AlertPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AlertPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AlertPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AlertPolicyName alertPolicyName = this;
            synchronized (alertPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"alertPolicy", (Object)this.alertPolicy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "alert_policy", this.alertPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AlertPolicyName) {
            AlertPolicyName that = (AlertPolicyName)o;
            return this.project.equals(that.project) && this.alertPolicy.equals(that.alertPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.alertPolicy.hashCode();
    }

    public static class Builder {
        private String project;
        private String alertPolicy;

        public String getProject() {
            return this.project;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        private Builder() {
        }

        private Builder(AlertPolicyName alertPolicyName) {
            this.project = alertPolicyName.project;
            this.alertPolicy = alertPolicyName.alertPolicy;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }
}

