// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/notification.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A `NotificationChannel` is a medium through which an alert is
 * delivered when a policy violation is detected. Examples of channels
 * include email, SMS, and third-party messaging applications. Fields
 * containing sensitive information like authentication tokens or
 * contact info are only partially populated on retrieval.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.NotificationChannel}
 */
public final class NotificationChannel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.NotificationChannel)
    NotificationChannelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationChannel.newBuilder() to construct.
  private NotificationChannel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationChannel() {
    type_ = "";
    name_ = "";
    displayName_ = "";
    description_ = "";
    verificationStatus_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private NotificationChannel(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              type_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000010;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                userLabels_ =
                    com.google.protobuf.MapField.newMapField(
                        UserLabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000020;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                  input.readMessage(
                      UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              userLabels_.getMutableMap().put(userLabels__.getKey(), userLabels__.getValue());
              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();

              verificationStatus_ = rawValue;
              break;
            }
          case 90:
            {
              com.google.protobuf.BoolValue.Builder subBuilder = null;
              if (enabled_ != null) {
                subBuilder = enabled_.toBuilder();
              }
              enabled_ =
                  input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(enabled_);
                enabled_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownFieldProto3(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.NotificationProto
        .internal_static_google_monitoring_v3_NotificationChannel_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      case 8:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.NotificationProto
        .internal_static_google_monitoring_v3_NotificationChannel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.NotificationChannel.class,
            com.google.monitoring.v3.NotificationChannel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates whether the channel has been verified or not. It is illegal
   * to specify this field in a
   * [`CreateNotificationChannel`][google.monitoring.v3.NotificationChannelService.CreateNotificationChannel]
   * or an
   * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
   * operation.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.NotificationChannel.VerificationStatus}
   */
  public enum VerificationStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Sentinel value used to indicate that the state is unknown, omitted, or
     * is not applicable (as in the case of channels that neither support
     * nor require verification in order to function).
     * </pre>
     *
     * <code>VERIFICATION_STATUS_UNSPECIFIED = 0;</code>
     */
    VERIFICATION_STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The channel has yet to be verified and requires verification to function.
     * Note that this state also applies to the case where the verification
     * process has been initiated by sending a verification code but where
     * the verification code has not been submitted to complete the process.
     * </pre>
     *
     * <code>UNVERIFIED = 1;</code>
     */
    UNVERIFIED(1),
    /**
     *
     *
     * <pre>
     * It has been proven that notifications can be received on this
     * notification channel and that someone on the project has access
     * to messages that are delivered to that channel.
     * </pre>
     *
     * <code>VERIFIED = 2;</code>
     */
    VERIFIED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Sentinel value used to indicate that the state is unknown, omitted, or
     * is not applicable (as in the case of channels that neither support
     * nor require verification in order to function).
     * </pre>
     *
     * <code>VERIFICATION_STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int VERIFICATION_STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The channel has yet to be verified and requires verification to function.
     * Note that this state also applies to the case where the verification
     * process has been initiated by sending a verification code but where
     * the verification code has not been submitted to complete the process.
     * </pre>
     *
     * <code>UNVERIFIED = 1;</code>
     */
    public static final int UNVERIFIED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * It has been proven that notifications can be received on this
     * notification channel and that someone on the project has access
     * to messages that are delivered to that channel.
     * </pre>
     *
     * <code>VERIFIED = 2;</code>
     */
    public static final int VERIFIED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static VerificationStatus valueOf(int value) {
      return forNumber(value);
    }

    public static VerificationStatus forNumber(int value) {
      switch (value) {
        case 0:
          return VERIFICATION_STATUS_UNSPECIFIED;
        case 1:
          return UNVERIFIED;
        case 2:
          return VERIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VerificationStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VerificationStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VerificationStatus>() {
              public VerificationStatus findValueByNumber(int number) {
                return VerificationStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.NotificationChannel.getDescriptor().getEnumTypes().get(0);
    }

    private static final VerificationStatus[] VALUES = values();

    public static VerificationStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VerificationStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.NotificationChannel.VerificationStatus)
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object type_;
  /**
   *
   *
   * <pre>
   * The type of the notification channel. This field matches the
   * value of the
   * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
   * field.
   * </pre>
   *
   * <code>string type = 1;</code>
   */
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the notification channel. This field matches the
   * value of the
   * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
   * field.
   * </pre>
   *
   * <code>string type = 1;</code>
   */
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The full REST resource name for this channel. The syntax is:
   *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
   * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
   * </pre>
   *
   * <code>string name = 6;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full REST resource name for this channel. The syntax is:
   *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
   * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
   * </pre>
   *
   * <code>string name = 6;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * An optional human-readable name for this notification channel. It is
   * recommended that you specify a non-empty and unique name in order to
   * make it easier to identify the channels in your project, though this is
   * not enforced. The display name is limited to 512 Unicode characters.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional human-readable name for this notification channel. It is
   * recommended that you specify a non-empty and unique name in order to
   * make it easier to identify the channels in your project, though this is
   * not enforced. The display name is limited to 512 Unicode characters.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * An optional human-readable description of this notification channel. This
   * description may provide additional details, beyond the display
   * name, for the channel. This may not exceeed 1024 Unicode characters.
   * </pre>
   *
   * <code>string description = 4;</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional human-readable description of this notification channel. This
   * description may provide additional details, beyond the display
   * name, for the channel. This may not exceeed 1024 Unicode characters.
   * </pre>
   *
   * <code>string description = 4;</code>
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.NotificationProto
                .internal_static_google_monitoring_v3_NotificationChannel_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int USER_LABELS_FIELD_NUMBER = 8;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.NotificationProto
                .internal_static_google_monitoring_v3_NotificationChannel_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  public java.lang.String getUserLabelsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int VERIFICATION_STATUS_FIELD_NUMBER = 9;
  private int verificationStatus_;
  /**
   *
   *
   * <pre>
   * Indicates whether this channel has been verified or not. On a
   * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * or
   * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
   * operation, this field is expected to be populated.
   * If the value is `UNVERIFIED`, then it indicates that the channel is
   * non-functioning (it both requires verification and lacks verification);
   * otherwise, it is assumed that the channel works.
   * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
   * the channel is of a type that does not require verification or that
   * this specific channel has been exempted from verification because it was
   * created prior to verification being required for channels of this type.
   * This field cannot be modified using a standard
   * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
   * operation. To change the value of this field, you must call
   * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
   * </pre>
   *
   * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
   * </code>
   */
  public int getVerificationStatusValue() {
    return verificationStatus_;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether this channel has been verified or not. On a
   * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * or
   * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
   * operation, this field is expected to be populated.
   * If the value is `UNVERIFIED`, then it indicates that the channel is
   * non-functioning (it both requires verification and lacks verification);
   * otherwise, it is assumed that the channel works.
   * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
   * the channel is of a type that does not require verification or that
   * this specific channel has been exempted from verification because it was
   * created prior to verification being required for channels of this type.
   * This field cannot be modified using a standard
   * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
   * operation. To change the value of this field, you must call
   * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
   * </pre>
   *
   * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
   * </code>
   */
  public com.google.monitoring.v3.NotificationChannel.VerificationStatus getVerificationStatus() {
    @SuppressWarnings("deprecation")
    com.google.monitoring.v3.NotificationChannel.VerificationStatus result =
        com.google.monitoring.v3.NotificationChannel.VerificationStatus.valueOf(
            verificationStatus_);
    return result == null
        ? com.google.monitoring.v3.NotificationChannel.VerificationStatus.UNRECOGNIZED
        : result;
  }

  public static final int ENABLED_FIELD_NUMBER = 11;
  private com.google.protobuf.BoolValue enabled_;
  /**
   *
   *
   * <pre>
   * Whether notifications are forwarded to the described channel. This makes
   * it possible to disable delivery of notifications to a particular channel
   * without removing the channel from all alerting policies that reference
   * the channel. This is a more convenient approach when the change is
   * temporary and you want to receive notifications from the same set
   * of alerting policies on the channel at some point in the future.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 11;</code>
   */
  public boolean hasEnabled() {
    return enabled_ != null;
  }
  /**
   *
   *
   * <pre>
   * Whether notifications are forwarded to the described channel. This makes
   * it possible to disable delivery of notifications to a particular channel
   * without removing the channel from all alerting policies that reference
   * the channel. This is a more convenient approach when the change is
   * temporary and you want to receive notifications from the same set
   * of alerting policies on the channel at some point in the future.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 11;</code>
   */
  public com.google.protobuf.BoolValue getEnabled() {
    return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
  }
  /**
   *
   *
   * <pre>
   * Whether notifications are forwarded to the described channel. This makes
   * it possible to disable delivery of notifications to a particular channel
   * without removing the channel from all alerting policies that reference
   * the channel. This is a more convenient approach when the change is
   * temporary and you want to receive notifications from the same set
   * of alerting policies on the channel at some point in the future.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 11;</code>
   */
  public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
    return getEnabled();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getTypeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 8);
    if (verificationStatus_
        != com.google.monitoring.v3.NotificationChannel.VerificationStatus
            .VERIFICATION_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, verificationStatus_);
    }
    if (enabled_ != null) {
      output.writeMessage(11, getEnabled());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getTypeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, userLabels__);
    }
    if (verificationStatus_
        != com.google.monitoring.v3.NotificationChannel.VerificationStatus
            .VERIFICATION_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, verificationStatus_);
    }
    if (enabled_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEnabled());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.NotificationChannel)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.NotificationChannel other =
        (com.google.monitoring.v3.NotificationChannel) obj;

    boolean result = true;
    result = result && getType().equals(other.getType());
    result = result && getName().equals(other.getName());
    result = result && getDisplayName().equals(other.getDisplayName());
    result = result && getDescription().equals(other.getDescription());
    result = result && internalGetLabels().equals(other.internalGetLabels());
    result = result && internalGetUserLabels().equals(other.internalGetUserLabels());
    result = result && verificationStatus_ == other.verificationStatus_;
    result = result && (hasEnabled() == other.hasEnabled());
    if (hasEnabled()) {
      result = result && getEnabled().equals(other.getEnabled());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (37 * hash) + VERIFICATION_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + verificationStatus_;
    if (hasEnabled()) {
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + getEnabled().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.NotificationChannel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `NotificationChannel` is a medium through which an alert is
   * delivered when a policy violation is detected. Examples of channels
   * include email, SMS, and third-party messaging applications. Fields
   * containing sensitive information like authentication tokens or
   * contact info are only partially populated on retrieval.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.NotificationChannel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.NotificationChannel)
      com.google.monitoring.v3.NotificationChannelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannel_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        case 8:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        case 8:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.NotificationChannel.class,
              com.google.monitoring.v3.NotificationChannel.Builder.class);
    }

    // Construct using com.google.monitoring.v3.NotificationChannel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      type_ = "";

      name_ = "";

      displayName_ = "";

      description_ = "";

      internalGetMutableLabels().clear();
      internalGetMutableUserLabels().clear();
      verificationStatus_ = 0;

      if (enabledBuilder_ == null) {
        enabled_ = null;
      } else {
        enabled_ = null;
        enabledBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannel_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel getDefaultInstanceForType() {
      return com.google.monitoring.v3.NotificationChannel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel build() {
      com.google.monitoring.v3.NotificationChannel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel buildPartial() {
      com.google.monitoring.v3.NotificationChannel result =
          new com.google.monitoring.v3.NotificationChannel(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.type_ = type_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.userLabels_ = internalGetUserLabels();
      result.userLabels_.makeImmutable();
      result.verificationStatus_ = verificationStatus_;
      if (enabledBuilder_ == null) {
        result.enabled_ = enabled_;
      } else {
        result.enabled_ = enabledBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.NotificationChannel) {
        return mergeFrom((com.google.monitoring.v3.NotificationChannel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.NotificationChannel other) {
      if (other == com.google.monitoring.v3.NotificationChannel.getDefaultInstance()) return this;
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      if (other.verificationStatus_ != 0) {
        setVerificationStatusValue(other.getVerificationStatusValue());
      }
      if (other.hasEnabled()) {
        mergeEnabled(other.getEnabled());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.NotificationChannel parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.monitoring.v3.NotificationChannel) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public Builder clearType() {

      type_ = getDefaultInstance().getType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      type_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceeed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceeed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceeed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceeed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceeed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      onChanged();
      ;
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public java.lang.String getUserLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      return this;
    }

    private int verificationStatus_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     */
    public int getVerificationStatusValue() {
      return verificationStatus_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     */
    public Builder setVerificationStatusValue(int value) {
      verificationStatus_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     */
    public com.google.monitoring.v3.NotificationChannel.VerificationStatus getVerificationStatus() {
      @SuppressWarnings("deprecation")
      com.google.monitoring.v3.NotificationChannel.VerificationStatus result =
          com.google.monitoring.v3.NotificationChannel.VerificationStatus.valueOf(
              verificationStatus_);
      return result == null
          ? com.google.monitoring.v3.NotificationChannel.VerificationStatus.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     */
    public Builder setVerificationStatus(
        com.google.monitoring.v3.NotificationChannel.VerificationStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }

      verificationStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     */
    public Builder clearVerificationStatus() {

      verificationStatus_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue enabled_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        enabledBuilder_;
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public boolean hasEnabled() {
      return enabledBuilder_ != null || enabled_ != null;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public com.google.protobuf.BoolValue getEnabled() {
      if (enabledBuilder_ == null) {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      } else {
        return enabledBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder setEnabled(com.google.protobuf.BoolValue value) {
      if (enabledBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enabled_ = value;
        onChanged();
      } else {
        enabledBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder setEnabled(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (enabledBuilder_ == null) {
        enabled_ = builderForValue.build();
        onChanged();
      } else {
        enabledBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder mergeEnabled(com.google.protobuf.BoolValue value) {
      if (enabledBuilder_ == null) {
        if (enabled_ != null) {
          enabled_ =
              com.google.protobuf.BoolValue.newBuilder(enabled_).mergeFrom(value).buildPartial();
        } else {
          enabled_ = value;
        }
        onChanged();
      } else {
        enabledBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder clearEnabled() {
      if (enabledBuilder_ == null) {
        enabled_ = null;
        onChanged();
      } else {
        enabled_ = null;
        enabledBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public com.google.protobuf.BoolValue.Builder getEnabledBuilder() {

      onChanged();
      return getEnabledFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
      if (enabledBuilder_ != null) {
        return enabledBuilder_.getMessageOrBuilder();
      } else {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getEnabledFieldBuilder() {
      if (enabledBuilder_ == null) {
        enabledBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getEnabled(), getParentForChildren(), isClean());
        enabled_ = null;
      }
      return enabledBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.NotificationChannel)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.NotificationChannel)
  private static final com.google.monitoring.v3.NotificationChannel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.NotificationChannel();
  }

  public static com.google.monitoring.v3.NotificationChannel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationChannel> PARSER =
      new com.google.protobuf.AbstractParser<NotificationChannel>() {
        @java.lang.Override
        public NotificationChannel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new NotificationChannel(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<NotificationChannel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationChannel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.NotificationChannel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
