/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The `ListTimeSeries` request.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.ListTimeSeriesRequest}
 */
public final class ListTimeSeriesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.ListTimeSeriesRequest)
    ListTimeSeriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTimeSeriesRequest.newBuilder() to construct.
  private ListTimeSeriesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTimeSeriesRequest() {
    name_ = "";
    filter_ = "";
    orderBy_ = "";
    view_ = 0;
    pageToken_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListTimeSeriesRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              filter_ = s;
              break;
            }
          case 34:
            {
              com.google.monitoring.v3.TimeInterval.Builder subBuilder = null;
              if (interval_ != null) {
                subBuilder = interval_.toBuilder();
              }
              interval_ =
                  input.readMessage(
                      com.google.monitoring.v3.TimeInterval.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(interval_);
                interval_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.monitoring.v3.Aggregation.Builder subBuilder = null;
              if (aggregation_ != null) {
                subBuilder = aggregation_.toBuilder();
              }
              aggregation_ =
                  input.readMessage(
                      com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(aggregation_);
                aggregation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              orderBy_ = s;
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              view_ = rawValue;
              break;
            }
          case 64:
            {
              pageSize_ = input.readInt32();
              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              pageToken_ = s;
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_ListTimeSeriesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_ListTimeSeriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.ListTimeSeriesRequest.class,
            com.google.monitoring.v3.ListTimeSeriesRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Controls which fields are returned by `ListTimeSeries`.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView}
   */
  public enum TimeSeriesView implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Returns the identity of the metric(s), the time series,
     * and the time series data.
     * </pre>
     *
     * <code>FULL = 0;</code>
     */
    FULL(0),
    /**
     *
     *
     * <pre>
     * Returns the identity of the metric and the time series resource,
     * but not the time series data.
     * </pre>
     *
     * <code>HEADERS = 1;</code>
     */
    HEADERS(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Returns the identity of the metric(s), the time series,
     * and the time series data.
     * </pre>
     *
     * <code>FULL = 0;</code>
     */
    public static final int FULL_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Returns the identity of the metric and the time series resource,
     * but not the time series data.
     * </pre>
     *
     * <code>HEADERS = 1;</code>
     */
    public static final int HEADERS_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static TimeSeriesView valueOf(int value) {
      return forNumber(value);
    }

    public static TimeSeriesView forNumber(int value) {
      switch (value) {
        case 0:
          return FULL;
        case 1:
          return HEADERS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TimeSeriesView> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TimeSeriesView> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TimeSeriesView>() {
          public TimeSeriesView findValueByNumber(int number) {
            return TimeSeriesView.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.ListTimeSeriesRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final TimeSeriesView[] VALUES = values();

    public static TimeSeriesView valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TimeSeriesView(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView)
  }

  public static final int NAME_FIELD_NUMBER = 10;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The project on which to execute the request. The format is
   * "projects/{project_id_or_number}".
   * </pre>
   *
   * <code>string name = 10;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project on which to execute the request. The format is
   * "projects/{project_id_or_number}".
   * </pre>
   *
   * <code>string name = 10;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
   * series should be returned.  The filter must specify a single metric type,
   * and can additionally specify metric labels and other information. For
   * example:
   *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
   *         metric.labels.instance_name = "my-instance-name"
   * </pre>
   *
   * <code>string filter = 2;</code>
   */
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
   * series should be returned.  The filter must specify a single metric type,
   * and can additionally specify metric labels and other information. For
   * example:
   *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
   *         metric.labels.instance_name = "my-instance-name"
   * </pre>
   *
   * <code>string filter = 2;</code>
   */
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERVAL_FIELD_NUMBER = 4;
  private com.google.monitoring.v3.TimeInterval interval_;
  /**
   *
   *
   * <pre>
   * The time interval for which results should be returned. Only time series
   * that contain data points in the specified interval are included
   * in the response.
   * </pre>
   *
   * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
   */
  public boolean hasInterval() {
    return interval_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time interval for which results should be returned. Only time series
   * that contain data points in the specified interval are included
   * in the response.
   * </pre>
   *
   * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
   */
  public com.google.monitoring.v3.TimeInterval getInterval() {
    return interval_ == null
        ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
        : interval_;
  }
  /**
   *
   *
   * <pre>
   * The time interval for which results should be returned. Only time series
   * that contain data points in the specified interval are included
   * in the response.
   * </pre>
   *
   * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
   */
  public com.google.monitoring.v3.TimeIntervalOrBuilder getIntervalOrBuilder() {
    return getInterval();
  }

  public static final int AGGREGATION_FIELD_NUMBER = 5;
  private com.google.monitoring.v3.Aggregation aggregation_;
  /**
   *
   *
   * <pre>
   * Specifies the alignment of data points in individual time series as
   * well as how to combine the retrieved time series across specified labels.
   * By default (if no `aggregation` is explicitly specified), the raw time
   * series data is returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
   */
  public boolean hasAggregation() {
    return aggregation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the alignment of data points in individual time series as
   * well as how to combine the retrieved time series across specified labels.
   * By default (if no `aggregation` is explicitly specified), the raw time
   * series data is returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
   */
  public com.google.monitoring.v3.Aggregation getAggregation() {
    return aggregation_ == null
        ? com.google.monitoring.v3.Aggregation.getDefaultInstance()
        : aggregation_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the alignment of data points in individual time series as
   * well as how to combine the retrieved time series across specified labels.
   * By default (if no `aggregation` is explicitly specified), the raw time
   * series data is returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
   */
  public com.google.monitoring.v3.AggregationOrBuilder getAggregationOrBuilder() {
    return getAggregation();
  }

  public static final int ORDER_BY_FIELD_NUMBER = 6;
  private volatile java.lang.Object orderBy_;
  /**
   *
   *
   * <pre>
   * Unsupported: must be left blank. The points in each time series are
   * currently returned in reverse time order (most recent to oldest).
   * </pre>
   *
   * <code>string order_by = 6;</code>
   */
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unsupported: must be left blank. The points in each time series are
   * currently returned in reverse time order (most recent to oldest).
   * </pre>
   *
   * <code>string order_by = 6;</code>
   */
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIEW_FIELD_NUMBER = 7;
  private int view_;
  /**
   *
   *
   * <pre>
   * Specifies which information is returned about the time series.
   * </pre>
   *
   * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
   */
  public int getViewValue() {
    return view_;
  }
  /**
   *
   *
   * <pre>
   * Specifies which information is returned about the time series.
   * </pre>
   *
   * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
   */
  public com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView getView() {
    @SuppressWarnings("deprecation")
    com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView result =
        com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView.valueOf(view_);
    return result == null
        ? com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView.UNRECOGNIZED
        : result;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 8;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * A positive number that is the maximum number of results to return. If
   * `page_size` is empty or more than 100,000 results, the effective
   * `page_size` is 100,000 results. If `view` is set to `FULL`, this is the
   * maximum number of `Points` returned. If `view` is set to `HEADERS`, this is
   * the maximum number of `TimeSeries` returned.
   * </pre>
   *
   * <code>int32 page_size = 8;</code>
   */
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 9;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * If this field is not empty then it must contain the `nextPageToken` value
   * returned by a previous call to this method.  Using this field causes the
   * method to return additional results from the previous method call.
   * </pre>
   *
   * <code>string page_token = 9;</code>
   */
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If this field is not empty then it must contain the `nextPageToken` value
   * returned by a previous call to this method.  Using this field causes the
   * method to return additional results from the previous method call.
   * </pre>
   *
   * <code>string page_token = 9;</code>
   */
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getFilterBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (interval_ != null) {
      output.writeMessage(4, getInterval());
    }
    if (aggregation_ != null) {
      output.writeMessage(5, getAggregation());
    }
    if (!getOrderByBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, orderBy_);
    }
    if (view_ != com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView.FULL.getNumber()) {
      output.writeEnum(7, view_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(8, pageSize_);
    }
    if (!getPageTokenBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, pageToken_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, name_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getFilterBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (interval_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInterval());
    }
    if (aggregation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAggregation());
    }
    if (!getOrderByBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, orderBy_);
    }
    if (view_ != com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView.FULL.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, view_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, pageSize_);
    }
    if (!getPageTokenBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, pageToken_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, name_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.ListTimeSeriesRequest)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.ListTimeSeriesRequest other =
        (com.google.monitoring.v3.ListTimeSeriesRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (hasInterval() != other.hasInterval()) return false;
    if (hasInterval()) {
      if (!getInterval().equals(other.getInterval())) return false;
    }
    if (hasAggregation() != other.hasAggregation()) return false;
    if (hasAggregation()) {
      if (!getAggregation().equals(other.getAggregation())) return false;
    }
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (view_ != other.view_) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (hasInterval()) {
      hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getInterval().hashCode();
    }
    if (hasAggregation()) {
      hash = (37 * hash) + AGGREGATION_FIELD_NUMBER;
      hash = (53 * hash) + getAggregation().hashCode();
    }
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (37 * hash) + VIEW_FIELD_NUMBER;
    hash = (53 * hash) + view_;
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.ListTimeSeriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `ListTimeSeries` request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.ListTimeSeriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.ListTimeSeriesRequest)
      com.google.monitoring.v3.ListTimeSeriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_ListTimeSeriesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_ListTimeSeriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.ListTimeSeriesRequest.class,
              com.google.monitoring.v3.ListTimeSeriesRequest.Builder.class);
    }

    // Construct using com.google.monitoring.v3.ListTimeSeriesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      filter_ = "";

      if (intervalBuilder_ == null) {
        interval_ = null;
      } else {
        interval_ = null;
        intervalBuilder_ = null;
      }
      if (aggregationBuilder_ == null) {
        aggregation_ = null;
      } else {
        aggregation_ = null;
        aggregationBuilder_ = null;
      }
      orderBy_ = "";

      view_ = 0;

      pageSize_ = 0;

      pageToken_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_ListTimeSeriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListTimeSeriesRequest getDefaultInstanceForType() {
      return com.google.monitoring.v3.ListTimeSeriesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListTimeSeriesRequest build() {
      com.google.monitoring.v3.ListTimeSeriesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListTimeSeriesRequest buildPartial() {
      com.google.monitoring.v3.ListTimeSeriesRequest result =
          new com.google.monitoring.v3.ListTimeSeriesRequest(this);
      result.name_ = name_;
      result.filter_ = filter_;
      if (intervalBuilder_ == null) {
        result.interval_ = interval_;
      } else {
        result.interval_ = intervalBuilder_.build();
      }
      if (aggregationBuilder_ == null) {
        result.aggregation_ = aggregation_;
      } else {
        result.aggregation_ = aggregationBuilder_.build();
      }
      result.orderBy_ = orderBy_;
      result.view_ = view_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.ListTimeSeriesRequest) {
        return mergeFrom((com.google.monitoring.v3.ListTimeSeriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.ListTimeSeriesRequest other) {
      if (other == com.google.monitoring.v3.ListTimeSeriesRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      if (other.hasInterval()) {
        mergeInterval(other.getInterval());
      }
      if (other.hasAggregation()) {
        mergeAggregation(other.getAggregation());
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        onChanged();
      }
      if (other.view_ != 0) {
        setViewValue(other.getViewValue());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.ListTimeSeriesRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.monitoring.v3.ListTimeSeriesRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The project on which to execute the request. The format is
     * "projects/{project_id_or_number}".
     * </pre>
     *
     * <code>string name = 10;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project on which to execute the request. The format is
     * "projects/{project_id_or_number}".
     * </pre>
     *
     * <code>string name = 10;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project on which to execute the request. The format is
     * "projects/{project_id_or_number}".
     * </pre>
     *
     * <code>string name = 10;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project on which to execute the request. The format is
     * "projects/{project_id_or_number}".
     * </pre>
     *
     * <code>string name = 10;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project on which to execute the request. The format is
     * "projects/{project_id_or_number}".
     * </pre>
     *
     * <code>string name = 10;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
     * series should be returned.  The filter must specify a single metric type,
     * and can additionally specify metric labels and other information. For
     * example:
     *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
     *         metric.labels.instance_name = "my-instance-name"
     * </pre>
     *
     * <code>string filter = 2;</code>
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
     * series should be returned.  The filter must specify a single metric type,
     * and can additionally specify metric labels and other information. For
     * example:
     *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
     *         metric.labels.instance_name = "my-instance-name"
     * </pre>
     *
     * <code>string filter = 2;</code>
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
     * series should be returned.  The filter must specify a single metric type,
     * and can additionally specify metric labels and other information. For
     * example:
     *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
     *         metric.labels.instance_name = "my-instance-name"
     * </pre>
     *
     * <code>string filter = 2;</code>
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
     * series should be returned.  The filter must specify a single metric type,
     * and can additionally specify metric labels and other information. For
     * example:
     *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
     *         metric.labels.instance_name = "my-instance-name"
     * </pre>
     *
     * <code>string filter = 2;</code>
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](/monitoring/api/v3/filters) that specifies which time
     * series should be returned.  The filter must specify a single metric type,
     * and can additionally specify metric labels and other information. For
     * example:
     *     metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
     *         metric.labels.instance_name = "my-instance-name"
     * </pre>
     *
     * <code>string filter = 2;</code>
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    private com.google.monitoring.v3.TimeInterval interval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TimeInterval,
            com.google.monitoring.v3.TimeInterval.Builder,
            com.google.monitoring.v3.TimeIntervalOrBuilder>
        intervalBuilder_;
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public boolean hasInterval() {
      return intervalBuilder_ != null || interval_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public com.google.monitoring.v3.TimeInterval getInterval() {
      if (intervalBuilder_ == null) {
        return interval_ == null
            ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
            : interval_;
      } else {
        return intervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public Builder setInterval(com.google.monitoring.v3.TimeInterval value) {
      if (intervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        interval_ = value;
        onChanged();
      } else {
        intervalBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public Builder setInterval(com.google.monitoring.v3.TimeInterval.Builder builderForValue) {
      if (intervalBuilder_ == null) {
        interval_ = builderForValue.build();
        onChanged();
      } else {
        intervalBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public Builder mergeInterval(com.google.monitoring.v3.TimeInterval value) {
      if (intervalBuilder_ == null) {
        if (interval_ != null) {
          interval_ =
              com.google.monitoring.v3.TimeInterval.newBuilder(interval_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          interval_ = value;
        }
        onChanged();
      } else {
        intervalBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public Builder clearInterval() {
      if (intervalBuilder_ == null) {
        interval_ = null;
        onChanged();
      } else {
        interval_ = null;
        intervalBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public com.google.monitoring.v3.TimeInterval.Builder getIntervalBuilder() {

      onChanged();
      return getIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    public com.google.monitoring.v3.TimeIntervalOrBuilder getIntervalOrBuilder() {
      if (intervalBuilder_ != null) {
        return intervalBuilder_.getMessageOrBuilder();
      } else {
        return interval_ == null
            ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
            : interval_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time interval for which results should be returned. Only time series
     * that contain data points in the specified interval are included
     * in the response.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval interval = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TimeInterval,
            com.google.monitoring.v3.TimeInterval.Builder,
            com.google.monitoring.v3.TimeIntervalOrBuilder>
        getIntervalFieldBuilder() {
      if (intervalBuilder_ == null) {
        intervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.TimeInterval,
                com.google.monitoring.v3.TimeInterval.Builder,
                com.google.monitoring.v3.TimeIntervalOrBuilder>(
                getInterval(), getParentForChildren(), isClean());
        interval_ = null;
      }
      return intervalBuilder_;
    }

    private com.google.monitoring.v3.Aggregation aggregation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Aggregation,
            com.google.monitoring.v3.Aggregation.Builder,
            com.google.monitoring.v3.AggregationOrBuilder>
        aggregationBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public boolean hasAggregation() {
      return aggregationBuilder_ != null || aggregation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public com.google.monitoring.v3.Aggregation getAggregation() {
      if (aggregationBuilder_ == null) {
        return aggregation_ == null
            ? com.google.monitoring.v3.Aggregation.getDefaultInstance()
            : aggregation_;
      } else {
        return aggregationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public Builder setAggregation(com.google.monitoring.v3.Aggregation value) {
      if (aggregationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregation_ = value;
        onChanged();
      } else {
        aggregationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public Builder setAggregation(com.google.monitoring.v3.Aggregation.Builder builderForValue) {
      if (aggregationBuilder_ == null) {
        aggregation_ = builderForValue.build();
        onChanged();
      } else {
        aggregationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public Builder mergeAggregation(com.google.monitoring.v3.Aggregation value) {
      if (aggregationBuilder_ == null) {
        if (aggregation_ != null) {
          aggregation_ =
              com.google.monitoring.v3.Aggregation.newBuilder(aggregation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregation_ = value;
        }
        onChanged();
      } else {
        aggregationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public Builder clearAggregation() {
      if (aggregationBuilder_ == null) {
        aggregation_ = null;
        onChanged();
      } else {
        aggregation_ = null;
        aggregationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public com.google.monitoring.v3.Aggregation.Builder getAggregationBuilder() {

      onChanged();
      return getAggregationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    public com.google.monitoring.v3.AggregationOrBuilder getAggregationOrBuilder() {
      if (aggregationBuilder_ != null) {
        return aggregationBuilder_.getMessageOrBuilder();
      } else {
        return aggregation_ == null
            ? com.google.monitoring.v3.Aggregation.getDefaultInstance()
            : aggregation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the alignment of data points in individual time series as
     * well as how to combine the retrieved time series across specified labels.
     * By default (if no `aggregation` is explicitly specified), the raw time
     * series data is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation aggregation = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Aggregation,
            com.google.monitoring.v3.Aggregation.Builder,
            com.google.monitoring.v3.AggregationOrBuilder>
        getAggregationFieldBuilder() {
      if (aggregationBuilder_ == null) {
        aggregationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>(
                getAggregation(), getParentForChildren(), isClean());
        aggregation_ = null;
      }
      return aggregationBuilder_;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * Unsupported: must be left blank. The points in each time series are
     * currently returned in reverse time order (most recent to oldest).
     * </pre>
     *
     * <code>string order_by = 6;</code>
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unsupported: must be left blank. The points in each time series are
     * currently returned in reverse time order (most recent to oldest).
     * </pre>
     *
     * <code>string order_by = 6;</code>
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unsupported: must be left blank. The points in each time series are
     * currently returned in reverse time order (most recent to oldest).
     * </pre>
     *
     * <code>string order_by = 6;</code>
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      orderBy_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unsupported: must be left blank. The points in each time series are
     * currently returned in reverse time order (most recent to oldest).
     * </pre>
     *
     * <code>string order_by = 6;</code>
     */
    public Builder clearOrderBy() {

      orderBy_ = getDefaultInstance().getOrderBy();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unsupported: must be left blank. The points in each time series are
     * currently returned in reverse time order (most recent to oldest).
     * </pre>
     *
     * <code>string order_by = 6;</code>
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      orderBy_ = value;
      onChanged();
      return this;
    }

    private int view_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies which information is returned about the time series.
     * </pre>
     *
     * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
     */
    public int getViewValue() {
      return view_;
    }
    /**
     *
     *
     * <pre>
     * Specifies which information is returned about the time series.
     * </pre>
     *
     * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
     */
    public Builder setViewValue(int value) {
      view_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which information is returned about the time series.
     * </pre>
     *
     * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
     */
    public com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView getView() {
      @SuppressWarnings("deprecation")
      com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView result =
          com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView.valueOf(view_);
      return result == null
          ? com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies which information is returned about the time series.
     * </pre>
     *
     * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
     */
    public Builder setView(com.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView value) {
      if (value == null) {
        throw new NullPointerException();
      }

      view_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which information is returned about the time series.
     * </pre>
     *
     * <code>.google.monitoring.v3.ListTimeSeriesRequest.TimeSeriesView view = 7;</code>
     */
    public Builder clearView() {

      view_ = 0;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * A positive number that is the maximum number of results to return. If
     * `page_size` is empty or more than 100,000 results, the effective
     * `page_size` is 100,000 results. If `view` is set to `FULL`, this is the
     * maximum number of `Points` returned. If `view` is set to `HEADERS`, this is
     * the maximum number of `TimeSeries` returned.
     * </pre>
     *
     * <code>int32 page_size = 8;</code>
     */
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * A positive number that is the maximum number of results to return. If
     * `page_size` is empty or more than 100,000 results, the effective
     * `page_size` is 100,000 results. If `view` is set to `FULL`, this is the
     * maximum number of `Points` returned. If `view` is set to `HEADERS`, this is
     * the maximum number of `TimeSeries` returned.
     * </pre>
     *
     * <code>int32 page_size = 8;</code>
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A positive number that is the maximum number of results to return. If
     * `page_size` is empty or more than 100,000 results, the effective
     * `page_size` is 100,000 results. If `view` is set to `FULL`, this is the
     * maximum number of `Points` returned. If `view` is set to `HEADERS`, this is
     * the maximum number of `TimeSeries` returned.
     * </pre>
     *
     * <code>int32 page_size = 8;</code>
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `nextPageToken` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 9;</code>
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `nextPageToken` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 9;</code>
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `nextPageToken` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 9;</code>
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `nextPageToken` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 9;</code>
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `nextPageToken` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 9;</code>
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.ListTimeSeriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.ListTimeSeriesRequest)
  private static final com.google.monitoring.v3.ListTimeSeriesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.ListTimeSeriesRequest();
  }

  public static com.google.monitoring.v3.ListTimeSeriesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTimeSeriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListTimeSeriesRequest>() {
        @java.lang.Override
        public ListTimeSeriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ListTimeSeriesRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ListTimeSeriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTimeSeriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.ListTimeSeriesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
