/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A `Service` is a discrete, autonomous, and network-accessible unit, designed
 * to solve an individual concern
 * ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
 * Stackdriver Monitoring, a `Service` acts as the root resource under which
 * operational aspects of the service are accessible.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.Service}
 */
public final class Service extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service)
    ServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Service.newBuilder() to construct.
  private Service(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Service() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Service();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Service(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 50:
            {
              com.google.monitoring.v3.Service.Custom.Builder subBuilder = null;
              if (identifierCase_ == 6) {
                subBuilder = ((com.google.monitoring.v3.Service.Custom) identifier_).toBuilder();
              }
              identifier_ =
                  input.readMessage(
                      com.google.monitoring.v3.Service.Custom.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.monitoring.v3.Service.Custom) identifier_);
                identifier_ = subBuilder.buildPartial();
              }
              identifierCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.monitoring.v3.Service.AppEngine.Builder subBuilder = null;
              if (identifierCase_ == 7) {
                subBuilder = ((com.google.monitoring.v3.Service.AppEngine) identifier_).toBuilder();
              }
              identifier_ =
                  input.readMessage(
                      com.google.monitoring.v3.Service.AppEngine.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.monitoring.v3.Service.AppEngine) identifier_);
                identifier_ = subBuilder.buildPartial();
              }
              identifierCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.monitoring.v3.Service.CloudEndpoints.Builder subBuilder = null;
              if (identifierCase_ == 8) {
                subBuilder =
                    ((com.google.monitoring.v3.Service.CloudEndpoints) identifier_).toBuilder();
              }
              identifier_ =
                  input.readMessage(
                      com.google.monitoring.v3.Service.CloudEndpoints.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.monitoring.v3.Service.CloudEndpoints) identifier_);
                identifier_ = subBuilder.buildPartial();
              }
              identifierCase_ = 8;
              break;
            }
          case 74:
            {
              com.google.monitoring.v3.Service.ClusterIstio.Builder subBuilder = null;
              if (identifierCase_ == 9) {
                subBuilder =
                    ((com.google.monitoring.v3.Service.ClusterIstio) identifier_).toBuilder();
              }
              identifier_ =
                  input.readMessage(
                      com.google.monitoring.v3.Service.ClusterIstio.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.monitoring.v3.Service.ClusterIstio) identifier_);
                identifier_ = subBuilder.buildPartial();
              }
              identifierCase_ = 9;
              break;
            }
          case 106:
            {
              com.google.monitoring.v3.Service.Telemetry.Builder subBuilder = null;
              if (telemetry_ != null) {
                subBuilder = telemetry_.toBuilder();
              }
              telemetry_ =
                  input.readMessage(
                      com.google.monitoring.v3.Service.Telemetry.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(telemetry_);
                telemetry_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_Service_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_Service_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.Service.class, com.google.monitoring.v3.Service.Builder.class);
  }

  public interface CustomOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.Custom)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Custom view of service telemetry. Currently a place-holder pending final
   * design.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.Custom}
   */
  public static final class Custom extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.Custom)
      CustomOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Custom.newBuilder() to construct.
    private Custom(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Custom() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Custom();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Custom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Custom_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Custom_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.Custom.class,
              com.google.monitoring.v3.Service.Custom.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.Custom)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.Custom other = (com.google.monitoring.v3.Service.Custom) obj;

      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Custom parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.Custom prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Custom view of service telemetry. Currently a place-holder pending final
     * design.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.Custom}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.Custom)
        com.google.monitoring.v3.Service.CustomOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Custom_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Custom_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.Custom.class,
                com.google.monitoring.v3.Service.Custom.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.Custom.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Custom_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Custom getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Custom build() {
        com.google.monitoring.v3.Service.Custom result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Custom buildPartial() {
        com.google.monitoring.v3.Service.Custom result =
            new com.google.monitoring.v3.Service.Custom(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.Custom) {
          return mergeFrom((com.google.monitoring.v3.Service.Custom) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.Custom other) {
        if (other == com.google.monitoring.v3.Service.Custom.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.monitoring.v3.Service.Custom parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.monitoring.v3.Service.Custom) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.Custom)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.Custom)
    private static final com.google.monitoring.v3.Service.Custom DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.Custom();
    }

    public static com.google.monitoring.v3.Service.Custom getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Custom> PARSER =
        new com.google.protobuf.AbstractParser<Custom>() {
          @java.lang.Override
          public Custom parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Custom(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Custom> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Custom> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.Custom getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AppEngineOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.AppEngine)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The moduleId.
     */
    java.lang.String getModuleId();
    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The bytes for moduleId.
     */
    com.google.protobuf.ByteString getModuleIdBytes();
  }
  /**
   *
   *
   * <pre>
   * App Engine service. Learn more at https://cloud.google.com/appengine.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.AppEngine}
   */
  public static final class AppEngine extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.AppEngine)
      AppEngineOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AppEngine.newBuilder() to construct.
    private AppEngine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AppEngine() {
      moduleId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AppEngine();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private AppEngine(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                moduleId_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_AppEngine_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_AppEngine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.AppEngine.class,
              com.google.monitoring.v3.Service.AppEngine.Builder.class);
    }

    public static final int MODULE_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object moduleId_;
    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The moduleId.
     */
    public java.lang.String getModuleId() {
      java.lang.Object ref = moduleId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        moduleId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The bytes for moduleId.
     */
    public com.google.protobuf.ByteString getModuleIdBytes() {
      java.lang.Object ref = moduleId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        moduleId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getModuleIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, moduleId_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getModuleIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, moduleId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.AppEngine)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.AppEngine other =
          (com.google.monitoring.v3.Service.AppEngine) obj;

      if (!getModuleId().equals(other.getModuleId())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODULE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getModuleId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.AppEngine prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * App Engine service. Learn more at https://cloud.google.com/appengine.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.AppEngine}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.AppEngine)
        com.google.monitoring.v3.Service.AppEngineOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_AppEngine_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_AppEngine_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.AppEngine.class,
                com.google.monitoring.v3.Service.AppEngine.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.AppEngine.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        moduleId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_AppEngine_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.AppEngine getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.AppEngine build() {
        com.google.monitoring.v3.Service.AppEngine result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.AppEngine buildPartial() {
        com.google.monitoring.v3.Service.AppEngine result =
            new com.google.monitoring.v3.Service.AppEngine(this);
        result.moduleId_ = moduleId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.AppEngine) {
          return mergeFrom((com.google.monitoring.v3.Service.AppEngine) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.AppEngine other) {
        if (other == com.google.monitoring.v3.Service.AppEngine.getDefaultInstance()) return this;
        if (!other.getModuleId().isEmpty()) {
          moduleId_ = other.moduleId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.monitoring.v3.Service.AppEngine parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.monitoring.v3.Service.AppEngine) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object moduleId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @return The moduleId.
       */
      public java.lang.String getModuleId() {
        java.lang.Object ref = moduleId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          moduleId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @return The bytes for moduleId.
       */
      public com.google.protobuf.ByteString getModuleIdBytes() {
        java.lang.Object ref = moduleId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          moduleId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @param value The moduleId to set.
       * @return This builder for chaining.
       */
      public Builder setModuleId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        moduleId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModuleId() {

        moduleId_ = getDefaultInstance().getModuleId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @param value The bytes for moduleId to set.
       * @return This builder for chaining.
       */
      public Builder setModuleIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        moduleId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.AppEngine)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.AppEngine)
    private static final com.google.monitoring.v3.Service.AppEngine DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.AppEngine();
    }

    public static com.google.monitoring.v3.Service.AppEngine getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AppEngine> PARSER =
        new com.google.protobuf.AbstractParser<AppEngine>() {
          @java.lang.Override
          public AppEngine parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new AppEngine(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<AppEngine> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AppEngine> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.AppEngine getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudEndpointsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.CloudEndpoints)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();
  }
  /**
   *
   *
   * <pre>
   * Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.CloudEndpoints}
   */
  public static final class CloudEndpoints extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.CloudEndpoints)
      CloudEndpointsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudEndpoints.newBuilder() to construct.
    private CloudEndpoints(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudEndpoints() {
      service_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudEndpoints();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CloudEndpoints(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                service_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_CloudEndpoints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_CloudEndpoints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.CloudEndpoints.class,
              com.google.monitoring.v3.Service.CloudEndpoints.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;
    private volatile java.lang.Object service_;
    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getServiceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getServiceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.CloudEndpoints)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.CloudEndpoints other =
          (com.google.monitoring.v3.Service.CloudEndpoints) obj;

      if (!getService().equals(other.getService())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.CloudEndpoints prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.CloudEndpoints}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.CloudEndpoints)
        com.google.monitoring.v3.Service.CloudEndpointsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_CloudEndpoints_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_CloudEndpoints_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.CloudEndpoints.class,
                com.google.monitoring.v3.Service.CloudEndpoints.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.CloudEndpoints.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        service_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_CloudEndpoints_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.CloudEndpoints getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.CloudEndpoints build() {
        com.google.monitoring.v3.Service.CloudEndpoints result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.CloudEndpoints buildPartial() {
        com.google.monitoring.v3.Service.CloudEndpoints result =
            new com.google.monitoring.v3.Service.CloudEndpoints(this);
        result.service_ = service_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.CloudEndpoints) {
          return mergeFrom((com.google.monitoring.v3.Service.CloudEndpoints) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.CloudEndpoints other) {
        if (other == com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance())
          return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.monitoring.v3.Service.CloudEndpoints parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.monitoring.v3.Service.CloudEndpoints) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        service_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {

        service_ = getDefaultInstance().getService();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        service_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.CloudEndpoints)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.CloudEndpoints)
    private static final com.google.monitoring.v3.Service.CloudEndpoints DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.CloudEndpoints();
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudEndpoints> PARSER =
        new com.google.protobuf.AbstractParser<CloudEndpoints>() {
          @java.lang.Override
          public CloudEndpoints parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CloudEndpoints(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CloudEndpoints> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudEndpoints> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.CloudEndpoints getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ClusterIstioOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.ClusterIstio)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The clusterName.
     */
    java.lang.String getClusterName();
    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The bytes for clusterName.
     */
    com.google.protobuf.ByteString getClusterNameBytes();

    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The serviceNamespace.
     */
    java.lang.String getServiceNamespace();
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The bytes for serviceNamespace.
     */
    com.google.protobuf.ByteString getServiceNamespaceBytes();

    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The serviceName.
     */
    java.lang.String getServiceName();
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The bytes for serviceName.
     */
    com.google.protobuf.ByteString getServiceNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Istio service. Learn more at http://istio.io.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.ClusterIstio}
   */
  public static final class ClusterIstio extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.ClusterIstio)
      ClusterIstioOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClusterIstio.newBuilder() to construct.
    private ClusterIstio(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterIstio() {
      location_ = "";
      clusterName_ = "";
      serviceNamespace_ = "";
      serviceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterIstio();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ClusterIstio(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                location_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                clusterName_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                serviceNamespace_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                serviceName_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_ClusterIstio_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_ClusterIstio_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.ClusterIstio.class,
              com.google.monitoring.v3.Service.ClusterIstio.Builder.class);
    }

    public static final int LOCATION_FIELD_NUMBER = 1;
    private volatile java.lang.Object location_;
    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLUSTER_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object clusterName_;
    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAMESPACE_FIELD_NUMBER = 3;
    private volatile java.lang.Object serviceNamespace_;
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The serviceNamespace.
     */
    public java.lang.String getServiceNamespace() {
      java.lang.Object ref = serviceNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceNamespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The bytes for serviceNamespace.
     */
    public com.google.protobuf.ByteString getServiceNamespaceBytes() {
      java.lang.Object ref = serviceNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAME_FIELD_NUMBER = 4;
    private volatile java.lang.Object serviceName_;
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      if (!getClusterNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterName_);
      }
      if (!getServiceNamespaceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serviceNamespace_);
      }
      if (!getServiceNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      if (!getClusterNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterName_);
      }
      if (!getServiceNamespaceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serviceNamespace_);
      }
      if (!getServiceNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.ClusterIstio)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.ClusterIstio other =
          (com.google.monitoring.v3.Service.ClusterIstio) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (!getClusterName().equals(other.getClusterName())) return false;
      if (!getServiceNamespace().equals(other.getServiceNamespace())) return false;
      if (!getServiceName().equals(other.getServiceName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getClusterName().hashCode();
      hash = (37 * hash) + SERVICE_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getServiceNamespace().hashCode();
      hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getServiceName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.ClusterIstio prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Istio service. Learn more at http://istio.io.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.ClusterIstio}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.ClusterIstio)
        com.google.monitoring.v3.Service.ClusterIstioOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_ClusterIstio_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_ClusterIstio_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.ClusterIstio.class,
                com.google.monitoring.v3.Service.ClusterIstio.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.ClusterIstio.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        location_ = "";

        clusterName_ = "";

        serviceNamespace_ = "";

        serviceName_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_ClusterIstio_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.ClusterIstio getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.ClusterIstio build() {
        com.google.monitoring.v3.Service.ClusterIstio result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.ClusterIstio buildPartial() {
        com.google.monitoring.v3.Service.ClusterIstio result =
            new com.google.monitoring.v3.Service.ClusterIstio(this);
        result.location_ = location_;
        result.clusterName_ = clusterName_;
        result.serviceNamespace_ = serviceNamespace_;
        result.serviceName_ = serviceName_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.ClusterIstio) {
          return mergeFrom((com.google.monitoring.v3.Service.ClusterIstio) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.ClusterIstio other) {
        if (other == com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance())
          return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        if (!other.getClusterName().isEmpty()) {
          clusterName_ = other.clusterName_;
          onChanged();
        }
        if (!other.getServiceNamespace().isEmpty()) {
          serviceNamespace_ = other.serviceNamespace_;
          onChanged();
        }
        if (!other.getServiceName().isEmpty()) {
          serviceName_ = other.serviceName_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.monitoring.v3.Service.ClusterIstio parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.monitoring.v3.Service.ClusterIstio) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        location_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {

        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        location_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object clusterName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @return The clusterName.
       */
      public java.lang.String getClusterName() {
        java.lang.Object ref = clusterName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clusterName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @return The bytes for clusterName.
       */
      public com.google.protobuf.ByteString getClusterNameBytes() {
        java.lang.Object ref = clusterName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clusterName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @param value The clusterName to set.
       * @return This builder for chaining.
       */
      public Builder setClusterName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        clusterName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterName() {

        clusterName_ = getDefaultInstance().getClusterName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @param value The bytes for clusterName to set.
       * @return This builder for chaining.
       */
      public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        clusterName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object serviceNamespace_ = "";
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return The serviceNamespace.
       */
      public java.lang.String getServiceNamespace() {
        java.lang.Object ref = serviceNamespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceNamespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return The bytes for serviceNamespace.
       */
      public com.google.protobuf.ByteString getServiceNamespaceBytes() {
        java.lang.Object ref = serviceNamespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceNamespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @param value The serviceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        serviceNamespace_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceNamespace() {

        serviceNamespace_ = getDefaultInstance().getServiceNamespace();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @param value The bytes for serviceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        serviceNamespace_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object serviceName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return The serviceName.
       */
      public java.lang.String getServiceName() {
        java.lang.Object ref = serviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return The bytes for serviceName.
       */
      public com.google.protobuf.ByteString getServiceNameBytes() {
        java.lang.Object ref = serviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @param value The serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        serviceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceName() {

        serviceName_ = getDefaultInstance().getServiceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @param value The bytes for serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        serviceName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.ClusterIstio)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.ClusterIstio)
    private static final com.google.monitoring.v3.Service.ClusterIstio DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.ClusterIstio();
    }

    public static com.google.monitoring.v3.Service.ClusterIstio getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterIstio> PARSER =
        new com.google.protobuf.AbstractParser<ClusterIstio>() {
          @java.lang.Override
          public ClusterIstio parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ClusterIstio(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ClusterIstio> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterIstio> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.ClusterIstio getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TelemetryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.Telemetry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The resourceName.
     */
    java.lang.String getResourceName();
    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The bytes for resourceName.
     */
    com.google.protobuf.ByteString getResourceNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.Telemetry}
   */
  public static final class Telemetry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.Telemetry)
      TelemetryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Telemetry.newBuilder() to construct.
    private Telemetry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Telemetry() {
      resourceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Telemetry();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Telemetry(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                resourceName_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Telemetry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Telemetry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.Telemetry.class,
              com.google.monitoring.v3.Service.Telemetry.Builder.class);
    }

    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object resourceName_;
    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getResourceNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getResourceNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.Telemetry)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.Telemetry other =
          (com.google.monitoring.v3.Service.Telemetry) obj;

      if (!getResourceName().equals(other.getResourceName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getResourceName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.Telemetry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.Telemetry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.Telemetry)
        com.google.monitoring.v3.Service.TelemetryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Telemetry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Telemetry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.Telemetry.class,
                com.google.monitoring.v3.Service.Telemetry.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.Telemetry.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        resourceName_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Telemetry_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Telemetry getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.Telemetry.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Telemetry build() {
        com.google.monitoring.v3.Service.Telemetry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Telemetry buildPartial() {
        com.google.monitoring.v3.Service.Telemetry result =
            new com.google.monitoring.v3.Service.Telemetry(this);
        result.resourceName_ = resourceName_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.Telemetry) {
          return mergeFrom((com.google.monitoring.v3.Service.Telemetry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.Telemetry other) {
        if (other == com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()) return this;
        if (!other.getResourceName().isEmpty()) {
          resourceName_ = other.resourceName_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.monitoring.v3.Service.Telemetry parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.monitoring.v3.Service.Telemetry) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object resourceName_ = "";
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @return The resourceName.
       */
      public java.lang.String getResourceName() {
        java.lang.Object ref = resourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @return The bytes for resourceName.
       */
      public com.google.protobuf.ByteString getResourceNameBytes() {
        java.lang.Object ref = resourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @param value The resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        resourceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceName() {

        resourceName_ = getDefaultInstance().getResourceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @param value The bytes for resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        resourceName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.Telemetry)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.Telemetry)
    private static final com.google.monitoring.v3.Service.Telemetry DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.Telemetry();
    }

    public static com.google.monitoring.v3.Service.Telemetry getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Telemetry> PARSER =
        new com.google.protobuf.AbstractParser<Telemetry>() {
          @java.lang.Override
          public Telemetry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Telemetry(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Telemetry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Telemetry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.Telemetry getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int identifierCase_ = 0;
  private java.lang.Object identifier_;

  public enum IdentifierCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CUSTOM(6),
    APP_ENGINE(7),
    CLOUD_ENDPOINTS(8),
    CLUSTER_ISTIO(9),
    IDENTIFIER_NOT_SET(0);
    private final int value;

    private IdentifierCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IdentifierCase valueOf(int value) {
      return forNumber(value);
    }

    public static IdentifierCase forNumber(int value) {
      switch (value) {
        case 6:
          return CUSTOM;
        case 7:
          return APP_ENGINE;
        case 8:
          return CLOUD_ENDPOINTS;
        case 9:
          return CLUSTER_ISTIO;
        case 0:
          return IDENTIFIER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IdentifierCase getIdentifierCase() {
    return IdentifierCase.forNumber(identifierCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Resource name for this Service. Of the form
   * `projects/{project_id}/services/{service_id}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name for this Service. Of the form
   * `projects/{project_id}/services/{service_id}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Name used for UI elements listing this Service.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name used for UI elements listing this Service.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Custom service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
   *
   * @return Whether the custom field is set.
   */
  public boolean hasCustom() {
    return identifierCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Custom service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
   *
   * @return The custom.
   */
  public com.google.monitoring.v3.Service.Custom getCustom() {
    if (identifierCase_ == 6) {
      return (com.google.monitoring.v3.Service.Custom) identifier_;
    }
    return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Custom service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
   */
  public com.google.monitoring.v3.Service.CustomOrBuilder getCustomOrBuilder() {
    if (identifierCase_ == 6) {
      return (com.google.monitoring.v3.Service.Custom) identifier_;
    }
    return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
  }

  public static final int APP_ENGINE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Type used for App Engine services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
   *
   * @return Whether the appEngine field is set.
   */
  public boolean hasAppEngine() {
    return identifierCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Type used for App Engine services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
   *
   * @return The appEngine.
   */
  public com.google.monitoring.v3.Service.AppEngine getAppEngine() {
    if (identifierCase_ == 7) {
      return (com.google.monitoring.v3.Service.AppEngine) identifier_;
    }
    return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for App Engine services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
   */
  public com.google.monitoring.v3.Service.AppEngineOrBuilder getAppEngineOrBuilder() {
    if (identifierCase_ == 7) {
      return (com.google.monitoring.v3.Service.AppEngine) identifier_;
    }
    return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
  }

  public static final int CLOUD_ENDPOINTS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Type used for Cloud Endpoints services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
   *
   * @return Whether the cloudEndpoints field is set.
   */
  public boolean hasCloudEndpoints() {
    return identifierCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Type used for Cloud Endpoints services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
   *
   * @return The cloudEndpoints.
   */
  public com.google.monitoring.v3.Service.CloudEndpoints getCloudEndpoints() {
    if (identifierCase_ == 8) {
      return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
    }
    return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for Cloud Endpoints services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
   */
  public com.google.monitoring.v3.Service.CloudEndpointsOrBuilder getCloudEndpointsOrBuilder() {
    if (identifierCase_ == 8) {
      return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
    }
    return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
  }

  public static final int CLUSTER_ISTIO_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Type used for Istio services that live in a Kubernetes cluster.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
   *
   * @return Whether the clusterIstio field is set.
   */
  public boolean hasClusterIstio() {
    return identifierCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Type used for Istio services that live in a Kubernetes cluster.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
   *
   * @return The clusterIstio.
   */
  public com.google.monitoring.v3.Service.ClusterIstio getClusterIstio() {
    if (identifierCase_ == 9) {
      return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
    }
    return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for Istio services that live in a Kubernetes cluster.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
   */
  public com.google.monitoring.v3.Service.ClusterIstioOrBuilder getClusterIstioOrBuilder() {
    if (identifierCase_ == 9) {
      return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
    }
    return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
  }

  public static final int TELEMETRY_FIELD_NUMBER = 13;
  private com.google.monitoring.v3.Service.Telemetry telemetry_;
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
   *
   * @return Whether the telemetry field is set.
   */
  public boolean hasTelemetry() {
    return telemetry_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
   *
   * @return The telemetry.
   */
  public com.google.monitoring.v3.Service.Telemetry getTelemetry() {
    return telemetry_ == null
        ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
        : telemetry_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
   */
  public com.google.monitoring.v3.Service.TelemetryOrBuilder getTelemetryOrBuilder() {
    return getTelemetry();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (identifierCase_ == 6) {
      output.writeMessage(6, (com.google.monitoring.v3.Service.Custom) identifier_);
    }
    if (identifierCase_ == 7) {
      output.writeMessage(7, (com.google.monitoring.v3.Service.AppEngine) identifier_);
    }
    if (identifierCase_ == 8) {
      output.writeMessage(8, (com.google.monitoring.v3.Service.CloudEndpoints) identifier_);
    }
    if (identifierCase_ == 9) {
      output.writeMessage(9, (com.google.monitoring.v3.Service.ClusterIstio) identifier_);
    }
    if (telemetry_ != null) {
      output.writeMessage(13, getTelemetry());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (identifierCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.monitoring.v3.Service.Custom) identifier_);
    }
    if (identifierCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.monitoring.v3.Service.AppEngine) identifier_);
    }
    if (identifierCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.monitoring.v3.Service.CloudEndpoints) identifier_);
    }
    if (identifierCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.monitoring.v3.Service.ClusterIstio) identifier_);
    }
    if (telemetry_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getTelemetry());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.Service)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.Service other = (com.google.monitoring.v3.Service) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasTelemetry() != other.hasTelemetry()) return false;
    if (hasTelemetry()) {
      if (!getTelemetry().equals(other.getTelemetry())) return false;
    }
    if (!getIdentifierCase().equals(other.getIdentifierCase())) return false;
    switch (identifierCase_) {
      case 6:
        if (!getCustom().equals(other.getCustom())) return false;
        break;
      case 7:
        if (!getAppEngine().equals(other.getAppEngine())) return false;
        break;
      case 8:
        if (!getCloudEndpoints().equals(other.getCloudEndpoints())) return false;
        break;
      case 9:
        if (!getClusterIstio().equals(other.getClusterIstio())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasTelemetry()) {
      hash = (37 * hash) + TELEMETRY_FIELD_NUMBER;
      hash = (53 * hash) + getTelemetry().hashCode();
    }
    switch (identifierCase_) {
      case 6:
        hash = (37 * hash) + CUSTOM_FIELD_NUMBER;
        hash = (53 * hash) + getCustom().hashCode();
        break;
      case 7:
        hash = (37 * hash) + APP_ENGINE_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngine().hashCode();
        break;
      case 8:
        hash = (37 * hash) + CLOUD_ENDPOINTS_FIELD_NUMBER;
        hash = (53 * hash) + getCloudEndpoints().hashCode();
        break;
      case 9:
        hash = (37 * hash) + CLUSTER_ISTIO_FIELD_NUMBER;
        hash = (53 * hash) + getClusterIstio().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.Service parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Service parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.Service prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `Service` is a discrete, autonomous, and network-accessible unit, designed
   * to solve an individual concern
   * ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
   * Stackdriver Monitoring, a `Service` acts as the root resource under which
   * operational aspects of the service are accessible.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service)
      com.google.monitoring.v3.ServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.class,
              com.google.monitoring.v3.Service.Builder.class);
    }

    // Construct using com.google.monitoring.v3.Service.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (telemetryBuilder_ == null) {
        telemetry_ = null;
      } else {
        telemetry_ = null;
        telemetryBuilder_ = null;
      }
      identifierCase_ = 0;
      identifier_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service getDefaultInstanceForType() {
      return com.google.monitoring.v3.Service.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service build() {
      com.google.monitoring.v3.Service result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service buildPartial() {
      com.google.monitoring.v3.Service result = new com.google.monitoring.v3.Service(this);
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (identifierCase_ == 6) {
        if (customBuilder_ == null) {
          result.identifier_ = identifier_;
        } else {
          result.identifier_ = customBuilder_.build();
        }
      }
      if (identifierCase_ == 7) {
        if (appEngineBuilder_ == null) {
          result.identifier_ = identifier_;
        } else {
          result.identifier_ = appEngineBuilder_.build();
        }
      }
      if (identifierCase_ == 8) {
        if (cloudEndpointsBuilder_ == null) {
          result.identifier_ = identifier_;
        } else {
          result.identifier_ = cloudEndpointsBuilder_.build();
        }
      }
      if (identifierCase_ == 9) {
        if (clusterIstioBuilder_ == null) {
          result.identifier_ = identifier_;
        } else {
          result.identifier_ = clusterIstioBuilder_.build();
        }
      }
      if (telemetryBuilder_ == null) {
        result.telemetry_ = telemetry_;
      } else {
        result.telemetry_ = telemetryBuilder_.build();
      }
      result.identifierCase_ = identifierCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.Service) {
        return mergeFrom((com.google.monitoring.v3.Service) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.Service other) {
      if (other == com.google.monitoring.v3.Service.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasTelemetry()) {
        mergeTelemetry(other.getTelemetry());
      }
      switch (other.getIdentifierCase()) {
        case CUSTOM:
          {
            mergeCustom(other.getCustom());
            break;
          }
        case APP_ENGINE:
          {
            mergeAppEngine(other.getAppEngine());
            break;
          }
        case CLOUD_ENDPOINTS:
          {
            mergeCloudEndpoints(other.getCloudEndpoints());
            break;
          }
        case CLUSTER_ISTIO:
          {
            mergeClusterIstio(other.getClusterIstio());
            break;
          }
        case IDENTIFIER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.Service parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.monitoring.v3.Service) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int identifierCase_ = 0;
    private java.lang.Object identifier_;

    public IdentifierCase getIdentifierCase() {
      return IdentifierCase.forNumber(identifierCase_);
    }

    public Builder clearIdentifier() {
      identifierCase_ = 0;
      identifier_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name for this Service. Of the form
     * `projects/{project_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. Of the form
     * `projects/{project_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. Of the form
     * `projects/{project_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. Of the form
     * `projects/{project_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. Of the form
     * `projects/{project_id}/services/{service_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Custom,
            com.google.monitoring.v3.Service.Custom.Builder,
            com.google.monitoring.v3.Service.CustomOrBuilder>
        customBuilder_;
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     *
     * @return Whether the custom field is set.
     */
    public boolean hasCustom() {
      return identifierCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     *
     * @return The custom.
     */
    public com.google.monitoring.v3.Service.Custom getCustom() {
      if (customBuilder_ == null) {
        if (identifierCase_ == 6) {
          return (com.google.monitoring.v3.Service.Custom) identifier_;
        }
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      } else {
        if (identifierCase_ == 6) {
          return customBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder setCustom(com.google.monitoring.v3.Service.Custom value) {
      if (customBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        customBuilder_.setMessage(value);
      }
      identifierCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder setCustom(com.google.monitoring.v3.Service.Custom.Builder builderForValue) {
      if (customBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        customBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder mergeCustom(com.google.monitoring.v3.Service.Custom value) {
      if (customBuilder_ == null) {
        if (identifierCase_ == 6
            && identifier_ != com.google.monitoring.v3.Service.Custom.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.Custom.newBuilder(
                      (com.google.monitoring.v3.Service.Custom) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 6) {
          customBuilder_.mergeFrom(value);
        }
        customBuilder_.setMessage(value);
      }
      identifierCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder clearCustom() {
      if (customBuilder_ == null) {
        if (identifierCase_ == 6) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 6) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        customBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public com.google.monitoring.v3.Service.Custom.Builder getCustomBuilder() {
      return getCustomFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public com.google.monitoring.v3.Service.CustomOrBuilder getCustomOrBuilder() {
      if ((identifierCase_ == 6) && (customBuilder_ != null)) {
        return customBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 6) {
          return (com.google.monitoring.v3.Service.Custom) identifier_;
        }
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Custom,
            com.google.monitoring.v3.Service.Custom.Builder,
            com.google.monitoring.v3.Service.CustomOrBuilder>
        getCustomFieldBuilder() {
      if (customBuilder_ == null) {
        if (!(identifierCase_ == 6)) {
          identifier_ = com.google.monitoring.v3.Service.Custom.getDefaultInstance();
        }
        customBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.Custom,
                com.google.monitoring.v3.Service.Custom.Builder,
                com.google.monitoring.v3.Service.CustomOrBuilder>(
                (com.google.monitoring.v3.Service.Custom) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 6;
      onChanged();
      ;
      return customBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.AppEngine,
            com.google.monitoring.v3.Service.AppEngine.Builder,
            com.google.monitoring.v3.Service.AppEngineOrBuilder>
        appEngineBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     *
     * @return Whether the appEngine field is set.
     */
    public boolean hasAppEngine() {
      return identifierCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     *
     * @return The appEngine.
     */
    public com.google.monitoring.v3.Service.AppEngine getAppEngine() {
      if (appEngineBuilder_ == null) {
        if (identifierCase_ == 7) {
          return (com.google.monitoring.v3.Service.AppEngine) identifier_;
        }
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      } else {
        if (identifierCase_ == 7) {
          return appEngineBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder setAppEngine(com.google.monitoring.v3.Service.AppEngine value) {
      if (appEngineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        appEngineBuilder_.setMessage(value);
      }
      identifierCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder setAppEngine(
        com.google.monitoring.v3.Service.AppEngine.Builder builderForValue) {
      if (appEngineBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        appEngineBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder mergeAppEngine(com.google.monitoring.v3.Service.AppEngine value) {
      if (appEngineBuilder_ == null) {
        if (identifierCase_ == 7
            && identifier_ != com.google.monitoring.v3.Service.AppEngine.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.AppEngine.newBuilder(
                      (com.google.monitoring.v3.Service.AppEngine) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 7) {
          appEngineBuilder_.mergeFrom(value);
        }
        appEngineBuilder_.setMessage(value);
      }
      identifierCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder clearAppEngine() {
      if (appEngineBuilder_ == null) {
        if (identifierCase_ == 7) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 7) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        appEngineBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public com.google.monitoring.v3.Service.AppEngine.Builder getAppEngineBuilder() {
      return getAppEngineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public com.google.monitoring.v3.Service.AppEngineOrBuilder getAppEngineOrBuilder() {
      if ((identifierCase_ == 7) && (appEngineBuilder_ != null)) {
        return appEngineBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 7) {
          return (com.google.monitoring.v3.Service.AppEngine) identifier_;
        }
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.AppEngine,
            com.google.monitoring.v3.Service.AppEngine.Builder,
            com.google.monitoring.v3.Service.AppEngineOrBuilder>
        getAppEngineFieldBuilder() {
      if (appEngineBuilder_ == null) {
        if (!(identifierCase_ == 7)) {
          identifier_ = com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
        }
        appEngineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.AppEngine,
                com.google.monitoring.v3.Service.AppEngine.Builder,
                com.google.monitoring.v3.Service.AppEngineOrBuilder>(
                (com.google.monitoring.v3.Service.AppEngine) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 7;
      onChanged();
      ;
      return appEngineBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.CloudEndpoints,
            com.google.monitoring.v3.Service.CloudEndpoints.Builder,
            com.google.monitoring.v3.Service.CloudEndpointsOrBuilder>
        cloudEndpointsBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     *
     * @return Whether the cloudEndpoints field is set.
     */
    public boolean hasCloudEndpoints() {
      return identifierCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     *
     * @return The cloudEndpoints.
     */
    public com.google.monitoring.v3.Service.CloudEndpoints getCloudEndpoints() {
      if (cloudEndpointsBuilder_ == null) {
        if (identifierCase_ == 8) {
          return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
        }
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      } else {
        if (identifierCase_ == 8) {
          return cloudEndpointsBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder setCloudEndpoints(com.google.monitoring.v3.Service.CloudEndpoints value) {
      if (cloudEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        cloudEndpointsBuilder_.setMessage(value);
      }
      identifierCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder setCloudEndpoints(
        com.google.monitoring.v3.Service.CloudEndpoints.Builder builderForValue) {
      if (cloudEndpointsBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        cloudEndpointsBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder mergeCloudEndpoints(com.google.monitoring.v3.Service.CloudEndpoints value) {
      if (cloudEndpointsBuilder_ == null) {
        if (identifierCase_ == 8
            && identifier_
                != com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.CloudEndpoints.newBuilder(
                      (com.google.monitoring.v3.Service.CloudEndpoints) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 8) {
          cloudEndpointsBuilder_.mergeFrom(value);
        }
        cloudEndpointsBuilder_.setMessage(value);
      }
      identifierCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder clearCloudEndpoints() {
      if (cloudEndpointsBuilder_ == null) {
        if (identifierCase_ == 8) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 8) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        cloudEndpointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public com.google.monitoring.v3.Service.CloudEndpoints.Builder getCloudEndpointsBuilder() {
      return getCloudEndpointsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public com.google.monitoring.v3.Service.CloudEndpointsOrBuilder getCloudEndpointsOrBuilder() {
      if ((identifierCase_ == 8) && (cloudEndpointsBuilder_ != null)) {
        return cloudEndpointsBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 8) {
          return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
        }
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.CloudEndpoints,
            com.google.monitoring.v3.Service.CloudEndpoints.Builder,
            com.google.monitoring.v3.Service.CloudEndpointsOrBuilder>
        getCloudEndpointsFieldBuilder() {
      if (cloudEndpointsBuilder_ == null) {
        if (!(identifierCase_ == 8)) {
          identifier_ = com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
        }
        cloudEndpointsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.CloudEndpoints,
                com.google.monitoring.v3.Service.CloudEndpoints.Builder,
                com.google.monitoring.v3.Service.CloudEndpointsOrBuilder>(
                (com.google.monitoring.v3.Service.CloudEndpoints) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 8;
      onChanged();
      ;
      return cloudEndpointsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.ClusterIstio,
            com.google.monitoring.v3.Service.ClusterIstio.Builder,
            com.google.monitoring.v3.Service.ClusterIstioOrBuilder>
        clusterIstioBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     *
     * @return Whether the clusterIstio field is set.
     */
    public boolean hasClusterIstio() {
      return identifierCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     *
     * @return The clusterIstio.
     */
    public com.google.monitoring.v3.Service.ClusterIstio getClusterIstio() {
      if (clusterIstioBuilder_ == null) {
        if (identifierCase_ == 9) {
          return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
        }
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      } else {
        if (identifierCase_ == 9) {
          return clusterIstioBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder setClusterIstio(com.google.monitoring.v3.Service.ClusterIstio value) {
      if (clusterIstioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        clusterIstioBuilder_.setMessage(value);
      }
      identifierCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder setClusterIstio(
        com.google.monitoring.v3.Service.ClusterIstio.Builder builderForValue) {
      if (clusterIstioBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        clusterIstioBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder mergeClusterIstio(com.google.monitoring.v3.Service.ClusterIstio value) {
      if (clusterIstioBuilder_ == null) {
        if (identifierCase_ == 9
            && identifier_ != com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.ClusterIstio.newBuilder(
                      (com.google.monitoring.v3.Service.ClusterIstio) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 9) {
          clusterIstioBuilder_.mergeFrom(value);
        }
        clusterIstioBuilder_.setMessage(value);
      }
      identifierCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder clearClusterIstio() {
      if (clusterIstioBuilder_ == null) {
        if (identifierCase_ == 9) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 9) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        clusterIstioBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public com.google.monitoring.v3.Service.ClusterIstio.Builder getClusterIstioBuilder() {
      return getClusterIstioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public com.google.monitoring.v3.Service.ClusterIstioOrBuilder getClusterIstioOrBuilder() {
      if ((identifierCase_ == 9) && (clusterIstioBuilder_ != null)) {
        return clusterIstioBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 9) {
          return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
        }
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.ClusterIstio,
            com.google.monitoring.v3.Service.ClusterIstio.Builder,
            com.google.monitoring.v3.Service.ClusterIstioOrBuilder>
        getClusterIstioFieldBuilder() {
      if (clusterIstioBuilder_ == null) {
        if (!(identifierCase_ == 9)) {
          identifier_ = com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
        }
        clusterIstioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.ClusterIstio,
                com.google.monitoring.v3.Service.ClusterIstio.Builder,
                com.google.monitoring.v3.Service.ClusterIstioOrBuilder>(
                (com.google.monitoring.v3.Service.ClusterIstio) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 9;
      onChanged();
      ;
      return clusterIstioBuilder_;
    }

    private com.google.monitoring.v3.Service.Telemetry telemetry_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Telemetry,
            com.google.monitoring.v3.Service.Telemetry.Builder,
            com.google.monitoring.v3.Service.TelemetryOrBuilder>
        telemetryBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     *
     * @return Whether the telemetry field is set.
     */
    public boolean hasTelemetry() {
      return telemetryBuilder_ != null || telemetry_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     *
     * @return The telemetry.
     */
    public com.google.monitoring.v3.Service.Telemetry getTelemetry() {
      if (telemetryBuilder_ == null) {
        return telemetry_ == null
            ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
            : telemetry_;
      } else {
        return telemetryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder setTelemetry(com.google.monitoring.v3.Service.Telemetry value) {
      if (telemetryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        telemetry_ = value;
        onChanged();
      } else {
        telemetryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder setTelemetry(
        com.google.monitoring.v3.Service.Telemetry.Builder builderForValue) {
      if (telemetryBuilder_ == null) {
        telemetry_ = builderForValue.build();
        onChanged();
      } else {
        telemetryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder mergeTelemetry(com.google.monitoring.v3.Service.Telemetry value) {
      if (telemetryBuilder_ == null) {
        if (telemetry_ != null) {
          telemetry_ =
              com.google.monitoring.v3.Service.Telemetry.newBuilder(telemetry_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          telemetry_ = value;
        }
        onChanged();
      } else {
        telemetryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder clearTelemetry() {
      if (telemetryBuilder_ == null) {
        telemetry_ = null;
        onChanged();
      } else {
        telemetry_ = null;
        telemetryBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public com.google.monitoring.v3.Service.Telemetry.Builder getTelemetryBuilder() {

      onChanged();
      return getTelemetryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public com.google.monitoring.v3.Service.TelemetryOrBuilder getTelemetryOrBuilder() {
      if (telemetryBuilder_ != null) {
        return telemetryBuilder_.getMessageOrBuilder();
      } else {
        return telemetry_ == null
            ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
            : telemetry_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Telemetry,
            com.google.monitoring.v3.Service.Telemetry.Builder,
            com.google.monitoring.v3.Service.TelemetryOrBuilder>
        getTelemetryFieldBuilder() {
      if (telemetryBuilder_ == null) {
        telemetryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.Telemetry,
                com.google.monitoring.v3.Service.Telemetry.Builder,
                com.google.monitoring.v3.Service.TelemetryOrBuilder>(
                getTelemetry(), getParentForChildren(), isClean());
        telemetry_ = null;
      }
      return telemetryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service)
  private static final com.google.monitoring.v3.Service DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.Service();
  }

  public static com.google.monitoring.v3.Service getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Service> PARSER =
      new com.google.protobuf.AbstractParser<Service>() {
        @java.lang.Override
        public Service parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Service(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Service> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Service> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.Service getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
