/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServiceLevelObjectiveName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String service;
    private final String serviceLevelObjective;

    public String getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public String getServiceLevelObjective() {
        return this.serviceLevelObjective;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ServiceLevelObjectiveName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.serviceLevelObjective = (String)Preconditions.checkNotNull((Object)builder.getServiceLevelObjective());
    }

    public static ServiceLevelObjectiveName of(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    public static String format(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    public static ServiceLevelObjectiveName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ServiceLevelObjectiveName.parse: formattedString not in valid format");
        return ServiceLevelObjectiveName.of((String)matchMap.get("project"), (String)matchMap.get("service"), (String)matchMap.get("service_level_objective"));
    }

    public static List<ServiceLevelObjectiveName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceLevelObjectiveName> list = new ArrayList<ServiceLevelObjectiveName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceLevelObjectiveName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceLevelObjectiveName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceLevelObjectiveName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceLevelObjectiveName serviceLevelObjectiveName = this;
            synchronized (serviceLevelObjectiveName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"service", (Object)this.service);
                    fieldMapBuilder.put((Object)"serviceLevelObjective", (Object)this.serviceLevelObjective);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "service", this.service, "service_level_objective", this.serviceLevelObjective});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceLevelObjectiveName) {
            ServiceLevelObjectiveName that = (ServiceLevelObjectiveName)o;
            return this.project.equals(that.project) && this.service.equals(that.service) && this.serviceLevelObjective.equals(that.serviceLevelObjective);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.service.hashCode();
        h *= 1000003;
        return h ^= this.serviceLevelObjective.hashCode();
    }

    public static class Builder {
        private String project;
        private String service;
        private String serviceLevelObjective;

        public String getProject() {
            return this.project;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        private Builder() {
        }

        private Builder(ServiceLevelObjectiveName serviceLevelObjectiveName) {
            this.project = serviceLevelObjectiveName.project;
            this.service = serviceLevelObjectiveName.service;
            this.serviceLevelObjective = serviceLevelObjectiveName.serviceLevelObjective;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }
}

