/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceName
implements ResourceName {
    private static final PathTemplate PROJECT_SERVICE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/services/{service}");
    private static final PathTemplate ORGANIZATION_SERVICE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/services/{service}");
    private static final PathTemplate FOLDER_SERVICE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/services/{service}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String service;
    private String organization;
    private String folder;

    @Deprecated
    protected ServiceName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    private ServiceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.pathTemplate = PROJECT_SERVICE_PATH_TEMPLATE;
    }

    private ServiceName(OrganizationServiceBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.pathTemplate = ORGANIZATION_SERVICE_PATH_TEMPLATE;
    }

    private ServiceName(FolderServiceBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.pathTemplate = FOLDER_SERVICE_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectServiceBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationServiceBuilder newOrganizationServiceBuilder() {
        return new OrganizationServiceBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderServiceBuilder newFolderServiceBuilder() {
        return new FolderServiceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceName of(String project, String service) {
        return ServiceName.newProjectServiceBuilder().setProject(project).setService(service).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ServiceName ofProjectServiceName(String project, String service) {
        return ServiceName.newProjectServiceBuilder().setProject(project).setService(service).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ServiceName ofOrganizationServiceName(String organization, String service) {
        return ServiceName.newOrganizationServiceBuilder().setOrganization(organization).setService(service).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ServiceName ofFolderServiceName(String folder, String service) {
        return ServiceName.newFolderServiceBuilder().setFolder(folder).setService(service).build();
    }

    public static String format(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectServiceName(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationServiceName(String organization, String service) {
        return ServiceName.newOrganizationServiceBuilder().setOrganization(organization).setService(service).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderServiceName(String folder, String service) {
        return ServiceName.newFolderServiceBuilder().setFolder(folder).setService(service).build().toString();
    }

    public static ServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SERVICE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_SERVICE_PATH_TEMPLATE.match(formattedString);
            return ServiceName.ofProjectServiceName((String)matchMap.get("project"), (String)matchMap.get("service"));
        }
        if (ORGANIZATION_SERVICE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SERVICE_PATH_TEMPLATE.match(formattedString);
            return ServiceName.ofOrganizationServiceName((String)matchMap.get("organization"), (String)matchMap.get("service"));
        }
        if (FOLDER_SERVICE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_SERVICE_PATH_TEMPLATE.match(formattedString);
            return ServiceName.ofFolderServiceName((String)matchMap.get("folder"), (String)matchMap.get("service"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ServiceName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceName> list = new ArrayList<ServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SERVICE_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_SERVICE_PATH_TEMPLATE.matches(formattedString) || FOLDER_SERVICE_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceName serviceName = this;
            synchronized (serviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ServiceName that = (ServiceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.service, that.service) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderServiceBuilder {
        private String folder;
        private String service;

        private FolderServiceBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getService() {
            return this.service;
        }

        public FolderServiceBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderServiceBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationServiceBuilder {
        private String organization;
        private String service;

        private OrganizationServiceBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getService() {
            return this.service;
        }

        public OrganizationServiceBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationServiceBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }

    public static class Builder {
        private String project;
        private String service;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getService() {
            return this.service;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        private Builder(ServiceName serviceName) {
            Preconditions.checkArgument((serviceName.pathTemplate == PROJECT_SERVICE_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when ServiceName has the pattern of projects/{project}/services/{service}.");
            this.project = serviceName.project;
            this.service = serviceName.service;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }
}

