/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceLevelObjectiveName
implements ResourceName {
    private static final PathTemplate PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private static final PathTemplate ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private static final PathTemplate FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String service;
    private String serviceLevelObjective;
    private String organization;
    private String folder;

    @Deprecated
    protected ServiceLevelObjectiveName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public String getServiceLevelObjective() {
        return this.serviceLevelObjective;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    private ServiceLevelObjectiveName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.serviceLevelObjective = (String)Preconditions.checkNotNull((Object)builder.getServiceLevelObjective());
        this.pathTemplate = PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE;
    }

    private ServiceLevelObjectiveName(OrganizationServiceServiceLevelObjectiveBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.serviceLevelObjective = (String)Preconditions.checkNotNull((Object)builder.getServiceLevelObjective());
        this.pathTemplate = ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE;
    }

    private ServiceLevelObjectiveName(FolderServiceServiceLevelObjectiveBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.serviceLevelObjective = (String)Preconditions.checkNotNull((Object)builder.getServiceLevelObjective());
        this.pathTemplate = FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectServiceServiceLevelObjectiveBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationServiceServiceLevelObjectiveBuilder newOrganizationServiceServiceLevelObjectiveBuilder() {
        return new OrganizationServiceServiceLevelObjectiveBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderServiceServiceLevelObjectiveBuilder newFolderServiceServiceLevelObjectiveBuilder() {
        return new FolderServiceServiceLevelObjectiveBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceLevelObjectiveName of(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newProjectServiceServiceLevelObjectiveBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ServiceLevelObjectiveName ofProjectServiceServiceLevelObjectiveName(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newProjectServiceServiceLevelObjectiveBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ServiceLevelObjectiveName ofOrganizationServiceServiceLevelObjectiveName(String organization, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newOrganizationServiceServiceLevelObjectiveBuilder().setOrganization(organization).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ServiceLevelObjectiveName ofFolderServiceServiceLevelObjectiveName(String folder, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newFolderServiceServiceLevelObjectiveBuilder().setFolder(folder).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    public static String format(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectServiceServiceLevelObjectiveName(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationServiceServiceLevelObjectiveName(String organization, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newOrganizationServiceServiceLevelObjectiveBuilder().setOrganization(organization).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderServiceServiceLevelObjectiveName(String folder, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newFolderServiceServiceLevelObjectiveBuilder().setFolder(folder).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    public static ServiceLevelObjectiveName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.match(formattedString);
            return ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)matchMap.get("project"), (String)matchMap.get("service"), (String)matchMap.get("service_level_objective"));
        }
        if (ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.match(formattedString);
            return ServiceLevelObjectiveName.ofOrganizationServiceServiceLevelObjectiveName((String)matchMap.get("organization"), (String)matchMap.get("service"), (String)matchMap.get("service_level_objective"));
        }
        if (FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.match(formattedString);
            return ServiceLevelObjectiveName.ofFolderServiceServiceLevelObjectiveName((String)matchMap.get("folder"), (String)matchMap.get("service"), (String)matchMap.get("service_level_objective"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ServiceLevelObjectiveName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceLevelObjectiveName> list = new ArrayList<ServiceLevelObjectiveName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceLevelObjectiveName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceLevelObjectiveName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceLevelObjectiveName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.matches(formattedString) || FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceLevelObjectiveName serviceLevelObjectiveName = this;
            synchronized (serviceLevelObjectiveName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.serviceLevelObjective != null) {
                        fieldMapBuilder.put((Object)"service_level_objective", (Object)this.serviceLevelObjective);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ServiceLevelObjectiveName that = (ServiceLevelObjectiveName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.service, that.service) && Objects.equals(this.serviceLevelObjective, that.serviceLevelObjective) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        h ^= Objects.hashCode(this.serviceLevelObjective);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderServiceServiceLevelObjectiveBuilder {
        private String folder;
        private String service;
        private String serviceLevelObjective;

        private FolderServiceServiceLevelObjectiveBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public FolderServiceServiceLevelObjectiveBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderServiceServiceLevelObjectiveBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public FolderServiceServiceLevelObjectiveBuilder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationServiceServiceLevelObjectiveBuilder {
        private String organization;
        private String service;
        private String serviceLevelObjective;

        private OrganizationServiceServiceLevelObjectiveBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public OrganizationServiceServiceLevelObjectiveBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationServiceServiceLevelObjectiveBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public OrganizationServiceServiceLevelObjectiveBuilder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }

    public static class Builder {
        private String project;
        private String service;
        private String serviceLevelObjective;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        private Builder(ServiceLevelObjectiveName serviceLevelObjectiveName) {
            Preconditions.checkArgument((serviceLevelObjectiveName.pathTemplate == PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when ServiceLevelObjectiveName has the pattern of projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}.");
            this.project = serviceLevelObjectiveName.project;
            this.service = serviceLevelObjectiveName.service;
            this.serviceLevelObjective = serviceLevelObjectiveName.serviceLevelObjective;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }
}

