/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/uptime.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * This message configures which resources and services to monitor for
 * availability.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig}
 */
public final class UptimeCheckConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig)
    UptimeCheckConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UptimeCheckConfig.newBuilder() to construct.
  private UptimeCheckConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UptimeCheckConfig() {
    name_ = "";
    displayName_ = "";
    contentMatchers_ = java.util.Collections.emptyList();
    selectedRegions_ = java.util.Collections.emptyList();
    internalCheckers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UptimeCheckConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.UptimeProto
        .internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.UptimeProto
        .internal_static_google_monitoring_v3_UptimeCheckConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.UptimeCheckConfig.class,
            com.google.monitoring.v3.UptimeCheckConfig.Builder.class);
  }

  public interface ResourceGroupOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The groupId.
     */
    java.lang.String getGroupId();
    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The bytes for groupId.
     */
    com.google.protobuf.ByteString getGroupIdBytes();

    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    int getResourceTypeValue();
    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    com.google.monitoring.v3.GroupResourceType getResourceType();
  }
  /**
   *
   *
   * <pre>
   * The resource submessage for group checks. It can be used instead of a
   * monitored resource, when multiple resources are being monitored.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ResourceGroup}
   */
  public static final class ResourceGroup extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
      ResourceGroupOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResourceGroup.newBuilder() to construct.
    private ResourceGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceGroup() {
      groupId_ = "";
      resourceType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceGroup();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.class,
              com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder.class);
    }

    public static final int GROUP_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object groupId_;
    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The groupId.
     */
    @java.lang.Override
    public java.lang.String getGroupId() {
      java.lang.Object ref = groupId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        groupId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The bytes for groupId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupIdBytes() {
      java.lang.Object ref = groupId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        groupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_TYPE_FIELD_NUMBER = 2;
    private int resourceType_;
    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }
    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.monitoring.v3.GroupResourceType getResourceType() {
      @SuppressWarnings("deprecation")
      com.google.monitoring.v3.GroupResourceType result =
          com.google.monitoring.v3.GroupResourceType.valueOf(resourceType_);
      return result == null ? com.google.monitoring.v3.GroupResourceType.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getGroupIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, groupId_);
      }
      if (resourceType_
          != com.google.monitoring.v3.GroupResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, resourceType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getGroupIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, groupId_);
      }
      if (resourceType_
          != com.google.monitoring.v3.GroupResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, resourceType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup other =
          (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) obj;

      if (!getGroupId().equals(other.getGroupId())) return false;
      if (resourceType_ != other.resourceType_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getGroupId().hashCode();
      hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + resourceType_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The resource submessage for group checks. It can be used instead of a
     * monitored resource, when multiple resources are being monitored.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ResourceGroup}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.class,
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        groupId_ = "";

        resourceType_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup build() {
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup result =
            new com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup(this);
        result.groupId_ = groupId_;
        result.resourceType_ = resourceType_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance())
          return this;
        if (!other.getGroupId().isEmpty()) {
          groupId_ = other.groupId_;
          onChanged();
        }
        if (other.resourceType_ != 0) {
          setResourceTypeValue(other.getResourceTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  groupId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 16:
                {
                  resourceType_ = input.readEnum();

                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object groupId_ = "";
      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @return The groupId.
       */
      public java.lang.String getGroupId() {
        java.lang.Object ref = groupId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          groupId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @return The bytes for groupId.
       */
      public com.google.protobuf.ByteString getGroupIdBytes() {
        java.lang.Object ref = groupId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          groupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @param value The groupId to set.
       * @return This builder for chaining.
       */
      public Builder setGroupId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        groupId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroupId() {

        groupId_ = getDefaultInstance().getGroupId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @param value The bytes for groupId to set.
       * @return This builder for chaining.
       */
      public Builder setGroupIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        groupId_ = value;
        onChanged();
        return this;
      }

      private int resourceType_ = 0;
      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @return The enum numeric value on the wire for resourceType.
       */
      @java.lang.Override
      public int getResourceTypeValue() {
        return resourceType_;
      }
      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @param value The enum numeric value on the wire for resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceTypeValue(int value) {

        resourceType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @return The resourceType.
       */
      @java.lang.Override
      public com.google.monitoring.v3.GroupResourceType getResourceType() {
        @SuppressWarnings("deprecation")
        com.google.monitoring.v3.GroupResourceType result =
            com.google.monitoring.v3.GroupResourceType.valueOf(resourceType_);
        return result == null ? com.google.monitoring.v3.GroupResourceType.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @param value The resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceType(com.google.monitoring.v3.GroupResourceType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        resourceType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceType() {

        resourceType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
    private static final com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceGroup> PARSER =
        new com.google.protobuf.AbstractParser<ResourceGroup>() {
          @java.lang.Override
          public ResourceGroup parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceGroup> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HttpCheckOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for requestMethod.
     */
    int getRequestMethodValue();
    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The requestMethod.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod getRequestMethod();

    /**
     *
     *
     * <pre>
     * If `true`, use HTTPS instead of HTTP to run the check.
     * </pre>
     *
     * <code>bool use_ssl = 1;</code>
     *
     * @return The useSsl.
     */
    boolean getUseSsl();

    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @return The port.
     */
    int getPort();

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return Whether the authInfo field is set.
     */
    boolean hasAuthInfo();
    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return The authInfo.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication getAuthInfo();
    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder
        getAuthInfoOrBuilder();

    /**
     *
     *
     * <pre>
     * Boolean specifiying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     * </pre>
     *
     * <code>bool mask_headers = 5;</code>
     *
     * @return The maskHeaders.
     */
    boolean getMaskHeaders();

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    int getHeadersCount();
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    boolean containsHeaders(java.lang.String key);
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getHeaders();
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getHeadersMap();
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    java.lang.String getHeadersOrDefault(java.lang.String key, java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    java.lang.String getHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The content type to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    int getContentTypeValue();
    /**
     *
     *
     * <pre>
     * The content type to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The contentType.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType getContentType();

    /**
     *
     *
     * <pre>
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     * </pre>
     *
     * <code>bool validate_ssl = 7;</code>
     *
     * @return The validateSsl.
     */
    boolean getValidateSsl();

    /**
     *
     *
     * <pre>
     * The request body associated with the HTTP request. If `content_type` is
     * `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide
     * a `Content-Length` header via the `headers` field or the API will do
     * so. The maximum byte size is 1 megabyte. Note: As with all `bytes` fields
     * JSON representations are base64 encoded.
     * </pre>
     *
     * <code>bytes body = 10;</code>
     *
     * @return The body.
     */
    com.google.protobuf.ByteString getBody();
  }
  /**
   *
   *
   * <pre>
   * Information involved in an HTTP/HTTPS Uptime check request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck}
   */
  public static final class HttpCheck extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
      HttpCheckOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HttpCheck.newBuilder() to construct.
    private HttpCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HttpCheck() {
      requestMethod_ = 0;
      path_ = "";
      contentType_ = 0;
      body_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HttpCheck();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.class,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The HTTP request method options.
     * </pre>
     *
     * Protobuf enum {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod}
     */
    public enum RequestMethod implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No request method specified.
       * </pre>
       *
       * <code>METHOD_UNSPECIFIED = 0;</code>
       */
      METHOD_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * GET request.
       * </pre>
       *
       * <code>GET = 1;</code>
       */
      GET(1),
      /**
       *
       *
       * <pre>
       * POST request.
       * </pre>
       *
       * <code>POST = 2;</code>
       */
      POST(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No request method specified.
       * </pre>
       *
       * <code>METHOD_UNSPECIFIED = 0;</code>
       */
      public static final int METHOD_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * GET request.
       * </pre>
       *
       * <code>GET = 1;</code>
       */
      public static final int GET_VALUE = 1;
      /**
       *
       *
       * <pre>
       * POST request.
       * </pre>
       *
       * <code>POST = 2;</code>
       */
      public static final int POST_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RequestMethod valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RequestMethod forNumber(int value) {
        switch (value) {
          case 0:
            return METHOD_UNSPECIFIED;
          case 1:
            return GET;
          case 2:
            return POST;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RequestMethod> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RequestMethod>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<RequestMethod>() {
                public RequestMethod findValueByNumber(int number) {
                  return RequestMethod.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final RequestMethod[] VALUES = values();

      public static RequestMethod valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RequestMethod(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod)
    }

    /**
     *
     *
     * <pre>
     * Header options corresponding to the Content-Type of the body in HTTP
     * requests. Note that a `Content-Type` header cannot be present in the
     * `headers` field if this field is specified.
     * </pre>
     *
     * Protobuf enum {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType}
     */
    public enum ContentType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No content type specified. If the request method is POST, an
       * unspecified content type results in a check creation rejection.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * `body` is in URL-encoded form. Equivalent to setting the `Content-Type`
       * to `application/x-www-form-urlencoded` in the HTTP request.
       * </pre>
       *
       * <code>URL_ENCODED = 1;</code>
       */
      URL_ENCODED(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No content type specified. If the request method is POST, an
       * unspecified content type results in a check creation rejection.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * `body` is in URL-encoded form. Equivalent to setting the `Content-Type`
       * to `application/x-www-form-urlencoded` in the HTTP request.
       * </pre>
       *
       * <code>URL_ENCODED = 1;</code>
       */
      public static final int URL_ENCODED_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ContentType forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return URL_ENCODED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ContentType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ContentType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ContentType>() {
            public ContentType findValueByNumber(int number) {
              return ContentType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final ContentType[] VALUES = values();

      public static ContentType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ContentType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType)
    }

    public interface BasicAuthenticationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The username.
       */
      java.lang.String getUsername();
      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The bytes for username.
       */
      com.google.protobuf.ByteString getUsernameBytes();

      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The password.
       */
      java.lang.String getPassword();
      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The bytes for password.
       */
      com.google.protobuf.ByteString getPasswordBytes();
    }
    /**
     *
     *
     * <pre>
     * The authentication parameters to provide to the specified resource or
     * URL that requires a username and password. Currently, only
     * [Basic HTTP authentication](https://tools.ietf.org/html/rfc7617) is
     * supported in Uptime checks.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication}
     */
    public static final class BasicAuthentication extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
        BasicAuthenticationOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BasicAuthentication.newBuilder() to construct.
      private BasicAuthentication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BasicAuthentication() {
        username_ = "";
        password_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BasicAuthentication();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.class,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
                    .class);
      }

      public static final int USERNAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object username_;
      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The username.
       */
      @java.lang.Override
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The bytes for username.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PASSWORD_FIELD_NUMBER = 2;
      private volatile java.lang.Object password_;
      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The password.
       */
      @java.lang.Override
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The bytes for password.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getUsernameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, username_);
        }
        if (!getPasswordBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getUsernameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, username_);
        }
        if (!getPasswordBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication other =
            (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication) obj;

        if (!getUsername().equals(other.getUsername())) return false;
        if (!getPassword().equals(other.getPassword())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + USERNAME_FIELD_NUMBER;
        hash = (53 * hash) + getUsername().hashCode();
        hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
        hash = (53 * hash) + getPassword().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The authentication parameters to provide to the specified resource or
       * URL that requires a username and password. Currently, only
       * [Basic HTTP authentication](https://tools.ietf.org/html/rfc7617) is
       * supported in Uptime checks.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.class,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
                      .class);
        }

        // Construct using
        // com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          username_ = "";

          password_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication build() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
            buildPartial() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication result =
              new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication(this);
          result.username_ = username_;
          result.password_ = password_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication) {
            return mergeFrom(
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication other) {
          if (other
              == com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                  .getDefaultInstance()) return this;
          if (!other.getUsername().isEmpty()) {
            username_ = other.username_;
            onChanged();
          }
          if (!other.getPassword().isEmpty()) {
            password_ = other.password_;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    username_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 18:
                  {
                    password_ = input.readStringRequireUtf8();

                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object username_ = "";
        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @return The username.
         */
        public java.lang.String getUsername() {
          java.lang.Object ref = username_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            username_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @return The bytes for username.
         */
        public com.google.protobuf.ByteString getUsernameBytes() {
          java.lang.Object ref = username_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            username_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @param value The username to set.
         * @return This builder for chaining.
         */
        public Builder setUsername(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          username_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUsername() {

          username_ = getDefaultInstance().getUsername();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @param value The bytes for username to set.
         * @return This builder for chaining.
         */
        public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          username_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object password_ = "";
        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @return The password.
         */
        public java.lang.String getPassword() {
          java.lang.Object ref = password_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            password_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @return The bytes for password.
         */
        public com.google.protobuf.ByteString getPasswordBytes() {
          java.lang.Object ref = password_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            password_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @param value The password to set.
         * @return This builder for chaining.
         */
        public Builder setPassword(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          password_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPassword() {

          password_ = getDefaultInstance().getPassword();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @param value The bytes for password to set.
         * @return This builder for chaining.
         */
        public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          password_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
      private static final com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication();
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BasicAuthentication> PARSER =
          new com.google.protobuf.AbstractParser<BasicAuthentication>() {
            @java.lang.Override
            public BasicAuthentication parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BasicAuthentication> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BasicAuthentication> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int REQUEST_METHOD_FIELD_NUMBER = 8;
    private int requestMethod_;
    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for requestMethod.
     */
    @java.lang.Override
    public int getRequestMethodValue() {
      return requestMethod_;
    }
    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The requestMethod.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod getRequestMethod() {
      @SuppressWarnings("deprecation")
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod result =
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.valueOf(
              requestMethod_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.UNRECOGNIZED
          : result;
    }

    public static final int USE_SSL_FIELD_NUMBER = 1;
    private boolean useSsl_;
    /**
     *
     *
     * <pre>
     * If `true`, use HTTPS instead of HTTP to run the check.
     * </pre>
     *
     * <code>bool use_ssl = 1;</code>
     *
     * @return The useSsl.
     */
    @java.lang.Override
    public boolean getUseSsl() {
      return useSsl_;
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 3;
    private int port_;
    /**
     *
     *
     * <pre>
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int AUTH_INFO_FIELD_NUMBER = 4;
    private com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication authInfo_;
    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return Whether the authInfo field is set.
     */
    @java.lang.Override
    public boolean hasAuthInfo() {
      return authInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return The authInfo.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication getAuthInfo() {
      return authInfo_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
              .getDefaultInstance()
          : authInfo_;
    }
    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder
        getAuthInfoOrBuilder() {
      return getAuthInfo();
    }

    public static final int MASK_HEADERS_FIELD_NUMBER = 5;
    private boolean maskHeaders_;
    /**
     *
     *
     * <pre>
     * Boolean specifiying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     * </pre>
     *
     * <code>bool mask_headers = 5;</code>
     *
     * @return The maskHeaders.
     */
    @java.lang.Override
    public boolean getMaskHeaders() {
      return maskHeaders_;
    }

    public static final int HEADERS_FIELD_NUMBER = 6;

    private static final class HeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.monitoring.v3.UptimeProto
                  .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_HeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int CONTENT_TYPE_FIELD_NUMBER = 9;
    private int contentType_;
    /**
     *
     *
     * <pre>
     * The content type to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    @java.lang.Override
    public int getContentTypeValue() {
      return contentType_;
    }
    /**
     *
     *
     * <pre>
     * The content type to use for the check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The contentType.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType getContentType() {
      @SuppressWarnings("deprecation")
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType result =
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.valueOf(contentType_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.UNRECOGNIZED
          : result;
    }

    public static final int VALIDATE_SSL_FIELD_NUMBER = 7;
    private boolean validateSsl_;
    /**
     *
     *
     * <pre>
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     * </pre>
     *
     * <code>bool validate_ssl = 7;</code>
     *
     * @return The validateSsl.
     */
    @java.lang.Override
    public boolean getValidateSsl() {
      return validateSsl_;
    }

    public static final int BODY_FIELD_NUMBER = 10;
    private com.google.protobuf.ByteString body_;
    /**
     *
     *
     * <pre>
     * The request body associated with the HTTP request. If `content_type` is
     * `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide
     * a `Content-Length` header via the `headers` field or the API will do
     * so. The maximum byte size is 1 megabyte. Note: As with all `bytes` fields
     * JSON representations are base64 encoded.
     * </pre>
     *
     * <code>bytes body = 10;</code>
     *
     * @return The body.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBody() {
      return body_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (useSsl_ != false) {
        output.writeBool(1, useSsl_);
      }
      if (!getPathBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (port_ != 0) {
        output.writeInt32(3, port_);
      }
      if (authInfo_ != null) {
        output.writeMessage(4, getAuthInfo());
      }
      if (maskHeaders_ != false) {
        output.writeBool(5, maskHeaders_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 6);
      if (validateSsl_ != false) {
        output.writeBool(7, validateSsl_);
      }
      if (requestMethod_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.METHOD_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(8, requestMethod_);
      }
      if (contentType_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(9, contentType_);
      }
      if (!body_.isEmpty()) {
        output.writeBytes(10, body_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (useSsl_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useSsl_);
      }
      if (!getPathBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, port_);
      }
      if (authInfo_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAuthInfo());
      }
      if (maskHeaders_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, maskHeaders_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
            HeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, headers__);
      }
      if (validateSsl_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, validateSsl_);
      }
      if (requestMethod_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.METHOD_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, requestMethod_);
      }
      if (contentType_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, contentType_);
      }
      if (!body_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(10, body_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck other =
          (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) obj;

      if (requestMethod_ != other.requestMethod_) return false;
      if (getUseSsl() != other.getUseSsl()) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (getPort() != other.getPort()) return false;
      if (hasAuthInfo() != other.hasAuthInfo()) return false;
      if (hasAuthInfo()) {
        if (!getAuthInfo().equals(other.getAuthInfo())) return false;
      }
      if (getMaskHeaders() != other.getMaskHeaders()) return false;
      if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
      if (contentType_ != other.contentType_) return false;
      if (getValidateSsl() != other.getValidateSsl()) return false;
      if (!getBody().equals(other.getBody())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REQUEST_METHOD_FIELD_NUMBER;
      hash = (53 * hash) + requestMethod_;
      hash = (37 * hash) + USE_SSL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseSsl());
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      if (hasAuthInfo()) {
        hash = (37 * hash) + AUTH_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getAuthInfo().hashCode();
      }
      hash = (37 * hash) + MASK_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMaskHeaders());
      if (!internalGetHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetHeaders().hashCode();
      }
      hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + contentType_;
      hash = (37 * hash) + VALIDATE_SSL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateSsl());
      hash = (37 * hash) + BODY_FIELD_NUMBER;
      hash = (53 * hash) + getBody().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information involved in an HTTP/HTTPS Uptime check request.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 6:
            return internalGetHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 6:
            return internalGetMutableHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.class,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        requestMethod_ = 0;

        useSsl_ = false;

        path_ = "";

        port_ = 0;

        if (authInfoBuilder_ == null) {
          authInfo_ = null;
        } else {
          authInfo_ = null;
          authInfoBuilder_ = null;
        }
        maskHeaders_ = false;

        internalGetMutableHeaders().clear();
        contentType_ = 0;

        validateSsl_ = false;

        body_ = com.google.protobuf.ByteString.EMPTY;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck build() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result =
            new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck(this);
        int from_bitField0_ = bitField0_;
        result.requestMethod_ = requestMethod_;
        result.useSsl_ = useSsl_;
        result.path_ = path_;
        result.port_ = port_;
        if (authInfoBuilder_ == null) {
          result.authInfo_ = authInfo_;
        } else {
          result.authInfo_ = authInfoBuilder_.build();
        }
        result.maskHeaders_ = maskHeaders_;
        result.headers_ = internalGetHeaders();
        result.headers_.makeImmutable();
        result.contentType_ = contentType_;
        result.validateSsl_ = validateSsl_;
        result.body_ = body_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance())
          return this;
        if (other.requestMethod_ != 0) {
          setRequestMethodValue(other.getRequestMethodValue());
        }
        if (other.getUseSsl() != false) {
          setUseSsl(other.getUseSsl());
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        if (other.hasAuthInfo()) {
          mergeAuthInfo(other.getAuthInfo());
        }
        if (other.getMaskHeaders() != false) {
          setMaskHeaders(other.getMaskHeaders());
        }
        internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
        if (other.contentType_ != 0) {
          setContentTypeValue(other.getContentTypeValue());
        }
        if (other.getValidateSsl() != false) {
          setValidateSsl(other.getValidateSsl());
        }
        if (other.getBody() != com.google.protobuf.ByteString.EMPTY) {
          setBody(other.getBody());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  useSsl_ = input.readBool();

                  break;
                } // case 8
              case 18:
                {
                  path_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 24:
                {
                  port_ = input.readInt32();

                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getAuthInfoFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 40:
                {
                  maskHeaders_ = input.readBool();

                  break;
                } // case 40
              case 50:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                      input.readMessage(
                          HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableHeaders()
                      .getMutableMap()
                      .put(headers__.getKey(), headers__.getValue());
                  break;
                } // case 50
              case 56:
                {
                  validateSsl_ = input.readBool();

                  break;
                } // case 56
              case 64:
                {
                  requestMethod_ = input.readEnum();

                  break;
                } // case 64
              case 72:
                {
                  contentType_ = input.readEnum();

                  break;
                } // case 72
              case 82:
                {
                  body_ = input.readBytes();

                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int requestMethod_ = 0;
      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @return The enum numeric value on the wire for requestMethod.
       */
      @java.lang.Override
      public int getRequestMethodValue() {
        return requestMethod_;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @param value The enum numeric value on the wire for requestMethod to set.
       * @return This builder for chaining.
       */
      public Builder setRequestMethodValue(int value) {

        requestMethod_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @return The requestMethod.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod getRequestMethod() {
        @SuppressWarnings("deprecation")
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod result =
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.valueOf(
                requestMethod_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @param value The requestMethod to set.
       * @return This builder for chaining.
       */
      public Builder setRequestMethod(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod value) {
        if (value == null) {
          throw new NullPointerException();
        }

        requestMethod_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestMethod() {

        requestMethod_ = 0;
        onChanged();
        return this;
      }

      private boolean useSsl_;
      /**
       *
       *
       * <pre>
       * If `true`, use HTTPS instead of HTTP to run the check.
       * </pre>
       *
       * <code>bool use_ssl = 1;</code>
       *
       * @return The useSsl.
       */
      @java.lang.Override
      public boolean getUseSsl() {
        return useSsl_;
      }
      /**
       *
       *
       * <pre>
       * If `true`, use HTTPS instead of HTTP to run the check.
       * </pre>
       *
       * <code>bool use_ssl = 1;</code>
       *
       * @param value The useSsl to set.
       * @return This builder for chaining.
       */
      public Builder setUseSsl(boolean value) {

        useSsl_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `true`, use HTTPS instead of HTTP to run the check.
       * </pre>
       *
       * <code>bool use_ssl = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseSsl() {

        useSsl_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      private int port_;
      /**
       *
       *
       * <pre>
       * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
       * `use_ssl` is `true`). The TCP port on the HTTP server against which to
       * run the check. Will be combined with host (specified within the
       * `monitored_resource`) and `path` to construct the full URL.
       * </pre>
       *
       * <code>int32 port = 3;</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }
      /**
       *
       *
       * <pre>
       * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
       * `use_ssl` is `true`). The TCP port on the HTTP server against which to
       * run the check. Will be combined with host (specified within the
       * `monitored_resource`) and `path` to construct the full URL.
       * </pre>
       *
       * <code>int32 port = 3;</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
       * `use_ssl` is `true`). The TCP port on the HTTP server against which to
       * run the check. Will be combined with host (specified within the
       * `monitored_resource`) and `path` to construct the full URL.
       * </pre>
       *
       * <code>int32 port = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {

        port_ = 0;
        onChanged();
        return this;
      }

      private com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication authInfo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder>
          authInfoBuilder_;
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       *
       * @return Whether the authInfo field is set.
       */
      public boolean hasAuthInfo() {
        return authInfoBuilder_ != null || authInfo_ != null;
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       *
       * @return The authInfo.
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          getAuthInfo() {
        if (authInfoBuilder_ == null) {
          return authInfo_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                  .getDefaultInstance()
              : authInfo_;
        } else {
          return authInfoBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder setAuthInfo(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication value) {
        if (authInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authInfo_ = value;
          onChanged();
        } else {
          authInfoBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder setAuthInfo(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
              builderForValue) {
        if (authInfoBuilder_ == null) {
          authInfo_ = builderForValue.build();
          onChanged();
        } else {
          authInfoBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder mergeAuthInfo(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication value) {
        if (authInfoBuilder_ == null) {
          if (authInfo_ != null) {
            authInfo_ =
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.newBuilder(
                        authInfo_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authInfo_ = value;
          }
          onChanged();
        } else {
          authInfoBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder clearAuthInfo() {
        if (authInfoBuilder_ == null) {
          authInfo_ = null;
          onChanged();
        } else {
          authInfo_ = null;
          authInfoBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
          getAuthInfoBuilder() {

        onChanged();
        return getAuthInfoFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder
          getAuthInfoOrBuilder() {
        if (authInfoBuilder_ != null) {
          return authInfoBuilder_.getMessageOrBuilder();
        } else {
          return authInfo_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                  .getDefaultInstance()
              : authInfo_;
        }
      }
      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder>
          getAuthInfoFieldBuilder() {
        if (authInfoBuilder_ == null) {
          authInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
                      .BasicAuthenticationOrBuilder>(
                  getAuthInfo(), getParentForChildren(), isClean());
          authInfo_ = null;
        }
        return authInfoBuilder_;
      }

      private boolean maskHeaders_;
      /**
       *
       *
       * <pre>
       * Boolean specifiying whether to encrypt the header information.
       * Encryption should be specified for any headers related to authentication
       * that you do not wish to be seen when retrieving the configuration. The
       * server will be responsible for encrypting the headers.
       * On Get/List calls, if `mask_headers` is set to `true` then the headers
       * will be obscured with `******.`
       * </pre>
       *
       * <code>bool mask_headers = 5;</code>
       *
       * @return The maskHeaders.
       */
      @java.lang.Override
      public boolean getMaskHeaders() {
        return maskHeaders_;
      }
      /**
       *
       *
       * <pre>
       * Boolean specifiying whether to encrypt the header information.
       * Encryption should be specified for any headers related to authentication
       * that you do not wish to be seen when retrieving the configuration. The
       * server will be responsible for encrypting the headers.
       * On Get/List calls, if `mask_headers` is set to `true` then the headers
       * will be obscured with `******.`
       * </pre>
       *
       * <code>bool mask_headers = 5;</code>
       *
       * @param value The maskHeaders to set.
       * @return This builder for chaining.
       */
      public Builder setMaskHeaders(boolean value) {

        maskHeaders_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Boolean specifiying whether to encrypt the header information.
       * Encryption should be specified for any headers related to authentication
       * that you do not wish to be seen when retrieving the configuration. The
       * server will be responsible for encrypting the headers.
       * On Get/List calls, if `mask_headers` is set to `true` then the headers
       * will be obscured with `******.`
       * </pre>
       *
       * <code>bool mask_headers = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaskHeaders() {

        maskHeaders_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetHeaders() {
        if (headers_ == null) {
          return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        return headers_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableHeaders() {
        onChanged();
        ;
        if (headers_ == null) {
          headers_ =
              com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        if (!headers_.isMutable()) {
          headers_ = headers_.copy();
        }
        return headers_;
      }

      public int getHeadersCount() {
        return internalGetHeaders().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public boolean containsHeaders(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        return internalGetHeaders().getMap().containsKey(key);
      }
      /** Use {@link #getHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
        return getHeadersMap();
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
        return internalGetHeaders().getMap();
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearHeaders() {
        internalGetMutableHeaders().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      public Builder removeHeaders(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableHeaders().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
        return internalGetMutableHeaders().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      public Builder putHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        if (value == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableHeaders().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableHeaders().getMutableMap().putAll(values);
        return this;
      }

      private int contentType_ = 0;
      /**
       *
       *
       * <pre>
       * The content type to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @return The enum numeric value on the wire for contentType.
       */
      @java.lang.Override
      public int getContentTypeValue() {
        return contentType_;
      }
      /**
       *
       *
       * <pre>
       * The content type to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @param value The enum numeric value on the wire for contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentTypeValue(int value) {

        contentType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The content type to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @return The contentType.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType getContentType() {
        @SuppressWarnings("deprecation")
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType result =
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.valueOf(contentType_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The content type to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @param value The contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentType(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        contentType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The content type to use for the check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentType() {

        contentType_ = 0;
        onChanged();
        return this;
      }

      private boolean validateSsl_;
      /**
       *
       *
       * <pre>
       * Boolean specifying whether to include SSL certificate validation as a
       * part of the Uptime check. Only applies to checks where
       * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
       * setting `validate_ssl` to `true` has no effect.
       * </pre>
       *
       * <code>bool validate_ssl = 7;</code>
       *
       * @return The validateSsl.
       */
      @java.lang.Override
      public boolean getValidateSsl() {
        return validateSsl_;
      }
      /**
       *
       *
       * <pre>
       * Boolean specifying whether to include SSL certificate validation as a
       * part of the Uptime check. Only applies to checks where
       * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
       * setting `validate_ssl` to `true` has no effect.
       * </pre>
       *
       * <code>bool validate_ssl = 7;</code>
       *
       * @param value The validateSsl to set.
       * @return This builder for chaining.
       */
      public Builder setValidateSsl(boolean value) {

        validateSsl_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Boolean specifying whether to include SSL certificate validation as a
       * part of the Uptime check. Only applies to checks where
       * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
       * setting `validate_ssl` to `true` has no effect.
       * </pre>
       *
       * <code>bool validate_ssl = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValidateSsl() {

        validateSsl_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The request body associated with the HTTP request. If `content_type` is
       * `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide
       * a `Content-Length` header via the `headers` field or the API will do
       * so. The maximum byte size is 1 megabyte. Note: As with all `bytes` fields
       * JSON representations are base64 encoded.
       * </pre>
       *
       * <code>bytes body = 10;</code>
       *
       * @return The body.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBody() {
        return body_;
      }
      /**
       *
       *
       * <pre>
       * The request body associated with the HTTP request. If `content_type` is
       * `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide
       * a `Content-Length` header via the `headers` field or the API will do
       * so. The maximum byte size is 1 megabyte. Note: As with all `bytes` fields
       * JSON representations are base64 encoded.
       * </pre>
       *
       * <code>bytes body = 10;</code>
       *
       * @param value The body to set.
       * @return This builder for chaining.
       */
      public Builder setBody(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }

        body_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The request body associated with the HTTP request. If `content_type` is
       * `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide
       * a `Content-Length` header via the `headers` field or the API will do
       * so. The maximum byte size is 1 megabyte. Note: As with all `bytes` fields
       * JSON representations are base64 encoded.
       * </pre>
       *
       * <code>bytes body = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBody() {

        body_ = getDefaultInstance().getBody();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
    private static final com.google.monitoring.v3.UptimeCheckConfig.HttpCheck DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HttpCheck> PARSER =
        new com.google.protobuf.AbstractParser<HttpCheck>() {
          @java.lang.Override
          public HttpCheck parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HttpCheck> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HttpCheck> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TcpCheckOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The TCP port on the server against which to run the check. Will be
     * combined with host (specified within the `monitored_resource`) to
     * construct the full URL. Required.
     * </pre>
     *
     * <code>int32 port = 1;</code>
     *
     * @return The port.
     */
    int getPort();
  }
  /**
   *
   *
   * <pre>
   * Information required for a TCP Uptime check request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.TcpCheck}
   */
  public static final class TcpCheck extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
      TcpCheckOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TcpCheck.newBuilder() to construct.
    private TcpCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TcpCheck() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TcpCheck();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.class,
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder.class);
    }

    public static final int PORT_FIELD_NUMBER = 1;
    private int port_;
    /**
     *
     *
     * <pre>
     * The TCP port on the server against which to run the check. Will be
     * combined with host (specified within the `monitored_resource`) to
     * construct the full URL. Required.
     * </pre>
     *
     * <code>int32 port = 1;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (port_ != 0) {
        output.writeInt32(1, port_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, port_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.TcpCheck)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.TcpCheck other =
          (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) obj;

      if (getPort() != other.getPort()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information required for a TCP Uptime check request.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.TcpCheck}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.class,
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        port_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck build() {
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck result =
            new com.google.monitoring.v3.UptimeCheckConfig.TcpCheck(this);
        result.port_ = port_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance())
          return this;
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  port_ = input.readInt32();

                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int port_;
      /**
       *
       *
       * <pre>
       * The TCP port on the server against which to run the check. Will be
       * combined with host (specified within the `monitored_resource`) to
       * construct the full URL. Required.
       * </pre>
       *
       * <code>int32 port = 1;</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }
      /**
       *
       *
       * <pre>
       * The TCP port on the server against which to run the check. Will be
       * combined with host (specified within the `monitored_resource`) to
       * construct the full URL. Required.
       * </pre>
       *
       * <code>int32 port = 1;</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The TCP port on the server against which to run the check. Will be
       * combined with host (specified within the `monitored_resource`) to
       * construct the full URL. Required.
       * </pre>
       *
       * <code>int32 port = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {

        port_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
    private static final com.google.monitoring.v3.UptimeCheckConfig.TcpCheck DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.TcpCheck();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TcpCheck> PARSER =
        new com.google.protobuf.AbstractParser<TcpCheck>() {
          @java.lang.Override
          public TcpCheck parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TcpCheck> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TcpCheck> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ContentMatcherOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * String or regex content to match. Maximum 1024 bytes. An empty `content`
     * string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    java.lang.String getContent();
    /**
     *
     *
     * <pre>
     * String or regex content to match. Maximum 1024 bytes. An empty `content`
     * string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();

    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for matcher.
     */
    int getMatcherValue();
    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The matcher.
     */
    com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption getMatcher();
  }
  /**
   *
   *
   * <pre>
   * Optional. Used to perform content matching. This allows matching based on
   * substrings and regular expressions, together with their negations. Only the
   * first 4&amp;nbsp;MB of an HTTP or HTTPS check's response (and the first
   * 1&amp;nbsp;MB of a TCP check's response) are examined for purposes of content
   * matching.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ContentMatcher}
   */
  public static final class ContentMatcher extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
      ContentMatcherOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ContentMatcher.newBuilder() to construct.
    private ContentMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ContentMatcher() {
      content_ = "";
      matcher_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ContentMatcher();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.class,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Options to perform content matching.
     * </pre>
     *
     * Protobuf enum {@code
     * google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption}
     */
    public enum ContentMatcherOption implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No content matcher type specified (maintained for backward
       * compatibility, but deprecated for future use).
       * Treated as `CONTAINS_STRING`.
       * </pre>
       *
       * <code>CONTENT_MATCHER_OPTION_UNSPECIFIED = 0;</code>
       */
      CONTENT_MATCHER_OPTION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Selects substring matching. The match succeeds if the output contains
       * the `content` string.  This is the default value for checks without
       * a `matcher` option, or where the value of `matcher` is
       * `CONTENT_MATCHER_OPTION_UNSPECIFIED`.
       * </pre>
       *
       * <code>CONTAINS_STRING = 1;</code>
       */
      CONTAINS_STRING(1),
      /**
       *
       *
       * <pre>
       * Selects negation of substring matching. The match succeeds if the
       * output does _NOT_ contain the `content` string.
       * </pre>
       *
       * <code>NOT_CONTAINS_STRING = 2;</code>
       */
      NOT_CONTAINS_STRING(2),
      /**
       *
       *
       * <pre>
       * Selects regular-expression matching. The match succeeds of the output
       * matches the regular expression specified in the `content` string.
       * </pre>
       *
       * <code>MATCHES_REGEX = 3;</code>
       */
      MATCHES_REGEX(3),
      /**
       *
       *
       * <pre>
       * Selects negation of regular-expression matching. The match succeeds if
       * the output does _NOT_ match the regular expression specified in the
       * `content` string.
       * </pre>
       *
       * <code>NOT_MATCHES_REGEX = 4;</code>
       */
      NOT_MATCHES_REGEX(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No content matcher type specified (maintained for backward
       * compatibility, but deprecated for future use).
       * Treated as `CONTAINS_STRING`.
       * </pre>
       *
       * <code>CONTENT_MATCHER_OPTION_UNSPECIFIED = 0;</code>
       */
      public static final int CONTENT_MATCHER_OPTION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Selects substring matching. The match succeeds if the output contains
       * the `content` string.  This is the default value for checks without
       * a `matcher` option, or where the value of `matcher` is
       * `CONTENT_MATCHER_OPTION_UNSPECIFIED`.
       * </pre>
       *
       * <code>CONTAINS_STRING = 1;</code>
       */
      public static final int CONTAINS_STRING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Selects negation of substring matching. The match succeeds if the
       * output does _NOT_ contain the `content` string.
       * </pre>
       *
       * <code>NOT_CONTAINS_STRING = 2;</code>
       */
      public static final int NOT_CONTAINS_STRING_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Selects regular-expression matching. The match succeeds of the output
       * matches the regular expression specified in the `content` string.
       * </pre>
       *
       * <code>MATCHES_REGEX = 3;</code>
       */
      public static final int MATCHES_REGEX_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Selects negation of regular-expression matching. The match succeeds if
       * the output does _NOT_ match the regular expression specified in the
       * `content` string.
       * </pre>
       *
       * <code>NOT_MATCHES_REGEX = 4;</code>
       */
      public static final int NOT_MATCHES_REGEX_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentMatcherOption valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ContentMatcherOption forNumber(int value) {
        switch (value) {
          case 0:
            return CONTENT_MATCHER_OPTION_UNSPECIFIED;
          case 1:
            return CONTAINS_STRING;
          case 2:
            return NOT_CONTAINS_STRING;
          case 3:
            return MATCHES_REGEX;
          case 4:
            return NOT_MATCHES_REGEX;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ContentMatcherOption>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ContentMatcherOption>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ContentMatcherOption>() {
                public ContentMatcherOption findValueByNumber(int number) {
                  return ContentMatcherOption.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ContentMatcherOption[] VALUES = values();

      public static ContentMatcherOption valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ContentMatcherOption(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption)
    }

    public static final int CONTENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object content_;
    /**
     *
     *
     * <pre>
     * String or regex content to match. Maximum 1024 bytes. An empty `content`
     * string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * String or regex content to match. Maximum 1024 bytes. An empty `content`
     * string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MATCHER_FIELD_NUMBER = 2;
    private int matcher_;
    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for matcher.
     */
    @java.lang.Override
    public int getMatcherValue() {
      return matcher_;
    }
    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The matcher.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
        getMatcher() {
      @SuppressWarnings("deprecation")
      com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption result =
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption.valueOf(
              matcher_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getContentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
      }
      if (matcher_
          != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
              .CONTENT_MATCHER_OPTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, matcher_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getContentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
      }
      if (matcher_
          != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
              .CONTENT_MATCHER_OPTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, matcher_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher other =
          (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher) obj;

      if (!getContent().equals(other.getContent())) return false;
      if (matcher_ != other.matcher_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (37 * hash) + MATCHER_FIELD_NUMBER;
      hash = (53 * hash) + matcher_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform content matching. This allows matching based on
     * substrings and regular expressions, together with their negations. Only the
     * first 4&amp;nbsp;MB of an HTTP or HTTPS check's response (and the first
     * 1&amp;nbsp;MB of a TCP check's response) are examined for purposes of content
     * matching.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ContentMatcher}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.class,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        content_ = "";

        matcher_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher build() {
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher result =
            new com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher(this);
        result.content_ = content_;
        result.matcher_ = matcher_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance())
          return this;
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          onChanged();
        }
        if (other.matcher_ != 0) {
          setMatcherValue(other.getMatcherValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  content_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 16:
                {
                  matcher_ = input.readEnum();

                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object content_ = "";
      /**
       *
       *
       * <pre>
       * String or regex content to match. Maximum 1024 bytes. An empty `content`
       * string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String or regex content to match. Maximum 1024 bytes. An empty `content`
       * string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String or regex content to match. Maximum 1024 bytes. An empty `content`
       * string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        content_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * String or regex content to match. Maximum 1024 bytes. An empty `content`
       * string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {

        content_ = getDefaultInstance().getContent();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * String or regex content to match. Maximum 1024 bytes. An empty `content`
       * string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        content_ = value;
        onChanged();
        return this;
      }

      private int matcher_ = 0;
      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for matcher.
       */
      @java.lang.Override
      public int getMatcherValue() {
        return matcher_;
      }
      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for matcher to set.
       * @return This builder for chaining.
       */
      public Builder setMatcherValue(int value) {

        matcher_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @return The matcher.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
          getMatcher() {
        @SuppressWarnings("deprecation")
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption result =
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption.valueOf(
                matcher_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @param value The matcher to set.
       * @return This builder for chaining.
       */
      public Builder setMatcher(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption value) {
        if (value == null) {
          throw new NullPointerException();
        }

        matcher_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatcher() {

        matcher_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
    private static final com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ContentMatcher> PARSER =
        new com.google.protobuf.AbstractParser<ContentMatcher>() {
          @java.lang.Override
          public ContentMatcher parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ContentMatcher> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ContentMatcher> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int resourceCase_ = 0;
  private java.lang.Object resource_;

  public enum ResourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MONITORED_RESOURCE(3),
    RESOURCE_GROUP(4),
    RESOURCE_NOT_SET(0);
    private final int value;

    private ResourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResourceCase forNumber(int value) {
      switch (value) {
        case 3:
          return MONITORED_RESOURCE;
        case 4:
          return RESOURCE_GROUP;
        case 0:
          return RESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResourceCase getResourceCase() {
    return ResourceCase.forNumber(resourceCase_);
  }

  private int checkRequestTypeCase_ = 0;
  private java.lang.Object checkRequestType_;

  public enum CheckRequestTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HTTP_CHECK(5),
    TCP_CHECK(6),
    CHECKREQUESTTYPE_NOT_SET(0);
    private final int value;

    private CheckRequestTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CheckRequestTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static CheckRequestTypeCase forNumber(int value) {
      switch (value) {
        case 5:
          return HTTP_CHECK;
        case 6:
          return TCP_CHECK;
        case 0:
          return CHECKREQUESTTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CheckRequestTypeCase getCheckRequestTypeCase() {
    return CheckRequestTypeCase.forNumber(checkRequestTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A unique resource name for this Uptime check configuration. The format is:
   *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
   * This field should be omitted when creating the Uptime check configuration;
   * on create, the resource name is assigned by the server and included in the
   * response.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique resource name for this Uptime check configuration. The format is:
   *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
   * This field should be omitted when creating the Uptime check configuration;
   * on create, the resource name is assigned by the server and included in the
   * response.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * A human-friendly name for the Uptime check configuration. The display name
   * should be unique within a Stackdriver Workspace in order to make it easier
   * to identify; however, uniqueness is not enforced. Required.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-friendly name for the Uptime check configuration. The display name
   * should be unique within a Stackdriver Workspace in order to make it easier
   * to identify; however, uniqueness is not enforced. Required.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MONITORED_RESOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The [monitored
   * resource](https://cloud.google.com/monitoring/api/resources) associated
   * with the configuration.
   * The following monitored resource types are supported for Uptime checks:
   *   `uptime_url`,
   *   `gce_instance`,
   *   `gae_app`,
   *   `aws_ec2_instance`,
   *   `aws_elb_load_balancer`
   * </pre>
   *
   * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
   *
   * @return Whether the monitoredResource field is set.
   */
  @java.lang.Override
  public boolean hasMonitoredResource() {
    return resourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The [monitored
   * resource](https://cloud.google.com/monitoring/api/resources) associated
   * with the configuration.
   * The following monitored resource types are supported for Uptime checks:
   *   `uptime_url`,
   *   `gce_instance`,
   *   `gae_app`,
   *   `aws_ec2_instance`,
   *   `aws_elb_load_balancer`
   * </pre>
   *
   * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
   *
   * @return The monitoredResource.
   */
  @java.lang.Override
  public com.google.api.MonitoredResource getMonitoredResource() {
    if (resourceCase_ == 3) {
      return (com.google.api.MonitoredResource) resource_;
    }
    return com.google.api.MonitoredResource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The [monitored
   * resource](https://cloud.google.com/monitoring/api/resources) associated
   * with the configuration.
   * The following monitored resource types are supported for Uptime checks:
   *   `uptime_url`,
   *   `gce_instance`,
   *   `gae_app`,
   *   `aws_ec2_instance`,
   *   `aws_elb_load_balancer`
   * </pre>
   *
   * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceOrBuilder getMonitoredResourceOrBuilder() {
    if (resourceCase_ == 3) {
      return (com.google.api.MonitoredResource) resource_;
    }
    return com.google.api.MonitoredResource.getDefaultInstance();
  }

  public static final int RESOURCE_GROUP_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The group resource associated with the configuration.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
   *
   * @return Whether the resourceGroup field is set.
   */
  @java.lang.Override
  public boolean hasResourceGroup() {
    return resourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The group resource associated with the configuration.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
   *
   * @return The resourceGroup.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getResourceGroup() {
    if (resourceCase_ == 4) {
      return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The group resource associated with the configuration.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder
      getResourceGroupOrBuilder() {
    if (resourceCase_ == 4) {
      return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
  }

  public static final int HTTP_CHECK_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Contains information needed to make an HTTP or HTTPS check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
   *
   * @return Whether the httpCheck field is set.
   */
  @java.lang.Override
  public boolean hasHttpCheck() {
    return checkRequestTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Contains information needed to make an HTTP or HTTPS check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
   *
   * @return The httpCheck.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getHttpCheck() {
    if (checkRequestTypeCase_ == 5) {
      return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Contains information needed to make an HTTP or HTTPS check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder getHttpCheckOrBuilder() {
    if (checkRequestTypeCase_ == 5) {
      return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
  }

  public static final int TCP_CHECK_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Contains information needed to make a TCP check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
   *
   * @return Whether the tcpCheck field is set.
   */
  @java.lang.Override
  public boolean hasTcpCheck() {
    return checkRequestTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Contains information needed to make a TCP check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
   *
   * @return The tcpCheck.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getTcpCheck() {
    if (checkRequestTypeCase_ == 6) {
      return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Contains information needed to make a TCP check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder getTcpCheckOrBuilder() {
    if (checkRequestTypeCase_ == 6) {
      return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
  }

  public static final int PERIOD_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration period_;
  /**
   *
   *
   * <pre>
   * How often, in seconds, the Uptime check is performed.
   * Currently, the only supported values are `60s` (1 minute), `300s`
   * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
   * defaults to `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 7;</code>
   *
   * @return Whether the period field is set.
   */
  @java.lang.Override
  public boolean hasPeriod() {
    return period_ != null;
  }
  /**
   *
   *
   * <pre>
   * How often, in seconds, the Uptime check is performed.
   * Currently, the only supported values are `60s` (1 minute), `300s`
   * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
   * defaults to `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 7;</code>
   *
   * @return The period.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getPeriod() {
    return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
  }
  /**
   *
   *
   * <pre>
   * How often, in seconds, the Uptime check is performed.
   * Currently, the only supported values are `60s` (1 minute), `300s`
   * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
   * defaults to `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
    return getPeriod();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait for the request to complete (must be
   * between 1 and 60 seconds). Required.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait for the request to complete (must be
   * between 1 and 60 seconds). Required.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait for the request to complete (must be
   * between 1 and 60 seconds). Required.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int CONTENT_MATCHERS_FIELD_NUMBER = 9;
  private java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
      contentMatchers_;
  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
      getContentMatchersList() {
    return contentMatchers_;
  }
  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
      getContentMatchersOrBuilderList() {
    return contentMatchers_;
  }
  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public int getContentMatchersCount() {
    return contentMatchers_.size();
  }
  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getContentMatchers(int index) {
    return contentMatchers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder
      getContentMatchersOrBuilder(int index) {
    return contentMatchers_.get(index);
  }

  public static final int SELECTED_REGIONS_FIELD_NUMBER = 10;
  private java.util.List<java.lang.Integer> selectedRegions_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>
      selectedRegions_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>() {
            public com.google.monitoring.v3.UptimeCheckRegion convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.monitoring.v3.UptimeCheckRegion result =
                  com.google.monitoring.v3.UptimeCheckRegion.valueOf(from);
              return result == null
                  ? com.google.monitoring.v3.UptimeCheckRegion.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @return A list containing the selectedRegions.
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.UptimeCheckRegion> getSelectedRegionsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>(
        selectedRegions_, selectedRegions_converter_);
  }
  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @return The count of selectedRegions.
   */
  @java.lang.Override
  public int getSelectedRegionsCount() {
    return selectedRegions_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The selectedRegions at the given index.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckRegion getSelectedRegions(int index) {
    return selectedRegions_converter_.convert(selectedRegions_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @return A list containing the enum numeric values on the wire for selectedRegions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSelectedRegionsValueList() {
    return selectedRegions_;
  }
  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of selectedRegions at the given index.
   */
  @java.lang.Override
  public int getSelectedRegionsValue(int index) {
    return selectedRegions_.get(index);
  }

  private int selectedRegionsMemoizedSerializedSize;

  public static final int IS_INTERNAL_FIELD_NUMBER = 15;
  private boolean isInternal_;
  /**
   *
   *
   * <pre>
   * If this is `true`, then checks are made only from the 'internal_checkers'.
   * If it is `false`, then checks are made only from the 'selected_regions'.
   * It is an error to provide 'selected_regions' when is_internal is `true`,
   * or to provide 'internal_checkers' when is_internal is `false`.
   * </pre>
   *
   * <code>bool is_internal = 15 [deprecated = true];</code>
   *
   * @return The isInternal.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getIsInternal() {
    return isInternal_;
  }

  public static final int INTERNAL_CHECKERS_FIELD_NUMBER = 14;
  private java.util.List<com.google.monitoring.v3.InternalChecker> internalCheckers_;
  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.monitoring.v3.InternalChecker> getInternalCheckersList() {
    return internalCheckers_;
  }
  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.monitoring.v3.InternalCheckerOrBuilder>
      getInternalCheckersOrBuilderList() {
    return internalCheckers_;
  }
  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getInternalCheckersCount() {
    return internalCheckers_.size();
  }
  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.monitoring.v3.InternalChecker getInternalCheckers(int index) {
    return internalCheckers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.monitoring.v3.InternalCheckerOrBuilder getInternalCheckersOrBuilder(int index) {
    return internalCheckers_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (resourceCase_ == 3) {
      output.writeMessage(3, (com.google.api.MonitoredResource) resource_);
    }
    if (resourceCase_ == 4) {
      output.writeMessage(4, (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_);
    }
    if (checkRequestTypeCase_ == 5) {
      output.writeMessage(
          5, (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_);
    }
    if (checkRequestTypeCase_ == 6) {
      output.writeMessage(
          6, (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_);
    }
    if (period_ != null) {
      output.writeMessage(7, getPeriod());
    }
    if (timeout_ != null) {
      output.writeMessage(8, getTimeout());
    }
    for (int i = 0; i < contentMatchers_.size(); i++) {
      output.writeMessage(9, contentMatchers_.get(i));
    }
    if (getSelectedRegionsList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(selectedRegionsMemoizedSerializedSize);
    }
    for (int i = 0; i < selectedRegions_.size(); i++) {
      output.writeEnumNoTag(selectedRegions_.get(i));
    }
    for (int i = 0; i < internalCheckers_.size(); i++) {
      output.writeMessage(14, internalCheckers_.get(i));
    }
    if (isInternal_ != false) {
      output.writeBool(15, isInternal_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (resourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.api.MonitoredResource) resource_);
    }
    if (resourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_);
    }
    if (checkRequestTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_);
    }
    if (checkRequestTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_);
    }
    if (period_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPeriod());
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTimeout());
    }
    for (int i = 0; i < contentMatchers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, contentMatchers_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < selectedRegions_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(selectedRegions_.get(i));
      }
      size += dataSize;
      if (!getSelectedRegionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      selectedRegionsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < internalCheckers_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, internalCheckers_.get(i));
    }
    if (isInternal_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, isInternal_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.UptimeCheckConfig other =
        (com.google.monitoring.v3.UptimeCheckConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasPeriod() != other.hasPeriod()) return false;
    if (hasPeriod()) {
      if (!getPeriod().equals(other.getPeriod())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getContentMatchersList().equals(other.getContentMatchersList())) return false;
    if (!selectedRegions_.equals(other.selectedRegions_)) return false;
    if (getIsInternal() != other.getIsInternal()) return false;
    if (!getInternalCheckersList().equals(other.getInternalCheckersList())) return false;
    if (!getResourceCase().equals(other.getResourceCase())) return false;
    switch (resourceCase_) {
      case 3:
        if (!getMonitoredResource().equals(other.getMonitoredResource())) return false;
        break;
      case 4:
        if (!getResourceGroup().equals(other.getResourceGroup())) return false;
        break;
      case 0:
      default:
    }
    if (!getCheckRequestTypeCase().equals(other.getCheckRequestTypeCase())) return false;
    switch (checkRequestTypeCase_) {
      case 5:
        if (!getHttpCheck().equals(other.getHttpCheck())) return false;
        break;
      case 6:
        if (!getTcpCheck().equals(other.getTcpCheck())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasPeriod()) {
      hash = (37 * hash) + PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getPeriod().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (getContentMatchersCount() > 0) {
      hash = (37 * hash) + CONTENT_MATCHERS_FIELD_NUMBER;
      hash = (53 * hash) + getContentMatchersList().hashCode();
    }
    if (getSelectedRegionsCount() > 0) {
      hash = (37 * hash) + SELECTED_REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + selectedRegions_.hashCode();
    }
    hash = (37 * hash) + IS_INTERNAL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsInternal());
    if (getInternalCheckersCount() > 0) {
      hash = (37 * hash) + INTERNAL_CHECKERS_FIELD_NUMBER;
      hash = (53 * hash) + getInternalCheckersList().hashCode();
    }
    switch (resourceCase_) {
      case 3:
        hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getMonitoredResource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + RESOURCE_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getResourceGroup().hashCode();
        break;
      case 0:
      default:
    }
    switch (checkRequestTypeCase_) {
      case 5:
        hash = (37 * hash) + HTTP_CHECK_FIELD_NUMBER;
        hash = (53 * hash) + getHttpCheck().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TCP_CHECK_FIELD_NUMBER;
        hash = (53 * hash) + getTcpCheck().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.UptimeCheckConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This message configures which resources and services to monitor for
   * availability.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig)
      com.google.monitoring.v3.UptimeCheckConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.class,
              com.google.monitoring.v3.UptimeCheckConfig.Builder.class);
    }

    // Construct using com.google.monitoring.v3.UptimeCheckConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (monitoredResourceBuilder_ != null) {
        monitoredResourceBuilder_.clear();
      }
      if (resourceGroupBuilder_ != null) {
        resourceGroupBuilder_.clear();
      }
      if (httpCheckBuilder_ != null) {
        httpCheckBuilder_.clear();
      }
      if (tcpCheckBuilder_ != null) {
        tcpCheckBuilder_.clear();
      }
      if (periodBuilder_ == null) {
        period_ = null;
      } else {
        period_ = null;
        periodBuilder_ = null;
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      if (contentMatchersBuilder_ == null) {
        contentMatchers_ = java.util.Collections.emptyList();
      } else {
        contentMatchers_ = null;
        contentMatchersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      selectedRegions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      isInternal_ = false;

      if (internalCheckersBuilder_ == null) {
        internalCheckers_ = java.util.Collections.emptyList();
      } else {
        internalCheckers_ = null;
        internalCheckersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      resourceCase_ = 0;
      resource_ = null;
      checkRequestTypeCase_ = 0;
      checkRequestType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig getDefaultInstanceForType() {
      return com.google.monitoring.v3.UptimeCheckConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig build() {
      com.google.monitoring.v3.UptimeCheckConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig buildPartial() {
      com.google.monitoring.v3.UptimeCheckConfig result =
          new com.google.monitoring.v3.UptimeCheckConfig(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (resourceCase_ == 3) {
        if (monitoredResourceBuilder_ == null) {
          result.resource_ = resource_;
        } else {
          result.resource_ = monitoredResourceBuilder_.build();
        }
      }
      if (resourceCase_ == 4) {
        if (resourceGroupBuilder_ == null) {
          result.resource_ = resource_;
        } else {
          result.resource_ = resourceGroupBuilder_.build();
        }
      }
      if (checkRequestTypeCase_ == 5) {
        if (httpCheckBuilder_ == null) {
          result.checkRequestType_ = checkRequestType_;
        } else {
          result.checkRequestType_ = httpCheckBuilder_.build();
        }
      }
      if (checkRequestTypeCase_ == 6) {
        if (tcpCheckBuilder_ == null) {
          result.checkRequestType_ = checkRequestType_;
        } else {
          result.checkRequestType_ = tcpCheckBuilder_.build();
        }
      }
      if (periodBuilder_ == null) {
        result.period_ = period_;
      } else {
        result.period_ = periodBuilder_.build();
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      if (contentMatchersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          contentMatchers_ = java.util.Collections.unmodifiableList(contentMatchers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.contentMatchers_ = contentMatchers_;
      } else {
        result.contentMatchers_ = contentMatchersBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        selectedRegions_ = java.util.Collections.unmodifiableList(selectedRegions_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.selectedRegions_ = selectedRegions_;
      result.isInternal_ = isInternal_;
      if (internalCheckersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          internalCheckers_ = java.util.Collections.unmodifiableList(internalCheckers_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.internalCheckers_ = internalCheckers_;
      } else {
        result.internalCheckers_ = internalCheckersBuilder_.build();
      }
      result.resourceCase_ = resourceCase_;
      result.checkRequestTypeCase_ = checkRequestTypeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.UptimeCheckConfig) {
        return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig other) {
      if (other == com.google.monitoring.v3.UptimeCheckConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasPeriod()) {
        mergePeriod(other.getPeriod());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (contentMatchersBuilder_ == null) {
        if (!other.contentMatchers_.isEmpty()) {
          if (contentMatchers_.isEmpty()) {
            contentMatchers_ = other.contentMatchers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureContentMatchersIsMutable();
            contentMatchers_.addAll(other.contentMatchers_);
          }
          onChanged();
        }
      } else {
        if (!other.contentMatchers_.isEmpty()) {
          if (contentMatchersBuilder_.isEmpty()) {
            contentMatchersBuilder_.dispose();
            contentMatchersBuilder_ = null;
            contentMatchers_ = other.contentMatchers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            contentMatchersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentMatchersFieldBuilder()
                    : null;
          } else {
            contentMatchersBuilder_.addAllMessages(other.contentMatchers_);
          }
        }
      }
      if (!other.selectedRegions_.isEmpty()) {
        if (selectedRegions_.isEmpty()) {
          selectedRegions_ = other.selectedRegions_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureSelectedRegionsIsMutable();
          selectedRegions_.addAll(other.selectedRegions_);
        }
        onChanged();
      }
      if (other.getIsInternal() != false) {
        setIsInternal(other.getIsInternal());
      }
      if (internalCheckersBuilder_ == null) {
        if (!other.internalCheckers_.isEmpty()) {
          if (internalCheckers_.isEmpty()) {
            internalCheckers_ = other.internalCheckers_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureInternalCheckersIsMutable();
            internalCheckers_.addAll(other.internalCheckers_);
          }
          onChanged();
        }
      } else {
        if (!other.internalCheckers_.isEmpty()) {
          if (internalCheckersBuilder_.isEmpty()) {
            internalCheckersBuilder_.dispose();
            internalCheckersBuilder_ = null;
            internalCheckers_ = other.internalCheckers_;
            bitField0_ = (bitField0_ & ~0x00000004);
            internalCheckersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInternalCheckersFieldBuilder()
                    : null;
          } else {
            internalCheckersBuilder_.addAllMessages(other.internalCheckers_);
          }
        }
      }
      switch (other.getResourceCase()) {
        case MONITORED_RESOURCE:
          {
            mergeMonitoredResource(other.getMonitoredResource());
            break;
          }
        case RESOURCE_GROUP:
          {
            mergeResourceGroup(other.getResourceGroup());
            break;
          }
        case RESOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getCheckRequestTypeCase()) {
        case HTTP_CHECK:
          {
            mergeHttpCheck(other.getHttpCheck());
            break;
          }
        case TCP_CHECK:
          {
            mergeTcpCheck(other.getTcpCheck());
            break;
          }
        case CHECKREQUESTTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getMonitoredResourceFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getResourceGroupFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getHttpCheckFieldBuilder().getBuilder(), extensionRegistry);
                checkRequestTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTcpCheckFieldBuilder().getBuilder(), extensionRegistry);
                checkRequestTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPeriodFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher m =
                    input.readMessage(
                        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.parser(),
                        extensionRegistry);
                if (contentMatchersBuilder_ == null) {
                  ensureContentMatchersIsMutable();
                  contentMatchers_.add(m);
                } else {
                  contentMatchersBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                int tmpRaw = input.readEnum();
                ensureSelectedRegionsIsMutable();
                selectedRegions_.add(tmpRaw);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSelectedRegionsIsMutable();
                  selectedRegions_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 82
            case 114:
              {
                com.google.monitoring.v3.InternalChecker m =
                    input.readMessage(
                        com.google.monitoring.v3.InternalChecker.parser(), extensionRegistry);
                if (internalCheckersBuilder_ == null) {
                  ensureInternalCheckersIsMutable();
                  internalCheckers_.add(m);
                } else {
                  internalCheckersBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 120:
              {
                isInternal_ = input.readBool();

                break;
              } // case 120
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resourceCase_ = 0;
    private java.lang.Object resource_;

    public ResourceCase getResourceCase() {
      return ResourceCase.forNumber(resourceCase_);
    }

    public Builder clearResource() {
      resourceCase_ = 0;
      resource_ = null;
      onChanged();
      return this;
    }

    private int checkRequestTypeCase_ = 0;
    private java.lang.Object checkRequestType_;

    public CheckRequestTypeCase getCheckRequestTypeCase() {
      return CheckRequestTypeCase.forNumber(checkRequestTypeCase_);
    }

    public Builder clearCheckRequestType() {
      checkRequestTypeCase_ = 0;
      checkRequestType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A unique resource name for this Uptime check configuration. The format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique resource name for this Uptime check configuration. The format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique resource name for this Uptime check configuration. The format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique resource name for this Uptime check configuration. The format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique resource name for this Uptime check configuration. The format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Stackdriver Workspace in order to make it easier
     * to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Stackdriver Workspace in order to make it easier
     * to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Stackdriver Workspace in order to make it easier
     * to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Stackdriver Workspace in order to make it easier
     * to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Stackdriver Workspace in order to make it easier
     * to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        monitoredResourceBuilder_;
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     *
     * @return Whether the monitoredResource field is set.
     */
    @java.lang.Override
    public boolean hasMonitoredResource() {
      return resourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     *
     * @return The monitoredResource.
     */
    @java.lang.Override
    public com.google.api.MonitoredResource getMonitoredResource() {
      if (monitoredResourceBuilder_ == null) {
        if (resourceCase_ == 3) {
          return (com.google.api.MonitoredResource) resource_;
        }
        return com.google.api.MonitoredResource.getDefaultInstance();
      } else {
        if (resourceCase_ == 3) {
          return monitoredResourceBuilder_.getMessage();
        }
        return com.google.api.MonitoredResource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder setMonitoredResource(com.google.api.MonitoredResource value) {
      if (monitoredResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        monitoredResourceBuilder_.setMessage(value);
      }
      resourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder setMonitoredResource(com.google.api.MonitoredResource.Builder builderForValue) {
      if (monitoredResourceBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        monitoredResourceBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder mergeMonitoredResource(com.google.api.MonitoredResource value) {
      if (monitoredResourceBuilder_ == null) {
        if (resourceCase_ == 3
            && resource_ != com.google.api.MonitoredResource.getDefaultInstance()) {
          resource_ =
              com.google.api.MonitoredResource.newBuilder(
                      (com.google.api.MonitoredResource) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 3) {
          monitoredResourceBuilder_.mergeFrom(value);
        }
        monitoredResourceBuilder_.setMessage(value);
      }
      resourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder clearMonitoredResource() {
      if (monitoredResourceBuilder_ == null) {
        if (resourceCase_ == 3) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 3) {
          resourceCase_ = 0;
          resource_ = null;
        }
        monitoredResourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public com.google.api.MonitoredResource.Builder getMonitoredResourceBuilder() {
      return getMonitoredResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    @java.lang.Override
    public com.google.api.MonitoredResourceOrBuilder getMonitoredResourceOrBuilder() {
      if ((resourceCase_ == 3) && (monitoredResourceBuilder_ != null)) {
        return monitoredResourceBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 3) {
          return (com.google.api.MonitoredResource) resource_;
        }
        return com.google.api.MonitoredResource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are supported for Uptime checks:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        getMonitoredResourceFieldBuilder() {
      if (monitoredResourceBuilder_ == null) {
        if (!(resourceCase_ == 3)) {
          resource_ = com.google.api.MonitoredResource.getDefaultInstance();
        }
        monitoredResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MonitoredResource,
                com.google.api.MonitoredResource.Builder,
                com.google.api.MonitoredResourceOrBuilder>(
                (com.google.api.MonitoredResource) resource_, getParentForChildren(), isClean());
        resource_ = null;
      }
      resourceCase_ = 3;
      onChanged();
      ;
      return monitoredResourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder>
        resourceGroupBuilder_;
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     *
     * @return Whether the resourceGroup field is set.
     */
    @java.lang.Override
    public boolean hasResourceGroup() {
      return resourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     *
     * @return The resourceGroup.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getResourceGroup() {
      if (resourceGroupBuilder_ == null) {
        if (resourceCase_ == 4) {
          return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      } else {
        if (resourceCase_ == 4) {
          return resourceGroupBuilder_.getMessage();
        }
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder setResourceGroup(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup value) {
      if (resourceGroupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        resourceGroupBuilder_.setMessage(value);
      }
      resourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder setResourceGroup(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder builderForValue) {
      if (resourceGroupBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        resourceGroupBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder mergeResourceGroup(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup value) {
      if (resourceGroupBuilder_ == null) {
        if (resourceCase_ == 4
            && resource_
                != com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance()) {
          resource_ =
              com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.newBuilder(
                      (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 4) {
          resourceGroupBuilder_.mergeFrom(value);
        }
        resourceGroupBuilder_.setMessage(value);
      }
      resourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder clearResourceGroup() {
      if (resourceGroupBuilder_ == null) {
        if (resourceCase_ == 4) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 4) {
          resourceCase_ = 0;
          resource_ = null;
        }
        resourceGroupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder
        getResourceGroupBuilder() {
      return getResourceGroupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder
        getResourceGroupOrBuilder() {
      if ((resourceCase_ == 4) && (resourceGroupBuilder_ != null)) {
        return resourceGroupBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 4) {
          return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder>
        getResourceGroupFieldBuilder() {
      if (resourceGroupBuilder_ == null) {
        if (!(resourceCase_ == 4)) {
          resource_ = com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
        }
        resourceGroupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup,
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder>(
                (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 4;
      onChanged();
      ;
      return resourceGroupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder>
        httpCheckBuilder_;
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     *
     * @return Whether the httpCheck field is set.
     */
    @java.lang.Override
    public boolean hasHttpCheck() {
      return checkRequestTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     *
     * @return The httpCheck.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getHttpCheck() {
      if (httpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 5) {
          return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      } else {
        if (checkRequestTypeCase_ == 5) {
          return httpCheckBuilder_.getMessage();
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder setHttpCheck(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck value) {
      if (httpCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkRequestType_ = value;
        onChanged();
      } else {
        httpCheckBuilder_.setMessage(value);
      }
      checkRequestTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder setHttpCheck(
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder builderForValue) {
      if (httpCheckBuilder_ == null) {
        checkRequestType_ = builderForValue.build();
        onChanged();
      } else {
        httpCheckBuilder_.setMessage(builderForValue.build());
      }
      checkRequestTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder mergeHttpCheck(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck value) {
      if (httpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 5
            && checkRequestType_
                != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance()) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.newBuilder(
                      (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          checkRequestType_ = value;
        }
        onChanged();
      } else {
        if (checkRequestTypeCase_ == 5) {
          httpCheckBuilder_.mergeFrom(value);
        }
        httpCheckBuilder_.setMessage(value);
      }
      checkRequestTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder clearHttpCheck() {
      if (httpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 5) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
          onChanged();
        }
      } else {
        if (checkRequestTypeCase_ == 5) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
        }
        httpCheckBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder getHttpCheckBuilder() {
      return getHttpCheckFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder getHttpCheckOrBuilder() {
      if ((checkRequestTypeCase_ == 5) && (httpCheckBuilder_ != null)) {
        return httpCheckBuilder_.getMessageOrBuilder();
      } else {
        if (checkRequestTypeCase_ == 5) {
          return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder>
        getHttpCheckFieldBuilder() {
      if (httpCheckBuilder_ == null) {
        if (!(checkRequestTypeCase_ == 5)) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
        }
        httpCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder>(
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_,
                getParentForChildren(),
                isClean());
        checkRequestType_ = null;
      }
      checkRequestTypeCase_ = 5;
      onChanged();
      ;
      return httpCheckBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder>
        tcpCheckBuilder_;
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     *
     * @return Whether the tcpCheck field is set.
     */
    @java.lang.Override
    public boolean hasTcpCheck() {
      return checkRequestTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     *
     * @return The tcpCheck.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getTcpCheck() {
      if (tcpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 6) {
          return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      } else {
        if (checkRequestTypeCase_ == 6) {
          return tcpCheckBuilder_.getMessage();
        }
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder setTcpCheck(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck value) {
      if (tcpCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkRequestType_ = value;
        onChanged();
      } else {
        tcpCheckBuilder_.setMessage(value);
      }
      checkRequestTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder setTcpCheck(
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder builderForValue) {
      if (tcpCheckBuilder_ == null) {
        checkRequestType_ = builderForValue.build();
        onChanged();
      } else {
        tcpCheckBuilder_.setMessage(builderForValue.build());
      }
      checkRequestTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder mergeTcpCheck(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck value) {
      if (tcpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 6
            && checkRequestType_
                != com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance()) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.newBuilder(
                      (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          checkRequestType_ = value;
        }
        onChanged();
      } else {
        if (checkRequestTypeCase_ == 6) {
          tcpCheckBuilder_.mergeFrom(value);
        }
        tcpCheckBuilder_.setMessage(value);
      }
      checkRequestTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder clearTcpCheck() {
      if (tcpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 6) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
          onChanged();
        }
      } else {
        if (checkRequestTypeCase_ == 6) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
        }
        tcpCheckBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder getTcpCheckBuilder() {
      return getTcpCheckFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder getTcpCheckOrBuilder() {
      if ((checkRequestTypeCase_ == 6) && (tcpCheckBuilder_ != null)) {
        return tcpCheckBuilder_.getMessageOrBuilder();
      } else {
        if (checkRequestTypeCase_ == 6) {
          return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder>
        getTcpCheckFieldBuilder() {
      if (tcpCheckBuilder_ == null) {
        if (!(checkRequestTypeCase_ == 6)) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
        }
        tcpCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck,
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder>(
                (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_,
                getParentForChildren(),
                isClean());
        checkRequestType_ = null;
      }
      checkRequestTypeCase_ = 6;
      onChanged();
      ;
      return tcpCheckBuilder_;
    }

    private com.google.protobuf.Duration period_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        periodBuilder_;
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     *
     * @return Whether the period field is set.
     */
    public boolean hasPeriod() {
      return periodBuilder_ != null || period_ != null;
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     *
     * @return The period.
     */
    public com.google.protobuf.Duration getPeriod() {
      if (periodBuilder_ == null) {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      } else {
        return periodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder setPeriod(com.google.protobuf.Duration value) {
      if (periodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        period_ = value;
        onChanged();
      } else {
        periodBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder setPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (periodBuilder_ == null) {
        period_ = builderForValue.build();
        onChanged();
      } else {
        periodBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder mergePeriod(com.google.protobuf.Duration value) {
      if (periodBuilder_ == null) {
        if (period_ != null) {
          period_ =
              com.google.protobuf.Duration.newBuilder(period_).mergeFrom(value).buildPartial();
        } else {
          period_ = value;
        }
        onChanged();
      } else {
        periodBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder clearPeriod() {
      if (periodBuilder_ == null) {
        period_ = null;
        onChanged();
      } else {
        period_ = null;
        periodBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getPeriodBuilder() {

      onChanged();
      return getPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
      if (periodBuilder_ != null) {
        return periodBuilder_.getMessageOrBuilder();
      } else {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      }
    }
    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getPeriodFieldBuilder() {
      if (periodBuilder_ == null) {
        periodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getPeriod(), getParentForChildren(), isClean());
        period_ = null;
      }
      return periodBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
        contentMatchers_ = java.util.Collections.emptyList();

    private void ensureContentMatchersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        contentMatchers_ =
            new java.util.ArrayList<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>(
                contentMatchers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
        contentMatchersBuilder_;

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
        getContentMatchersList() {
      if (contentMatchersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contentMatchers_);
      } else {
        return contentMatchersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public int getContentMatchersCount() {
      if (contentMatchersBuilder_ == null) {
        return contentMatchers_.size();
      } else {
        return contentMatchersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getContentMatchers(int index) {
      if (contentMatchersBuilder_ == null) {
        return contentMatchers_.get(index);
      } else {
        return contentMatchersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder setContentMatchers(
        int index, com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher value) {
      if (contentMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentMatchersIsMutable();
        contentMatchers_.set(index, value);
        onChanged();
      } else {
        contentMatchersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder setContentMatchers(
        int index,
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder builderForValue) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentMatchersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher value) {
      if (contentMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentMatchersIsMutable();
        contentMatchers_.add(value);
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        int index, com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher value) {
      if (contentMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentMatchersIsMutable();
        contentMatchers_.add(index, value);
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder builderForValue) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.add(builderForValue.build());
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        int index,
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder builderForValue) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addAllContentMatchers(
        java.lang.Iterable<? extends com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
            values) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contentMatchers_);
        onChanged();
      } else {
        contentMatchersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder clearContentMatchers() {
      if (contentMatchersBuilder_ == null) {
        contentMatchers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        contentMatchersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder removeContentMatchers(int index) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.remove(index);
        onChanged();
      } else {
        contentMatchersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder
        getContentMatchersBuilder(int index) {
      return getContentMatchersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder
        getContentMatchersOrBuilder(int index) {
      if (contentMatchersBuilder_ == null) {
        return contentMatchers_.get(index);
      } else {
        return contentMatchersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public java.util.List<
            ? extends com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
        getContentMatchersOrBuilderList() {
      if (contentMatchersBuilder_ != null) {
        return contentMatchersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contentMatchers_);
      }
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder
        addContentMatchersBuilder() {
      return getContentMatchersFieldBuilder()
          .addBuilder(
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder
        addContentMatchersBuilder(int index) {
      return getContentMatchersFieldBuilder()
          .addBuilder(
              index,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder>
        getContentMatchersBuilderList() {
      return getContentMatchersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
        getContentMatchersFieldBuilder() {
      if (contentMatchersBuilder_ == null) {
        contentMatchersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>(
                contentMatchers_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        contentMatchers_ = null;
      }
      return contentMatchersBuilder_;
    }

    private java.util.List<java.lang.Integer> selectedRegions_ = java.util.Collections.emptyList();

    private void ensureSelectedRegionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        selectedRegions_ = new java.util.ArrayList<java.lang.Integer>(selectedRegions_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return A list containing the selectedRegions.
     */
    public java.util.List<com.google.monitoring.v3.UptimeCheckRegion> getSelectedRegionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>(
          selectedRegions_, selectedRegions_converter_);
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return The count of selectedRegions.
     */
    public int getSelectedRegionsCount() {
      return selectedRegions_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The selectedRegions at the given index.
     */
    public com.google.monitoring.v3.UptimeCheckRegion getSelectedRegions(int index) {
      return selectedRegions_converter_.convert(selectedRegions_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The selectedRegions to set.
     * @return This builder for chaining.
     */
    public Builder setSelectedRegions(int index, com.google.monitoring.v3.UptimeCheckRegion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSelectedRegionsIsMutable();
      selectedRegions_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param value The selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addSelectedRegions(com.google.monitoring.v3.UptimeCheckRegion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSelectedRegionsIsMutable();
      selectedRegions_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param values The selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSelectedRegions(
        java.lang.Iterable<? extends com.google.monitoring.v3.UptimeCheckRegion> values) {
      ensureSelectedRegionsIsMutable();
      for (com.google.monitoring.v3.UptimeCheckRegion value : values) {
        selectedRegions_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelectedRegions() {
      selectedRegions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return A list containing the enum numeric values on the wire for selectedRegions.
     */
    public java.util.List<java.lang.Integer> getSelectedRegionsValueList() {
      return java.util.Collections.unmodifiableList(selectedRegions_);
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of selectedRegions at the given index.
     */
    public int getSelectedRegionsValue(int index) {
      return selectedRegions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of selectedRegions at the given index.
     * @return This builder for chaining.
     */
    public Builder setSelectedRegionsValue(int index, int value) {
      ensureSelectedRegionsIsMutable();
      selectedRegions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param value The enum numeric value on the wire for selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addSelectedRegionsValue(int value) {
      ensureSelectedRegionsIsMutable();
      selectedRegions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param values The enum numeric values on the wire for selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSelectedRegionsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSelectedRegionsIsMutable();
      for (int value : values) {
        selectedRegions_.add(value);
      }
      onChanged();
      return this;
    }

    private boolean isInternal_;
    /**
     *
     *
     * <pre>
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     * </pre>
     *
     * <code>bool is_internal = 15 [deprecated = true];</code>
     *
     * @return The isInternal.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getIsInternal() {
      return isInternal_;
    }
    /**
     *
     *
     * <pre>
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     * </pre>
     *
     * <code>bool is_internal = 15 [deprecated = true];</code>
     *
     * @param value The isInternal to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setIsInternal(boolean value) {

      isInternal_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     * </pre>
     *
     * <code>bool is_internal = 15 [deprecated = true];</code>
     *
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearIsInternal() {

      isInternal_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.monitoring.v3.InternalChecker> internalCheckers_ =
        java.util.Collections.emptyList();

    private void ensureInternalCheckersIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        internalCheckers_ =
            new java.util.ArrayList<com.google.monitoring.v3.InternalChecker>(internalCheckers_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.InternalChecker,
            com.google.monitoring.v3.InternalChecker.Builder,
            com.google.monitoring.v3.InternalCheckerOrBuilder>
        internalCheckersBuilder_;

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.monitoring.v3.InternalChecker> getInternalCheckersList() {
      if (internalCheckersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(internalCheckers_);
      } else {
        return internalCheckersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getInternalCheckersCount() {
      if (internalCheckersBuilder_ == null) {
        return internalCheckers_.size();
      } else {
        return internalCheckersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker getInternalCheckers(int index) {
      if (internalCheckersBuilder_ == null) {
        return internalCheckers_.get(index);
      } else {
        return internalCheckersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInternalCheckers(int index, com.google.monitoring.v3.InternalChecker value) {
      if (internalCheckersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInternalCheckersIsMutable();
        internalCheckers_.set(index, value);
        onChanged();
      } else {
        internalCheckersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInternalCheckers(
        int index, com.google.monitoring.v3.InternalChecker.Builder builderForValue) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.set(index, builderForValue.build());
        onChanged();
      } else {
        internalCheckersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(com.google.monitoring.v3.InternalChecker value) {
      if (internalCheckersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(value);
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(int index, com.google.monitoring.v3.InternalChecker value) {
      if (internalCheckersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(index, value);
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(
        com.google.monitoring.v3.InternalChecker.Builder builderForValue) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(builderForValue.build());
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(
        int index, com.google.monitoring.v3.InternalChecker.Builder builderForValue) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(index, builderForValue.build());
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllInternalCheckers(
        java.lang.Iterable<? extends com.google.monitoring.v3.InternalChecker> values) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, internalCheckers_);
        onChanged();
      } else {
        internalCheckersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearInternalCheckers() {
      if (internalCheckersBuilder_ == null) {
        internalCheckers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        internalCheckersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeInternalCheckers(int index) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.remove(index);
        onChanged();
      } else {
        internalCheckersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker.Builder getInternalCheckersBuilder(int index) {
      return getInternalCheckersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalCheckerOrBuilder getInternalCheckersOrBuilder(
        int index) {
      if (internalCheckersBuilder_ == null) {
        return internalCheckers_.get(index);
      } else {
        return internalCheckersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.monitoring.v3.InternalCheckerOrBuilder>
        getInternalCheckersOrBuilderList() {
      if (internalCheckersBuilder_ != null) {
        return internalCheckersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(internalCheckers_);
      }
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker.Builder addInternalCheckersBuilder() {
      return getInternalCheckersFieldBuilder()
          .addBuilder(com.google.monitoring.v3.InternalChecker.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker.Builder addInternalCheckersBuilder(int index) {
      return getInternalCheckersFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.InternalChecker.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.monitoring.v3.InternalChecker.Builder>
        getInternalCheckersBuilderList() {
      return getInternalCheckersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.InternalChecker,
            com.google.monitoring.v3.InternalChecker.Builder,
            com.google.monitoring.v3.InternalCheckerOrBuilder>
        getInternalCheckersFieldBuilder() {
      if (internalCheckersBuilder_ == null) {
        internalCheckersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.InternalChecker,
                com.google.monitoring.v3.InternalChecker.Builder,
                com.google.monitoring.v3.InternalCheckerOrBuilder>(
                internalCheckers_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        internalCheckers_ = null;
      }
      return internalCheckersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig)
  private static final com.google.monitoring.v3.UptimeCheckConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig();
  }

  public static com.google.monitoring.v3.UptimeCheckConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UptimeCheckConfig> PARSER =
      new com.google.protobuf.AbstractParser<UptimeCheckConfig>() {
        @java.lang.Override
        public UptimeCheckConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UptimeCheckConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UptimeCheckConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
