/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * Summary of the result of a failed request to write data to a time series.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.CreateTimeSeriesSummary}
 */
public final class CreateTimeSeriesSummary extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.CreateTimeSeriesSummary)
    CreateTimeSeriesSummaryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateTimeSeriesSummary.newBuilder() to construct.
  private CreateTimeSeriesSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateTimeSeriesSummary() {
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateTimeSeriesSummary();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.CreateTimeSeriesSummary.class,
            com.google.monitoring.v3.CreateTimeSeriesSummary.Builder.class);
  }

  public interface ErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.CreateTimeSeriesSummary.Error)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The status of the requested write operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The status of the requested write operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();
    /**
     *
     *
     * <pre>
     * The status of the requested write operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * The number of points that couldn't be written because of `status`.
     * </pre>
     *
     * <code>int32 point_count = 2;</code>
     *
     * @return The pointCount.
     */
    int getPointCount();
  }
  /**
   *
   *
   * <pre>
   * Detailed information about an error category.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.CreateTimeSeriesSummary.Error}
   */
  public static final class Error extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.CreateTimeSeriesSummary.Error)
      ErrorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Error.newBuilder() to construct.
    private Error(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Error() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Error();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_Error_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.CreateTimeSeriesSummary.Error.class,
              com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder.class);
    }

    public static final int STATUS_FIELD_NUMBER = 1;
    private com.google.rpc.Status status_;
    /**
     *
     *
     * <pre>
     * The status of the requested write operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return status_ != null;
    }
    /**
     *
     *
     * <pre>
     * The status of the requested write operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }
    /**
     *
     *
     * <pre>
     * The status of the requested write operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    public static final int POINT_COUNT_FIELD_NUMBER = 2;
    private int pointCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of points that couldn't be written because of `status`.
     * </pre>
     *
     * <code>int32 point_count = 2;</code>
     *
     * @return The pointCount.
     */
    @java.lang.Override
    public int getPointCount() {
      return pointCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (status_ != null) {
        output.writeMessage(1, getStatus());
      }
      if (pointCount_ != 0) {
        output.writeInt32(2, pointCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (status_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStatus());
      }
      if (pointCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pointCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.CreateTimeSeriesSummary.Error)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.CreateTimeSeriesSummary.Error other =
          (com.google.monitoring.v3.CreateTimeSeriesSummary.Error) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (getPointCount() != other.getPointCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (37 * hash) + POINT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPointCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.CreateTimeSeriesSummary.Error prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Detailed information about an error category.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.CreateTimeSeriesSummary.Error}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.CreateTimeSeriesSummary.Error)
        com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.MetricServiceProto
            .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_Error_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.MetricServiceProto
            .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_Error_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.CreateTimeSeriesSummary.Error.class,
                com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder.class);
      }

      // Construct using com.google.monitoring.v3.CreateTimeSeriesSummary.Error.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        pointCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.MetricServiceProto
            .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_Error_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.CreateTimeSeriesSummary.Error getDefaultInstanceForType() {
        return com.google.monitoring.v3.CreateTimeSeriesSummary.Error.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.CreateTimeSeriesSummary.Error build() {
        com.google.monitoring.v3.CreateTimeSeriesSummary.Error result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.CreateTimeSeriesSummary.Error buildPartial() {
        com.google.monitoring.v3.CreateTimeSeriesSummary.Error result =
            new com.google.monitoring.v3.CreateTimeSeriesSummary.Error(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.CreateTimeSeriesSummary.Error result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pointCount_ = pointCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.CreateTimeSeriesSummary.Error) {
          return mergeFrom((com.google.monitoring.v3.CreateTimeSeriesSummary.Error) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.CreateTimeSeriesSummary.Error other) {
        if (other == com.google.monitoring.v3.CreateTimeSeriesSummary.Error.getDefaultInstance())
          return this;
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        if (other.getPointCount() != 0) {
          setPointCount(other.getPointCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  pointCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && status_ != null
              && status_ != com.google.rpc.Status.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The status of the requested write operation.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      private int pointCount_;
      /**
       *
       *
       * <pre>
       * The number of points that couldn't be written because of `status`.
       * </pre>
       *
       * <code>int32 point_count = 2;</code>
       *
       * @return The pointCount.
       */
      @java.lang.Override
      public int getPointCount() {
        return pointCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of points that couldn't be written because of `status`.
       * </pre>
       *
       * <code>int32 point_count = 2;</code>
       *
       * @param value The pointCount to set.
       * @return This builder for chaining.
       */
      public Builder setPointCount(int value) {

        pointCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of points that couldn't be written because of `status`.
       * </pre>
       *
       * <code>int32 point_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPointCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pointCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.CreateTimeSeriesSummary.Error)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.CreateTimeSeriesSummary.Error)
    private static final com.google.monitoring.v3.CreateTimeSeriesSummary.Error DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.CreateTimeSeriesSummary.Error();
    }

    public static com.google.monitoring.v3.CreateTimeSeriesSummary.Error getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Error> PARSER =
        new com.google.protobuf.AbstractParser<Error>() {
          @java.lang.Override
          public Error parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Error> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Error> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesSummary.Error getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TOTAL_POINT_COUNT_FIELD_NUMBER = 1;
  private int totalPointCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of points in the request.
   * </pre>
   *
   * <code>int32 total_point_count = 1;</code>
   *
   * @return The totalPointCount.
   */
  @java.lang.Override
  public int getTotalPointCount() {
    return totalPointCount_;
  }

  public static final int SUCCESS_POINT_COUNT_FIELD_NUMBER = 2;
  private int successPointCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of points that were successfully written.
   * </pre>
   *
   * <code>int32 success_point_count = 2;</code>
   *
   * @return The successPointCount.
   */
  @java.lang.Override
  public int getSuccessPointCount() {
    return successPointCount_;
  }

  public static final int ERRORS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.CreateTimeSeriesSummary.Error> errors_;
  /**
   *
   *
   * <pre>
   * The number of points that failed to be written. Order is not guaranteed.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.CreateTimeSeriesSummary.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * The number of points that failed to be written. Order is not guaranteed.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * The number of points that failed to be written. Order is not guaranteed.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * The number of points that failed to be written. Order is not guaranteed.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.CreateTimeSeriesSummary.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The number of points that failed to be written. Order is not guaranteed.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder getErrorsOrBuilder(
      int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (totalPointCount_ != 0) {
      output.writeInt32(1, totalPointCount_);
    }
    if (successPointCount_ != 0) {
      output.writeInt32(2, successPointCount_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(3, errors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (totalPointCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, totalPointCount_);
    }
    if (successPointCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, successPointCount_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, errors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.CreateTimeSeriesSummary)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.CreateTimeSeriesSummary other =
        (com.google.monitoring.v3.CreateTimeSeriesSummary) obj;

    if (getTotalPointCount() != other.getTotalPointCount()) return false;
    if (getSuccessPointCount() != other.getSuccessPointCount()) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOTAL_POINT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalPointCount();
    hash = (37 * hash) + SUCCESS_POINT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSuccessPointCount();
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.CreateTimeSeriesSummary prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Summary of the result of a failed request to write data to a time series.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.CreateTimeSeriesSummary}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.CreateTimeSeriesSummary)
      com.google.monitoring.v3.CreateTimeSeriesSummaryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.CreateTimeSeriesSummary.class,
              com.google.monitoring.v3.CreateTimeSeriesSummary.Builder.class);
    }

    // Construct using com.google.monitoring.v3.CreateTimeSeriesSummary.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      totalPointCount_ = 0;
      successPointCount_ = 0;
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesSummary_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesSummary getDefaultInstanceForType() {
      return com.google.monitoring.v3.CreateTimeSeriesSummary.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesSummary build() {
      com.google.monitoring.v3.CreateTimeSeriesSummary result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesSummary buildPartial() {
      com.google.monitoring.v3.CreateTimeSeriesSummary result =
          new com.google.monitoring.v3.CreateTimeSeriesSummary(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.monitoring.v3.CreateTimeSeriesSummary result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.CreateTimeSeriesSummary result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.totalPointCount_ = totalPointCount_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.successPointCount_ = successPointCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.CreateTimeSeriesSummary) {
        return mergeFrom((com.google.monitoring.v3.CreateTimeSeriesSummary) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.CreateTimeSeriesSummary other) {
      if (other == com.google.monitoring.v3.CreateTimeSeriesSummary.getDefaultInstance())
        return this;
      if (other.getTotalPointCount() != 0) {
        setTotalPointCount(other.getTotalPointCount());
      }
      if (other.getSuccessPointCount() != 0) {
        setSuccessPointCount(other.getSuccessPointCount());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                totalPointCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                successPointCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.monitoring.v3.CreateTimeSeriesSummary.Error m =
                    input.readMessage(
                        com.google.monitoring.v3.CreateTimeSeriesSummary.Error.parser(),
                        extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int totalPointCount_;
    /**
     *
     *
     * <pre>
     * The number of points in the request.
     * </pre>
     *
     * <code>int32 total_point_count = 1;</code>
     *
     * @return The totalPointCount.
     */
    @java.lang.Override
    public int getTotalPointCount() {
      return totalPointCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of points in the request.
     * </pre>
     *
     * <code>int32 total_point_count = 1;</code>
     *
     * @param value The totalPointCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalPointCount(int value) {

      totalPointCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points in the request.
     * </pre>
     *
     * <code>int32 total_point_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalPointCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      totalPointCount_ = 0;
      onChanged();
      return this;
    }

    private int successPointCount_;
    /**
     *
     *
     * <pre>
     * The number of points that were successfully written.
     * </pre>
     *
     * <code>int32 success_point_count = 2;</code>
     *
     * @return The successPointCount.
     */
    @java.lang.Override
    public int getSuccessPointCount() {
      return successPointCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of points that were successfully written.
     * </pre>
     *
     * <code>int32 success_point_count = 2;</code>
     *
     * @param value The successPointCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessPointCount(int value) {

      successPointCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that were successfully written.
     * </pre>
     *
     * <code>int32 success_point_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessPointCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      successPointCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.monitoring.v3.CreateTimeSeriesSummary.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        errors_ =
            new java.util.ArrayList<com.google.monitoring.v3.CreateTimeSeriesSummary.Error>(
                errors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.CreateTimeSeriesSummary.Error,
            com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder,
            com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public java.util.List<com.google.monitoring.v3.CreateTimeSeriesSummary.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public com.google.monitoring.v3.CreateTimeSeriesSummary.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder setErrors(
        int index, com.google.monitoring.v3.CreateTimeSeriesSummary.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder setErrors(
        int index, com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder addErrors(com.google.monitoring.v3.CreateTimeSeriesSummary.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder addErrors(
        int index, com.google.monitoring.v3.CreateTimeSeriesSummary.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder addErrors(
        com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder addErrors(
        int index, com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.monitoring.v3.CreateTimeSeriesSummary.Error>
            values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder getErrorsBuilder(
        int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder getErrorsOrBuilder(
        int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.monitoring.v3.CreateTimeSeriesSummary.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder addErrorsBuilder(
        int index) {
      return getErrorsFieldBuilder()
          .addBuilder(
              index, com.google.monitoring.v3.CreateTimeSeriesSummary.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The number of points that failed to be written. Order is not guaranteed.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.CreateTimeSeriesSummary.Error errors = 3;</code>
     */
    public java.util.List<com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder>
        getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.CreateTimeSeriesSummary.Error,
            com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder,
            com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.CreateTimeSeriesSummary.Error,
                com.google.monitoring.v3.CreateTimeSeriesSummary.Error.Builder,
                com.google.monitoring.v3.CreateTimeSeriesSummary.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.CreateTimeSeriesSummary)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.CreateTimeSeriesSummary)
  private static final com.google.monitoring.v3.CreateTimeSeriesSummary DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.CreateTimeSeriesSummary();
  }

  public static com.google.monitoring.v3.CreateTimeSeriesSummary getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateTimeSeriesSummary> PARSER =
      new com.google.protobuf.AbstractParser<CreateTimeSeriesSummary>() {
        @java.lang.Override
        public CreateTimeSeriesSummary parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateTimeSeriesSummary> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateTimeSeriesSummary> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.CreateTimeSeriesSummary getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
