/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/group_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The `ListGroup` request.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.ListGroupsRequest}
 */
public final class ListGroupsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.ListGroupsRequest)
    ListGroupsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListGroupsRequest.newBuilder() to construct.
  private ListGroupsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListGroupsRequest() {
    name_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListGroupsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.GroupServiceProto
        .internal_static_google_monitoring_v3_ListGroupsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.GroupServiceProto
        .internal_static_google_monitoring_v3_ListGroupsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.ListGroupsRequest.class,
            com.google.monitoring.v3.ListGroupsRequest.Builder.class);
  }

  private int filterCase_ = 0;
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHILDREN_OF_GROUP(2),
    ANCESTORS_OF_GROUP(3),
    DESCENDANTS_OF_GROUP(4),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 2:
          return CHILDREN_OF_GROUP;
        case 3:
          return ANCESTORS_OF_GROUP;
        case 4:
          return DESCENDANTS_OF_GROUP;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  public static final int NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
   * whose groups are to be listed. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]
   * </pre>
   *
   * <code>
   * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
   * whose groups are to be listed. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]
   * </pre>
   *
   * <code>
   * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHILDREN_OF_GROUP_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns groups whose `parent_name` field contains the group
   * name.  If no groups have this parent, the results are empty.
   * </pre>
   *
   * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the childrenOfGroup field is set.
   */
  public boolean hasChildrenOfGroup() {
    return filterCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns groups whose `parent_name` field contains the group
   * name.  If no groups have this parent, the results are empty.
   * </pre>
   *
   * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The childrenOfGroup.
   */
  public java.lang.String getChildrenOfGroup() {
    java.lang.Object ref = "";
    if (filterCase_ == 2) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (filterCase_ == 2) {
        filter_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns groups whose `parent_name` field contains the group
   * name.  If no groups have this parent, the results are empty.
   * </pre>
   *
   * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for childrenOfGroup.
   */
  public com.google.protobuf.ByteString getChildrenOfGroupBytes() {
    java.lang.Object ref = "";
    if (filterCase_ == 2) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (filterCase_ == 2) {
        filter_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANCESTORS_OF_GROUP_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns groups that are ancestors of the specified group.
   * The groups are returned in order, starting with the immediate parent and
   * ending with the most distant ancestor.  If the specified group has no
   * immediate parent, the results are empty.
   * </pre>
   *
   * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the ancestorsOfGroup field is set.
   */
  public boolean hasAncestorsOfGroup() {
    return filterCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns groups that are ancestors of the specified group.
   * The groups are returned in order, starting with the immediate parent and
   * ending with the most distant ancestor.  If the specified group has no
   * immediate parent, the results are empty.
   * </pre>
   *
   * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The ancestorsOfGroup.
   */
  public java.lang.String getAncestorsOfGroup() {
    java.lang.Object ref = "";
    if (filterCase_ == 3) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (filterCase_ == 3) {
        filter_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns groups that are ancestors of the specified group.
   * The groups are returned in order, starting with the immediate parent and
   * ending with the most distant ancestor.  If the specified group has no
   * immediate parent, the results are empty.
   * </pre>
   *
   * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for ancestorsOfGroup.
   */
  public com.google.protobuf.ByteString getAncestorsOfGroupBytes() {
    java.lang.Object ref = "";
    if (filterCase_ == 3) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (filterCase_ == 3) {
        filter_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCENDANTS_OF_GROUP_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns the descendants of the specified group.  This is a superset of
   * the results returned by the `children_of_group` filter, and includes
   * children-of-children, and so forth.
   * </pre>
   *
   * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the descendantsOfGroup field is set.
   */
  public boolean hasDescendantsOfGroup() {
    return filterCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns the descendants of the specified group.  This is a superset of
   * the results returned by the `children_of_group` filter, and includes
   * children-of-children, and so forth.
   * </pre>
   *
   * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The descendantsOfGroup.
   */
  public java.lang.String getDescendantsOfGroup() {
    java.lang.Object ref = "";
    if (filterCase_ == 4) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (filterCase_ == 4) {
        filter_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A group name. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
   * Returns the descendants of the specified group.  This is a superset of
   * the results returned by the `children_of_group` filter, and includes
   * children-of-children, and so forth.
   * </pre>
   *
   * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for descendantsOfGroup.
   */
  public com.google.protobuf.ByteString getDescendantsOfGroupBytes() {
    java.lang.Object ref = "";
    if (filterCase_ == 4) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (filterCase_ == 4) {
        filter_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * A positive number that is the maximum number of results to return.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * If this field is not empty then it must contain the `next_page_token` value
   * returned by a previous call to this method.  Using this field causes the
   * method to return additional results from the previous method call.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If this field is not empty then it must contain the `next_page_token` value
   * returned by a previous call to this method.  Using this field causes the
   * method to return additional results from the previous method call.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (filterCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (filterCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    if (filterCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filter_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (filterCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (filterCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    if (filterCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, filter_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.ListGroupsRequest)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.ListGroupsRequest other =
        (com.google.monitoring.v3.ListGroupsRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 2:
        if (!getChildrenOfGroup().equals(other.getChildrenOfGroup())) return false;
        break;
      case 3:
        if (!getAncestorsOfGroup().equals(other.getAncestorsOfGroup())) return false;
        break;
      case 4:
        if (!getDescendantsOfGroup().equals(other.getDescendantsOfGroup())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    switch (filterCase_) {
      case 2:
        hash = (37 * hash) + CHILDREN_OF_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getChildrenOfGroup().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ANCESTORS_OF_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getAncestorsOfGroup().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DESCENDANTS_OF_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getDescendantsOfGroup().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListGroupsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.ListGroupsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `ListGroup` request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.ListGroupsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.ListGroupsRequest)
      com.google.monitoring.v3.ListGroupsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.GroupServiceProto
          .internal_static_google_monitoring_v3_ListGroupsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.GroupServiceProto
          .internal_static_google_monitoring_v3_ListGroupsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.ListGroupsRequest.class,
              com.google.monitoring.v3.ListGroupsRequest.Builder.class);
    }

    // Construct using com.google.monitoring.v3.ListGroupsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      filterCase_ = 0;
      filter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.GroupServiceProto
          .internal_static_google_monitoring_v3_ListGroupsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListGroupsRequest getDefaultInstanceForType() {
      return com.google.monitoring.v3.ListGroupsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListGroupsRequest build() {
      com.google.monitoring.v3.ListGroupsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListGroupsRequest buildPartial() {
      com.google.monitoring.v3.ListGroupsRequest result =
          new com.google.monitoring.v3.ListGroupsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.ListGroupsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pageToken_ = pageToken_;
      }
    }

    private void buildPartialOneofs(com.google.monitoring.v3.ListGroupsRequest result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.ListGroupsRequest) {
        return mergeFrom((com.google.monitoring.v3.ListGroupsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.ListGroupsRequest other) {
      if (other == com.google.monitoring.v3.ListGroupsRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getFilterCase()) {
        case CHILDREN_OF_GROUP:
          {
            filterCase_ = 2;
            filter_ = other.filter_;
            onChanged();
            break;
          }
        case ANCESTORS_OF_GROUP:
          {
            filterCase_ = 3;
            filter_ = other.filter_;
            onChanged();
            break;
          }
        case DESCENDANTS_OF_GROUP:
          {
            filterCase_ = 4;
            filter_ = other.filter_;
            onChanged();
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                filterCase_ = 2;
                filter_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                filterCase_ = 3;
                filter_ = s;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                filterCase_ = 4;
                filter_ = s;
                break;
              } // case 34
            case 40:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
     * whose groups are to be listed. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
     * whose groups are to be listed. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
     * whose groups are to be listed. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
     * whose groups are to be listed. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name)
     * whose groups are to be listed. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups whose `parent_name` field contains the group
     * name.  If no groups have this parent, the results are empty.
     * </pre>
     *
     * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the childrenOfGroup field is set.
     */
    @java.lang.Override
    public boolean hasChildrenOfGroup() {
      return filterCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups whose `parent_name` field contains the group
     * name.  If no groups have this parent, the results are empty.
     * </pre>
     *
     * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The childrenOfGroup.
     */
    @java.lang.Override
    public java.lang.String getChildrenOfGroup() {
      java.lang.Object ref = "";
      if (filterCase_ == 2) {
        ref = filter_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (filterCase_ == 2) {
          filter_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups whose `parent_name` field contains the group
     * name.  If no groups have this parent, the results are empty.
     * </pre>
     *
     * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for childrenOfGroup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getChildrenOfGroupBytes() {
      java.lang.Object ref = "";
      if (filterCase_ == 2) {
        ref = filter_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (filterCase_ == 2) {
          filter_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups whose `parent_name` field contains the group
     * name.  If no groups have this parent, the results are empty.
     * </pre>
     *
     * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The childrenOfGroup to set.
     * @return This builder for chaining.
     */
    public Builder setChildrenOfGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 2;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups whose `parent_name` field contains the group
     * name.  If no groups have this parent, the results are empty.
     * </pre>
     *
     * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChildrenOfGroup() {
      if (filterCase_ == 2) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups whose `parent_name` field contains the group
     * name.  If no groups have this parent, the results are empty.
     * </pre>
     *
     * <code>string children_of_group = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for childrenOfGroup to set.
     * @return This builder for chaining.
     */
    public Builder setChildrenOfGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterCase_ = 2;
      filter_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups that are ancestors of the specified group.
     * The groups are returned in order, starting with the immediate parent and
     * ending with the most distant ancestor.  If the specified group has no
     * immediate parent, the results are empty.
     * </pre>
     *
     * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the ancestorsOfGroup field is set.
     */
    @java.lang.Override
    public boolean hasAncestorsOfGroup() {
      return filterCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups that are ancestors of the specified group.
     * The groups are returned in order, starting with the immediate parent and
     * ending with the most distant ancestor.  If the specified group has no
     * immediate parent, the results are empty.
     * </pre>
     *
     * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The ancestorsOfGroup.
     */
    @java.lang.Override
    public java.lang.String getAncestorsOfGroup() {
      java.lang.Object ref = "";
      if (filterCase_ == 3) {
        ref = filter_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (filterCase_ == 3) {
          filter_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups that are ancestors of the specified group.
     * The groups are returned in order, starting with the immediate parent and
     * ending with the most distant ancestor.  If the specified group has no
     * immediate parent, the results are empty.
     * </pre>
     *
     * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for ancestorsOfGroup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAncestorsOfGroupBytes() {
      java.lang.Object ref = "";
      if (filterCase_ == 3) {
        ref = filter_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (filterCase_ == 3) {
          filter_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups that are ancestors of the specified group.
     * The groups are returned in order, starting with the immediate parent and
     * ending with the most distant ancestor.  If the specified group has no
     * immediate parent, the results are empty.
     * </pre>
     *
     * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The ancestorsOfGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAncestorsOfGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 3;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups that are ancestors of the specified group.
     * The groups are returned in order, starting with the immediate parent and
     * ending with the most distant ancestor.  If the specified group has no
     * immediate parent, the results are empty.
     * </pre>
     *
     * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAncestorsOfGroup() {
      if (filterCase_ == 3) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns groups that are ancestors of the specified group.
     * The groups are returned in order, starting with the immediate parent and
     * ending with the most distant ancestor.  If the specified group has no
     * immediate parent, the results are empty.
     * </pre>
     *
     * <code>string ancestors_of_group = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for ancestorsOfGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAncestorsOfGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterCase_ = 3;
      filter_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns the descendants of the specified group.  This is a superset of
     * the results returned by the `children_of_group` filter, and includes
     * children-of-children, and so forth.
     * </pre>
     *
     * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the descendantsOfGroup field is set.
     */
    @java.lang.Override
    public boolean hasDescendantsOfGroup() {
      return filterCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns the descendants of the specified group.  This is a superset of
     * the results returned by the `children_of_group` filter, and includes
     * children-of-children, and so forth.
     * </pre>
     *
     * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The descendantsOfGroup.
     */
    @java.lang.Override
    public java.lang.String getDescendantsOfGroup() {
      java.lang.Object ref = "";
      if (filterCase_ == 4) {
        ref = filter_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (filterCase_ == 4) {
          filter_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns the descendants of the specified group.  This is a superset of
     * the results returned by the `children_of_group` filter, and includes
     * children-of-children, and so forth.
     * </pre>
     *
     * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for descendantsOfGroup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescendantsOfGroupBytes() {
      java.lang.Object ref = "";
      if (filterCase_ == 4) {
        ref = filter_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (filterCase_ == 4) {
          filter_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns the descendants of the specified group.  This is a superset of
     * the results returned by the `children_of_group` filter, and includes
     * children-of-children, and so forth.
     * </pre>
     *
     * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The descendantsOfGroup to set.
     * @return This builder for chaining.
     */
    public Builder setDescendantsOfGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 4;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns the descendants of the specified group.  This is a superset of
     * the results returned by the `children_of_group` filter, and includes
     * children-of-children, and so forth.
     * </pre>
     *
     * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescendantsOfGroup() {
      if (filterCase_ == 4) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A group name. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
     * Returns the descendants of the specified group.  This is a superset of
     * the results returned by the `children_of_group` filter, and includes
     * children-of-children, and so forth.
     * </pre>
     *
     * <code>string descendants_of_group = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for descendantsOfGroup to set.
     * @return This builder for chaining.
     */
    public Builder setDescendantsOfGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterCase_ = 4;
      filter_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * A positive number that is the maximum number of results to return.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * A positive number that is the maximum number of results to return.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A positive number that is the maximum number of results to return.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000010);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `next_page_token` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `next_page_token` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `next_page_token` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `next_page_token` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is not empty then it must contain the `next_page_token` value
     * returned by a previous call to this method.  Using this field causes the
     * method to return additional results from the previous method call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.ListGroupsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.ListGroupsRequest)
  private static final com.google.monitoring.v3.ListGroupsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.ListGroupsRequest();
  }

  public static com.google.monitoring.v3.ListGroupsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListGroupsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListGroupsRequest>() {
        @java.lang.Override
        public ListGroupsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListGroupsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListGroupsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.ListGroupsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
