/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A `WindowsBasedSli` defines `good_service` as the count of time windows for
 * which the provided service was of good quality. Criteria for determining
 * if service was good are embedded in the `window_criterion`.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.WindowsBasedSli}
 */
public final class WindowsBasedSli extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.WindowsBasedSli)
    WindowsBasedSliOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WindowsBasedSli.newBuilder() to construct.
  private WindowsBasedSli(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WindowsBasedSli() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WindowsBasedSli();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_WindowsBasedSli_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_WindowsBasedSli_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.WindowsBasedSli.class,
            com.google.monitoring.v3.WindowsBasedSli.Builder.class);
  }

  public interface PerformanceThresholdOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * `RequestBasedSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
     *
     * @return Whether the performance field is set.
     */
    boolean hasPerformance();
    /**
     *
     *
     * <pre>
     * `RequestBasedSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
     *
     * @return The performance.
     */
    com.google.monitoring.v3.RequestBasedSli getPerformance();
    /**
     *
     *
     * <pre>
     * `RequestBasedSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
     */
    com.google.monitoring.v3.RequestBasedSliOrBuilder getPerformanceOrBuilder();

    /**
     *
     *
     * <pre>
     * `BasicSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
     *
     * @return Whether the basicSliPerformance field is set.
     */
    boolean hasBasicSliPerformance();
    /**
     *
     *
     * <pre>
     * `BasicSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
     *
     * @return The basicSliPerformance.
     */
    com.google.monitoring.v3.BasicSli getBasicSliPerformance();
    /**
     *
     *
     * <pre>
     * `BasicSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
     */
    com.google.monitoring.v3.BasicSliOrBuilder getBasicSliPerformanceOrBuilder();

    /**
     *
     *
     * <pre>
     * If window `performance &gt;= threshold`, the window is counted as good.
     * </pre>
     *
     * <code>double threshold = 2;</code>
     *
     * @return The threshold.
     */
    double getThreshold();

    public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.TypeCase getTypeCase();
  }
  /**
   *
   *
   * <pre>
   * A `PerformanceThreshold` is used when each window is good when that window
   * has a sufficiently high `performance`.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.WindowsBasedSli.PerformanceThreshold}
   */
  public static final class PerformanceThreshold extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)
      PerformanceThresholdOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PerformanceThreshold.newBuilder() to construct.
    private PerformanceThreshold(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PerformanceThreshold() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PerformanceThreshold();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_PerformanceThreshold_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_PerformanceThreshold_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.class,
              com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder.class);
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public enum TypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PERFORMANCE(1),
      BASIC_SLI_PERFORMANCE(3),
      TYPE_NOT_SET(0);
      private final int value;

      private TypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static TypeCase forNumber(int value) {
        switch (value) {
          case 1:
            return PERFORMANCE;
          case 3:
            return BASIC_SLI_PERFORMANCE;
          case 0:
            return TYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public static final int PERFORMANCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * `RequestBasedSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
     *
     * @return Whether the performance field is set.
     */
    @java.lang.Override
    public boolean hasPerformance() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * `RequestBasedSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
     *
     * @return The performance.
     */
    @java.lang.Override
    public com.google.monitoring.v3.RequestBasedSli getPerformance() {
      if (typeCase_ == 1) {
        return (com.google.monitoring.v3.RequestBasedSli) type_;
      }
      return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * `RequestBasedSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.RequestBasedSliOrBuilder getPerformanceOrBuilder() {
      if (typeCase_ == 1) {
        return (com.google.monitoring.v3.RequestBasedSli) type_;
      }
      return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
    }

    public static final int BASIC_SLI_PERFORMANCE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * `BasicSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
     *
     * @return Whether the basicSliPerformance field is set.
     */
    @java.lang.Override
    public boolean hasBasicSliPerformance() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * `BasicSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
     *
     * @return The basicSliPerformance.
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSli getBasicSliPerformance() {
      if (typeCase_ == 3) {
        return (com.google.monitoring.v3.BasicSli) type_;
      }
      return com.google.monitoring.v3.BasicSli.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * `BasicSli` to evaluate to judge window quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSliOrBuilder getBasicSliPerformanceOrBuilder() {
      if (typeCase_ == 3) {
        return (com.google.monitoring.v3.BasicSli) type_;
      }
      return com.google.monitoring.v3.BasicSli.getDefaultInstance();
    }

    public static final int THRESHOLD_FIELD_NUMBER = 2;
    private double threshold_ = 0D;
    /**
     *
     *
     * <pre>
     * If window `performance &gt;= threshold`, the window is counted as good.
     * </pre>
     *
     * <code>double threshold = 2;</code>
     *
     * @return The threshold.
     */
    @java.lang.Override
    public double getThreshold() {
      return threshold_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (typeCase_ == 1) {
        output.writeMessage(1, (com.google.monitoring.v3.RequestBasedSli) type_);
      }
      if (java.lang.Double.doubleToRawLongBits(threshold_) != 0) {
        output.writeDouble(2, threshold_);
      }
      if (typeCase_ == 3) {
        output.writeMessage(3, (com.google.monitoring.v3.BasicSli) type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (typeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.monitoring.v3.RequestBasedSli) type_);
      }
      if (java.lang.Double.doubleToRawLongBits(threshold_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, threshold_);
      }
      if (typeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.monitoring.v3.BasicSli) type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold other =
          (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) obj;

      if (java.lang.Double.doubleToLongBits(getThreshold())
          != java.lang.Double.doubleToLongBits(other.getThreshold())) return false;
      if (!getTypeCase().equals(other.getTypeCase())) return false;
      switch (typeCase_) {
        case 1:
          if (!getPerformance().equals(other.getPerformance())) return false;
          break;
        case 3:
          if (!getBasicSliPerformance().equals(other.getBasicSliPerformance())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + THRESHOLD_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getThreshold()));
      switch (typeCase_) {
        case 1:
          hash = (37 * hash) + PERFORMANCE_FIELD_NUMBER;
          hash = (53 * hash) + getPerformance().hashCode();
          break;
        case 3:
          hash = (37 * hash) + BASIC_SLI_PERFORMANCE_FIELD_NUMBER;
          hash = (53 * hash) + getBasicSliPerformance().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A `PerformanceThreshold` is used when each window is good when that window
     * has a sufficiently high `performance`.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.WindowsBasedSli.PerformanceThreshold}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThresholdOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_WindowsBasedSli_PerformanceThreshold_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_WindowsBasedSli_PerformanceThreshold_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.class,
                com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder.class);
      }

      // Construct using com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (performanceBuilder_ != null) {
          performanceBuilder_.clear();
        }
        if (basicSliPerformanceBuilder_ != null) {
          basicSliPerformanceBuilder_.clear();
        }
        threshold_ = 0D;
        typeCase_ = 0;
        type_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_WindowsBasedSli_PerformanceThreshold_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
          getDefaultInstanceForType() {
        return com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold build() {
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold buildPartial() {
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold result =
            new com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.threshold_ = threshold_;
        }
      }

      private void buildPartialOneofs(
          com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold result) {
        result.typeCase_ = typeCase_;
        result.type_ = this.type_;
        if (typeCase_ == 1 && performanceBuilder_ != null) {
          result.type_ = performanceBuilder_.build();
        }
        if (typeCase_ == 3 && basicSliPerformanceBuilder_ != null) {
          result.type_ = basicSliPerformanceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) {
          return mergeFrom((com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold other) {
        if (other
            == com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance())
          return this;
        if (other.getThreshold() != 0D) {
          setThreshold(other.getThreshold());
        }
        switch (other.getTypeCase()) {
          case PERFORMANCE:
            {
              mergePerformance(other.getPerformance());
              break;
            }
          case BASIC_SLI_PERFORMANCE:
            {
              mergeBasicSliPerformance(other.getBasicSliPerformance());
              break;
            }
          case TYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPerformanceFieldBuilder().getBuilder(), extensionRegistry);
                  typeCase_ = 1;
                  break;
                } // case 10
              case 17:
                {
                  threshold_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 17
              case 26:
                {
                  input.readMessage(
                      getBasicSliPerformanceFieldBuilder().getBuilder(), extensionRegistry);
                  typeCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int typeCase_ = 0;
      private java.lang.Object type_;

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public Builder clearType() {
        typeCase_ = 0;
        type_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.RequestBasedSli,
              com.google.monitoring.v3.RequestBasedSli.Builder,
              com.google.monitoring.v3.RequestBasedSliOrBuilder>
          performanceBuilder_;
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       *
       * @return Whether the performance field is set.
       */
      @java.lang.Override
      public boolean hasPerformance() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       *
       * @return The performance.
       */
      @java.lang.Override
      public com.google.monitoring.v3.RequestBasedSli getPerformance() {
        if (performanceBuilder_ == null) {
          if (typeCase_ == 1) {
            return (com.google.monitoring.v3.RequestBasedSli) type_;
          }
          return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
        } else {
          if (typeCase_ == 1) {
            return performanceBuilder_.getMessage();
          }
          return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      public Builder setPerformance(com.google.monitoring.v3.RequestBasedSli value) {
        if (performanceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          performanceBuilder_.setMessage(value);
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      public Builder setPerformance(
          com.google.monitoring.v3.RequestBasedSli.Builder builderForValue) {
        if (performanceBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          performanceBuilder_.setMessage(builderForValue.build());
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      public Builder mergePerformance(com.google.monitoring.v3.RequestBasedSli value) {
        if (performanceBuilder_ == null) {
          if (typeCase_ == 1
              && type_ != com.google.monitoring.v3.RequestBasedSli.getDefaultInstance()) {
            type_ =
                com.google.monitoring.v3.RequestBasedSli.newBuilder(
                        (com.google.monitoring.v3.RequestBasedSli) type_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          if (typeCase_ == 1) {
            performanceBuilder_.mergeFrom(value);
          } else {
            performanceBuilder_.setMessage(value);
          }
        }
        typeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      public Builder clearPerformance() {
        if (performanceBuilder_ == null) {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
        } else {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
          }
          performanceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      public com.google.monitoring.v3.RequestBasedSli.Builder getPerformanceBuilder() {
        return getPerformanceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.RequestBasedSliOrBuilder getPerformanceOrBuilder() {
        if ((typeCase_ == 1) && (performanceBuilder_ != null)) {
          return performanceBuilder_.getMessageOrBuilder();
        } else {
          if (typeCase_ == 1) {
            return (com.google.monitoring.v3.RequestBasedSli) type_;
          }
          return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * `RequestBasedSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.RequestBasedSli performance = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.RequestBasedSli,
              com.google.monitoring.v3.RequestBasedSli.Builder,
              com.google.monitoring.v3.RequestBasedSliOrBuilder>
          getPerformanceFieldBuilder() {
        if (performanceBuilder_ == null) {
          if (!(typeCase_ == 1)) {
            type_ = com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
          }
          performanceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.RequestBasedSli,
                  com.google.monitoring.v3.RequestBasedSli.Builder,
                  com.google.monitoring.v3.RequestBasedSliOrBuilder>(
                  (com.google.monitoring.v3.RequestBasedSli) type_,
                  getParentForChildren(),
                  isClean());
          type_ = null;
        }
        typeCase_ = 1;
        onChanged();
        return performanceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.BasicSli,
              com.google.monitoring.v3.BasicSli.Builder,
              com.google.monitoring.v3.BasicSliOrBuilder>
          basicSliPerformanceBuilder_;
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       *
       * @return Whether the basicSliPerformance field is set.
       */
      @java.lang.Override
      public boolean hasBasicSliPerformance() {
        return typeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       *
       * @return The basicSliPerformance.
       */
      @java.lang.Override
      public com.google.monitoring.v3.BasicSli getBasicSliPerformance() {
        if (basicSliPerformanceBuilder_ == null) {
          if (typeCase_ == 3) {
            return (com.google.monitoring.v3.BasicSli) type_;
          }
          return com.google.monitoring.v3.BasicSli.getDefaultInstance();
        } else {
          if (typeCase_ == 3) {
            return basicSliPerformanceBuilder_.getMessage();
          }
          return com.google.monitoring.v3.BasicSli.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      public Builder setBasicSliPerformance(com.google.monitoring.v3.BasicSli value) {
        if (basicSliPerformanceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          basicSliPerformanceBuilder_.setMessage(value);
        }
        typeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      public Builder setBasicSliPerformance(
          com.google.monitoring.v3.BasicSli.Builder builderForValue) {
        if (basicSliPerformanceBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          basicSliPerformanceBuilder_.setMessage(builderForValue.build());
        }
        typeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      public Builder mergeBasicSliPerformance(com.google.monitoring.v3.BasicSli value) {
        if (basicSliPerformanceBuilder_ == null) {
          if (typeCase_ == 3 && type_ != com.google.monitoring.v3.BasicSli.getDefaultInstance()) {
            type_ =
                com.google.monitoring.v3.BasicSli.newBuilder(
                        (com.google.monitoring.v3.BasicSli) type_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          if (typeCase_ == 3) {
            basicSliPerformanceBuilder_.mergeFrom(value);
          } else {
            basicSliPerformanceBuilder_.setMessage(value);
          }
        }
        typeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      public Builder clearBasicSliPerformance() {
        if (basicSliPerformanceBuilder_ == null) {
          if (typeCase_ == 3) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
        } else {
          if (typeCase_ == 3) {
            typeCase_ = 0;
            type_ = null;
          }
          basicSliPerformanceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      public com.google.monitoring.v3.BasicSli.Builder getBasicSliPerformanceBuilder() {
        return getBasicSliPerformanceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.BasicSliOrBuilder getBasicSliPerformanceOrBuilder() {
        if ((typeCase_ == 3) && (basicSliPerformanceBuilder_ != null)) {
          return basicSliPerformanceBuilder_.getMessageOrBuilder();
        } else {
          if (typeCase_ == 3) {
            return (com.google.monitoring.v3.BasicSli) type_;
          }
          return com.google.monitoring.v3.BasicSli.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * `BasicSli` to evaluate to judge window quality.
       * </pre>
       *
       * <code>.google.monitoring.v3.BasicSli basic_sli_performance = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.BasicSli,
              com.google.monitoring.v3.BasicSli.Builder,
              com.google.monitoring.v3.BasicSliOrBuilder>
          getBasicSliPerformanceFieldBuilder() {
        if (basicSliPerformanceBuilder_ == null) {
          if (!(typeCase_ == 3)) {
            type_ = com.google.monitoring.v3.BasicSli.getDefaultInstance();
          }
          basicSliPerformanceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.BasicSli,
                  com.google.monitoring.v3.BasicSli.Builder,
                  com.google.monitoring.v3.BasicSliOrBuilder>(
                  (com.google.monitoring.v3.BasicSli) type_, getParentForChildren(), isClean());
          type_ = null;
        }
        typeCase_ = 3;
        onChanged();
        return basicSliPerformanceBuilder_;
      }

      private double threshold_;
      /**
       *
       *
       * <pre>
       * If window `performance &gt;= threshold`, the window is counted as good.
       * </pre>
       *
       * <code>double threshold = 2;</code>
       *
       * @return The threshold.
       */
      @java.lang.Override
      public double getThreshold() {
        return threshold_;
      }
      /**
       *
       *
       * <pre>
       * If window `performance &gt;= threshold`, the window is counted as good.
       * </pre>
       *
       * <code>double threshold = 2;</code>
       *
       * @param value The threshold to set.
       * @return This builder for chaining.
       */
      public Builder setThreshold(double value) {

        threshold_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If window `performance &gt;= threshold`, the window is counted as good.
       * </pre>
       *
       * <code>double threshold = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearThreshold() {
        bitField0_ = (bitField0_ & ~0x00000004);
        threshold_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)
    private static final com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold();
    }

    public static com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PerformanceThreshold> PARSER =
        new com.google.protobuf.AbstractParser<PerformanceThreshold>() {
          @java.lang.Override
          public PerformanceThreshold parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PerformanceThreshold> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PerformanceThreshold> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MetricRangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.WindowsBasedSli.MetricRange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying the `TimeSeries` to use for evaluating window quality.
     * </pre>
     *
     * <code>string time_series = 1;</code>
     *
     * @return The timeSeries.
     */
    java.lang.String getTimeSeries();
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying the `TimeSeries` to use for evaluating window quality.
     * </pre>
     *
     * <code>string time_series = 1;</code>
     *
     * @return The bytes for timeSeries.
     */
    com.google.protobuf.ByteString getTimeSeriesBytes();

    /**
     *
     *
     * <pre>
     * Range of values considered "good." For a one-sided range, set one bound
     * to an infinite value.
     * </pre>
     *
     * <code>.google.monitoring.v3.Range range = 4;</code>
     *
     * @return Whether the range field is set.
     */
    boolean hasRange();
    /**
     *
     *
     * <pre>
     * Range of values considered "good." For a one-sided range, set one bound
     * to an infinite value.
     * </pre>
     *
     * <code>.google.monitoring.v3.Range range = 4;</code>
     *
     * @return The range.
     */
    com.google.monitoring.v3.Range getRange();
    /**
     *
     *
     * <pre>
     * Range of values considered "good." For a one-sided range, set one bound
     * to an infinite value.
     * </pre>
     *
     * <code>.google.monitoring.v3.Range range = 4;</code>
     */
    com.google.monitoring.v3.RangeOrBuilder getRangeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A `MetricRange` is used when each window is good when the value x of a
   * single `TimeSeries` satisfies `range.min &lt;= x &lt;= range.max`. The provided
   * `TimeSeries` must have `ValueType = INT64` or `ValueType = DOUBLE` and
   * `MetricKind = GAUGE`.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.WindowsBasedSli.MetricRange}
   */
  public static final class MetricRange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.WindowsBasedSli.MetricRange)
      MetricRangeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MetricRange.newBuilder() to construct.
    private MetricRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MetricRange() {
      timeSeries_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MetricRange();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_MetricRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_MetricRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.WindowsBasedSli.MetricRange.class,
              com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder.class);
    }

    public static final int TIME_SERIES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object timeSeries_ = "";
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying the `TimeSeries` to use for evaluating window quality.
     * </pre>
     *
     * <code>string time_series = 1;</code>
     *
     * @return The timeSeries.
     */
    @java.lang.Override
    public java.lang.String getTimeSeries() {
      java.lang.Object ref = timeSeries_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeSeries_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying the `TimeSeries` to use for evaluating window quality.
     * </pre>
     *
     * <code>string time_series = 1;</code>
     *
     * @return The bytes for timeSeries.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTimeSeriesBytes() {
      java.lang.Object ref = timeSeries_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeSeries_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RANGE_FIELD_NUMBER = 4;
    private com.google.monitoring.v3.Range range_;
    /**
     *
     *
     * <pre>
     * Range of values considered "good." For a one-sided range, set one bound
     * to an infinite value.
     * </pre>
     *
     * <code>.google.monitoring.v3.Range range = 4;</code>
     *
     * @return Whether the range field is set.
     */
    @java.lang.Override
    public boolean hasRange() {
      return range_ != null;
    }
    /**
     *
     *
     * <pre>
     * Range of values considered "good." For a one-sided range, set one bound
     * to an infinite value.
     * </pre>
     *
     * <code>.google.monitoring.v3.Range range = 4;</code>
     *
     * @return The range.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Range getRange() {
      return range_ == null ? com.google.monitoring.v3.Range.getDefaultInstance() : range_;
    }
    /**
     *
     *
     * <pre>
     * Range of values considered "good." For a one-sided range, set one bound
     * to an infinite value.
     * </pre>
     *
     * <code>.google.monitoring.v3.Range range = 4;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.RangeOrBuilder getRangeOrBuilder() {
      return range_ == null ? com.google.monitoring.v3.Range.getDefaultInstance() : range_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeSeries_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, timeSeries_);
      }
      if (range_ != null) {
        output.writeMessage(4, getRange());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeSeries_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, timeSeries_);
      }
      if (range_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRange());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.WindowsBasedSli.MetricRange)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.WindowsBasedSli.MetricRange other =
          (com.google.monitoring.v3.WindowsBasedSli.MetricRange) obj;

      if (!getTimeSeries().equals(other.getTimeSeries())) return false;
      if (hasRange() != other.hasRange()) return false;
      if (hasRange()) {
        if (!getRange().equals(other.getRange())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TIME_SERIES_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSeries().hashCode();
      if (hasRange()) {
        hash = (37 * hash) + RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getRange().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.WindowsBasedSli.MetricRange prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A `MetricRange` is used when each window is good when the value x of a
     * single `TimeSeries` satisfies `range.min &lt;= x &lt;= range.max`. The provided
     * `TimeSeries` must have `ValueType = INT64` or `ValueType = DOUBLE` and
     * `MetricKind = GAUGE`.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.WindowsBasedSli.MetricRange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.WindowsBasedSli.MetricRange)
        com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_WindowsBasedSli_MetricRange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_WindowsBasedSli_MetricRange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.WindowsBasedSli.MetricRange.class,
                com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder.class);
      }

      // Construct using com.google.monitoring.v3.WindowsBasedSli.MetricRange.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timeSeries_ = "";
        range_ = null;
        if (rangeBuilder_ != null) {
          rangeBuilder_.dispose();
          rangeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_WindowsBasedSli_MetricRange_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.WindowsBasedSli.MetricRange getDefaultInstanceForType() {
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.WindowsBasedSli.MetricRange build() {
        com.google.monitoring.v3.WindowsBasedSli.MetricRange result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.WindowsBasedSli.MetricRange buildPartial() {
        com.google.monitoring.v3.WindowsBasedSli.MetricRange result =
            new com.google.monitoring.v3.WindowsBasedSli.MetricRange(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.WindowsBasedSli.MetricRange result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timeSeries_ = timeSeries_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.range_ = rangeBuilder_ == null ? range_ : rangeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.WindowsBasedSli.MetricRange) {
          return mergeFrom((com.google.monitoring.v3.WindowsBasedSli.MetricRange) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.WindowsBasedSli.MetricRange other) {
        if (other == com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance())
          return this;
        if (!other.getTimeSeries().isEmpty()) {
          timeSeries_ = other.timeSeries_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasRange()) {
          mergeRange(other.getRange());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  timeSeries_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 34:
                {
                  input.readMessage(getRangeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object timeSeries_ = "";
      /**
       *
       *
       * <pre>
       * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
       * specifying the `TimeSeries` to use for evaluating window quality.
       * </pre>
       *
       * <code>string time_series = 1;</code>
       *
       * @return The timeSeries.
       */
      public java.lang.String getTimeSeries() {
        java.lang.Object ref = timeSeries_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          timeSeries_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
       * specifying the `TimeSeries` to use for evaluating window quality.
       * </pre>
       *
       * <code>string time_series = 1;</code>
       *
       * @return The bytes for timeSeries.
       */
      public com.google.protobuf.ByteString getTimeSeriesBytes() {
        java.lang.Object ref = timeSeries_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          timeSeries_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
       * specifying the `TimeSeries` to use for evaluating window quality.
       * </pre>
       *
       * <code>string time_series = 1;</code>
       *
       * @param value The timeSeries to set.
       * @return This builder for chaining.
       */
      public Builder setTimeSeries(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSeries_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
       * specifying the `TimeSeries` to use for evaluating window quality.
       * </pre>
       *
       * <code>string time_series = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTimeSeries() {
        timeSeries_ = getDefaultInstance().getTimeSeries();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
       * specifying the `TimeSeries` to use for evaluating window quality.
       * </pre>
       *
       * <code>string time_series = 1;</code>
       *
       * @param value The bytes for timeSeries to set.
       * @return This builder for chaining.
       */
      public Builder setTimeSeriesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        timeSeries_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.monitoring.v3.Range range_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.Range,
              com.google.monitoring.v3.Range.Builder,
              com.google.monitoring.v3.RangeOrBuilder>
          rangeBuilder_;
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       *
       * @return Whether the range field is set.
       */
      public boolean hasRange() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       *
       * @return The range.
       */
      public com.google.monitoring.v3.Range getRange() {
        if (rangeBuilder_ == null) {
          return range_ == null ? com.google.monitoring.v3.Range.getDefaultInstance() : range_;
        } else {
          return rangeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      public Builder setRange(com.google.monitoring.v3.Range value) {
        if (rangeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          range_ = value;
        } else {
          rangeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      public Builder setRange(com.google.monitoring.v3.Range.Builder builderForValue) {
        if (rangeBuilder_ == null) {
          range_ = builderForValue.build();
        } else {
          rangeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      public Builder mergeRange(com.google.monitoring.v3.Range value) {
        if (rangeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && range_ != null
              && range_ != com.google.monitoring.v3.Range.getDefaultInstance()) {
            getRangeBuilder().mergeFrom(value);
          } else {
            range_ = value;
          }
        } else {
          rangeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      public Builder clearRange() {
        bitField0_ = (bitField0_ & ~0x00000002);
        range_ = null;
        if (rangeBuilder_ != null) {
          rangeBuilder_.dispose();
          rangeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      public com.google.monitoring.v3.Range.Builder getRangeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRangeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      public com.google.monitoring.v3.RangeOrBuilder getRangeOrBuilder() {
        if (rangeBuilder_ != null) {
          return rangeBuilder_.getMessageOrBuilder();
        } else {
          return range_ == null ? com.google.monitoring.v3.Range.getDefaultInstance() : range_;
        }
      }
      /**
       *
       *
       * <pre>
       * Range of values considered "good." For a one-sided range, set one bound
       * to an infinite value.
       * </pre>
       *
       * <code>.google.monitoring.v3.Range range = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.Range,
              com.google.monitoring.v3.Range.Builder,
              com.google.monitoring.v3.RangeOrBuilder>
          getRangeFieldBuilder() {
        if (rangeBuilder_ == null) {
          rangeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.Range,
                  com.google.monitoring.v3.Range.Builder,
                  com.google.monitoring.v3.RangeOrBuilder>(
                  getRange(), getParentForChildren(), isClean());
          range_ = null;
        }
        return rangeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.WindowsBasedSli.MetricRange)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.WindowsBasedSli.MetricRange)
    private static final com.google.monitoring.v3.WindowsBasedSli.MetricRange DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.WindowsBasedSli.MetricRange();
    }

    public static com.google.monitoring.v3.WindowsBasedSli.MetricRange getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MetricRange> PARSER =
        new com.google.protobuf.AbstractParser<MetricRange>() {
          @java.lang.Override
          public MetricRange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MetricRange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MetricRange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.MetricRange getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int windowCriterionCase_ = 0;
  private java.lang.Object windowCriterion_;

  public enum WindowCriterionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GOOD_BAD_METRIC_FILTER(5),
    GOOD_TOTAL_RATIO_THRESHOLD(2),
    METRIC_MEAN_IN_RANGE(6),
    METRIC_SUM_IN_RANGE(7),
    WINDOWCRITERION_NOT_SET(0);
    private final int value;

    private WindowCriterionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WindowCriterionCase valueOf(int value) {
      return forNumber(value);
    }

    public static WindowCriterionCase forNumber(int value) {
      switch (value) {
        case 5:
          return GOOD_BAD_METRIC_FILTER;
        case 2:
          return GOOD_TOTAL_RATIO_THRESHOLD;
        case 6:
          return METRIC_MEAN_IN_RANGE;
        case 7:
          return METRIC_SUM_IN_RANGE;
        case 0:
          return WINDOWCRITERION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public WindowCriterionCase getWindowCriterionCase() {
    return WindowCriterionCase.forNumber(windowCriterionCase_);
  }

  public static final int GOOD_BAD_METRIC_FILTER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
   * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
   * any `true` values appear in the window.
   * </pre>
   *
   * <code>string good_bad_metric_filter = 5;</code>
   *
   * @return Whether the goodBadMetricFilter field is set.
   */
  public boolean hasGoodBadMetricFilter() {
    return windowCriterionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
   * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
   * any `true` values appear in the window.
   * </pre>
   *
   * <code>string good_bad_metric_filter = 5;</code>
   *
   * @return The goodBadMetricFilter.
   */
  public java.lang.String getGoodBadMetricFilter() {
    java.lang.Object ref = "";
    if (windowCriterionCase_ == 5) {
      ref = windowCriterion_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (windowCriterionCase_ == 5) {
        windowCriterion_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
   * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
   * any `true` values appear in the window.
   * </pre>
   *
   * <code>string good_bad_metric_filter = 5;</code>
   *
   * @return The bytes for goodBadMetricFilter.
   */
  public com.google.protobuf.ByteString getGoodBadMetricFilterBytes() {
    java.lang.Object ref = "";
    if (windowCriterionCase_ == 5) {
      ref = windowCriterion_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (windowCriterionCase_ == 5) {
        windowCriterion_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOOD_TOTAL_RATIO_THRESHOLD_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A window is good if its `performance` is high enough.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
   * </code>
   *
   * @return Whether the goodTotalRatioThreshold field is set.
   */
  @java.lang.Override
  public boolean hasGoodTotalRatioThreshold() {
    return windowCriterionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A window is good if its `performance` is high enough.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
   * </code>
   *
   * @return The goodTotalRatioThreshold.
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
      getGoodTotalRatioThreshold() {
    if (windowCriterionCase_ == 2) {
      return (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A window is good if its `performance` is high enough.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli.PerformanceThresholdOrBuilder
      getGoodTotalRatioThresholdOrBuilder() {
    if (windowCriterionCase_ == 2) {
      return (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
  }

  public static final int METRIC_MEAN_IN_RANGE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A window is good if the metric's value is in a good range, averaged
   * across returned streams.
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
   *
   * @return Whether the metricMeanInRange field is set.
   */
  @java.lang.Override
  public boolean hasMetricMeanInRange() {
    return windowCriterionCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A window is good if the metric's value is in a good range, averaged
   * across returned streams.
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
   *
   * @return The metricMeanInRange.
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli.MetricRange getMetricMeanInRange() {
    if (windowCriterionCase_ == 6) {
      return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A window is good if the metric's value is in a good range, averaged
   * across returned streams.
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder
      getMetricMeanInRangeOrBuilder() {
    if (windowCriterionCase_ == 6) {
      return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
  }

  public static final int METRIC_SUM_IN_RANGE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * A window is good if the metric's value is in a good range, summed across
   * returned streams.
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
   *
   * @return Whether the metricSumInRange field is set.
   */
  @java.lang.Override
  public boolean hasMetricSumInRange() {
    return windowCriterionCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * A window is good if the metric's value is in a good range, summed across
   * returned streams.
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
   *
   * @return The metricSumInRange.
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli.MetricRange getMetricSumInRange() {
    if (windowCriterionCase_ == 7) {
      return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A window is good if the metric's value is in a good range, summed across
   * returned streams.
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder
      getMetricSumInRangeOrBuilder() {
    if (windowCriterionCase_ == 7) {
      return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
  }

  public static final int WINDOW_PERIOD_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration windowPeriod_;
  /**
   *
   *
   * <pre>
   * Duration over which window quality is evaluated. Must be an integer
   * fraction of a day and at least `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration window_period = 4;</code>
   *
   * @return Whether the windowPeriod field is set.
   */
  @java.lang.Override
  public boolean hasWindowPeriod() {
    return windowPeriod_ != null;
  }
  /**
   *
   *
   * <pre>
   * Duration over which window quality is evaluated. Must be an integer
   * fraction of a day and at least `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration window_period = 4;</code>
   *
   * @return The windowPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getWindowPeriod() {
    return windowPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : windowPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Duration over which window quality is evaluated. Must be an integer
   * fraction of a day and at least `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration window_period = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getWindowPeriodOrBuilder() {
    return windowPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : windowPeriod_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (windowCriterionCase_ == 2) {
      output.writeMessage(
          2, (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_);
    }
    if (windowPeriod_ != null) {
      output.writeMessage(4, getWindowPeriod());
    }
    if (windowCriterionCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, windowCriterion_);
    }
    if (windowCriterionCase_ == 6) {
      output.writeMessage(
          6, (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_);
    }
    if (windowCriterionCase_ == 7) {
      output.writeMessage(
          7, (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (windowCriterionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_);
    }
    if (windowPeriod_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getWindowPeriod());
    }
    if (windowCriterionCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, windowCriterion_);
    }
    if (windowCriterionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_);
    }
    if (windowCriterionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.WindowsBasedSli)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.WindowsBasedSli other = (com.google.monitoring.v3.WindowsBasedSli) obj;

    if (hasWindowPeriod() != other.hasWindowPeriod()) return false;
    if (hasWindowPeriod()) {
      if (!getWindowPeriod().equals(other.getWindowPeriod())) return false;
    }
    if (!getWindowCriterionCase().equals(other.getWindowCriterionCase())) return false;
    switch (windowCriterionCase_) {
      case 5:
        if (!getGoodBadMetricFilter().equals(other.getGoodBadMetricFilter())) return false;
        break;
      case 2:
        if (!getGoodTotalRatioThreshold().equals(other.getGoodTotalRatioThreshold())) return false;
        break;
      case 6:
        if (!getMetricMeanInRange().equals(other.getMetricMeanInRange())) return false;
        break;
      case 7:
        if (!getMetricSumInRange().equals(other.getMetricSumInRange())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasWindowPeriod()) {
      hash = (37 * hash) + WINDOW_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getWindowPeriod().hashCode();
    }
    switch (windowCriterionCase_) {
      case 5:
        hash = (37 * hash) + GOOD_BAD_METRIC_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getGoodBadMetricFilter().hashCode();
        break;
      case 2:
        hash = (37 * hash) + GOOD_TOTAL_RATIO_THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getGoodTotalRatioThreshold().hashCode();
        break;
      case 6:
        hash = (37 * hash) + METRIC_MEAN_IN_RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getMetricMeanInRange().hashCode();
        break;
      case 7:
        hash = (37 * hash) + METRIC_SUM_IN_RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getMetricSumInRange().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.WindowsBasedSli parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.WindowsBasedSli prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `WindowsBasedSli` defines `good_service` as the count of time windows for
   * which the provided service was of good quality. Criteria for determining
   * if service was good are embedded in the `window_criterion`.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.WindowsBasedSli}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.WindowsBasedSli)
      com.google.monitoring.v3.WindowsBasedSliOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.WindowsBasedSli.class,
              com.google.monitoring.v3.WindowsBasedSli.Builder.class);
    }

    // Construct using com.google.monitoring.v3.WindowsBasedSli.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (goodTotalRatioThresholdBuilder_ != null) {
        goodTotalRatioThresholdBuilder_.clear();
      }
      if (metricMeanInRangeBuilder_ != null) {
        metricMeanInRangeBuilder_.clear();
      }
      if (metricSumInRangeBuilder_ != null) {
        metricSumInRangeBuilder_.clear();
      }
      windowPeriod_ = null;
      if (windowPeriodBuilder_ != null) {
        windowPeriodBuilder_.dispose();
        windowPeriodBuilder_ = null;
      }
      windowCriterionCase_ = 0;
      windowCriterion_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_WindowsBasedSli_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli getDefaultInstanceForType() {
      return com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli build() {
      com.google.monitoring.v3.WindowsBasedSli result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli buildPartial() {
      com.google.monitoring.v3.WindowsBasedSli result =
          new com.google.monitoring.v3.WindowsBasedSli(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.WindowsBasedSli result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.windowPeriod_ =
            windowPeriodBuilder_ == null ? windowPeriod_ : windowPeriodBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.monitoring.v3.WindowsBasedSli result) {
      result.windowCriterionCase_ = windowCriterionCase_;
      result.windowCriterion_ = this.windowCriterion_;
      if (windowCriterionCase_ == 2 && goodTotalRatioThresholdBuilder_ != null) {
        result.windowCriterion_ = goodTotalRatioThresholdBuilder_.build();
      }
      if (windowCriterionCase_ == 6 && metricMeanInRangeBuilder_ != null) {
        result.windowCriterion_ = metricMeanInRangeBuilder_.build();
      }
      if (windowCriterionCase_ == 7 && metricSumInRangeBuilder_ != null) {
        result.windowCriterion_ = metricSumInRangeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.WindowsBasedSli) {
        return mergeFrom((com.google.monitoring.v3.WindowsBasedSli) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.WindowsBasedSli other) {
      if (other == com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance()) return this;
      if (other.hasWindowPeriod()) {
        mergeWindowPeriod(other.getWindowPeriod());
      }
      switch (other.getWindowCriterionCase()) {
        case GOOD_BAD_METRIC_FILTER:
          {
            windowCriterionCase_ = 5;
            windowCriterion_ = other.windowCriterion_;
            onChanged();
            break;
          }
        case GOOD_TOTAL_RATIO_THRESHOLD:
          {
            mergeGoodTotalRatioThreshold(other.getGoodTotalRatioThreshold());
            break;
          }
        case METRIC_MEAN_IN_RANGE:
          {
            mergeMetricMeanInRange(other.getMetricMeanInRange());
            break;
          }
        case METRIC_SUM_IN_RANGE:
          {
            mergeMetricSumInRange(other.getMetricSumInRange());
            break;
          }
        case WINDOWCRITERION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getGoodTotalRatioThresholdFieldBuilder().getBuilder(), extensionRegistry);
                windowCriterionCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getWindowPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                windowCriterionCase_ = 5;
                windowCriterion_ = s;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getMetricMeanInRangeFieldBuilder().getBuilder(), extensionRegistry);
                windowCriterionCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getMetricSumInRangeFieldBuilder().getBuilder(), extensionRegistry);
                windowCriterionCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int windowCriterionCase_ = 0;
    private java.lang.Object windowCriterion_;

    public WindowCriterionCase getWindowCriterionCase() {
      return WindowCriterionCase.forNumber(windowCriterionCase_);
    }

    public Builder clearWindowCriterion() {
      windowCriterionCase_ = 0;
      windowCriterion_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     * </pre>
     *
     * <code>string good_bad_metric_filter = 5;</code>
     *
     * @return Whether the goodBadMetricFilter field is set.
     */
    @java.lang.Override
    public boolean hasGoodBadMetricFilter() {
      return windowCriterionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     * </pre>
     *
     * <code>string good_bad_metric_filter = 5;</code>
     *
     * @return The goodBadMetricFilter.
     */
    @java.lang.Override
    public java.lang.String getGoodBadMetricFilter() {
      java.lang.Object ref = "";
      if (windowCriterionCase_ == 5) {
        ref = windowCriterion_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (windowCriterionCase_ == 5) {
          windowCriterion_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     * </pre>
     *
     * <code>string good_bad_metric_filter = 5;</code>
     *
     * @return The bytes for goodBadMetricFilter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGoodBadMetricFilterBytes() {
      java.lang.Object ref = "";
      if (windowCriterionCase_ == 5) {
        ref = windowCriterion_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (windowCriterionCase_ == 5) {
          windowCriterion_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     * </pre>
     *
     * <code>string good_bad_metric_filter = 5;</code>
     *
     * @param value The goodBadMetricFilter to set.
     * @return This builder for chaining.
     */
    public Builder setGoodBadMetricFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      windowCriterionCase_ = 5;
      windowCriterion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     * </pre>
     *
     * <code>string good_bad_metric_filter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoodBadMetricFilter() {
      if (windowCriterionCase_ == 5) {
        windowCriterionCase_ = 0;
        windowCriterion_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
     * specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
     * any `true` values appear in the window.
     * </pre>
     *
     * <code>string good_bad_metric_filter = 5;</code>
     *
     * @param value The bytes for goodBadMetricFilter to set.
     * @return This builder for chaining.
     */
    public Builder setGoodBadMetricFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      windowCriterionCase_ = 5;
      windowCriterion_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold,
            com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder,
            com.google.monitoring.v3.WindowsBasedSli.PerformanceThresholdOrBuilder>
        goodTotalRatioThresholdBuilder_;
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     *
     * @return Whether the goodTotalRatioThreshold field is set.
     */
    @java.lang.Override
    public boolean hasGoodTotalRatioThreshold() {
      return windowCriterionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     *
     * @return The goodTotalRatioThreshold.
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
        getGoodTotalRatioThreshold() {
      if (goodTotalRatioThresholdBuilder_ == null) {
        if (windowCriterionCase_ == 2) {
          return (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
      } else {
        if (windowCriterionCase_ == 2) {
          return goodTotalRatioThresholdBuilder_.getMessage();
        }
        return com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    public Builder setGoodTotalRatioThreshold(
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold value) {
      if (goodTotalRatioThresholdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        windowCriterion_ = value;
        onChanged();
      } else {
        goodTotalRatioThresholdBuilder_.setMessage(value);
      }
      windowCriterionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    public Builder setGoodTotalRatioThreshold(
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder builderForValue) {
      if (goodTotalRatioThresholdBuilder_ == null) {
        windowCriterion_ = builderForValue.build();
        onChanged();
      } else {
        goodTotalRatioThresholdBuilder_.setMessage(builderForValue.build());
      }
      windowCriterionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    public Builder mergeGoodTotalRatioThreshold(
        com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold value) {
      if (goodTotalRatioThresholdBuilder_ == null) {
        if (windowCriterionCase_ == 2
            && windowCriterion_
                != com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
                    .getDefaultInstance()) {
          windowCriterion_ =
              com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.newBuilder(
                      (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold)
                          windowCriterion_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          windowCriterion_ = value;
        }
        onChanged();
      } else {
        if (windowCriterionCase_ == 2) {
          goodTotalRatioThresholdBuilder_.mergeFrom(value);
        } else {
          goodTotalRatioThresholdBuilder_.setMessage(value);
        }
      }
      windowCriterionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    public Builder clearGoodTotalRatioThreshold() {
      if (goodTotalRatioThresholdBuilder_ == null) {
        if (windowCriterionCase_ == 2) {
          windowCriterionCase_ = 0;
          windowCriterion_ = null;
          onChanged();
        }
      } else {
        if (windowCriterionCase_ == 2) {
          windowCriterionCase_ = 0;
          windowCriterion_ = null;
        }
        goodTotalRatioThresholdBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    public com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder
        getGoodTotalRatioThresholdBuilder() {
      return getGoodTotalRatioThresholdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.PerformanceThresholdOrBuilder
        getGoodTotalRatioThresholdOrBuilder() {
      if ((windowCriterionCase_ == 2) && (goodTotalRatioThresholdBuilder_ != null)) {
        return goodTotalRatioThresholdBuilder_.getMessageOrBuilder();
      } else {
        if (windowCriterionCase_ == 2) {
          return (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A window is good if its `performance` is high enough.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.WindowsBasedSli.PerformanceThreshold good_total_ratio_threshold = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold,
            com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder,
            com.google.monitoring.v3.WindowsBasedSli.PerformanceThresholdOrBuilder>
        getGoodTotalRatioThresholdFieldBuilder() {
      if (goodTotalRatioThresholdBuilder_ == null) {
        if (!(windowCriterionCase_ == 2)) {
          windowCriterion_ =
              com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.getDefaultInstance();
        }
        goodTotalRatioThresholdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold,
                com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.Builder,
                com.google.monitoring.v3.WindowsBasedSli.PerformanceThresholdOrBuilder>(
                (com.google.monitoring.v3.WindowsBasedSli.PerformanceThreshold) windowCriterion_,
                getParentForChildren(),
                isClean());
        windowCriterion_ = null;
      }
      windowCriterionCase_ = 2;
      onChanged();
      return goodTotalRatioThresholdBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli.MetricRange,
            com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder,
            com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder>
        metricMeanInRangeBuilder_;
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     *
     * @return Whether the metricMeanInRange field is set.
     */
    @java.lang.Override
    public boolean hasMetricMeanInRange() {
      return windowCriterionCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     *
     * @return The metricMeanInRange.
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.MetricRange getMetricMeanInRange() {
      if (metricMeanInRangeBuilder_ == null) {
        if (windowCriterionCase_ == 6) {
          return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      } else {
        if (windowCriterionCase_ == 6) {
          return metricMeanInRangeBuilder_.getMessage();
        }
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    public Builder setMetricMeanInRange(
        com.google.monitoring.v3.WindowsBasedSli.MetricRange value) {
      if (metricMeanInRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        windowCriterion_ = value;
        onChanged();
      } else {
        metricMeanInRangeBuilder_.setMessage(value);
      }
      windowCriterionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    public Builder setMetricMeanInRange(
        com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder builderForValue) {
      if (metricMeanInRangeBuilder_ == null) {
        windowCriterion_ = builderForValue.build();
        onChanged();
      } else {
        metricMeanInRangeBuilder_.setMessage(builderForValue.build());
      }
      windowCriterionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    public Builder mergeMetricMeanInRange(
        com.google.monitoring.v3.WindowsBasedSli.MetricRange value) {
      if (metricMeanInRangeBuilder_ == null) {
        if (windowCriterionCase_ == 6
            && windowCriterion_
                != com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance()) {
          windowCriterion_ =
              com.google.monitoring.v3.WindowsBasedSli.MetricRange.newBuilder(
                      (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          windowCriterion_ = value;
        }
        onChanged();
      } else {
        if (windowCriterionCase_ == 6) {
          metricMeanInRangeBuilder_.mergeFrom(value);
        } else {
          metricMeanInRangeBuilder_.setMessage(value);
        }
      }
      windowCriterionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    public Builder clearMetricMeanInRange() {
      if (metricMeanInRangeBuilder_ == null) {
        if (windowCriterionCase_ == 6) {
          windowCriterionCase_ = 0;
          windowCriterion_ = null;
          onChanged();
        }
      } else {
        if (windowCriterionCase_ == 6) {
          windowCriterionCase_ = 0;
          windowCriterion_ = null;
        }
        metricMeanInRangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    public com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder
        getMetricMeanInRangeBuilder() {
      return getMetricMeanInRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder
        getMetricMeanInRangeOrBuilder() {
      if ((windowCriterionCase_ == 6) && (metricMeanInRangeBuilder_ != null)) {
        return metricMeanInRangeBuilder_.getMessageOrBuilder();
      } else {
        if (windowCriterionCase_ == 6) {
          return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, averaged
     * across returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_mean_in_range = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli.MetricRange,
            com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder,
            com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder>
        getMetricMeanInRangeFieldBuilder() {
      if (metricMeanInRangeBuilder_ == null) {
        if (!(windowCriterionCase_ == 6)) {
          windowCriterion_ =
              com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
        }
        metricMeanInRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.WindowsBasedSli.MetricRange,
                com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder,
                com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder>(
                (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_,
                getParentForChildren(),
                isClean());
        windowCriterion_ = null;
      }
      windowCriterionCase_ = 6;
      onChanged();
      return metricMeanInRangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli.MetricRange,
            com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder,
            com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder>
        metricSumInRangeBuilder_;
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     *
     * @return Whether the metricSumInRange field is set.
     */
    @java.lang.Override
    public boolean hasMetricSumInRange() {
      return windowCriterionCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     *
     * @return The metricSumInRange.
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.MetricRange getMetricSumInRange() {
      if (metricSumInRangeBuilder_ == null) {
        if (windowCriterionCase_ == 7) {
          return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      } else {
        if (windowCriterionCase_ == 7) {
          return metricSumInRangeBuilder_.getMessage();
        }
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    public Builder setMetricSumInRange(com.google.monitoring.v3.WindowsBasedSli.MetricRange value) {
      if (metricSumInRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        windowCriterion_ = value;
        onChanged();
      } else {
        metricSumInRangeBuilder_.setMessage(value);
      }
      windowCriterionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    public Builder setMetricSumInRange(
        com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder builderForValue) {
      if (metricSumInRangeBuilder_ == null) {
        windowCriterion_ = builderForValue.build();
        onChanged();
      } else {
        metricSumInRangeBuilder_.setMessage(builderForValue.build());
      }
      windowCriterionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    public Builder mergeMetricSumInRange(
        com.google.monitoring.v3.WindowsBasedSli.MetricRange value) {
      if (metricSumInRangeBuilder_ == null) {
        if (windowCriterionCase_ == 7
            && windowCriterion_
                != com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance()) {
          windowCriterion_ =
              com.google.monitoring.v3.WindowsBasedSli.MetricRange.newBuilder(
                      (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          windowCriterion_ = value;
        }
        onChanged();
      } else {
        if (windowCriterionCase_ == 7) {
          metricSumInRangeBuilder_.mergeFrom(value);
        } else {
          metricSumInRangeBuilder_.setMessage(value);
        }
      }
      windowCriterionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    public Builder clearMetricSumInRange() {
      if (metricSumInRangeBuilder_ == null) {
        if (windowCriterionCase_ == 7) {
          windowCriterionCase_ = 0;
          windowCriterion_ = null;
          onChanged();
        }
      } else {
        if (windowCriterionCase_ == 7) {
          windowCriterionCase_ = 0;
          windowCriterion_ = null;
        }
        metricSumInRangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    public com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder
        getMetricSumInRangeBuilder() {
      return getMetricSumInRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder
        getMetricSumInRangeOrBuilder() {
      if ((windowCriterionCase_ == 7) && (metricSumInRangeBuilder_ != null)) {
        return metricSumInRangeBuilder_.getMessageOrBuilder();
      } else {
        if (windowCriterionCase_ == 7) {
          return (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A window is good if the metric's value is in a good range, summed across
     * returned streams.
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli.MetricRange metric_sum_in_range = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli.MetricRange,
            com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder,
            com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder>
        getMetricSumInRangeFieldBuilder() {
      if (metricSumInRangeBuilder_ == null) {
        if (!(windowCriterionCase_ == 7)) {
          windowCriterion_ =
              com.google.monitoring.v3.WindowsBasedSli.MetricRange.getDefaultInstance();
        }
        metricSumInRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.WindowsBasedSli.MetricRange,
                com.google.monitoring.v3.WindowsBasedSli.MetricRange.Builder,
                com.google.monitoring.v3.WindowsBasedSli.MetricRangeOrBuilder>(
                (com.google.monitoring.v3.WindowsBasedSli.MetricRange) windowCriterion_,
                getParentForChildren(),
                isClean());
        windowCriterion_ = null;
      }
      windowCriterionCase_ = 7;
      onChanged();
      return metricSumInRangeBuilder_;
    }

    private com.google.protobuf.Duration windowPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        windowPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     *
     * @return Whether the windowPeriod field is set.
     */
    public boolean hasWindowPeriod() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     *
     * @return The windowPeriod.
     */
    public com.google.protobuf.Duration getWindowPeriod() {
      if (windowPeriodBuilder_ == null) {
        return windowPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : windowPeriod_;
      } else {
        return windowPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    public Builder setWindowPeriod(com.google.protobuf.Duration value) {
      if (windowPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        windowPeriod_ = value;
      } else {
        windowPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    public Builder setWindowPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (windowPeriodBuilder_ == null) {
        windowPeriod_ = builderForValue.build();
      } else {
        windowPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    public Builder mergeWindowPeriod(com.google.protobuf.Duration value) {
      if (windowPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && windowPeriod_ != null
            && windowPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getWindowPeriodBuilder().mergeFrom(value);
        } else {
          windowPeriod_ = value;
        }
      } else {
        windowPeriodBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    public Builder clearWindowPeriod() {
      bitField0_ = (bitField0_ & ~0x00000010);
      windowPeriod_ = null;
      if (windowPeriodBuilder_ != null) {
        windowPeriodBuilder_.dispose();
        windowPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getWindowPeriodBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getWindowPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getWindowPeriodOrBuilder() {
      if (windowPeriodBuilder_ != null) {
        return windowPeriodBuilder_.getMessageOrBuilder();
      } else {
        return windowPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : windowPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration over which window quality is evaluated. Must be an integer
     * fraction of a day and at least `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration window_period = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getWindowPeriodFieldBuilder() {
      if (windowPeriodBuilder_ == null) {
        windowPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getWindowPeriod(), getParentForChildren(), isClean());
        windowPeriod_ = null;
      }
      return windowPeriodBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.WindowsBasedSli)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.WindowsBasedSli)
  private static final com.google.monitoring.v3.WindowsBasedSli DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.WindowsBasedSli();
  }

  public static com.google.monitoring.v3.WindowsBasedSli getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WindowsBasedSli> PARSER =
      new com.google.protobuf.AbstractParser<WindowsBasedSli>() {
        @java.lang.Override
        public WindowsBasedSli parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WindowsBasedSli> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WindowsBasedSli> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
