/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/notification_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The `ListNotificationChannels` response.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.ListNotificationChannelsResponse}
 */
public final class ListNotificationChannelsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.ListNotificationChannelsResponse)
    ListNotificationChannelsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListNotificationChannelsResponse.newBuilder() to construct.
  private ListNotificationChannelsResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListNotificationChannelsResponse() {
    notificationChannels_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListNotificationChannelsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.NotificationServiceProto
        .internal_static_google_monitoring_v3_ListNotificationChannelsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.NotificationServiceProto
        .internal_static_google_monitoring_v3_ListNotificationChannelsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.ListNotificationChannelsResponse.class,
            com.google.monitoring.v3.ListNotificationChannelsResponse.Builder.class);
  }

  public static final int NOTIFICATION_CHANNELS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.NotificationChannel> notificationChannels_;
  /**
   *
   *
   * <pre>
   * The notification channels defined for the specified project.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.NotificationChannel>
      getNotificationChannelsList() {
    return notificationChannels_;
  }
  /**
   *
   *
   * <pre>
   * The notification channels defined for the specified project.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.NotificationChannelOrBuilder>
      getNotificationChannelsOrBuilderList() {
    return notificationChannels_;
  }
  /**
   *
   *
   * <pre>
   * The notification channels defined for the specified project.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
   */
  @java.lang.Override
  public int getNotificationChannelsCount() {
    return notificationChannels_.size();
  }
  /**
   *
   *
   * <pre>
   * The notification channels defined for the specified project.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.NotificationChannel getNotificationChannels(int index) {
    return notificationChannels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The notification channels defined for the specified project.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.NotificationChannelOrBuilder getNotificationChannelsOrBuilder(
      int index) {
    return notificationChannels_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * If not empty, indicates that there may be more results that match
   * the request. Use the value in the `page_token` field in a
   * subsequent request to fetch the next set of results. If empty,
   * all results have been returned.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If not empty, indicates that there may be more results that match
   * the request. Use the value in the `page_token` field in a
   * subsequent request to fetch the next set of results. If empty,
   * all results have been returned.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOTAL_SIZE_FIELD_NUMBER = 4;
  private int totalSize_ = 0;
  /**
   *
   *
   * <pre>
   * The total number of notification channels in all pages. This number is only
   * an estimate, and may change in subsequent pages. https://aip.dev/158
   * </pre>
   *
   * <code>int32 total_size = 4;</code>
   *
   * @return The totalSize.
   */
  @java.lang.Override
  public int getTotalSize() {
    return totalSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < notificationChannels_.size(); i++) {
      output.writeMessage(3, notificationChannels_.get(i));
    }
    if (totalSize_ != 0) {
      output.writeInt32(4, totalSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    for (int i = 0; i < notificationChannels_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, notificationChannels_.get(i));
    }
    if (totalSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, totalSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.ListNotificationChannelsResponse)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.ListNotificationChannelsResponse other =
        (com.google.monitoring.v3.ListNotificationChannelsResponse) obj;

    if (!getNotificationChannelsList().equals(other.getNotificationChannelsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (getTotalSize() != other.getTotalSize()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getNotificationChannelsCount() > 0) {
      hash = (37 * hash) + NOTIFICATION_CHANNELS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationChannelsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (37 * hash) + TOTAL_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getTotalSize();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.monitoring.v3.ListNotificationChannelsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `ListNotificationChannels` response.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.ListNotificationChannelsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.ListNotificationChannelsResponse)
      com.google.monitoring.v3.ListNotificationChannelsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.NotificationServiceProto
          .internal_static_google_monitoring_v3_ListNotificationChannelsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.NotificationServiceProto
          .internal_static_google_monitoring_v3_ListNotificationChannelsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.ListNotificationChannelsResponse.class,
              com.google.monitoring.v3.ListNotificationChannelsResponse.Builder.class);
    }

    // Construct using com.google.monitoring.v3.ListNotificationChannelsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (notificationChannelsBuilder_ == null) {
        notificationChannels_ = java.util.Collections.emptyList();
      } else {
        notificationChannels_ = null;
        notificationChannelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      totalSize_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.NotificationServiceProto
          .internal_static_google_monitoring_v3_ListNotificationChannelsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListNotificationChannelsResponse getDefaultInstanceForType() {
      return com.google.monitoring.v3.ListNotificationChannelsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListNotificationChannelsResponse build() {
      com.google.monitoring.v3.ListNotificationChannelsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListNotificationChannelsResponse buildPartial() {
      com.google.monitoring.v3.ListNotificationChannelsResponse result =
          new com.google.monitoring.v3.ListNotificationChannelsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.monitoring.v3.ListNotificationChannelsResponse result) {
      if (notificationChannelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          notificationChannels_ = java.util.Collections.unmodifiableList(notificationChannels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.notificationChannels_ = notificationChannels_;
      } else {
        result.notificationChannels_ = notificationChannelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.ListNotificationChannelsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.totalSize_ = totalSize_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.ListNotificationChannelsResponse) {
        return mergeFrom((com.google.monitoring.v3.ListNotificationChannelsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.ListNotificationChannelsResponse other) {
      if (other == com.google.monitoring.v3.ListNotificationChannelsResponse.getDefaultInstance())
        return this;
      if (notificationChannelsBuilder_ == null) {
        if (!other.notificationChannels_.isEmpty()) {
          if (notificationChannels_.isEmpty()) {
            notificationChannels_ = other.notificationChannels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureNotificationChannelsIsMutable();
            notificationChannels_.addAll(other.notificationChannels_);
          }
          onChanged();
        }
      } else {
        if (!other.notificationChannels_.isEmpty()) {
          if (notificationChannelsBuilder_.isEmpty()) {
            notificationChannelsBuilder_.dispose();
            notificationChannelsBuilder_ = null;
            notificationChannels_ = other.notificationChannels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            notificationChannelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNotificationChannelsFieldBuilder()
                    : null;
          } else {
            notificationChannelsBuilder_.addAllMessages(other.notificationChannels_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getTotalSize() != 0) {
        setTotalSize(other.getTotalSize());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.monitoring.v3.NotificationChannel m =
                    input.readMessage(
                        com.google.monitoring.v3.NotificationChannel.parser(), extensionRegistry);
                if (notificationChannelsBuilder_ == null) {
                  ensureNotificationChannelsIsMutable();
                  notificationChannels_.add(m);
                } else {
                  notificationChannelsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                totalSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.monitoring.v3.NotificationChannel> notificationChannels_ =
        java.util.Collections.emptyList();

    private void ensureNotificationChannelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        notificationChannels_ =
            new java.util.ArrayList<com.google.monitoring.v3.NotificationChannel>(
                notificationChannels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.NotificationChannel,
            com.google.monitoring.v3.NotificationChannel.Builder,
            com.google.monitoring.v3.NotificationChannelOrBuilder>
        notificationChannelsBuilder_;

    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public java.util.List<com.google.monitoring.v3.NotificationChannel>
        getNotificationChannelsList() {
      if (notificationChannelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(notificationChannels_);
      } else {
        return notificationChannelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public int getNotificationChannelsCount() {
      if (notificationChannelsBuilder_ == null) {
        return notificationChannels_.size();
      } else {
        return notificationChannelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public com.google.monitoring.v3.NotificationChannel getNotificationChannels(int index) {
      if (notificationChannelsBuilder_ == null) {
        return notificationChannels_.get(index);
      } else {
        return notificationChannelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder setNotificationChannels(
        int index, com.google.monitoring.v3.NotificationChannel value) {
      if (notificationChannelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationChannelsIsMutable();
        notificationChannels_.set(index, value);
        onChanged();
      } else {
        notificationChannelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder setNotificationChannels(
        int index, com.google.monitoring.v3.NotificationChannel.Builder builderForValue) {
      if (notificationChannelsBuilder_ == null) {
        ensureNotificationChannelsIsMutable();
        notificationChannels_.set(index, builderForValue.build());
        onChanged();
      } else {
        notificationChannelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder addNotificationChannels(com.google.monitoring.v3.NotificationChannel value) {
      if (notificationChannelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationChannelsIsMutable();
        notificationChannels_.add(value);
        onChanged();
      } else {
        notificationChannelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder addNotificationChannels(
        int index, com.google.monitoring.v3.NotificationChannel value) {
      if (notificationChannelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationChannelsIsMutable();
        notificationChannels_.add(index, value);
        onChanged();
      } else {
        notificationChannelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder addNotificationChannels(
        com.google.monitoring.v3.NotificationChannel.Builder builderForValue) {
      if (notificationChannelsBuilder_ == null) {
        ensureNotificationChannelsIsMutable();
        notificationChannels_.add(builderForValue.build());
        onChanged();
      } else {
        notificationChannelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder addNotificationChannels(
        int index, com.google.monitoring.v3.NotificationChannel.Builder builderForValue) {
      if (notificationChannelsBuilder_ == null) {
        ensureNotificationChannelsIsMutable();
        notificationChannels_.add(index, builderForValue.build());
        onChanged();
      } else {
        notificationChannelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder addAllNotificationChannels(
        java.lang.Iterable<? extends com.google.monitoring.v3.NotificationChannel> values) {
      if (notificationChannelsBuilder_ == null) {
        ensureNotificationChannelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notificationChannels_);
        onChanged();
      } else {
        notificationChannelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder clearNotificationChannels() {
      if (notificationChannelsBuilder_ == null) {
        notificationChannels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        notificationChannelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public Builder removeNotificationChannels(int index) {
      if (notificationChannelsBuilder_ == null) {
        ensureNotificationChannelsIsMutable();
        notificationChannels_.remove(index);
        onChanged();
      } else {
        notificationChannelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public com.google.monitoring.v3.NotificationChannel.Builder getNotificationChannelsBuilder(
        int index) {
      return getNotificationChannelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public com.google.monitoring.v3.NotificationChannelOrBuilder getNotificationChannelsOrBuilder(
        int index) {
      if (notificationChannelsBuilder_ == null) {
        return notificationChannels_.get(index);
      } else {
        return notificationChannelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.NotificationChannelOrBuilder>
        getNotificationChannelsOrBuilderList() {
      if (notificationChannelsBuilder_ != null) {
        return notificationChannelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(notificationChannels_);
      }
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public com.google.monitoring.v3.NotificationChannel.Builder addNotificationChannelsBuilder() {
      return getNotificationChannelsFieldBuilder()
          .addBuilder(com.google.monitoring.v3.NotificationChannel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public com.google.monitoring.v3.NotificationChannel.Builder addNotificationChannelsBuilder(
        int index) {
      return getNotificationChannelsFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.NotificationChannel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The notification channels defined for the specified project.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.NotificationChannel notification_channels = 3;</code>
     */
    public java.util.List<com.google.monitoring.v3.NotificationChannel.Builder>
        getNotificationChannelsBuilderList() {
      return getNotificationChannelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.NotificationChannel,
            com.google.monitoring.v3.NotificationChannel.Builder,
            com.google.monitoring.v3.NotificationChannelOrBuilder>
        getNotificationChannelsFieldBuilder() {
      if (notificationChannelsBuilder_ == null) {
        notificationChannelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.NotificationChannel,
                com.google.monitoring.v3.NotificationChannel.Builder,
                com.google.monitoring.v3.NotificationChannelOrBuilder>(
                notificationChannels_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        notificationChannels_ = null;
      }
      return notificationChannelsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more results that match
     * the request. Use the value in the `page_token` field in a
     * subsequent request to fetch the next set of results. If empty,
     * all results have been returned.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more results that match
     * the request. Use the value in the `page_token` field in a
     * subsequent request to fetch the next set of results. If empty,
     * all results have been returned.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more results that match
     * the request. Use the value in the `page_token` field in a
     * subsequent request to fetch the next set of results. If empty,
     * all results have been returned.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more results that match
     * the request. Use the value in the `page_token` field in a
     * subsequent request to fetch the next set of results. If empty,
     * all results have been returned.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more results that match
     * the request. Use the value in the `page_token` field in a
     * subsequent request to fetch the next set of results. If empty,
     * all results have been returned.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int totalSize_;
    /**
     *
     *
     * <pre>
     * The total number of notification channels in all pages. This number is only
     * an estimate, and may change in subsequent pages. https://aip.dev/158
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @return The totalSize.
     */
    @java.lang.Override
    public int getTotalSize() {
      return totalSize_;
    }
    /**
     *
     *
     * <pre>
     * The total number of notification channels in all pages. This number is only
     * an estimate, and may change in subsequent pages. https://aip.dev/158
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @param value The totalSize to set.
     * @return This builder for chaining.
     */
    public Builder setTotalSize(int value) {

      totalSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of notification channels in all pages. This number is only
     * an estimate, and may change in subsequent pages. https://aip.dev/158
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      totalSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.ListNotificationChannelsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.ListNotificationChannelsResponse)
  private static final com.google.monitoring.v3.ListNotificationChannelsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.ListNotificationChannelsResponse();
  }

  public static com.google.monitoring.v3.ListNotificationChannelsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListNotificationChannelsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListNotificationChannelsResponse>() {
        @java.lang.Override
        public ListNotificationChannelsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListNotificationChannelsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListNotificationChannelsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.ListNotificationChannelsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
