/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A descriptor for the labels and points in a time series.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.TimeSeriesDescriptor}
 */
public final class TimeSeriesDescriptor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.TimeSeriesDescriptor)
    TimeSeriesDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeSeriesDescriptor.newBuilder() to construct.
  private TimeSeriesDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeSeriesDescriptor() {
    labelDescriptors_ = java.util.Collections.emptyList();
    pointDescriptors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeSeriesDescriptor();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TimeSeriesDescriptor(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labelDescriptors_ = new java.util.ArrayList<com.google.api.LabelDescriptor>();
                mutable_bitField0_ |= 0x00000001;
              }
              labelDescriptors_.add(
                  input.readMessage(com.google.api.LabelDescriptor.parser(), extensionRegistry));
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                pointDescriptors_ =
                    new java.util.ArrayList<
                        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>();
                mutable_bitField0_ |= 0x00000002;
              }
              pointDescriptors_.add(
                  input.readMessage(
                      com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        labelDescriptors_ = java.util.Collections.unmodifiableList(labelDescriptors_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        pointDescriptors_ = java.util.Collections.unmodifiableList(pointDescriptors_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TimeSeriesDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TimeSeriesDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.TimeSeriesDescriptor.class,
            com.google.monitoring.v3.TimeSeriesDescriptor.Builder.class);
  }

  public interface ValueDescriptorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The value key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * The value key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * The value type.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    int getValueTypeValue();
    /**
     *
     *
     * <pre>
     * The value type.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
     *
     * @return The valueType.
     */
    com.google.api.MetricDescriptor.ValueType getValueType();

    /**
     *
     *
     * <pre>
     * The value stream kind.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The enum numeric value on the wire for metricKind.
     */
    int getMetricKindValue();
    /**
     *
     *
     * <pre>
     * The value stream kind.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The metricKind.
     */
    com.google.api.MetricDescriptor.MetricKind getMetricKind();

    /**
     *
     *
     * <pre>
     * The unit in which `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
     * </pre>
     *
     * <code>string unit = 4;</code>
     *
     * @return The unit.
     */
    java.lang.String getUnit();
    /**
     *
     *
     * <pre>
     * The unit in which `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
     * </pre>
     *
     * <code>string unit = 4;</code>
     *
     * @return The bytes for unit.
     */
    com.google.protobuf.ByteString getUnitBytes();
  }
  /**
   *
   *
   * <pre>
   * A descriptor for the value columns in a data point.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor}
   */
  public static final class ValueDescriptor extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)
      ValueDescriptorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ValueDescriptor.newBuilder() to construct.
    private ValueDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ValueDescriptor() {
      key_ = "";
      valueType_ = 0;
      metricKind_ = 0;
      unit_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ValueDescriptor();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ValueDescriptor(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                key_ = s;
                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                valueType_ = rawValue;
                break;
              }
            case 24:
              {
                int rawValue = input.readEnum();

                metricKind_ = rawValue;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                unit_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesDescriptor_ValueDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesDescriptor_ValueDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.class,
              com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object key_;
    /**
     *
     *
     * <pre>
     * The value key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_TYPE_FIELD_NUMBER = 2;
    private int valueType_;
    /**
     *
     *
     * <pre>
     * The value type.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * The value type.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.api.MetricDescriptor.ValueType getValueType() {
      @SuppressWarnings("deprecation")
      com.google.api.MetricDescriptor.ValueType result =
          com.google.api.MetricDescriptor.ValueType.valueOf(valueType_);
      return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
    }

    public static final int METRIC_KIND_FIELD_NUMBER = 3;
    private int metricKind_;
    /**
     *
     *
     * <pre>
     * The value stream kind.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The enum numeric value on the wire for metricKind.
     */
    @java.lang.Override
    public int getMetricKindValue() {
      return metricKind_;
    }
    /**
     *
     *
     * <pre>
     * The value stream kind.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The metricKind.
     */
    @java.lang.Override
    public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
      @SuppressWarnings("deprecation")
      com.google.api.MetricDescriptor.MetricKind result =
          com.google.api.MetricDescriptor.MetricKind.valueOf(metricKind_);
      return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
    }

    public static final int UNIT_FIELD_NUMBER = 4;
    private volatile java.lang.Object unit_;
    /**
     *
     *
     * <pre>
     * The unit in which `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
     * </pre>
     *
     * <code>string unit = 4;</code>
     *
     * @return The unit.
     */
    @java.lang.Override
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unit in which `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
     * </pre>
     *
     * <code>string unit = 4;</code>
     *
     * @return The bytes for unit.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (valueType_
          != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, valueType_);
      }
      if (metricKind_
          != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
        output.writeEnum(3, metricKind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, unit_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (valueType_
          != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, valueType_);
      }
      if (metricKind_
          != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, metricKind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, unit_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor other =
          (com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (valueType_ != other.valueType_) return false;
      if (metricKind_ != other.metricKind_) return false;
      if (!getUnit().equals(other.getUnit())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + valueType_;
      hash = (37 * hash) + METRIC_KIND_FIELD_NUMBER;
      hash = (53 * hash) + metricKind_;
      hash = (37 * hash) + UNIT_FIELD_NUMBER;
      hash = (53 * hash) + getUnit().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A descriptor for the value columns in a data point.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TimeSeriesDescriptor_ValueDescriptor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TimeSeriesDescriptor_ValueDescriptor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.class,
                com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder.class);
      }

      // Construct using com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        key_ = "";

        valueType_ = 0;

        metricKind_ = 0;

        unit_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TimeSeriesDescriptor_ValueDescriptor_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor
          getDefaultInstanceForType() {
        return com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor build() {
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor buildPartial() {
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor result =
            new com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor(this);
        result.key_ = key_;
        result.valueType_ = valueType_;
        result.metricKind_ = metricKind_;
        result.unit_ = unit_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor) {
          return mergeFrom((com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor other) {
        if (other
            == com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          onChanged();
        }
        if (other.valueType_ != 0) {
          setValueTypeValue(other.getValueTypeValue());
        }
        if (other.metricKind_ != 0) {
          setMetricKindValue(other.getMetricKindValue());
        }
        if (!other.getUnit().isEmpty()) {
          unit_ = other.unit_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The value key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        key_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {

        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        key_ = value;
        onChanged();
        return this;
      }

      private int valueType_ = 0;
      /**
       *
       *
       * <pre>
       * The value type.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
       *
       * @return The enum numeric value on the wire for valueType.
       */
      @java.lang.Override
      public int getValueTypeValue() {
        return valueType_;
      }
      /**
       *
       *
       * <pre>
       * The value type.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
       *
       * @param value The enum numeric value on the wire for valueType to set.
       * @return This builder for chaining.
       */
      public Builder setValueTypeValue(int value) {

        valueType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value type.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
       *
       * @return The valueType.
       */
      @java.lang.Override
      public com.google.api.MetricDescriptor.ValueType getValueType() {
        @SuppressWarnings("deprecation")
        com.google.api.MetricDescriptor.ValueType result =
            com.google.api.MetricDescriptor.ValueType.valueOf(valueType_);
        return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * The value type.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
       *
       * @param value The valueType to set.
       * @return This builder for chaining.
       */
      public Builder setValueType(com.google.api.MetricDescriptor.ValueType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        valueType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value type.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.ValueType value_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueType() {

        valueType_ = 0;
        onChanged();
        return this;
      }

      private int metricKind_ = 0;
      /**
       *
       *
       * <pre>
       * The value stream kind.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
       *
       * @return The enum numeric value on the wire for metricKind.
       */
      @java.lang.Override
      public int getMetricKindValue() {
        return metricKind_;
      }
      /**
       *
       *
       * <pre>
       * The value stream kind.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
       *
       * @param value The enum numeric value on the wire for metricKind to set.
       * @return This builder for chaining.
       */
      public Builder setMetricKindValue(int value) {

        metricKind_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value stream kind.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
       *
       * @return The metricKind.
       */
      @java.lang.Override
      public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
        @SuppressWarnings("deprecation")
        com.google.api.MetricDescriptor.MetricKind result =
            com.google.api.MetricDescriptor.MetricKind.valueOf(metricKind_);
        return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * The value stream kind.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
       *
       * @param value The metricKind to set.
       * @return This builder for chaining.
       */
      public Builder setMetricKind(com.google.api.MetricDescriptor.MetricKind value) {
        if (value == null) {
          throw new NullPointerException();
        }

        metricKind_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value stream kind.
       * </pre>
       *
       * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricKind() {

        metricKind_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object unit_ = "";
      /**
       *
       *
       * <pre>
       * The unit in which `time_series` point values are reported. `unit`
       * follows the UCUM format for units as seen in
       * https://unitsofmeasure.org/ucum.html.
       * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
       * </pre>
       *
       * <code>string unit = 4;</code>
       *
       * @return The unit.
       */
      public java.lang.String getUnit() {
        java.lang.Object ref = unit_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          unit_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unit in which `time_series` point values are reported. `unit`
       * follows the UCUM format for units as seen in
       * https://unitsofmeasure.org/ucum.html.
       * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
       * </pre>
       *
       * <code>string unit = 4;</code>
       *
       * @return The bytes for unit.
       */
      public com.google.protobuf.ByteString getUnitBytes() {
        java.lang.Object ref = unit_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          unit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unit in which `time_series` point values are reported. `unit`
       * follows the UCUM format for units as seen in
       * https://unitsofmeasure.org/ucum.html.
       * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
       * </pre>
       *
       * <code>string unit = 4;</code>
       *
       * @param value The unit to set.
       * @return This builder for chaining.
       */
      public Builder setUnit(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        unit_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unit in which `time_series` point values are reported. `unit`
       * follows the UCUM format for units as seen in
       * https://unitsofmeasure.org/ucum.html.
       * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
       * </pre>
       *
       * <code>string unit = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUnit() {

        unit_ = getDefaultInstance().getUnit();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unit in which `time_series` point values are reported. `unit`
       * follows the UCUM format for units as seen in
       * https://unitsofmeasure.org/ucum.html.
       * `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
       * </pre>
       *
       * <code>string unit = 4;</code>
       *
       * @param value The bytes for unit to set.
       * @return This builder for chaining.
       */
      public Builder setUnitBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        unit_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor)
    private static final com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor();
    }

    public static com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ValueDescriptor> PARSER =
        new com.google.protobuf.AbstractParser<ValueDescriptor>() {
          @java.lang.Override
          public ValueDescriptor parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ValueDescriptor(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ValueDescriptor> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ValueDescriptor> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int LABEL_DESCRIPTORS_FIELD_NUMBER = 1;
  private java.util.List<com.google.api.LabelDescriptor> labelDescriptors_;
  /**
   *
   *
   * <pre>
   * Descriptors for the labels.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.LabelDescriptor> getLabelDescriptorsList() {
    return labelDescriptors_;
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the labels.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.LabelDescriptorOrBuilder>
      getLabelDescriptorsOrBuilderList() {
    return labelDescriptors_;
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the labels.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
   */
  @java.lang.Override
  public int getLabelDescriptorsCount() {
    return labelDescriptors_.size();
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the labels.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
   */
  @java.lang.Override
  public com.google.api.LabelDescriptor getLabelDescriptors(int index) {
    return labelDescriptors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the labels.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
   */
  @java.lang.Override
  public com.google.api.LabelDescriptorOrBuilder getLabelDescriptorsOrBuilder(int index) {
    return labelDescriptors_.get(index);
  }

  public static final int POINT_DESCRIPTORS_FIELD_NUMBER = 5;
  private java.util.List<com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>
      pointDescriptors_;
  /**
   *
   *
   * <pre>
   * Descriptors for the point data value columns.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>
      getPointDescriptorsList() {
    return pointDescriptors_;
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the point data value columns.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder>
      getPointDescriptorsOrBuilderList() {
    return pointDescriptors_;
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the point data value columns.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
   * </code>
   */
  @java.lang.Override
  public int getPointDescriptorsCount() {
    return pointDescriptors_.size();
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the point data value columns.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor getPointDescriptors(
      int index) {
    return pointDescriptors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Descriptors for the point data value columns.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder
      getPointDescriptorsOrBuilder(int index) {
    return pointDescriptors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < labelDescriptors_.size(); i++) {
      output.writeMessage(1, labelDescriptors_.get(i));
    }
    for (int i = 0; i < pointDescriptors_.size(); i++) {
      output.writeMessage(5, pointDescriptors_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < labelDescriptors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, labelDescriptors_.get(i));
    }
    for (int i = 0; i < pointDescriptors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, pointDescriptors_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.TimeSeriesDescriptor)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.TimeSeriesDescriptor other =
        (com.google.monitoring.v3.TimeSeriesDescriptor) obj;

    if (!getLabelDescriptorsList().equals(other.getLabelDescriptorsList())) return false;
    if (!getPointDescriptorsList().equals(other.getPointDescriptorsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLabelDescriptorsCount() > 0) {
      hash = (37 * hash) + LABEL_DESCRIPTORS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelDescriptorsList().hashCode();
    }
    if (getPointDescriptorsCount() > 0) {
      hash = (37 * hash) + POINT_DESCRIPTORS_FIELD_NUMBER;
      hash = (53 * hash) + getPointDescriptorsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.TimeSeriesDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A descriptor for the labels and points in a time series.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TimeSeriesDescriptor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TimeSeriesDescriptor)
      com.google.monitoring.v3.TimeSeriesDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TimeSeriesDescriptor.class,
              com.google.monitoring.v3.TimeSeriesDescriptor.Builder.class);
    }

    // Construct using com.google.monitoring.v3.TimeSeriesDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLabelDescriptorsFieldBuilder();
        getPointDescriptorsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (labelDescriptorsBuilder_ == null) {
        labelDescriptors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        labelDescriptorsBuilder_.clear();
      }
      if (pointDescriptorsBuilder_ == null) {
        pointDescriptors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        pointDescriptorsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesDescriptor_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesDescriptor getDefaultInstanceForType() {
      return com.google.monitoring.v3.TimeSeriesDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesDescriptor build() {
      com.google.monitoring.v3.TimeSeriesDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesDescriptor buildPartial() {
      com.google.monitoring.v3.TimeSeriesDescriptor result =
          new com.google.monitoring.v3.TimeSeriesDescriptor(this);
      int from_bitField0_ = bitField0_;
      if (labelDescriptorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          labelDescriptors_ = java.util.Collections.unmodifiableList(labelDescriptors_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.labelDescriptors_ = labelDescriptors_;
      } else {
        result.labelDescriptors_ = labelDescriptorsBuilder_.build();
      }
      if (pointDescriptorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          pointDescriptors_ = java.util.Collections.unmodifiableList(pointDescriptors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.pointDescriptors_ = pointDescriptors_;
      } else {
        result.pointDescriptors_ = pointDescriptorsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.TimeSeriesDescriptor) {
        return mergeFrom((com.google.monitoring.v3.TimeSeriesDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.TimeSeriesDescriptor other) {
      if (other == com.google.monitoring.v3.TimeSeriesDescriptor.getDefaultInstance()) return this;
      if (labelDescriptorsBuilder_ == null) {
        if (!other.labelDescriptors_.isEmpty()) {
          if (labelDescriptors_.isEmpty()) {
            labelDescriptors_ = other.labelDescriptors_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLabelDescriptorsIsMutable();
            labelDescriptors_.addAll(other.labelDescriptors_);
          }
          onChanged();
        }
      } else {
        if (!other.labelDescriptors_.isEmpty()) {
          if (labelDescriptorsBuilder_.isEmpty()) {
            labelDescriptorsBuilder_.dispose();
            labelDescriptorsBuilder_ = null;
            labelDescriptors_ = other.labelDescriptors_;
            bitField0_ = (bitField0_ & ~0x00000001);
            labelDescriptorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelDescriptorsFieldBuilder()
                    : null;
          } else {
            labelDescriptorsBuilder_.addAllMessages(other.labelDescriptors_);
          }
        }
      }
      if (pointDescriptorsBuilder_ == null) {
        if (!other.pointDescriptors_.isEmpty()) {
          if (pointDescriptors_.isEmpty()) {
            pointDescriptors_ = other.pointDescriptors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePointDescriptorsIsMutable();
            pointDescriptors_.addAll(other.pointDescriptors_);
          }
          onChanged();
        }
      } else {
        if (!other.pointDescriptors_.isEmpty()) {
          if (pointDescriptorsBuilder_.isEmpty()) {
            pointDescriptorsBuilder_.dispose();
            pointDescriptorsBuilder_ = null;
            pointDescriptors_ = other.pointDescriptors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            pointDescriptorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPointDescriptorsFieldBuilder()
                    : null;
          } else {
            pointDescriptorsBuilder_.addAllMessages(other.pointDescriptors_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.TimeSeriesDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.monitoring.v3.TimeSeriesDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.api.LabelDescriptor> labelDescriptors_ =
        java.util.Collections.emptyList();

    private void ensureLabelDescriptorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        labelDescriptors_ =
            new java.util.ArrayList<com.google.api.LabelDescriptor>(labelDescriptors_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            com.google.api.LabelDescriptor.Builder,
            com.google.api.LabelDescriptorOrBuilder>
        labelDescriptorsBuilder_;

    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public java.util.List<com.google.api.LabelDescriptor> getLabelDescriptorsList() {
      if (labelDescriptorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labelDescriptors_);
      } else {
        return labelDescriptorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public int getLabelDescriptorsCount() {
      if (labelDescriptorsBuilder_ == null) {
        return labelDescriptors_.size();
      } else {
        return labelDescriptorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public com.google.api.LabelDescriptor getLabelDescriptors(int index) {
      if (labelDescriptorsBuilder_ == null) {
        return labelDescriptors_.get(index);
      } else {
        return labelDescriptorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder setLabelDescriptors(int index, com.google.api.LabelDescriptor value) {
      if (labelDescriptorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.set(index, value);
        onChanged();
      } else {
        labelDescriptorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder setLabelDescriptors(
        int index, com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelDescriptorsBuilder_ == null) {
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelDescriptorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder addLabelDescriptors(com.google.api.LabelDescriptor value) {
      if (labelDescriptorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.add(value);
        onChanged();
      } else {
        labelDescriptorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder addLabelDescriptors(int index, com.google.api.LabelDescriptor value) {
      if (labelDescriptorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.add(index, value);
        onChanged();
      } else {
        labelDescriptorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder addLabelDescriptors(com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelDescriptorsBuilder_ == null) {
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.add(builderForValue.build());
        onChanged();
      } else {
        labelDescriptorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder addLabelDescriptors(
        int index, com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelDescriptorsBuilder_ == null) {
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelDescriptorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder addAllLabelDescriptors(
        java.lang.Iterable<? extends com.google.api.LabelDescriptor> values) {
      if (labelDescriptorsBuilder_ == null) {
        ensureLabelDescriptorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labelDescriptors_);
        onChanged();
      } else {
        labelDescriptorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder clearLabelDescriptors() {
      if (labelDescriptorsBuilder_ == null) {
        labelDescriptors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        labelDescriptorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public Builder removeLabelDescriptors(int index) {
      if (labelDescriptorsBuilder_ == null) {
        ensureLabelDescriptorsIsMutable();
        labelDescriptors_.remove(index);
        onChanged();
      } else {
        labelDescriptorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public com.google.api.LabelDescriptor.Builder getLabelDescriptorsBuilder(int index) {
      return getLabelDescriptorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public com.google.api.LabelDescriptorOrBuilder getLabelDescriptorsOrBuilder(int index) {
      if (labelDescriptorsBuilder_ == null) {
        return labelDescriptors_.get(index);
      } else {
        return labelDescriptorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public java.util.List<? extends com.google.api.LabelDescriptorOrBuilder>
        getLabelDescriptorsOrBuilderList() {
      if (labelDescriptorsBuilder_ != null) {
        return labelDescriptorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labelDescriptors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public com.google.api.LabelDescriptor.Builder addLabelDescriptorsBuilder() {
      return getLabelDescriptorsFieldBuilder()
          .addBuilder(com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public com.google.api.LabelDescriptor.Builder addLabelDescriptorsBuilder(int index) {
      return getLabelDescriptorsFieldBuilder()
          .addBuilder(index, com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the labels.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor label_descriptors = 1;</code>
     */
    public java.util.List<com.google.api.LabelDescriptor.Builder> getLabelDescriptorsBuilderList() {
      return getLabelDescriptorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            com.google.api.LabelDescriptor.Builder,
            com.google.api.LabelDescriptorOrBuilder>
        getLabelDescriptorsFieldBuilder() {
      if (labelDescriptorsBuilder_ == null) {
        labelDescriptorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.LabelDescriptor,
                com.google.api.LabelDescriptor.Builder,
                com.google.api.LabelDescriptorOrBuilder>(
                labelDescriptors_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        labelDescriptors_ = null;
      }
      return labelDescriptorsBuilder_;
    }

    private java.util.List<com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>
        pointDescriptors_ = java.util.Collections.emptyList();

    private void ensurePointDescriptorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        pointDescriptors_ =
            new java.util.ArrayList<com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>(
                pointDescriptors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor,
            com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder,
            com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder>
        pointDescriptorsBuilder_;

    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>
        getPointDescriptorsList() {
      if (pointDescriptorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pointDescriptors_);
      } else {
        return pointDescriptorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public int getPointDescriptorsCount() {
      if (pointDescriptorsBuilder_ == null) {
        return pointDescriptors_.size();
      } else {
        return pointDescriptorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor getPointDescriptors(
        int index) {
      if (pointDescriptorsBuilder_ == null) {
        return pointDescriptors_.get(index);
      } else {
        return pointDescriptorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder setPointDescriptors(
        int index, com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor value) {
      if (pointDescriptorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.set(index, value);
        onChanged();
      } else {
        pointDescriptorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder setPointDescriptors(
        int index,
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder builderForValue) {
      if (pointDescriptorsBuilder_ == null) {
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.set(index, builderForValue.build());
        onChanged();
      } else {
        pointDescriptorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder addPointDescriptors(
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor value) {
      if (pointDescriptorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.add(value);
        onChanged();
      } else {
        pointDescriptorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder addPointDescriptors(
        int index, com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor value) {
      if (pointDescriptorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.add(index, value);
        onChanged();
      } else {
        pointDescriptorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder addPointDescriptors(
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder builderForValue) {
      if (pointDescriptorsBuilder_ == null) {
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.add(builderForValue.build());
        onChanged();
      } else {
        pointDescriptorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder addPointDescriptors(
        int index,
        com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder builderForValue) {
      if (pointDescriptorsBuilder_ == null) {
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.add(index, builderForValue.build());
        onChanged();
      } else {
        pointDescriptorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder addAllPointDescriptors(
        java.lang.Iterable<? extends com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor>
            values) {
      if (pointDescriptorsBuilder_ == null) {
        ensurePointDescriptorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pointDescriptors_);
        onChanged();
      } else {
        pointDescriptorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder clearPointDescriptors() {
      if (pointDescriptorsBuilder_ == null) {
        pointDescriptors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        pointDescriptorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public Builder removePointDescriptors(int index) {
      if (pointDescriptorsBuilder_ == null) {
        ensurePointDescriptorsIsMutable();
        pointDescriptors_.remove(index);
        onChanged();
      } else {
        pointDescriptorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder
        getPointDescriptorsBuilder(int index) {
      return getPointDescriptorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder
        getPointDescriptorsOrBuilder(int index) {
      if (pointDescriptorsBuilder_ == null) {
        return pointDescriptors_.get(index);
      } else {
        return pointDescriptorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder>
        getPointDescriptorsOrBuilderList() {
      if (pointDescriptorsBuilder_ != null) {
        return pointDescriptorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pointDescriptors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder
        addPointDescriptorsBuilder() {
      return getPointDescriptorsFieldBuilder()
          .addBuilder(
              com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder
        addPointDescriptorsBuilder(int index) {
      return getPointDescriptorsFieldBuilder()
          .addBuilder(
              index,
              com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Descriptors for the point data value columns.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor point_descriptors = 5;
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder>
        getPointDescriptorsBuilderList() {
      return getPointDescriptorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor,
            com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder,
            com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder>
        getPointDescriptorsFieldBuilder() {
      if (pointDescriptorsBuilder_ == null) {
        pointDescriptorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor,
                com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptor.Builder,
                com.google.monitoring.v3.TimeSeriesDescriptor.ValueDescriptorOrBuilder>(
                pointDescriptors_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        pointDescriptors_ = null;
      }
      return pointDescriptorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TimeSeriesDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.TimeSeriesDescriptor)
  private static final com.google.monitoring.v3.TimeSeriesDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.TimeSeriesDescriptor();
  }

  public static com.google.monitoring.v3.TimeSeriesDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeriesDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<TimeSeriesDescriptor>() {
        @java.lang.Override
        public TimeSeriesDescriptor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TimeSeriesDescriptor(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TimeSeriesDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeriesDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
