/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/notification_service.proto

package com.google.monitoring.v3;

public interface ListNotificationChannelsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.monitoring.v3.ListNotificationChannelsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
   * which to execute the request. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]
   *
   * This names the container
   * in which to look for the notification channels; it does not name a
   * specific channel. To query a specific channel by REST resource name, use
   * the
   * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
   * operation.
   * </pre>
   *
   * <code>
   * string name = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
   * which to execute the request. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]
   *
   * This names the container
   * in which to look for the notification channels; it does not name a
   * specific channel. To query a specific channel by REST resource name, use
   * the
   * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
   * operation.
   * </pre>
   *
   * <code>
   * string name = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * If provided, this field specifies the criteria that must be met by
   * notification channels to be included in the response.
   *
   * For more details, see [sorting and
   * filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
   * </pre>
   *
   * <code>string filter = 6;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * If provided, this field specifies the criteria that must be met by
   * notification channels to be included in the response.
   *
   * For more details, see [sorting and
   * filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
   * </pre>
   *
   * <code>string filter = 6;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * A comma-separated list of fields by which to sort the result. Supports
   * the same set of fields as in `filter`. Entries can be prefixed with
   * a minus sign to sort in descending rather than ascending order.
   *
   * For more details, see [sorting and
   * filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
   * </pre>
   *
   * <code>string order_by = 7;</code>
   *
   * @return The orderBy.
   */
  java.lang.String getOrderBy();
  /**
   *
   *
   * <pre>
   * A comma-separated list of fields by which to sort the result. Supports
   * the same set of fields as in `filter`. Entries can be prefixed with
   * a minus sign to sort in descending rather than ascending order.
   *
   * For more details, see [sorting and
   * filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
   * </pre>
   *
   * <code>string order_by = 7;</code>
   *
   * @return The bytes for orderBy.
   */
  com.google.protobuf.ByteString getOrderByBytes();

  /**
   *
   *
   * <pre>
   * The maximum number of results to return in a single response. If
   * not set to a positive number, a reasonable value will be chosen by the
   * service.
   * </pre>
   *
   * <code>int32 page_size = 3;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` must contain a value returned as the
   * `next_page_token` in a previous response to request the next set
   * of results.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` must contain a value returned as the
   * `next_page_token` in a previous response to request the next set
   * of results.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();
}
