/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/notification.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A description of a notification channel. The descriptor includes
 * the properties of the channel and the set of labels or fields that
 * must be specified to configure channels of a given type.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.NotificationChannelDescriptor}
 */
public final class NotificationChannelDescriptor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.NotificationChannelDescriptor)
    NotificationChannelDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationChannelDescriptor.newBuilder() to construct.
  private NotificationChannelDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationChannelDescriptor() {
    name_ = "";
    type_ = "";
    displayName_ = "";
    description_ = "";
    labels_ = java.util.Collections.emptyList();
    supportedTiers_ = java.util.Collections.emptyList();
    launchStage_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotificationChannelDescriptor();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private NotificationChannelDescriptor(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              type_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ = new java.util.ArrayList<com.google.api.LabelDescriptor>();
                mutable_bitField0_ |= 0x00000001;
              }
              labels_.add(
                  input.readMessage(com.google.api.LabelDescriptor.parser(), extensionRegistry));
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                supportedTiers_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000002;
              }
              supportedTiers_.add(rawValue);
              break;
            }
          case 42:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  supportedTiers_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000002;
                }
                supportedTiers_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              launchStage_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        labels_ = java.util.Collections.unmodifiableList(labels_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        supportedTiers_ = java.util.Collections.unmodifiableList(supportedTiers_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.NotificationProto
        .internal_static_google_monitoring_v3_NotificationChannelDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.NotificationProto
        .internal_static_google_monitoring_v3_NotificationChannelDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.NotificationChannelDescriptor.class,
            com.google.monitoring.v3.NotificationChannelDescriptor.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The full REST resource name for this descriptor. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
   * In the above, `[TYPE]` is the value of the `type` field.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full REST resource name for this descriptor. The format is:
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
   * In the above, `[TYPE]` is the value of the `type` field.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object type_;
  /**
   *
   *
   * <pre>
   * The type of notification channel, such as "email" and "sms". To view the
   * full list of channels, see
   * [Channel
   * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
   * Notification channel types are globally unique.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of notification channel, such as "email" and "sms". To view the
   * full list of channels, see
   * [Channel
   * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
   * Notification channel types are globally unique.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * A human-readable name for the notification channel type.  This
   * form of the name is suitable for a user interface.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable name for the notification channel type.  This
   * form of the name is suitable for a user interface.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * A human-readable description of the notification channel
   * type. The description may include a description of the properties
   * of the channel and pointers to external documentation.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable description of the notification channel
   * type. The description may include a description of the properties
   * of the channel and pointers to external documentation.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 4;
  private java.util.List<com.google.api.LabelDescriptor> labels_;
  /**
   *
   *
   * <pre>
   * The set of labels that must be defined to identify a particular
   * channel of the corresponding type. Each label includes a
   * description for how that field should be populated.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.LabelDescriptor> getLabelsList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that must be defined to identify a particular
   * channel of the corresponding type. Each label includes a
   * description for how that field should be populated.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.LabelDescriptorOrBuilder>
      getLabelsOrBuilderList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that must be defined to identify a particular
   * channel of the corresponding type. Each label includes a
   * description for how that field should be populated.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of labels that must be defined to identify a particular
   * channel of the corresponding type. Each label includes a
   * description for how that field should be populated.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public com.google.api.LabelDescriptor getLabels(int index) {
    return labels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of labels that must be defined to identify a particular
   * channel of the corresponding type. Each label includes a
   * description for how that field should be populated.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
    return labels_.get(index);
  }

  public static final int SUPPORTED_TIERS_FIELD_NUMBER = 5;
  private java.util.List<java.lang.Integer> supportedTiers_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.monitoring.v3.ServiceTier>
      supportedTiers_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.monitoring.v3.ServiceTier>() {
            public com.google.monitoring.v3.ServiceTier convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.monitoring.v3.ServiceTier result =
                  com.google.monitoring.v3.ServiceTier.valueOf(from);
              return result == null ? com.google.monitoring.v3.ServiceTier.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The tiers that support this notification channel; the project service tier
   * must be one of the supported_tiers.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
   * </code>
   *
   * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
   *     See google/monitoring/v3/notification.proto;l=75
   * @return A list containing the supportedTiers.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.monitoring.v3.ServiceTier> getSupportedTiersList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.monitoring.v3.ServiceTier>(
        supportedTiers_, supportedTiers_converter_);
  }
  /**
   *
   *
   * <pre>
   * The tiers that support this notification channel; the project service tier
   * must be one of the supported_tiers.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
   * </code>
   *
   * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
   *     See google/monitoring/v3/notification.proto;l=75
   * @return The count of supportedTiers.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getSupportedTiersCount() {
    return supportedTiers_.size();
  }
  /**
   *
   *
   * <pre>
   * The tiers that support this notification channel; the project service tier
   * must be one of the supported_tiers.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
   * </code>
   *
   * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
   *     See google/monitoring/v3/notification.proto;l=75
   * @param index The index of the element to return.
   * @return The supportedTiers at the given index.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.monitoring.v3.ServiceTier getSupportedTiers(int index) {
    return supportedTiers_converter_.convert(supportedTiers_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The tiers that support this notification channel; the project service tier
   * must be one of the supported_tiers.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
   * </code>
   *
   * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
   *     See google/monitoring/v3/notification.proto;l=75
   * @return A list containing the enum numeric values on the wire for supportedTiers.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<java.lang.Integer> getSupportedTiersValueList() {
    return supportedTiers_;
  }
  /**
   *
   *
   * <pre>
   * The tiers that support this notification channel; the project service tier
   * must be one of the supported_tiers.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
   * </code>
   *
   * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
   *     See google/monitoring/v3/notification.proto;l=75
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedTiers at the given index.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getSupportedTiersValue(int index) {
    return supportedTiers_.get(index);
  }

  private int supportedTiersMemoizedSerializedSize;

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 7;
  private int launchStage_;
  /**
   *
   *
   * <pre>
   * The product launch stage for channels of this type.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 7;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * The product launch stage for channels of this type.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 7;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.api.LaunchStage getLaunchStage() {
    @SuppressWarnings("deprecation")
    com.google.api.LaunchStage result = com.google.api.LaunchStage.valueOf(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      output.writeMessage(4, labels_.get(i));
    }
    if (getSupportedTiersList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(supportedTiersMemoizedSerializedSize);
    }
    for (int i = 0; i < supportedTiers_.size(); i++) {
      output.writeEnumNoTag(supportedTiers_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, launchStage_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedTiers_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(supportedTiers_.get(i));
      }
      size += dataSize;
      if (!getSupportedTiersList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      supportedTiersMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, launchStage_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.NotificationChannelDescriptor)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.NotificationChannelDescriptor other =
        (com.google.monitoring.v3.NotificationChannelDescriptor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getLabelsList().equals(other.getLabelsList())) return false;
    if (!supportedTiers_.equals(other.supportedTiers_)) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    if (getSupportedTiersCount() > 0) {
      hash = (37 * hash) + SUPPORTED_TIERS_FIELD_NUMBER;
      hash = (53 * hash) + supportedTiers_.hashCode();
    }
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.monitoring.v3.NotificationChannelDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A description of a notification channel. The descriptor includes
   * the properties of the channel and the set of labels or fields that
   * must be specified to configure channels of a given type.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.NotificationChannelDescriptor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.NotificationChannelDescriptor)
      com.google.monitoring.v3.NotificationChannelDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannelDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannelDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.NotificationChannelDescriptor.class,
              com.google.monitoring.v3.NotificationChannelDescriptor.Builder.class);
    }

    // Construct using com.google.monitoring.v3.NotificationChannelDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLabelsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      type_ = "";

      displayName_ = "";

      description_ = "";

      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        labelsBuilder_.clear();
      }
      supportedTiers_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      launchStage_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannelDescriptor_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannelDescriptor getDefaultInstanceForType() {
      return com.google.monitoring.v3.NotificationChannelDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannelDescriptor build() {
      com.google.monitoring.v3.NotificationChannelDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannelDescriptor buildPartial() {
      com.google.monitoring.v3.NotificationChannelDescriptor result =
          new com.google.monitoring.v3.NotificationChannelDescriptor(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.type_ = type_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          labels_ = java.util.Collections.unmodifiableList(labels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.labels_ = labels_;
      } else {
        result.labels_ = labelsBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        supportedTiers_ = java.util.Collections.unmodifiableList(supportedTiers_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.supportedTiers_ = supportedTiers_;
      result.launchStage_ = launchStage_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.NotificationChannelDescriptor) {
        return mergeFrom((com.google.monitoring.v3.NotificationChannelDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.NotificationChannelDescriptor other) {
      if (other == com.google.monitoring.v3.NotificationChannelDescriptor.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (labelsBuilder_ == null) {
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
      } else {
        if (!other.labels_.isEmpty()) {
          if (labelsBuilder_.isEmpty()) {
            labelsBuilder_.dispose();
            labelsBuilder_ = null;
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            labelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelsFieldBuilder()
                    : null;
          } else {
            labelsBuilder_.addAllMessages(other.labels_);
          }
        }
      }
      if (!other.supportedTiers_.isEmpty()) {
        if (supportedTiers_.isEmpty()) {
          supportedTiers_ = other.supportedTiers_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureSupportedTiersIsMutable();
          supportedTiers_.addAll(other.supportedTiers_);
        }
        onChanged();
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.NotificationChannelDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.monitoring.v3.NotificationChannelDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full REST resource name for this descriptor. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
     * In the above, `[TYPE]` is the value of the `type` field.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this descriptor. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
     * In the above, `[TYPE]` is the value of the `type` field.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this descriptor. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
     * In the above, `[TYPE]` is the value of the `type` field.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this descriptor. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
     * In the above, `[TYPE]` is the value of the `type` field.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this descriptor. The format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[TYPE]
     * In the above, `[TYPE]` is the value of the `type` field.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of notification channel, such as "email" and "sms". To view the
     * full list of channels, see
     * [Channel
     * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
     * Notification channel types are globally unique.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of notification channel, such as "email" and "sms". To view the
     * full list of channels, see
     * [Channel
     * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
     * Notification channel types are globally unique.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of notification channel, such as "email" and "sms". To view the
     * full list of channels, see
     * [Channel
     * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
     * Notification channel types are globally unique.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of notification channel, such as "email" and "sms". To view the
     * full list of channels, see
     * [Channel
     * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
     * Notification channel types are globally unique.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = getDefaultInstance().getType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of notification channel, such as "email" and "sms". To view the
     * full list of channels, see
     * [Channel
     * descriptors](https://cloud.google.com/monitoring/alerts/using-channels-api#ncd).
     * Notification channel types are globally unique.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      type_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable name for the notification channel type.  This
     * form of the name is suitable for a user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable name for the notification channel type.  This
     * form of the name is suitable for a user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable name for the notification channel type.  This
     * form of the name is suitable for a user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable name for the notification channel type.  This
     * form of the name is suitable for a user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable name for the notification channel type.  This
     * form of the name is suitable for a user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable description of the notification channel
     * type. The description may include a description of the properties
     * of the channel and pointers to external documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the notification channel
     * type. The description may include a description of the properties
     * of the channel and pointers to external documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the notification channel
     * type. The description may include a description of the properties
     * of the channel and pointers to external documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the notification channel
     * type. The description may include a description of the properties
     * of the channel and pointers to external documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the notification channel
     * type. The description may include a description of the properties
     * of the channel and pointers to external documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.LabelDescriptor> labels_ =
        java.util.Collections.emptyList();

    private void ensureLabelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        labels_ = new java.util.ArrayList<com.google.api.LabelDescriptor>(labels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            com.google.api.LabelDescriptor.Builder,
            com.google.api.LabelDescriptorOrBuilder>
        labelsBuilder_;

    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public java.util.List<com.google.api.LabelDescriptor> getLabelsList() {
      if (labelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labels_);
      } else {
        return labelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public int getLabelsCount() {
      if (labelsBuilder_ == null) {
        return labels_.size();
      } else {
        return labelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.google.api.LabelDescriptor getLabels(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder setLabels(int index, com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder setLabels(int index, com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(int index, com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(index, value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(int index, com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addAllLabels(
        java.lang.Iterable<? extends com.google.api.LabelDescriptor> values) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
      } else {
        labelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder clearLabels() {
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        labelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder removeLabels(int index) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.remove(index);
        onChanged();
      } else {
        labelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.google.api.LabelDescriptor.Builder getLabelsBuilder(int index) {
      return getLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public java.util.List<? extends com.google.api.LabelDescriptorOrBuilder>
        getLabelsOrBuilderList() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labels_);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.google.api.LabelDescriptor.Builder addLabelsBuilder() {
      return getLabelsFieldBuilder()
          .addBuilder(com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.google.api.LabelDescriptor.Builder addLabelsBuilder(int index) {
      return getLabelsFieldBuilder()
          .addBuilder(index, com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that must be defined to identify a particular
     * channel of the corresponding type. Each label includes a
     * description for how that field should be populated.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public java.util.List<com.google.api.LabelDescriptor.Builder> getLabelsBuilderList() {
      return getLabelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            com.google.api.LabelDescriptor.Builder,
            com.google.api.LabelDescriptorOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.LabelDescriptor,
                com.google.api.LabelDescriptor.Builder,
                com.google.api.LabelDescriptorOrBuilder>(
                labels_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private java.util.List<java.lang.Integer> supportedTiers_ = java.util.Collections.emptyList();

    private void ensureSupportedTiersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        supportedTiers_ = new java.util.ArrayList<java.lang.Integer>(supportedTiers_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @return A list containing the supportedTiers.
     */
    @java.lang.Deprecated
    public java.util.List<com.google.monitoring.v3.ServiceTier> getSupportedTiersList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.monitoring.v3.ServiceTier>(
          supportedTiers_, supportedTiers_converter_);
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @return The count of supportedTiers.
     */
    @java.lang.Deprecated
    public int getSupportedTiersCount() {
      return supportedTiers_.size();
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param index The index of the element to return.
     * @return The supportedTiers at the given index.
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.ServiceTier getSupportedTiers(int index) {
      return supportedTiers_converter_.convert(supportedTiers_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param index The index to set the value at.
     * @param value The supportedTiers to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSupportedTiers(int index, com.google.monitoring.v3.ServiceTier value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedTiersIsMutable();
      supportedTiers_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param value The supportedTiers to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addSupportedTiers(com.google.monitoring.v3.ServiceTier value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedTiersIsMutable();
      supportedTiers_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param values The supportedTiers to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllSupportedTiers(
        java.lang.Iterable<? extends com.google.monitoring.v3.ServiceTier> values) {
      ensureSupportedTiersIsMutable();
      for (com.google.monitoring.v3.ServiceTier value : values) {
        supportedTiers_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSupportedTiers() {
      supportedTiers_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @return A list containing the enum numeric values on the wire for supportedTiers.
     */
    @java.lang.Deprecated
    public java.util.List<java.lang.Integer> getSupportedTiersValueList() {
      return java.util.Collections.unmodifiableList(supportedTiers_);
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedTiers at the given index.
     */
    @java.lang.Deprecated
    public int getSupportedTiersValue(int index) {
      return supportedTiers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedTiers at the given index.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSupportedTiersValue(int index, int value) {
      ensureSupportedTiersIsMutable();
      supportedTiers_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param value The enum numeric value on the wire for supportedTiers to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addSupportedTiersValue(int value) {
      ensureSupportedTiersIsMutable();
      supportedTiers_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tiers that support this notification channel; the project service tier
     * must be one of the supported_tiers.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.ServiceTier supported_tiers = 5 [deprecated = true];
     * </code>
     *
     * @deprecated google.monitoring.v3.NotificationChannelDescriptor.supported_tiers is deprecated.
     *     See google/monitoring/v3/notification.proto;l=75
     * @param values The enum numeric values on the wire for supportedTiers to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllSupportedTiersValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSupportedTiersIsMutable();
      for (int value : values) {
        supportedTiers_.add(value);
      }
      onChanged();
      return this;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * The product launch stage for channels of this type.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * The product launch stage for channels of this type.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {

      launchStage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product launch stage for channels of this type.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.api.LaunchStage getLaunchStage() {
      @SuppressWarnings("deprecation")
      com.google.api.LaunchStage result = com.google.api.LaunchStage.valueOf(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The product launch stage for channels of this type.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }

      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product launch stage for channels of this type.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {

      launchStage_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.NotificationChannelDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.NotificationChannelDescriptor)
  private static final com.google.monitoring.v3.NotificationChannelDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.NotificationChannelDescriptor();
  }

  public static com.google.monitoring.v3.NotificationChannelDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationChannelDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<NotificationChannelDescriptor>() {
        @java.lang.Override
        public NotificationChannelDescriptor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new NotificationChannelDescriptor(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<NotificationChannelDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationChannelDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.NotificationChannelDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
