/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/service.proto

// Protobuf Java Version: 3.25.2
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A `Service` is a discrete, autonomous, and network-accessible unit, designed
 * to solve an individual concern
 * ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
 * Cloud Monitoring, a `Service` acts as the root resource under which
 * operational aspects of the service are accessible.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.Service}
 */
public final class Service extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service)
    ServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Service.newBuilder() to construct.
  private Service(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Service() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Service();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_Service_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 14:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_Service_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.Service.class, com.google.monitoring.v3.Service.Builder.class);
  }

  public interface CustomOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.Custom)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Custom view of service telemetry. Currently a place-holder pending final
   * design.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.Custom}
   */
  public static final class Custom extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.Custom)
      CustomOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Custom.newBuilder() to construct.
    private Custom(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Custom() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Custom();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Custom_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Custom_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.Custom.class,
              com.google.monitoring.v3.Service.Custom.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.Custom)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.Custom other = (com.google.monitoring.v3.Service.Custom) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Custom parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Custom parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.Custom prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Custom view of service telemetry. Currently a place-holder pending final
     * design.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.Custom}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.Custom)
        com.google.monitoring.v3.Service.CustomOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Custom_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Custom_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.Custom.class,
                com.google.monitoring.v3.Service.Custom.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.Custom.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Custom_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Custom getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Custom build() {
        com.google.monitoring.v3.Service.Custom result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Custom buildPartial() {
        com.google.monitoring.v3.Service.Custom result =
            new com.google.monitoring.v3.Service.Custom(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.Custom) {
          return mergeFrom((com.google.monitoring.v3.Service.Custom) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.Custom other) {
        if (other == com.google.monitoring.v3.Service.Custom.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.Custom)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.Custom)
    private static final com.google.monitoring.v3.Service.Custom DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.Custom();
    }

    public static com.google.monitoring.v3.Service.Custom getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Custom> PARSER =
        new com.google.protobuf.AbstractParser<Custom>() {
          @java.lang.Override
          public Custom parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Custom> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Custom> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.Custom getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AppEngineOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.AppEngine)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The moduleId.
     */
    java.lang.String getModuleId();
    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The bytes for moduleId.
     */
    com.google.protobuf.ByteString getModuleIdBytes();
  }
  /**
   *
   *
   * <pre>
   * App Engine service. Learn more at https://cloud.google.com/appengine.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.AppEngine}
   */
  public static final class AppEngine extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.AppEngine)
      AppEngineOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AppEngine.newBuilder() to construct.
    private AppEngine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AppEngine() {
      moduleId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AppEngine();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_AppEngine_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_AppEngine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.AppEngine.class,
              com.google.monitoring.v3.Service.AppEngine.Builder.class);
    }

    public static final int MODULE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object moduleId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The moduleId.
     */
    @java.lang.Override
    public java.lang.String getModuleId() {
      java.lang.Object ref = moduleId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        moduleId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the App Engine module underlying this service. Corresponds to
     * the `module_id` resource label in the `gae_app` monitored resource:
     * https://cloud.google.com/monitoring/api/resources#tag_gae_app
     * </pre>
     *
     * <code>string module_id = 1;</code>
     *
     * @return The bytes for moduleId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModuleIdBytes() {
      java.lang.Object ref = moduleId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        moduleId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(moduleId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, moduleId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(moduleId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, moduleId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.AppEngine)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.AppEngine other =
          (com.google.monitoring.v3.Service.AppEngine) obj;

      if (!getModuleId().equals(other.getModuleId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODULE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getModuleId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.AppEngine parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.AppEngine prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * App Engine service. Learn more at https://cloud.google.com/appengine.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.AppEngine}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.AppEngine)
        com.google.monitoring.v3.Service.AppEngineOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_AppEngine_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_AppEngine_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.AppEngine.class,
                com.google.monitoring.v3.Service.AppEngine.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.AppEngine.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        moduleId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_AppEngine_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.AppEngine getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.AppEngine build() {
        com.google.monitoring.v3.Service.AppEngine result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.AppEngine buildPartial() {
        com.google.monitoring.v3.Service.AppEngine result =
            new com.google.monitoring.v3.Service.AppEngine(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Service.AppEngine result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.moduleId_ = moduleId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.AppEngine) {
          return mergeFrom((com.google.monitoring.v3.Service.AppEngine) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.AppEngine other) {
        if (other == com.google.monitoring.v3.Service.AppEngine.getDefaultInstance()) return this;
        if (!other.getModuleId().isEmpty()) {
          moduleId_ = other.moduleId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  moduleId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object moduleId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @return The moduleId.
       */
      public java.lang.String getModuleId() {
        java.lang.Object ref = moduleId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          moduleId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @return The bytes for moduleId.
       */
      public com.google.protobuf.ByteString getModuleIdBytes() {
        java.lang.Object ref = moduleId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          moduleId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @param value The moduleId to set.
       * @return This builder for chaining.
       */
      public Builder setModuleId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        moduleId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModuleId() {
        moduleId_ = getDefaultInstance().getModuleId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the App Engine module underlying this service. Corresponds to
       * the `module_id` resource label in the `gae_app` monitored resource:
       * https://cloud.google.com/monitoring/api/resources#tag_gae_app
       * </pre>
       *
       * <code>string module_id = 1;</code>
       *
       * @param value The bytes for moduleId to set.
       * @return This builder for chaining.
       */
      public Builder setModuleIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        moduleId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.AppEngine)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.AppEngine)
    private static final com.google.monitoring.v3.Service.AppEngine DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.AppEngine();
    }

    public static com.google.monitoring.v3.Service.AppEngine getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AppEngine> PARSER =
        new com.google.protobuf.AbstractParser<AppEngine>() {
          @java.lang.Override
          public AppEngine parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AppEngine> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AppEngine> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.AppEngine getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudEndpointsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.CloudEndpoints)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();
  }
  /**
   *
   *
   * <pre>
   * Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.CloudEndpoints}
   */
  public static final class CloudEndpoints extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.CloudEndpoints)
      CloudEndpointsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudEndpoints.newBuilder() to construct.
    private CloudEndpoints(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudEndpoints() {
      service_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudEndpoints();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_CloudEndpoints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_CloudEndpoints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.CloudEndpoints.class,
              com.google.monitoring.v3.Service.CloudEndpoints.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud Endpoints service underlying this service.
     * Corresponds to the `service` resource label in the `api` monitored
     * resource: https://cloud.google.com/monitoring/api/resources#tag_api
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.CloudEndpoints)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.CloudEndpoints other =
          (com.google.monitoring.v3.Service.CloudEndpoints) obj;

      if (!getService().equals(other.getService())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.CloudEndpoints prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.CloudEndpoints}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.CloudEndpoints)
        com.google.monitoring.v3.Service.CloudEndpointsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_CloudEndpoints_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_CloudEndpoints_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.CloudEndpoints.class,
                com.google.monitoring.v3.Service.CloudEndpoints.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.CloudEndpoints.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        service_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_CloudEndpoints_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.CloudEndpoints getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.CloudEndpoints build() {
        com.google.monitoring.v3.Service.CloudEndpoints result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.CloudEndpoints buildPartial() {
        com.google.monitoring.v3.Service.CloudEndpoints result =
            new com.google.monitoring.v3.Service.CloudEndpoints(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Service.CloudEndpoints result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.service_ = service_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.CloudEndpoints) {
          return mergeFrom((com.google.monitoring.v3.Service.CloudEndpoints) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.CloudEndpoints other) {
        if (other == com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance())
          return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  service_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {
        service_ = getDefaultInstance().getService();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud Endpoints service underlying this service.
       * Corresponds to the `service` resource label in the `api` monitored
       * resource: https://cloud.google.com/monitoring/api/resources#tag_api
       * </pre>
       *
       * <code>string service = 1;</code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.CloudEndpoints)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.CloudEndpoints)
    private static final com.google.monitoring.v3.Service.CloudEndpoints DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.CloudEndpoints();
    }

    public static com.google.monitoring.v3.Service.CloudEndpoints getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudEndpoints> PARSER =
        new com.google.protobuf.AbstractParser<CloudEndpoints>() {
          @java.lang.Override
          public CloudEndpoints parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudEndpoints> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudEndpoints> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.CloudEndpoints getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ClusterIstioOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.ClusterIstio)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The clusterName.
     */
    java.lang.String getClusterName();
    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The bytes for clusterName.
     */
    com.google.protobuf.ByteString getClusterNameBytes();

    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The serviceNamespace.
     */
    java.lang.String getServiceNamespace();
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The bytes for serviceNamespace.
     */
    com.google.protobuf.ByteString getServiceNamespaceBytes();

    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The serviceName.
     */
    java.lang.String getServiceName();
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The bytes for serviceName.
     */
    com.google.protobuf.ByteString getServiceNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Istio service scoped to a single Kubernetes cluster. Learn more at
   * https://istio.io. Clusters running OSS Istio will have their services
   * ingested as this type.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.ClusterIstio}
   */
  public static final class ClusterIstio extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.ClusterIstio)
      ClusterIstioOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClusterIstio.newBuilder() to construct.
    private ClusterIstio(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterIstio() {
      location_ = "";
      clusterName_ = "";
      serviceNamespace_ = "";
      serviceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterIstio();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_ClusterIstio_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_ClusterIstio_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.ClusterIstio.class,
              com.google.monitoring.v3.Service.ClusterIstio.Builder.class);
    }

    public static final int LOCATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `location` resource label in `k8s_cluster`
     * resources.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLUSTER_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The clusterName.
     */
    @java.lang.Override
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Kubernetes cluster in which this Istio service is
     * defined. Corresponds to the `cluster_name` resource label in
     * `k8s_cluster` resources.
     * </pre>
     *
     * <code>string cluster_name = 2;</code>
     *
     * @return The bytes for clusterName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAMESPACE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceNamespace_ = "";
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The serviceNamespace.
     */
    @java.lang.Override
    public java.lang.String getServiceNamespace() {
      java.lang.Object ref = serviceNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceNamespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The bytes for serviceNamespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceNamespaceBytes() {
      java.lang.Object ref = serviceNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The serviceName.
     */
    @java.lang.Override
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The bytes for serviceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceNamespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serviceNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceNamespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serviceNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.ClusterIstio)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.ClusterIstio other =
          (com.google.monitoring.v3.Service.ClusterIstio) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (!getClusterName().equals(other.getClusterName())) return false;
      if (!getServiceNamespace().equals(other.getServiceNamespace())) return false;
      if (!getServiceName().equals(other.getServiceName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getClusterName().hashCode();
      hash = (37 * hash) + SERVICE_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getServiceNamespace().hashCode();
      hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getServiceName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.ClusterIstio parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.ClusterIstio prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Istio service scoped to a single Kubernetes cluster. Learn more at
     * https://istio.io. Clusters running OSS Istio will have their services
     * ingested as this type.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.ClusterIstio}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.ClusterIstio)
        com.google.monitoring.v3.Service.ClusterIstioOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_ClusterIstio_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_ClusterIstio_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.ClusterIstio.class,
                com.google.monitoring.v3.Service.ClusterIstio.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.ClusterIstio.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        location_ = "";
        clusterName_ = "";
        serviceNamespace_ = "";
        serviceName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_ClusterIstio_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.ClusterIstio getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.ClusterIstio build() {
        com.google.monitoring.v3.Service.ClusterIstio result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.ClusterIstio buildPartial() {
        com.google.monitoring.v3.Service.ClusterIstio result =
            new com.google.monitoring.v3.Service.ClusterIstio(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Service.ClusterIstio result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.location_ = location_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.clusterName_ = clusterName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.serviceNamespace_ = serviceNamespace_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.serviceName_ = serviceName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.ClusterIstio) {
          return mergeFrom((com.google.monitoring.v3.Service.ClusterIstio) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.ClusterIstio other) {
        if (other == com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance())
          return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getClusterName().isEmpty()) {
          clusterName_ = other.clusterName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getServiceNamespace().isEmpty()) {
          serviceNamespace_ = other.serviceNamespace_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getServiceName().isEmpty()) {
          serviceName_ = other.serviceName_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  location_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  clusterName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  serviceNamespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  serviceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {
        location_ = getDefaultInstance().getLocation();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `location` resource label in `k8s_cluster`
       * resources.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object clusterName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @return The clusterName.
       */
      public java.lang.String getClusterName() {
        java.lang.Object ref = clusterName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clusterName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @return The bytes for clusterName.
       */
      public com.google.protobuf.ByteString getClusterNameBytes() {
        java.lang.Object ref = clusterName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clusterName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @param value The clusterName to set.
       * @return This builder for chaining.
       */
      public Builder setClusterName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clusterName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterName() {
        clusterName_ = getDefaultInstance().getClusterName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Kubernetes cluster in which this Istio service is
       * defined. Corresponds to the `cluster_name` resource label in
       * `k8s_cluster` resources.
       * </pre>
       *
       * <code>string cluster_name = 2;</code>
       *
       * @param value The bytes for clusterName to set.
       * @return This builder for chaining.
       */
      public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clusterName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object serviceNamespace_ = "";
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return The serviceNamespace.
       */
      public java.lang.String getServiceNamespace() {
        java.lang.Object ref = serviceNamespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceNamespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return The bytes for serviceNamespace.
       */
      public com.google.protobuf.ByteString getServiceNamespaceBytes() {
        java.lang.Object ref = serviceNamespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceNamespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @param value The serviceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceNamespace_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceNamespace() {
        serviceNamespace_ = getDefaultInstance().getServiceNamespace();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @param value The bytes for serviceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceNamespace_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object serviceName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return The serviceName.
       */
      public java.lang.String getServiceName() {
        java.lang.Object ref = serviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return The bytes for serviceName.
       */
      public com.google.protobuf.ByteString getServiceNameBytes() {
        java.lang.Object ref = serviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @param value The serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceName() {
        serviceName_ = getDefaultInstance().getServiceName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @param value The bytes for serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.ClusterIstio)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.ClusterIstio)
    private static final com.google.monitoring.v3.Service.ClusterIstio DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.ClusterIstio();
    }

    public static com.google.monitoring.v3.Service.ClusterIstio getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterIstio> PARSER =
        new com.google.protobuf.AbstractParser<ClusterIstio>() {
          @java.lang.Override
          public ClusterIstio parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClusterIstio> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterIstio> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.ClusterIstio getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MeshIstioOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.MeshIstio)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Identifier for the mesh in which this Istio service is defined.
     * Corresponds to the `mesh_uid` metric label in Istio metrics.
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The meshUid.
     */
    java.lang.String getMeshUid();
    /**
     *
     *
     * <pre>
     * Identifier for the mesh in which this Istio service is defined.
     * Corresponds to the `mesh_uid` metric label in Istio metrics.
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The bytes for meshUid.
     */
    com.google.protobuf.ByteString getMeshUidBytes();

    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The serviceNamespace.
     */
    java.lang.String getServiceNamespace();
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The bytes for serviceNamespace.
     */
    com.google.protobuf.ByteString getServiceNamespaceBytes();

    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The serviceName.
     */
    java.lang.String getServiceName();
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The bytes for serviceName.
     */
    com.google.protobuf.ByteString getServiceNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Istio service scoped to an Istio mesh. Anthos clusters running ASM &lt; 1.6.8
   * will have their services ingested as this type.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.MeshIstio}
   */
  public static final class MeshIstio extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.MeshIstio)
      MeshIstioOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MeshIstio.newBuilder() to construct.
    private MeshIstio(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MeshIstio() {
      meshUid_ = "";
      serviceNamespace_ = "";
      serviceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MeshIstio();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_MeshIstio_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_MeshIstio_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.MeshIstio.class,
              com.google.monitoring.v3.Service.MeshIstio.Builder.class);
    }

    public static final int MESH_UID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object meshUid_ = "";
    /**
     *
     *
     * <pre>
     * Identifier for the mesh in which this Istio service is defined.
     * Corresponds to the `mesh_uid` metric label in Istio metrics.
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The meshUid.
     */
    @java.lang.Override
    public java.lang.String getMeshUid() {
      java.lang.Object ref = meshUid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        meshUid_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier for the mesh in which this Istio service is defined.
     * Corresponds to the `mesh_uid` metric label in Istio metrics.
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The bytes for meshUid.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMeshUidBytes() {
      java.lang.Object ref = meshUid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        meshUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAMESPACE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceNamespace_ = "";
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The serviceNamespace.
     */
    @java.lang.Override
    public java.lang.String getServiceNamespace() {
      java.lang.Object ref = serviceNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceNamespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The namespace of the Istio service underlying this service. Corresponds
     * to the `destination_service_namespace` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_namespace = 3;</code>
     *
     * @return The bytes for serviceNamespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceNamespaceBytes() {
      java.lang.Object ref = serviceNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The serviceName.
     */
    @java.lang.Override
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Istio service underlying this service. Corresponds to the
     * `destination_service_name` metric label in Istio metrics.
     * </pre>
     *
     * <code>string service_name = 4;</code>
     *
     * @return The bytes for serviceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meshUid_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, meshUid_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceNamespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serviceNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meshUid_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, meshUid_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceNamespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serviceNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.MeshIstio)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.MeshIstio other =
          (com.google.monitoring.v3.Service.MeshIstio) obj;

      if (!getMeshUid().equals(other.getMeshUid())) return false;
      if (!getServiceNamespace().equals(other.getServiceNamespace())) return false;
      if (!getServiceName().equals(other.getServiceName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MESH_UID_FIELD_NUMBER;
      hash = (53 * hash) + getMeshUid().hashCode();
      hash = (37 * hash) + SERVICE_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getServiceNamespace().hashCode();
      hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getServiceName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.MeshIstio parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.MeshIstio prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Istio service scoped to an Istio mesh. Anthos clusters running ASM &lt; 1.6.8
     * will have their services ingested as this type.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.MeshIstio}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.MeshIstio)
        com.google.monitoring.v3.Service.MeshIstioOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_MeshIstio_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_MeshIstio_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.MeshIstio.class,
                com.google.monitoring.v3.Service.MeshIstio.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.MeshIstio.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        meshUid_ = "";
        serviceNamespace_ = "";
        serviceName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_MeshIstio_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.MeshIstio getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.MeshIstio build() {
        com.google.monitoring.v3.Service.MeshIstio result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.MeshIstio buildPartial() {
        com.google.monitoring.v3.Service.MeshIstio result =
            new com.google.monitoring.v3.Service.MeshIstio(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Service.MeshIstio result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.meshUid_ = meshUid_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.serviceNamespace_ = serviceNamespace_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.serviceName_ = serviceName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.MeshIstio) {
          return mergeFrom((com.google.monitoring.v3.Service.MeshIstio) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.MeshIstio other) {
        if (other == com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance()) return this;
        if (!other.getMeshUid().isEmpty()) {
          meshUid_ = other.meshUid_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getServiceNamespace().isEmpty()) {
          serviceNamespace_ = other.serviceNamespace_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getServiceName().isEmpty()) {
          serviceName_ = other.serviceName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  meshUid_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  serviceNamespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  serviceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object meshUid_ = "";
      /**
       *
       *
       * <pre>
       * Identifier for the mesh in which this Istio service is defined.
       * Corresponds to the `mesh_uid` metric label in Istio metrics.
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @return The meshUid.
       */
      public java.lang.String getMeshUid() {
        java.lang.Object ref = meshUid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          meshUid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifier for the mesh in which this Istio service is defined.
       * Corresponds to the `mesh_uid` metric label in Istio metrics.
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @return The bytes for meshUid.
       */
      public com.google.protobuf.ByteString getMeshUidBytes() {
        java.lang.Object ref = meshUid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          meshUid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifier for the mesh in which this Istio service is defined.
       * Corresponds to the `mesh_uid` metric label in Istio metrics.
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @param value The meshUid to set.
       * @return This builder for chaining.
       */
      public Builder setMeshUid(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        meshUid_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifier for the mesh in which this Istio service is defined.
       * Corresponds to the `mesh_uid` metric label in Istio metrics.
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMeshUid() {
        meshUid_ = getDefaultInstance().getMeshUid();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifier for the mesh in which this Istio service is defined.
       * Corresponds to the `mesh_uid` metric label in Istio metrics.
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @param value The bytes for meshUid to set.
       * @return This builder for chaining.
       */
      public Builder setMeshUidBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        meshUid_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object serviceNamespace_ = "";
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return The serviceNamespace.
       */
      public java.lang.String getServiceNamespace() {
        java.lang.Object ref = serviceNamespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceNamespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return The bytes for serviceNamespace.
       */
      public com.google.protobuf.ByteString getServiceNamespaceBytes() {
        java.lang.Object ref = serviceNamespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceNamespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @param value The serviceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceNamespace_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceNamespace() {
        serviceNamespace_ = getDefaultInstance().getServiceNamespace();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the Istio service underlying this service. Corresponds
       * to the `destination_service_namespace` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_namespace = 3;</code>
       *
       * @param value The bytes for serviceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceNamespace_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object serviceName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return The serviceName.
       */
      public java.lang.String getServiceName() {
        java.lang.Object ref = serviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return The bytes for serviceName.
       */
      public com.google.protobuf.ByteString getServiceNameBytes() {
        java.lang.Object ref = serviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @param value The serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceName() {
        serviceName_ = getDefaultInstance().getServiceName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Istio service underlying this service. Corresponds to the
       * `destination_service_name` metric label in Istio metrics.
       * </pre>
       *
       * <code>string service_name = 4;</code>
       *
       * @param value The bytes for serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.MeshIstio)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.MeshIstio)
    private static final com.google.monitoring.v3.Service.MeshIstio DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.MeshIstio();
    }

    public static com.google.monitoring.v3.Service.MeshIstio getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MeshIstio> PARSER =
        new com.google.protobuf.AbstractParser<MeshIstio>() {
          @java.lang.Override
          public MeshIstio parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MeshIstio> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MeshIstio> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.MeshIstio getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IstioCanonicalServiceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.IstioCanonicalService)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Identifier for the Istio mesh in which this canonical service is defined.
     * Corresponds to the `mesh_uid` metric label in
     * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The meshUid.
     */
    java.lang.String getMeshUid();
    /**
     *
     *
     * <pre>
     * Identifier for the Istio mesh in which this canonical service is defined.
     * Corresponds to the `mesh_uid` metric label in
     * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The bytes for meshUid.
     */
    com.google.protobuf.ByteString getMeshUidBytes();

    /**
     *
     *
     * <pre>
     * The namespace of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_namespace` metric
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service_namespace = 3;</code>
     *
     * @return The canonicalServiceNamespace.
     */
    java.lang.String getCanonicalServiceNamespace();
    /**
     *
     *
     * <pre>
     * The namespace of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_namespace` metric
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service_namespace = 3;</code>
     *
     * @return The bytes for canonicalServiceNamespace.
     */
    com.google.protobuf.ByteString getCanonicalServiceNamespaceBytes();

    /**
     *
     *
     * <pre>
     * The name of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_name` metric label in
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service = 4;</code>
     *
     * @return The canonicalService.
     */
    java.lang.String getCanonicalService();
    /**
     *
     *
     * <pre>
     * The name of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_name` metric label in
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service = 4;</code>
     *
     * @return The bytes for canonicalService.
     */
    com.google.protobuf.ByteString getCanonicalServiceBytes();
  }
  /**
   *
   *
   * <pre>
   * Canonical service scoped to an Istio mesh. Anthos clusters running ASM &gt;=
   * 1.6.8 will have their services ingested as this type.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.IstioCanonicalService}
   */
  public static final class IstioCanonicalService extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.IstioCanonicalService)
      IstioCanonicalServiceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IstioCanonicalService.newBuilder() to construct.
    private IstioCanonicalService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IstioCanonicalService() {
      meshUid_ = "";
      canonicalServiceNamespace_ = "";
      canonicalService_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IstioCanonicalService();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_IstioCanonicalService_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_IstioCanonicalService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.IstioCanonicalService.class,
              com.google.monitoring.v3.Service.IstioCanonicalService.Builder.class);
    }

    public static final int MESH_UID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object meshUid_ = "";
    /**
     *
     *
     * <pre>
     * Identifier for the Istio mesh in which this canonical service is defined.
     * Corresponds to the `mesh_uid` metric label in
     * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The meshUid.
     */
    @java.lang.Override
    public java.lang.String getMeshUid() {
      java.lang.Object ref = meshUid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        meshUid_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier for the Istio mesh in which this canonical service is defined.
     * Corresponds to the `mesh_uid` metric label in
     * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string mesh_uid = 1;</code>
     *
     * @return The bytes for meshUid.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMeshUidBytes() {
      java.lang.Object ref = meshUid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        meshUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CANONICAL_SERVICE_NAMESPACE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object canonicalServiceNamespace_ = "";
    /**
     *
     *
     * <pre>
     * The namespace of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_namespace` metric
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service_namespace = 3;</code>
     *
     * @return The canonicalServiceNamespace.
     */
    @java.lang.Override
    public java.lang.String getCanonicalServiceNamespace() {
      java.lang.Object ref = canonicalServiceNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        canonicalServiceNamespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The namespace of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_namespace` metric
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service_namespace = 3;</code>
     *
     * @return The bytes for canonicalServiceNamespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCanonicalServiceNamespaceBytes() {
      java.lang.Object ref = canonicalServiceNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        canonicalServiceNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CANONICAL_SERVICE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object canonicalService_ = "";
    /**
     *
     *
     * <pre>
     * The name of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_name` metric label in
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service = 4;</code>
     *
     * @return The canonicalService.
     */
    @java.lang.Override
    public java.lang.String getCanonicalService() {
      java.lang.Object ref = canonicalService_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        canonicalService_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the canonical service underlying this service.
     * Corresponds to the `destination_canonical_service_name` metric label in
     * label in [Istio
     * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
     * </pre>
     *
     * <code>string canonical_service = 4;</code>
     *
     * @return The bytes for canonicalService.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCanonicalServiceBytes() {
      java.lang.Object ref = canonicalService_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        canonicalService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meshUid_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, meshUid_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalServiceNamespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, canonicalServiceNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalService_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, canonicalService_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meshUid_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, meshUid_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalServiceNamespace_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(3, canonicalServiceNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalService_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, canonicalService_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.IstioCanonicalService)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.IstioCanonicalService other =
          (com.google.monitoring.v3.Service.IstioCanonicalService) obj;

      if (!getMeshUid().equals(other.getMeshUid())) return false;
      if (!getCanonicalServiceNamespace().equals(other.getCanonicalServiceNamespace()))
        return false;
      if (!getCanonicalService().equals(other.getCanonicalService())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MESH_UID_FIELD_NUMBER;
      hash = (53 * hash) + getMeshUid().hashCode();
      hash = (37 * hash) + CANONICAL_SERVICE_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getCanonicalServiceNamespace().hashCode();
      hash = (37 * hash) + CANONICAL_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getCanonicalService().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.Service.IstioCanonicalService prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Canonical service scoped to an Istio mesh. Anthos clusters running ASM &gt;=
     * 1.6.8 will have their services ingested as this type.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.IstioCanonicalService}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.IstioCanonicalService)
        com.google.monitoring.v3.Service.IstioCanonicalServiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_IstioCanonicalService_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_IstioCanonicalService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.IstioCanonicalService.class,
                com.google.monitoring.v3.Service.IstioCanonicalService.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.IstioCanonicalService.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        meshUid_ = "";
        canonicalServiceNamespace_ = "";
        canonicalService_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_IstioCanonicalService_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.IstioCanonicalService getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.IstioCanonicalService build() {
        com.google.monitoring.v3.Service.IstioCanonicalService result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.IstioCanonicalService buildPartial() {
        com.google.monitoring.v3.Service.IstioCanonicalService result =
            new com.google.monitoring.v3.Service.IstioCanonicalService(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Service.IstioCanonicalService result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.meshUid_ = meshUid_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.canonicalServiceNamespace_ = canonicalServiceNamespace_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.canonicalService_ = canonicalService_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.IstioCanonicalService) {
          return mergeFrom((com.google.monitoring.v3.Service.IstioCanonicalService) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.IstioCanonicalService other) {
        if (other == com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance())
          return this;
        if (!other.getMeshUid().isEmpty()) {
          meshUid_ = other.meshUid_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCanonicalServiceNamespace().isEmpty()) {
          canonicalServiceNamespace_ = other.canonicalServiceNamespace_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getCanonicalService().isEmpty()) {
          canonicalService_ = other.canonicalService_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  meshUid_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  canonicalServiceNamespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  canonicalService_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object meshUid_ = "";
      /**
       *
       *
       * <pre>
       * Identifier for the Istio mesh in which this canonical service is defined.
       * Corresponds to the `mesh_uid` metric label in
       * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @return The meshUid.
       */
      public java.lang.String getMeshUid() {
        java.lang.Object ref = meshUid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          meshUid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifier for the Istio mesh in which this canonical service is defined.
       * Corresponds to the `mesh_uid` metric label in
       * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @return The bytes for meshUid.
       */
      public com.google.protobuf.ByteString getMeshUidBytes() {
        java.lang.Object ref = meshUid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          meshUid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifier for the Istio mesh in which this canonical service is defined.
       * Corresponds to the `mesh_uid` metric label in
       * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @param value The meshUid to set.
       * @return This builder for chaining.
       */
      public Builder setMeshUid(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        meshUid_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifier for the Istio mesh in which this canonical service is defined.
       * Corresponds to the `mesh_uid` metric label in
       * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMeshUid() {
        meshUid_ = getDefaultInstance().getMeshUid();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifier for the Istio mesh in which this canonical service is defined.
       * Corresponds to the `mesh_uid` metric label in
       * [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string mesh_uid = 1;</code>
       *
       * @param value The bytes for meshUid to set.
       * @return This builder for chaining.
       */
      public Builder setMeshUidBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        meshUid_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object canonicalServiceNamespace_ = "";
      /**
       *
       *
       * <pre>
       * The namespace of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_namespace` metric
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service_namespace = 3;</code>
       *
       * @return The canonicalServiceNamespace.
       */
      public java.lang.String getCanonicalServiceNamespace() {
        java.lang.Object ref = canonicalServiceNamespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          canonicalServiceNamespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_namespace` metric
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service_namespace = 3;</code>
       *
       * @return The bytes for canonicalServiceNamespace.
       */
      public com.google.protobuf.ByteString getCanonicalServiceNamespaceBytes() {
        java.lang.Object ref = canonicalServiceNamespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          canonicalServiceNamespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The namespace of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_namespace` metric
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service_namespace = 3;</code>
       *
       * @param value The canonicalServiceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setCanonicalServiceNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        canonicalServiceNamespace_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_namespace` metric
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service_namespace = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCanonicalServiceNamespace() {
        canonicalServiceNamespace_ = getDefaultInstance().getCanonicalServiceNamespace();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The namespace of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_namespace` metric
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service_namespace = 3;</code>
       *
       * @param value The bytes for canonicalServiceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setCanonicalServiceNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        canonicalServiceNamespace_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object canonicalService_ = "";
      /**
       *
       *
       * <pre>
       * The name of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_name` metric label in
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service = 4;</code>
       *
       * @return The canonicalService.
       */
      public java.lang.String getCanonicalService() {
        java.lang.Object ref = canonicalService_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          canonicalService_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_name` metric label in
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service = 4;</code>
       *
       * @return The bytes for canonicalService.
       */
      public com.google.protobuf.ByteString getCanonicalServiceBytes() {
        java.lang.Object ref = canonicalService_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          canonicalService_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_name` metric label in
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service = 4;</code>
       *
       * @param value The canonicalService to set.
       * @return This builder for chaining.
       */
      public Builder setCanonicalService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        canonicalService_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_name` metric label in
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCanonicalService() {
        canonicalService_ = getDefaultInstance().getCanonicalService();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the canonical service underlying this service.
       * Corresponds to the `destination_canonical_service_name` metric label in
       * label in [Istio
       * metrics](https://cloud.google.com/monitoring/api/metrics_istio).
       * </pre>
       *
       * <code>string canonical_service = 4;</code>
       *
       * @param value The bytes for canonicalService to set.
       * @return This builder for chaining.
       */
      public Builder setCanonicalServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        canonicalService_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.IstioCanonicalService)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.IstioCanonicalService)
    private static final com.google.monitoring.v3.Service.IstioCanonicalService DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.IstioCanonicalService();
    }

    public static com.google.monitoring.v3.Service.IstioCanonicalService getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IstioCanonicalService> PARSER =
        new com.google.protobuf.AbstractParser<IstioCanonicalService>() {
          @java.lang.Override
          public IstioCanonicalService parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IstioCanonicalService> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IstioCanonicalService> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.IstioCanonicalService getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TelemetryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Service.Telemetry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The resourceName.
     */
    java.lang.String getResourceName();
    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The bytes for resourceName.
     */
    com.google.protobuf.ByteString getResourceNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service.Telemetry}
   */
  public static final class Telemetry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Service.Telemetry)
      TelemetryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Telemetry.newBuilder() to construct.
    private Telemetry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Telemetry() {
      resourceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Telemetry();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Telemetry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_Telemetry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.Telemetry.class,
              com.google.monitoring.v3.Service.Telemetry.Builder.class);
    }

    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The resourceName.
     */
    @java.lang.Override
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the resource that defines this service. Formatted as
     * described in https://cloud.google.com/apis/design/resource_names.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The bytes for resourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Service.Telemetry)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Service.Telemetry other =
          (com.google.monitoring.v3.Service.Telemetry) obj;

      if (!getResourceName().equals(other.getResourceName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getResourceName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Service.Telemetry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Service.Telemetry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Service.Telemetry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service.Telemetry)
        com.google.monitoring.v3.Service.TelemetryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Telemetry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Telemetry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Service.Telemetry.class,
                com.google.monitoring.v3.Service.Telemetry.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Service.Telemetry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resourceName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_Service_Telemetry_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Telemetry getDefaultInstanceForType() {
        return com.google.monitoring.v3.Service.Telemetry.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Telemetry build() {
        com.google.monitoring.v3.Service.Telemetry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Service.Telemetry buildPartial() {
        com.google.monitoring.v3.Service.Telemetry result =
            new com.google.monitoring.v3.Service.Telemetry(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Service.Telemetry result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.resourceName_ = resourceName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Service.Telemetry) {
          return mergeFrom((com.google.monitoring.v3.Service.Telemetry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Service.Telemetry other) {
        if (other == com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()) return this;
        if (!other.getResourceName().isEmpty()) {
          resourceName_ = other.resourceName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  resourceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object resourceName_ = "";
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @return The resourceName.
       */
      public java.lang.String getResourceName() {
        java.lang.Object ref = resourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @return The bytes for resourceName.
       */
      public com.google.protobuf.ByteString getResourceNameBytes() {
        java.lang.Object ref = resourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @param value The resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceName() {
        resourceName_ = getDefaultInstance().getResourceName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full name of the resource that defines this service. Formatted as
       * described in https://cloud.google.com/apis/design/resource_names.
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       *
       * @param value The bytes for resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service.Telemetry)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service.Telemetry)
    private static final com.google.monitoring.v3.Service.Telemetry DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Service.Telemetry();
    }

    public static com.google.monitoring.v3.Service.Telemetry getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Telemetry> PARSER =
        new com.google.protobuf.AbstractParser<Telemetry>() {
          @java.lang.Override
          public Telemetry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Telemetry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Telemetry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service.Telemetry getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int identifierCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object identifier_;

  public enum IdentifierCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CUSTOM(6),
    APP_ENGINE(7),
    CLOUD_ENDPOINTS(8),
    CLUSTER_ISTIO(9),
    MESH_ISTIO(10),
    ISTIO_CANONICAL_SERVICE(11),
    IDENTIFIER_NOT_SET(0);
    private final int value;

    private IdentifierCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IdentifierCase valueOf(int value) {
      return forNumber(value);
    }

    public static IdentifierCase forNumber(int value) {
      switch (value) {
        case 6:
          return CUSTOM;
        case 7:
          return APP_ENGINE;
        case 8:
          return CLOUD_ENDPOINTS;
        case 9:
          return CLUSTER_ISTIO;
        case 10:
          return MESH_ISTIO;
        case 11:
          return ISTIO_CANONICAL_SERVICE;
        case 0:
          return IDENTIFIER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IdentifierCase getIdentifierCase() {
    return IdentifierCase.forNumber(identifierCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name for this Service. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name for this Service. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Name used for UI elements listing this Service.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name used for UI elements listing this Service.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Custom service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
   *
   * @return Whether the custom field is set.
   */
  @java.lang.Override
  public boolean hasCustom() {
    return identifierCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Custom service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
   *
   * @return The custom.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.Custom getCustom() {
    if (identifierCase_ == 6) {
      return (com.google.monitoring.v3.Service.Custom) identifier_;
    }
    return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Custom service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.CustomOrBuilder getCustomOrBuilder() {
    if (identifierCase_ == 6) {
      return (com.google.monitoring.v3.Service.Custom) identifier_;
    }
    return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
  }

  public static final int APP_ENGINE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Type used for App Engine services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
   *
   * @return Whether the appEngine field is set.
   */
  @java.lang.Override
  public boolean hasAppEngine() {
    return identifierCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Type used for App Engine services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
   *
   * @return The appEngine.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.AppEngine getAppEngine() {
    if (identifierCase_ == 7) {
      return (com.google.monitoring.v3.Service.AppEngine) identifier_;
    }
    return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for App Engine services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.AppEngineOrBuilder getAppEngineOrBuilder() {
    if (identifierCase_ == 7) {
      return (com.google.monitoring.v3.Service.AppEngine) identifier_;
    }
    return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
  }

  public static final int CLOUD_ENDPOINTS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Type used for Cloud Endpoints services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
   *
   * @return Whether the cloudEndpoints field is set.
   */
  @java.lang.Override
  public boolean hasCloudEndpoints() {
    return identifierCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Type used for Cloud Endpoints services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
   *
   * @return The cloudEndpoints.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.CloudEndpoints getCloudEndpoints() {
    if (identifierCase_ == 8) {
      return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
    }
    return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for Cloud Endpoints services.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.CloudEndpointsOrBuilder getCloudEndpointsOrBuilder() {
    if (identifierCase_ == 8) {
      return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
    }
    return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
  }

  public static final int CLUSTER_ISTIO_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Type used for Istio services that live in a Kubernetes cluster.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
   *
   * @return Whether the clusterIstio field is set.
   */
  @java.lang.Override
  public boolean hasClusterIstio() {
    return identifierCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Type used for Istio services that live in a Kubernetes cluster.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
   *
   * @return The clusterIstio.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.ClusterIstio getClusterIstio() {
    if (identifierCase_ == 9) {
      return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
    }
    return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for Istio services that live in a Kubernetes cluster.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.ClusterIstioOrBuilder getClusterIstioOrBuilder() {
    if (identifierCase_ == 9) {
      return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
    }
    return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
  }

  public static final int MESH_ISTIO_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Type used for Istio services scoped to an Istio mesh.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
   *
   * @return Whether the meshIstio field is set.
   */
  @java.lang.Override
  public boolean hasMeshIstio() {
    return identifierCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Type used for Istio services scoped to an Istio mesh.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
   *
   * @return The meshIstio.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.MeshIstio getMeshIstio() {
    if (identifierCase_ == 10) {
      return (com.google.monitoring.v3.Service.MeshIstio) identifier_;
    }
    return com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for Istio services scoped to an Istio mesh.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.MeshIstioOrBuilder getMeshIstioOrBuilder() {
    if (identifierCase_ == 10) {
      return (com.google.monitoring.v3.Service.MeshIstio) identifier_;
    }
    return com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
  }

  public static final int ISTIO_CANONICAL_SERVICE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Type used for canonical services scoped to an Istio mesh.
   * Metrics for Istio are
   * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;</code>
   *
   * @return Whether the istioCanonicalService field is set.
   */
  @java.lang.Override
  public boolean hasIstioCanonicalService() {
    return identifierCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Type used for canonical services scoped to an Istio mesh.
   * Metrics for Istio are
   * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;</code>
   *
   * @return The istioCanonicalService.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.IstioCanonicalService getIstioCanonicalService() {
    if (identifierCase_ == 11) {
      return (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_;
    }
    return com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Type used for canonical services scoped to an Istio mesh.
   * Metrics for Istio are
   * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.IstioCanonicalServiceOrBuilder
      getIstioCanonicalServiceOrBuilder() {
    if (identifierCase_ == 11) {
      return (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_;
    }
    return com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
  }

  public static final int TELEMETRY_FIELD_NUMBER = 13;
  private com.google.monitoring.v3.Service.Telemetry telemetry_;
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
   *
   * @return Whether the telemetry field is set.
   */
  @java.lang.Override
  public boolean hasTelemetry() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
   *
   * @return The telemetry.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.Telemetry getTelemetry() {
    return telemetry_ == null
        ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
        : telemetry_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to query telemetry on a Service.
   * </pre>
   *
   * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Service.TelemetryOrBuilder getTelemetryOrBuilder() {
    return telemetry_ == null
        ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
        : telemetry_;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 14;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.ServiceMonitoringProto
                .internal_static_google_monitoring_v3_Service_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service. Label keys must start
   * with a letter. Label keys and values may contain lowercase letters,
   * numbers, underscores, and dashes. Label keys and values have a maximum
   * length of 63 characters, and must be less than 128 bytes in size. Up to 64
   * label entries may be stored. For labels which do not have a semantic value,
   * the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 14;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service. Label keys must start
   * with a letter. Label keys and values may contain lowercase letters,
   * numbers, underscores, and dashes. Label keys and values have a maximum
   * length of 63 characters, and must be less than 128 bytes in size. Up to 64
   * label entries may be stored. For labels which do not have a semantic value,
   * the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 14;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service. Label keys must start
   * with a letter. Label keys and values may contain lowercase letters,
   * numbers, underscores, and dashes. Label keys and values have a maximum
   * length of 63 characters, and must be less than 128 bytes in size. Up to 64
   * label entries may be stored. For labels which do not have a semantic value,
   * the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 14;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service. Label keys must start
   * with a letter. Label keys and values may contain lowercase letters,
   * numbers, underscores, and dashes. Label keys and values have a maximum
   * length of 63 characters, and must be less than 128 bytes in size. Up to 64
   * label entries may be stored. For labels which do not have a semantic value,
   * the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 14;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (identifierCase_ == 6) {
      output.writeMessage(6, (com.google.monitoring.v3.Service.Custom) identifier_);
    }
    if (identifierCase_ == 7) {
      output.writeMessage(7, (com.google.monitoring.v3.Service.AppEngine) identifier_);
    }
    if (identifierCase_ == 8) {
      output.writeMessage(8, (com.google.monitoring.v3.Service.CloudEndpoints) identifier_);
    }
    if (identifierCase_ == 9) {
      output.writeMessage(9, (com.google.monitoring.v3.Service.ClusterIstio) identifier_);
    }
    if (identifierCase_ == 10) {
      output.writeMessage(10, (com.google.monitoring.v3.Service.MeshIstio) identifier_);
    }
    if (identifierCase_ == 11) {
      output.writeMessage(11, (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getTelemetry());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 14);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (identifierCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.monitoring.v3.Service.Custom) identifier_);
    }
    if (identifierCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.monitoring.v3.Service.AppEngine) identifier_);
    }
    if (identifierCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.monitoring.v3.Service.CloudEndpoints) identifier_);
    }
    if (identifierCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.monitoring.v3.Service.ClusterIstio) identifier_);
    }
    if (identifierCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.monitoring.v3.Service.MeshIstio) identifier_);
    }
    if (identifierCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getTelemetry());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, userLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.Service)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.Service other = (com.google.monitoring.v3.Service) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasTelemetry() != other.hasTelemetry()) return false;
    if (hasTelemetry()) {
      if (!getTelemetry().equals(other.getTelemetry())) return false;
    }
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getIdentifierCase().equals(other.getIdentifierCase())) return false;
    switch (identifierCase_) {
      case 6:
        if (!getCustom().equals(other.getCustom())) return false;
        break;
      case 7:
        if (!getAppEngine().equals(other.getAppEngine())) return false;
        break;
      case 8:
        if (!getCloudEndpoints().equals(other.getCloudEndpoints())) return false;
        break;
      case 9:
        if (!getClusterIstio().equals(other.getClusterIstio())) return false;
        break;
      case 10:
        if (!getMeshIstio().equals(other.getMeshIstio())) return false;
        break;
      case 11:
        if (!getIstioCanonicalService().equals(other.getIstioCanonicalService())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasTelemetry()) {
      hash = (37 * hash) + TELEMETRY_FIELD_NUMBER;
      hash = (53 * hash) + getTelemetry().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    switch (identifierCase_) {
      case 6:
        hash = (37 * hash) + CUSTOM_FIELD_NUMBER;
        hash = (53 * hash) + getCustom().hashCode();
        break;
      case 7:
        hash = (37 * hash) + APP_ENGINE_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngine().hashCode();
        break;
      case 8:
        hash = (37 * hash) + CLOUD_ENDPOINTS_FIELD_NUMBER;
        hash = (53 * hash) + getCloudEndpoints().hashCode();
        break;
      case 9:
        hash = (37 * hash) + CLUSTER_ISTIO_FIELD_NUMBER;
        hash = (53 * hash) + getClusterIstio().hashCode();
        break;
      case 10:
        hash = (37 * hash) + MESH_ISTIO_FIELD_NUMBER;
        hash = (53 * hash) + getMeshIstio().hashCode();
        break;
      case 11:
        hash = (37 * hash) + ISTIO_CANONICAL_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getIstioCanonicalService().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.Service parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Service parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Service parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.Service prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `Service` is a discrete, autonomous, and network-accessible unit, designed
   * to solve an individual concern
   * ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
   * Cloud Monitoring, a `Service` acts as the root resource under which
   * operational aspects of the service are accessible.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Service}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Service)
      com.google.monitoring.v3.ServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 14:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 14:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Service.class,
              com.google.monitoring.v3.Service.Builder.class);
    }

    // Construct using com.google.monitoring.v3.Service.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTelemetryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (customBuilder_ != null) {
        customBuilder_.clear();
      }
      if (appEngineBuilder_ != null) {
        appEngineBuilder_.clear();
      }
      if (cloudEndpointsBuilder_ != null) {
        cloudEndpointsBuilder_.clear();
      }
      if (clusterIstioBuilder_ != null) {
        clusterIstioBuilder_.clear();
      }
      if (meshIstioBuilder_ != null) {
        meshIstioBuilder_.clear();
      }
      if (istioCanonicalServiceBuilder_ != null) {
        istioCanonicalServiceBuilder_.clear();
      }
      telemetry_ = null;
      if (telemetryBuilder_ != null) {
        telemetryBuilder_.dispose();
        telemetryBuilder_ = null;
      }
      internalGetMutableUserLabels().clear();
      identifierCase_ = 0;
      identifier_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_Service_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service getDefaultInstanceForType() {
      return com.google.monitoring.v3.Service.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service build() {
      com.google.monitoring.v3.Service result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Service buildPartial() {
      com.google.monitoring.v3.Service result = new com.google.monitoring.v3.Service(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.Service result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.telemetry_ = telemetryBuilder_ == null ? telemetry_ : telemetryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.monitoring.v3.Service result) {
      result.identifierCase_ = identifierCase_;
      result.identifier_ = this.identifier_;
      if (identifierCase_ == 6 && customBuilder_ != null) {
        result.identifier_ = customBuilder_.build();
      }
      if (identifierCase_ == 7 && appEngineBuilder_ != null) {
        result.identifier_ = appEngineBuilder_.build();
      }
      if (identifierCase_ == 8 && cloudEndpointsBuilder_ != null) {
        result.identifier_ = cloudEndpointsBuilder_.build();
      }
      if (identifierCase_ == 9 && clusterIstioBuilder_ != null) {
        result.identifier_ = clusterIstioBuilder_.build();
      }
      if (identifierCase_ == 10 && meshIstioBuilder_ != null) {
        result.identifier_ = meshIstioBuilder_.build();
      }
      if (identifierCase_ == 11 && istioCanonicalServiceBuilder_ != null) {
        result.identifier_ = istioCanonicalServiceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.Service) {
        return mergeFrom((com.google.monitoring.v3.Service) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.Service other) {
      if (other == com.google.monitoring.v3.Service.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasTelemetry()) {
        mergeTelemetry(other.getTelemetry());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000200;
      switch (other.getIdentifierCase()) {
        case CUSTOM:
          {
            mergeCustom(other.getCustom());
            break;
          }
        case APP_ENGINE:
          {
            mergeAppEngine(other.getAppEngine());
            break;
          }
        case CLOUD_ENDPOINTS:
          {
            mergeCloudEndpoints(other.getCloudEndpoints());
            break;
          }
        case CLUSTER_ISTIO:
          {
            mergeClusterIstio(other.getClusterIstio());
            break;
          }
        case MESH_ISTIO:
          {
            mergeMeshIstio(other.getMeshIstio());
            break;
          }
        case ISTIO_CANONICAL_SERVICE:
          {
            mergeIstioCanonicalService(other.getIstioCanonicalService());
            break;
          }
        case IDENTIFIER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 50:
              {
                input.readMessage(getCustomFieldBuilder().getBuilder(), extensionRegistry);
                identifierCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getAppEngineFieldBuilder().getBuilder(), extensionRegistry);
                identifierCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCloudEndpointsFieldBuilder().getBuilder(), extensionRegistry);
                identifierCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getClusterIstioFieldBuilder().getBuilder(), extensionRegistry);
                identifierCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getMeshIstioFieldBuilder().getBuilder(), extensionRegistry);
                identifierCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getIstioCanonicalServiceFieldBuilder().getBuilder(), extensionRegistry);
                identifierCase_ = 11;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(getTelemetryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 106
            case 114:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int identifierCase_ = 0;
    private java.lang.Object identifier_;

    public IdentifierCase getIdentifierCase() {
      return IdentifierCase.forNumber(identifierCase_);
    }

    public Builder clearIdentifier() {
      identifierCase_ = 0;
      identifier_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name for this Service. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name for this Service. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this Service.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Custom,
            com.google.monitoring.v3.Service.Custom.Builder,
            com.google.monitoring.v3.Service.CustomOrBuilder>
        customBuilder_;
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     *
     * @return Whether the custom field is set.
     */
    @java.lang.Override
    public boolean hasCustom() {
      return identifierCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     *
     * @return The custom.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.Custom getCustom() {
      if (customBuilder_ == null) {
        if (identifierCase_ == 6) {
          return (com.google.monitoring.v3.Service.Custom) identifier_;
        }
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      } else {
        if (identifierCase_ == 6) {
          return customBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder setCustom(com.google.monitoring.v3.Service.Custom value) {
      if (customBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        customBuilder_.setMessage(value);
      }
      identifierCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder setCustom(com.google.monitoring.v3.Service.Custom.Builder builderForValue) {
      if (customBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        customBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder mergeCustom(com.google.monitoring.v3.Service.Custom value) {
      if (customBuilder_ == null) {
        if (identifierCase_ == 6
            && identifier_ != com.google.monitoring.v3.Service.Custom.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.Custom.newBuilder(
                      (com.google.monitoring.v3.Service.Custom) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 6) {
          customBuilder_.mergeFrom(value);
        } else {
          customBuilder_.setMessage(value);
        }
      }
      identifierCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public Builder clearCustom() {
      if (customBuilder_ == null) {
        if (identifierCase_ == 6) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 6) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        customBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    public com.google.monitoring.v3.Service.Custom.Builder getCustomBuilder() {
      return getCustomFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.CustomOrBuilder getCustomOrBuilder() {
      if ((identifierCase_ == 6) && (customBuilder_ != null)) {
        return customBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 6) {
          return (com.google.monitoring.v3.Service.Custom) identifier_;
        }
        return com.google.monitoring.v3.Service.Custom.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Custom custom = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Custom,
            com.google.monitoring.v3.Service.Custom.Builder,
            com.google.monitoring.v3.Service.CustomOrBuilder>
        getCustomFieldBuilder() {
      if (customBuilder_ == null) {
        if (!(identifierCase_ == 6)) {
          identifier_ = com.google.monitoring.v3.Service.Custom.getDefaultInstance();
        }
        customBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.Custom,
                com.google.monitoring.v3.Service.Custom.Builder,
                com.google.monitoring.v3.Service.CustomOrBuilder>(
                (com.google.monitoring.v3.Service.Custom) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 6;
      onChanged();
      return customBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.AppEngine,
            com.google.monitoring.v3.Service.AppEngine.Builder,
            com.google.monitoring.v3.Service.AppEngineOrBuilder>
        appEngineBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     *
     * @return Whether the appEngine field is set.
     */
    @java.lang.Override
    public boolean hasAppEngine() {
      return identifierCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     *
     * @return The appEngine.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.AppEngine getAppEngine() {
      if (appEngineBuilder_ == null) {
        if (identifierCase_ == 7) {
          return (com.google.monitoring.v3.Service.AppEngine) identifier_;
        }
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      } else {
        if (identifierCase_ == 7) {
          return appEngineBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder setAppEngine(com.google.monitoring.v3.Service.AppEngine value) {
      if (appEngineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        appEngineBuilder_.setMessage(value);
      }
      identifierCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder setAppEngine(
        com.google.monitoring.v3.Service.AppEngine.Builder builderForValue) {
      if (appEngineBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        appEngineBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder mergeAppEngine(com.google.monitoring.v3.Service.AppEngine value) {
      if (appEngineBuilder_ == null) {
        if (identifierCase_ == 7
            && identifier_ != com.google.monitoring.v3.Service.AppEngine.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.AppEngine.newBuilder(
                      (com.google.monitoring.v3.Service.AppEngine) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 7) {
          appEngineBuilder_.mergeFrom(value);
        } else {
          appEngineBuilder_.setMessage(value);
        }
      }
      identifierCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public Builder clearAppEngine() {
      if (appEngineBuilder_ == null) {
        if (identifierCase_ == 7) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 7) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        appEngineBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    public com.google.monitoring.v3.Service.AppEngine.Builder getAppEngineBuilder() {
      return getAppEngineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.AppEngineOrBuilder getAppEngineOrBuilder() {
      if ((identifierCase_ == 7) && (appEngineBuilder_ != null)) {
        return appEngineBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 7) {
          return (com.google.monitoring.v3.Service.AppEngine) identifier_;
        }
        return com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for App Engine services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.AppEngine app_engine = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.AppEngine,
            com.google.monitoring.v3.Service.AppEngine.Builder,
            com.google.monitoring.v3.Service.AppEngineOrBuilder>
        getAppEngineFieldBuilder() {
      if (appEngineBuilder_ == null) {
        if (!(identifierCase_ == 7)) {
          identifier_ = com.google.monitoring.v3.Service.AppEngine.getDefaultInstance();
        }
        appEngineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.AppEngine,
                com.google.monitoring.v3.Service.AppEngine.Builder,
                com.google.monitoring.v3.Service.AppEngineOrBuilder>(
                (com.google.monitoring.v3.Service.AppEngine) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 7;
      onChanged();
      return appEngineBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.CloudEndpoints,
            com.google.monitoring.v3.Service.CloudEndpoints.Builder,
            com.google.monitoring.v3.Service.CloudEndpointsOrBuilder>
        cloudEndpointsBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     *
     * @return Whether the cloudEndpoints field is set.
     */
    @java.lang.Override
    public boolean hasCloudEndpoints() {
      return identifierCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     *
     * @return The cloudEndpoints.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.CloudEndpoints getCloudEndpoints() {
      if (cloudEndpointsBuilder_ == null) {
        if (identifierCase_ == 8) {
          return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
        }
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      } else {
        if (identifierCase_ == 8) {
          return cloudEndpointsBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder setCloudEndpoints(com.google.monitoring.v3.Service.CloudEndpoints value) {
      if (cloudEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        cloudEndpointsBuilder_.setMessage(value);
      }
      identifierCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder setCloudEndpoints(
        com.google.monitoring.v3.Service.CloudEndpoints.Builder builderForValue) {
      if (cloudEndpointsBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        cloudEndpointsBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder mergeCloudEndpoints(com.google.monitoring.v3.Service.CloudEndpoints value) {
      if (cloudEndpointsBuilder_ == null) {
        if (identifierCase_ == 8
            && identifier_
                != com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.CloudEndpoints.newBuilder(
                      (com.google.monitoring.v3.Service.CloudEndpoints) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 8) {
          cloudEndpointsBuilder_.mergeFrom(value);
        } else {
          cloudEndpointsBuilder_.setMessage(value);
        }
      }
      identifierCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public Builder clearCloudEndpoints() {
      if (cloudEndpointsBuilder_ == null) {
        if (identifierCase_ == 8) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 8) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        cloudEndpointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    public com.google.monitoring.v3.Service.CloudEndpoints.Builder getCloudEndpointsBuilder() {
      return getCloudEndpointsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.CloudEndpointsOrBuilder getCloudEndpointsOrBuilder() {
      if ((identifierCase_ == 8) && (cloudEndpointsBuilder_ != null)) {
        return cloudEndpointsBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 8) {
          return (com.google.monitoring.v3.Service.CloudEndpoints) identifier_;
        }
        return com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Cloud Endpoints services.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.CloudEndpoints cloud_endpoints = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.CloudEndpoints,
            com.google.monitoring.v3.Service.CloudEndpoints.Builder,
            com.google.monitoring.v3.Service.CloudEndpointsOrBuilder>
        getCloudEndpointsFieldBuilder() {
      if (cloudEndpointsBuilder_ == null) {
        if (!(identifierCase_ == 8)) {
          identifier_ = com.google.monitoring.v3.Service.CloudEndpoints.getDefaultInstance();
        }
        cloudEndpointsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.CloudEndpoints,
                com.google.monitoring.v3.Service.CloudEndpoints.Builder,
                com.google.monitoring.v3.Service.CloudEndpointsOrBuilder>(
                (com.google.monitoring.v3.Service.CloudEndpoints) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 8;
      onChanged();
      return cloudEndpointsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.ClusterIstio,
            com.google.monitoring.v3.Service.ClusterIstio.Builder,
            com.google.monitoring.v3.Service.ClusterIstioOrBuilder>
        clusterIstioBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     *
     * @return Whether the clusterIstio field is set.
     */
    @java.lang.Override
    public boolean hasClusterIstio() {
      return identifierCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     *
     * @return The clusterIstio.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.ClusterIstio getClusterIstio() {
      if (clusterIstioBuilder_ == null) {
        if (identifierCase_ == 9) {
          return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
        }
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      } else {
        if (identifierCase_ == 9) {
          return clusterIstioBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder setClusterIstio(com.google.monitoring.v3.Service.ClusterIstio value) {
      if (clusterIstioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        clusterIstioBuilder_.setMessage(value);
      }
      identifierCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder setClusterIstio(
        com.google.monitoring.v3.Service.ClusterIstio.Builder builderForValue) {
      if (clusterIstioBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        clusterIstioBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder mergeClusterIstio(com.google.monitoring.v3.Service.ClusterIstio value) {
      if (clusterIstioBuilder_ == null) {
        if (identifierCase_ == 9
            && identifier_ != com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.ClusterIstio.newBuilder(
                      (com.google.monitoring.v3.Service.ClusterIstio) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 9) {
          clusterIstioBuilder_.mergeFrom(value);
        } else {
          clusterIstioBuilder_.setMessage(value);
        }
      }
      identifierCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public Builder clearClusterIstio() {
      if (clusterIstioBuilder_ == null) {
        if (identifierCase_ == 9) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 9) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        clusterIstioBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    public com.google.monitoring.v3.Service.ClusterIstio.Builder getClusterIstioBuilder() {
      return getClusterIstioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.ClusterIstioOrBuilder getClusterIstioOrBuilder() {
      if ((identifierCase_ == 9) && (clusterIstioBuilder_ != null)) {
        return clusterIstioBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 9) {
          return (com.google.monitoring.v3.Service.ClusterIstio) identifier_;
        }
        return com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services that live in a Kubernetes cluster.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.ClusterIstio cluster_istio = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.ClusterIstio,
            com.google.monitoring.v3.Service.ClusterIstio.Builder,
            com.google.monitoring.v3.Service.ClusterIstioOrBuilder>
        getClusterIstioFieldBuilder() {
      if (clusterIstioBuilder_ == null) {
        if (!(identifierCase_ == 9)) {
          identifier_ = com.google.monitoring.v3.Service.ClusterIstio.getDefaultInstance();
        }
        clusterIstioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.ClusterIstio,
                com.google.monitoring.v3.Service.ClusterIstio.Builder,
                com.google.monitoring.v3.Service.ClusterIstioOrBuilder>(
                (com.google.monitoring.v3.Service.ClusterIstio) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 9;
      onChanged();
      return clusterIstioBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.MeshIstio,
            com.google.monitoring.v3.Service.MeshIstio.Builder,
            com.google.monitoring.v3.Service.MeshIstioOrBuilder>
        meshIstioBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     *
     * @return Whether the meshIstio field is set.
     */
    @java.lang.Override
    public boolean hasMeshIstio() {
      return identifierCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     *
     * @return The meshIstio.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.MeshIstio getMeshIstio() {
      if (meshIstioBuilder_ == null) {
        if (identifierCase_ == 10) {
          return (com.google.monitoring.v3.Service.MeshIstio) identifier_;
        }
        return com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
      } else {
        if (identifierCase_ == 10) {
          return meshIstioBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    public Builder setMeshIstio(com.google.monitoring.v3.Service.MeshIstio value) {
      if (meshIstioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        meshIstioBuilder_.setMessage(value);
      }
      identifierCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    public Builder setMeshIstio(
        com.google.monitoring.v3.Service.MeshIstio.Builder builderForValue) {
      if (meshIstioBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        meshIstioBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    public Builder mergeMeshIstio(com.google.monitoring.v3.Service.MeshIstio value) {
      if (meshIstioBuilder_ == null) {
        if (identifierCase_ == 10
            && identifier_ != com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.MeshIstio.newBuilder(
                      (com.google.monitoring.v3.Service.MeshIstio) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 10) {
          meshIstioBuilder_.mergeFrom(value);
        } else {
          meshIstioBuilder_.setMessage(value);
        }
      }
      identifierCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    public Builder clearMeshIstio() {
      if (meshIstioBuilder_ == null) {
        if (identifierCase_ == 10) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 10) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        meshIstioBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    public com.google.monitoring.v3.Service.MeshIstio.Builder getMeshIstioBuilder() {
      return getMeshIstioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.MeshIstioOrBuilder getMeshIstioOrBuilder() {
      if ((identifierCase_ == 10) && (meshIstioBuilder_ != null)) {
        return meshIstioBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 10) {
          return (com.google.monitoring.v3.Service.MeshIstio) identifier_;
        }
        return com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for Istio services scoped to an Istio mesh.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.MeshIstio mesh_istio = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.MeshIstio,
            com.google.monitoring.v3.Service.MeshIstio.Builder,
            com.google.monitoring.v3.Service.MeshIstioOrBuilder>
        getMeshIstioFieldBuilder() {
      if (meshIstioBuilder_ == null) {
        if (!(identifierCase_ == 10)) {
          identifier_ = com.google.monitoring.v3.Service.MeshIstio.getDefaultInstance();
        }
        meshIstioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.MeshIstio,
                com.google.monitoring.v3.Service.MeshIstio.Builder,
                com.google.monitoring.v3.Service.MeshIstioOrBuilder>(
                (com.google.monitoring.v3.Service.MeshIstio) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 10;
      onChanged();
      return meshIstioBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.IstioCanonicalService,
            com.google.monitoring.v3.Service.IstioCanonicalService.Builder,
            com.google.monitoring.v3.Service.IstioCanonicalServiceOrBuilder>
        istioCanonicalServiceBuilder_;
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     *
     * @return Whether the istioCanonicalService field is set.
     */
    @java.lang.Override
    public boolean hasIstioCanonicalService() {
      return identifierCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     *
     * @return The istioCanonicalService.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.IstioCanonicalService getIstioCanonicalService() {
      if (istioCanonicalServiceBuilder_ == null) {
        if (identifierCase_ == 11) {
          return (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_;
        }
        return com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
      } else {
        if (identifierCase_ == 11) {
          return istioCanonicalServiceBuilder_.getMessage();
        }
        return com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    public Builder setIstioCanonicalService(
        com.google.monitoring.v3.Service.IstioCanonicalService value) {
      if (istioCanonicalServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identifier_ = value;
        onChanged();
      } else {
        istioCanonicalServiceBuilder_.setMessage(value);
      }
      identifierCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    public Builder setIstioCanonicalService(
        com.google.monitoring.v3.Service.IstioCanonicalService.Builder builderForValue) {
      if (istioCanonicalServiceBuilder_ == null) {
        identifier_ = builderForValue.build();
        onChanged();
      } else {
        istioCanonicalServiceBuilder_.setMessage(builderForValue.build());
      }
      identifierCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    public Builder mergeIstioCanonicalService(
        com.google.monitoring.v3.Service.IstioCanonicalService value) {
      if (istioCanonicalServiceBuilder_ == null) {
        if (identifierCase_ == 11
            && identifier_
                != com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance()) {
          identifier_ =
              com.google.monitoring.v3.Service.IstioCanonicalService.newBuilder(
                      (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identifier_ = value;
        }
        onChanged();
      } else {
        if (identifierCase_ == 11) {
          istioCanonicalServiceBuilder_.mergeFrom(value);
        } else {
          istioCanonicalServiceBuilder_.setMessage(value);
        }
      }
      identifierCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    public Builder clearIstioCanonicalService() {
      if (istioCanonicalServiceBuilder_ == null) {
        if (identifierCase_ == 11) {
          identifierCase_ = 0;
          identifier_ = null;
          onChanged();
        }
      } else {
        if (identifierCase_ == 11) {
          identifierCase_ = 0;
          identifier_ = null;
        }
        istioCanonicalServiceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    public com.google.monitoring.v3.Service.IstioCanonicalService.Builder
        getIstioCanonicalServiceBuilder() {
      return getIstioCanonicalServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.Service.IstioCanonicalServiceOrBuilder
        getIstioCanonicalServiceOrBuilder() {
      if ((identifierCase_ == 11) && (istioCanonicalServiceBuilder_ != null)) {
        return istioCanonicalServiceBuilder_.getMessageOrBuilder();
      } else {
        if (identifierCase_ == 11) {
          return (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_;
        }
        return com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Type used for canonical services scoped to an Istio mesh.
     * Metrics for Istio are
     * [documented here](https://istio.io/latest/docs/reference/config/metrics/)
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.IstioCanonicalService istio_canonical_service = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.IstioCanonicalService,
            com.google.monitoring.v3.Service.IstioCanonicalService.Builder,
            com.google.monitoring.v3.Service.IstioCanonicalServiceOrBuilder>
        getIstioCanonicalServiceFieldBuilder() {
      if (istioCanonicalServiceBuilder_ == null) {
        if (!(identifierCase_ == 11)) {
          identifier_ = com.google.monitoring.v3.Service.IstioCanonicalService.getDefaultInstance();
        }
        istioCanonicalServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.IstioCanonicalService,
                com.google.monitoring.v3.Service.IstioCanonicalService.Builder,
                com.google.monitoring.v3.Service.IstioCanonicalServiceOrBuilder>(
                (com.google.monitoring.v3.Service.IstioCanonicalService) identifier_,
                getParentForChildren(),
                isClean());
        identifier_ = null;
      }
      identifierCase_ = 11;
      onChanged();
      return istioCanonicalServiceBuilder_;
    }

    private com.google.monitoring.v3.Service.Telemetry telemetry_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Telemetry,
            com.google.monitoring.v3.Service.Telemetry.Builder,
            com.google.monitoring.v3.Service.TelemetryOrBuilder>
        telemetryBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     *
     * @return Whether the telemetry field is set.
     */
    public boolean hasTelemetry() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     *
     * @return The telemetry.
     */
    public com.google.monitoring.v3.Service.Telemetry getTelemetry() {
      if (telemetryBuilder_ == null) {
        return telemetry_ == null
            ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
            : telemetry_;
      } else {
        return telemetryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder setTelemetry(com.google.monitoring.v3.Service.Telemetry value) {
      if (telemetryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        telemetry_ = value;
      } else {
        telemetryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder setTelemetry(
        com.google.monitoring.v3.Service.Telemetry.Builder builderForValue) {
      if (telemetryBuilder_ == null) {
        telemetry_ = builderForValue.build();
      } else {
        telemetryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder mergeTelemetry(com.google.monitoring.v3.Service.Telemetry value) {
      if (telemetryBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && telemetry_ != null
            && telemetry_ != com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()) {
          getTelemetryBuilder().mergeFrom(value);
        } else {
          telemetry_ = value;
        }
      } else {
        telemetryBuilder_.mergeFrom(value);
      }
      if (telemetry_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public Builder clearTelemetry() {
      bitField0_ = (bitField0_ & ~0x00000100);
      telemetry_ = null;
      if (telemetryBuilder_ != null) {
        telemetryBuilder_.dispose();
        telemetryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public com.google.monitoring.v3.Service.Telemetry.Builder getTelemetryBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getTelemetryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    public com.google.monitoring.v3.Service.TelemetryOrBuilder getTelemetryOrBuilder() {
      if (telemetryBuilder_ != null) {
        return telemetryBuilder_.getMessageOrBuilder();
      } else {
        return telemetry_ == null
            ? com.google.monitoring.v3.Service.Telemetry.getDefaultInstance()
            : telemetry_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to query telemetry on a Service.
     * </pre>
     *
     * <code>.google.monitoring.v3.Service.Telemetry telemetry = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Service.Telemetry,
            com.google.monitoring.v3.Service.Telemetry.Builder,
            com.google.monitoring.v3.Service.TelemetryOrBuilder>
        getTelemetryFieldBuilder() {
      if (telemetryBuilder_ == null) {
        telemetryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Service.Telemetry,
                com.google.monitoring.v3.Service.Telemetry.Builder,
                com.google.monitoring.v3.Service.TelemetryOrBuilder>(
                getTelemetry(), getParentForChildren(), isClean());
        telemetry_ = null;
      }
      return telemetryBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000200;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service. Label keys must start
     * with a letter. Label keys and values may contain lowercase letters,
     * numbers, underscores, and dashes. Label keys and values have a maximum
     * length of 63 characters, and must be less than 128 bytes in size. Up to 64
     * label entries may be stored. For labels which do not have a semantic value,
     * the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 14;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Service)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.Service)
  private static final com.google.monitoring.v3.Service DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.Service();
  }

  public static com.google.monitoring.v3.Service getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Service> PARSER =
      new com.google.protobuf.AbstractParser<Service>() {
        @java.lang.Override
        public Service parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Service> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Service> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.Service getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
