/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * An SLI measuring performance on a well-known service type. Performance will
 * be computed on the basis of pre-defined metrics. The type of the
 * `service_resource` determines the metrics to use and the
 * `service_resource.labels` and `metric_labels` are used to construct a
 * monitoring filter to filter that metric down to just the data relevant to
 * this service.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.BasicSli}
 */
public final class BasicSli extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.BasicSli)
    BasicSliOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BasicSli.newBuilder() to construct.
  private BasicSli(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BasicSli() {
    method_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    location_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BasicSli();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_BasicSli_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_BasicSli_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.BasicSli.class,
            com.google.monitoring.v3.BasicSli.Builder.class);
  }

  public interface AvailabilityCriteriaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.BasicSli.AvailabilityCriteria)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Future parameters for the availability SLI.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.BasicSli.AvailabilityCriteria}
   */
  public static final class AvailabilityCriteria extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.BasicSli.AvailabilityCriteria)
      AvailabilityCriteriaOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AvailabilityCriteria.newBuilder() to construct.
    private AvailabilityCriteria(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AvailabilityCriteria() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AvailabilityCriteria();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_AvailabilityCriteria_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_AvailabilityCriteria_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.BasicSli.AvailabilityCriteria.class,
              com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.BasicSli.AvailabilityCriteria)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.BasicSli.AvailabilityCriteria other =
          (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.BasicSli.AvailabilityCriteria prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Future parameters for the availability SLI.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.BasicSli.AvailabilityCriteria}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.BasicSli.AvailabilityCriteria)
        com.google.monitoring.v3.BasicSli.AvailabilityCriteriaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_BasicSli_AvailabilityCriteria_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_BasicSli_AvailabilityCriteria_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.BasicSli.AvailabilityCriteria.class,
                com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder.class);
      }

      // Construct using com.google.monitoring.v3.BasicSli.AvailabilityCriteria.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_BasicSli_AvailabilityCriteria_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.BasicSli.AvailabilityCriteria getDefaultInstanceForType() {
        return com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.BasicSli.AvailabilityCriteria build() {
        com.google.monitoring.v3.BasicSli.AvailabilityCriteria result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.BasicSli.AvailabilityCriteria buildPartial() {
        com.google.monitoring.v3.BasicSli.AvailabilityCriteria result =
            new com.google.monitoring.v3.BasicSli.AvailabilityCriteria(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.BasicSli.AvailabilityCriteria) {
          return mergeFrom((com.google.monitoring.v3.BasicSli.AvailabilityCriteria) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.BasicSli.AvailabilityCriteria other) {
        if (other == com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.BasicSli.AvailabilityCriteria)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.BasicSli.AvailabilityCriteria)
    private static final com.google.monitoring.v3.BasicSli.AvailabilityCriteria DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.BasicSli.AvailabilityCriteria();
    }

    public static com.google.monitoring.v3.BasicSli.AvailabilityCriteria getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AvailabilityCriteria> PARSER =
        new com.google.protobuf.AbstractParser<AvailabilityCriteria>() {
          @java.lang.Override
          public AvailabilityCriteria parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AvailabilityCriteria> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AvailabilityCriteria> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.BasicSli.AvailabilityCriteria getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LatencyCriteriaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.BasicSli.LatencyCriteria)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return in no more than `threshold`.
     * </pre>
     *
     * <code>.google.protobuf.Duration threshold = 3;</code>
     *
     * @return Whether the threshold field is set.
     */
    boolean hasThreshold();
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return in no more than `threshold`.
     * </pre>
     *
     * <code>.google.protobuf.Duration threshold = 3;</code>
     *
     * @return The threshold.
     */
    com.google.protobuf.Duration getThreshold();
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return in no more than `threshold`.
     * </pre>
     *
     * <code>.google.protobuf.Duration threshold = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getThresholdOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Parameters for a latency threshold SLI.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.BasicSli.LatencyCriteria}
   */
  public static final class LatencyCriteria extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.BasicSli.LatencyCriteria)
      LatencyCriteriaOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LatencyCriteria.newBuilder() to construct.
    private LatencyCriteria(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LatencyCriteria() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LatencyCriteria();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_LatencyCriteria_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_LatencyCriteria_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.BasicSli.LatencyCriteria.class,
              com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder.class);
    }

    public static final int THRESHOLD_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration threshold_;
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return in no more than `threshold`.
     * </pre>
     *
     * <code>.google.protobuf.Duration threshold = 3;</code>
     *
     * @return Whether the threshold field is set.
     */
    @java.lang.Override
    public boolean hasThreshold() {
      return threshold_ != null;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return in no more than `threshold`.
     * </pre>
     *
     * <code>.google.protobuf.Duration threshold = 3;</code>
     *
     * @return The threshold.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getThreshold() {
      return threshold_ == null ? com.google.protobuf.Duration.getDefaultInstance() : threshold_;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return in no more than `threshold`.
     * </pre>
     *
     * <code>.google.protobuf.Duration threshold = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getThresholdOrBuilder() {
      return getThreshold();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (threshold_ != null) {
        output.writeMessage(3, getThreshold());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (threshold_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getThreshold());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.BasicSli.LatencyCriteria)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.BasicSli.LatencyCriteria other =
          (com.google.monitoring.v3.BasicSli.LatencyCriteria) obj;

      if (hasThreshold() != other.hasThreshold()) return false;
      if (hasThreshold()) {
        if (!getThreshold().equals(other.getThreshold())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasThreshold()) {
        hash = (37 * hash) + THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getThreshold().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.BasicSli.LatencyCriteria prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a latency threshold SLI.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.BasicSli.LatencyCriteria}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.BasicSli.LatencyCriteria)
        com.google.monitoring.v3.BasicSli.LatencyCriteriaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_BasicSli_LatencyCriteria_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_BasicSli_LatencyCriteria_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.BasicSli.LatencyCriteria.class,
                com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder.class);
      }

      // Construct using com.google.monitoring.v3.BasicSli.LatencyCriteria.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (thresholdBuilder_ == null) {
          threshold_ = null;
        } else {
          threshold_ = null;
          thresholdBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.ServiceMonitoringProto
            .internal_static_google_monitoring_v3_BasicSli_LatencyCriteria_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.BasicSli.LatencyCriteria getDefaultInstanceForType() {
        return com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.BasicSli.LatencyCriteria build() {
        com.google.monitoring.v3.BasicSli.LatencyCriteria result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.BasicSli.LatencyCriteria buildPartial() {
        com.google.monitoring.v3.BasicSli.LatencyCriteria result =
            new com.google.monitoring.v3.BasicSli.LatencyCriteria(this);
        if (thresholdBuilder_ == null) {
          result.threshold_ = threshold_;
        } else {
          result.threshold_ = thresholdBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.BasicSli.LatencyCriteria) {
          return mergeFrom((com.google.monitoring.v3.BasicSli.LatencyCriteria) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.BasicSli.LatencyCriteria other) {
        if (other == com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance())
          return this;
        if (other.hasThreshold()) {
          mergeThreshold(other.getThreshold());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  input.readMessage(getThresholdFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Duration threshold_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          thresholdBuilder_;
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       *
       * @return Whether the threshold field is set.
       */
      public boolean hasThreshold() {
        return thresholdBuilder_ != null || threshold_ != null;
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       *
       * @return The threshold.
       */
      public com.google.protobuf.Duration getThreshold() {
        if (thresholdBuilder_ == null) {
          return threshold_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : threshold_;
        } else {
          return thresholdBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      public Builder setThreshold(com.google.protobuf.Duration value) {
        if (thresholdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          threshold_ = value;
          onChanged();
        } else {
          thresholdBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      public Builder setThreshold(com.google.protobuf.Duration.Builder builderForValue) {
        if (thresholdBuilder_ == null) {
          threshold_ = builderForValue.build();
          onChanged();
        } else {
          thresholdBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      public Builder mergeThreshold(com.google.protobuf.Duration value) {
        if (thresholdBuilder_ == null) {
          if (threshold_ != null) {
            threshold_ =
                com.google.protobuf.Duration.newBuilder(threshold_).mergeFrom(value).buildPartial();
          } else {
            threshold_ = value;
          }
          onChanged();
        } else {
          thresholdBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      public Builder clearThreshold() {
        if (thresholdBuilder_ == null) {
          threshold_ = null;
          onChanged();
        } else {
          threshold_ = null;
          thresholdBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getThresholdBuilder() {

        onChanged();
        return getThresholdFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      public com.google.protobuf.DurationOrBuilder getThresholdOrBuilder() {
        if (thresholdBuilder_ != null) {
          return thresholdBuilder_.getMessageOrBuilder();
        } else {
          return threshold_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : threshold_;
        }
      }
      /**
       *
       *
       * <pre>
       * Good service is defined to be the count of requests made to this service
       * that return in no more than `threshold`.
       * </pre>
       *
       * <code>.google.protobuf.Duration threshold = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getThresholdFieldBuilder() {
        if (thresholdBuilder_ == null) {
          thresholdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getThreshold(), getParentForChildren(), isClean());
          threshold_ = null;
        }
        return thresholdBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.BasicSli.LatencyCriteria)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.BasicSli.LatencyCriteria)
    private static final com.google.monitoring.v3.BasicSli.LatencyCriteria DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.BasicSli.LatencyCriteria();
    }

    public static com.google.monitoring.v3.BasicSli.LatencyCriteria getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LatencyCriteria> PARSER =
        new com.google.protobuf.AbstractParser<LatencyCriteria>() {
          @java.lang.Override
          public LatencyCriteria parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LatencyCriteria> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LatencyCriteria> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.BasicSli.LatencyCriteria getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sliCriteriaCase_ = 0;
  private java.lang.Object sliCriteria_;

  public enum SliCriteriaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVAILABILITY(2),
    LATENCY(3),
    SLICRITERIA_NOT_SET(0);
    private final int value;

    private SliCriteriaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SliCriteriaCase valueOf(int value) {
      return forNumber(value);
    }

    public static SliCriteriaCase forNumber(int value) {
      switch (value) {
        case 2:
          return AVAILABILITY;
        case 3:
          return LATENCY;
        case 0:
          return SLICRITERIA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SliCriteriaCase getSliCriteriaCase() {
    return SliCriteriaCase.forNumber(sliCriteriaCase_);
  }

  public static final int METHOD_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList method_;
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
   * other methods will not be used to calculate performance for this SLI. If
   * omitted, this SLI applies to all the Service's methods. For service types
   * that don't support breaking down by method, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string method = 7;</code>
   *
   * @return A list containing the method.
   */
  public com.google.protobuf.ProtocolStringList getMethodList() {
    return method_;
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
   * other methods will not be used to calculate performance for this SLI. If
   * omitted, this SLI applies to all the Service's methods. For service types
   * that don't support breaking down by method, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string method = 7;</code>
   *
   * @return The count of method.
   */
  public int getMethodCount() {
    return method_.size();
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
   * other methods will not be used to calculate performance for this SLI. If
   * omitted, this SLI applies to all the Service's methods. For service types
   * that don't support breaking down by method, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string method = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The method at the given index.
   */
  public java.lang.String getMethod(int index) {
    return method_.get(index);
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
   * other methods will not be used to calculate performance for this SLI. If
   * omitted, this SLI applies to all the Service's methods. For service types
   * that don't support breaking down by method, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string method = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the method at the given index.
   */
  public com.google.protobuf.ByteString getMethodBytes(int index) {
    return method_.getByteString(index);
  }

  public static final int LOCATION_FIELD_NUMBER = 8;
  private com.google.protobuf.LazyStringList location_;
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
   * from other locations will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all locations in which the Service has
   * activity. For service types that don't support breaking down by location,
   * setting this field will result in an error.
   * </pre>
   *
   * <code>repeated string location = 8;</code>
   *
   * @return A list containing the location.
   */
  public com.google.protobuf.ProtocolStringList getLocationList() {
    return location_;
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
   * from other locations will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all locations in which the Service has
   * activity. For service types that don't support breaking down by location,
   * setting this field will result in an error.
   * </pre>
   *
   * <code>repeated string location = 8;</code>
   *
   * @return The count of location.
   */
  public int getLocationCount() {
    return location_.size();
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
   * from other locations will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all locations in which the Service has
   * activity. For service types that don't support breaking down by location,
   * setting this field will result in an error.
   * </pre>
   *
   * <code>repeated string location = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The location at the given index.
   */
  public java.lang.String getLocation(int index) {
    return location_.get(index);
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
   * from other locations will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all locations in which the Service has
   * activity. For service types that don't support breaking down by location,
   * setting this field will result in an error.
   * </pre>
   *
   * <code>repeated string location = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the location at the given index.
   */
  public com.google.protobuf.ByteString getLocationBytes(int index) {
    return location_.getByteString(index);
  }

  public static final int VERSION_FIELD_NUMBER = 9;
  private com.google.protobuf.LazyStringList version_;
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
   * from other API versions will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all API versions. For service types
   * that don't support breaking down by version, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string version = 9;</code>
   *
   * @return A list containing the version.
   */
  public com.google.protobuf.ProtocolStringList getVersionList() {
    return version_;
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
   * from other API versions will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all API versions. For service types
   * that don't support breaking down by version, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string version = 9;</code>
   *
   * @return The count of version.
   */
  public int getVersionCount() {
    return version_.size();
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
   * from other API versions will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all API versions. For service types
   * that don't support breaking down by version, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string version = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The version at the given index.
   */
  public java.lang.String getVersion(int index) {
    return version_.get(index);
  }
  /**
   *
   *
   * <pre>
   * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
   * from other API versions will not be used to calculate performance for this
   * SLI. If omitted, this SLI applies to all API versions. For service types
   * that don't support breaking down by version, setting this field will result
   * in an error.
   * </pre>
   *
   * <code>repeated string version = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the version at the given index.
   */
  public com.google.protobuf.ByteString getVersionBytes(int index) {
    return version_.getByteString(index);
  }

  public static final int AVAILABILITY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Good service is defined to be the count of requests made to this service
   * that return successfully.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
   *
   * @return Whether the availability field is set.
   */
  @java.lang.Override
  public boolean hasAvailability() {
    return sliCriteriaCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Good service is defined to be the count of requests made to this service
   * that return successfully.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
   *
   * @return The availability.
   */
  @java.lang.Override
  public com.google.monitoring.v3.BasicSli.AvailabilityCriteria getAvailability() {
    if (sliCriteriaCase_ == 2) {
      return (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_;
    }
    return com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Good service is defined to be the count of requests made to this service
   * that return successfully.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.BasicSli.AvailabilityCriteriaOrBuilder
      getAvailabilityOrBuilder() {
    if (sliCriteriaCase_ == 2) {
      return (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_;
    }
    return com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
  }

  public static final int LATENCY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Good service is defined to be the count of requests made to this service
   * that are fast enough with respect to `latency.threshold`.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
   *
   * @return Whether the latency field is set.
   */
  @java.lang.Override
  public boolean hasLatency() {
    return sliCriteriaCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Good service is defined to be the count of requests made to this service
   * that are fast enough with respect to `latency.threshold`.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
   *
   * @return The latency.
   */
  @java.lang.Override
  public com.google.monitoring.v3.BasicSli.LatencyCriteria getLatency() {
    if (sliCriteriaCase_ == 3) {
      return (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_;
    }
    return com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Good service is defined to be the count of requests made to this service
   * that are fast enough with respect to `latency.threshold`.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.BasicSli.LatencyCriteriaOrBuilder getLatencyOrBuilder() {
    if (sliCriteriaCase_ == 3) {
      return (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_;
    }
    return com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sliCriteriaCase_ == 2) {
      output.writeMessage(2, (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_);
    }
    if (sliCriteriaCase_ == 3) {
      output.writeMessage(3, (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_);
    }
    for (int i = 0; i < method_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, method_.getRaw(i));
    }
    for (int i = 0; i < location_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, location_.getRaw(i));
    }
    for (int i = 0; i < version_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, version_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sliCriteriaCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_);
    }
    if (sliCriteriaCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < method_.size(); i++) {
        dataSize += computeStringSizeNoTag(method_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMethodList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < location_.size(); i++) {
        dataSize += computeStringSizeNoTag(location_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < version_.size(); i++) {
        dataSize += computeStringSizeNoTag(version_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getVersionList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.BasicSli)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.BasicSli other = (com.google.monitoring.v3.BasicSli) obj;

    if (!getMethodList().equals(other.getMethodList())) return false;
    if (!getLocationList().equals(other.getLocationList())) return false;
    if (!getVersionList().equals(other.getVersionList())) return false;
    if (!getSliCriteriaCase().equals(other.getSliCriteriaCase())) return false;
    switch (sliCriteriaCase_) {
      case 2:
        if (!getAvailability().equals(other.getAvailability())) return false;
        break;
      case 3:
        if (!getLatency().equals(other.getLatency())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMethodCount() > 0) {
      hash = (37 * hash) + METHOD_FIELD_NUMBER;
      hash = (53 * hash) + getMethodList().hashCode();
    }
    if (getLocationCount() > 0) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocationList().hashCode();
    }
    if (getVersionCount() > 0) {
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersionList().hashCode();
    }
    switch (sliCriteriaCase_) {
      case 2:
        hash = (37 * hash) + AVAILABILITY_FIELD_NUMBER;
        hash = (53 * hash) + getAvailability().hashCode();
        break;
      case 3:
        hash = (37 * hash) + LATENCY_FIELD_NUMBER;
        hash = (53 * hash) + getLatency().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.BasicSli parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.BasicSli parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.BasicSli parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.BasicSli prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An SLI measuring performance on a well-known service type. Performance will
   * be computed on the basis of pre-defined metrics. The type of the
   * `service_resource` determines the metrics to use and the
   * `service_resource.labels` and `metric_labels` are used to construct a
   * monitoring filter to filter that metric down to just the data relevant to
   * this service.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.BasicSli}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.BasicSli)
      com.google.monitoring.v3.BasicSliOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.BasicSli.class,
              com.google.monitoring.v3.BasicSli.Builder.class);
    }

    // Construct using com.google.monitoring.v3.BasicSli.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      method_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      location_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      if (availabilityBuilder_ != null) {
        availabilityBuilder_.clear();
      }
      if (latencyBuilder_ != null) {
        latencyBuilder_.clear();
      }
      sliCriteriaCase_ = 0;
      sliCriteria_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_BasicSli_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.BasicSli getDefaultInstanceForType() {
      return com.google.monitoring.v3.BasicSli.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.BasicSli build() {
      com.google.monitoring.v3.BasicSli result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.BasicSli buildPartial() {
      com.google.monitoring.v3.BasicSli result = new com.google.monitoring.v3.BasicSli(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        method_ = method_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.method_ = method_;
      if (((bitField0_ & 0x00000002) != 0)) {
        location_ = location_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.location_ = location_;
      if (((bitField0_ & 0x00000004) != 0)) {
        version_ = version_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.version_ = version_;
      if (sliCriteriaCase_ == 2) {
        if (availabilityBuilder_ == null) {
          result.sliCriteria_ = sliCriteria_;
        } else {
          result.sliCriteria_ = availabilityBuilder_.build();
        }
      }
      if (sliCriteriaCase_ == 3) {
        if (latencyBuilder_ == null) {
          result.sliCriteria_ = sliCriteria_;
        } else {
          result.sliCriteria_ = latencyBuilder_.build();
        }
      }
      result.sliCriteriaCase_ = sliCriteriaCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.BasicSli) {
        return mergeFrom((com.google.monitoring.v3.BasicSli) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.BasicSli other) {
      if (other == com.google.monitoring.v3.BasicSli.getDefaultInstance()) return this;
      if (!other.method_.isEmpty()) {
        if (method_.isEmpty()) {
          method_ = other.method_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureMethodIsMutable();
          method_.addAll(other.method_);
        }
        onChanged();
      }
      if (!other.location_.isEmpty()) {
        if (location_.isEmpty()) {
          location_ = other.location_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureLocationIsMutable();
          location_.addAll(other.location_);
        }
        onChanged();
      }
      if (!other.version_.isEmpty()) {
        if (version_.isEmpty()) {
          version_ = other.version_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureVersionIsMutable();
          version_.addAll(other.version_);
        }
        onChanged();
      }
      switch (other.getSliCriteriaCase()) {
        case AVAILABILITY:
          {
            mergeAvailability(other.getAvailability());
            break;
          }
        case LATENCY:
          {
            mergeLatency(other.getLatency());
            break;
          }
        case SLICRITERIA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getAvailabilityFieldBuilder().getBuilder(), extensionRegistry);
                sliCriteriaCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getLatencyFieldBuilder().getBuilder(), extensionRegistry);
                sliCriteriaCase_ = 3;
                break;
              } // case 26
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMethodIsMutable();
                method_.add(s);
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationIsMutable();
                location_.add(s);
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureVersionIsMutable();
                version_.add(s);
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sliCriteriaCase_ = 0;
    private java.lang.Object sliCriteria_;

    public SliCriteriaCase getSliCriteriaCase() {
      return SliCriteriaCase.forNumber(sliCriteriaCase_);
    }

    public Builder clearSliCriteria() {
      sliCriteriaCase_ = 0;
      sliCriteria_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList method_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureMethodIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        method_ = new com.google.protobuf.LazyStringArrayList(method_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @return A list containing the method.
     */
    public com.google.protobuf.ProtocolStringList getMethodList() {
      return method_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @return The count of method.
     */
    public int getMethodCount() {
      return method_.size();
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    public java.lang.String getMethod(int index) {
      return method_.get(index);
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    public com.google.protobuf.ByteString getMethodBytes(int index) {
      return method_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The method to set.
     * @return This builder for chaining.
     */
    public Builder setMethod(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMethodIsMutable();
      method_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @param value The method to add.
     * @return This builder for chaining.
     */
    public Builder addMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMethodIsMutable();
      method_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @param values The method to add.
     * @return This builder for chaining.
     */
    public Builder addAllMethod(java.lang.Iterable<java.lang.String> values) {
      ensureMethodIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, method_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMethod() {
      method_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
     * other methods will not be used to calculate performance for this SLI. If
     * omitted, this SLI applies to all the Service's methods. For service types
     * that don't support breaking down by method, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string method = 7;</code>
     *
     * @param value The bytes of the method to add.
     * @return This builder for chaining.
     */
    public Builder addMethodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMethodIsMutable();
      method_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList location_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureLocationIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        location_ = new com.google.protobuf.LazyStringArrayList(location_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @return A list containing the location.
     */
    public com.google.protobuf.ProtocolStringList getLocationList() {
      return location_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @return The count of location.
     */
    public int getLocationCount() {
      return location_.size();
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The location at the given index.
     */
    public java.lang.String getLocation(int index) {
      return location_.get(index);
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the location at the given index.
     */
    public com.google.protobuf.ByteString getLocationBytes(int index) {
      return location_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationIsMutable();
      location_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @param value The location to add.
     * @return This builder for chaining.
     */
    public Builder addLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationIsMutable();
      location_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @param values The location to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocation(java.lang.Iterable<java.lang.String> values) {
      ensureLocationIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, location_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
     * from other locations will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all locations in which the Service has
     * activity. For service types that don't support breaking down by location,
     * setting this field will result in an error.
     * </pre>
     *
     * <code>repeated string location = 8;</code>
     *
     * @param value The bytes of the location to add.
     * @return This builder for chaining.
     */
    public Builder addLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationIsMutable();
      location_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList version_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureVersionIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        version_ = new com.google.protobuf.LazyStringArrayList(version_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @return A list containing the version.
     */
    public com.google.protobuf.ProtocolStringList getVersionList() {
      return version_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @return The count of version.
     */
    public int getVersionCount() {
      return version_.size();
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The version at the given index.
     */
    public java.lang.String getVersion(int index) {
      return version_.get(index);
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the version at the given index.
     */
    public com.google.protobuf.ByteString getVersionBytes(int index) {
      return version_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionIsMutable();
      version_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @param value The version to add.
     * @return This builder for chaining.
     */
    public Builder addVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionIsMutable();
      version_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @param values The version to add.
     * @return This builder for chaining.
     */
    public Builder addAllVersion(java.lang.Iterable<java.lang.String> values) {
      ensureVersionIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, version_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
     * from other API versions will not be used to calculate performance for this
     * SLI. If omitted, this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this field will result
     * in an error.
     * </pre>
     *
     * <code>repeated string version = 9;</code>
     *
     * @param value The bytes of the version to add.
     * @return This builder for chaining.
     */
    public Builder addVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureVersionIsMutable();
      version_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.BasicSli.AvailabilityCriteria,
            com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder,
            com.google.monitoring.v3.BasicSli.AvailabilityCriteriaOrBuilder>
        availabilityBuilder_;
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     *
     * @return Whether the availability field is set.
     */
    @java.lang.Override
    public boolean hasAvailability() {
      return sliCriteriaCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     *
     * @return The availability.
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSli.AvailabilityCriteria getAvailability() {
      if (availabilityBuilder_ == null) {
        if (sliCriteriaCase_ == 2) {
          return (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_;
        }
        return com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
      } else {
        if (sliCriteriaCase_ == 2) {
          return availabilityBuilder_.getMessage();
        }
        return com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    public Builder setAvailability(com.google.monitoring.v3.BasicSli.AvailabilityCriteria value) {
      if (availabilityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sliCriteria_ = value;
        onChanged();
      } else {
        availabilityBuilder_.setMessage(value);
      }
      sliCriteriaCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    public Builder setAvailability(
        com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder builderForValue) {
      if (availabilityBuilder_ == null) {
        sliCriteria_ = builderForValue.build();
        onChanged();
      } else {
        availabilityBuilder_.setMessage(builderForValue.build());
      }
      sliCriteriaCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    public Builder mergeAvailability(com.google.monitoring.v3.BasicSli.AvailabilityCriteria value) {
      if (availabilityBuilder_ == null) {
        if (sliCriteriaCase_ == 2
            && sliCriteria_
                != com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance()) {
          sliCriteria_ =
              com.google.monitoring.v3.BasicSli.AvailabilityCriteria.newBuilder(
                      (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sliCriteria_ = value;
        }
        onChanged();
      } else {
        if (sliCriteriaCase_ == 2) {
          availabilityBuilder_.mergeFrom(value);
        } else {
          availabilityBuilder_.setMessage(value);
        }
      }
      sliCriteriaCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    public Builder clearAvailability() {
      if (availabilityBuilder_ == null) {
        if (sliCriteriaCase_ == 2) {
          sliCriteriaCase_ = 0;
          sliCriteria_ = null;
          onChanged();
        }
      } else {
        if (sliCriteriaCase_ == 2) {
          sliCriteriaCase_ = 0;
          sliCriteria_ = null;
        }
        availabilityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    public com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder getAvailabilityBuilder() {
      return getAvailabilityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSli.AvailabilityCriteriaOrBuilder
        getAvailabilityOrBuilder() {
      if ((sliCriteriaCase_ == 2) && (availabilityBuilder_ != null)) {
        return availabilityBuilder_.getMessageOrBuilder();
      } else {
        if (sliCriteriaCase_ == 2) {
          return (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_;
        }
        return com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that return successfully.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.AvailabilityCriteria availability = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.BasicSli.AvailabilityCriteria,
            com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder,
            com.google.monitoring.v3.BasicSli.AvailabilityCriteriaOrBuilder>
        getAvailabilityFieldBuilder() {
      if (availabilityBuilder_ == null) {
        if (!(sliCriteriaCase_ == 2)) {
          sliCriteria_ =
              com.google.monitoring.v3.BasicSli.AvailabilityCriteria.getDefaultInstance();
        }
        availabilityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.BasicSli.AvailabilityCriteria,
                com.google.monitoring.v3.BasicSli.AvailabilityCriteria.Builder,
                com.google.monitoring.v3.BasicSli.AvailabilityCriteriaOrBuilder>(
                (com.google.monitoring.v3.BasicSli.AvailabilityCriteria) sliCriteria_,
                getParentForChildren(),
                isClean());
        sliCriteria_ = null;
      }
      sliCriteriaCase_ = 2;
      onChanged();
      ;
      return availabilityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.BasicSli.LatencyCriteria,
            com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder,
            com.google.monitoring.v3.BasicSli.LatencyCriteriaOrBuilder>
        latencyBuilder_;
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     *
     * @return Whether the latency field is set.
     */
    @java.lang.Override
    public boolean hasLatency() {
      return sliCriteriaCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     *
     * @return The latency.
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSli.LatencyCriteria getLatency() {
      if (latencyBuilder_ == null) {
        if (sliCriteriaCase_ == 3) {
          return (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_;
        }
        return com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
      } else {
        if (sliCriteriaCase_ == 3) {
          return latencyBuilder_.getMessage();
        }
        return com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    public Builder setLatency(com.google.monitoring.v3.BasicSli.LatencyCriteria value) {
      if (latencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sliCriteria_ = value;
        onChanged();
      } else {
        latencyBuilder_.setMessage(value);
      }
      sliCriteriaCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    public Builder setLatency(
        com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder builderForValue) {
      if (latencyBuilder_ == null) {
        sliCriteria_ = builderForValue.build();
        onChanged();
      } else {
        latencyBuilder_.setMessage(builderForValue.build());
      }
      sliCriteriaCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    public Builder mergeLatency(com.google.monitoring.v3.BasicSli.LatencyCriteria value) {
      if (latencyBuilder_ == null) {
        if (sliCriteriaCase_ == 3
            && sliCriteria_
                != com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance()) {
          sliCriteria_ =
              com.google.monitoring.v3.BasicSli.LatencyCriteria.newBuilder(
                      (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sliCriteria_ = value;
        }
        onChanged();
      } else {
        if (sliCriteriaCase_ == 3) {
          latencyBuilder_.mergeFrom(value);
        } else {
          latencyBuilder_.setMessage(value);
        }
      }
      sliCriteriaCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    public Builder clearLatency() {
      if (latencyBuilder_ == null) {
        if (sliCriteriaCase_ == 3) {
          sliCriteriaCase_ = 0;
          sliCriteria_ = null;
          onChanged();
        }
      } else {
        if (sliCriteriaCase_ == 3) {
          sliCriteriaCase_ = 0;
          sliCriteria_ = null;
        }
        latencyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    public com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder getLatencyBuilder() {
      return getLatencyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSli.LatencyCriteriaOrBuilder getLatencyOrBuilder() {
      if ((sliCriteriaCase_ == 3) && (latencyBuilder_ != null)) {
        return latencyBuilder_.getMessageOrBuilder();
      } else {
        if (sliCriteriaCase_ == 3) {
          return (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_;
        }
        return com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Good service is defined to be the count of requests made to this service
     * that are fast enough with respect to `latency.threshold`.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli.LatencyCriteria latency = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.BasicSli.LatencyCriteria,
            com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder,
            com.google.monitoring.v3.BasicSli.LatencyCriteriaOrBuilder>
        getLatencyFieldBuilder() {
      if (latencyBuilder_ == null) {
        if (!(sliCriteriaCase_ == 3)) {
          sliCriteria_ = com.google.monitoring.v3.BasicSli.LatencyCriteria.getDefaultInstance();
        }
        latencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.BasicSli.LatencyCriteria,
                com.google.monitoring.v3.BasicSli.LatencyCriteria.Builder,
                com.google.monitoring.v3.BasicSli.LatencyCriteriaOrBuilder>(
                (com.google.monitoring.v3.BasicSli.LatencyCriteria) sliCriteria_,
                getParentForChildren(),
                isClean());
        sliCriteria_ = null;
      }
      sliCriteriaCase_ = 3;
      onChanged();
      ;
      return latencyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.BasicSli)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.BasicSli)
  private static final com.google.monitoring.v3.BasicSli DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.BasicSli();
  }

  public static com.google.monitoring.v3.BasicSli getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BasicSli> PARSER =
      new com.google.protobuf.AbstractParser<BasicSli>() {
        @java.lang.Override
        public BasicSli parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BasicSli> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BasicSli> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.BasicSli getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
