/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The `ListTimeSeries` response.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.ListTimeSeriesResponse}
 */
public final class ListTimeSeriesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.ListTimeSeriesResponse)
    ListTimeSeriesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTimeSeriesResponse.newBuilder() to construct.
  private ListTimeSeriesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTimeSeriesResponse() {
    timeSeries_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    executionErrors_ = java.util.Collections.emptyList();
    unit_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTimeSeriesResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_ListTimeSeriesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_ListTimeSeriesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.ListTimeSeriesResponse.class,
            com.google.monitoring.v3.ListTimeSeriesResponse.Builder.class);
  }

  public static final int TIME_SERIES_FIELD_NUMBER = 1;
  private java.util.List<com.google.monitoring.v3.TimeSeries> timeSeries_;
  /**
   *
   *
   * <pre>
   * One or more time series that match the filter included in the request.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.TimeSeries> getTimeSeriesList() {
    return timeSeries_;
  }
  /**
   *
   *
   * <pre>
   * One or more time series that match the filter included in the request.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.TimeSeriesOrBuilder>
      getTimeSeriesOrBuilderList() {
    return timeSeries_;
  }
  /**
   *
   *
   * <pre>
   * One or more time series that match the filter included in the request.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
   */
  @java.lang.Override
  public int getTimeSeriesCount() {
    return timeSeries_.size();
  }
  /**
   *
   *
   * <pre>
   * One or more time series that match the filter included in the request.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeries getTimeSeries(int index) {
    return timeSeries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * One or more time series that match the filter included in the request.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesOrBuilder getTimeSeriesOrBuilder(int index) {
    return timeSeries_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * If there are more results than have been returned, then this field is set
   * to a non-empty value.  To see the additional results,
   * use that value as `page_token` in the next call to this method.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If there are more results than have been returned, then this field is set
   * to a non-empty value.  To see the additional results,
   * use that value as `page_token` in the next call to this method.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_ERRORS_FIELD_NUMBER = 3;
  private java.util.List<com.google.rpc.Status> executionErrors_;
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status execution_errors = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getExecutionErrorsList() {
    return executionErrors_;
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status execution_errors = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getExecutionErrorsOrBuilderList() {
    return executionErrors_;
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status execution_errors = 3;</code>
   */
  @java.lang.Override
  public int getExecutionErrorsCount() {
    return executionErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status execution_errors = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getExecutionErrors(int index) {
    return executionErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status execution_errors = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getExecutionErrorsOrBuilder(int index) {
    return executionErrors_.get(index);
  }

  public static final int UNIT_FIELD_NUMBER = 5;
  private volatile java.lang.Object unit_;
  /**
   *
   *
   * <pre>
   * The unit in which all `time_series` point values are reported. `unit`
   * follows the UCUM format for units as seen in
   * https://unitsofmeasure.org/ucum.html.
   * If different `time_series` have different units (for example, because they
   * come from different metric types, or a unit is absent), then `unit` will be
   * "{not_a_unit}".
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unit in which all `time_series` point values are reported. `unit`
   * follows the UCUM format for units as seen in
   * https://unitsofmeasure.org/ucum.html.
   * If different `time_series` have different units (for example, because they
   * come from different metric types, or a unit is absent), then `unit` will be
   * "{not_a_unit}".
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < timeSeries_.size(); i++) {
      output.writeMessage(1, timeSeries_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < executionErrors_.size(); i++) {
      output.writeMessage(3, executionErrors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, unit_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < timeSeries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, timeSeries_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    for (int i = 0; i < executionErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, executionErrors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, unit_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.ListTimeSeriesResponse)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.ListTimeSeriesResponse other =
        (com.google.monitoring.v3.ListTimeSeriesResponse) obj;

    if (!getTimeSeriesList().equals(other.getTimeSeriesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getExecutionErrorsList().equals(other.getExecutionErrorsList())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTimeSeriesCount() > 0) {
      hash = (37 * hash) + TIME_SERIES_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSeriesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getExecutionErrorsCount() > 0) {
      hash = (37 * hash) + EXECUTION_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionErrorsList().hashCode();
    }
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.ListTimeSeriesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `ListTimeSeries` response.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.ListTimeSeriesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.ListTimeSeriesResponse)
      com.google.monitoring.v3.ListTimeSeriesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_ListTimeSeriesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_ListTimeSeriesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.ListTimeSeriesResponse.class,
              com.google.monitoring.v3.ListTimeSeriesResponse.Builder.class);
    }

    // Construct using com.google.monitoring.v3.ListTimeSeriesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (timeSeriesBuilder_ == null) {
        timeSeries_ = java.util.Collections.emptyList();
      } else {
        timeSeries_ = null;
        timeSeriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      if (executionErrorsBuilder_ == null) {
        executionErrors_ = java.util.Collections.emptyList();
      } else {
        executionErrors_ = null;
        executionErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      unit_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_ListTimeSeriesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListTimeSeriesResponse getDefaultInstanceForType() {
      return com.google.monitoring.v3.ListTimeSeriesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListTimeSeriesResponse build() {
      com.google.monitoring.v3.ListTimeSeriesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ListTimeSeriesResponse buildPartial() {
      com.google.monitoring.v3.ListTimeSeriesResponse result =
          new com.google.monitoring.v3.ListTimeSeriesResponse(this);
      int from_bitField0_ = bitField0_;
      if (timeSeriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          timeSeries_ = java.util.Collections.unmodifiableList(timeSeries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.timeSeries_ = timeSeries_;
      } else {
        result.timeSeries_ = timeSeriesBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      if (executionErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          executionErrors_ = java.util.Collections.unmodifiableList(executionErrors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.executionErrors_ = executionErrors_;
      } else {
        result.executionErrors_ = executionErrorsBuilder_.build();
      }
      result.unit_ = unit_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.ListTimeSeriesResponse) {
        return mergeFrom((com.google.monitoring.v3.ListTimeSeriesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.ListTimeSeriesResponse other) {
      if (other == com.google.monitoring.v3.ListTimeSeriesResponse.getDefaultInstance())
        return this;
      if (timeSeriesBuilder_ == null) {
        if (!other.timeSeries_.isEmpty()) {
          if (timeSeries_.isEmpty()) {
            timeSeries_ = other.timeSeries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTimeSeriesIsMutable();
            timeSeries_.addAll(other.timeSeries_);
          }
          onChanged();
        }
      } else {
        if (!other.timeSeries_.isEmpty()) {
          if (timeSeriesBuilder_.isEmpty()) {
            timeSeriesBuilder_.dispose();
            timeSeriesBuilder_ = null;
            timeSeries_ = other.timeSeries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            timeSeriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTimeSeriesFieldBuilder()
                    : null;
          } else {
            timeSeriesBuilder_.addAllMessages(other.timeSeries_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (executionErrorsBuilder_ == null) {
        if (!other.executionErrors_.isEmpty()) {
          if (executionErrors_.isEmpty()) {
            executionErrors_ = other.executionErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExecutionErrorsIsMutable();
            executionErrors_.addAll(other.executionErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.executionErrors_.isEmpty()) {
          if (executionErrorsBuilder_.isEmpty()) {
            executionErrorsBuilder_.dispose();
            executionErrorsBuilder_ = null;
            executionErrors_ = other.executionErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            executionErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExecutionErrorsFieldBuilder()
                    : null;
          } else {
            executionErrorsBuilder_.addAllMessages(other.executionErrors_);
          }
        }
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.monitoring.v3.TimeSeries m =
                    input.readMessage(
                        com.google.monitoring.v3.TimeSeries.parser(), extensionRegistry);
                if (timeSeriesBuilder_ == null) {
                  ensureTimeSeriesIsMutable();
                  timeSeries_.add(m);
                } else {
                  timeSeriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (executionErrorsBuilder_ == null) {
                  ensureExecutionErrorsIsMutable();
                  executionErrors_.add(m);
                } else {
                  executionErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 42:
              {
                unit_ = input.readStringRequireUtf8();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.monitoring.v3.TimeSeries> timeSeries_ =
        java.util.Collections.emptyList();

    private void ensureTimeSeriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        timeSeries_ = new java.util.ArrayList<com.google.monitoring.v3.TimeSeries>(timeSeries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeries,
            com.google.monitoring.v3.TimeSeries.Builder,
            com.google.monitoring.v3.TimeSeriesOrBuilder>
        timeSeriesBuilder_;

    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeries> getTimeSeriesList() {
      if (timeSeriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timeSeries_);
      } else {
        return timeSeriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public int getTimeSeriesCount() {
      if (timeSeriesBuilder_ == null) {
        return timeSeries_.size();
      } else {
        return timeSeriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public com.google.monitoring.v3.TimeSeries getTimeSeries(int index) {
      if (timeSeriesBuilder_ == null) {
        return timeSeries_.get(index);
      } else {
        return timeSeriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder setTimeSeries(int index, com.google.monitoring.v3.TimeSeries value) {
      if (timeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesIsMutable();
        timeSeries_.set(index, value);
        onChanged();
      } else {
        timeSeriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder setTimeSeries(
        int index, com.google.monitoring.v3.TimeSeries.Builder builderForValue) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.set(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder addTimeSeries(com.google.monitoring.v3.TimeSeries value) {
      if (timeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesIsMutable();
        timeSeries_.add(value);
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder addTimeSeries(int index, com.google.monitoring.v3.TimeSeries value) {
      if (timeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesIsMutable();
        timeSeries_.add(index, value);
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder addTimeSeries(com.google.monitoring.v3.TimeSeries.Builder builderForValue) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.add(builderForValue.build());
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder addTimeSeries(
        int index, com.google.monitoring.v3.TimeSeries.Builder builderForValue) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.add(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder addAllTimeSeries(
        java.lang.Iterable<? extends com.google.monitoring.v3.TimeSeries> values) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timeSeries_);
        onChanged();
      } else {
        timeSeriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder clearTimeSeries() {
      if (timeSeriesBuilder_ == null) {
        timeSeries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        timeSeriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public Builder removeTimeSeries(int index) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.remove(index);
        onChanged();
      } else {
        timeSeriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public com.google.monitoring.v3.TimeSeries.Builder getTimeSeriesBuilder(int index) {
      return getTimeSeriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public com.google.monitoring.v3.TimeSeriesOrBuilder getTimeSeriesOrBuilder(int index) {
      if (timeSeriesBuilder_ == null) {
        return timeSeries_.get(index);
      } else {
        return timeSeriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.TimeSeriesOrBuilder>
        getTimeSeriesOrBuilderList() {
      if (timeSeriesBuilder_ != null) {
        return timeSeriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timeSeries_);
      }
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public com.google.monitoring.v3.TimeSeries.Builder addTimeSeriesBuilder() {
      return getTimeSeriesFieldBuilder()
          .addBuilder(com.google.monitoring.v3.TimeSeries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public com.google.monitoring.v3.TimeSeries.Builder addTimeSeriesBuilder(int index) {
      return getTimeSeriesFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.TimeSeries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * One or more time series that match the filter included in the request.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeries time_series = 1;</code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeries.Builder> getTimeSeriesBuilderList() {
      return getTimeSeriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeries,
            com.google.monitoring.v3.TimeSeries.Builder,
            com.google.monitoring.v3.TimeSeriesOrBuilder>
        getTimeSeriesFieldBuilder() {
      if (timeSeriesBuilder_ == null) {
        timeSeriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.TimeSeries,
                com.google.monitoring.v3.TimeSeries.Builder,
                com.google.monitoring.v3.TimeSeriesOrBuilder>(
                timeSeries_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        timeSeries_ = null;
      }
      return timeSeriesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results,
     * use that value as `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results,
     * use that value as `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results,
     * use that value as `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results,
     * use that value as `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results,
     * use that value as `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> executionErrors_ =
        java.util.Collections.emptyList();

    private void ensureExecutionErrorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        executionErrors_ = new java.util.ArrayList<com.google.rpc.Status>(executionErrors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        executionErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public java.util.List<com.google.rpc.Status> getExecutionErrorsList() {
      if (executionErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(executionErrors_);
      } else {
        return executionErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public int getExecutionErrorsCount() {
      if (executionErrorsBuilder_ == null) {
        return executionErrors_.size();
      } else {
        return executionErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public com.google.rpc.Status getExecutionErrors(int index) {
      if (executionErrorsBuilder_ == null) {
        return executionErrors_.get(index);
      } else {
        return executionErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder setExecutionErrors(int index, com.google.rpc.Status value) {
      if (executionErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionErrorsIsMutable();
        executionErrors_.set(index, value);
        onChanged();
      } else {
        executionErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder setExecutionErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (executionErrorsBuilder_ == null) {
        ensureExecutionErrorsIsMutable();
        executionErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        executionErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder addExecutionErrors(com.google.rpc.Status value) {
      if (executionErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionErrorsIsMutable();
        executionErrors_.add(value);
        onChanged();
      } else {
        executionErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder addExecutionErrors(int index, com.google.rpc.Status value) {
      if (executionErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionErrorsIsMutable();
        executionErrors_.add(index, value);
        onChanged();
      } else {
        executionErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder addExecutionErrors(com.google.rpc.Status.Builder builderForValue) {
      if (executionErrorsBuilder_ == null) {
        ensureExecutionErrorsIsMutable();
        executionErrors_.add(builderForValue.build());
        onChanged();
      } else {
        executionErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder addExecutionErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (executionErrorsBuilder_ == null) {
        ensureExecutionErrorsIsMutable();
        executionErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        executionErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder addAllExecutionErrors(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (executionErrorsBuilder_ == null) {
        ensureExecutionErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, executionErrors_);
        onChanged();
      } else {
        executionErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder clearExecutionErrors() {
      if (executionErrorsBuilder_ == null) {
        executionErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        executionErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public Builder removeExecutionErrors(int index) {
      if (executionErrorsBuilder_ == null) {
        ensureExecutionErrorsIsMutable();
        executionErrors_.remove(index);
        onChanged();
      } else {
        executionErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public com.google.rpc.Status.Builder getExecutionErrorsBuilder(int index) {
      return getExecutionErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getExecutionErrorsOrBuilder(int index) {
      if (executionErrorsBuilder_ == null) {
        return executionErrors_.get(index);
      } else {
        return executionErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getExecutionErrorsOrBuilderList() {
      if (executionErrorsBuilder_ != null) {
        return executionErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(executionErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public com.google.rpc.Status.Builder addExecutionErrorsBuilder() {
      return getExecutionErrorsFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public com.google.rpc.Status.Builder addExecutionErrorsBuilder(int index) {
      return getExecutionErrorsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status execution_errors = 3;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getExecutionErrorsBuilderList() {
      return getExecutionErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getExecutionErrorsFieldBuilder() {
      if (executionErrorsBuilder_ == null) {
        executionErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                executionErrors_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        executionErrors_ = null;
      }
      return executionErrorsBuilder_;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The unit in which all `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * If different `time_series` have different units (for example, because they
     * come from different metric types, or a unit is absent), then `unit` will be
     * "{not_a_unit}".
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unit in which all `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * If different `time_series` have different units (for example, because they
     * come from different metric types, or a unit is absent), then `unit` will be
     * "{not_a_unit}".
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unit in which all `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * If different `time_series` have different units (for example, because they
     * come from different metric types, or a unit is absent), then `unit` will be
     * "{not_a_unit}".
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      unit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unit in which all `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * If different `time_series` have different units (for example, because they
     * come from different metric types, or a unit is absent), then `unit` will be
     * "{not_a_unit}".
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {

      unit_ = getDefaultInstance().getUnit();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unit in which all `time_series` point values are reported. `unit`
     * follows the UCUM format for units as seen in
     * https://unitsofmeasure.org/ucum.html.
     * If different `time_series` have different units (for example, because they
     * come from different metric types, or a unit is absent), then `unit` will be
     * "{not_a_unit}".
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      unit_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.ListTimeSeriesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.ListTimeSeriesResponse)
  private static final com.google.monitoring.v3.ListTimeSeriesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.ListTimeSeriesResponse();
  }

  public static com.google.monitoring.v3.ListTimeSeriesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTimeSeriesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListTimeSeriesResponse>() {
        @java.lang.Override
        public ListTimeSeriesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListTimeSeriesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTimeSeriesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.ListTimeSeriesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
