/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/notification.proto

// Protobuf Java Version: 3.25.3
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A `NotificationChannel` is a medium through which an alert is
 * delivered when a policy violation is detected. Examples of channels
 * include email, SMS, and third-party messaging applications. Fields
 * containing sensitive information like authentication tokens or
 * contact info are only partially populated on retrieval.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.NotificationChannel}
 */
public final class NotificationChannel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.NotificationChannel)
    NotificationChannelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationChannel.newBuilder() to construct.
  private NotificationChannel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationChannel() {
    type_ = "";
    name_ = "";
    displayName_ = "";
    description_ = "";
    verificationStatus_ = 0;
    mutationRecords_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotificationChannel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.NotificationProto
        .internal_static_google_monitoring_v3_NotificationChannel_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      case 8:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.NotificationProto
        .internal_static_google_monitoring_v3_NotificationChannel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.NotificationChannel.class,
            com.google.monitoring.v3.NotificationChannel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates whether the channel has been verified or not. It is illegal
   * to specify this field in a
   * [`CreateNotificationChannel`][google.monitoring.v3.NotificationChannelService.CreateNotificationChannel]
   * or an
   * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
   * operation.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.NotificationChannel.VerificationStatus}
   */
  public enum VerificationStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Sentinel value used to indicate that the state is unknown, omitted, or
     * is not applicable (as in the case of channels that neither support
     * nor require verification in order to function).
     * </pre>
     *
     * <code>VERIFICATION_STATUS_UNSPECIFIED = 0;</code>
     */
    VERIFICATION_STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The channel has yet to be verified and requires verification to function.
     * Note that this state also applies to the case where the verification
     * process has been initiated by sending a verification code but where
     * the verification code has not been submitted to complete the process.
     * </pre>
     *
     * <code>UNVERIFIED = 1;</code>
     */
    UNVERIFIED(1),
    /**
     *
     *
     * <pre>
     * It has been proven that notifications can be received on this
     * notification channel and that someone on the project has access
     * to messages that are delivered to that channel.
     * </pre>
     *
     * <code>VERIFIED = 2;</code>
     */
    VERIFIED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Sentinel value used to indicate that the state is unknown, omitted, or
     * is not applicable (as in the case of channels that neither support
     * nor require verification in order to function).
     * </pre>
     *
     * <code>VERIFICATION_STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int VERIFICATION_STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The channel has yet to be verified and requires verification to function.
     * Note that this state also applies to the case where the verification
     * process has been initiated by sending a verification code but where
     * the verification code has not been submitted to complete the process.
     * </pre>
     *
     * <code>UNVERIFIED = 1;</code>
     */
    public static final int UNVERIFIED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * It has been proven that notifications can be received on this
     * notification channel and that someone on the project has access
     * to messages that are delivered to that channel.
     * </pre>
     *
     * <code>VERIFIED = 2;</code>
     */
    public static final int VERIFIED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VerificationStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VerificationStatus forNumber(int value) {
      switch (value) {
        case 0:
          return VERIFICATION_STATUS_UNSPECIFIED;
        case 1:
          return UNVERIFIED;
        case 2:
          return VERIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VerificationStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VerificationStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VerificationStatus>() {
              public VerificationStatus findValueByNumber(int number) {
                return VerificationStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.NotificationChannel.getDescriptor().getEnumTypes().get(0);
    }

    private static final VerificationStatus[] VALUES = values();

    public static VerificationStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VerificationStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.NotificationChannel.VerificationStatus)
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of the notification channel. This field matches the
   * value of the
   * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
   * field.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the notification channel. This field matches the
   * value of the
   * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
   * field.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full REST resource name for this channel. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
   *
   * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full REST resource name for this channel. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
   *
   * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * An optional human-readable name for this notification channel. It is
   * recommended that you specify a non-empty and unique name in order to
   * make it easier to identify the channels in your project, though this is
   * not enforced. The display name is limited to 512 Unicode characters.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional human-readable name for this notification channel. It is
   * recommended that you specify a non-empty and unique name in order to
   * make it easier to identify the channels in your project, though this is
   * not enforced. The display name is limited to 512 Unicode characters.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional human-readable description of this notification channel. This
   * description may provide additional details, beyond the display
   * name, for the channel. This may not exceed 1024 Unicode characters.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional human-readable description of this notification channel. This
   * description may provide additional details, beyond the display
   * name, for the channel. This may not exceed 1024 Unicode characters.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.NotificationProto
                .internal_static_google_monitoring_v3_NotificationChannel_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Configuration fields that define the channel and its behavior. The
   * permissible and required labels are specified in the
   * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
   * of the `NotificationChannelDescriptor` corresponding to the `type` field.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int USER_LABELS_FIELD_NUMBER = 8;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.NotificationProto
                .internal_static_google_monitoring_v3_NotificationChannel_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data that does not need to conform to
   * the corresponding `NotificationChannelDescriptor`'s schema, unlike
   * the `labels` field. This field is intended to be used for organizing
   * and identifying the `NotificationChannel` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int VERIFICATION_STATUS_FIELD_NUMBER = 9;
  private int verificationStatus_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates whether this channel has been verified or not. On a
   * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * or
   * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
   * operation, this field is expected to be populated.
   *
   * If the value is `UNVERIFIED`, then it indicates that the channel is
   * non-functioning (it both requires verification and lacks verification);
   * otherwise, it is assumed that the channel works.
   *
   * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
   * the channel is of a type that does not require verification or that
   * this specific channel has been exempted from verification because it was
   * created prior to verification being required for channels of this type.
   *
   * This field cannot be modified using a standard
   * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
   * operation. To change the value of this field, you must call
   * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
   * </pre>
   *
   * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
   * </code>
   *
   * @return The enum numeric value on the wire for verificationStatus.
   */
  @java.lang.Override
  public int getVerificationStatusValue() {
    return verificationStatus_;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether this channel has been verified or not. On a
   * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * or
   * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
   * operation, this field is expected to be populated.
   *
   * If the value is `UNVERIFIED`, then it indicates that the channel is
   * non-functioning (it both requires verification and lacks verification);
   * otherwise, it is assumed that the channel works.
   *
   * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
   * the channel is of a type that does not require verification or that
   * this specific channel has been exempted from verification because it was
   * created prior to verification being required for channels of this type.
   *
   * This field cannot be modified using a standard
   * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
   * operation. To change the value of this field, you must call
   * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
   * </pre>
   *
   * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
   * </code>
   *
   * @return The verificationStatus.
   */
  @java.lang.Override
  public com.google.monitoring.v3.NotificationChannel.VerificationStatus getVerificationStatus() {
    com.google.monitoring.v3.NotificationChannel.VerificationStatus result =
        com.google.monitoring.v3.NotificationChannel.VerificationStatus.forNumber(
            verificationStatus_);
    return result == null
        ? com.google.monitoring.v3.NotificationChannel.VerificationStatus.UNRECOGNIZED
        : result;
  }

  public static final int ENABLED_FIELD_NUMBER = 11;
  private com.google.protobuf.BoolValue enabled_;
  /**
   *
   *
   * <pre>
   * Whether notifications are forwarded to the described channel. This makes
   * it possible to disable delivery of notifications to a particular channel
   * without removing the channel from all alerting policies that reference
   * the channel. This is a more convenient approach when the change is
   * temporary and you want to receive notifications from the same set
   * of alerting policies on the channel at some point in the future.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 11;</code>
   *
   * @return Whether the enabled field is set.
   */
  @java.lang.Override
  public boolean hasEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether notifications are forwarded to the described channel. This makes
   * it possible to disable delivery of notifications to a particular channel
   * without removing the channel from all alerting policies that reference
   * the channel. This is a more convenient approach when the change is
   * temporary and you want to receive notifications from the same set
   * of alerting policies on the channel at some point in the future.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 11;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getEnabled() {
    return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
  }
  /**
   *
   *
   * <pre>
   * Whether notifications are forwarded to the described channel. This makes
   * it possible to disable delivery of notifications to a particular channel
   * without removing the channel from all alerting policies that reference
   * the channel. This is a more convenient approach when the change is
   * temporary and you want to receive notifications from the same set
   * of alerting policies on the channel at some point in the future.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
    return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
  }

  public static final int CREATION_RECORD_FIELD_NUMBER = 12;
  private com.google.monitoring.v3.MutationRecord creationRecord_;
  /**
   *
   *
   * <pre>
   * Record of the creation of this channel.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
   *
   * @return Whether the creationRecord field is set.
   */
  @java.lang.Override
  public boolean hasCreationRecord() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Record of the creation of this channel.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
   *
   * @return The creationRecord.
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecord getCreationRecord() {
    return creationRecord_ == null
        ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
        : creationRecord_;
  }
  /**
   *
   *
   * <pre>
   * Record of the creation of this channel.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecordOrBuilder getCreationRecordOrBuilder() {
    return creationRecord_ == null
        ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
        : creationRecord_;
  }

  public static final int MUTATION_RECORDS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.MutationRecord> mutationRecords_;
  /**
   *
   *
   * <pre>
   * Records of the modification of this channel.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.MutationRecord> getMutationRecordsList() {
    return mutationRecords_;
  }
  /**
   *
   *
   * <pre>
   * Records of the modification of this channel.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.MutationRecordOrBuilder>
      getMutationRecordsOrBuilderList() {
    return mutationRecords_;
  }
  /**
   *
   *
   * <pre>
   * Records of the modification of this channel.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
   */
  @java.lang.Override
  public int getMutationRecordsCount() {
    return mutationRecords_.size();
  }
  /**
   *
   *
   * <pre>
   * Records of the modification of this channel.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecord getMutationRecords(int index) {
    return mutationRecords_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Records of the modification of this channel.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecordOrBuilder getMutationRecordsOrBuilder(int index) {
    return mutationRecords_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 8);
    if (verificationStatus_
        != com.google.monitoring.v3.NotificationChannel.VerificationStatus
            .VERIFICATION_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, verificationStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getEnabled());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getCreationRecord());
    }
    for (int i = 0; i < mutationRecords_.size(); i++) {
      output.writeMessage(13, mutationRecords_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, userLabels__);
    }
    if (verificationStatus_
        != com.google.monitoring.v3.NotificationChannel.VerificationStatus
            .VERIFICATION_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, verificationStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEnabled());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCreationRecord());
    }
    for (int i = 0; i < mutationRecords_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, mutationRecords_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.NotificationChannel)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.NotificationChannel other =
        (com.google.monitoring.v3.NotificationChannel) obj;

    if (!getType().equals(other.getType())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (verificationStatus_ != other.verificationStatus_) return false;
    if (hasEnabled() != other.hasEnabled()) return false;
    if (hasEnabled()) {
      if (!getEnabled().equals(other.getEnabled())) return false;
    }
    if (hasCreationRecord() != other.hasCreationRecord()) return false;
    if (hasCreationRecord()) {
      if (!getCreationRecord().equals(other.getCreationRecord())) return false;
    }
    if (!getMutationRecordsList().equals(other.getMutationRecordsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (37 * hash) + VERIFICATION_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + verificationStatus_;
    if (hasEnabled()) {
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + getEnabled().hashCode();
    }
    if (hasCreationRecord()) {
      hash = (37 * hash) + CREATION_RECORD_FIELD_NUMBER;
      hash = (53 * hash) + getCreationRecord().hashCode();
    }
    if (getMutationRecordsCount() > 0) {
      hash = (37 * hash) + MUTATION_RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getMutationRecordsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.NotificationChannel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.NotificationChannel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `NotificationChannel` is a medium through which an alert is
   * delivered when a policy violation is detected. Examples of channels
   * include email, SMS, and third-party messaging applications. Fields
   * containing sensitive information like authentication tokens or
   * contact info are only partially populated on retrieval.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.NotificationChannel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.NotificationChannel)
      com.google.monitoring.v3.NotificationChannelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannel_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        case 8:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        case 8:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.NotificationChannel.class,
              com.google.monitoring.v3.NotificationChannel.Builder.class);
    }

    // Construct using com.google.monitoring.v3.NotificationChannel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEnabledFieldBuilder();
        getCreationRecordFieldBuilder();
        getMutationRecordsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = "";
      name_ = "";
      displayName_ = "";
      description_ = "";
      internalGetMutableLabels().clear();
      internalGetMutableUserLabels().clear();
      verificationStatus_ = 0;
      enabled_ = null;
      if (enabledBuilder_ != null) {
        enabledBuilder_.dispose();
        enabledBuilder_ = null;
      }
      creationRecord_ = null;
      if (creationRecordBuilder_ != null) {
        creationRecordBuilder_.dispose();
        creationRecordBuilder_ = null;
      }
      if (mutationRecordsBuilder_ == null) {
        mutationRecords_ = java.util.Collections.emptyList();
      } else {
        mutationRecords_ = null;
        mutationRecordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.NotificationProto
          .internal_static_google_monitoring_v3_NotificationChannel_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel getDefaultInstanceForType() {
      return com.google.monitoring.v3.NotificationChannel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel build() {
      com.google.monitoring.v3.NotificationChannel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel buildPartial() {
      com.google.monitoring.v3.NotificationChannel result =
          new com.google.monitoring.v3.NotificationChannel(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.monitoring.v3.NotificationChannel result) {
      if (mutationRecordsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          mutationRecords_ = java.util.Collections.unmodifiableList(mutationRecords_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.mutationRecords_ = mutationRecords_;
      } else {
        result.mutationRecords_ = mutationRecordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.NotificationChannel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.verificationStatus_ = verificationStatus_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enabled_ = enabledBuilder_ == null ? enabled_ : enabledBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.creationRecord_ =
            creationRecordBuilder_ == null ? creationRecord_ : creationRecordBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.NotificationChannel) {
        return mergeFrom((com.google.monitoring.v3.NotificationChannel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.NotificationChannel other) {
      if (other == com.google.monitoring.v3.NotificationChannel.getDefaultInstance()) return this;
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000020;
      if (other.verificationStatus_ != 0) {
        setVerificationStatusValue(other.getVerificationStatusValue());
      }
      if (other.hasEnabled()) {
        mergeEnabled(other.getEnabled());
      }
      if (other.hasCreationRecord()) {
        mergeCreationRecord(other.getCreationRecord());
      }
      if (mutationRecordsBuilder_ == null) {
        if (!other.mutationRecords_.isEmpty()) {
          if (mutationRecords_.isEmpty()) {
            mutationRecords_ = other.mutationRecords_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureMutationRecordsIsMutable();
            mutationRecords_.addAll(other.mutationRecords_);
          }
          onChanged();
        }
      } else {
        if (!other.mutationRecords_.isEmpty()) {
          if (mutationRecordsBuilder_.isEmpty()) {
            mutationRecordsBuilder_.dispose();
            mutationRecordsBuilder_ = null;
            mutationRecords_ = other.mutationRecords_;
            bitField0_ = (bitField0_ & ~0x00000200);
            mutationRecordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMutationRecordsFieldBuilder()
                    : null;
          } else {
            mutationRecordsBuilder_.addAllMessages(other.mutationRecords_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 72:
              {
                verificationStatus_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 72
            case 90:
              {
                input.readMessage(getEnabledFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getCreationRecordFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            case 106:
              {
                com.google.monitoring.v3.MutationRecord m =
                    input.readMessage(
                        com.google.monitoring.v3.MutationRecord.parser(), extensionRegistry);
                if (mutationRecordsBuilder_ == null) {
                  ensureMutationRecordsIsMutable();
                  mutationRecords_.add(m);
                } else {
                  mutationRecordsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the notification channel. This field matches the
     * value of the
     * [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type]
     * field.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
     *
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
     *
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
     *
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
     *
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full REST resource name for this channel. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
     *
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels]
     * of the `NotificationChannelDescriptor` corresponding to the `type` field.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private int verificationStatus_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     *
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     *
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     *
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     *
     * @return The enum numeric value on the wire for verificationStatus.
     */
    @java.lang.Override
    public int getVerificationStatusValue() {
      return verificationStatus_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     *
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     *
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     *
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     *
     * @param value The enum numeric value on the wire for verificationStatus to set.
     * @return This builder for chaining.
     */
    public Builder setVerificationStatusValue(int value) {
      verificationStatus_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     *
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     *
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     *
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     *
     * @return The verificationStatus.
     */
    @java.lang.Override
    public com.google.monitoring.v3.NotificationChannel.VerificationStatus getVerificationStatus() {
      com.google.monitoring.v3.NotificationChannel.VerificationStatus result =
          com.google.monitoring.v3.NotificationChannel.VerificationStatus.forNumber(
              verificationStatus_);
      return result == null
          ? com.google.monitoring.v3.NotificationChannel.VerificationStatus.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     *
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     *
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     *
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     *
     * @param value The verificationStatus to set.
     * @return This builder for chaining.
     */
    public Builder setVerificationStatus(
        com.google.monitoring.v3.NotificationChannel.VerificationStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      verificationStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     *
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     *
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     *
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     * </pre>
     *
     * <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerificationStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      verificationStatus_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue enabled_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        enabledBuilder_;
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     *
     * @return Whether the enabled field is set.
     */
    public boolean hasEnabled() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     *
     * @return The enabled.
     */
    public com.google.protobuf.BoolValue getEnabled() {
      if (enabledBuilder_ == null) {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      } else {
        return enabledBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder setEnabled(com.google.protobuf.BoolValue value) {
      if (enabledBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enabled_ = value;
      } else {
        enabledBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder setEnabled(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (enabledBuilder_ == null) {
        enabled_ = builderForValue.build();
      } else {
        enabledBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder mergeEnabled(com.google.protobuf.BoolValue value) {
      if (enabledBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && enabled_ != null
            && enabled_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getEnabledBuilder().mergeFrom(value);
        } else {
          enabled_ = value;
        }
      } else {
        enabledBuilder_.mergeFrom(value);
      }
      if (enabled_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enabled_ = null;
      if (enabledBuilder_ != null) {
        enabledBuilder_.dispose();
        enabledBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public com.google.protobuf.BoolValue.Builder getEnabledBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEnabledFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
      if (enabledBuilder_ != null) {
        return enabledBuilder_.getMessageOrBuilder();
      } else {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getEnabledFieldBuilder() {
      if (enabledBuilder_ == null) {
        enabledBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getEnabled(), getParentForChildren(), isClean());
        enabled_ = null;
      }
      return enabledBuilder_;
    }

    private com.google.monitoring.v3.MutationRecord creationRecord_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.MutationRecord,
            com.google.monitoring.v3.MutationRecord.Builder,
            com.google.monitoring.v3.MutationRecordOrBuilder>
        creationRecordBuilder_;
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     *
     * @return Whether the creationRecord field is set.
     */
    public boolean hasCreationRecord() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     *
     * @return The creationRecord.
     */
    public com.google.monitoring.v3.MutationRecord getCreationRecord() {
      if (creationRecordBuilder_ == null) {
        return creationRecord_ == null
            ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
            : creationRecord_;
      } else {
        return creationRecordBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    public Builder setCreationRecord(com.google.monitoring.v3.MutationRecord value) {
      if (creationRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        creationRecord_ = value;
      } else {
        creationRecordBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    public Builder setCreationRecord(
        com.google.monitoring.v3.MutationRecord.Builder builderForValue) {
      if (creationRecordBuilder_ == null) {
        creationRecord_ = builderForValue.build();
      } else {
        creationRecordBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    public Builder mergeCreationRecord(com.google.monitoring.v3.MutationRecord value) {
      if (creationRecordBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && creationRecord_ != null
            && creationRecord_ != com.google.monitoring.v3.MutationRecord.getDefaultInstance()) {
          getCreationRecordBuilder().mergeFrom(value);
        } else {
          creationRecord_ = value;
        }
      } else {
        creationRecordBuilder_.mergeFrom(value);
      }
      if (creationRecord_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    public Builder clearCreationRecord() {
      bitField0_ = (bitField0_ & ~0x00000100);
      creationRecord_ = null;
      if (creationRecordBuilder_ != null) {
        creationRecordBuilder_.dispose();
        creationRecordBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    public com.google.monitoring.v3.MutationRecord.Builder getCreationRecordBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreationRecordFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    public com.google.monitoring.v3.MutationRecordOrBuilder getCreationRecordOrBuilder() {
      if (creationRecordBuilder_ != null) {
        return creationRecordBuilder_.getMessageOrBuilder();
      } else {
        return creationRecord_ == null
            ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
            : creationRecord_;
      }
    }
    /**
     *
     *
     * <pre>
     * Record of the creation of this channel.
     * </pre>
     *
     * <code>.google.monitoring.v3.MutationRecord creation_record = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.MutationRecord,
            com.google.monitoring.v3.MutationRecord.Builder,
            com.google.monitoring.v3.MutationRecordOrBuilder>
        getCreationRecordFieldBuilder() {
      if (creationRecordBuilder_ == null) {
        creationRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.MutationRecord,
                com.google.monitoring.v3.MutationRecord.Builder,
                com.google.monitoring.v3.MutationRecordOrBuilder>(
                getCreationRecord(), getParentForChildren(), isClean());
        creationRecord_ = null;
      }
      return creationRecordBuilder_;
    }

    private java.util.List<com.google.monitoring.v3.MutationRecord> mutationRecords_ =
        java.util.Collections.emptyList();

    private void ensureMutationRecordsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        mutationRecords_ =
            new java.util.ArrayList<com.google.monitoring.v3.MutationRecord>(mutationRecords_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.MutationRecord,
            com.google.monitoring.v3.MutationRecord.Builder,
            com.google.monitoring.v3.MutationRecordOrBuilder>
        mutationRecordsBuilder_;

    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public java.util.List<com.google.monitoring.v3.MutationRecord> getMutationRecordsList() {
      if (mutationRecordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mutationRecords_);
      } else {
        return mutationRecordsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public int getMutationRecordsCount() {
      if (mutationRecordsBuilder_ == null) {
        return mutationRecords_.size();
      } else {
        return mutationRecordsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public com.google.monitoring.v3.MutationRecord getMutationRecords(int index) {
      if (mutationRecordsBuilder_ == null) {
        return mutationRecords_.get(index);
      } else {
        return mutationRecordsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder setMutationRecords(int index, com.google.monitoring.v3.MutationRecord value) {
      if (mutationRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationRecordsIsMutable();
        mutationRecords_.set(index, value);
        onChanged();
      } else {
        mutationRecordsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder setMutationRecords(
        int index, com.google.monitoring.v3.MutationRecord.Builder builderForValue) {
      if (mutationRecordsBuilder_ == null) {
        ensureMutationRecordsIsMutable();
        mutationRecords_.set(index, builderForValue.build());
        onChanged();
      } else {
        mutationRecordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder addMutationRecords(com.google.monitoring.v3.MutationRecord value) {
      if (mutationRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationRecordsIsMutable();
        mutationRecords_.add(value);
        onChanged();
      } else {
        mutationRecordsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder addMutationRecords(int index, com.google.monitoring.v3.MutationRecord value) {
      if (mutationRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationRecordsIsMutable();
        mutationRecords_.add(index, value);
        onChanged();
      } else {
        mutationRecordsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder addMutationRecords(
        com.google.monitoring.v3.MutationRecord.Builder builderForValue) {
      if (mutationRecordsBuilder_ == null) {
        ensureMutationRecordsIsMutable();
        mutationRecords_.add(builderForValue.build());
        onChanged();
      } else {
        mutationRecordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder addMutationRecords(
        int index, com.google.monitoring.v3.MutationRecord.Builder builderForValue) {
      if (mutationRecordsBuilder_ == null) {
        ensureMutationRecordsIsMutable();
        mutationRecords_.add(index, builderForValue.build());
        onChanged();
      } else {
        mutationRecordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder addAllMutationRecords(
        java.lang.Iterable<? extends com.google.monitoring.v3.MutationRecord> values) {
      if (mutationRecordsBuilder_ == null) {
        ensureMutationRecordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutationRecords_);
        onChanged();
      } else {
        mutationRecordsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder clearMutationRecords() {
      if (mutationRecordsBuilder_ == null) {
        mutationRecords_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        mutationRecordsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public Builder removeMutationRecords(int index) {
      if (mutationRecordsBuilder_ == null) {
        ensureMutationRecordsIsMutable();
        mutationRecords_.remove(index);
        onChanged();
      } else {
        mutationRecordsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public com.google.monitoring.v3.MutationRecord.Builder getMutationRecordsBuilder(int index) {
      return getMutationRecordsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public com.google.monitoring.v3.MutationRecordOrBuilder getMutationRecordsOrBuilder(int index) {
      if (mutationRecordsBuilder_ == null) {
        return mutationRecords_.get(index);
      } else {
        return mutationRecordsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.MutationRecordOrBuilder>
        getMutationRecordsOrBuilderList() {
      if (mutationRecordsBuilder_ != null) {
        return mutationRecordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mutationRecords_);
      }
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public com.google.monitoring.v3.MutationRecord.Builder addMutationRecordsBuilder() {
      return getMutationRecordsFieldBuilder()
          .addBuilder(com.google.monitoring.v3.MutationRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public com.google.monitoring.v3.MutationRecord.Builder addMutationRecordsBuilder(int index) {
      return getMutationRecordsFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.MutationRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Records of the modification of this channel.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.MutationRecord mutation_records = 13;</code>
     */
    public java.util.List<com.google.monitoring.v3.MutationRecord.Builder>
        getMutationRecordsBuilderList() {
      return getMutationRecordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.MutationRecord,
            com.google.monitoring.v3.MutationRecord.Builder,
            com.google.monitoring.v3.MutationRecordOrBuilder>
        getMutationRecordsFieldBuilder() {
      if (mutationRecordsBuilder_ == null) {
        mutationRecordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.MutationRecord,
                com.google.monitoring.v3.MutationRecord.Builder,
                com.google.monitoring.v3.MutationRecordOrBuilder>(
                mutationRecords_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        mutationRecords_ = null;
      }
      return mutationRecordsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.NotificationChannel)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.NotificationChannel)
  private static final com.google.monitoring.v3.NotificationChannel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.NotificationChannel();
  }

  public static com.google.monitoring.v3.NotificationChannel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationChannel> PARSER =
      new com.google.protobuf.AbstractParser<NotificationChannel>() {
        @java.lang.Override
        public NotificationChannel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotificationChannel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationChannel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.NotificationChannel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
