/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric.proto

// Protobuf Java Version: 3.25.4
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A locator for text. Indicates a particular part of the text of a request or
 * of an object referenced in the request.
 *
 * For example, suppose the request field `text` contains:
 *
 *   text: "The quick brown fox jumps over the lazy dog."
 *
 * Then the locator:
 *
 *   source: "text"
 *   start_position {
 *     line: 1
 *     column: 17
 *   }
 *   end_position {
 *     line: 1
 *     column: 19
 *   }
 *
 * refers to the part of the text: "fox".
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.TextLocator}
 */
public final class TextLocator extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.TextLocator)
    TextLocatorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextLocator.newBuilder() to construct.
  private TextLocator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextLocator() {
    source_ = "";
    nestingReason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextLocator();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TextLocator_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TextLocator_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.TextLocator.class,
            com.google.monitoring.v3.TextLocator.Builder.class);
  }

  public interface PositionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.TextLocator.Position)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The line, starting with 1, where the byte is positioned.
     * </pre>
     *
     * <code>int32 line = 1;</code>
     *
     * @return The line.
     */
    int getLine();

    /**
     *
     *
     * <pre>
     * The column within the line, starting with 1, where the byte is
     * positioned. This is a byte index even though the text is UTF-8.
     * </pre>
     *
     * <code>int32 column = 2;</code>
     *
     * @return The column.
     */
    int getColumn();
  }
  /**
   *
   *
   * <pre>
   * The position of a byte within the text.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TextLocator.Position}
   */
  public static final class Position extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.TextLocator.Position)
      PositionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Position.newBuilder() to construct.
    private Position(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Position() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Position();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TextLocator_Position_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TextLocator_Position_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TextLocator.Position.class,
              com.google.monitoring.v3.TextLocator.Position.Builder.class);
    }

    public static final int LINE_FIELD_NUMBER = 1;
    private int line_ = 0;
    /**
     *
     *
     * <pre>
     * The line, starting with 1, where the byte is positioned.
     * </pre>
     *
     * <code>int32 line = 1;</code>
     *
     * @return The line.
     */
    @java.lang.Override
    public int getLine() {
      return line_;
    }

    public static final int COLUMN_FIELD_NUMBER = 2;
    private int column_ = 0;
    /**
     *
     *
     * <pre>
     * The column within the line, starting with 1, where the byte is
     * positioned. This is a byte index even though the text is UTF-8.
     * </pre>
     *
     * <code>int32 column = 2;</code>
     *
     * @return The column.
     */
    @java.lang.Override
    public int getColumn() {
      return column_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (line_ != 0) {
        output.writeInt32(1, line_);
      }
      if (column_ != 0) {
        output.writeInt32(2, column_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (line_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, line_);
      }
      if (column_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, column_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.TextLocator.Position)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.TextLocator.Position other =
          (com.google.monitoring.v3.TextLocator.Position) obj;

      if (getLine() != other.getLine()) return false;
      if (getColumn() != other.getColumn()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LINE_FIELD_NUMBER;
      hash = (53 * hash) + getLine();
      hash = (37 * hash) + COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getColumn();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TextLocator.Position parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.TextLocator.Position prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The position of a byte within the text.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.TextLocator.Position}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TextLocator.Position)
        com.google.monitoring.v3.TextLocator.PositionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TextLocator_Position_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TextLocator_Position_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.TextLocator.Position.class,
                com.google.monitoring.v3.TextLocator.Position.Builder.class);
      }

      // Construct using com.google.monitoring.v3.TextLocator.Position.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        line_ = 0;
        column_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TextLocator_Position_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.TextLocator.Position getDefaultInstanceForType() {
        return com.google.monitoring.v3.TextLocator.Position.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.TextLocator.Position build() {
        com.google.monitoring.v3.TextLocator.Position result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.TextLocator.Position buildPartial() {
        com.google.monitoring.v3.TextLocator.Position result =
            new com.google.monitoring.v3.TextLocator.Position(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.TextLocator.Position result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.line_ = line_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.column_ = column_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.TextLocator.Position) {
          return mergeFrom((com.google.monitoring.v3.TextLocator.Position) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.TextLocator.Position other) {
        if (other == com.google.monitoring.v3.TextLocator.Position.getDefaultInstance())
          return this;
        if (other.getLine() != 0) {
          setLine(other.getLine());
        }
        if (other.getColumn() != 0) {
          setColumn(other.getColumn());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  line_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  column_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int line_;
      /**
       *
       *
       * <pre>
       * The line, starting with 1, where the byte is positioned.
       * </pre>
       *
       * <code>int32 line = 1;</code>
       *
       * @return The line.
       */
      @java.lang.Override
      public int getLine() {
        return line_;
      }
      /**
       *
       *
       * <pre>
       * The line, starting with 1, where the byte is positioned.
       * </pre>
       *
       * <code>int32 line = 1;</code>
       *
       * @param value The line to set.
       * @return This builder for chaining.
       */
      public Builder setLine(int value) {

        line_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The line, starting with 1, where the byte is positioned.
       * </pre>
       *
       * <code>int32 line = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLine() {
        bitField0_ = (bitField0_ & ~0x00000001);
        line_ = 0;
        onChanged();
        return this;
      }

      private int column_;
      /**
       *
       *
       * <pre>
       * The column within the line, starting with 1, where the byte is
       * positioned. This is a byte index even though the text is UTF-8.
       * </pre>
       *
       * <code>int32 column = 2;</code>
       *
       * @return The column.
       */
      @java.lang.Override
      public int getColumn() {
        return column_;
      }
      /**
       *
       *
       * <pre>
       * The column within the line, starting with 1, where the byte is
       * positioned. This is a byte index even though the text is UTF-8.
       * </pre>
       *
       * <code>int32 column = 2;</code>
       *
       * @param value The column to set.
       * @return This builder for chaining.
       */
      public Builder setColumn(int value) {

        column_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The column within the line, starting with 1, where the byte is
       * positioned. This is a byte index even though the text is UTF-8.
       * </pre>
       *
       * <code>int32 column = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearColumn() {
        bitField0_ = (bitField0_ & ~0x00000002);
        column_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TextLocator.Position)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.TextLocator.Position)
    private static final com.google.monitoring.v3.TextLocator.Position DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.TextLocator.Position();
    }

    public static com.google.monitoring.v3.TextLocator.Position getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Position> PARSER =
        new com.google.protobuf.AbstractParser<Position>() {
          @java.lang.Override
          public Position parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Position> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Position> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TextLocator.Position getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SOURCE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";
  /**
   *
   *
   * <pre>
   * The source of the text. The source may be a field in the request, in which
   * case its format is the format of the
   * google.rpc.BadRequest.FieldViolation.field field in
   * https://cloud.google.com/apis/design/errors#error_details. It may also be
   * be a source other than the request field (e.g. a macro definition
   * referenced in the text of the query), in which case this is the name of
   * the source (e.g. the macro name).
   * </pre>
   *
   * <code>string source = 1;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The source of the text. The source may be a field in the request, in which
   * case its format is the format of the
   * google.rpc.BadRequest.FieldViolation.field field in
   * https://cloud.google.com/apis/design/errors#error_details. It may also be
   * be a source other than the request field (e.g. a macro definition
   * referenced in the text of the query), in which case this is the name of
   * the source (e.g. the macro name).
   * </pre>
   *
   * <code>string source = 1;</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_POSITION_FIELD_NUMBER = 2;
  private com.google.monitoring.v3.TextLocator.Position startPosition_;
  /**
   *
   *
   * <pre>
   * The position of the first byte within the text.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
   *
   * @return Whether the startPosition field is set.
   */
  @java.lang.Override
  public boolean hasStartPosition() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The position of the first byte within the text.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
   *
   * @return The startPosition.
   */
  @java.lang.Override
  public com.google.monitoring.v3.TextLocator.Position getStartPosition() {
    return startPosition_ == null
        ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
        : startPosition_;
  }
  /**
   *
   *
   * <pre>
   * The position of the first byte within the text.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TextLocator.PositionOrBuilder getStartPositionOrBuilder() {
    return startPosition_ == null
        ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
        : startPosition_;
  }

  public static final int END_POSITION_FIELD_NUMBER = 3;
  private com.google.monitoring.v3.TextLocator.Position endPosition_;
  /**
   *
   *
   * <pre>
   * The position of the last byte within the text.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
   *
   * @return Whether the endPosition field is set.
   */
  @java.lang.Override
  public boolean hasEndPosition() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The position of the last byte within the text.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
   *
   * @return The endPosition.
   */
  @java.lang.Override
  public com.google.monitoring.v3.TextLocator.Position getEndPosition() {
    return endPosition_ == null
        ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
        : endPosition_;
  }
  /**
   *
   *
   * <pre>
   * The position of the last byte within the text.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TextLocator.PositionOrBuilder getEndPositionOrBuilder() {
    return endPosition_ == null
        ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
        : endPosition_;
  }

  public static final int NESTED_LOCATOR_FIELD_NUMBER = 4;
  private com.google.monitoring.v3.TextLocator nestedLocator_;
  /**
   *
   *
   * <pre>
   * If `source`, `start_position`, and `end_position` describe a call on
   * some object (e.g. a macro in the time series query language text) and a
   * location is to be designated in that object's text, `nested_locator`
   * identifies the location within that object.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
   *
   * @return Whether the nestedLocator field is set.
   */
  @java.lang.Override
  public boolean hasNestedLocator() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * If `source`, `start_position`, and `end_position` describe a call on
   * some object (e.g. a macro in the time series query language text) and a
   * location is to be designated in that object's text, `nested_locator`
   * identifies the location within that object.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
   *
   * @return The nestedLocator.
   */
  @java.lang.Override
  public com.google.monitoring.v3.TextLocator getNestedLocator() {
    return nestedLocator_ == null
        ? com.google.monitoring.v3.TextLocator.getDefaultInstance()
        : nestedLocator_;
  }
  /**
   *
   *
   * <pre>
   * If `source`, `start_position`, and `end_position` describe a call on
   * some object (e.g. a macro in the time series query language text) and a
   * location is to be designated in that object's text, `nested_locator`
   * identifies the location within that object.
   * </pre>
   *
   * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TextLocatorOrBuilder getNestedLocatorOrBuilder() {
    return nestedLocator_ == null
        ? com.google.monitoring.v3.TextLocator.getDefaultInstance()
        : nestedLocator_;
  }

  public static final int NESTING_REASON_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nestingReason_ = "";
  /**
   *
   *
   * <pre>
   * When `nested_locator` is set, this field gives the reason for the nesting.
   * Usually, the reason is a macro invocation. In that case, the macro name
   * (including the leading '&#64;') signals the location of the macro call
   * in the text and a macro argument name (including the leading '$') signals
   * the location of the macro argument inside the macro body that got
   * substituted away.
   * </pre>
   *
   * <code>string nesting_reason = 5;</code>
   *
   * @return The nestingReason.
   */
  @java.lang.Override
  public java.lang.String getNestingReason() {
    java.lang.Object ref = nestingReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nestingReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * When `nested_locator` is set, this field gives the reason for the nesting.
   * Usually, the reason is a macro invocation. In that case, the macro name
   * (including the leading '&#64;') signals the location of the macro call
   * in the text and a macro argument name (including the leading '$') signals
   * the location of the macro argument inside the macro body that got
   * substituted away.
   * </pre>
   *
   * <code>string nesting_reason = 5;</code>
   *
   * @return The bytes for nestingReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNestingReasonBytes() {
    java.lang.Object ref = nestingReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nestingReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStartPosition());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getEndPosition());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getNestedLocator());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nestingReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, nestingReason_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartPosition());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndPosition());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNestedLocator());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nestingReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, nestingReason_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.TextLocator)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.TextLocator other = (com.google.monitoring.v3.TextLocator) obj;

    if (!getSource().equals(other.getSource())) return false;
    if (hasStartPosition() != other.hasStartPosition()) return false;
    if (hasStartPosition()) {
      if (!getStartPosition().equals(other.getStartPosition())) return false;
    }
    if (hasEndPosition() != other.hasEndPosition()) return false;
    if (hasEndPosition()) {
      if (!getEndPosition().equals(other.getEndPosition())) return false;
    }
    if (hasNestedLocator() != other.hasNestedLocator()) return false;
    if (hasNestedLocator()) {
      if (!getNestedLocator().equals(other.getNestedLocator())) return false;
    }
    if (!getNestingReason().equals(other.getNestingReason())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getSource().hashCode();
    if (hasStartPosition()) {
      hash = (37 * hash) + START_POSITION_FIELD_NUMBER;
      hash = (53 * hash) + getStartPosition().hashCode();
    }
    if (hasEndPosition()) {
      hash = (37 * hash) + END_POSITION_FIELD_NUMBER;
      hash = (53 * hash) + getEndPosition().hashCode();
    }
    if (hasNestedLocator()) {
      hash = (37 * hash) + NESTED_LOCATOR_FIELD_NUMBER;
      hash = (53 * hash) + getNestedLocator().hashCode();
    }
    hash = (37 * hash) + NESTING_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getNestingReason().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TextLocator parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TextLocator parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TextLocator parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.TextLocator prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A locator for text. Indicates a particular part of the text of a request or
   * of an object referenced in the request.
   *
   * For example, suppose the request field `text` contains:
   *
   *   text: "The quick brown fox jumps over the lazy dog."
   *
   * Then the locator:
   *
   *   source: "text"
   *   start_position {
   *     line: 1
   *     column: 17
   *   }
   *   end_position {
   *     line: 1
   *     column: 19
   *   }
   *
   * refers to the part of the text: "fox".
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TextLocator}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TextLocator)
      com.google.monitoring.v3.TextLocatorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TextLocator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TextLocator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TextLocator.class,
              com.google.monitoring.v3.TextLocator.Builder.class);
    }

    // Construct using com.google.monitoring.v3.TextLocator.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartPositionFieldBuilder();
        getEndPositionFieldBuilder();
        getNestedLocatorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      source_ = "";
      startPosition_ = null;
      if (startPositionBuilder_ != null) {
        startPositionBuilder_.dispose();
        startPositionBuilder_ = null;
      }
      endPosition_ = null;
      if (endPositionBuilder_ != null) {
        endPositionBuilder_.dispose();
        endPositionBuilder_ = null;
      }
      nestedLocator_ = null;
      if (nestedLocatorBuilder_ != null) {
        nestedLocatorBuilder_.dispose();
        nestedLocatorBuilder_ = null;
      }
      nestingReason_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TextLocator_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TextLocator getDefaultInstanceForType() {
      return com.google.monitoring.v3.TextLocator.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.TextLocator build() {
      com.google.monitoring.v3.TextLocator result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TextLocator buildPartial() {
      com.google.monitoring.v3.TextLocator result = new com.google.monitoring.v3.TextLocator(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.TextLocator result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.source_ = source_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startPosition_ =
            startPositionBuilder_ == null ? startPosition_ : startPositionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endPosition_ =
            endPositionBuilder_ == null ? endPosition_ : endPositionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nestedLocator_ =
            nestedLocatorBuilder_ == null ? nestedLocator_ : nestedLocatorBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nestingReason_ = nestingReason_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.TextLocator) {
        return mergeFrom((com.google.monitoring.v3.TextLocator) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.TextLocator other) {
      if (other == com.google.monitoring.v3.TextLocator.getDefaultInstance()) return this;
      if (!other.getSource().isEmpty()) {
        source_ = other.source_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStartPosition()) {
        mergeStartPosition(other.getStartPosition());
      }
      if (other.hasEndPosition()) {
        mergeEndPosition(other.getEndPosition());
      }
      if (other.hasNestedLocator()) {
        mergeNestedLocator(other.getNestedLocator());
      }
      if (!other.getNestingReason().isEmpty()) {
        nestingReason_ = other.nestingReason_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStartPositionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEndPositionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNestedLocatorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                nestingReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * The source of the text. The source may be a field in the request, in which
     * case its format is the format of the
     * google.rpc.BadRequest.FieldViolation.field field in
     * https://cloud.google.com/apis/design/errors#error_details. It may also be
     * be a source other than the request field (e.g. a macro definition
     * referenced in the text of the query), in which case this is the name of
     * the source (e.g. the macro name).
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source of the text. The source may be a field in the request, in which
     * case its format is the format of the
     * google.rpc.BadRequest.FieldViolation.field field in
     * https://cloud.google.com/apis/design/errors#error_details. It may also be
     * be a source other than the request field (e.g. a macro definition
     * referenced in the text of the query), in which case this is the name of
     * the source (e.g. the macro name).
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source of the text. The source may be a field in the request, in which
     * case its format is the format of the
     * google.rpc.BadRequest.FieldViolation.field field in
     * https://cloud.google.com/apis/design/errors#error_details. It may also be
     * be a source other than the request field (e.g. a macro definition
     * referenced in the text of the query), in which case this is the name of
     * the source (e.g. the macro name).
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of the text. The source may be a field in the request, in which
     * case its format is the format of the
     * google.rpc.BadRequest.FieldViolation.field field in
     * https://cloud.google.com/apis/design/errors#error_details. It may also be
     * be a source other than the request field (e.g. a macro definition
     * referenced in the text of the query), in which case this is the name of
     * the source (e.g. the macro name).
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of the text. The source may be a field in the request, in which
     * case its format is the format of the
     * google.rpc.BadRequest.FieldViolation.field field in
     * https://cloud.google.com/apis/design/errors#error_details. It may also be
     * be a source other than the request field (e.g. a macro definition
     * referenced in the text of the query), in which case this is the name of
     * the source (e.g. the macro name).
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.monitoring.v3.TextLocator.Position startPosition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TextLocator.Position,
            com.google.monitoring.v3.TextLocator.Position.Builder,
            com.google.monitoring.v3.TextLocator.PositionOrBuilder>
        startPositionBuilder_;
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     *
     * @return Whether the startPosition field is set.
     */
    public boolean hasStartPosition() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     *
     * @return The startPosition.
     */
    public com.google.monitoring.v3.TextLocator.Position getStartPosition() {
      if (startPositionBuilder_ == null) {
        return startPosition_ == null
            ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
            : startPosition_;
      } else {
        return startPositionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    public Builder setStartPosition(com.google.monitoring.v3.TextLocator.Position value) {
      if (startPositionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startPosition_ = value;
      } else {
        startPositionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    public Builder setStartPosition(
        com.google.monitoring.v3.TextLocator.Position.Builder builderForValue) {
      if (startPositionBuilder_ == null) {
        startPosition_ = builderForValue.build();
      } else {
        startPositionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    public Builder mergeStartPosition(com.google.monitoring.v3.TextLocator.Position value) {
      if (startPositionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startPosition_ != null
            && startPosition_
                != com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()) {
          getStartPositionBuilder().mergeFrom(value);
        } else {
          startPosition_ = value;
        }
      } else {
        startPositionBuilder_.mergeFrom(value);
      }
      if (startPosition_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    public Builder clearStartPosition() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startPosition_ = null;
      if (startPositionBuilder_ != null) {
        startPositionBuilder_.dispose();
        startPositionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    public com.google.monitoring.v3.TextLocator.Position.Builder getStartPositionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartPositionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    public com.google.monitoring.v3.TextLocator.PositionOrBuilder getStartPositionOrBuilder() {
      if (startPositionBuilder_ != null) {
        return startPositionBuilder_.getMessageOrBuilder();
      } else {
        return startPosition_ == null
            ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
            : startPosition_;
      }
    }
    /**
     *
     *
     * <pre>
     * The position of the first byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position start_position = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TextLocator.Position,
            com.google.monitoring.v3.TextLocator.Position.Builder,
            com.google.monitoring.v3.TextLocator.PositionOrBuilder>
        getStartPositionFieldBuilder() {
      if (startPositionBuilder_ == null) {
        startPositionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.TextLocator.Position,
                com.google.monitoring.v3.TextLocator.Position.Builder,
                com.google.monitoring.v3.TextLocator.PositionOrBuilder>(
                getStartPosition(), getParentForChildren(), isClean());
        startPosition_ = null;
      }
      return startPositionBuilder_;
    }

    private com.google.monitoring.v3.TextLocator.Position endPosition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TextLocator.Position,
            com.google.monitoring.v3.TextLocator.Position.Builder,
            com.google.monitoring.v3.TextLocator.PositionOrBuilder>
        endPositionBuilder_;
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     *
     * @return Whether the endPosition field is set.
     */
    public boolean hasEndPosition() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     *
     * @return The endPosition.
     */
    public com.google.monitoring.v3.TextLocator.Position getEndPosition() {
      if (endPositionBuilder_ == null) {
        return endPosition_ == null
            ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
            : endPosition_;
      } else {
        return endPositionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    public Builder setEndPosition(com.google.monitoring.v3.TextLocator.Position value) {
      if (endPositionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endPosition_ = value;
      } else {
        endPositionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    public Builder setEndPosition(
        com.google.monitoring.v3.TextLocator.Position.Builder builderForValue) {
      if (endPositionBuilder_ == null) {
        endPosition_ = builderForValue.build();
      } else {
        endPositionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    public Builder mergeEndPosition(com.google.monitoring.v3.TextLocator.Position value) {
      if (endPositionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && endPosition_ != null
            && endPosition_ != com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()) {
          getEndPositionBuilder().mergeFrom(value);
        } else {
          endPosition_ = value;
        }
      } else {
        endPositionBuilder_.mergeFrom(value);
      }
      if (endPosition_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    public Builder clearEndPosition() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endPosition_ = null;
      if (endPositionBuilder_ != null) {
        endPositionBuilder_.dispose();
        endPositionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    public com.google.monitoring.v3.TextLocator.Position.Builder getEndPositionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEndPositionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    public com.google.monitoring.v3.TextLocator.PositionOrBuilder getEndPositionOrBuilder() {
      if (endPositionBuilder_ != null) {
        return endPositionBuilder_.getMessageOrBuilder();
      } else {
        return endPosition_ == null
            ? com.google.monitoring.v3.TextLocator.Position.getDefaultInstance()
            : endPosition_;
      }
    }
    /**
     *
     *
     * <pre>
     * The position of the last byte within the text.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator.Position end_position = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TextLocator.Position,
            com.google.monitoring.v3.TextLocator.Position.Builder,
            com.google.monitoring.v3.TextLocator.PositionOrBuilder>
        getEndPositionFieldBuilder() {
      if (endPositionBuilder_ == null) {
        endPositionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.TextLocator.Position,
                com.google.monitoring.v3.TextLocator.Position.Builder,
                com.google.monitoring.v3.TextLocator.PositionOrBuilder>(
                getEndPosition(), getParentForChildren(), isClean());
        endPosition_ = null;
      }
      return endPositionBuilder_;
    }

    private com.google.monitoring.v3.TextLocator nestedLocator_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TextLocator,
            com.google.monitoring.v3.TextLocator.Builder,
            com.google.monitoring.v3.TextLocatorOrBuilder>
        nestedLocatorBuilder_;
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     *
     * @return Whether the nestedLocator field is set.
     */
    public boolean hasNestedLocator() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     *
     * @return The nestedLocator.
     */
    public com.google.monitoring.v3.TextLocator getNestedLocator() {
      if (nestedLocatorBuilder_ == null) {
        return nestedLocator_ == null
            ? com.google.monitoring.v3.TextLocator.getDefaultInstance()
            : nestedLocator_;
      } else {
        return nestedLocatorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    public Builder setNestedLocator(com.google.monitoring.v3.TextLocator value) {
      if (nestedLocatorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nestedLocator_ = value;
      } else {
        nestedLocatorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    public Builder setNestedLocator(com.google.monitoring.v3.TextLocator.Builder builderForValue) {
      if (nestedLocatorBuilder_ == null) {
        nestedLocator_ = builderForValue.build();
      } else {
        nestedLocatorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    public Builder mergeNestedLocator(com.google.monitoring.v3.TextLocator value) {
      if (nestedLocatorBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && nestedLocator_ != null
            && nestedLocator_ != com.google.monitoring.v3.TextLocator.getDefaultInstance()) {
          getNestedLocatorBuilder().mergeFrom(value);
        } else {
          nestedLocator_ = value;
        }
      } else {
        nestedLocatorBuilder_.mergeFrom(value);
      }
      if (nestedLocator_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    public Builder clearNestedLocator() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nestedLocator_ = null;
      if (nestedLocatorBuilder_ != null) {
        nestedLocatorBuilder_.dispose();
        nestedLocatorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    public com.google.monitoring.v3.TextLocator.Builder getNestedLocatorBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNestedLocatorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    public com.google.monitoring.v3.TextLocatorOrBuilder getNestedLocatorOrBuilder() {
      if (nestedLocatorBuilder_ != null) {
        return nestedLocatorBuilder_.getMessageOrBuilder();
      } else {
        return nestedLocator_ == null
            ? com.google.monitoring.v3.TextLocator.getDefaultInstance()
            : nestedLocator_;
      }
    }
    /**
     *
     *
     * <pre>
     * If `source`, `start_position`, and `end_position` describe a call on
     * some object (e.g. a macro in the time series query language text) and a
     * location is to be designated in that object's text, `nested_locator`
     * identifies the location within that object.
     * </pre>
     *
     * <code>.google.monitoring.v3.TextLocator nested_locator = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TextLocator,
            com.google.monitoring.v3.TextLocator.Builder,
            com.google.monitoring.v3.TextLocatorOrBuilder>
        getNestedLocatorFieldBuilder() {
      if (nestedLocatorBuilder_ == null) {
        nestedLocatorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.TextLocator,
                com.google.monitoring.v3.TextLocator.Builder,
                com.google.monitoring.v3.TextLocatorOrBuilder>(
                getNestedLocator(), getParentForChildren(), isClean());
        nestedLocator_ = null;
      }
      return nestedLocatorBuilder_;
    }

    private java.lang.Object nestingReason_ = "";
    /**
     *
     *
     * <pre>
     * When `nested_locator` is set, this field gives the reason for the nesting.
     * Usually, the reason is a macro invocation. In that case, the macro name
     * (including the leading '&#64;') signals the location of the macro call
     * in the text and a macro argument name (including the leading '$') signals
     * the location of the macro argument inside the macro body that got
     * substituted away.
     * </pre>
     *
     * <code>string nesting_reason = 5;</code>
     *
     * @return The nestingReason.
     */
    public java.lang.String getNestingReason() {
      java.lang.Object ref = nestingReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nestingReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * When `nested_locator` is set, this field gives the reason for the nesting.
     * Usually, the reason is a macro invocation. In that case, the macro name
     * (including the leading '&#64;') signals the location of the macro call
     * in the text and a macro argument name (including the leading '$') signals
     * the location of the macro argument inside the macro body that got
     * substituted away.
     * </pre>
     *
     * <code>string nesting_reason = 5;</code>
     *
     * @return The bytes for nestingReason.
     */
    public com.google.protobuf.ByteString getNestingReasonBytes() {
      java.lang.Object ref = nestingReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nestingReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * When `nested_locator` is set, this field gives the reason for the nesting.
     * Usually, the reason is a macro invocation. In that case, the macro name
     * (including the leading '&#64;') signals the location of the macro call
     * in the text and a macro argument name (including the leading '$') signals
     * the location of the macro argument inside the macro body that got
     * substituted away.
     * </pre>
     *
     * <code>string nesting_reason = 5;</code>
     *
     * @param value The nestingReason to set.
     * @return This builder for chaining.
     */
    public Builder setNestingReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nestingReason_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When `nested_locator` is set, this field gives the reason for the nesting.
     * Usually, the reason is a macro invocation. In that case, the macro name
     * (including the leading '&#64;') signals the location of the macro call
     * in the text and a macro argument name (including the leading '$') signals
     * the location of the macro argument inside the macro body that got
     * substituted away.
     * </pre>
     *
     * <code>string nesting_reason = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNestingReason() {
      nestingReason_ = getDefaultInstance().getNestingReason();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When `nested_locator` is set, this field gives the reason for the nesting.
     * Usually, the reason is a macro invocation. In that case, the macro name
     * (including the leading '&#64;') signals the location of the macro call
     * in the text and a macro argument name (including the leading '$') signals
     * the location of the macro argument inside the macro body that got
     * substituted away.
     * </pre>
     *
     * <code>string nesting_reason = 5;</code>
     *
     * @param value The bytes for nestingReason to set.
     * @return This builder for chaining.
     */
    public Builder setNestingReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nestingReason_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TextLocator)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.TextLocator)
  private static final com.google.monitoring.v3.TextLocator DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.TextLocator();
  }

  public static com.google.monitoring.v3.TextLocator getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextLocator> PARSER =
      new com.google.protobuf.AbstractParser<TextLocator>() {
        @java.lang.Override
        public TextLocator parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextLocator> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextLocator> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.TextLocator getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
