/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/alert.proto

// Protobuf Java Version: 3.25.5
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A description of the conditions under which some aspect of your system is
 * considered to be "unhealthy" and the ways to notify people or services about
 * this state. For an overview of alerting policies, see
 * [Introduction to Alerting](https://cloud.google.com/monitoring/alerts/).
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.AlertPolicy}
 */
public final class AlertPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy)
    AlertPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AlertPolicy.newBuilder() to construct.
  private AlertPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AlertPolicy() {
    name_ = "";
    displayName_ = "";
    conditions_ = java.util.Collections.emptyList();
    combiner_ = 0;
    notificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
    severity_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AlertPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.AlertProto
        .internal_static_google_monitoring_v3_AlertPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 16:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.AlertProto
        .internal_static_google_monitoring_v3_AlertPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.AlertPolicy.class,
            com.google.monitoring.v3.AlertPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Operators for combining conditions.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.AlertPolicy.ConditionCombinerType}
   */
  public enum ConditionCombinerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An unspecified combiner.
     * </pre>
     *
     * <code>COMBINE_UNSPECIFIED = 0;</code>
     */
    COMBINE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `AND` operator. An
     * incident is created only if all the conditions are met
     * simultaneously. This combiner is satisfied if all conditions are
     * met, even if they are met on completely different resources.
     * </pre>
     *
     * <code>AND = 1;</code>
     */
    AND(1),
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `OR` operator. An incident
     * is created if any of the listed conditions is met.
     * </pre>
     *
     * <code>OR = 2;</code>
     */
    OR(2),
    /**
     *
     *
     * <pre>
     * Combine conditions using logical `AND` operator, but unlike the regular
     * `AND` option, an incident is created only if all conditions are met
     * simultaneously on at least one resource.
     * </pre>
     *
     * <code>AND_WITH_MATCHING_RESOURCE = 3;</code>
     */
    AND_WITH_MATCHING_RESOURCE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An unspecified combiner.
     * </pre>
     *
     * <code>COMBINE_UNSPECIFIED = 0;</code>
     */
    public static final int COMBINE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `AND` operator. An
     * incident is created only if all the conditions are met
     * simultaneously. This combiner is satisfied if all conditions are
     * met, even if they are met on completely different resources.
     * </pre>
     *
     * <code>AND = 1;</code>
     */
    public static final int AND_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `OR` operator. An incident
     * is created if any of the listed conditions is met.
     * </pre>
     *
     * <code>OR = 2;</code>
     */
    public static final int OR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Combine conditions using logical `AND` operator, but unlike the regular
     * `AND` option, an incident is created only if all conditions are met
     * simultaneously on at least one resource.
     * </pre>
     *
     * <code>AND_WITH_MATCHING_RESOURCE = 3;</code>
     */
    public static final int AND_WITH_MATCHING_RESOURCE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConditionCombinerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConditionCombinerType forNumber(int value) {
      switch (value) {
        case 0:
          return COMBINE_UNSPECIFIED;
        case 1:
          return AND;
        case 2:
          return OR;
        case 3:
          return AND_WITH_MATCHING_RESOURCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConditionCombinerType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConditionCombinerType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConditionCombinerType>() {
              public ConditionCombinerType findValueByNumber(int number) {
                return ConditionCombinerType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.AlertPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConditionCombinerType[] VALUES = values();

    public static ConditionCombinerType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConditionCombinerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.AlertPolicy.ConditionCombinerType)
  }

  /**
   *
   *
   * <pre>
   * An enumeration of possible severity level for an alerting policy.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.AlertPolicy.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No severity is specified. This is the default value.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This is the highest severity level. Use this if the problem could
     * cause significant damage or downtime.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    CRITICAL(1),
    /**
     *
     *
     * <pre>
     * This is the medium severity level. Use this if the problem could
     * cause minor damage or downtime.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    ERROR(2),
    /**
     *
     *
     * <pre>
     * This is the lowest severity level. Use this if the problem is not causing
     * any damage or downtime, but could potentially lead to a problem in the
     * future.
     * </pre>
     *
     * <code>WARNING = 3;</code>
     */
    WARNING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No severity is specified. This is the default value.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This is the highest severity level. Use this if the problem could
     * cause significant damage or downtime.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    public static final int CRITICAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This is the medium severity level. Use this if the problem could
     * cause minor damage or downtime.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    public static final int ERROR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This is the lowest severity level. Use this if the problem is not causing
     * any damage or downtime, but could potentially lead to a problem in the
     * future.
     * </pre>
     *
     * <code>WARNING = 3;</code>
     */
    public static final int WARNING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return CRITICAL;
        case 2:
          return ERROR;
        case 3:
          return WARNING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.AlertPolicy.getDescriptor().getEnumTypes().get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.AlertPolicy.Severity)
  }

  public interface DocumentationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Documentation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    java.lang.String getContent();
    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();

    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    java.lang.String getMimeType();
    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    com.google.protobuf.ByteString getMimeTypeBytes();

    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subject.
     */
    java.lang.String getSubject();
    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subject.
     */
    com.google.protobuf.ByteString getSubjectBytes();

    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.monitoring.v3.AlertPolicy.Documentation.Link> getLinksList();
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Documentation.Link getLinks(int index);
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getLinksCount();
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder>
        getLinksOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder getLinksOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Documentation that is included in the notifications and incidents
   * pertaining to this policy.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.AlertPolicy.Documentation}
   */
  public static final class Documentation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Documentation)
      DocumentationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Documentation.newBuilder() to construct.
    private Documentation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Documentation() {
      content_ = "";
      mimeType_ = "";
      subject_ = "";
      links_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Documentation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Documentation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Documentation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.AlertPolicy.Documentation.class,
              com.google.monitoring.v3.AlertPolicy.Documentation.Builder.class);
    }

    public interface LinkOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Documentation.Link)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A short display name for the link. The display name must not be empty
       * or exceed 63 characters. Example: "playbook".
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      java.lang.String getDisplayName();
      /**
       *
       *
       * <pre>
       * A short display name for the link. The display name must not be empty
       * or exceed 63 characters. Example: "playbook".
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      com.google.protobuf.ByteString getDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * The url of a webpage.
       * A url can be templatized by using variables
       * in the path or the query parameters. The total length of a URL should
       * not exceed 2083 characters before and after variable expansion.
       * Example: "https://my_domain.com/playbook?name=${resource.name}"
       * </pre>
       *
       * <code>string url = 2;</code>
       *
       * @return The url.
       */
      java.lang.String getUrl();
      /**
       *
       *
       * <pre>
       * The url of a webpage.
       * A url can be templatized by using variables
       * in the path or the query parameters. The total length of a URL should
       * not exceed 2083 characters before and after variable expansion.
       * Example: "https://my_domain.com/playbook?name=${resource.name}"
       * </pre>
       *
       * <code>string url = 2;</code>
       *
       * @return The bytes for url.
       */
      com.google.protobuf.ByteString getUrlBytes();
    }
    /**
     *
     *
     * <pre>
     * Links to content such as playbooks, repositories, and other resources.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Documentation.Link}
     */
    public static final class Link extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Documentation.Link)
        LinkOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Link.newBuilder() to construct.
      private Link(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Link() {
        displayName_ = "";
        url_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Link();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_Link_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_Link_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Documentation.Link.class,
                com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder.class);
      }

      public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * A short display name for the link. The display name must not be empty
       * or exceed 63 characters. Example: "playbook".
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      @java.lang.Override
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A short display name for the link. The display name must not be empty
       * or exceed 63 characters. Example: "playbook".
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int URL_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object url_ = "";
      /**
       *
       *
       * <pre>
       * The url of a webpage.
       * A url can be templatized by using variables
       * in the path or the query parameters. The total length of a URL should
       * not exceed 2083 characters before and after variable expansion.
       * Example: "https://my_domain.com/playbook?name=${resource.name}"
       * </pre>
       *
       * <code>string url = 2;</code>
       *
       * @return The url.
       */
      @java.lang.Override
      public java.lang.String getUrl() {
        java.lang.Object ref = url_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          url_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The url of a webpage.
       * A url can be templatized by using variables
       * in the path or the query parameters. The total length of a URL should
       * not exceed 2083 characters before and after variable expansion.
       * Example: "https://my_domain.com/playbook?name=${resource.name}"
       * </pre>
       *
       * <code>string url = 2;</code>
       *
       * @return The bytes for url.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUrlBytes() {
        java.lang.Object ref = url_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          url_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, url_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, url_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Documentation.Link)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Documentation.Link other =
            (com.google.monitoring.v3.AlertPolicy.Documentation.Link) obj;

        if (!getDisplayName().equals(other.getDisplayName())) return false;
        if (!getUrl().equals(other.getUrl())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayName().hashCode();
        hash = (37 * hash) + URL_FIELD_NUMBER;
        hash = (53 * hash) + getUrl().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Documentation.Link prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Links to content such as playbooks, repositories, and other resources.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Documentation.Link}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Documentation.Link)
          com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Documentation_Link_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Documentation_Link_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Documentation.Link.class,
                  com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Documentation.Link.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          displayName_ = "";
          url_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Documentation_Link_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Documentation.Link getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Documentation.Link.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Documentation.Link build() {
          com.google.monitoring.v3.AlertPolicy.Documentation.Link result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Documentation.Link buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Documentation.Link result =
              new com.google.monitoring.v3.AlertPolicy.Documentation.Link(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Documentation.Link result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.displayName_ = displayName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.url_ = url_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Documentation.Link) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Documentation.Link) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Documentation.Link other) {
          if (other == com.google.monitoring.v3.AlertPolicy.Documentation.Link.getDefaultInstance())
            return this;
          if (!other.getDisplayName().isEmpty()) {
            displayName_ = other.displayName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getUrl().isEmpty()) {
            url_ = other.url_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    displayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    url_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * A short display name for the link. The display name must not be empty
         * or exceed 63 characters. Example: "playbook".
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return The displayName.
         */
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A short display name for the link. The display name must not be empty
         * or exceed 63 characters. Example: "playbook".
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return The bytes for displayName.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A short display name for the link. The display name must not be empty
         * or exceed 63 characters. Example: "playbook".
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A short display name for the link. The display name must not be empty
         * or exceed 63 characters. Example: "playbook".
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {
          displayName_ = getDefaultInstance().getDisplayName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A short display name for the link. The display name must not be empty
         * or exceed 63 characters. Example: "playbook".
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @param value The bytes for displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object url_ = "";
        /**
         *
         *
         * <pre>
         * The url of a webpage.
         * A url can be templatized by using variables
         * in the path or the query parameters. The total length of a URL should
         * not exceed 2083 characters before and after variable expansion.
         * Example: "https://my_domain.com/playbook?name=${resource.name}"
         * </pre>
         *
         * <code>string url = 2;</code>
         *
         * @return The url.
         */
        public java.lang.String getUrl() {
          java.lang.Object ref = url_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            url_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The url of a webpage.
         * A url can be templatized by using variables
         * in the path or the query parameters. The total length of a URL should
         * not exceed 2083 characters before and after variable expansion.
         * Example: "https://my_domain.com/playbook?name=${resource.name}"
         * </pre>
         *
         * <code>string url = 2;</code>
         *
         * @return The bytes for url.
         */
        public com.google.protobuf.ByteString getUrlBytes() {
          java.lang.Object ref = url_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            url_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The url of a webpage.
         * A url can be templatized by using variables
         * in the path or the query parameters. The total length of a URL should
         * not exceed 2083 characters before and after variable expansion.
         * Example: "https://my_domain.com/playbook?name=${resource.name}"
         * </pre>
         *
         * <code>string url = 2;</code>
         *
         * @param value The url to set.
         * @return This builder for chaining.
         */
        public Builder setUrl(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          url_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The url of a webpage.
         * A url can be templatized by using variables
         * in the path or the query parameters. The total length of a URL should
         * not exceed 2083 characters before and after variable expansion.
         * Example: "https://my_domain.com/playbook?name=${resource.name}"
         * </pre>
         *
         * <code>string url = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUrl() {
          url_ = getDefaultInstance().getUrl();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The url of a webpage.
         * A url can be templatized by using variables
         * in the path or the query parameters. The total length of a URL should
         * not exceed 2083 characters before and after variable expansion.
         * Example: "https://my_domain.com/playbook?name=${resource.name}"
         * </pre>
         *
         * <code>string url = 2;</code>
         *
         * @param value The bytes for url to set.
         * @return This builder for chaining.
         */
        public Builder setUrlBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          url_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Documentation.Link)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Documentation.Link)
      private static final com.google.monitoring.v3.AlertPolicy.Documentation.Link DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Documentation.Link();
      }

      public static com.google.monitoring.v3.AlertPolicy.Documentation.Link getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Link> PARSER =
          new com.google.protobuf.AbstractParser<Link>() {
            @java.lang.Override
            public Link parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Link> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Link> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation.Link getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CONTENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIME_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mimeType_ = "";
    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    @java.lang.Override
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBJECT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subject_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subject.
     */
    @java.lang.Override
    public java.lang.String getSubject() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subject_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subject.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubjectBytes() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LINKS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.monitoring.v3.AlertPolicy.Documentation.Link> links_;
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.monitoring.v3.AlertPolicy.Documentation.Link> getLinksList() {
      return links_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder>
        getLinksOrBuilderList() {
      return links_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getLinksCount() {
      return links_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Documentation.Link getLinks(int index) {
      return links_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Links to content such as playbooks, repositories, and other
     * resources. This field can contain up to 3 entries.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder getLinksOrBuilder(
        int index) {
      return links_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, mimeType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, subject_);
      }
      for (int i = 0; i < links_.size(); i++) {
        output.writeMessage(4, links_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, mimeType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, subject_);
      }
      for (int i = 0; i < links_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, links_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Documentation)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.AlertPolicy.Documentation other =
          (com.google.monitoring.v3.AlertPolicy.Documentation) obj;

      if (!getContent().equals(other.getContent())) return false;
      if (!getMimeType().equals(other.getMimeType())) return false;
      if (!getSubject().equals(other.getSubject())) return false;
      if (!getLinksList().equals(other.getLinksList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMimeType().hashCode();
      hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getSubject().hashCode();
      if (getLinksCount() > 0) {
        hash = (37 * hash) + LINKS_FIELD_NUMBER;
        hash = (53 * hash) + getLinksList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.AlertPolicy.Documentation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included in the notifications and incidents
     * pertaining to this policy.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Documentation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Documentation)
        com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Documentation.class,
                com.google.monitoring.v3.AlertPolicy.Documentation.Builder.class);
      }

      // Construct using com.google.monitoring.v3.AlertPolicy.Documentation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        content_ = "";
        mimeType_ = "";
        subject_ = "";
        if (linksBuilder_ == null) {
          links_ = java.util.Collections.emptyList();
        } else {
          links_ = null;
          linksBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation getDefaultInstanceForType() {
        return com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation build() {
        com.google.monitoring.v3.AlertPolicy.Documentation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation buildPartial() {
        com.google.monitoring.v3.AlertPolicy.Documentation result =
            new com.google.monitoring.v3.AlertPolicy.Documentation(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.monitoring.v3.AlertPolicy.Documentation result) {
        if (linksBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            links_ = java.util.Collections.unmodifiableList(links_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.links_ = links_;
        } else {
          result.links_ = linksBuilder_.build();
        }
      }

      private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Documentation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.content_ = content_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mimeType_ = mimeType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.subject_ = subject_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.AlertPolicy.Documentation) {
          return mergeFrom((com.google.monitoring.v3.AlertPolicy.Documentation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Documentation other) {
        if (other == com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance())
          return this;
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getMimeType().isEmpty()) {
          mimeType_ = other.mimeType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getSubject().isEmpty()) {
          subject_ = other.subject_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (linksBuilder_ == null) {
          if (!other.links_.isEmpty()) {
            if (links_.isEmpty()) {
              links_ = other.links_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureLinksIsMutable();
              links_.addAll(other.links_);
            }
            onChanged();
          }
        } else {
          if (!other.links_.isEmpty()) {
            if (linksBuilder_.isEmpty()) {
              linksBuilder_.dispose();
              linksBuilder_ = null;
              links_ = other.links_;
              bitField0_ = (bitField0_ & ~0x00000008);
              linksBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getLinksFieldBuilder()
                      : null;
            } else {
              linksBuilder_.addAllMessages(other.links_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  content_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  mimeType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  subject_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.monitoring.v3.AlertPolicy.Documentation.Link m =
                      input.readMessage(
                          com.google.monitoring.v3.AlertPolicy.Documentation.Link.parser(),
                          extensionRegistry);
                  if (linksBuilder_ == null) {
                    ensureLinksIsMutable();
                    links_.add(m);
                  } else {
                    linksBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object content_ = "";
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        content_ = getDefaultInstance().getContent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The mimeType.
       */
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The bytes for mimeType.
       */
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mimeType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMimeType() {
        mimeType_ = getDefaultInstance().getMimeType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The bytes for mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mimeType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object subject_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subject.
       */
      public java.lang.String getSubject() {
        java.lang.Object ref = subject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subject.
       */
      public com.google.protobuf.ByteString getSubjectBytes() {
        java.lang.Object ref = subject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The subject to set.
       * @return This builder for chaining.
       */
      public Builder setSubject(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subject_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubject() {
        subject_ = getDefaultInstance().getSubject();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for subject to set.
       * @return This builder for chaining.
       */
      public Builder setSubjectBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subject_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.util.List<com.google.monitoring.v3.AlertPolicy.Documentation.Link> links_ =
          java.util.Collections.emptyList();

      private void ensureLinksIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          links_ =
              new java.util.ArrayList<com.google.monitoring.v3.AlertPolicy.Documentation.Link>(
                  links_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Documentation.Link,
              com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder,
              com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder>
          linksBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.monitoring.v3.AlertPolicy.Documentation.Link>
          getLinksList() {
        if (linksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(links_);
        } else {
          return linksBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getLinksCount() {
        if (linksBuilder_ == null) {
          return links_.size();
        } else {
          return linksBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Documentation.Link getLinks(int index) {
        if (linksBuilder_ == null) {
          return links_.get(index);
        } else {
          return linksBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setLinks(
          int index, com.google.monitoring.v3.AlertPolicy.Documentation.Link value) {
        if (linksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLinksIsMutable();
          links_.set(index, value);
          onChanged();
        } else {
          linksBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setLinks(
          int index,
          com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder builderForValue) {
        if (linksBuilder_ == null) {
          ensureLinksIsMutable();
          links_.set(index, builderForValue.build());
          onChanged();
        } else {
          linksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addLinks(com.google.monitoring.v3.AlertPolicy.Documentation.Link value) {
        if (linksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLinksIsMutable();
          links_.add(value);
          onChanged();
        } else {
          linksBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addLinks(
          int index, com.google.monitoring.v3.AlertPolicy.Documentation.Link value) {
        if (linksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLinksIsMutable();
          links_.add(index, value);
          onChanged();
        } else {
          linksBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addLinks(
          com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder builderForValue) {
        if (linksBuilder_ == null) {
          ensureLinksIsMutable();
          links_.add(builderForValue.build());
          onChanged();
        } else {
          linksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addLinks(
          int index,
          com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder builderForValue) {
        if (linksBuilder_ == null) {
          ensureLinksIsMutable();
          links_.add(index, builderForValue.build());
          onChanged();
        } else {
          linksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllLinks(
          java.lang.Iterable<? extends com.google.monitoring.v3.AlertPolicy.Documentation.Link>
              values) {
        if (linksBuilder_ == null) {
          ensureLinksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, links_);
          onChanged();
        } else {
          linksBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearLinks() {
        if (linksBuilder_ == null) {
          links_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          linksBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeLinks(int index) {
        if (linksBuilder_ == null) {
          ensureLinksIsMutable();
          links_.remove(index);
          onChanged();
        } else {
          linksBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder getLinksBuilder(
          int index) {
        return getLinksFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder getLinksOrBuilder(
          int index) {
        if (linksBuilder_ == null) {
          return links_.get(index);
        } else {
          return linksBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder>
          getLinksOrBuilderList() {
        if (linksBuilder_ != null) {
          return linksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(links_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder addLinksBuilder() {
        return getLinksFieldBuilder()
            .addBuilder(
                com.google.monitoring.v3.AlertPolicy.Documentation.Link.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder addLinksBuilder(
          int index) {
        return getLinksFieldBuilder()
            .addBuilder(
                index,
                com.google.monitoring.v3.AlertPolicy.Documentation.Link.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Links to content such as playbooks, repositories, and other
       * resources. This field can contain up to 3 entries.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.Documentation.Link links = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder>
          getLinksBuilderList() {
        return getLinksFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Documentation.Link,
              com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder,
              com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder>
          getLinksFieldBuilder() {
        if (linksBuilder_ == null) {
          linksBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.Documentation.Link,
                  com.google.monitoring.v3.AlertPolicy.Documentation.Link.Builder,
                  com.google.monitoring.v3.AlertPolicy.Documentation.LinkOrBuilder>(
                  links_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
          links_ = null;
        }
        return linksBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Documentation)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Documentation)
    private static final com.google.monitoring.v3.AlertPolicy.Documentation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Documentation();
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Documentation> PARSER =
        new com.google.protobuf.AbstractParser<Documentation>() {
          @java.lang.Override
          public Documentation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Documentation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Documentation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Documentation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return Whether the conditionThreshold field is set.
     */
    boolean hasConditionThreshold();
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return The conditionThreshold.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold getConditionThreshold();
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder
        getConditionThresholdOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return Whether the conditionAbsent field is set.
     */
    boolean hasConditionAbsent();
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return The conditionAbsent.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence getConditionAbsent();
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder
        getConditionAbsentOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return Whether the conditionMatchedLog field is set.
     */
    boolean hasConditionMatchedLog();
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return The conditionMatchedLog.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getConditionMatchedLog();
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder
        getConditionMatchedLogOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return Whether the conditionMonitoringQueryLanguage field is set.
     */
    boolean hasConditionMonitoringQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return The conditionMonitoringQueryLanguage.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
        getConditionMonitoringQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageConditionOrBuilder
        getConditionMonitoringQueryLanguageOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return Whether the conditionPrometheusQueryLanguage field is set.
     */
    boolean hasConditionPrometheusQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return The conditionPrometheusQueryLanguage.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
        getConditionPrometheusQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageConditionOrBuilder
        getConditionPrometheusQueryLanguageOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that periodically evaluates a SQL query result.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     *
     * @return Whether the conditionSql field is set.
     */
    boolean hasConditionSql();
    /**
     *
     *
     * <pre>
     * A condition that periodically evaluates a SQL query result.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     *
     * @return The conditionSql.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition getConditionSql();
    /**
     *
     *
     * <pre>
     * A condition that periodically evaluates a SQL query result.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.SqlConditionOrBuilder getConditionSqlOrBuilder();

    com.google.monitoring.v3.AlertPolicy.Condition.ConditionCase getConditionCase();
  }
  /**
   *
   *
   * <pre>
   * A condition is a true/false test that determines when an alerting policy
   * should open an incident. If a condition evaluates to true, it signifies
   * that something is wrong.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition}
   */
  public static final class Condition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition)
      ConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Condition.newBuilder() to construct.
    private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Condition() {
      name_ = "";
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Condition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Condition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Condition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.AlertPolicy.Condition.class,
              com.google.monitoring.v3.AlertPolicy.Condition.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A condition control that determines how metric-threshold conditions
     * are evaluated when data stops arriving.
     * This control doesn't affect metric-absence policies.
     * </pre>
     *
     * Protobuf enum {@code google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData}
     */
    public enum EvaluationMissingData implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * An unspecified evaluation missing data option.  Equivalent to
       * EVALUATION_MISSING_DATA_NO_OP.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_UNSPECIFIED = 0;</code>
       */
      EVALUATION_MISSING_DATA_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as false.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_INACTIVE = 1;</code>
       */
      EVALUATION_MISSING_DATA_INACTIVE(1),
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as true.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_ACTIVE = 2;</code>
       */
      EVALUATION_MISSING_DATA_ACTIVE(2),
      /**
       *
       *
       * <pre>
       * Do not evaluate the condition to any value if there is no data.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_NO_OP = 3;</code>
       */
      EVALUATION_MISSING_DATA_NO_OP(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * An unspecified evaluation missing data option.  Equivalent to
       * EVALUATION_MISSING_DATA_NO_OP.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_UNSPECIFIED = 0;</code>
       */
      public static final int EVALUATION_MISSING_DATA_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as false.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_INACTIVE = 1;</code>
       */
      public static final int EVALUATION_MISSING_DATA_INACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as true.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_ACTIVE = 2;</code>
       */
      public static final int EVALUATION_MISSING_DATA_ACTIVE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Do not evaluate the condition to any value if there is no data.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_NO_OP = 3;</code>
       */
      public static final int EVALUATION_MISSING_DATA_NO_OP_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EvaluationMissingData valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EvaluationMissingData forNumber(int value) {
        switch (value) {
          case 0:
            return EVALUATION_MISSING_DATA_UNSPECIFIED;
          case 1:
            return EVALUATION_MISSING_DATA_INACTIVE;
          case 2:
            return EVALUATION_MISSING_DATA_ACTIVE;
          case 3:
            return EVALUATION_MISSING_DATA_NO_OP;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EvaluationMissingData>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EvaluationMissingData>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<EvaluationMissingData>() {
                public EvaluationMissingData findValueByNumber(int number) {
                  return EvaluationMissingData.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.AlertPolicy.Condition.getDescriptor().getEnumTypes().get(0);
      }

      private static final EvaluationMissingData[] VALUES = values();

      public static EvaluationMissingData valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EvaluationMissingData(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData)
    }

    public interface TriggerOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.Trigger)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return Whether the count field is set.
       */
      boolean hasCount();
      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return The count.
       */
      int getCount();

      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return Whether the percent field is set.
       */
      boolean hasPercent();
      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return The percent.
       */
      double getPercent();

      com.google.monitoring.v3.AlertPolicy.Condition.Trigger.TypeCase getTypeCase();
    }
    /**
     *
     *
     * <pre>
     * Specifies how many time series must fail a predicate to trigger a
     * condition. If not specified, then a `{count: 1}` trigger is used.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.Trigger}
     */
    public static final class Trigger extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.Trigger)
        TriggerOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Trigger.newBuilder() to construct.
      private Trigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Trigger() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Trigger();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.class,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder.class);
      }

      private int typeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object type_;

      public enum TypeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        COUNT(1),
        PERCENT(2),
        TYPE_NOT_SET(0);
        private final int value;

        private TypeCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TypeCase valueOf(int value) {
          return forNumber(value);
        }

        public static TypeCase forNumber(int value) {
          switch (value) {
            case 1:
              return COUNT;
            case 2:
              return PERCENT;
            case 0:
              return TYPE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public static final int COUNT_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return Whether the count field is set.
       */
      @java.lang.Override
      public boolean hasCount() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public int getCount() {
        if (typeCase_ == 1) {
          return (java.lang.Integer) type_;
        }
        return 0;
      }

      public static final int PERCENT_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return Whether the percent field is set.
       */
      @java.lang.Override
      public boolean hasPercent() {
        return typeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return The percent.
       */
      @java.lang.Override
      public double getPercent() {
        if (typeCase_ == 2) {
          return (java.lang.Double) type_;
        }
        return 0D;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (typeCase_ == 1) {
          output.writeInt32(1, (int) ((java.lang.Integer) type_));
        }
        if (typeCase_ == 2) {
          output.writeDouble(2, (double) ((java.lang.Double) type_));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (typeCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(
                  1, (int) ((java.lang.Integer) type_));
        }
        if (typeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeDoubleSize(
                  2, (double) ((java.lang.Double) type_));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.Trigger)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.Trigger other =
            (com.google.monitoring.v3.AlertPolicy.Condition.Trigger) obj;

        if (!getTypeCase().equals(other.getTypeCase())) return false;
        switch (typeCase_) {
          case 1:
            if (getCount() != other.getCount()) return false;
            break;
          case 2:
            if (java.lang.Double.doubleToLongBits(getPercent())
                != java.lang.Double.doubleToLongBits(other.getPercent())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (typeCase_) {
          case 1:
            hash = (37 * hash) + COUNT_FIELD_NUMBER;
            hash = (53 * hash) + getCount();
            break;
          case 2:
            hash = (37 * hash) + PERCENT_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getPercent()));
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.Trigger prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies how many time series must fail a predicate to trigger a
       * condition. If not specified, then a `{count: 1}` trigger is used.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.Trigger}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.Trigger)
          com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.Trigger.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.Trigger.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          typeCase_ = 0;
          type_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger build() {
          com.google.monitoring.v3.AlertPolicy.Condition.Trigger result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.Trigger result =
              new com.google.monitoring.v3.AlertPolicy.Condition.Trigger(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Condition.Trigger result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger result) {
          result.typeCase_ = typeCase_;
          result.type_ = this.type_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.Trigger) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.Trigger) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Condition.Trigger other) {
          if (other == com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance())
            return this;
          switch (other.getTypeCase()) {
            case COUNT:
              {
                setCount(other.getCount());
                break;
              }
            case PERCENT:
              {
                setPercent(other.getPercent());
                break;
              }
            case TYPE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    type_ = input.readInt32();
                    typeCase_ = 1;
                    break;
                  } // case 8
                case 17:
                  {
                    type_ = input.readDouble();
                    typeCase_ = 2;
                    break;
                  } // case 17
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int typeCase_ = 0;
        private java.lang.Object type_;

        public TypeCase getTypeCase() {
          return TypeCase.forNumber(typeCase_);
        }

        public Builder clearType() {
          typeCase_ = 0;
          type_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @return Whether the count field is set.
         */
        public boolean hasCount() {
          return typeCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @return The count.
         */
        public int getCount() {
          if (typeCase_ == 1) {
            return (java.lang.Integer) type_;
          }
          return 0;
        }
        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(int value) {

          typeCase_ = 1;
          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @return Whether the percent field is set.
         */
        public boolean hasPercent() {
          return typeCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @return The percent.
         */
        public double getPercent() {
          if (typeCase_ == 2) {
            return (java.lang.Double) type_;
          }
          return 0D;
        }
        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @param value The percent to set.
         * @return This builder for chaining.
         */
        public Builder setPercent(double value) {

          typeCase_ = 2;
          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPercent() {
          if (typeCase_ == 2) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.Trigger)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.Trigger)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.Trigger DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.Trigger();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Trigger> PARSER =
          new com.google.protobuf.AbstractParser<Trigger>() {
            @java.lang.Override
            public Trigger parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Trigger> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Trigger> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MetricThresholdOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      com.google.monitoring.v3.Aggregation getAggregations(int index);
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      int getAggregationsCount();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The denominatorFilter.
       */
      java.lang.String getDenominatorFilter();
      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The bytes for denominatorFilter.
       */
      com.google.protobuf.ByteString getDenominatorFilterBytes();

      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      java.util.List<com.google.monitoring.v3.Aggregation> getDenominatorAggregationsList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      com.google.monitoring.v3.Aggregation getDenominatorAggregations(int index);
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      int getDenominatorAggregationsCount();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getDenominatorAggregationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      com.google.monitoring.v3.AggregationOrBuilder getDenominatorAggregationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return Whether the forecastOptions field is set.
       */
      boolean hasForecastOptions();
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return The forecastOptions.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
          getForecastOptions();
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptionsOrBuilder
          getForecastOptionsOrBuilder();

      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The enum numeric value on the wire for comparison.
       */
      int getComparisonValue();
      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The comparison.
       */
      com.google.monitoring.v3.ComparisonType getComparison();

      /**
       *
       *
       * <pre>
       * A value against which to compare the time series.
       * </pre>
       *
       * <code>double threshold_value = 5;</code>
       *
       * @return The thresholdValue.
       */
      double getThresholdValue();

      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return Whether the trigger field is set.
       */
      boolean hasTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return The trigger.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder();

      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving. To use this control, the value
       * of the `duration` field must be greater than or equal to 60 seconds.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      int getEvaluationMissingDataValue();
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving. To use this control, the value
       * of the `duration` field must be greater than or equal to 60 seconds.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData();
    }
    /**
     *
     *
     * <pre>
     * A condition type that compares a collection of time series
     * against a threshold.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricThreshold}
     */
    public static final class MetricThreshold extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
        MetricThresholdOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MetricThreshold.newBuilder() to construct.
      private MetricThreshold(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MetricThreshold() {
        filter_ = "";
        aggregations_ = java.util.Collections.emptyList();
        denominatorFilter_ = "";
        denominatorAggregations_ = java.util.Collections.emptyList();
        comparison_ = 0;
        evaluationMissingData_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MetricThreshold();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.class,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder.class);
      }

      public interface ForecastOptionsOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the forecastHorizon field is set.
         */
        boolean hasForecastHorizon();
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The forecastHorizon.
         */
        com.google.protobuf.Duration getForecastHorizon();
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.protobuf.DurationOrBuilder getForecastHorizonOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Options used when forecasting the time series and testing
       * the predicted value against the threshold.
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions}
       */
      public static final class ForecastOptions extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
          ForecastOptionsOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ForecastOptions.newBuilder() to construct.
        private ForecastOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ForecastOptions() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ForecastOptions();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                      .class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                      .Builder.class);
        }

        private int bitField0_;
        public static final int FORECAST_HORIZON_FIELD_NUMBER = 1;
        private com.google.protobuf.Duration forecastHorizon_;
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the forecastHorizon field is set.
         */
        @java.lang.Override
        public boolean hasForecastHorizon() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The forecastHorizon.
         */
        @java.lang.Override
        public com.google.protobuf.Duration getForecastHorizon() {
          return forecastHorizon_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : forecastHorizon_;
        }
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.protobuf.DurationOrBuilder getForecastHorizonOrBuilder() {
          return forecastHorizon_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : forecastHorizon_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(1, getForecastHorizon());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(1, getForecastHorizon());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions other =
              (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions) obj;

          if (hasForecastHorizon() != other.hasForecastHorizon()) return false;
          if (hasForecastHorizon()) {
            if (!getForecastHorizon().equals(other.getForecastHorizon())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasForecastHorizon()) {
            hash = (37 * hash) + FORECAST_HORIZON_FIELD_NUMBER;
            hash = (53 * hash) + getForecastHorizon().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Options used when forecasting the time series and testing
         * the predicted value against the threshold.
         * </pre>
         *
         * Protobuf type {@code
         * google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                .ForecastOptionsOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                        .class,
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                        .Builder.class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getForecastHorizonFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            forecastHorizon_ = null;
            if (forecastHorizonBuilder_ != null) {
              forecastHorizonBuilder_.dispose();
              forecastHorizonBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
              build() {
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
              buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions result =
                new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                  result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.forecastHorizon_ =
                  forecastHorizonBuilder_ == null
                      ? forecastHorizon_
                      : forecastHorizonBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                  other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .getDefaultInstance()) return this;
            if (other.hasForecastHorizon()) {
              mergeForecastHorizon(other.getForecastHorizon());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          getForecastHorizonFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Duration forecastHorizon_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              forecastHorizonBuilder_;
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the forecastHorizon field is set.
           */
          public boolean hasForecastHorizon() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The forecastHorizon.
           */
          public com.google.protobuf.Duration getForecastHorizon() {
            if (forecastHorizonBuilder_ == null) {
              return forecastHorizon_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : forecastHorizon_;
            } else {
              return forecastHorizonBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setForecastHorizon(com.google.protobuf.Duration value) {
            if (forecastHorizonBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              forecastHorizon_ = value;
            } else {
              forecastHorizonBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setForecastHorizon(com.google.protobuf.Duration.Builder builderForValue) {
            if (forecastHorizonBuilder_ == null) {
              forecastHorizon_ = builderForValue.build();
            } else {
              forecastHorizonBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeForecastHorizon(com.google.protobuf.Duration value) {
            if (forecastHorizonBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && forecastHorizon_ != null
                  && forecastHorizon_ != com.google.protobuf.Duration.getDefaultInstance()) {
                getForecastHorizonBuilder().mergeFrom(value);
              } else {
                forecastHorizon_ = value;
              }
            } else {
              forecastHorizonBuilder_.mergeFrom(value);
            }
            if (forecastHorizon_ != null) {
              bitField0_ |= 0x00000001;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearForecastHorizon() {
            bitField0_ = (bitField0_ & ~0x00000001);
            forecastHorizon_ = null;
            if (forecastHorizonBuilder_ != null) {
              forecastHorizonBuilder_.dispose();
              forecastHorizonBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.protobuf.Duration.Builder getForecastHorizonBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getForecastHorizonFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.protobuf.DurationOrBuilder getForecastHorizonOrBuilder() {
            if (forecastHorizonBuilder_ != null) {
              return forecastHorizonBuilder_.getMessageOrBuilder();
            } else {
              return forecastHorizon_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : forecastHorizon_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              getForecastHorizonFieldBuilder() {
            if (forecastHorizonBuilder_ == null) {
              forecastHorizonBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.Duration,
                      com.google.protobuf.Duration.Builder,
                      com.google.protobuf.DurationOrBuilder>(
                      getForecastHorizon(), getParentForChildren(), isClean());
              forecastHorizon_ = null;
            }
            return forecastHorizonBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                .ForecastOptions
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ForecastOptions> PARSER =
            new com.google.protobuf.AbstractParser<ForecastOptions>() {
              @java.lang.Override
              public ForecastOptions parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ForecastOptions> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ForecastOptions> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int FILTER_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int AGGREGATIONS_FIELD_NUMBER = 8;

      @SuppressWarnings("serial")
      private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_;
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public int getAggregationsCount() {
        return aggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.Aggregation getAggregations(int index) {
        return aggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
        return aggregations_.get(index);
      }

      public static final int DENOMINATOR_FILTER_FIELD_NUMBER = 9;

      @SuppressWarnings("serial")
      private volatile java.lang.Object denominatorFilter_ = "";
      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The denominatorFilter.
       */
      @java.lang.Override
      public java.lang.String getDenominatorFilter() {
        java.lang.Object ref = denominatorFilter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          denominatorFilter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The bytes for denominatorFilter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDenominatorFilterBytes() {
        java.lang.Object ref = denominatorFilter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          denominatorFilter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DENOMINATOR_AGGREGATIONS_FIELD_NUMBER = 10;

      @SuppressWarnings("serial")
      private java.util.List<com.google.monitoring.v3.Aggregation> denominatorAggregations_;
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.monitoring.v3.Aggregation> getDenominatorAggregationsList() {
        return denominatorAggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getDenominatorAggregationsOrBuilderList() {
        return denominatorAggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public int getDenominatorAggregationsCount() {
        return denominatorAggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.Aggregation getDenominatorAggregations(int index) {
        return denominatorAggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AggregationOrBuilder getDenominatorAggregationsOrBuilder(
          int index) {
        return denominatorAggregations_.get(index);
      }

      public static final int FORECAST_OPTIONS_FIELD_NUMBER = 12;
      private com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
          forecastOptions_;
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return Whether the forecastOptions field is set.
       */
      @java.lang.Override
      public boolean hasForecastOptions() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return The forecastOptions.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
          getForecastOptions() {
        return forecastOptions_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .getDefaultInstance()
            : forecastOptions_;
      }
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptionsOrBuilder
          getForecastOptionsOrBuilder() {
        return forecastOptions_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .getDefaultInstance()
            : forecastOptions_;
      }

      public static final int COMPARISON_FIELD_NUMBER = 4;
      private int comparison_ = 0;
      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The enum numeric value on the wire for comparison.
       */
      @java.lang.Override
      public int getComparisonValue() {
        return comparison_;
      }
      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The comparison.
       */
      @java.lang.Override
      public com.google.monitoring.v3.ComparisonType getComparison() {
        com.google.monitoring.v3.ComparisonType result =
            com.google.monitoring.v3.ComparisonType.forNumber(comparison_);
        return result == null ? com.google.monitoring.v3.ComparisonType.UNRECOGNIZED : result;
      }

      public static final int THRESHOLD_VALUE_FIELD_NUMBER = 5;
      private double thresholdValue_ = 0D;
      /**
       *
       *
       * <pre>
       * A value against which to compare the time series.
       * </pre>
       *
       * <code>double threshold_value = 5;</code>
       *
       * @return The thresholdValue.
       */
      @java.lang.Override
      public double getThresholdValue() {
        return thresholdValue_;
      }

      public static final int DURATION_FIELD_NUMBER = 6;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int TRIGGER_FIELD_NUMBER = 7;
      private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return Whether the trigger field is set.
       */
      @java.lang.Override
      public boolean hasTrigger() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return The trigger.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }

      public static final int EVALUATION_MISSING_DATA_FIELD_NUMBER = 11;
      private int evaluationMissingData_ = 0;
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving. To use this control, the value
       * of the `duration` field must be greater than or equal to 60 seconds.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      @java.lang.Override
      public int getEvaluationMissingDataValue() {
        return evaluationMissingData_;
      }
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving. To use this control, the value
       * of the `duration` field must be greater than or equal to 60 seconds.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData() {
        com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                evaluationMissingData_);
        return result == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
        }
        if (comparison_
            != com.google.monitoring.v3.ComparisonType.COMPARISON_UNSPECIFIED.getNumber()) {
          output.writeEnum(4, comparison_);
        }
        if (java.lang.Double.doubleToRawLongBits(thresholdValue_) != 0) {
          output.writeDouble(5, thresholdValue_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(6, getDuration());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(7, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          output.writeMessage(8, aggregations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(denominatorFilter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 9, denominatorFilter_);
        }
        for (int i = 0; i < denominatorAggregations_.size(); i++) {
          output.writeMessage(10, denominatorAggregations_.get(i));
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(11, evaluationMissingData_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(12, getForecastOptions());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
        }
        if (comparison_
            != com.google.monitoring.v3.ComparisonType.COMPARISON_UNSPECIFIED.getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, comparison_);
        }
        if (java.lang.Double.doubleToRawLongBits(thresholdValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, thresholdValue_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDuration());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, aggregations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(denominatorFilter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, denominatorFilter_);
        }
        for (int i = 0; i < denominatorAggregations_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  10, denominatorAggregations_.get(i));
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, evaluationMissingData_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(12, getForecastOptions());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold other =
            (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) obj;

        if (!getFilter().equals(other.getFilter())) return false;
        if (!getAggregationsList().equals(other.getAggregationsList())) return false;
        if (!getDenominatorFilter().equals(other.getDenominatorFilter())) return false;
        if (!getDenominatorAggregationsList().equals(other.getDenominatorAggregationsList()))
          return false;
        if (hasForecastOptions() != other.hasForecastOptions()) return false;
        if (hasForecastOptions()) {
          if (!getForecastOptions().equals(other.getForecastOptions())) return false;
        }
        if (comparison_ != other.comparison_) return false;
        if (java.lang.Double.doubleToLongBits(getThresholdValue())
            != java.lang.Double.doubleToLongBits(other.getThresholdValue())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasTrigger() != other.hasTrigger()) return false;
        if (hasTrigger()) {
          if (!getTrigger().equals(other.getTrigger())) return false;
        }
        if (evaluationMissingData_ != other.evaluationMissingData_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (getAggregationsCount() > 0) {
          hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getAggregationsList().hashCode();
        }
        hash = (37 * hash) + DENOMINATOR_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getDenominatorFilter().hashCode();
        if (getDenominatorAggregationsCount() > 0) {
          hash = (37 * hash) + DENOMINATOR_AGGREGATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getDenominatorAggregationsList().hashCode();
        }
        if (hasForecastOptions()) {
          hash = (37 * hash) + FORECAST_OPTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getForecastOptions().hashCode();
        }
        hash = (37 * hash) + COMPARISON_FIELD_NUMBER;
        hash = (53 * hash) + comparison_;
        hash = (37 * hash) + THRESHOLD_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getThresholdValue()));
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasTrigger()) {
          hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
          hash = (53 * hash) + getTrigger().hashCode();
        }
        hash = (37 * hash) + EVALUATION_MISSING_DATA_FIELD_NUMBER;
        hash = (53 * hash) + evaluationMissingData_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that compares a collection of time series
       * against a threshold.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricThreshold}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getAggregationsFieldBuilder();
            getDenominatorAggregationsFieldBuilder();
            getForecastOptionsFieldBuilder();
            getDurationFieldBuilder();
            getTriggerFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          filter_ = "";
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
          } else {
            aggregations_ = null;
            aggregationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          denominatorFilter_ = "";
          if (denominatorAggregationsBuilder_ == null) {
            denominatorAggregations_ = java.util.Collections.emptyList();
          } else {
            denominatorAggregations_ = null;
            denominatorAggregationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          forecastOptions_ = null;
          if (forecastOptionsBuilder_ != null) {
            forecastOptionsBuilder_.dispose();
            forecastOptionsBuilder_ = null;
          }
          comparison_ = 0;
          thresholdValue_ = 0D;
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          evaluationMissingData_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold build() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result =
              new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result) {
          if (aggregationsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.aggregations_ = aggregations_;
          } else {
            result.aggregations_ = aggregationsBuilder_.build();
          }
          if (denominatorAggregationsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              denominatorAggregations_ =
                  java.util.Collections.unmodifiableList(denominatorAggregations_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.denominatorAggregations_ = denominatorAggregations_;
          } else {
            result.denominatorAggregations_ = denominatorAggregationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.filter_ = filter_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.denominatorFilter_ = denominatorFilter_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.forecastOptions_ =
                forecastOptionsBuilder_ == null
                    ? forecastOptions_
                    : forecastOptionsBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.comparison_ = comparison_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.thresholdValue_ = thresholdValue_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.trigger_ = triggerBuilder_ == null ? trigger_ : triggerBuilder_.build();
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000200) != 0)) {
            result.evaluationMissingData_ = evaluationMissingData_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                  .getDefaultInstance()) return this;
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (aggregationsBuilder_ == null) {
            if (!other.aggregations_.isEmpty()) {
              if (aggregations_.isEmpty()) {
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureAggregationsIsMutable();
                aggregations_.addAll(other.aggregations_);
              }
              onChanged();
            }
          } else {
            if (!other.aggregations_.isEmpty()) {
              if (aggregationsBuilder_.isEmpty()) {
                aggregationsBuilder_.dispose();
                aggregationsBuilder_ = null;
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
                aggregationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getAggregationsFieldBuilder()
                        : null;
              } else {
                aggregationsBuilder_.addAllMessages(other.aggregations_);
              }
            }
          }
          if (!other.getDenominatorFilter().isEmpty()) {
            denominatorFilter_ = other.denominatorFilter_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (denominatorAggregationsBuilder_ == null) {
            if (!other.denominatorAggregations_.isEmpty()) {
              if (denominatorAggregations_.isEmpty()) {
                denominatorAggregations_ = other.denominatorAggregations_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureDenominatorAggregationsIsMutable();
                denominatorAggregations_.addAll(other.denominatorAggregations_);
              }
              onChanged();
            }
          } else {
            if (!other.denominatorAggregations_.isEmpty()) {
              if (denominatorAggregationsBuilder_.isEmpty()) {
                denominatorAggregationsBuilder_.dispose();
                denominatorAggregationsBuilder_ = null;
                denominatorAggregations_ = other.denominatorAggregations_;
                bitField0_ = (bitField0_ & ~0x00000008);
                denominatorAggregationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDenominatorAggregationsFieldBuilder()
                        : null;
              } else {
                denominatorAggregationsBuilder_.addAllMessages(other.denominatorAggregations_);
              }
            }
          }
          if (other.hasForecastOptions()) {
            mergeForecastOptions(other.getForecastOptions());
          }
          if (other.comparison_ != 0) {
            setComparisonValue(other.getComparisonValue());
          }
          if (other.getThresholdValue() != 0D) {
            setThresholdValue(other.getThresholdValue());
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasTrigger()) {
            mergeTrigger(other.getTrigger());
          }
          if (other.evaluationMissingData_ != 0) {
            setEvaluationMissingDataValue(other.getEvaluationMissingDataValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 18
                case 32:
                  {
                    comparison_ = input.readEnum();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 32
                case 41:
                  {
                    thresholdValue_ = input.readDouble();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 41
                case 50:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 50
                case 58:
                  {
                    input.readMessage(getTriggerFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 58
                case 66:
                  {
                    com.google.monitoring.v3.Aggregation m =
                        input.readMessage(
                            com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
                    if (aggregationsBuilder_ == null) {
                      ensureAggregationsIsMutable();
                      aggregations_.add(m);
                    } else {
                      aggregationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 66
                case 74:
                  {
                    denominatorFilter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 74
                case 82:
                  {
                    com.google.monitoring.v3.Aggregation m =
                        input.readMessage(
                            com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
                    if (denominatorAggregationsBuilder_ == null) {
                      ensureDenominatorAggregationsIsMutable();
                      denominatorAggregations_.add(m);
                    } else {
                      denominatorAggregationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 82
                case 88:
                  {
                    evaluationMissingData_ = input.readEnum();
                    bitField0_ |= 0x00000200;
                    break;
                  } // case 88
                case 98:
                  {
                    input.readMessage(
                        getForecastOptionsFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 98
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_ =
            java.util.Collections.emptyList();

        private void ensureAggregationsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            aggregations_ =
                new java.util.ArrayList<com.google.monitoring.v3.Aggregation>(aggregations_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            aggregationsBuilder_;

        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
          if (aggregationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(aggregations_);
          } else {
            return aggregationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public int getAggregationsCount() {
          if (aggregationsBuilder_ == null) {
            return aggregations_.size();
          } else {
            return aggregationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation getAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder setAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.set(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder setAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.set(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(
            com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAllAggregations(
            java.lang.Iterable<? extends com.google.monitoring.v3.Aggregation> values) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
            onChanged();
          } else {
            aggregationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder clearAggregations() {
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            aggregationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder removeAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.remove(index);
            onChanged();
          } else {
            aggregationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder getAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsOrBuilderList() {
          if (aggregationsBuilder_ != null) {
            return aggregationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(aggregations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder() {
          return getAggregationsFieldBuilder()
              .addBuilder(com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder()
              .addBuilder(index, com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation.Builder>
            getAggregationsBuilderList() {
          return getAggregationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsFieldBuilder() {
          if (aggregationsBuilder_ == null) {
            aggregationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.monitoring.v3.Aggregation,
                    com.google.monitoring.v3.Aggregation.Builder,
                    com.google.monitoring.v3.AggregationOrBuilder>(
                    aggregations_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            aggregations_ = null;
          }
          return aggregationsBuilder_;
        }

        private java.lang.Object denominatorFilter_ = "";
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @return The denominatorFilter.
         */
        public java.lang.String getDenominatorFilter() {
          java.lang.Object ref = denominatorFilter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            denominatorFilter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @return The bytes for denominatorFilter.
         */
        public com.google.protobuf.ByteString getDenominatorFilterBytes() {
          java.lang.Object ref = denominatorFilter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            denominatorFilter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @param value The denominatorFilter to set.
         * @return This builder for chaining.
         */
        public Builder setDenominatorFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          denominatorFilter_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDenominatorFilter() {
          denominatorFilter_ = getDefaultInstance().getDenominatorFilter();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @param value The bytes for denominatorFilter to set.
         * @return This builder for chaining.
         */
        public Builder setDenominatorFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          denominatorFilter_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.util.List<com.google.monitoring.v3.Aggregation> denominatorAggregations_ =
            java.util.Collections.emptyList();

        private void ensureDenominatorAggregationsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            denominatorAggregations_ =
                new java.util.ArrayList<com.google.monitoring.v3.Aggregation>(
                    denominatorAggregations_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            denominatorAggregationsBuilder_;

        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation>
            getDenominatorAggregationsList() {
          if (denominatorAggregationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(denominatorAggregations_);
          } else {
            return denominatorAggregationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public int getDenominatorAggregationsCount() {
          if (denominatorAggregationsBuilder_ == null) {
            return denominatorAggregations_.size();
          } else {
            return denominatorAggregationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation getDenominatorAggregations(int index) {
          if (denominatorAggregationsBuilder_ == null) {
            return denominatorAggregations_.get(index);
          } else {
            return denominatorAggregationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder setDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation value) {
          if (denominatorAggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.set(index, value);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder setDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.set(index, builderForValue.build());
            onChanged();
          } else {
            denominatorAggregationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(com.google.monitoring.v3.Aggregation value) {
          if (denominatorAggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(value);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation value) {
          if (denominatorAggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(index, value);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(
            com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(builderForValue.build());
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(index, builderForValue.build());
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addAllDenominatorAggregations(
            java.lang.Iterable<? extends com.google.monitoring.v3.Aggregation> values) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, denominatorAggregations_);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder clearDenominatorAggregations() {
          if (denominatorAggregationsBuilder_ == null) {
            denominatorAggregations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder removeDenominatorAggregations(int index) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.remove(index);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder getDenominatorAggregationsBuilder(
            int index) {
          return getDenominatorAggregationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.AggregationOrBuilder getDenominatorAggregationsOrBuilder(
            int index) {
          if (denominatorAggregationsBuilder_ == null) {
            return denominatorAggregations_.get(index);
          } else {
            return denominatorAggregationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
            getDenominatorAggregationsOrBuilderList() {
          if (denominatorAggregationsBuilder_ != null) {
            return denominatorAggregationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(denominatorAggregations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addDenominatorAggregationsBuilder() {
          return getDenominatorAggregationsFieldBuilder()
              .addBuilder(com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addDenominatorAggregationsBuilder(
            int index) {
          return getDenominatorAggregationsFieldBuilder()
              .addBuilder(index, com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation.Builder>
            getDenominatorAggregationsBuilderList() {
          return getDenominatorAggregationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            getDenominatorAggregationsFieldBuilder() {
          if (denominatorAggregationsBuilder_ == null) {
            denominatorAggregationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.monitoring.v3.Aggregation,
                    com.google.monitoring.v3.Aggregation.Builder,
                    com.google.monitoring.v3.AggregationOrBuilder>(
                    denominatorAggregations_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            denominatorAggregations_ = null;
          }
          return denominatorAggregationsBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            forecastOptions_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                    .ForecastOptionsOrBuilder>
            forecastOptionsBuilder_;
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         *
         * @return Whether the forecastOptions field is set.
         */
        public boolean hasForecastOptions() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         *
         * @return The forecastOptions.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            getForecastOptions() {
          if (forecastOptionsBuilder_ == null) {
            return forecastOptions_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .getDefaultInstance()
                : forecastOptions_;
          } else {
            return forecastOptionsBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder setForecastOptions(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions value) {
          if (forecastOptionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            forecastOptions_ = value;
          } else {
            forecastOptionsBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder setForecastOptions(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions.Builder
                builderForValue) {
          if (forecastOptionsBuilder_ == null) {
            forecastOptions_ = builderForValue.build();
          } else {
            forecastOptionsBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder mergeForecastOptions(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions value) {
          if (forecastOptionsBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && forecastOptions_ != null
                && forecastOptions_
                    != com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                        .ForecastOptions.getDefaultInstance()) {
              getForecastOptionsBuilder().mergeFrom(value);
            } else {
              forecastOptions_ = value;
            }
          } else {
            forecastOptionsBuilder_.mergeFrom(value);
          }
          if (forecastOptions_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder clearForecastOptions() {
          bitField0_ = (bitField0_ & ~0x00000010);
          forecastOptions_ = null;
          if (forecastOptionsBuilder_ != null) {
            forecastOptionsBuilder_.dispose();
            forecastOptionsBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .Builder
            getForecastOptionsBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getForecastOptionsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                .ForecastOptionsOrBuilder
            getForecastOptionsOrBuilder() {
          if (forecastOptionsBuilder_ != null) {
            return forecastOptionsBuilder_.getMessageOrBuilder();
          } else {
            return forecastOptions_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .getDefaultInstance()
                : forecastOptions_;
          }
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                    .ForecastOptionsOrBuilder>
            getForecastOptionsFieldBuilder() {
          if (forecastOptionsBuilder_ == null) {
            forecastOptionsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions,
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                        .Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                        .ForecastOptionsOrBuilder>(
                    getForecastOptions(), getParentForChildren(), isClean());
            forecastOptions_ = null;
          }
          return forecastOptionsBuilder_;
        }

        private int comparison_ = 0;
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @return The enum numeric value on the wire for comparison.
         */
        @java.lang.Override
        public int getComparisonValue() {
          return comparison_;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @param value The enum numeric value on the wire for comparison to set.
         * @return This builder for chaining.
         */
        public Builder setComparisonValue(int value) {
          comparison_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @return The comparison.
         */
        @java.lang.Override
        public com.google.monitoring.v3.ComparisonType getComparison() {
          com.google.monitoring.v3.ComparisonType result =
              com.google.monitoring.v3.ComparisonType.forNumber(comparison_);
          return result == null ? com.google.monitoring.v3.ComparisonType.UNRECOGNIZED : result;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @param value The comparison to set.
         * @return This builder for chaining.
         */
        public Builder setComparison(com.google.monitoring.v3.ComparisonType value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000020;
          comparison_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearComparison() {
          bitField0_ = (bitField0_ & ~0x00000020);
          comparison_ = 0;
          onChanged();
          return this;
        }

        private double thresholdValue_;
        /**
         *
         *
         * <pre>
         * A value against which to compare the time series.
         * </pre>
         *
         * <code>double threshold_value = 5;</code>
         *
         * @return The thresholdValue.
         */
        @java.lang.Override
        public double getThresholdValue() {
          return thresholdValue_;
        }
        /**
         *
         *
         * <pre>
         * A value against which to compare the time series.
         * </pre>
         *
         * <code>double threshold_value = 5;</code>
         *
         * @param value The thresholdValue to set.
         * @return This builder for chaining.
         */
        public Builder setThresholdValue(double value) {

          thresholdValue_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A value against which to compare the time series.
         * </pre>
         *
         * <code>double threshold_value = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearThresholdValue() {
          bitField0_ = (bitField0_ & ~0x00000040);
          thresholdValue_ = 0D;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000080) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          if (duration_ != null) {
            bitField0_ |= 0x00000080;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000080);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000080;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            triggerBuilder_;
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         *
         * @return Whether the trigger field is set.
         */
        public boolean hasTrigger() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         *
         * @return The trigger.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
          if (triggerBuilder_ == null) {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          } else {
            return triggerBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder setTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trigger_ = value;
          } else {
            triggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder setTrigger(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder builderForValue) {
          if (triggerBuilder_ == null) {
            trigger_ = builderForValue.build();
          } else {
            triggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder mergeTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (((bitField0_ & 0x00000100) != 0)
                && trigger_ != null
                && trigger_
                    != com.google.monitoring.v3.AlertPolicy.Condition.Trigger
                        .getDefaultInstance()) {
              getTriggerBuilder().mergeFrom(value);
            } else {
              trigger_ = value;
            }
          } else {
            triggerBuilder_.mergeFrom(value);
          }
          if (trigger_ != null) {
            bitField0_ |= 0x00000100;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder clearTrigger() {
          bitField0_ = (bitField0_ & ~0x00000100);
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder getTriggerBuilder() {
          bitField0_ |= 0x00000100;
          onChanged();
          return getTriggerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder
            getTriggerOrBuilder() {
          if (triggerBuilder_ != null) {
            return triggerBuilder_.getMessageOrBuilder();
          } else {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            getTriggerFieldBuilder() {
          if (triggerBuilder_ == null) {
            triggerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>(
                    getTrigger(), getParentForChildren(), isClean());
            trigger_ = null;
          }
          return triggerBuilder_;
        }

        private int evaluationMissingData_ = 0;
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving. To use this control, the value
         * of the `duration` field must be greater than or equal to 60 seconds.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @return The enum numeric value on the wire for evaluationMissingData.
         */
        @java.lang.Override
        public int getEvaluationMissingDataValue() {
          return evaluationMissingData_;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving. To use this control, the value
         * of the `duration` field must be greater than or equal to 60 seconds.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @param value The enum numeric value on the wire for evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingDataValue(int value) {
          evaluationMissingData_ = value;
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving. To use this control, the value
         * of the `duration` field must be greater than or equal to 60 seconds.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @return The evaluationMissingData.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
            getEvaluationMissingData() {
          com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
              com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                  evaluationMissingData_);
          return result == null
              ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving. To use this control, the value
         * of the `duration` field must be greater than or equal to 60 seconds.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @param value The evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingData(
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000200;
          evaluationMissingData_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving. To use this control, the value
         * of the `duration` field must be greater than or equal to 60 seconds.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEvaluationMissingData() {
          bitField0_ = (bitField0_ & ~0x00000200);
          evaluationMissingData_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MetricThreshold> PARSER =
          new com.google.protobuf.AbstractParser<MetricThreshold>() {
            @java.lang.Override
            public MetricThreshold parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MetricThreshold> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MetricThreshold> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MetricAbsenceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      com.google.monitoring.v3.Aggregation getAggregations(int index);
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      int getAggregationsCount();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      boolean hasTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A condition type that checks that monitored resources
     * are reporting data. The configuration defines a metric and
     * a set of monitored resources. The predicate is considered in violation
     * when a time series for the specified metric of a monitored
     * resource does not include any data in the specified `duration`.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricAbsence}
     */
    public static final class MetricAbsence extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
        MetricAbsenceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MetricAbsence.newBuilder() to construct.
      private MetricAbsence(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MetricAbsence() {
        filter_ = "";
        aggregations_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MetricAbsence();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.class,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder.class);
      }

      private int bitField0_;
      public static final int FILTER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int AGGREGATIONS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_;
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public int getAggregationsCount() {
        return aggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.Aggregation getAggregations(int index) {
        return aggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
        return aggregations_.get(index);
      }

      public static final int DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int TRIGGER_FIELD_NUMBER = 3;
      private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      @java.lang.Override
      public boolean hasTrigger() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getDuration());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          output.writeMessage(5, aggregations_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, aggregations_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence other =
            (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) obj;

        if (!getFilter().equals(other.getFilter())) return false;
        if (!getAggregationsList().equals(other.getAggregationsList())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasTrigger() != other.hasTrigger()) return false;
        if (hasTrigger()) {
          if (!getTrigger().equals(other.getTrigger())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (getAggregationsCount() > 0) {
          hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getAggregationsList().hashCode();
        }
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasTrigger()) {
          hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
          hash = (53 * hash) + getTrigger().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that checks that monitored resources
       * are reporting data. The configuration defines a metric and
       * a set of monitored resources. The predicate is considered in violation
       * when a time series for the specified metric of a monitored
       * resource does not include any data in the specified `duration`.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricAbsence}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getAggregationsFieldBuilder();
            getDurationFieldBuilder();
            getTriggerFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          filter_ = "";
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
          } else {
            aggregations_ = null;
            aggregationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence build() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result =
              new com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result) {
          if (aggregationsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.aggregations_ = aggregations_;
          } else {
            result.aggregations_ = aggregationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.filter_ = filter_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.trigger_ = triggerBuilder_ == null ? trigger_ : triggerBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance())
            return this;
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (aggregationsBuilder_ == null) {
            if (!other.aggregations_.isEmpty()) {
              if (aggregations_.isEmpty()) {
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureAggregationsIsMutable();
                aggregations_.addAll(other.aggregations_);
              }
              onChanged();
            }
          } else {
            if (!other.aggregations_.isEmpty()) {
              if (aggregationsBuilder_.isEmpty()) {
                aggregationsBuilder_.dispose();
                aggregationsBuilder_ = null;
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
                aggregationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getAggregationsFieldBuilder()
                        : null;
              } else {
                aggregationsBuilder_.addAllMessages(other.aggregations_);
              }
            }
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasTrigger()) {
            mergeTrigger(other.getTrigger());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getTriggerFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 26
                case 42:
                  {
                    com.google.monitoring.v3.Aggregation m =
                        input.readMessage(
                            com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
                    if (aggregationsBuilder_ == null) {
                      ensureAggregationsIsMutable();
                      aggregations_.add(m);
                    } else {
                      aggregationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_ =
            java.util.Collections.emptyList();

        private void ensureAggregationsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            aggregations_ =
                new java.util.ArrayList<com.google.monitoring.v3.Aggregation>(aggregations_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            aggregationsBuilder_;

        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
          if (aggregationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(aggregations_);
          } else {
            return aggregationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public int getAggregationsCount() {
          if (aggregationsBuilder_ == null) {
            return aggregations_.size();
          } else {
            return aggregationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation getAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder setAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.set(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder setAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.set(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(
            com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAllAggregations(
            java.lang.Iterable<? extends com.google.monitoring.v3.Aggregation> values) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
            onChanged();
          } else {
            aggregationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder clearAggregations() {
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            aggregationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder removeAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.remove(index);
            onChanged();
          } else {
            aggregationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder getAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsOrBuilderList() {
          if (aggregationsBuilder_ != null) {
            return aggregationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(aggregations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder() {
          return getAggregationsFieldBuilder()
              .addBuilder(com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder()
              .addBuilder(index, com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation.Builder>
            getAggregationsBuilderList() {
          return getAggregationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsFieldBuilder() {
          if (aggregationsBuilder_ == null) {
            aggregationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.monitoring.v3.Aggregation,
                    com.google.monitoring.v3.Aggregation.Builder,
                    com.google.monitoring.v3.AggregationOrBuilder>(
                    aggregations_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            aggregations_ = null;
          }
          return aggregationsBuilder_;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          if (duration_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000004);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            triggerBuilder_;
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return Whether the trigger field is set.
         */
        public boolean hasTrigger() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return The trigger.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
          if (triggerBuilder_ == null) {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          } else {
            return triggerBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trigger_ = value;
          } else {
            triggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder builderForValue) {
          if (triggerBuilder_ == null) {
            trigger_ = builderForValue.build();
          } else {
            triggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder mergeTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && trigger_ != null
                && trigger_
                    != com.google.monitoring.v3.AlertPolicy.Condition.Trigger
                        .getDefaultInstance()) {
              getTriggerBuilder().mergeFrom(value);
            } else {
              trigger_ = value;
            }
          } else {
            triggerBuilder_.mergeFrom(value);
          }
          if (trigger_ != null) {
            bitField0_ |= 0x00000008;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder clearTrigger() {
          bitField0_ = (bitField0_ & ~0x00000008);
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder getTriggerBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getTriggerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder
            getTriggerOrBuilder() {
          if (triggerBuilder_ != null) {
            return triggerBuilder_.getMessageOrBuilder();
          } else {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            getTriggerFieldBuilder() {
          if (triggerBuilder_ == null) {
            triggerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>(
                    getTrigger(), getParentForChildren(), isClean());
            trigger_ = null;
          }
          return triggerBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MetricAbsence> PARSER =
          new com.google.protobuf.AbstractParser<MetricAbsence>() {
            @java.lang.Override
            public MetricAbsence parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MetricAbsence> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MetricAbsence> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LogMatchOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      int getLabelExtractorsCount();
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      boolean containsLabelExtractors(java.lang.String key);
      /** Use {@link #getLabelExtractorsMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String> getLabelExtractors();
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap();
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      /* nullable */
      java.lang.String getLabelExtractorsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue);
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      java.lang.String getLabelExtractorsOrThrow(java.lang.String key);
    }
    /**
     *
     *
     * <pre>
     * A condition type that checks whether a log message in the [scoping
     * project](https://cloud.google.com/monitoring/api/v3#project_name)
     * satisfies the given filter. Logs from other projects in the metrics
     * scope are not evaluated.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.LogMatch}
     */
    public static final class LogMatch extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
        LogMatchOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use LogMatch.newBuilder() to construct.
      private LogMatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private LogMatch() {
        filter_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new LogMatch();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetLabelExtractors();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.class,
                com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder.class);
      }

      public static final int FILTER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LABEL_EXTRACTORS_FIELD_NUMBER = 2;

      private static final class LabelExtractorsDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.monitoring.v3.AlertProto
                    .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_LabelExtractorsEntry_descriptor,
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetLabelExtractors() {
        if (labelExtractors_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              LabelExtractorsDefaultEntryHolder.defaultEntry);
        }
        return labelExtractors_;
      }

      public int getLabelExtractorsCount() {
        return internalGetLabelExtractors().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public boolean containsLabelExtractors(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabelExtractors().getMap().containsKey(key);
      }
      /** Use {@link #getLabelExtractorsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
        return getLabelExtractorsMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
        return internalGetLabelExtractors().getMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getLabelExtractorsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetLabelExtractors().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetLabelExtractors().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
        }
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output,
            internalGetLabelExtractors(),
            LabelExtractorsDefaultEntryHolder.defaultEntry,
            2);
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
        }
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
            internalGetLabelExtractors().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labelExtractors__ =
              LabelExtractorsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labelExtractors__);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.LogMatch)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.LogMatch other =
            (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) obj;

        if (!getFilter().equals(other.getFilter())) return false;
        if (!internalGetLabelExtractors().equals(other.internalGetLabelExtractors())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (!internalGetLabelExtractors().getMap().isEmpty()) {
          hash = (37 * hash) + LABEL_EXTRACTORS_FIELD_NUMBER;
          hash = (53 * hash) + internalGetLabelExtractors().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that checks whether a log message in the [scoping
       * project](https://cloud.google.com/monitoring/api/v3#project_name)
       * satisfies the given filter. Logs from other projects in the metrics
       * scope are not evaluated.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.LogMatch}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
            int number) {
          switch (number) {
            case 2:
              return internalGetLabelExtractors();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor
            internalGetMutableMapFieldReflection(int number) {
          switch (number) {
            case 2:
              return internalGetMutableLabelExtractors();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          filter_ = "";
          internalGetMutableLabelExtractors().clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch build() {
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch result =
              new com.google.monitoring.v3.AlertPolicy.Condition.LogMatch(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Condition.LogMatch result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.filter_ = filter_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.labelExtractors_ = internalGetLabelExtractors();
            result.labelExtractors_.makeImmutable();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Condition.LogMatch other) {
          if (other == com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance())
            return this;
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          internalGetMutableLabelExtractors().mergeFrom(other.internalGetLabelExtractors());
          bitField0_ |= 0x00000002;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                        labelExtractors__ =
                            input.readMessage(
                                LabelExtractorsDefaultEntryHolder.defaultEntry.getParserForType(),
                                extensionRegistry);
                    internalGetMutableLabelExtractors()
                        .getMutableMap()
                        .put(labelExtractors__.getKey(), labelExtractors__.getValue());
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetLabelExtractors() {
          if (labelExtractors_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                LabelExtractorsDefaultEntryHolder.defaultEntry);
          }
          return labelExtractors_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableLabelExtractors() {
          if (labelExtractors_ == null) {
            labelExtractors_ =
                com.google.protobuf.MapField.newMapField(
                    LabelExtractorsDefaultEntryHolder.defaultEntry);
          }
          if (!labelExtractors_.isMutable()) {
            labelExtractors_ = labelExtractors_.copy();
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return labelExtractors_;
        }

        public int getLabelExtractorsCount() {
          return internalGetLabelExtractors().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public boolean containsLabelExtractors(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetLabelExtractors().getMap().containsKey(key);
        }
        /** Use {@link #getLabelExtractorsMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
          return getLabelExtractorsMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
          return internalGetLabelExtractors().getMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public /* nullable */ java.lang.String getLabelExtractorsOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetLabelExtractors().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetLabelExtractors().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public Builder clearLabelExtractors() {
          bitField0_ = (bitField0_ & ~0x00000002);
          internalGetMutableLabelExtractors().getMutableMap().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        public Builder removeLabelExtractors(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableLabelExtractors().getMutableMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getMutableLabelExtractors() {
          bitField0_ |= 0x00000002;
          return internalGetMutableLabelExtractors().getMutableMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        public Builder putLabelExtractors(java.lang.String key, java.lang.String value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableLabelExtractors().getMutableMap().put(key, value);
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        public Builder putAllLabelExtractors(
            java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableLabelExtractors().getMutableMap().putAll(values);
          bitField0_ |= 0x00000002;
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.LogMatch DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.LogMatch();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<LogMatch> PARSER =
          new com.google.protobuf.AbstractParser<LogMatch>() {
            @java.lang.Override
            public LogMatch parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<LogMatch> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<LogMatch> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MonitoringQueryLanguageConditionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      boolean hasTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder();

      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      int getEvaluationMissingDataValue();
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData();
    }
    /**
     *
     *
     * <pre>
     * A condition type that allows alerting policies to be defined using
     * [Monitoring Query Language](https://cloud.google.com/monitoring/mql).
     * </pre>
     *
     * Protobuf type {@code
     * google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition}
     */
    public static final class MonitoringQueryLanguageCondition
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
        MonitoringQueryLanguageConditionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MonitoringQueryLanguageCondition.newBuilder() to construct.
      private MonitoringQueryLanguageCondition(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MonitoringQueryLanguageCondition() {
        query_ = "";
        evaluationMissingData_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MonitoringQueryLanguageCondition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                    .class,
                com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                    .Builder.class);
      }

      private int bitField0_;
      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int TRIGGER_FIELD_NUMBER = 3;
      private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      @java.lang.Override
      public boolean hasTrigger() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }

      public static final int EVALUATION_MISSING_DATA_FIELD_NUMBER = 4;
      private int evaluationMissingData_ = 0;
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      @java.lang.Override
      public int getEvaluationMissingDataValue() {
        return evaluationMissingData_;
      }
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData() {
        com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                evaluationMissingData_);
        return result == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getDuration());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getTrigger());
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(4, evaluationMissingData_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTrigger());
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, evaluationMissingData_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition other =
            (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition) obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasTrigger() != other.hasTrigger()) return false;
        if (hasTrigger()) {
          if (!getTrigger().equals(other.getTrigger())) return false;
        }
        if (evaluationMissingData_ != other.evaluationMissingData_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasTrigger()) {
          hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
          hash = (53 * hash) + getTrigger().hashCode();
        }
        hash = (37 * hash) + EVALUATION_MISSING_DATA_FIELD_NUMBER;
        hash = (53 * hash) + evaluationMissingData_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that allows alerting policies to be defined using
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql).
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                      .class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                      .Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getDurationFieldBuilder();
            getTriggerFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          evaluationMissingData_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
            build() {
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
            buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition result =
              new com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.trigger_ = triggerBuilder_ == null ? trigger_ : triggerBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.evaluationMissingData_ = evaluationMissingData_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                  .getDefaultInstance()) return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasTrigger()) {
            mergeTrigger(other.getTrigger());
          }
          if (other.evaluationMissingData_ != 0) {
            setEvaluationMissingDataValue(other.getEvaluationMissingDataValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getTriggerFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 32:
                  {
                    evaluationMissingData_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          if (duration_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000002);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            triggerBuilder_;
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return Whether the trigger field is set.
         */
        public boolean hasTrigger() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return The trigger.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
          if (triggerBuilder_ == null) {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          } else {
            return triggerBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trigger_ = value;
          } else {
            triggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder builderForValue) {
          if (triggerBuilder_ == null) {
            trigger_ = builderForValue.build();
          } else {
            triggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder mergeTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && trigger_ != null
                && trigger_
                    != com.google.monitoring.v3.AlertPolicy.Condition.Trigger
                        .getDefaultInstance()) {
              getTriggerBuilder().mergeFrom(value);
            } else {
              trigger_ = value;
            }
          } else {
            triggerBuilder_.mergeFrom(value);
          }
          if (trigger_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder clearTrigger() {
          bitField0_ = (bitField0_ & ~0x00000004);
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder getTriggerBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getTriggerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder
            getTriggerOrBuilder() {
          if (triggerBuilder_ != null) {
            return triggerBuilder_.getMessageOrBuilder();
          } else {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            getTriggerFieldBuilder() {
          if (triggerBuilder_ == null) {
            triggerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>(
                    getTrigger(), getParentForChildren(), isClean());
            trigger_ = null;
          }
          return triggerBuilder_;
        }

        private int evaluationMissingData_ = 0;
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @return The enum numeric value on the wire for evaluationMissingData.
         */
        @java.lang.Override
        public int getEvaluationMissingDataValue() {
          return evaluationMissingData_;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @param value The enum numeric value on the wire for evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingDataValue(int value) {
          evaluationMissingData_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @return The evaluationMissingData.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
            getEvaluationMissingData() {
          com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
              com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                  evaluationMissingData_);
          return result == null
              ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @param value The evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingData(
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          evaluationMissingData_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEvaluationMissingData() {
          bitField0_ = (bitField0_ & ~0x00000008);
          evaluationMissingData_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
      private static final com.google.monitoring.v3.AlertPolicy.Condition
              .MonitoringQueryLanguageCondition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MonitoringQueryLanguageCondition> PARSER =
          new com.google.protobuf.AbstractParser<MonitoringQueryLanguageCondition>() {
            @java.lang.Override
            public MonitoringQueryLanguageCondition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MonitoringQueryLanguageCondition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MonitoringQueryLanguageCondition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PrometheusQueryLanguageConditionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the evaluationInterval field is set.
       */
      boolean hasEvaluationInterval();
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The evaluationInterval.
       */
      com.google.protobuf.Duration getEvaluationInterval();
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getEvaluationIntervalOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getLabelsCount();
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      boolean containsLabels(java.lang.String key);
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String> getLabels();
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      /* nullable */
      java.lang.String getLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue);
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.lang.String getLabelsOrThrow(java.lang.String key);

      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ruleGroup.
       */
      java.lang.String getRuleGroup();
      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for ruleGroup.
       */
      com.google.protobuf.ByteString getRuleGroupBytes();

      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alertRule.
       */
      java.lang.String getAlertRule();
      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alertRule.
       */
      com.google.protobuf.ByteString getAlertRuleBytes();

      /**
       *
       *
       * <pre>
       * Optional. Whether to disable metric existence validation for this
       * condition.
       *
       * This allows alerting policies to be defined on metrics that do not yet
       * exist, improving advanced customer workflows such as configuring
       * alerting policies using Terraform.
       *
       * Users with the `monitoring.alertPolicyViewer` role are able to see the
       * name of the non-existent metric in the alerting policy condition.
       * </pre>
       *
       * <code>bool disable_metric_validation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The disableMetricValidation.
       */
      boolean getDisableMetricValidation();
    }
    /**
     *
     *
     * <pre>
     * A condition type that allows alerting policies to be defined using
     * [Prometheus Query Language
     * (PromQL)](https://prometheus.io/docs/prometheus/latest/querying/basics/).
     *
     * The PrometheusQueryLanguageCondition message contains information
     * from a Prometheus alerting rule and its associated rule group.
     *
     * A Prometheus alerting rule is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/).
     * The semantics of a Prometheus alerting rule is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule).
     *
     * A Prometheus rule group is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/).
     * The semantics of a Prometheus rule group is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule_group).
     *
     * Because Cloud Alerting has no representation of a Prometheus rule
     * group resource, we must embed the information of the parent rule
     * group inside each of the conditions that refer to it. We must also
     * update the contents of all Prometheus alerts in case the information
     * of their rule group changes.
     *
     * The PrometheusQueryLanguageCondition protocol buffer combines the
     * information of the corresponding rule group and alerting rule.
     * The structure of the PrometheusQueryLanguageCondition protocol buffer
     * does NOT mimic the structure of the Prometheus rule group and alerting
     * rule YAML declarations. The PrometheusQueryLanguageCondition protocol
     * buffer may change in the future to support future rule group and/or
     * alerting rule features. There are no new such features at the present
     * time (2023-06-26).
     * </pre>
     *
     * Protobuf type {@code
     * google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition}
     */
    public static final class PrometheusQueryLanguageCondition
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
        PrometheusQueryLanguageConditionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use PrometheusQueryLanguageCondition.newBuilder() to construct.
      private PrometheusQueryLanguageCondition(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PrometheusQueryLanguageCondition() {
        query_ = "";
        ruleGroup_ = "";
        alertRule_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PrometheusQueryLanguageCondition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                    .class,
                com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                    .Builder.class);
      }

      private int bitField0_;
      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int EVALUATION_INTERVAL_FIELD_NUMBER = 3;
      private com.google.protobuf.Duration evaluationInterval_;
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the evaluationInterval field is set.
       */
      @java.lang.Override
      public boolean hasEvaluationInterval() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The evaluationInterval.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getEvaluationInterval() {
        return evaluationInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : evaluationInterval_;
      }
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getEvaluationIntervalOrBuilder() {
        return evaluationInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : evaluationInterval_;
      }

      public static final int LABELS_FIELD_NUMBER = 4;

      private static final class LabelsDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.monitoring.v3.AlertProto
                    .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_LabelsEntry_descriptor,
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
        if (labels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return labels_;
      }

      public int getLabelsCount() {
        return internalGetLabels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabels().getMap().containsKey(key);
      }
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return getLabelsMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
        return internalGetLabels().getMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public static final int RULE_GROUP_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object ruleGroup_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ruleGroup.
       */
      @java.lang.Override
      public java.lang.String getRuleGroup() {
        java.lang.Object ref = ruleGroup_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ruleGroup_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for ruleGroup.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRuleGroupBytes() {
        java.lang.Object ref = ruleGroup_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ruleGroup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ALERT_RULE_FIELD_NUMBER = 6;

      @SuppressWarnings("serial")
      private volatile java.lang.Object alertRule_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alertRule.
       */
      @java.lang.Override
      public java.lang.String getAlertRule() {
        java.lang.Object ref = alertRule_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alertRule_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alertRule.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAlertRuleBytes() {
        java.lang.Object ref = alertRule_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          alertRule_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DISABLE_METRIC_VALIDATION_FIELD_NUMBER = 7;
      private boolean disableMetricValidation_ = false;
      /**
       *
       *
       * <pre>
       * Optional. Whether to disable metric existence validation for this
       * condition.
       *
       * This allows alerting policies to be defined on metrics that do not yet
       * exist, improving advanced customer workflows such as configuring
       * alerting policies using Terraform.
       *
       * Users with the `monitoring.alertPolicyViewer` role are able to see the
       * name of the non-existent metric in the alerting policy condition.
       * </pre>
       *
       * <code>bool disable_metric_validation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The disableMetricValidation.
       */
      @java.lang.Override
      public boolean getDisableMetricValidation() {
        return disableMetricValidation_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getDuration());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getEvaluationInterval());
        }
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleGroup_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, ruleGroup_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alertRule_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 6, alertRule_);
        }
        if (disableMetricValidation_ != false) {
          output.writeBool(7, disableMetricValidation_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEvaluationInterval());
        }
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
            internalGetLabels().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
              LabelsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleGroup_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, ruleGroup_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alertRule_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, alertRule_);
        }
        if (disableMetricValidation_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(7, disableMetricValidation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition other =
            (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition) obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasEvaluationInterval() != other.hasEvaluationInterval()) return false;
        if (hasEvaluationInterval()) {
          if (!getEvaluationInterval().equals(other.getEvaluationInterval())) return false;
        }
        if (!internalGetLabels().equals(other.internalGetLabels())) return false;
        if (!getRuleGroup().equals(other.getRuleGroup())) return false;
        if (!getAlertRule().equals(other.getAlertRule())) return false;
        if (getDisableMetricValidation() != other.getDisableMetricValidation()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasEvaluationInterval()) {
          hash = (37 * hash) + EVALUATION_INTERVAL_FIELD_NUMBER;
          hash = (53 * hash) + getEvaluationInterval().hashCode();
        }
        if (!internalGetLabels().getMap().isEmpty()) {
          hash = (37 * hash) + LABELS_FIELD_NUMBER;
          hash = (53 * hash) + internalGetLabels().hashCode();
        }
        hash = (37 * hash) + RULE_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getRuleGroup().hashCode();
        hash = (37 * hash) + ALERT_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getAlertRule().hashCode();
        hash = (37 * hash) + DISABLE_METRIC_VALIDATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableMetricValidation());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that allows alerting policies to be defined using
       * [Prometheus Query Language
       * (PromQL)](https://prometheus.io/docs/prometheus/latest/querying/basics/).
       *
       * The PrometheusQueryLanguageCondition message contains information
       * from a Prometheus alerting rule and its associated rule group.
       *
       * A Prometheus alerting rule is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/).
       * The semantics of a Prometheus alerting rule is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule).
       *
       * A Prometheus rule group is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/).
       * The semantics of a Prometheus rule group is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule_group).
       *
       * Because Cloud Alerting has no representation of a Prometheus rule
       * group resource, we must embed the information of the parent rule
       * group inside each of the conditions that refer to it. We must also
       * update the contents of all Prometheus alerts in case the information
       * of their rule group changes.
       *
       * The PrometheusQueryLanguageCondition protocol buffer combines the
       * information of the corresponding rule group and alerting rule.
       * The structure of the PrometheusQueryLanguageCondition protocol buffer
       * does NOT mimic the structure of the Prometheus rule group and alerting
       * rule YAML declarations. The PrometheusQueryLanguageCondition protocol
       * buffer may change in the future to support future rule group and/or
       * alerting rule features. There are no new such features at the present
       * time (2023-06-26).
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
            int number) {
          switch (number) {
            case 4:
              return internalGetLabels();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor
            internalGetMutableMapFieldReflection(int number) {
          switch (number) {
            case 4:
              return internalGetMutableLabels();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                      .class,
                  com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                      .Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getDurationFieldBuilder();
            getEvaluationIntervalFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          evaluationInterval_ = null;
          if (evaluationIntervalBuilder_ != null) {
            evaluationIntervalBuilder_.dispose();
            evaluationIntervalBuilder_ = null;
          }
          internalGetMutableLabels().clear();
          ruleGroup_ = "";
          alertRule_ = "";
          disableMetricValidation_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
            build() {
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
            buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition result =
              new com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.evaluationInterval_ =
                evaluationIntervalBuilder_ == null
                    ? evaluationInterval_
                    : evaluationIntervalBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.labels_ = internalGetLabels();
            result.labels_.makeImmutable();
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.ruleGroup_ = ruleGroup_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.alertRule_ = alertRule_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.disableMetricValidation_ = disableMetricValidation_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                  .getDefaultInstance()) return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasEvaluationInterval()) {
            mergeEvaluationInterval(other.getEvaluationInterval());
          }
          internalGetMutableLabels().mergeFrom(other.internalGetLabels());
          bitField0_ |= 0x00000008;
          if (!other.getRuleGroup().isEmpty()) {
            ruleGroup_ = other.ruleGroup_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          if (!other.getAlertRule().isEmpty()) {
            alertRule_ = other.alertRule_;
            bitField0_ |= 0x00000020;
            onChanged();
          }
          if (other.getDisableMetricValidation() != false) {
            setDisableMetricValidation(other.getDisableMetricValidation());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getEvaluationIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                        input.readMessage(
                            LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                    internalGetMutableLabels()
                        .getMutableMap()
                        .put(labels__.getKey(), labels__.getValue());
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    ruleGroup_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                case 50:
                  {
                    alertRule_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 50
                case 56:
                  {
                    disableMetricValidation_ = input.readBool();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 56
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          if (duration_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000002);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.protobuf.Duration evaluationInterval_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            evaluationIntervalBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the evaluationInterval field is set.
         */
        public boolean hasEvaluationInterval() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The evaluationInterval.
         */
        public com.google.protobuf.Duration getEvaluationInterval() {
          if (evaluationIntervalBuilder_ == null) {
            return evaluationInterval_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : evaluationInterval_;
          } else {
            return evaluationIntervalBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEvaluationInterval(com.google.protobuf.Duration value) {
          if (evaluationIntervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            evaluationInterval_ = value;
          } else {
            evaluationIntervalBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEvaluationInterval(com.google.protobuf.Duration.Builder builderForValue) {
          if (evaluationIntervalBuilder_ == null) {
            evaluationInterval_ = builderForValue.build();
          } else {
            evaluationIntervalBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeEvaluationInterval(com.google.protobuf.Duration value) {
          if (evaluationIntervalBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && evaluationInterval_ != null
                && evaluationInterval_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getEvaluationIntervalBuilder().mergeFrom(value);
            } else {
              evaluationInterval_ = value;
            }
          } else {
            evaluationIntervalBuilder_.mergeFrom(value);
          }
          if (evaluationInterval_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearEvaluationInterval() {
          bitField0_ = (bitField0_ & ~0x00000004);
          evaluationInterval_ = null;
          if (evaluationIntervalBuilder_ != null) {
            evaluationIntervalBuilder_.dispose();
            evaluationIntervalBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getEvaluationIntervalBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getEvaluationIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getEvaluationIntervalOrBuilder() {
          if (evaluationIntervalBuilder_ != null) {
            return evaluationIntervalBuilder_.getMessageOrBuilder();
          } else {
            return evaluationInterval_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : evaluationInterval_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getEvaluationIntervalFieldBuilder() {
          if (evaluationIntervalBuilder_ == null) {
            evaluationIntervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getEvaluationInterval(), getParentForChildren(), isClean());
            evaluationInterval_ = null;
          }
          return evaluationIntervalBuilder_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetLabels() {
          if (labels_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                LabelsDefaultEntryHolder.defaultEntry);
          }
          return labels_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableLabels() {
          if (labels_ == null) {
            labels_ =
                com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
          }
          if (!labels_.isMutable()) {
            labels_ = labels_.copy();
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return labels_;
        }

        public int getLabelsCount() {
          return internalGetLabels().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public boolean containsLabels(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetLabels().getMap().containsKey(key);
        }
        /** Use {@link #getLabelsMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getLabels() {
          return getLabelsMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
          return internalGetLabels().getMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public /* nullable */ java.lang.String getLabelsOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public java.lang.String getLabelsOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public Builder clearLabels() {
          bitField0_ = (bitField0_ & ~0x00000008);
          internalGetMutableLabels().getMutableMap().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeLabels(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableLabels().getMutableMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
          bitField0_ |= 0x00000008;
          return internalGetMutableLabels().getMutableMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder putLabels(java.lang.String key, java.lang.String value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableLabels().getMutableMap().put(key, value);
          bitField0_ |= 0x00000008;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableLabels().getMutableMap().putAll(values);
          bitField0_ |= 0x00000008;
          return this;
        }

        private java.lang.Object ruleGroup_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The ruleGroup.
         */
        public java.lang.String getRuleGroup() {
          java.lang.Object ref = ruleGroup_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            ruleGroup_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for ruleGroup.
         */
        public com.google.protobuf.ByteString getRuleGroupBytes() {
          java.lang.Object ref = ruleGroup_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            ruleGroup_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The ruleGroup to set.
         * @return This builder for chaining.
         */
        public Builder setRuleGroup(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ruleGroup_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRuleGroup() {
          ruleGroup_ = getDefaultInstance().getRuleGroup();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for ruleGroup to set.
         * @return This builder for chaining.
         */
        public Builder setRuleGroupBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ruleGroup_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private java.lang.Object alertRule_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The alertRule.
         */
        public java.lang.String getAlertRule() {
          java.lang.Object ref = alertRule_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            alertRule_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for alertRule.
         */
        public com.google.protobuf.ByteString getAlertRuleBytes() {
          java.lang.Object ref = alertRule_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            alertRule_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The alertRule to set.
         * @return This builder for chaining.
         */
        public Builder setAlertRule(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          alertRule_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAlertRule() {
          alertRule_ = getDefaultInstance().getAlertRule();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for alertRule to set.
         * @return This builder for chaining.
         */
        public Builder setAlertRuleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          alertRule_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        private boolean disableMetricValidation_;
        /**
         *
         *
         * <pre>
         * Optional. Whether to disable metric existence validation for this
         * condition.
         *
         * This allows alerting policies to be defined on metrics that do not yet
         * exist, improving advanced customer workflows such as configuring
         * alerting policies using Terraform.
         *
         * Users with the `monitoring.alertPolicyViewer` role are able to see the
         * name of the non-existent metric in the alerting policy condition.
         * </pre>
         *
         * <code>bool disable_metric_validation = 7 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The disableMetricValidation.
         */
        @java.lang.Override
        public boolean getDisableMetricValidation() {
          return disableMetricValidation_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Whether to disable metric existence validation for this
         * condition.
         *
         * This allows alerting policies to be defined on metrics that do not yet
         * exist, improving advanced customer workflows such as configuring
         * alerting policies using Terraform.
         *
         * Users with the `monitoring.alertPolicyViewer` role are able to see the
         * name of the non-existent metric in the alerting policy condition.
         * </pre>
         *
         * <code>bool disable_metric_validation = 7 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The disableMetricValidation to set.
         * @return This builder for chaining.
         */
        public Builder setDisableMetricValidation(boolean value) {

          disableMetricValidation_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Whether to disable metric existence validation for this
         * condition.
         *
         * This allows alerting policies to be defined on metrics that do not yet
         * exist, improving advanced customer workflows such as configuring
         * alerting policies using Terraform.
         *
         * Users with the `monitoring.alertPolicyViewer` role are able to see the
         * name of the non-existent metric in the alerting policy condition.
         * </pre>
         *
         * <code>bool disable_metric_validation = 7 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisableMetricValidation() {
          bitField0_ = (bitField0_ & ~0x00000040);
          disableMetricValidation_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
      private static final com.google.monitoring.v3.AlertPolicy.Condition
              .PrometheusQueryLanguageCondition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PrometheusQueryLanguageCondition> PARSER =
          new com.google.protobuf.AbstractParser<PrometheusQueryLanguageCondition>() {
            @java.lang.Override
            public PrometheusQueryLanguageCondition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PrometheusQueryLanguageCondition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PrometheusQueryLanguageCondition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SqlConditionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.SqlCondition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The Log Analytics SQL query to run, as a string.  The query
       * must conform to the required shape. Specifically, the query must not
       * try to filter the input by time.  A filter will automatically be
       * applied to filter the input so that the query receives all rows
       * received since the last time the query was run.
       *
       * For example, the following query extracts all log entries containing an
       * HTTP request:
       *
       *     SELECT
       *       timestamp, log_name, severity, http_request, resource, labels
       *     FROM
       *       my-project.global._Default._AllLogs
       *     WHERE
       *       http_request IS NOT NULL
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * Required. The Log Analytics SQL query to run, as a string.  The query
       * must conform to the required shape. Specifically, the query must not
       * try to filter the input by time.  A filter will automatically be
       * applied to filter the input so that the query receives all rows
       * received since the last time the query was run.
       *
       * For example, the following query extracts all log entries containing an
       * HTTP request:
       *
       *     SELECT
       *       timestamp, log_name, severity, http_request, resource, labels
       *     FROM
       *       my-project.global._Default._AllLogs
       *     WHERE
       *       http_request IS NOT NULL
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many minutes.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
       *
       * @return Whether the minutes field is set.
       */
      boolean hasMinutes();
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many minutes.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
       *
       * @return The minutes.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes getMinutes();
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many minutes.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder
          getMinutesOrBuilder();

      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many hours.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
       *
       * @return Whether the hourly field is set.
       */
      boolean hasHourly();
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many hours.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
       *
       * @return The hourly.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly getHourly();
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many hours.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder
          getHourlyOrBuilder();

      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many days.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
       *
       * @return Whether the daily field is set.
       */
      boolean hasDaily();
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many days.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
       *
       * @return The daily.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily getDaily();
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many days.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder
          getDailyOrBuilder();

      /**
       *
       *
       * <pre>
       * Test the row count against a threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
       * </code>
       *
       * @return Whether the rowCountTest field is set.
       */
      boolean hasRowCountTest();
      /**
       *
       *
       * <pre>
       * Test the row count against a threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
       * </code>
       *
       * @return The rowCountTest.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest getRowCountTest();
      /**
       *
       *
       * <pre>
       * Test the row count against a threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
       * </code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTestOrBuilder
          getRowCountTestOrBuilder();

      /**
       *
       *
       * <pre>
       * Test the boolean value in the indicated column.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
       * </code>
       *
       * @return Whether the booleanTest field is set.
       */
      boolean hasBooleanTest();
      /**
       *
       *
       * <pre>
       * Test the boolean value in the indicated column.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
       * </code>
       *
       * @return The booleanTest.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest getBooleanTest();
      /**
       *
       *
       * <pre>
       * Test the boolean value in the indicated column.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
       * </code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTestOrBuilder
          getBooleanTestOrBuilder();

      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.ScheduleCase getScheduleCase();

      com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.EvaluateCase getEvaluateCase();
    }
    /**
     *
     *
     * <pre>
     * A condition that allows alerting policies to be defined using GoogleSQL.
     * SQL conditions examine a sliding window of logs using GoogleSQL.
     * Alert policies with SQL conditions may incur additional billing.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition}
     */
    public static final class SqlCondition extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition)
        SqlConditionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SqlCondition.newBuilder() to construct.
      private SqlCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SqlCondition() {
        query_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SqlCondition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.class,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Builder.class);
      }

      public interface MinutesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Number of minutes between runs. The interval must be
         * greater than or equal to 5 minutes and less than or equal to 1440
         * minutes.
         * </pre>
         *
         * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The periodicity.
         */
        int getPeriodicity();
      }
      /**
       *
       *
       * <pre>
       * Used to schedule the query to run every so many minutes.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes}
       */
      public static final class Minutes extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
          MinutesOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Minutes.newBuilder() to construct.
        private Minutes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Minutes() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Minutes();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Minutes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Minutes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder
                      .class);
        }

        public static final int PERIODICITY_FIELD_NUMBER = 1;
        private int periodicity_ = 0;
        /**
         *
         *
         * <pre>
         * Required. Number of minutes between runs. The interval must be
         * greater than or equal to 5 minutes and less than or equal to 1440
         * minutes.
         * </pre>
         *
         * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The periodicity.
         */
        @java.lang.Override
        public int getPeriodicity() {
          return periodicity_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (periodicity_ != 0) {
            output.writeInt32(1, periodicity_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (periodicity_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, periodicity_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes other =
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) obj;

          if (getPeriodicity() != other.getPeriodicity()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + PERIODICITY_FIELD_NUMBER;
          hash = (53 * hash) + getPeriodicity();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Used to schedule the query to run every so many minutes.
         * </pre>
         *
         * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Minutes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Minutes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.class,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder
                        .class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            periodicity_ = 0;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Minutes_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes build() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
              buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes result =
                new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.periodicity_ = periodicity_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                    .getDefaultInstance()) return this;
            if (other.getPeriodicity() != 0) {
              setPeriodicity(other.getPeriodicity());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      periodicity_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int periodicity_;
          /**
           *
           *
           * <pre>
           * Required. Number of minutes between runs. The interval must be
           * greater than or equal to 5 minutes and less than or equal to 1440
           * minutes.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The periodicity.
           */
          @java.lang.Override
          public int getPeriodicity() {
            return periodicity_;
          }
          /**
           *
           *
           * <pre>
           * Required. Number of minutes between runs. The interval must be
           * greater than or equal to 5 minutes and less than or equal to 1440
           * minutes.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The periodicity to set.
           * @return This builder for chaining.
           */
          public Builder setPeriodicity(int value) {

            periodicity_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Number of minutes between runs. The interval must be
           * greater than or equal to 5 minutes and less than or equal to 1440
           * minutes.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPeriodicity() {
            bitField0_ = (bitField0_ & ~0x00000001);
            periodicity_ = 0;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Minutes> PARSER =
            new com.google.protobuf.AbstractParser<Minutes>() {
              @java.lang.Override
              public Minutes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Minutes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Minutes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface HourlyOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The number of hours between runs. Must be greater than or
         * equal to 1 hour and less than or equal to 48 hours.
         * </pre>
         *
         * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The periodicity.
         */
        int getPeriodicity();

        /**
         *
         *
         * <pre>
         * Optional. The number of minutes after the hour (in UTC) to run the
         * query. Must be greater than or equal to 0 minutes and less than or
         * equal to 59 minutes.  If left unspecified, then an arbitrary offset
         * is used.
         * </pre>
         *
         * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return Whether the minuteOffset field is set.
         */
        boolean hasMinuteOffset();
        /**
         *
         *
         * <pre>
         * Optional. The number of minutes after the hour (in UTC) to run the
         * query. Must be greater than or equal to 0 minutes and less than or
         * equal to 59 minutes.  If left unspecified, then an arbitrary offset
         * is used.
         * </pre>
         *
         * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The minuteOffset.
         */
        int getMinuteOffset();
      }
      /**
       *
       *
       * <pre>
       * Used to schedule the query to run every so many hours.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly}
       */
      public static final class Hourly extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)
          HourlyOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Hourly.newBuilder() to construct.
        private Hourly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Hourly() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Hourly();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Hourly_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Hourly_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder.class);
        }

        private int bitField0_;
        public static final int PERIODICITY_FIELD_NUMBER = 1;
        private int periodicity_ = 0;
        /**
         *
         *
         * <pre>
         * Required. The number of hours between runs. Must be greater than or
         * equal to 1 hour and less than or equal to 48 hours.
         * </pre>
         *
         * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The periodicity.
         */
        @java.lang.Override
        public int getPeriodicity() {
          return periodicity_;
        }

        public static final int MINUTE_OFFSET_FIELD_NUMBER = 2;
        private int minuteOffset_ = 0;
        /**
         *
         *
         * <pre>
         * Optional. The number of minutes after the hour (in UTC) to run the
         * query. Must be greater than or equal to 0 minutes and less than or
         * equal to 59 minutes.  If left unspecified, then an arbitrary offset
         * is used.
         * </pre>
         *
         * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return Whether the minuteOffset field is set.
         */
        @java.lang.Override
        public boolean hasMinuteOffset() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The number of minutes after the hour (in UTC) to run the
         * query. Must be greater than or equal to 0 minutes and less than or
         * equal to 59 minutes.  If left unspecified, then an arbitrary offset
         * is used.
         * </pre>
         *
         * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The minuteOffset.
         */
        @java.lang.Override
        public int getMinuteOffset() {
          return minuteOffset_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (periodicity_ != 0) {
            output.writeInt32(1, periodicity_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeInt32(2, minuteOffset_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (periodicity_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, periodicity_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, minuteOffset_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly other =
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) obj;

          if (getPeriodicity() != other.getPeriodicity()) return false;
          if (hasMinuteOffset() != other.hasMinuteOffset()) return false;
          if (hasMinuteOffset()) {
            if (getMinuteOffset() != other.getMinuteOffset()) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + PERIODICITY_FIELD_NUMBER;
          hash = (53 * hash) + getPeriodicity();
          if (hasMinuteOffset()) {
            hash = (37 * hash) + MINUTE_OFFSET_FIELD_NUMBER;
            hash = (53 * hash) + getMinuteOffset();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Used to schedule the query to run every so many hours.
         * </pre>
         *
         * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Hourly_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Hourly_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.class,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder
                        .class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            periodicity_ = 0;
            minuteOffset_ = 0;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Hourly_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly build() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly result =
                new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.periodicity_ = periodicity_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.minuteOffset_ = minuteOffset_;
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                    .getDefaultInstance()) return this;
            if (other.getPeriodicity() != 0) {
              setPeriodicity(other.getPeriodicity());
            }
            if (other.hasMinuteOffset()) {
              setMinuteOffset(other.getMinuteOffset());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      periodicity_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 16:
                    {
                      minuteOffset_ = input.readInt32();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int periodicity_;
          /**
           *
           *
           * <pre>
           * Required. The number of hours between runs. Must be greater than or
           * equal to 1 hour and less than or equal to 48 hours.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The periodicity.
           */
          @java.lang.Override
          public int getPeriodicity() {
            return periodicity_;
          }
          /**
           *
           *
           * <pre>
           * Required. The number of hours between runs. Must be greater than or
           * equal to 1 hour and less than or equal to 48 hours.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The periodicity to set.
           * @return This builder for chaining.
           */
          public Builder setPeriodicity(int value) {

            periodicity_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The number of hours between runs. Must be greater than or
           * equal to 1 hour and less than or equal to 48 hours.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPeriodicity() {
            bitField0_ = (bitField0_ & ~0x00000001);
            periodicity_ = 0;
            onChanged();
            return this;
          }

          private int minuteOffset_;
          /**
           *
           *
           * <pre>
           * Optional. The number of minutes after the hour (in UTC) to run the
           * query. Must be greater than or equal to 0 minutes and less than or
           * equal to 59 minutes.  If left unspecified, then an arbitrary offset
           * is used.
           * </pre>
           *
           * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the minuteOffset field is set.
           */
          @java.lang.Override
          public boolean hasMinuteOffset() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * Optional. The number of minutes after the hour (in UTC) to run the
           * query. Must be greater than or equal to 0 minutes and less than or
           * equal to 59 minutes.  If left unspecified, then an arbitrary offset
           * is used.
           * </pre>
           *
           * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The minuteOffset.
           */
          @java.lang.Override
          public int getMinuteOffset() {
            return minuteOffset_;
          }
          /**
           *
           *
           * <pre>
           * Optional. The number of minutes after the hour (in UTC) to run the
           * query. Must be greater than or equal to 0 minutes and less than or
           * equal to 59 minutes.  If left unspecified, then an arbitrary offset
           * is used.
           * </pre>
           *
           * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The minuteOffset to set.
           * @return This builder for chaining.
           */
          public Builder setMinuteOffset(int value) {

            minuteOffset_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The number of minutes after the hour (in UTC) to run the
           * query. Must be greater than or equal to 0 minutes and less than or
           * equal to 59 minutes.  If left unspecified, then an arbitrary offset
           * is used.
           * </pre>
           *
           * <code>optional int32 minute_offset = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMinuteOffset() {
            bitField0_ = (bitField0_ & ~0x00000002);
            minuteOffset_ = 0;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Hourly> PARSER =
            new com.google.protobuf.AbstractParser<Hourly>() {
              @java.lang.Override
              public Hourly parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Hourly> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Hourly> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface DailyOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The number of days between runs. Must be greater than or
         * equal to 1 day and less than or equal to 31 days.
         * </pre>
         *
         * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The periodicity.
         */
        int getPeriodicity();

        /**
         *
         *
         * <pre>
         * Optional. The time of day (in UTC) at which the query should run. If
         * left unspecified, the server picks an arbitrary time of day and runs
         * the query at the same time each day.
         * </pre>
         *
         * <code>
         * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the executionTime field is set.
         */
        boolean hasExecutionTime();
        /**
         *
         *
         * <pre>
         * Optional. The time of day (in UTC) at which the query should run. If
         * left unspecified, the server picks an arbitrary time of day and runs
         * the query at the same time each day.
         * </pre>
         *
         * <code>
         * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The executionTime.
         */
        com.google.type.TimeOfDay getExecutionTime();
        /**
         *
         *
         * <pre>
         * Optional. The time of day (in UTC) at which the query should run. If
         * left unspecified, the server picks an arbitrary time of day and runs
         * the query at the same time each day.
         * </pre>
         *
         * <code>
         * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.type.TimeOfDayOrBuilder getExecutionTimeOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Used to schedule the query to run every so many days.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily}
       */
      public static final class Daily extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)
          DailyOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Daily.newBuilder() to construct.
        private Daily(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Daily() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Daily();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Daily_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Daily_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder.class);
        }

        private int bitField0_;
        public static final int PERIODICITY_FIELD_NUMBER = 1;
        private int periodicity_ = 0;
        /**
         *
         *
         * <pre>
         * Required. The number of days between runs. Must be greater than or
         * equal to 1 day and less than or equal to 31 days.
         * </pre>
         *
         * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The periodicity.
         */
        @java.lang.Override
        public int getPeriodicity() {
          return periodicity_;
        }

        public static final int EXECUTION_TIME_FIELD_NUMBER = 2;
        private com.google.type.TimeOfDay executionTime_;
        /**
         *
         *
         * <pre>
         * Optional. The time of day (in UTC) at which the query should run. If
         * left unspecified, the server picks an arbitrary time of day and runs
         * the query at the same time each day.
         * </pre>
         *
         * <code>
         * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the executionTime field is set.
         */
        @java.lang.Override
        public boolean hasExecutionTime() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The time of day (in UTC) at which the query should run. If
         * left unspecified, the server picks an arbitrary time of day and runs
         * the query at the same time each day.
         * </pre>
         *
         * <code>
         * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The executionTime.
         */
        @java.lang.Override
        public com.google.type.TimeOfDay getExecutionTime() {
          return executionTime_ == null
              ? com.google.type.TimeOfDay.getDefaultInstance()
              : executionTime_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The time of day (in UTC) at which the query should run. If
         * left unspecified, the server picks an arbitrary time of day and runs
         * the query at the same time each day.
         * </pre>
         *
         * <code>
         * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.type.TimeOfDayOrBuilder getExecutionTimeOrBuilder() {
          return executionTime_ == null
              ? com.google.type.TimeOfDay.getDefaultInstance()
              : executionTime_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (periodicity_ != 0) {
            output.writeInt32(1, periodicity_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(2, getExecutionTime());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (periodicity_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, periodicity_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExecutionTime());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily other =
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) obj;

          if (getPeriodicity() != other.getPeriodicity()) return false;
          if (hasExecutionTime() != other.hasExecutionTime()) return false;
          if (hasExecutionTime()) {
            if (!getExecutionTime().equals(other.getExecutionTime())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + PERIODICITY_FIELD_NUMBER;
          hash = (53 * hash) + getPeriodicity();
          if (hasExecutionTime()) {
            hash = (37 * hash) + EXECUTION_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getExecutionTime().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Used to schedule the query to run every so many days.
         * </pre>
         *
         * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Daily_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Daily_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.class,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder
                        .class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getExecutionTimeFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            periodicity_ = 0;
            executionTime_ = null;
            if (executionTimeBuilder_ != null) {
              executionTimeBuilder_.dispose();
              executionTimeBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_Daily_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily build() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily result =
                new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.periodicity_ = periodicity_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.executionTime_ =
                  executionTimeBuilder_ == null ? executionTime_ : executionTimeBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                    .getDefaultInstance()) return this;
            if (other.getPeriodicity() != 0) {
              setPeriodicity(other.getPeriodicity());
            }
            if (other.hasExecutionTime()) {
              mergeExecutionTime(other.getExecutionTime());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      periodicity_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 18:
                    {
                      input.readMessage(
                          getExecutionTimeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int periodicity_;
          /**
           *
           *
           * <pre>
           * Required. The number of days between runs. Must be greater than or
           * equal to 1 day and less than or equal to 31 days.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The periodicity.
           */
          @java.lang.Override
          public int getPeriodicity() {
            return periodicity_;
          }
          /**
           *
           *
           * <pre>
           * Required. The number of days between runs. Must be greater than or
           * equal to 1 day and less than or equal to 31 days.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The periodicity to set.
           * @return This builder for chaining.
           */
          public Builder setPeriodicity(int value) {

            periodicity_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The number of days between runs. Must be greater than or
           * equal to 1 day and less than or equal to 31 days.
           * </pre>
           *
           * <code>int32 periodicity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPeriodicity() {
            bitField0_ = (bitField0_ & ~0x00000001);
            periodicity_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.TimeOfDay executionTime_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.TimeOfDay,
                  com.google.type.TimeOfDay.Builder,
                  com.google.type.TimeOfDayOrBuilder>
              executionTimeBuilder_;
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the executionTime field is set.
           */
          public boolean hasExecutionTime() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The executionTime.
           */
          public com.google.type.TimeOfDay getExecutionTime() {
            if (executionTimeBuilder_ == null) {
              return executionTime_ == null
                  ? com.google.type.TimeOfDay.getDefaultInstance()
                  : executionTime_;
            } else {
              return executionTimeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setExecutionTime(com.google.type.TimeOfDay value) {
            if (executionTimeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              executionTime_ = value;
            } else {
              executionTimeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setExecutionTime(com.google.type.TimeOfDay.Builder builderForValue) {
            if (executionTimeBuilder_ == null) {
              executionTime_ = builderForValue.build();
            } else {
              executionTimeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder mergeExecutionTime(com.google.type.TimeOfDay value) {
            if (executionTimeBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0)
                  && executionTime_ != null
                  && executionTime_ != com.google.type.TimeOfDay.getDefaultInstance()) {
                getExecutionTimeBuilder().mergeFrom(value);
              } else {
                executionTime_ = value;
              }
            } else {
              executionTimeBuilder_.mergeFrom(value);
            }
            if (executionTime_ != null) {
              bitField0_ |= 0x00000002;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder clearExecutionTime() {
            bitField0_ = (bitField0_ & ~0x00000002);
            executionTime_ = null;
            if (executionTimeBuilder_ != null) {
              executionTimeBuilder_.dispose();
              executionTimeBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.TimeOfDay.Builder getExecutionTimeBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getExecutionTimeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.TimeOfDayOrBuilder getExecutionTimeOrBuilder() {
            if (executionTimeBuilder_ != null) {
              return executionTimeBuilder_.getMessageOrBuilder();
            } else {
              return executionTime_ == null
                  ? com.google.type.TimeOfDay.getDefaultInstance()
                  : executionTime_;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The time of day (in UTC) at which the query should run. If
           * left unspecified, the server picks an arbitrary time of day and runs
           * the query at the same time each day.
           * </pre>
           *
           * <code>
           * .google.type.TimeOfDay execution_time = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.TimeOfDay,
                  com.google.type.TimeOfDay.Builder,
                  com.google.type.TimeOfDayOrBuilder>
              getExecutionTimeFieldBuilder() {
            if (executionTimeBuilder_ == null) {
              executionTimeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.TimeOfDay,
                      com.google.type.TimeOfDay.Builder,
                      com.google.type.TimeOfDayOrBuilder>(
                      getExecutionTime(), getParentForChildren(), isClean());
              executionTime_ = null;
            }
            return executionTimeBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Daily> PARSER =
            new com.google.protobuf.AbstractParser<Daily>() {
              @java.lang.Override
              public Daily parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Daily> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Daily> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface RowCountTestOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The comparison to apply between the number of rows returned
         * by the query and the threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for comparison.
         */
        int getComparisonValue();
        /**
         *
         *
         * <pre>
         * Required. The comparison to apply between the number of rows returned
         * by the query and the threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The comparison.
         */
        com.google.monitoring.v3.ComparisonType getComparison();

        /**
         *
         *
         * <pre>
         * Required. The value against which to compare the row count.
         * </pre>
         *
         * <code>int64 threshold = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The threshold.
         */
        long getThreshold();
      }
      /**
       *
       *
       * <pre>
       * A test that checks if the number of rows in the result set
       * violates some threshold.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest}
       */
      public static final class RowCountTest extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
          RowCountTestOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use RowCountTest.newBuilder() to construct.
        private RowCountTest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private RowCountTest() {
          comparison_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new RowCountTest();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_RowCountTest_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_RowCountTest_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.Builder
                      .class);
        }

        public static final int COMPARISON_FIELD_NUMBER = 1;
        private int comparison_ = 0;
        /**
         *
         *
         * <pre>
         * Required. The comparison to apply between the number of rows returned
         * by the query and the threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for comparison.
         */
        @java.lang.Override
        public int getComparisonValue() {
          return comparison_;
        }
        /**
         *
         *
         * <pre>
         * Required. The comparison to apply between the number of rows returned
         * by the query and the threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The comparison.
         */
        @java.lang.Override
        public com.google.monitoring.v3.ComparisonType getComparison() {
          com.google.monitoring.v3.ComparisonType result =
              com.google.monitoring.v3.ComparisonType.forNumber(comparison_);
          return result == null ? com.google.monitoring.v3.ComparisonType.UNRECOGNIZED : result;
        }

        public static final int THRESHOLD_FIELD_NUMBER = 2;
        private long threshold_ = 0L;
        /**
         *
         *
         * <pre>
         * Required. The value against which to compare the row count.
         * </pre>
         *
         * <code>int64 threshold = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The threshold.
         */
        @java.lang.Override
        public long getThreshold() {
          return threshold_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (comparison_
              != com.google.monitoring.v3.ComparisonType.COMPARISON_UNSPECIFIED.getNumber()) {
            output.writeEnum(1, comparison_);
          }
          if (threshold_ != 0L) {
            output.writeInt64(2, threshold_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (comparison_
              != com.google.monitoring.v3.ComparisonType.COMPARISON_UNSPECIFIED.getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, comparison_);
          }
          if (threshold_ != 0L) {
            size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, threshold_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest other =
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest) obj;

          if (comparison_ != other.comparison_) return false;
          if (getThreshold() != other.getThreshold()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + COMPARISON_FIELD_NUMBER;
          hash = (53 * hash) + comparison_;
          hash = (37 * hash) + THRESHOLD_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getThreshold());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A test that checks if the number of rows in the result set
         * violates some threshold.
         * </pre>
         *
         * Protobuf type {@code
         * google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTestOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_RowCountTest_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_RowCountTest_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.class,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.Builder
                        .class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            comparison_ = 0;
            threshold_ = 0L;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_RowCountTest_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest build() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
              buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest result =
                new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.comparison_ = comparison_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.threshold_ = threshold_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                    .getDefaultInstance()) return this;
            if (other.comparison_ != 0) {
              setComparisonValue(other.getComparisonValue());
            }
            if (other.getThreshold() != 0L) {
              setThreshold(other.getThreshold());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      comparison_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 16:
                    {
                      threshold_ = input.readInt64();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int comparison_ = 0;
          /**
           *
           *
           * <pre>
           * Required. The comparison to apply between the number of rows returned
           * by the query and the threshold.
           * </pre>
           *
           * <code>
           * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The enum numeric value on the wire for comparison.
           */
          @java.lang.Override
          public int getComparisonValue() {
            return comparison_;
          }
          /**
           *
           *
           * <pre>
           * Required. The comparison to apply between the number of rows returned
           * by the query and the threshold.
           * </pre>
           *
           * <code>
           * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The enum numeric value on the wire for comparison to set.
           * @return This builder for chaining.
           */
          public Builder setComparisonValue(int value) {
            comparison_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The comparison to apply between the number of rows returned
           * by the query and the threshold.
           * </pre>
           *
           * <code>
           * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The comparison.
           */
          @java.lang.Override
          public com.google.monitoring.v3.ComparisonType getComparison() {
            com.google.monitoring.v3.ComparisonType result =
                com.google.monitoring.v3.ComparisonType.forNumber(comparison_);
            return result == null ? com.google.monitoring.v3.ComparisonType.UNRECOGNIZED : result;
          }
          /**
           *
           *
           * <pre>
           * Required. The comparison to apply between the number of rows returned
           * by the query and the threshold.
           * </pre>
           *
           * <code>
           * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The comparison to set.
           * @return This builder for chaining.
           */
          public Builder setComparison(com.google.monitoring.v3.ComparisonType value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            comparison_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The comparison to apply between the number of rows returned
           * by the query and the threshold.
           * </pre>
           *
           * <code>
           * .google.monitoring.v3.ComparisonType comparison = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearComparison() {
            bitField0_ = (bitField0_ & ~0x00000001);
            comparison_ = 0;
            onChanged();
            return this;
          }

          private long threshold_;
          /**
           *
           *
           * <pre>
           * Required. The value against which to compare the row count.
           * </pre>
           *
           * <code>int64 threshold = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The threshold.
           */
          @java.lang.Override
          public long getThreshold() {
            return threshold_;
          }
          /**
           *
           *
           * <pre>
           * Required. The value against which to compare the row count.
           * </pre>
           *
           * <code>int64 threshold = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The threshold to set.
           * @return This builder for chaining.
           */
          public Builder setThreshold(long value) {

            threshold_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The value against which to compare the row count.
           * </pre>
           *
           * <code>int64 threshold = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearThreshold() {
            bitField0_ = (bitField0_ & ~0x00000002);
            threshold_ = 0L;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
                .RowCountTest
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<RowCountTest> PARSER =
            new com.google.protobuf.AbstractParser<RowCountTest>() {
              @java.lang.Override
              public RowCountTest parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<RowCountTest> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<RowCountTest> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface BooleanTestOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The name of the column containing the boolean value. If the
         * value in a row is NULL, that row is ignored.
         * </pre>
         *
         * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The column.
         */
        java.lang.String getColumn();
        /**
         *
         *
         * <pre>
         * Required. The name of the column containing the boolean value. If the
         * value in a row is NULL, that row is ignored.
         * </pre>
         *
         * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for column.
         */
        com.google.protobuf.ByteString getColumnBytes();
      }
      /**
       *
       *
       * <pre>
       * A test that uses an alerting result in a boolean column produced by
       * the SQL query.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest}
       */
      public static final class BooleanTest extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
          BooleanTestOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use BooleanTest.newBuilder() to construct.
        private BooleanTest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private BooleanTest() {
          column_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new BooleanTest();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_BooleanTest_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_BooleanTest_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder
                      .class);
        }

        public static final int COLUMN_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object column_ = "";
        /**
         *
         *
         * <pre>
         * Required. The name of the column containing the boolean value. If the
         * value in a row is NULL, that row is ignored.
         * </pre>
         *
         * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The column.
         */
        @java.lang.Override
        public java.lang.String getColumn() {
          java.lang.Object ref = column_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            column_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the column containing the boolean value. If the
         * value in a row is NULL, that row is ignored.
         * </pre>
         *
         * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for column.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getColumnBytes() {
          java.lang.Object ref = column_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            column_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, column_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, column_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest other =
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest) obj;

          if (!getColumn().equals(other.getColumn())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + COLUMN_FIELD_NUMBER;
          hash = (53 * hash) + getColumn().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A test that uses an alerting result in a boolean column produced by
         * the SQL query.
         * </pre>
         *
         * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTestOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_BooleanTest_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_BooleanTest_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.class,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder
                        .class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            column_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_BooleanTest_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest build() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
              buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest result =
                new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.column_ = column_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                    .getDefaultInstance()) return this;
            if (!other.getColumn().isEmpty()) {
              column_ = other.column_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      column_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object column_ = "";
          /**
           *
           *
           * <pre>
           * Required. The name of the column containing the boolean value. If the
           * value in a row is NULL, that row is ignored.
           * </pre>
           *
           * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The column.
           */
          public java.lang.String getColumn() {
            java.lang.Object ref = column_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              column_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the column containing the boolean value. If the
           * value in a row is NULL, that row is ignored.
           * </pre>
           *
           * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for column.
           */
          public com.google.protobuf.ByteString getColumnBytes() {
            java.lang.Object ref = column_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              column_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the column containing the boolean value. If the
           * value in a row is NULL, that row is ignored.
           * </pre>
           *
           * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The column to set.
           * @return This builder for chaining.
           */
          public Builder setColumn(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            column_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the column containing the boolean value. If the
           * value in a row is NULL, that row is ignored.
           * </pre>
           *
           * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearColumn() {
            column_ = getDefaultInstance().getColumn();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the column containing the boolean value. If the
           * value in a row is NULL, that row is ignored.
           * </pre>
           *
           * <code>string column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for column to set.
           * @return This builder for chaining.
           */
          public Builder setColumnBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            column_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<BooleanTest> PARSER =
            new com.google.protobuf.AbstractParser<BooleanTest>() {
              @java.lang.Override
              public BooleanTest parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<BooleanTest> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<BooleanTest> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int scheduleCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object schedule_;

      public enum ScheduleCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        MINUTES(2),
        HOURLY(3),
        DAILY(4),
        SCHEDULE_NOT_SET(0);
        private final int value;

        private ScheduleCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ScheduleCase valueOf(int value) {
          return forNumber(value);
        }

        public static ScheduleCase forNumber(int value) {
          switch (value) {
            case 2:
              return MINUTES;
            case 3:
              return HOURLY;
            case 4:
              return DAILY;
            case 0:
              return SCHEDULE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ScheduleCase getScheduleCase() {
        return ScheduleCase.forNumber(scheduleCase_);
      }

      private int evaluateCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object evaluate_;

      public enum EvaluateCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        ROW_COUNT_TEST(5),
        BOOLEAN_TEST(6),
        EVALUATE_NOT_SET(0);
        private final int value;

        private EvaluateCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EvaluateCase valueOf(int value) {
          return forNumber(value);
        }

        public static EvaluateCase forNumber(int value) {
          switch (value) {
            case 5:
              return ROW_COUNT_TEST;
            case 6:
              return BOOLEAN_TEST;
            case 0:
              return EVALUATE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EvaluateCase getEvaluateCase() {
        return EvaluateCase.forNumber(evaluateCase_);
      }

      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Log Analytics SQL query to run, as a string.  The query
       * must conform to the required shape. Specifically, the query must not
       * try to filter the input by time.  A filter will automatically be
       * applied to filter the input so that the query receives all rows
       * received since the last time the query was run.
       *
       * For example, the following query extracts all log entries containing an
       * HTTP request:
       *
       *     SELECT
       *       timestamp, log_name, severity, http_request, resource, labels
       *     FROM
       *       my-project.global._Default._AllLogs
       *     WHERE
       *       http_request IS NOT NULL
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Log Analytics SQL query to run, as a string.  The query
       * must conform to the required shape. Specifically, the query must not
       * try to filter the input by time.  A filter will automatically be
       * applied to filter the input so that the query receives all rows
       * received since the last time the query was run.
       *
       * For example, the following query extracts all log entries containing an
       * HTTP request:
       *
       *     SELECT
       *       timestamp, log_name, severity, http_request, resource, labels
       *     FROM
       *       my-project.global._Default._AllLogs
       *     WHERE
       *       http_request IS NOT NULL
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MINUTES_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many minutes.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
       *
       * @return Whether the minutes field is set.
       */
      @java.lang.Override
      public boolean hasMinutes() {
        return scheduleCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many minutes.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
       *
       * @return The minutes.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes getMinutes() {
        if (scheduleCase_ == 2) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) schedule_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many minutes.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder
          getMinutesOrBuilder() {
        if (scheduleCase_ == 2) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) schedule_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
            .getDefaultInstance();
      }

      public static final int HOURLY_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many hours.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
       *
       * @return Whether the hourly field is set.
       */
      @java.lang.Override
      public boolean hasHourly() {
        return scheduleCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many hours.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
       *
       * @return The hourly.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly getHourly() {
        if (scheduleCase_ == 3) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many hours.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder
          getHourlyOrBuilder() {
        if (scheduleCase_ == 3) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
            .getDefaultInstance();
      }

      public static final int DAILY_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many days.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
       *
       * @return Whether the daily field is set.
       */
      @java.lang.Override
      public boolean hasDaily() {
        return scheduleCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many days.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
       *
       * @return The daily.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily getDaily() {
        if (scheduleCase_ == 4) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Schedule the query to execute every so many days.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder
          getDailyOrBuilder() {
        if (scheduleCase_ == 4) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
            .getDefaultInstance();
      }

      public static final int ROW_COUNT_TEST_FIELD_NUMBER = 5;
      /**
       *
       *
       * <pre>
       * Test the row count against a threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
       * </code>
       *
       * @return Whether the rowCountTest field is set.
       */
      @java.lang.Override
      public boolean hasRowCountTest() {
        return evaluateCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Test the row count against a threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
       * </code>
       *
       * @return The rowCountTest.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
          getRowCountTest() {
        if (evaluateCase_ == 5) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
              evaluate_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Test the row count against a threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTestOrBuilder
          getRowCountTestOrBuilder() {
        if (evaluateCase_ == 5) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
              evaluate_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            .getDefaultInstance();
      }

      public static final int BOOLEAN_TEST_FIELD_NUMBER = 6;
      /**
       *
       *
       * <pre>
       * Test the boolean value in the indicated column.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
       * </code>
       *
       * @return Whether the booleanTest field is set.
       */
      @java.lang.Override
      public boolean hasBooleanTest() {
        return evaluateCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Test the boolean value in the indicated column.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
       * </code>
       *
       * @return The booleanTest.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
          getBooleanTest() {
        if (evaluateCase_ == 6) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
              evaluate_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Test the boolean value in the indicated column.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTestOrBuilder
          getBooleanTestOrBuilder() {
        if (evaluateCase_ == 6) {
          return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
              evaluate_;
        }
        return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (scheduleCase_ == 2) {
          output.writeMessage(
              2, (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) schedule_);
        }
        if (scheduleCase_ == 3) {
          output.writeMessage(
              3, (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_);
        }
        if (scheduleCase_ == 4) {
          output.writeMessage(
              4, (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_);
        }
        if (evaluateCase_ == 5) {
          output.writeMessage(
              5,
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest) evaluate_);
        }
        if (evaluateCase_ == 6) {
          output.writeMessage(
              6,
              (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest) evaluate_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (scheduleCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) schedule_);
        }
        if (scheduleCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_);
        }
        if (scheduleCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4, (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_);
        }
        if (evaluateCase_ == 5) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5,
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
                      evaluate_);
        }
        if (evaluateCase_ == 6) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  6,
                  (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
                      evaluate_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition other =
            (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (!getScheduleCase().equals(other.getScheduleCase())) return false;
        switch (scheduleCase_) {
          case 2:
            if (!getMinutes().equals(other.getMinutes())) return false;
            break;
          case 3:
            if (!getHourly().equals(other.getHourly())) return false;
            break;
          case 4:
            if (!getDaily().equals(other.getDaily())) return false;
            break;
          case 0:
          default:
        }
        if (!getEvaluateCase().equals(other.getEvaluateCase())) return false;
        switch (evaluateCase_) {
          case 5:
            if (!getRowCountTest().equals(other.getRowCountTest())) return false;
            break;
          case 6:
            if (!getBooleanTest().equals(other.getBooleanTest())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        switch (scheduleCase_) {
          case 2:
            hash = (37 * hash) + MINUTES_FIELD_NUMBER;
            hash = (53 * hash) + getMinutes().hashCode();
            break;
          case 3:
            hash = (37 * hash) + HOURLY_FIELD_NUMBER;
            hash = (53 * hash) + getHourly().hashCode();
            break;
          case 4:
            hash = (37 * hash) + DAILY_FIELD_NUMBER;
            hash = (53 * hash) + getDaily().hashCode();
            break;
          case 0:
          default:
        }
        switch (evaluateCase_) {
          case 5:
            hash = (37 * hash) + ROW_COUNT_TEST_FIELD_NUMBER;
            hash = (53 * hash) + getRowCountTest().hashCode();
            break;
          case 6:
            hash = (37 * hash) + BOOLEAN_TEST_FIELD_NUMBER;
            hash = (53 * hash) + getBooleanTest().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition that allows alerting policies to be defined using GoogleSQL.
       * SQL conditions examine a sliding window of logs using GoogleSQL.
       * Alert policies with SQL conditions may incur additional billing.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.SqlCondition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.SqlCondition)
          com.google.monitoring.v3.AlertPolicy.Condition.SqlConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          if (minutesBuilder_ != null) {
            minutesBuilder_.clear();
          }
          if (hourlyBuilder_ != null) {
            hourlyBuilder_.clear();
          }
          if (dailyBuilder_ != null) {
            dailyBuilder_.clear();
          }
          if (rowCountTestBuilder_ != null) {
            rowCountTestBuilder_.clear();
          }
          if (booleanTestBuilder_ != null) {
            booleanTestBuilder_.clear();
          }
          scheduleCase_ = 0;
          schedule_ = null;
          evaluateCase_ = 0;
          evaluate_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_SqlCondition_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition build() {
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition result =
              new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
        }

        private void buildPartialOneofs(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition result) {
          result.scheduleCase_ = scheduleCase_;
          result.schedule_ = this.schedule_;
          if (scheduleCase_ == 2 && minutesBuilder_ != null) {
            result.schedule_ = minutesBuilder_.build();
          }
          if (scheduleCase_ == 3 && hourlyBuilder_ != null) {
            result.schedule_ = hourlyBuilder_.build();
          }
          if (scheduleCase_ == 4 && dailyBuilder_ != null) {
            result.schedule_ = dailyBuilder_.build();
          }
          result.evaluateCase_ = evaluateCase_;
          result.evaluate_ = this.evaluate_;
          if (evaluateCase_ == 5 && rowCountTestBuilder_ != null) {
            result.evaluate_ = rowCountTestBuilder_.build();
          }
          if (evaluateCase_ == 6 && booleanTestBuilder_ != null) {
            result.evaluate_ = booleanTestBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.getDefaultInstance())
            return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          switch (other.getScheduleCase()) {
            case MINUTES:
              {
                mergeMinutes(other.getMinutes());
                break;
              }
            case HOURLY:
              {
                mergeHourly(other.getHourly());
                break;
              }
            case DAILY:
              {
                mergeDaily(other.getDaily());
                break;
              }
            case SCHEDULE_NOT_SET:
              {
                break;
              }
          }
          switch (other.getEvaluateCase()) {
            case ROW_COUNT_TEST:
              {
                mergeRowCountTest(other.getRowCountTest());
                break;
              }
            case BOOLEAN_TEST:
              {
                mergeBooleanTest(other.getBooleanTest());
                break;
              }
            case EVALUATE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getMinutesFieldBuilder().getBuilder(), extensionRegistry);
                    scheduleCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getHourlyFieldBuilder().getBuilder(), extensionRegistry);
                    scheduleCase_ = 3;
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(getDailyFieldBuilder().getBuilder(), extensionRegistry);
                    scheduleCase_ = 4;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(
                        getRowCountTestFieldBuilder().getBuilder(), extensionRegistry);
                    evaluateCase_ = 5;
                    break;
                  } // case 42
                case 50:
                  {
                    input.readMessage(getBooleanTestFieldBuilder().getBuilder(), extensionRegistry);
                    evaluateCase_ = 6;
                    break;
                  } // case 50
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int scheduleCase_ = 0;
        private java.lang.Object schedule_;

        public ScheduleCase getScheduleCase() {
          return ScheduleCase.forNumber(scheduleCase_);
        }

        public Builder clearSchedule() {
          scheduleCase_ = 0;
          schedule_ = null;
          onChanged();
          return this;
        }

        private int evaluateCase_ = 0;
        private java.lang.Object evaluate_;

        public EvaluateCase getEvaluateCase() {
          return EvaluateCase.forNumber(evaluateCase_);
        }

        public Builder clearEvaluate() {
          evaluateCase_ = 0;
          evaluate_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";
        /**
         *
         *
         * <pre>
         * Required. The Log Analytics SQL query to run, as a string.  The query
         * must conform to the required shape. Specifically, the query must not
         * try to filter the input by time.  A filter will automatically be
         * applied to filter the input so that the query receives all rows
         * received since the last time the query was run.
         *
         * For example, the following query extracts all log entries containing an
         * HTTP request:
         *
         *     SELECT
         *       timestamp, log_name, severity, http_request, resource, labels
         *     FROM
         *       my-project.global._Default._AllLogs
         *     WHERE
         *       http_request IS NOT NULL
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The Log Analytics SQL query to run, as a string.  The query
         * must conform to the required shape. Specifically, the query must not
         * try to filter the input by time.  A filter will automatically be
         * applied to filter the input so that the query receives all rows
         * received since the last time the query was run.
         *
         * For example, the following query extracts all log entries containing an
         * HTTP request:
         *
         *     SELECT
         *       timestamp, log_name, severity, http_request, resource, labels
         *     FROM
         *       my-project.global._Default._AllLogs
         *     WHERE
         *       http_request IS NOT NULL
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The Log Analytics SQL query to run, as a string.  The query
         * must conform to the required shape. Specifically, the query must not
         * try to filter the input by time.  A filter will automatically be
         * applied to filter the input so that the query receives all rows
         * received since the last time the query was run.
         *
         * For example, the following query extracts all log entries containing an
         * HTTP request:
         *
         *     SELECT
         *       timestamp, log_name, severity, http_request, resource, labels
         *     FROM
         *       my-project.global._Default._AllLogs
         *     WHERE
         *       http_request IS NOT NULL
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The Log Analytics SQL query to run, as a string.  The query
         * must conform to the required shape. Specifically, the query must not
         * try to filter the input by time.  A filter will automatically be
         * applied to filter the input so that the query receives all rows
         * received since the last time the query was run.
         *
         * For example, the following query extracts all log entries containing an
         * HTTP request:
         *
         *     SELECT
         *       timestamp, log_name, severity, http_request, resource, labels
         *     FROM
         *       my-project.global._Default._AllLogs
         *     WHERE
         *       http_request IS NOT NULL
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The Log Analytics SQL query to run, as a string.  The query
         * must conform to the required shape. Specifically, the query must not
         * try to filter the input by time.  A filter will automatically be
         * applied to filter the input so that the query receives all rows
         * received since the last time the query was run.
         *
         * For example, the following query extracts all log entries containing an
         * HTTP request:
         *
         *     SELECT
         *       timestamp, log_name, severity, http_request, resource, labels
         *     FROM
         *       my-project.global._Default._AllLogs
         *     WHERE
         *       http_request IS NOT NULL
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder>
            minutesBuilder_;
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         *
         * @return Whether the minutes field is set.
         */
        @java.lang.Override
        public boolean hasMinutes() {
          return scheduleCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         *
         * @return The minutes.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes getMinutes() {
          if (minutesBuilder_ == null) {
            if (scheduleCase_ == 2) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
                  schedule_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                .getDefaultInstance();
          } else {
            if (scheduleCase_ == 2) {
              return minutesBuilder_.getMessage();
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        public Builder setMinutes(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes value) {
          if (minutesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            schedule_ = value;
            onChanged();
          } else {
            minutesBuilder_.setMessage(value);
          }
          scheduleCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        public Builder setMinutes(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder
                builderForValue) {
          if (minutesBuilder_ == null) {
            schedule_ = builderForValue.build();
            onChanged();
          } else {
            minutesBuilder_.setMessage(builderForValue.build());
          }
          scheduleCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        public Builder mergeMinutes(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes value) {
          if (minutesBuilder_ == null) {
            if (scheduleCase_ == 2
                && schedule_
                    != com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                        .getDefaultInstance()) {
              schedule_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.newBuilder(
                          (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
                              schedule_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              schedule_ = value;
            }
            onChanged();
          } else {
            if (scheduleCase_ == 2) {
              minutesBuilder_.mergeFrom(value);
            } else {
              minutesBuilder_.setMessage(value);
            }
          }
          scheduleCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        public Builder clearMinutes() {
          if (minutesBuilder_ == null) {
            if (scheduleCase_ == 2) {
              scheduleCase_ = 0;
              schedule_ = null;
              onChanged();
            }
          } else {
            if (scheduleCase_ == 2) {
              scheduleCase_ = 0;
              schedule_ = null;
            }
            minutesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder
            getMinutesBuilder() {
          return getMinutesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder
            getMinutesOrBuilder() {
          if ((scheduleCase_ == 2) && (minutesBuilder_ != null)) {
            return minutesBuilder_.getMessageOrBuilder();
          } else {
            if (scheduleCase_ == 2) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes)
                  schedule_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many minutes.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder>
            getMinutesFieldBuilder() {
          if (minutesBuilder_ == null) {
            if (!(scheduleCase_ == 2)) {
              schedule_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes
                      .getDefaultInstance();
            }
            minutesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.MinutesOrBuilder>(
                    (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes) schedule_,
                    getParentForChildren(),
                    isClean());
            schedule_ = null;
          }
          scheduleCase_ = 2;
          onChanged();
          return minutesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder>
            hourlyBuilder_;
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         *
         * @return Whether the hourly field is set.
         */
        @java.lang.Override
        public boolean hasHourly() {
          return scheduleCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         *
         * @return The hourly.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly getHourly() {
          if (hourlyBuilder_ == null) {
            if (scheduleCase_ == 3) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                .getDefaultInstance();
          } else {
            if (scheduleCase_ == 3) {
              return hourlyBuilder_.getMessage();
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        public Builder setHourly(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly value) {
          if (hourlyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            schedule_ = value;
            onChanged();
          } else {
            hourlyBuilder_.setMessage(value);
          }
          scheduleCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        public Builder setHourly(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder
                builderForValue) {
          if (hourlyBuilder_ == null) {
            schedule_ = builderForValue.build();
            onChanged();
          } else {
            hourlyBuilder_.setMessage(builderForValue.build());
          }
          scheduleCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        public Builder mergeHourly(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly value) {
          if (hourlyBuilder_ == null) {
            if (scheduleCase_ == 3
                && schedule_
                    != com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                        .getDefaultInstance()) {
              schedule_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.newBuilder(
                          (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly)
                              schedule_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              schedule_ = value;
            }
            onChanged();
          } else {
            if (scheduleCase_ == 3) {
              hourlyBuilder_.mergeFrom(value);
            } else {
              hourlyBuilder_.setMessage(value);
            }
          }
          scheduleCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        public Builder clearHourly() {
          if (hourlyBuilder_ == null) {
            if (scheduleCase_ == 3) {
              scheduleCase_ = 0;
              schedule_ = null;
              onChanged();
            }
          } else {
            if (scheduleCase_ == 3) {
              scheduleCase_ = 0;
              schedule_ = null;
            }
            hourlyBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder
            getHourlyBuilder() {
          return getHourlyFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder
            getHourlyOrBuilder() {
          if ((scheduleCase_ == 3) && (hourlyBuilder_ != null)) {
            return hourlyBuilder_.getMessageOrBuilder();
          } else {
            if (scheduleCase_ == 3) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many hours.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder>
            getHourlyFieldBuilder() {
          if (hourlyBuilder_ == null) {
            if (!(scheduleCase_ == 3)) {
              schedule_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly
                      .getDefaultInstance();
            }
            hourlyBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.HourlyOrBuilder>(
                    (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly) schedule_,
                    getParentForChildren(),
                    isClean());
            schedule_ = null;
          }
          scheduleCase_ = 3;
          onChanged();
          return hourlyBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder>
            dailyBuilder_;
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         *
         * @return Whether the daily field is set.
         */
        @java.lang.Override
        public boolean hasDaily() {
          return scheduleCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         *
         * @return The daily.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily getDaily() {
          if (dailyBuilder_ == null) {
            if (scheduleCase_ == 4) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                .getDefaultInstance();
          } else {
            if (scheduleCase_ == 4) {
              return dailyBuilder_.getMessage();
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        public Builder setDaily(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily value) {
          if (dailyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            schedule_ = value;
            onChanged();
          } else {
            dailyBuilder_.setMessage(value);
          }
          scheduleCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        public Builder setDaily(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder
                builderForValue) {
          if (dailyBuilder_ == null) {
            schedule_ = builderForValue.build();
            onChanged();
          } else {
            dailyBuilder_.setMessage(builderForValue.build());
          }
          scheduleCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        public Builder mergeDaily(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily value) {
          if (dailyBuilder_ == null) {
            if (scheduleCase_ == 4
                && schedule_
                    != com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                        .getDefaultInstance()) {
              schedule_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.newBuilder(
                          (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily)
                              schedule_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              schedule_ = value;
            }
            onChanged();
          } else {
            if (scheduleCase_ == 4) {
              dailyBuilder_.mergeFrom(value);
            } else {
              dailyBuilder_.setMessage(value);
            }
          }
          scheduleCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        public Builder clearDaily() {
          if (dailyBuilder_ == null) {
            if (scheduleCase_ == 4) {
              scheduleCase_ = 0;
              schedule_ = null;
              onChanged();
            }
          } else {
            if (scheduleCase_ == 4) {
              scheduleCase_ = 0;
              schedule_ = null;
            }
            dailyBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder
            getDailyBuilder() {
          return getDailyFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder
            getDailyOrBuilder() {
          if ((scheduleCase_ == 4) && (dailyBuilder_ != null)) {
            return dailyBuilder_.getMessageOrBuilder();
          } else {
            if (scheduleCase_ == 4) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Schedule the query to execute every so many days.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder>
            getDailyFieldBuilder() {
          if (dailyBuilder_ == null) {
            if (!(scheduleCase_ == 4)) {
              schedule_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily
                      .getDefaultInstance();
            }
            dailyBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.DailyOrBuilder>(
                    (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily) schedule_,
                    getParentForChildren(),
                    isClean());
            schedule_ = null;
          }
          scheduleCase_ = 4;
          onChanged();
          return dailyBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTestOrBuilder>
            rowCountTestBuilder_;
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         *
         * @return Whether the rowCountTest field is set.
         */
        @java.lang.Override
        public boolean hasRowCountTest() {
          return evaluateCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         *
         * @return The rowCountTest.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
            getRowCountTest() {
          if (rowCountTestBuilder_ == null) {
            if (evaluateCase_ == 5) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
                  evaluate_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                .getDefaultInstance();
          } else {
            if (evaluateCase_ == 5) {
              return rowCountTestBuilder_.getMessage();
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        public Builder setRowCountTest(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest value) {
          if (rowCountTestBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            evaluate_ = value;
            onChanged();
          } else {
            rowCountTestBuilder_.setMessage(value);
          }
          evaluateCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        public Builder setRowCountTest(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.Builder
                builderForValue) {
          if (rowCountTestBuilder_ == null) {
            evaluate_ = builderForValue.build();
            onChanged();
          } else {
            rowCountTestBuilder_.setMessage(builderForValue.build());
          }
          evaluateCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        public Builder mergeRowCountTest(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest value) {
          if (rowCountTestBuilder_ == null) {
            if (evaluateCase_ == 5
                && evaluate_
                    != com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                        .getDefaultInstance()) {
              evaluate_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                      .newBuilder(
                          (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
                              evaluate_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              evaluate_ = value;
            }
            onChanged();
          } else {
            if (evaluateCase_ == 5) {
              rowCountTestBuilder_.mergeFrom(value);
            } else {
              rowCountTestBuilder_.setMessage(value);
            }
          }
          evaluateCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        public Builder clearRowCountTest() {
          if (rowCountTestBuilder_ == null) {
            if (evaluateCase_ == 5) {
              evaluateCase_ = 0;
              evaluate_ = null;
              onChanged();
            }
          } else {
            if (evaluateCase_ == 5) {
              evaluateCase_ = 0;
              evaluate_ = null;
            }
            rowCountTestBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.Builder
            getRowCountTestBuilder() {
          return getRowCountTestFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTestOrBuilder
            getRowCountTestOrBuilder() {
          if ((evaluateCase_ == 5) && (rowCountTestBuilder_ != null)) {
            return rowCountTestBuilder_.getMessageOrBuilder();
          } else {
            if (evaluateCase_ == 5) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
                  evaluate_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Test the row count against a threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTestOrBuilder>
            getRowCountTestFieldBuilder() {
          if (rowCountTestBuilder_ == null) {
            if (!(evaluateCase_ == 5)) {
              evaluate_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                      .getDefaultInstance();
            }
            rowCountTestBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest
                        .Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
                        .RowCountTestOrBuilder>(
                    (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest)
                        evaluate_,
                    getParentForChildren(),
                    isClean());
            evaluate_ = null;
          }
          evaluateCase_ = 5;
          onChanged();
          return rowCountTestBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTestOrBuilder>
            booleanTestBuilder_;
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         *
         * @return Whether the booleanTest field is set.
         */
        @java.lang.Override
        public boolean hasBooleanTest() {
          return evaluateCase_ == 6;
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         *
         * @return The booleanTest.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
            getBooleanTest() {
          if (booleanTestBuilder_ == null) {
            if (evaluateCase_ == 6) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
                  evaluate_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                .getDefaultInstance();
          } else {
            if (evaluateCase_ == 6) {
              return booleanTestBuilder_.getMessage();
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        public Builder setBooleanTest(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest value) {
          if (booleanTestBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            evaluate_ = value;
            onChanged();
          } else {
            booleanTestBuilder_.setMessage(value);
          }
          evaluateCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        public Builder setBooleanTest(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder
                builderForValue) {
          if (booleanTestBuilder_ == null) {
            evaluate_ = builderForValue.build();
            onChanged();
          } else {
            booleanTestBuilder_.setMessage(builderForValue.build());
          }
          evaluateCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        public Builder mergeBooleanTest(
            com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest value) {
          if (booleanTestBuilder_ == null) {
            if (evaluateCase_ == 6
                && evaluate_
                    != com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                        .getDefaultInstance()) {
              evaluate_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                      .newBuilder(
                          (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
                              evaluate_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              evaluate_ = value;
            }
            onChanged();
          } else {
            if (evaluateCase_ == 6) {
              booleanTestBuilder_.mergeFrom(value);
            } else {
              booleanTestBuilder_.setMessage(value);
            }
          }
          evaluateCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        public Builder clearBooleanTest() {
          if (booleanTestBuilder_ == null) {
            if (evaluateCase_ == 6) {
              evaluateCase_ = 0;
              evaluate_ = null;
              onChanged();
            }
          } else {
            if (evaluateCase_ == 6) {
              evaluateCase_ = 0;
              evaluate_ = null;
            }
            booleanTestBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder
            getBooleanTestBuilder() {
          return getBooleanTestFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTestOrBuilder
            getBooleanTestOrBuilder() {
          if ((evaluateCase_ == 6) && (booleanTestBuilder_ != null)) {
            return booleanTestBuilder_.getMessageOrBuilder();
          } else {
            if (evaluateCase_ == 6) {
              return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
                  evaluate_;
            }
            return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Test the boolean value in the indicated column.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTestOrBuilder>
            getBooleanTestFieldBuilder() {
          if (booleanTestBuilder_ == null) {
            if (!(evaluateCase_ == 6)) {
              evaluate_ =
                  com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest
                      .getDefaultInstance();
            }
            booleanTestBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
                        .BooleanTestOrBuilder>(
                    (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest)
                        evaluate_,
                    getParentForChildren(),
                    isClean());
            evaluate_ = null;
          }
          evaluateCase_ = 6;
          onChanged();
          return booleanTestBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.SqlCondition)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SqlCondition> PARSER =
          new com.google.protobuf.AbstractParser<SqlCondition>() {
            @java.lang.Override
            public SqlCondition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SqlCondition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SqlCondition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int conditionCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object condition_;

    public enum ConditionCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONDITION_THRESHOLD(1),
      CONDITION_ABSENT(2),
      CONDITION_MATCHED_LOG(20),
      CONDITION_MONITORING_QUERY_LANGUAGE(19),
      CONDITION_PROMETHEUS_QUERY_LANGUAGE(21),
      CONDITION_SQL(22),
      CONDITION_NOT_SET(0);
      private final int value;

      private ConditionCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ConditionCase valueOf(int value) {
        return forNumber(value);
      }

      public static ConditionCase forNumber(int value) {
        switch (value) {
          case 1:
            return CONDITION_THRESHOLD;
          case 2:
            return CONDITION_ABSENT;
          case 20:
            return CONDITION_MATCHED_LOG;
          case 19:
            return CONDITION_MONITORING_QUERY_LANGUAGE;
          case 21:
            return CONDITION_PROMETHEUS_QUERY_LANGUAGE;
          case 22:
            return CONDITION_SQL;
          case 0:
            return CONDITION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ConditionCase getConditionCase() {
      return ConditionCase.forNumber(conditionCase_);
    }

    public static final int NAME_FIELD_NUMBER = 12;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONDITION_THRESHOLD_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return Whether the conditionThreshold field is set.
     */
    @java.lang.Override
    public boolean hasConditionThreshold() {
      return conditionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return The conditionThreshold.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold getConditionThreshold() {
      if (conditionCase_ == 1) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder
        getConditionThresholdOrBuilder() {
      if (conditionCase_ == 1) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.getDefaultInstance();
    }

    public static final int CONDITION_ABSENT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return Whether the conditionAbsent field is set.
     */
    @java.lang.Override
    public boolean hasConditionAbsent() {
      return conditionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return The conditionAbsent.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence getConditionAbsent() {
      if (conditionCase_ == 2) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder
        getConditionAbsentOrBuilder() {
      if (conditionCase_ == 2) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
    }

    public static final int CONDITION_MATCHED_LOG_FIELD_NUMBER = 20;
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return Whether the conditionMatchedLog field is set.
     */
    @java.lang.Override
    public boolean hasConditionMatchedLog() {
      return conditionCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return The conditionMatchedLog.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getConditionMatchedLog() {
      if (conditionCase_ == 20) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder
        getConditionMatchedLogOrBuilder() {
      if (conditionCase_ == 20) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
    }

    public static final int CONDITION_MONITORING_QUERY_LANGUAGE_FIELD_NUMBER = 19;
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return Whether the conditionMonitoringQueryLanguage field is set.
     */
    @java.lang.Override
    public boolean hasConditionMonitoringQueryLanguage() {
      return conditionCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return The conditionMonitoringQueryLanguage.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
        getConditionMonitoringQueryLanguage() {
      if (conditionCase_ == 19) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageConditionOrBuilder
        getConditionMonitoringQueryLanguageOrBuilder() {
      if (conditionCase_ == 19) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          .getDefaultInstance();
    }

    public static final int CONDITION_PROMETHEUS_QUERY_LANGUAGE_FIELD_NUMBER = 21;
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return Whether the conditionPrometheusQueryLanguage field is set.
     */
    @java.lang.Override
    public boolean hasConditionPrometheusQueryLanguage() {
      return conditionCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return The conditionPrometheusQueryLanguage.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
        getConditionPrometheusQueryLanguage() {
      if (conditionCase_ == 21) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageConditionOrBuilder
        getConditionPrometheusQueryLanguageOrBuilder() {
      if (conditionCase_ == 21) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          .getDefaultInstance();
    }

    public static final int CONDITION_SQL_FIELD_NUMBER = 22;
    /**
     *
     *
     * <pre>
     * A condition that periodically evaluates a SQL query result.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     *
     * @return Whether the conditionSql field is set.
     */
    @java.lang.Override
    public boolean hasConditionSql() {
      return conditionCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * A condition that periodically evaluates a SQL query result.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     *
     * @return The conditionSql.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition getConditionSql() {
      if (conditionCase_ == 22) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that periodically evaluates a SQL query result.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.SqlConditionOrBuilder
        getConditionSqlOrBuilder() {
      if (conditionCase_ == 22) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (conditionCase_ == 1) {
        output.writeMessage(
            1, (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_);
      }
      if (conditionCase_ == 2) {
        output.writeMessage(
            2, (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, name_);
      }
      if (conditionCase_ == 19) {
        output.writeMessage(
            19,
            (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                condition_);
      }
      if (conditionCase_ == 20) {
        output.writeMessage(
            20, (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_);
      }
      if (conditionCase_ == 21) {
        output.writeMessage(
            21,
            (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                condition_);
      }
      if (conditionCase_ == 22) {
        output.writeMessage(
            22, (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) condition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (conditionCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_);
      }
      if (conditionCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, name_);
      }
      if (conditionCase_ == 19) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                19,
                (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                    condition_);
      }
      if (conditionCase_ == 20) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                20, (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_);
      }
      if (conditionCase_ == 21) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                21,
                (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                    condition_);
      }
      if (conditionCase_ == 22) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                22, (com.google.monitoring.v3.AlertPolicy.Condition.SqlCondition) condition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.AlertPolicy.Condition other =
          (com.google.monitoring.v3.AlertPolicy.Condition) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getConditionCase().equals(other.getConditionCase())) return false;
      switch (conditionCase_) {
        case 1:
          if (!getConditionThreshold().equals(other.getConditionThreshold())) return false;
          break;
        case 2:
          if (!getConditionAbsent().equals(other.getConditionAbsent())) return false;
          break;
        case 20:
          if (!getConditionMatchedLog().equals(other.getConditionMatchedLog())) return false;
          break;
        case 19:
          if (!getConditionMonitoringQueryLanguage()
              .equals(other.getConditionMonitoringQueryLanguage())) return false;
          break;
        case 21:
          if (!getConditionPrometheusQueryLanguage()
              .equals(other.getConditionPrometheusQueryLanguage())) return false;
          break;
        case 22:
          if (!getConditionSql().equals(other.getConditionSql())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      switch (conditionCase_) {
        case 1:
          hash = (37 * hash) + CONDITION_THRESHOLD_FIELD_NUMBER;
          hash = (53 * hash) + getConditionThreshold().hashCode();
          break;
        case 2:
          hash = (37 * hash) + CONDITION_ABSENT_FIELD_NUMBER;
          hash = (53 * hash) + getConditionAbsent().hashCode();
          break;
        case 20:
          hash = (37 * hash) + CONDITION_MATCHED_LOG_FIELD_NUMBER;
          hash = (53 * hash) + getConditionMatchedLog().hashCode();
          break;
        case 19:
          hash = (37 * hash) + CONDITION_MONITORING_QUERY_LANGUAGE_FIELD_NUMBER;
          hash = (53 * hash) + getConditionMonitoringQueryLanguage().hashCode();
          break;
        case 21:
          hash = (37 * hash) + CONDITION_PROMETHEUS_QUERY_LANGUAGE_FIELD_NUMBER;
          hash = (53 * hash) + getConditionPrometheusQueryLanguage().hashCode();
          break;
        case 22:
          hash = (37 * hash) + CONDITION_SQL_FIELD_NUMBER;
          hash = (53 * hash) + getConditionSql().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.AlertPolicy.Condition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A condition is a true/false test that determines when an alerting policy
     * should open an incident. If a condition evaluates to true, it signifies
     * that something is wrong.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition)
        com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.class,
                com.google.monitoring.v3.AlertPolicy.Condition.Builder.class);
      }

      // Construct using com.google.monitoring.v3.AlertPolicy.Condition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        displayName_ = "";
        if (conditionThresholdBuilder_ != null) {
          conditionThresholdBuilder_.clear();
        }
        if (conditionAbsentBuilder_ != null) {
          conditionAbsentBuilder_.clear();
        }
        if (conditionMatchedLogBuilder_ != null) {
          conditionMatchedLogBuilder_.clear();
        }
        if (conditionMonitoringQueryLanguageBuilder_ != null) {
          conditionMonitoringQueryLanguageBuilder_.clear();
        }
        if (conditionPrometheusQueryLanguageBuilder_ != null) {
          conditionPrometheusQueryLanguageBuilder_.clear();
        }
        if (conditionSqlBuilder_ != null) {
          conditionSqlBuilder_.clear();
        }
        conditionCase_ = 0;
        condition_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition getDefaultInstanceForType() {
        return com.google.monitoring.v3.AlertPolicy.Condition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition build() {
        com.google.monitoring.v3.AlertPolicy.Condition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition buildPartial() {
        com.google.monitoring.v3.AlertPolicy.Condition result =
            new com.google.monitoring.v3.AlertPolicy.Condition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Condition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.displayName_ = displayName_;
        }
      }

      private void buildPartialOneofs(com.google.monitoring.v3.AlertPolicy.Condition result) {
        result.conditionCase_ = conditionCase_;
        result.condition_ = this.condition_;
        if (conditionCase_ == 1 && conditionThresholdBuilder_ != null) {
          result.condition_ = conditionThresholdBuilder_.build();
        }
        if (conditionCase_ == 2 && conditionAbsentBuilder_ != null) {
          result.condition_ = conditionAbsentBuilder_.build();
        }
        if (conditionCase_ == 20 && conditionMatchedLogBuilder_ != null) {
          result.condition_ = conditionMatchedLogBuilder_.build();
        }
        if (conditionCase_ == 19 && conditionMonitoringQueryLanguageBuilder_ != null) {
          result.condition_ = conditionMonitoringQueryLanguageBuilder_.build();
        }
        if (conditionCase_ == 21 && conditionPrometheusQueryLanguageBuilder_ != null) {
          result.condition_ = conditionPrometheusQueryLanguageBuilder_.build();
        }
        if (conditionCase_ == 22 && conditionSqlBuilder_ != null) {
          result.condition_ = conditionSqlBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition) {
          return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Condition other) {
        if (other == com.google.monitoring.v3.AlertPolicy.Condition.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getConditionCase()) {
          case CONDITION_THRESHOLD:
            {
              mergeConditionThreshold(other.getConditionThreshold());
              break;
            }
          case CONDITION_ABSENT:
            {
              mergeConditionAbsent(other.getConditionAbsent());
              break;
            }
          case CONDITION_MATCHED_LOG:
            {
              mergeConditionMatchedLog(other.getConditionMatchedLog());
              break;
            }
          case CONDITION_MONITORING_QUERY_LANGUAGE:
            {
              mergeConditionMonitoringQueryLanguage(other.getConditionMonitoringQueryLanguage());
              break;
            }
          case CONDITION_PROMETHEUS_QUERY_LANGUAGE:
            {
              mergeConditionPrometheusQueryLanguage(other.getConditionPrometheusQueryLanguage());
              break;
            }
          case CONDITION_SQL:
            {
              mergeConditionSql(other.getConditionSql());
              break;
            }
          case CONDITION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getConditionThresholdFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getConditionAbsentFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 2;
                  break;
                } // case 18
              case 50:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 50
              case 98:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 98
              case 154:
                {
                  input.readMessage(
                      getConditionMonitoringQueryLanguageFieldBuilder().getBuilder(),
                      extensionRegistry);
                  conditionCase_ = 19;
                  break;
                } // case 154
              case 162:
                {
                  input.readMessage(
                      getConditionMatchedLogFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 20;
                  break;
                } // case 162
              case 170:
                {
                  input.readMessage(
                      getConditionPrometheusQueryLanguageFieldBuilder().getBuilder(),
                      extensionRegistry);
                  conditionCase_ = 21;
                  break;
                } // case 170
              case 178:
                {
                  input.readMessage(getConditionSqlFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 22;
                  break;
                } // case 178
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int conditionCase_ = 0;
      private java.lang.Object condition_;

      public ConditionCase getConditionCase() {
        return ConditionCase.forNumber(conditionCase_);
      }

      public Builder clearCondition() {
        conditionCase_ = 0;
        condition_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerExcept