/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric.proto

// Protobuf Java Version: 3.25.5
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * Represents the values of a time series associated with a
 * TimeSeriesDescriptor.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.TimeSeriesData}
 */
public final class TimeSeriesData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.TimeSeriesData)
    TimeSeriesDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeSeriesData.newBuilder() to construct.
  private TimeSeriesData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeSeriesData() {
    labelValues_ = java.util.Collections.emptyList();
    pointData_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeSeriesData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TimeSeriesData_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TimeSeriesData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.TimeSeriesData.class,
            com.google.monitoring.v3.TimeSeriesData.Builder.class);
  }

  public interface PointDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.TimeSeriesData.PointData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    java.util.List<com.google.monitoring.v3.TypedValue> getValuesList();
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    com.google.monitoring.v3.TypedValue getValues(int index);
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    java.util.List<? extends com.google.monitoring.v3.TypedValueOrBuilder> getValuesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    com.google.monitoring.v3.TypedValueOrBuilder getValuesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The time interval associated with the point.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
     *
     * @return Whether the timeInterval field is set.
     */
    boolean hasTimeInterval();
    /**
     *
     *
     * <pre>
     * The time interval associated with the point.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
     *
     * @return The timeInterval.
     */
    com.google.monitoring.v3.TimeInterval getTimeInterval();
    /**
     *
     *
     * <pre>
     * The time interval associated with the point.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
     */
    com.google.monitoring.v3.TimeIntervalOrBuilder getTimeIntervalOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A point's value columns and time interval. Each point has one or more
   * point values corresponding to the entries in `point_descriptors` field in
   * the TimeSeriesDescriptor associated with this object.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TimeSeriesData.PointData}
   */
  public static final class PointData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.TimeSeriesData.PointData)
      PointDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PointData.newBuilder() to construct.
    private PointData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PointData() {
      values_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PointData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesData_PointData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesData_PointData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TimeSeriesData.PointData.class,
              com.google.monitoring.v3.TimeSeriesData.PointData.Builder.class);
    }

    private int bitField0_;
    public static final int VALUES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.monitoring.v3.TypedValue> values_;
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.monitoring.v3.TypedValue> getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.monitoring.v3.TypedValueOrBuilder>
        getValuesOrBuilderList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    @java.lang.Override
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.TypedValue getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The values that make up the point.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.TypedValueOrBuilder getValuesOrBuilder(int index) {
      return values_.get(index);
    }

    public static final int TIME_INTERVAL_FIELD_NUMBER = 2;
    private com.google.monitoring.v3.TimeInterval timeInterval_;
    /**
     *
     *
     * <pre>
     * The time interval associated with the point.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
     *
     * @return Whether the timeInterval field is set.
     */
    @java.lang.Override
    public boolean hasTimeInterval() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time interval associated with the point.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
     *
     * @return The timeInterval.
     */
    @java.lang.Override
    public com.google.monitoring.v3.TimeInterval getTimeInterval() {
      return timeInterval_ == null
          ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
          : timeInterval_;
    }
    /**
     *
     *
     * <pre>
     * The time interval associated with the point.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.TimeIntervalOrBuilder getTimeIntervalOrBuilder() {
      return timeInterval_ == null
          ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
          : timeInterval_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < values_.size(); i++) {
        output.writeMessage(1, values_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getTimeInterval());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < values_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, values_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeInterval());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.TimeSeriesData.PointData)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.TimeSeriesData.PointData other =
          (com.google.monitoring.v3.TimeSeriesData.PointData) obj;

      if (!getValuesList().equals(other.getValuesList())) return false;
      if (hasTimeInterval() != other.hasTimeInterval()) return false;
      if (hasTimeInterval()) {
        if (!getTimeInterval().equals(other.getTimeInterval())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      if (hasTimeInterval()) {
        hash = (37 * hash) + TIME_INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getTimeInterval().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.TimeSeriesData.PointData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A point's value columns and time interval. Each point has one or more
     * point values corresponding to the entries in `point_descriptors` field in
     * the TimeSeriesDescriptor associated with this object.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.TimeSeriesData.PointData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TimeSeriesData.PointData)
        com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TimeSeriesData_PointData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TimeSeriesData_PointData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.TimeSeriesData.PointData.class,
                com.google.monitoring.v3.TimeSeriesData.PointData.Builder.class);
      }

      // Construct using com.google.monitoring.v3.TimeSeriesData.PointData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getValuesFieldBuilder();
          getTimeIntervalFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
        } else {
          values_ = null;
          valuesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        timeInterval_ = null;
        if (timeIntervalBuilder_ != null) {
          timeIntervalBuilder_.dispose();
          timeIntervalBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.MetricProto
            .internal_static_google_monitoring_v3_TimeSeriesData_PointData_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.TimeSeriesData.PointData getDefaultInstanceForType() {
        return com.google.monitoring.v3.TimeSeriesData.PointData.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.TimeSeriesData.PointData build() {
        com.google.monitoring.v3.TimeSeriesData.PointData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.TimeSeriesData.PointData buildPartial() {
        com.google.monitoring.v3.TimeSeriesData.PointData result =
            new com.google.monitoring.v3.TimeSeriesData.PointData(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.monitoring.v3.TimeSeriesData.PointData result) {
        if (valuesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            values_ = java.util.Collections.unmodifiableList(values_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.values_ = values_;
        } else {
          result.values_ = valuesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.monitoring.v3.TimeSeriesData.PointData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.timeInterval_ =
              timeIntervalBuilder_ == null ? timeInterval_ : timeIntervalBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.TimeSeriesData.PointData) {
          return mergeFrom((com.google.monitoring.v3.TimeSeriesData.PointData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.TimeSeriesData.PointData other) {
        if (other == com.google.monitoring.v3.TimeSeriesData.PointData.getDefaultInstance())
          return this;
        if (valuesBuilder_ == null) {
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
        } else {
          if (!other.values_.isEmpty()) {
            if (valuesBuilder_.isEmpty()) {
              valuesBuilder_.dispose();
              valuesBuilder_ = null;
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valuesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getValuesFieldBuilder()
                      : null;
            } else {
              valuesBuilder_.addAllMessages(other.values_);
            }
          }
        }
        if (other.hasTimeInterval()) {
          mergeTimeInterval(other.getTimeInterval());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.monitoring.v3.TypedValue m =
                      input.readMessage(
                          com.google.monitoring.v3.TypedValue.parser(), extensionRegistry);
                  if (valuesBuilder_ == null) {
                    ensureValuesIsMutable();
                    values_.add(m);
                  } else {
                    valuesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getTimeIntervalFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.monitoring.v3.TypedValue> values_ =
          java.util.Collections.emptyList();

      private void ensureValuesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          values_ = new java.util.ArrayList<com.google.monitoring.v3.TypedValue>(values_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.TypedValue,
              com.google.monitoring.v3.TypedValue.Builder,
              com.google.monitoring.v3.TypedValueOrBuilder>
          valuesBuilder_;

      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public java.util.List<com.google.monitoring.v3.TypedValue> getValuesList() {
        if (valuesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(values_);
        } else {
          return valuesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public int getValuesCount() {
        if (valuesBuilder_ == null) {
          return values_.size();
        } else {
          return valuesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public com.google.monitoring.v3.TypedValue getValues(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder setValues(int index, com.google.monitoring.v3.TypedValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder setValues(
          int index, com.google.monitoring.v3.TypedValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.set(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder addValues(com.google.monitoring.v3.TypedValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder addValues(int index, com.google.monitoring.v3.TypedValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(index, value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder addValues(com.google.monitoring.v3.TypedValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder addValues(
          int index, com.google.monitoring.v3.TypedValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder addAllValues(
          java.lang.Iterable<? extends com.google.monitoring.v3.TypedValue> values) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
        } else {
          valuesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public Builder removeValues(int index) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.remove(index);
          onChanged();
        } else {
          valuesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public com.google.monitoring.v3.TypedValue.Builder getValuesBuilder(int index) {
        return getValuesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public com.google.monitoring.v3.TypedValueOrBuilder getValuesOrBuilder(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public java.util.List<? extends com.google.monitoring.v3.TypedValueOrBuilder>
          getValuesOrBuilderList() {
        if (valuesBuilder_ != null) {
          return valuesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(values_);
        }
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public com.google.monitoring.v3.TypedValue.Builder addValuesBuilder() {
        return getValuesFieldBuilder()
            .addBuilder(com.google.monitoring.v3.TypedValue.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public com.google.monitoring.v3.TypedValue.Builder addValuesBuilder(int index) {
        return getValuesFieldBuilder()
            .addBuilder(index, com.google.monitoring.v3.TypedValue.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The values that make up the point.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.TypedValue values = 1;</code>
       */
      public java.util.List<com.google.monitoring.v3.TypedValue.Builder> getValuesBuilderList() {
        return getValuesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.TypedValue,
              com.google.monitoring.v3.TypedValue.Builder,
              com.google.monitoring.v3.TypedValueOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          valuesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.monitoring.v3.TypedValue,
                  com.google.monitoring.v3.TypedValue.Builder,
                  com.google.monitoring.v3.TypedValueOrBuilder>(
                  values_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          values_ = null;
        }
        return valuesBuilder_;
      }

      private com.google.monitoring.v3.TimeInterval timeInterval_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.TimeInterval,
              com.google.monitoring.v3.TimeInterval.Builder,
              com.google.monitoring.v3.TimeIntervalOrBuilder>
          timeIntervalBuilder_;
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       *
       * @return Whether the timeInterval field is set.
       */
      public boolean hasTimeInterval() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       *
       * @return The timeInterval.
       */
      public com.google.monitoring.v3.TimeInterval getTimeInterval() {
        if (timeIntervalBuilder_ == null) {
          return timeInterval_ == null
              ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
              : timeInterval_;
        } else {
          return timeIntervalBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      public Builder setTimeInterval(com.google.monitoring.v3.TimeInterval value) {
        if (timeIntervalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeInterval_ = value;
        } else {
          timeIntervalBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      public Builder setTimeInterval(
          com.google.monitoring.v3.TimeInterval.Builder builderForValue) {
        if (timeIntervalBuilder_ == null) {
          timeInterval_ = builderForValue.build();
        } else {
          timeIntervalBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      public Builder mergeTimeInterval(com.google.monitoring.v3.TimeInterval value) {
        if (timeIntervalBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && timeInterval_ != null
              && timeInterval_ != com.google.monitoring.v3.TimeInterval.getDefaultInstance()) {
            getTimeIntervalBuilder().mergeFrom(value);
          } else {
            timeInterval_ = value;
          }
        } else {
          timeIntervalBuilder_.mergeFrom(value);
        }
        if (timeInterval_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      public Builder clearTimeInterval() {
        bitField0_ = (bitField0_ & ~0x00000002);
        timeInterval_ = null;
        if (timeIntervalBuilder_ != null) {
          timeIntervalBuilder_.dispose();
          timeIntervalBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      public com.google.monitoring.v3.TimeInterval.Builder getTimeIntervalBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTimeIntervalFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      public com.google.monitoring.v3.TimeIntervalOrBuilder getTimeIntervalOrBuilder() {
        if (timeIntervalBuilder_ != null) {
          return timeIntervalBuilder_.getMessageOrBuilder();
        } else {
          return timeInterval_ == null
              ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
              : timeInterval_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time interval associated with the point.
       * </pre>
       *
       * <code>.google.monitoring.v3.TimeInterval time_interval = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.TimeInterval,
              com.google.monitoring.v3.TimeInterval.Builder,
              com.google.monitoring.v3.TimeIntervalOrBuilder>
          getTimeIntervalFieldBuilder() {
        if (timeIntervalBuilder_ == null) {
          timeIntervalBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.TimeInterval,
                  com.google.monitoring.v3.TimeInterval.Builder,
                  com.google.monitoring.v3.TimeIntervalOrBuilder>(
                  getTimeInterval(), getParentForChildren(), isClean());
          timeInterval_ = null;
        }
        return timeIntervalBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TimeSeriesData.PointData)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.TimeSeriesData.PointData)
    private static final com.google.monitoring.v3.TimeSeriesData.PointData DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.TimeSeriesData.PointData();
    }

    public static com.google.monitoring.v3.TimeSeriesData.PointData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PointData> PARSER =
        new com.google.protobuf.AbstractParser<PointData>() {
          @java.lang.Override
          public PointData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PointData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PointData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesData.PointData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int LABEL_VALUES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.LabelValue> labelValues_;
  /**
   *
   *
   * <pre>
   * The values of the labels in the time series identifier, given in the same
   * order as the `label_descriptors` field of the TimeSeriesDescriptor
   * associated with this object. Each value must have a value of the type
   * given in the corresponding entry of `label_descriptors`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.LabelValue> getLabelValuesList() {
    return labelValues_;
  }
  /**
   *
   *
   * <pre>
   * The values of the labels in the time series identifier, given in the same
   * order as the `label_descriptors` field of the TimeSeriesDescriptor
   * associated with this object. Each value must have a value of the type
   * given in the corresponding entry of `label_descriptors`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.LabelValueOrBuilder>
      getLabelValuesOrBuilderList() {
    return labelValues_;
  }
  /**
   *
   *
   * <pre>
   * The values of the labels in the time series identifier, given in the same
   * order as the `label_descriptors` field of the TimeSeriesDescriptor
   * associated with this object. Each value must have a value of the type
   * given in the corresponding entry of `label_descriptors`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
   */
  @java.lang.Override
  public int getLabelValuesCount() {
    return labelValues_.size();
  }
  /**
   *
   *
   * <pre>
   * The values of the labels in the time series identifier, given in the same
   * order as the `label_descriptors` field of the TimeSeriesDescriptor
   * associated with this object. Each value must have a value of the type
   * given in the corresponding entry of `label_descriptors`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.LabelValue getLabelValues(int index) {
    return labelValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The values of the labels in the time series identifier, given in the same
   * order as the `label_descriptors` field of the TimeSeriesDescriptor
   * associated with this object. Each value must have a value of the type
   * given in the corresponding entry of `label_descriptors`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.LabelValueOrBuilder getLabelValuesOrBuilder(int index) {
    return labelValues_.get(index);
  }

  public static final int POINT_DATA_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.TimeSeriesData.PointData> pointData_;
  /**
   *
   *
   * <pre>
   * The points in the time series.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.TimeSeriesData.PointData> getPointDataList() {
    return pointData_;
  }
  /**
   *
   *
   * <pre>
   * The points in the time series.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder>
      getPointDataOrBuilderList() {
    return pointData_;
  }
  /**
   *
   *
   * <pre>
   * The points in the time series.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
   */
  @java.lang.Override
  public int getPointDataCount() {
    return pointData_.size();
  }
  /**
   *
   *
   * <pre>
   * The points in the time series.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesData.PointData getPointData(int index) {
    return pointData_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The points in the time series.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder getPointDataOrBuilder(
      int index) {
    return pointData_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < labelValues_.size(); i++) {
      output.writeMessage(1, labelValues_.get(i));
    }
    for (int i = 0; i < pointData_.size(); i++) {
      output.writeMessage(2, pointData_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < labelValues_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, labelValues_.get(i));
    }
    for (int i = 0; i < pointData_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, pointData_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.TimeSeriesData)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.TimeSeriesData other = (com.google.monitoring.v3.TimeSeriesData) obj;

    if (!getLabelValuesList().equals(other.getLabelValuesList())) return false;
    if (!getPointDataList().equals(other.getPointDataList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLabelValuesCount() > 0) {
      hash = (37 * hash) + LABEL_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getLabelValuesList().hashCode();
    }
    if (getPointDataCount() > 0) {
      hash = (37 * hash) + POINT_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getPointDataList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeriesData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.TimeSeriesData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the values of a time series associated with a
   * TimeSeriesDescriptor.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TimeSeriesData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TimeSeriesData)
      com.google.monitoring.v3.TimeSeriesDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TimeSeriesData.class,
              com.google.monitoring.v3.TimeSeriesData.Builder.class);
    }

    // Construct using com.google.monitoring.v3.TimeSeriesData.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (labelValuesBuilder_ == null) {
        labelValues_ = java.util.Collections.emptyList();
      } else {
        labelValues_ = null;
        labelValuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (pointDataBuilder_ == null) {
        pointData_ = java.util.Collections.emptyList();
      } else {
        pointData_ = null;
        pointDataBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeriesData_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesData getDefaultInstanceForType() {
      return com.google.monitoring.v3.TimeSeriesData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesData build() {
      com.google.monitoring.v3.TimeSeriesData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeriesData buildPartial() {
      com.google.monitoring.v3.TimeSeriesData result =
          new com.google.monitoring.v3.TimeSeriesData(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.monitoring.v3.TimeSeriesData result) {
      if (labelValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          labelValues_ = java.util.Collections.unmodifiableList(labelValues_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.labelValues_ = labelValues_;
      } else {
        result.labelValues_ = labelValuesBuilder_.build();
      }
      if (pointDataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          pointData_ = java.util.Collections.unmodifiableList(pointData_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.pointData_ = pointData_;
      } else {
        result.pointData_ = pointDataBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.TimeSeriesData result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.TimeSeriesData) {
        return mergeFrom((com.google.monitoring.v3.TimeSeriesData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.TimeSeriesData other) {
      if (other == com.google.monitoring.v3.TimeSeriesData.getDefaultInstance()) return this;
      if (labelValuesBuilder_ == null) {
        if (!other.labelValues_.isEmpty()) {
          if (labelValues_.isEmpty()) {
            labelValues_ = other.labelValues_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLabelValuesIsMutable();
            labelValues_.addAll(other.labelValues_);
          }
          onChanged();
        }
      } else {
        if (!other.labelValues_.isEmpty()) {
          if (labelValuesBuilder_.isEmpty()) {
            labelValuesBuilder_.dispose();
            labelValuesBuilder_ = null;
            labelValues_ = other.labelValues_;
            bitField0_ = (bitField0_ & ~0x00000001);
            labelValuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelValuesFieldBuilder()
                    : null;
          } else {
            labelValuesBuilder_.addAllMessages(other.labelValues_);
          }
        }
      }
      if (pointDataBuilder_ == null) {
        if (!other.pointData_.isEmpty()) {
          if (pointData_.isEmpty()) {
            pointData_ = other.pointData_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePointDataIsMutable();
            pointData_.addAll(other.pointData_);
          }
          onChanged();
        }
      } else {
        if (!other.pointData_.isEmpty()) {
          if (pointDataBuilder_.isEmpty()) {
            pointDataBuilder_.dispose();
            pointDataBuilder_ = null;
            pointData_ = other.pointData_;
            bitField0_ = (bitField0_ & ~0x00000002);
            pointDataBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPointDataFieldBuilder()
                    : null;
          } else {
            pointDataBuilder_.addAllMessages(other.pointData_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.monitoring.v3.LabelValue m =
                    input.readMessage(
                        com.google.monitoring.v3.LabelValue.parser(), extensionRegistry);
                if (labelValuesBuilder_ == null) {
                  ensureLabelValuesIsMutable();
                  labelValues_.add(m);
                } else {
                  labelValuesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.monitoring.v3.TimeSeriesData.PointData m =
                    input.readMessage(
                        com.google.monitoring.v3.TimeSeriesData.PointData.parser(),
                        extensionRegistry);
                if (pointDataBuilder_ == null) {
                  ensurePointDataIsMutable();
                  pointData_.add(m);
                } else {
                  pointDataBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.monitoring.v3.LabelValue> labelValues_ =
        java.util.Collections.emptyList();

    private void ensureLabelValuesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        labelValues_ = new java.util.ArrayList<com.google.monitoring.v3.LabelValue>(labelValues_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.LabelValue,
            com.google.monitoring.v3.LabelValue.Builder,
            com.google.monitoring.v3.LabelValueOrBuilder>
        labelValuesBuilder_;

    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public java.util.List<com.google.monitoring.v3.LabelValue> getLabelValuesList() {
      if (labelValuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labelValues_);
      } else {
        return labelValuesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public int getLabelValuesCount() {
      if (labelValuesBuilder_ == null) {
        return labelValues_.size();
      } else {
        return labelValuesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public com.google.monitoring.v3.LabelValue getLabelValues(int index) {
      if (labelValuesBuilder_ == null) {
        return labelValues_.get(index);
      } else {
        return labelValuesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder setLabelValues(int index, com.google.monitoring.v3.LabelValue value) {
      if (labelValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelValuesIsMutable();
        labelValues_.set(index, value);
        onChanged();
      } else {
        labelValuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder setLabelValues(
        int index, com.google.monitoring.v3.LabelValue.Builder builderForValue) {
      if (labelValuesBuilder_ == null) {
        ensureLabelValuesIsMutable();
        labelValues_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelValuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder addLabelValues(com.google.monitoring.v3.LabelValue value) {
      if (labelValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelValuesIsMutable();
        labelValues_.add(value);
        onChanged();
      } else {
        labelValuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder addLabelValues(int index, com.google.monitoring.v3.LabelValue value) {
      if (labelValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelValuesIsMutable();
        labelValues_.add(index, value);
        onChanged();
      } else {
        labelValuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder addLabelValues(com.google.monitoring.v3.LabelValue.Builder builderForValue) {
      if (labelValuesBuilder_ == null) {
        ensureLabelValuesIsMutable();
        labelValues_.add(builderForValue.build());
        onChanged();
      } else {
        labelValuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder addLabelValues(
        int index, com.google.monitoring.v3.LabelValue.Builder builderForValue) {
      if (labelValuesBuilder_ == null) {
        ensureLabelValuesIsMutable();
        labelValues_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelValuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder addAllLabelValues(
        java.lang.Iterable<? extends com.google.monitoring.v3.LabelValue> values) {
      if (labelValuesBuilder_ == null) {
        ensureLabelValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labelValues_);
        onChanged();
      } else {
        labelValuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder clearLabelValues() {
      if (labelValuesBuilder_ == null) {
        labelValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        labelValuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public Builder removeLabelValues(int index) {
      if (labelValuesBuilder_ == null) {
        ensureLabelValuesIsMutable();
        labelValues_.remove(index);
        onChanged();
      } else {
        labelValuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public com.google.monitoring.v3.LabelValue.Builder getLabelValuesBuilder(int index) {
      return getLabelValuesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public com.google.monitoring.v3.LabelValueOrBuilder getLabelValuesOrBuilder(int index) {
      if (labelValuesBuilder_ == null) {
        return labelValues_.get(index);
      } else {
        return labelValuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.LabelValueOrBuilder>
        getLabelValuesOrBuilderList() {
      if (labelValuesBuilder_ != null) {
        return labelValuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labelValues_);
      }
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public com.google.monitoring.v3.LabelValue.Builder addLabelValuesBuilder() {
      return getLabelValuesFieldBuilder()
          .addBuilder(com.google.monitoring.v3.LabelValue.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public com.google.monitoring.v3.LabelValue.Builder addLabelValuesBuilder(int index) {
      return getLabelValuesFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.LabelValue.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The values of the labels in the time series identifier, given in the same
     * order as the `label_descriptors` field of the TimeSeriesDescriptor
     * associated with this object. Each value must have a value of the type
     * given in the corresponding entry of `label_descriptors`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.LabelValue label_values = 1;</code>
     */
    public java.util.List<com.google.monitoring.v3.LabelValue.Builder> getLabelValuesBuilderList() {
      return getLabelValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.LabelValue,
            com.google.monitoring.v3.LabelValue.Builder,
            com.google.monitoring.v3.LabelValueOrBuilder>
        getLabelValuesFieldBuilder() {
      if (labelValuesBuilder_ == null) {
        labelValuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.LabelValue,
                com.google.monitoring.v3.LabelValue.Builder,
                com.google.monitoring.v3.LabelValueOrBuilder>(
                labelValues_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        labelValues_ = null;
      }
      return labelValuesBuilder_;
    }

    private java.util.List<com.google.monitoring.v3.TimeSeriesData.PointData> pointData_ =
        java.util.Collections.emptyList();

    private void ensurePointDataIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        pointData_ =
            new java.util.ArrayList<com.google.monitoring.v3.TimeSeriesData.PointData>(pointData_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesData.PointData,
            com.google.monitoring.v3.TimeSeriesData.PointData.Builder,
            com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder>
        pointDataBuilder_;

    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeriesData.PointData> getPointDataList() {
      if (pointDataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pointData_);
      } else {
        return pointDataBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public int getPointDataCount() {
      if (pointDataBuilder_ == null) {
        return pointData_.size();
      } else {
        return pointDataBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.PointData getPointData(int index) {
      if (pointDataBuilder_ == null) {
        return pointData_.get(index);
      } else {
        return pointDataBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder setPointData(
        int index, com.google.monitoring.v3.TimeSeriesData.PointData value) {
      if (pointDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointDataIsMutable();
        pointData_.set(index, value);
        onChanged();
      } else {
        pointDataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder setPointData(
        int index, com.google.monitoring.v3.TimeSeriesData.PointData.Builder builderForValue) {
      if (pointDataBuilder_ == null) {
        ensurePointDataIsMutable();
        pointData_.set(index, builderForValue.build());
        onChanged();
      } else {
        pointDataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder addPointData(com.google.monitoring.v3.TimeSeriesData.PointData value) {
      if (pointDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointDataIsMutable();
        pointData_.add(value);
        onChanged();
      } else {
        pointDataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder addPointData(
        int index, com.google.monitoring.v3.TimeSeriesData.PointData value) {
      if (pointDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointDataIsMutable();
        pointData_.add(index, value);
        onChanged();
      } else {
        pointDataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder addPointData(
        com.google.monitoring.v3.TimeSeriesData.PointData.Builder builderForValue) {
      if (pointDataBuilder_ == null) {
        ensurePointDataIsMutable();
        pointData_.add(builderForValue.build());
        onChanged();
      } else {
        pointDataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder addPointData(
        int index, com.google.monitoring.v3.TimeSeriesData.PointData.Builder builderForValue) {
      if (pointDataBuilder_ == null) {
        ensurePointDataIsMutable();
        pointData_.add(index, builderForValue.build());
        onChanged();
      } else {
        pointDataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder addAllPointData(
        java.lang.Iterable<? extends com.google.monitoring.v3.TimeSeriesData.PointData> values) {
      if (pointDataBuilder_ == null) {
        ensurePointDataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pointData_);
        onChanged();
      } else {
        pointDataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder clearPointData() {
      if (pointDataBuilder_ == null) {
        pointData_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        pointDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public Builder removePointData(int index) {
      if (pointDataBuilder_ == null) {
        ensurePointDataIsMutable();
        pointData_.remove(index);
        onChanged();
      } else {
        pointDataBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.PointData.Builder getPointDataBuilder(
        int index) {
      return getPointDataFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder getPointDataOrBuilder(
        int index) {
      if (pointDataBuilder_ == null) {
        return pointData_.get(index);
      } else {
        return pointDataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder>
        getPointDataOrBuilderList() {
      if (pointDataBuilder_ != null) {
        return pointDataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pointData_);
      }
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.PointData.Builder addPointDataBuilder() {
      return getPointDataFieldBuilder()
          .addBuilder(com.google.monitoring.v3.TimeSeriesData.PointData.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.PointData.Builder addPointDataBuilder(
        int index) {
      return getPointDataFieldBuilder()
          .addBuilder(
              index, com.google.monitoring.v3.TimeSeriesData.PointData.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The points in the time series.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData.PointData point_data = 2;</code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeriesData.PointData.Builder>
        getPointDataBuilderList() {
      return getPointDataFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesData.PointData,
            com.google.monitoring.v3.TimeSeriesData.PointData.Builder,
            com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder>
        getPointDataFieldBuilder() {
      if (pointDataBuilder_ == null) {
        pointDataBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.TimeSeriesData.PointData,
                com.google.monitoring.v3.TimeSeriesData.PointData.Builder,
                com.google.monitoring.v3.TimeSeriesData.PointDataOrBuilder>(
                pointData_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        pointData_ = null;
      }
      return pointDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TimeSeriesData)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.TimeSeriesData)
  private static final com.google.monitoring.v3.TimeSeriesData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.TimeSeriesData();
  }

  public static com.google.monitoring.v3.TimeSeriesData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeriesData> PARSER =
      new com.google.protobuf.AbstractParser<TimeSeriesData>() {
        @java.lang.Override
        public TimeSeriesData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeSeriesData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeriesData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
