/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * Details of the final state "drop" and associated resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.DropInfo}
 */
public final class DropInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.DropInfo)
    DropInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DropInfo.newBuilder() to construct.
  private DropInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DropInfo() {
    cause_ = 0;
    resourceUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DropInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_DropInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_DropInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.DropInfo.class,
            com.google.cloud.networkmanagement.v1.DropInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Drop cause types:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.DropInfo.Cause}
   */
  public enum Cause implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Cause is unspecified.
     * </pre>
     *
     * <code>CAUSE_UNSPECIFIED = 0;</code>
     */
    CAUSE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Destination external address cannot be resolved to a known target. If
     * the address is used in a Google Cloud project, provide the project ID
     * as test input.
     * </pre>
     *
     * <code>UNKNOWN_EXTERNAL_ADDRESS = 1;</code>
     */
    UNKNOWN_EXTERNAL_ADDRESS(1),
    /**
     *
     *
     * <pre>
     * A Compute Engine instance can only send or receive a packet with a
     * foreign IP address if ip_forward is enabled.
     * </pre>
     *
     * <code>FOREIGN_IP_DISALLOWED = 2;</code>
     */
    FOREIGN_IP_DISALLOWED(2),
    /**
     *
     *
     * <pre>
     * Dropped due to a firewall rule, unless allowed due to connection
     * tracking.
     * </pre>
     *
     * <code>FIREWALL_RULE = 3;</code>
     */
    FIREWALL_RULE(3),
    /**
     *
     *
     * <pre>
     * Dropped due to no routes.
     * </pre>
     *
     * <code>NO_ROUTE = 4;</code>
     */
    NO_ROUTE(4),
    /**
     *
     *
     * <pre>
     * Dropped due to invalid route. Route's next hop is a blackhole.
     * </pre>
     *
     * <code>ROUTE_BLACKHOLE = 5;</code>
     */
    ROUTE_BLACKHOLE(5),
    /**
     *
     *
     * <pre>
     * Packet is sent to a wrong (unintended) network. Example: you trace a
     * packet from VM1:Network1 to VM2:Network2, however, the route configured
     * in Network1 sends the packet destined for VM2's IP addresss to Network3.
     * </pre>
     *
     * <code>ROUTE_WRONG_NETWORK = 6;</code>
     */
    ROUTE_WRONG_NETWORK(6),
    /**
     *
     *
     * <pre>
     * Packet with internal destination address sent to the internet gateway.
     * </pre>
     *
     * <code>PRIVATE_TRAFFIC_TO_INTERNET = 7;</code>
     */
    PRIVATE_TRAFFIC_TO_INTERNET(7),
    /**
     *
     *
     * <pre>
     * Instance with only an internal IP address tries to access Google API and
     * services, but private Google access is not enabled.
     * </pre>
     *
     * <code>PRIVATE_GOOGLE_ACCESS_DISALLOWED = 8;</code>
     */
    PRIVATE_GOOGLE_ACCESS_DISALLOWED(8),
    /**
     *
     *
     * <pre>
     * Instance with only an internal IP address tries to access external hosts,
     * but Cloud NAT is not enabled in the subnet, unless special configurations
     * on a VM allow this connection.
     * </pre>
     *
     * <code>NO_EXTERNAL_ADDRESS = 9;</code>
     */
    NO_EXTERNAL_ADDRESS(9),
    /**
     *
     *
     * <pre>
     * Destination internal address cannot be resolved to a known target. If
     * this is a shared VPC scenario, verify if the service project ID is
     * provided as test input. Otherwise, verify if the IP address is being
     * used in the project.
     * </pre>
     *
     * <code>UNKNOWN_INTERNAL_ADDRESS = 10;</code>
     */
    UNKNOWN_INTERNAL_ADDRESS(10),
    /**
     *
     *
     * <pre>
     * Forwarding rule's protocol and ports do not match the packet header.
     * </pre>
     *
     * <code>FORWARDING_RULE_MISMATCH = 11;</code>
     */
    FORWARDING_RULE_MISMATCH(11),
    /**
     *
     *
     * <pre>
     * Packet could be dropped because it was sent from a different region
     * to a regional forwarding without global access.
     * </pre>
     *
     * <code>FORWARDING_RULE_REGION_MISMATCH = 25;</code>
     */
    FORWARDING_RULE_REGION_MISMATCH(25),
    /**
     *
     *
     * <pre>
     * Forwarding rule does not have backends configured.
     * </pre>
     *
     * <code>FORWARDING_RULE_NO_INSTANCES = 12;</code>
     */
    FORWARDING_RULE_NO_INSTANCES(12),
    /**
     *
     *
     * <pre>
     * Firewalls block the health check probes to the backends and cause
     * the backends to be unavailable for traffic from the load balancer.
     * For more details, see [Health check firewall
     * rules](https://cloud.google.com/load-balancing/docs/health-checks#firewall_rules).
     * </pre>
     *
     * <code>FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK = 13;</code>
     */
    FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK(13),
    /**
     *
     *
     * <pre>
     * Packet is sent from or to a Compute Engine instance that is not in a
     * running state.
     * </pre>
     *
     * <code>INSTANCE_NOT_RUNNING = 14;</code>
     */
    INSTANCE_NOT_RUNNING(14),
    /**
     *
     *
     * <pre>
     * Packet sent from or to a GKE cluster that is not in running state.
     * </pre>
     *
     * <code>GKE_CLUSTER_NOT_RUNNING = 27;</code>
     */
    GKE_CLUSTER_NOT_RUNNING(27),
    /**
     *
     *
     * <pre>
     * Packet sent from or to a Cloud SQL instance that is not in running state.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NOT_RUNNING = 28;</code>
     */
    CLOUD_SQL_INSTANCE_NOT_RUNNING(28),
    /**
     *
     *
     * <pre>
     * The type of traffic is blocked and the user cannot configure a firewall
     * rule to enable it. See [Always blocked
     * traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic) for
     * more details.
     * </pre>
     *
     * <code>TRAFFIC_TYPE_BLOCKED = 15;</code>
     */
    TRAFFIC_TYPE_BLOCKED(15),
    /**
     *
     *
     * <pre>
     * Access to Google Kubernetes Engine cluster master's endpoint is not
     * authorized. See [Access to the cluster
     * endpoints](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#access_to_the_cluster_endpoints)
     * for more details.
     * </pre>
     *
     * <code>GKE_MASTER_UNAUTHORIZED_ACCESS = 16;</code>
     */
    GKE_MASTER_UNAUTHORIZED_ACCESS(16),
    /**
     *
     *
     * <pre>
     * Access to the Cloud SQL instance endpoint is not authorized.
     * See [Authorizing with authorized
     * networks](https://cloud.google.com/sql/docs/mysql/authorize-networks) for
     * more details.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS = 17;</code>
     */
    CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS(17),
    /**
     *
     *
     * <pre>
     * Packet was dropped inside Google Kubernetes Engine Service.
     * </pre>
     *
     * <code>DROPPED_INSIDE_GKE_SERVICE = 18;</code>
     */
    DROPPED_INSIDE_GKE_SERVICE(18),
    /**
     *
     *
     * <pre>
     * Packet was dropped inside Cloud SQL Service.
     * </pre>
     *
     * <code>DROPPED_INSIDE_CLOUD_SQL_SERVICE = 19;</code>
     */
    DROPPED_INSIDE_CLOUD_SQL_SERVICE(19),
    /**
     *
     *
     * <pre>
     * Packet was dropped because there is no peering between the originating
     * network and the Google Managed Services Network.
     * </pre>
     *
     * <code>GOOGLE_MANAGED_SERVICE_NO_PEERING = 20;</code>
     */
    GOOGLE_MANAGED_SERVICE_NO_PEERING(20),
    /**
     *
     *
     * <pre>
     * Packet was dropped because the Google-managed service uses Private
     * Service Connect (PSC), but the PSC endpoint is not found in the project.
     * </pre>
     *
     * <code>GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT = 38;</code>
     */
    GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT(38),
    /**
     *
     *
     * <pre>
     * Packet was dropped because the GKE cluster uses Private Service Connect
     * (PSC), but the PSC endpoint is not found in the project.
     * </pre>
     *
     * <code>GKE_PSC_ENDPOINT_MISSING = 36;</code>
     */
    GKE_PSC_ENDPOINT_MISSING(36),
    /**
     *
     *
     * <pre>
     * Packet was dropped because the Cloud SQL instance has neither a private
     * nor a public IP address.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NO_IP_ADDRESS = 21;</code>
     */
    CLOUD_SQL_INSTANCE_NO_IP_ADDRESS(21),
    /**
     *
     *
     * <pre>
     * Packet was dropped because a GKE cluster private endpoint is
     * unreachable from a region different from the cluster's region.
     * </pre>
     *
     * <code>GKE_CONTROL_PLANE_REGION_MISMATCH = 30;</code>
     */
    GKE_CONTROL_PLANE_REGION_MISMATCH(30),
    /**
     *
     *
     * <pre>
     * Packet sent from a public GKE cluster control plane to a private
     * IP address.
     * </pre>
     *
     * <code>PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION = 31;</code>
     */
    PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION(31),
    /**
     *
     *
     * <pre>
     * Packet was dropped because there is no route from a GKE cluster
     * control plane to a destination network.
     * </pre>
     *
     * <code>GKE_CONTROL_PLANE_NO_ROUTE = 32;</code>
     */
    GKE_CONTROL_PLANE_NO_ROUTE(32),
    /**
     *
     *
     * <pre>
     * Packet sent from a Cloud SQL instance to an external IP address is not
     * allowed. The Cloud SQL instance is not configured to send packets to
     * external IP addresses.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC = 33;</code>
     */
    CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC(33),
    /**
     *
     *
     * <pre>
     * Packet sent from a Cloud SQL instance with only a public IP address to a
     * private IP address.
     * </pre>
     *
     * <code>PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION = 34;</code>
     */
    PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION(34),
    /**
     *
     *
     * <pre>
     * Packet was dropped because there is no route from a Cloud SQL
     * instance to a destination network.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NO_ROUTE = 35;</code>
     */
    CLOUD_SQL_INSTANCE_NO_ROUTE(35),
    /**
     *
     *
     * <pre>
     * Packet could be dropped because the Cloud Function is not in an active
     * status.
     * </pre>
     *
     * <code>CLOUD_FUNCTION_NOT_ACTIVE = 22;</code>
     */
    CLOUD_FUNCTION_NOT_ACTIVE(22),
    /**
     *
     *
     * <pre>
     * Packet could be dropped because no VPC connector is set.
     * </pre>
     *
     * <code>VPC_CONNECTOR_NOT_SET = 23;</code>
     */
    VPC_CONNECTOR_NOT_SET(23),
    /**
     *
     *
     * <pre>
     * Packet could be dropped because the VPC connector is not in a running
     * state.
     * </pre>
     *
     * <code>VPC_CONNECTOR_NOT_RUNNING = 24;</code>
     */
    VPC_CONNECTOR_NOT_RUNNING(24),
    /**
     *
     *
     * <pre>
     * The Private Service Connect endpoint is in a project that is not approved
     * to connect to the service.
     * </pre>
     *
     * <code>PSC_CONNECTION_NOT_ACCEPTED = 26;</code>
     */
    PSC_CONNECTION_NOT_ACCEPTED(26),
    /**
     *
     *
     * <pre>
     * Packet sent from a Cloud Run revision that is not ready.
     * </pre>
     *
     * <code>CLOUD_RUN_REVISION_NOT_READY = 29;</code>
     */
    CLOUD_RUN_REVISION_NOT_READY(29),
    /**
     *
     *
     * <pre>
     * Packet was dropped inside Private Service Connect service producer.
     * </pre>
     *
     * <code>DROPPED_INSIDE_PSC_SERVICE_PRODUCER = 37;</code>
     */
    DROPPED_INSIDE_PSC_SERVICE_PRODUCER(37),
    /**
     *
     *
     * <pre>
     * Packet sent to a load balancer, which requires a proxy-only subnet and
     * the subnet is not found.
     * </pre>
     *
     * <code>LOAD_BALANCER_HAS_NO_PROXY_SUBNET = 39;</code>
     */
    LOAD_BALANCER_HAS_NO_PROXY_SUBNET(39),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Cause is unspecified.
     * </pre>
     *
     * <code>CAUSE_UNSPECIFIED = 0;</code>
     */
    public static final int CAUSE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Destination external address cannot be resolved to a known target. If
     * the address is used in a Google Cloud project, provide the project ID
     * as test input.
     * </pre>
     *
     * <code>UNKNOWN_EXTERNAL_ADDRESS = 1;</code>
     */
    public static final int UNKNOWN_EXTERNAL_ADDRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A Compute Engine instance can only send or receive a packet with a
     * foreign IP address if ip_forward is enabled.
     * </pre>
     *
     * <code>FOREIGN_IP_DISALLOWED = 2;</code>
     */
    public static final int FOREIGN_IP_DISALLOWED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Dropped due to a firewall rule, unless allowed due to connection
     * tracking.
     * </pre>
     *
     * <code>FIREWALL_RULE = 3;</code>
     */
    public static final int FIREWALL_RULE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Dropped due to no routes.
     * </pre>
     *
     * <code>NO_ROUTE = 4;</code>
     */
    public static final int NO_ROUTE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Dropped due to invalid route. Route's next hop is a blackhole.
     * </pre>
     *
     * <code>ROUTE_BLACKHOLE = 5;</code>
     */
    public static final int ROUTE_BLACKHOLE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Packet is sent to a wrong (unintended) network. Example: you trace a
     * packet from VM1:Network1 to VM2:Network2, however, the route configured
     * in Network1 sends the packet destined for VM2's IP addresss to Network3.
     * </pre>
     *
     * <code>ROUTE_WRONG_NETWORK = 6;</code>
     */
    public static final int ROUTE_WRONG_NETWORK_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Packet with internal destination address sent to the internet gateway.
     * </pre>
     *
     * <code>PRIVATE_TRAFFIC_TO_INTERNET = 7;</code>
     */
    public static final int PRIVATE_TRAFFIC_TO_INTERNET_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Instance with only an internal IP address tries to access Google API and
     * services, but private Google access is not enabled.
     * </pre>
     *
     * <code>PRIVATE_GOOGLE_ACCESS_DISALLOWED = 8;</code>
     */
    public static final int PRIVATE_GOOGLE_ACCESS_DISALLOWED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Instance with only an internal IP address tries to access external hosts,
     * but Cloud NAT is not enabled in the subnet, unless special configurations
     * on a VM allow this connection.
     * </pre>
     *
     * <code>NO_EXTERNAL_ADDRESS = 9;</code>
     */
    public static final int NO_EXTERNAL_ADDRESS_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Destination internal address cannot be resolved to a known target. If
     * this is a shared VPC scenario, verify if the service project ID is
     * provided as test input. Otherwise, verify if the IP address is being
     * used in the project.
     * </pre>
     *
     * <code>UNKNOWN_INTERNAL_ADDRESS = 10;</code>
     */
    public static final int UNKNOWN_INTERNAL_ADDRESS_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Forwarding rule's protocol and ports do not match the packet header.
     * </pre>
     *
     * <code>FORWARDING_RULE_MISMATCH = 11;</code>
     */
    public static final int FORWARDING_RULE_MISMATCH_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Packet could be dropped because it was sent from a different region
     * to a regional forwarding without global access.
     * </pre>
     *
     * <code>FORWARDING_RULE_REGION_MISMATCH = 25;</code>
     */
    public static final int FORWARDING_RULE_REGION_MISMATCH_VALUE = 25;
    /**
     *
     *
     * <pre>
     * Forwarding rule does not have backends configured.
     * </pre>
     *
     * <code>FORWARDING_RULE_NO_INSTANCES = 12;</code>
     */
    public static final int FORWARDING_RULE_NO_INSTANCES_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Firewalls block the health check probes to the backends and cause
     * the backends to be unavailable for traffic from the load balancer.
     * For more details, see [Health check firewall
     * rules](https://cloud.google.com/load-balancing/docs/health-checks#firewall_rules).
     * </pre>
     *
     * <code>FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK = 13;</code>
     */
    public static final int FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Packet is sent from or to a Compute Engine instance that is not in a
     * running state.
     * </pre>
     *
     * <code>INSTANCE_NOT_RUNNING = 14;</code>
     */
    public static final int INSTANCE_NOT_RUNNING_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Packet sent from or to a GKE cluster that is not in running state.
     * </pre>
     *
     * <code>GKE_CLUSTER_NOT_RUNNING = 27;</code>
     */
    public static final int GKE_CLUSTER_NOT_RUNNING_VALUE = 27;
    /**
     *
     *
     * <pre>
     * Packet sent from or to a Cloud SQL instance that is not in running state.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NOT_RUNNING = 28;</code>
     */
    public static final int CLOUD_SQL_INSTANCE_NOT_RUNNING_VALUE = 28;
    /**
     *
     *
     * <pre>
     * The type of traffic is blocked and the user cannot configure a firewall
     * rule to enable it. See [Always blocked
     * traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic) for
     * more details.
     * </pre>
     *
     * <code>TRAFFIC_TYPE_BLOCKED = 15;</code>
     */
    public static final int TRAFFIC_TYPE_BLOCKED_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Access to Google Kubernetes Engine cluster master's endpoint is not
     * authorized. See [Access to the cluster
     * endpoints](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#access_to_the_cluster_endpoints)
     * for more details.
     * </pre>
     *
     * <code>GKE_MASTER_UNAUTHORIZED_ACCESS = 16;</code>
     */
    public static final int GKE_MASTER_UNAUTHORIZED_ACCESS_VALUE = 16;
    /**
     *
     *
     * <pre>
     * Access to the Cloud SQL instance endpoint is not authorized.
     * See [Authorizing with authorized
     * networks](https://cloud.google.com/sql/docs/mysql/authorize-networks) for
     * more details.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS = 17;</code>
     */
    public static final int CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS_VALUE = 17;
    /**
     *
     *
     * <pre>
     * Packet was dropped inside Google Kubernetes Engine Service.
     * </pre>
     *
     * <code>DROPPED_INSIDE_GKE_SERVICE = 18;</code>
     */
    public static final int DROPPED_INSIDE_GKE_SERVICE_VALUE = 18;
    /**
     *
     *
     * <pre>
     * Packet was dropped inside Cloud SQL Service.
     * </pre>
     *
     * <code>DROPPED_INSIDE_CLOUD_SQL_SERVICE = 19;</code>
     */
    public static final int DROPPED_INSIDE_CLOUD_SQL_SERVICE_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Packet was dropped because there is no peering between the originating
     * network and the Google Managed Services Network.
     * </pre>
     *
     * <code>GOOGLE_MANAGED_SERVICE_NO_PEERING = 20;</code>
     */
    public static final int GOOGLE_MANAGED_SERVICE_NO_PEERING_VALUE = 20;
    /**
     *
     *
     * <pre>
     * Packet was dropped because the Google-managed service uses Private
     * Service Connect (PSC), but the PSC endpoint is not found in the project.
     * </pre>
     *
     * <code>GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT = 38;</code>
     */
    public static final int GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT_VALUE = 38;
    /**
     *
     *
     * <pre>
     * Packet was dropped because the GKE cluster uses Private Service Connect
     * (PSC), but the PSC endpoint is not found in the project.
     * </pre>
     *
     * <code>GKE_PSC_ENDPOINT_MISSING = 36;</code>
     */
    public static final int GKE_PSC_ENDPOINT_MISSING_VALUE = 36;
    /**
     *
     *
     * <pre>
     * Packet was dropped because the Cloud SQL instance has neither a private
     * nor a public IP address.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NO_IP_ADDRESS = 21;</code>
     */
    public static final int CLOUD_SQL_INSTANCE_NO_IP_ADDRESS_VALUE = 21;
    /**
     *
     *
     * <pre>
     * Packet was dropped because a GKE cluster private endpoint is
     * unreachable from a region different from the cluster's region.
     * </pre>
     *
     * <code>GKE_CONTROL_PLANE_REGION_MISMATCH = 30;</code>
     */
    public static final int GKE_CONTROL_PLANE_REGION_MISMATCH_VALUE = 30;
    /**
     *
     *
     * <pre>
     * Packet sent from a public GKE cluster control plane to a private
     * IP address.
     * </pre>
     *
     * <code>PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION = 31;</code>
     */
    public static final int PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION_VALUE = 31;
    /**
     *
     *
     * <pre>
     * Packet was dropped because there is no route from a GKE cluster
     * control plane to a destination network.
     * </pre>
     *
     * <code>GKE_CONTROL_PLANE_NO_ROUTE = 32;</code>
     */
    public static final int GKE_CONTROL_PLANE_NO_ROUTE_VALUE = 32;
    /**
     *
     *
     * <pre>
     * Packet sent from a Cloud SQL instance to an external IP address is not
     * allowed. The Cloud SQL instance is not configured to send packets to
     * external IP addresses.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC = 33;</code>
     */
    public static final int CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC_VALUE = 33;
    /**
     *
     *
     * <pre>
     * Packet sent from a Cloud SQL instance with only a public IP address to a
     * private IP address.
     * </pre>
     *
     * <code>PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION = 34;</code>
     */
    public static final int PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION_VALUE = 34;
    /**
     *
     *
     * <pre>
     * Packet was dropped because there is no route from a Cloud SQL
     * instance to a destination network.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE_NO_ROUTE = 35;</code>
     */
    public static final int CLOUD_SQL_INSTANCE_NO_ROUTE_VALUE = 35;
    /**
     *
     *
     * <pre>
     * Packet could be dropped because the Cloud Function is not in an active
     * status.
     * </pre>
     *
     * <code>CLOUD_FUNCTION_NOT_ACTIVE = 22;</code>
     */
    public static final int CLOUD_FUNCTION_NOT_ACTIVE_VALUE = 22;
    /**
     *
     *
     * <pre>
     * Packet could be dropped because no VPC connector is set.
     * </pre>
     *
     * <code>VPC_CONNECTOR_NOT_SET = 23;</code>
     */
    public static final int VPC_CONNECTOR_NOT_SET_VALUE = 23;
    /**
     *
     *
     * <pre>
     * Packet could be dropped because the VPC connector is not in a running
     * state.
     * </pre>
     *
     * <code>VPC_CONNECTOR_NOT_RUNNING = 24;</code>
     */
    public static final int VPC_CONNECTOR_NOT_RUNNING_VALUE = 24;
    /**
     *
     *
     * <pre>
     * The Private Service Connect endpoint is in a project that is not approved
     * to connect to the service.
     * </pre>
     *
     * <code>PSC_CONNECTION_NOT_ACCEPTED = 26;</code>
     */
    public static final int PSC_CONNECTION_NOT_ACCEPTED_VALUE = 26;
    /**
     *
     *
     * <pre>
     * Packet sent from a Cloud Run revision that is not ready.
     * </pre>
     *
     * <code>CLOUD_RUN_REVISION_NOT_READY = 29;</code>
     */
    public static final int CLOUD_RUN_REVISION_NOT_READY_VALUE = 29;
    /**
     *
     *
     * <pre>
     * Packet was dropped inside Private Service Connect service producer.
     * </pre>
     *
     * <code>DROPPED_INSIDE_PSC_SERVICE_PRODUCER = 37;</code>
     */
    public static final int DROPPED_INSIDE_PSC_SERVICE_PRODUCER_VALUE = 37;
    /**
     *
     *
     * <pre>
     * Packet sent to a load balancer, which requires a proxy-only subnet and
     * the subnet is not found.
     * </pre>
     *
     * <code>LOAD_BALANCER_HAS_NO_PROXY_SUBNET = 39;</code>
     */
    public static final int LOAD_BALANCER_HAS_NO_PROXY_SUBNET_VALUE = 39;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Cause valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Cause forNumber(int value) {
      switch (value) {
        case 0:
          return CAUSE_UNSPECIFIED;
        case 1:
          return UNKNOWN_EXTERNAL_ADDRESS;
        case 2:
          return FOREIGN_IP_DISALLOWED;
        case 3:
          return FIREWALL_RULE;
        case 4:
          return NO_ROUTE;
        case 5:
          return ROUTE_BLACKHOLE;
        case 6:
          return ROUTE_WRONG_NETWORK;
        case 7:
          return PRIVATE_TRAFFIC_TO_INTERNET;
        case 8:
          return PRIVATE_GOOGLE_ACCESS_DISALLOWED;
        case 9:
          return NO_EXTERNAL_ADDRESS;
        case 10:
          return UNKNOWN_INTERNAL_ADDRESS;
        case 11:
          return FORWARDING_RULE_MISMATCH;
        case 25:
          return FORWARDING_RULE_REGION_MISMATCH;
        case 12:
          return FORWARDING_RULE_NO_INSTANCES;
        case 13:
          return FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK;
        case 14:
          return INSTANCE_NOT_RUNNING;
        case 27:
          return GKE_CLUSTER_NOT_RUNNING;
        case 28:
          return CLOUD_SQL_INSTANCE_NOT_RUNNING;
        case 15:
          return TRAFFIC_TYPE_BLOCKED;
        case 16:
          return GKE_MASTER_UNAUTHORIZED_ACCESS;
        case 17:
          return CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS;
        case 18:
          return DROPPED_INSIDE_GKE_SERVICE;
        case 19:
          return DROPPED_INSIDE_CLOUD_SQL_SERVICE;
        case 20:
          return GOOGLE_MANAGED_SERVICE_NO_PEERING;
        case 38:
          return GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT;
        case 36:
          return GKE_PSC_ENDPOINT_MISSING;
        case 21:
          return CLOUD_SQL_INSTANCE_NO_IP_ADDRESS;
        case 30:
          return GKE_CONTROL_PLANE_REGION_MISMATCH;
        case 31:
          return PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION;
        case 32:
          return GKE_CONTROL_PLANE_NO_ROUTE;
        case 33:
          return CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC;
        case 34:
          return PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION;
        case 35:
          return CLOUD_SQL_INSTANCE_NO_ROUTE;
        case 22:
          return CLOUD_FUNCTION_NOT_ACTIVE;
        case 23:
          return VPC_CONNECTOR_NOT_SET;
        case 24:
          return VPC_CONNECTOR_NOT_RUNNING;
        case 26:
          return PSC_CONNECTION_NOT_ACCEPTED;
        case 29:
          return CLOUD_RUN_REVISION_NOT_READY;
        case 37:
          return DROPPED_INSIDE_PSC_SERVICE_PRODUCER;
        case 39:
          return LOAD_BALANCER_HAS_NO_PROXY_SUBNET;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Cause> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Cause> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Cause>() {
          public Cause findValueByNumber(int number) {
            return Cause.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.DropInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final Cause[] VALUES = values();

    public static Cause valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Cause(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.DropInfo.Cause)
  }

  public static final int CAUSE_FIELD_NUMBER = 1;
  private int cause_ = 0;
  /**
   *
   *
   * <pre>
   * Cause that the packet is dropped.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
   *
   * @return The enum numeric value on the wire for cause.
   */
  @java.lang.Override
  public int getCauseValue() {
    return cause_;
  }
  /**
   *
   *
   * <pre>
   * Cause that the packet is dropped.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
   *
   * @return The cause.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.DropInfo.Cause getCause() {
    com.google.cloud.networkmanagement.v1.DropInfo.Cause result =
        com.google.cloud.networkmanagement.v1.DropInfo.Cause.forNumber(cause_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.DropInfo.Cause.UNRECOGNIZED
        : result;
  }

  public static final int RESOURCE_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the resource that caused the drop.
   * </pre>
   *
   * <code>string resource_uri = 2;</code>
   *
   * @return The resourceUri.
   */
  @java.lang.Override
  public java.lang.String getResourceUri() {
    java.lang.Object ref = resourceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the resource that caused the drop.
   * </pre>
   *
   * <code>string resource_uri = 2;</code>
   *
   * @return The bytes for resourceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceUriBytes() {
    java.lang.Object ref = resourceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (cause_
        != com.google.cloud.networkmanagement.v1.DropInfo.Cause.CAUSE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, cause_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (cause_
        != com.google.cloud.networkmanagement.v1.DropInfo.Cause.CAUSE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, cause_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.DropInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.DropInfo other =
        (com.google.cloud.networkmanagement.v1.DropInfo) obj;

    if (cause_ != other.cause_) return false;
    if (!getResourceUri().equals(other.getResourceUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CAUSE_FIELD_NUMBER;
    hash = (53 * hash) + cause_;
    hash = (37 * hash) + RESOURCE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getResourceUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.DropInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of the final state "drop" and associated resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.DropInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.DropInfo)
      com.google.cloud.networkmanagement.v1.DropInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_DropInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_DropInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.DropInfo.class,
              com.google.cloud.networkmanagement.v1.DropInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.DropInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cause_ = 0;
      resourceUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_DropInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DropInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DropInfo build() {
      com.google.cloud.networkmanagement.v1.DropInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DropInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.DropInfo result =
          new com.google.cloud.networkmanagement.v1.DropInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.DropInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cause_ = cause_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resourceUri_ = resourceUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.DropInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.DropInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.DropInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance()) return this;
      if (other.cause_ != 0) {
        setCauseValue(other.getCauseValue());
      }
      if (!other.getResourceUri().isEmpty()) {
        resourceUri_ = other.resourceUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                cause_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                resourceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int cause_ = 0;
    /**
     *
     *
     * <pre>
     * Cause that the packet is dropped.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
     *
     * @return The enum numeric value on the wire for cause.
     */
    @java.lang.Override
    public int getCauseValue() {
      return cause_;
    }
    /**
     *
     *
     * <pre>
     * Cause that the packet is dropped.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
     *
     * @param value The enum numeric value on the wire for cause to set.
     * @return This builder for chaining.
     */
    public Builder setCauseValue(int value) {
      cause_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cause that the packet is dropped.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
     *
     * @return The cause.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DropInfo.Cause getCause() {
      com.google.cloud.networkmanagement.v1.DropInfo.Cause result =
          com.google.cloud.networkmanagement.v1.DropInfo.Cause.forNumber(cause_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.DropInfo.Cause.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Cause that the packet is dropped.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
     *
     * @param value The cause to set.
     * @return This builder for chaining.
     */
    public Builder setCause(com.google.cloud.networkmanagement.v1.DropInfo.Cause value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      cause_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cause that the packet is dropped.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo.Cause cause = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCause() {
      bitField0_ = (bitField0_ & ~0x00000001);
      cause_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object resourceUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the resource that caused the drop.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @return The resourceUri.
     */
    public java.lang.String getResourceUri() {
      java.lang.Object ref = resourceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that caused the drop.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @return The bytes for resourceUri.
     */
    public com.google.protobuf.ByteString getResourceUriBytes() {
      java.lang.Object ref = resourceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that caused the drop.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @param value The resourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that caused the drop.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceUri() {
      resourceUri_ = getDefaultInstance().getResourceUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that caused the drop.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @param value The bytes for resourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.DropInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.DropInfo)
  private static final com.google.cloud.networkmanagement.v1.DropInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.DropInfo();
  }

  public static com.google.cloud.networkmanagement.v1.DropInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DropInfo> PARSER =
      new com.google.protobuf.AbstractParser<DropInfo>() {
        @java.lang.Override
        public DropInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DropInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DropInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.DropInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
