/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. The specification of the endpoints for the test.
 * EndpointInfo is derived from source and destination Endpoint and validated
 * by the backend data plane model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.EndpointInfo}
 */
public final class EndpointInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.EndpointInfo)
    EndpointInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EndpointInfo.newBuilder() to construct.
  private EndpointInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EndpointInfo() {
    sourceIp_ = "";
    destinationIp_ = "";
    protocol_ = "";
    sourceNetworkUri_ = "";
    destinationNetworkUri_ = "";
    sourceAgentUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EndpointInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_EndpointInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_EndpointInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.EndpointInfo.class,
            com.google.cloud.networkmanagement.v1.EndpointInfo.Builder.class);
  }

  public static final int SOURCE_IP_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceIp_ = "";
  /**
   *
   *
   * <pre>
   * Source IP address.
   * </pre>
   *
   * <code>string source_ip = 1;</code>
   *
   * @return The sourceIp.
   */
  @java.lang.Override
  public java.lang.String getSourceIp() {
    java.lang.Object ref = sourceIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source IP address.
   * </pre>
   *
   * <code>string source_ip = 1;</code>
   *
   * @return The bytes for sourceIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceIpBytes() {
    java.lang.Object ref = sourceIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_IP_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationIp_ = "";
  /**
   *
   *
   * <pre>
   * Destination IP address.
   * </pre>
   *
   * <code>string destination_ip = 2;</code>
   *
   * @return The destinationIp.
   */
  @java.lang.Override
  public java.lang.String getDestinationIp() {
    java.lang.Object ref = destinationIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP address.
   * </pre>
   *
   * <code>string destination_ip = 2;</code>
   *
   * @return The bytes for destinationIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationIpBytes() {
    java.lang.Object ref = destinationIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTOCOL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protocol_ = "";
  /**
   *
   *
   * <pre>
   * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
   * </pre>
   *
   * <code>string protocol = 3;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
   * </pre>
   *
   * <code>string protocol = 3;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PORT_FIELD_NUMBER = 4;
  private int sourcePort_ = 0;
  /**
   *
   *
   * <pre>
   * Source port. Only valid when protocol is TCP or UDP.
   * </pre>
   *
   * <code>int32 source_port = 4;</code>
   *
   * @return The sourcePort.
   */
  @java.lang.Override
  public int getSourcePort() {
    return sourcePort_;
  }

  public static final int DESTINATION_PORT_FIELD_NUMBER = 5;
  private int destinationPort_ = 0;
  /**
   *
   *
   * <pre>
   * Destination port. Only valid when protocol is TCP or UDP.
   * </pre>
   *
   * <code>int32 destination_port = 5;</code>
   *
   * @return The destinationPort.
   */
  @java.lang.Override
  public int getDestinationPort() {
    return destinationPort_;
  }

  public static final int SOURCE_NETWORK_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceNetworkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the network where this packet originates from.
   * </pre>
   *
   * <code>string source_network_uri = 6;</code>
   *
   * @return The sourceNetworkUri.
   */
  @java.lang.Override
  public java.lang.String getSourceNetworkUri() {
    java.lang.Object ref = sourceNetworkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceNetworkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the network where this packet originates from.
   * </pre>
   *
   * <code>string source_network_uri = 6;</code>
   *
   * @return The bytes for sourceNetworkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceNetworkUriBytes() {
    java.lang.Object ref = sourceNetworkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceNetworkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_NETWORK_URI_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationNetworkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the network where this packet is sent to.
   * </pre>
   *
   * <code>string destination_network_uri = 7;</code>
   *
   * @return The destinationNetworkUri.
   */
  @java.lang.Override
  public java.lang.String getDestinationNetworkUri() {
    java.lang.Object ref = destinationNetworkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationNetworkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the network where this packet is sent to.
   * </pre>
   *
   * <code>string destination_network_uri = 7;</code>
   *
   * @return The bytes for destinationNetworkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationNetworkUriBytes() {
    java.lang.Object ref = destinationNetworkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationNetworkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_AGENT_URI_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceAgentUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the source telemetry agent this packet originates from.
   * </pre>
   *
   * <code>string source_agent_uri = 8;</code>
   *
   * @return The sourceAgentUri.
   */
  @java.lang.Override
  public java.lang.String getSourceAgentUri() {
    java.lang.Object ref = sourceAgentUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceAgentUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the source telemetry agent this packet originates from.
   * </pre>
   *
   * <code>string source_agent_uri = 8;</code>
   *
   * @return The bytes for sourceAgentUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceAgentUriBytes() {
    java.lang.Object ref = sourceAgentUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceAgentUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destinationIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, protocol_);
    }
    if (sourcePort_ != 0) {
      output.writeInt32(4, sourcePort_);
    }
    if (destinationPort_ != 0) {
      output.writeInt32(5, destinationPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNetworkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sourceNetworkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationNetworkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, destinationNetworkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceAgentUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, sourceAgentUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destinationIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, protocol_);
    }
    if (sourcePort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, sourcePort_);
    }
    if (destinationPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, destinationPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNetworkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sourceNetworkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationNetworkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, destinationNetworkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceAgentUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, sourceAgentUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.EndpointInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.EndpointInfo other =
        (com.google.cloud.networkmanagement.v1.EndpointInfo) obj;

    if (!getSourceIp().equals(other.getSourceIp())) return false;
    if (!getDestinationIp().equals(other.getDestinationIp())) return false;
    if (!getProtocol().equals(other.getProtocol())) return false;
    if (getSourcePort() != other.getSourcePort()) return false;
    if (getDestinationPort() != other.getDestinationPort()) return false;
    if (!getSourceNetworkUri().equals(other.getSourceNetworkUri())) return false;
    if (!getDestinationNetworkUri().equals(other.getDestinationNetworkUri())) return false;
    if (!getSourceAgentUri().equals(other.getSourceAgentUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SOURCE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getSourceIp().hashCode();
    hash = (37 * hash) + DESTINATION_IP_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationIp().hashCode();
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    hash = (37 * hash) + SOURCE_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getSourcePort();
    hash = (37 * hash) + DESTINATION_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationPort();
    hash = (37 * hash) + SOURCE_NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSourceNetworkUri().hashCode();
    hash = (37 * hash) + DESTINATION_NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationNetworkUri().hashCode();
    hash = (37 * hash) + SOURCE_AGENT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSourceAgentUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.EndpointInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. The specification of the endpoints for the test.
   * EndpointInfo is derived from source and destination Endpoint and validated
   * by the backend data plane model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.EndpointInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.EndpointInfo)
      com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_EndpointInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_EndpointInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.EndpointInfo.class,
              com.google.cloud.networkmanagement.v1.EndpointInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.EndpointInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceIp_ = "";
      destinationIp_ = "";
      protocol_ = "";
      sourcePort_ = 0;
      destinationPort_ = 0;
      sourceNetworkUri_ = "";
      destinationNetworkUri_ = "";
      sourceAgentUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_EndpointInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.EndpointInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.EndpointInfo build() {
      com.google.cloud.networkmanagement.v1.EndpointInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.EndpointInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.EndpointInfo result =
          new com.google.cloud.networkmanagement.v1.EndpointInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.EndpointInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.sourceIp_ = sourceIp_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destinationIp_ = destinationIp_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.protocol_ = protocol_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sourcePort_ = sourcePort_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.destinationPort_ = destinationPort_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceNetworkUri_ = sourceNetworkUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.destinationNetworkUri_ = destinationNetworkUri_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.sourceAgentUri_ = sourceAgentUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.EndpointInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.EndpointInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.EndpointInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance())
        return this;
      if (!other.getSourceIp().isEmpty()) {
        sourceIp_ = other.sourceIp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDestinationIp().isEmpty()) {
        destinationIp_ = other.destinationIp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getSourcePort() != 0) {
        setSourcePort(other.getSourcePort());
      }
      if (other.getDestinationPort() != 0) {
        setDestinationPort(other.getDestinationPort());
      }
      if (!other.getSourceNetworkUri().isEmpty()) {
        sourceNetworkUri_ = other.sourceNetworkUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDestinationNetworkUri().isEmpty()) {
        destinationNetworkUri_ = other.destinationNetworkUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getSourceAgentUri().isEmpty()) {
        sourceAgentUri_ = other.sourceAgentUri_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                sourceIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                destinationIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                protocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                sourcePort_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                destinationPort_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                sourceNetworkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                destinationNetworkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                sourceAgentUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object sourceIp_ = "";
    /**
     *
     *
     * <pre>
     * Source IP address.
     * </pre>
     *
     * <code>string source_ip = 1;</code>
     *
     * @return The sourceIp.
     */
    public java.lang.String getSourceIp() {
      java.lang.Object ref = sourceIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address.
     * </pre>
     *
     * <code>string source_ip = 1;</code>
     *
     * @return The bytes for sourceIp.
     */
    public com.google.protobuf.ByteString getSourceIpBytes() {
      java.lang.Object ref = sourceIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address.
     * </pre>
     *
     * <code>string source_ip = 1;</code>
     *
     * @param value The sourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setSourceIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceIp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address.
     * </pre>
     *
     * <code>string source_ip = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceIp() {
      sourceIp_ = getDefaultInstance().getSourceIp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address.
     * </pre>
     *
     * <code>string source_ip = 1;</code>
     *
     * @param value The bytes for sourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setSourceIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceIp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object destinationIp_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP address.
     * </pre>
     *
     * <code>string destination_ip = 2;</code>
     *
     * @return The destinationIp.
     */
    public java.lang.String getDestinationIp() {
      java.lang.Object ref = destinationIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address.
     * </pre>
     *
     * <code>string destination_ip = 2;</code>
     *
     * @return The bytes for destinationIp.
     */
    public com.google.protobuf.ByteString getDestinationIpBytes() {
      java.lang.Object ref = destinationIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address.
     * </pre>
     *
     * <code>string destination_ip = 2;</code>
     *
     * @param value The destinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationIp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address.
     * </pre>
     *
     * <code>string destination_ip = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationIp() {
      destinationIp_ = getDefaultInstance().getDestinationIp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address.
     * </pre>
     *
     * <code>string destination_ip = 2;</code>
     *
     * @param value The bytes for destinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationIp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return The bytes for protocol.
     */
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protocol_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {
      protocol_ = getDefaultInstance().getProtocol();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 3;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protocol_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int sourcePort_;
    /**
     *
     *
     * <pre>
     * Source port. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 source_port = 4;</code>
     *
     * @return The sourcePort.
     */
    @java.lang.Override
    public int getSourcePort() {
      return sourcePort_;
    }
    /**
     *
     *
     * <pre>
     * Source port. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 source_port = 4;</code>
     *
     * @param value The sourcePort to set.
     * @return This builder for chaining.
     */
    public Builder setSourcePort(int value) {

      sourcePort_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 source_port = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourcePort() {
      bitField0_ = (bitField0_ & ~0x00000008);
      sourcePort_ = 0;
      onChanged();
      return this;
    }

    private int destinationPort_;
    /**
     *
     *
     * <pre>
     * Destination port. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 destination_port = 5;</code>
     *
     * @return The destinationPort.
     */
    @java.lang.Override
    public int getDestinationPort() {
      return destinationPort_;
    }
    /**
     *
     *
     * <pre>
     * Destination port. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 destination_port = 5;</code>
     *
     * @param value The destinationPort to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPort(int value) {

      destinationPort_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 destination_port = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationPort() {
      bitField0_ = (bitField0_ & ~0x00000010);
      destinationPort_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object sourceNetworkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the network where this packet originates from.
     * </pre>
     *
     * <code>string source_network_uri = 6;</code>
     *
     * @return The sourceNetworkUri.
     */
    public java.lang.String getSourceNetworkUri() {
      java.lang.Object ref = sourceNetworkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceNetworkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet originates from.
     * </pre>
     *
     * <code>string source_network_uri = 6;</code>
     *
     * @return The bytes for sourceNetworkUri.
     */
    public com.google.protobuf.ByteString getSourceNetworkUriBytes() {
      java.lang.Object ref = sourceNetworkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceNetworkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet originates from.
     * </pre>
     *
     * <code>string source_network_uri = 6;</code>
     *
     * @param value The sourceNetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setSourceNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceNetworkUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet originates from.
     * </pre>
     *
     * <code>string source_network_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceNetworkUri() {
      sourceNetworkUri_ = getDefaultInstance().getSourceNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet originates from.
     * </pre>
     *
     * <code>string source_network_uri = 6;</code>
     *
     * @param value The bytes for sourceNetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setSourceNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceNetworkUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object destinationNetworkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the network where this packet is sent to.
     * </pre>
     *
     * <code>string destination_network_uri = 7;</code>
     *
     * @return The destinationNetworkUri.
     */
    public java.lang.String getDestinationNetworkUri() {
      java.lang.Object ref = destinationNetworkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationNetworkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet is sent to.
     * </pre>
     *
     * <code>string destination_network_uri = 7;</code>
     *
     * @return The bytes for destinationNetworkUri.
     */
    public com.google.protobuf.ByteString getDestinationNetworkUriBytes() {
      java.lang.Object ref = destinationNetworkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationNetworkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet is sent to.
     * </pre>
     *
     * <code>string destination_network_uri = 7;</code>
     *
     * @param value The destinationNetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationNetworkUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet is sent to.
     * </pre>
     *
     * <code>string destination_network_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationNetworkUri() {
      destinationNetworkUri_ = getDefaultInstance().getDestinationNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where this packet is sent to.
     * </pre>
     *
     * <code>string destination_network_uri = 7;</code>
     *
     * @param value The bytes for destinationNetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationNetworkUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object sourceAgentUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the source telemetry agent this packet originates from.
     * </pre>
     *
     * <code>string source_agent_uri = 8;</code>
     *
     * @return The sourceAgentUri.
     */
    public java.lang.String getSourceAgentUri() {
      java.lang.Object ref = sourceAgentUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceAgentUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the source telemetry agent this packet originates from.
     * </pre>
     *
     * <code>string source_agent_uri = 8;</code>
     *
     * @return The bytes for sourceAgentUri.
     */
    public com.google.protobuf.ByteString getSourceAgentUriBytes() {
      java.lang.Object ref = sourceAgentUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceAgentUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the source telemetry agent this packet originates from.
     * </pre>
     *
     * <code>string source_agent_uri = 8;</code>
     *
     * @param value The sourceAgentUri to set.
     * @return This builder for chaining.
     */
    public Builder setSourceAgentUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceAgentUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the source telemetry agent this packet originates from.
     * </pre>
     *
     * <code>string source_agent_uri = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceAgentUri() {
      sourceAgentUri_ = getDefaultInstance().getSourceAgentUri();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the source telemetry agent this packet originates from.
     * </pre>
     *
     * <code>string source_agent_uri = 8;</code>
     *
     * @param value The bytes for sourceAgentUri to set.
     * @return This builder for chaining.
     */
    public Builder setSourceAgentUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceAgentUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.EndpointInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.EndpointInfo)
  private static final com.google.cloud.networkmanagement.v1.EndpointInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.EndpointInfo();
  }

  public static com.google.cloud.networkmanagement.v1.EndpointInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EndpointInfo> PARSER =
      new com.google.protobuf.AbstractParser<EndpointInfo>() {
        @java.lang.Override
        public EndpointInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EndpointInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EndpointInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.EndpointInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
