/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a VPC firewall rule, an implied
 * VPC firewall rule, or a hierarchical firewall policy rule.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.FirewallInfo}
 */
public final class FirewallInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.FirewallInfo)
    FirewallInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FirewallInfo.newBuilder() to construct.
  private FirewallInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FirewallInfo() {
    displayName_ = "";
    uri_ = "";
    direction_ = "";
    action_ = "";
    networkUri_ = "";
    targetTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    policy_ = "";
    firewallRuleType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FirewallInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_FirewallInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_FirewallInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.FirewallInfo.class,
            com.google.cloud.networkmanagement.v1.FirewallInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The firewall rule's type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType}
   */
  public enum FirewallRuleType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type.
     * </pre>
     *
     * <code>FIREWALL_RULE_TYPE_UNSPECIFIED = 0;</code>
     */
    FIREWALL_RULE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Hierarchical firewall policy rule. For details, see
     * [Hierarchical firewall policies
     * overview](https://cloud.google.com/vpc/docs/firewall-policies).
     * </pre>
     *
     * <code>HIERARCHICAL_FIREWALL_POLICY_RULE = 1;</code>
     */
    HIERARCHICAL_FIREWALL_POLICY_RULE(1),
    /**
     *
     *
     * <pre>
     * VPC firewall rule. For details, see
     * [VPC firewall rules
     * overview](https://cloud.google.com/vpc/docs/firewalls).
     * </pre>
     *
     * <code>VPC_FIREWALL_RULE = 2;</code>
     */
    VPC_FIREWALL_RULE(2),
    /**
     *
     *
     * <pre>
     * Implied VPC firewall rule. For details, see
     * [Implied
     * rules](https://cloud.google.com/vpc/docs/firewalls#default_firewall_rules).
     * </pre>
     *
     * <code>IMPLIED_VPC_FIREWALL_RULE = 3;</code>
     */
    IMPLIED_VPC_FIREWALL_RULE(3),
    /**
     *
     *
     * <pre>
     * Implicit firewall rules that are managed by serverless VPC access to
     * allow ingress access. They are not visible in the Google Cloud console.
     * For details, see [VPC connector's implicit
     * rules](https://cloud.google.com/functions/docs/networking/connecting-vpc#restrict-access).
     * </pre>
     *
     * <code>SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE = 4;</code>
     */
    SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE(4),
    /**
     *
     *
     * <pre>
     * Global network firewall policy rule.
     * For details, see [Network firewall
     * policies](https://cloud.google.com/vpc/docs/network-firewall-policies).
     * </pre>
     *
     * <code>NETWORK_FIREWALL_POLICY_RULE = 5;</code>
     */
    NETWORK_FIREWALL_POLICY_RULE(5),
    /**
     *
     *
     * <pre>
     * Regional network firewall policy rule.
     * For details, see [Regional network firewall
     * policies](https://cloud.google.com/firewall/docs/regional-firewall-policies).
     * </pre>
     *
     * <code>NETWORK_REGIONAL_FIREWALL_POLICY_RULE = 6;</code>
     */
    NETWORK_REGIONAL_FIREWALL_POLICY_RULE(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type.
     * </pre>
     *
     * <code>FIREWALL_RULE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FIREWALL_RULE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Hierarchical firewall policy rule. For details, see
     * [Hierarchical firewall policies
     * overview](https://cloud.google.com/vpc/docs/firewall-policies).
     * </pre>
     *
     * <code>HIERARCHICAL_FIREWALL_POLICY_RULE = 1;</code>
     */
    public static final int HIERARCHICAL_FIREWALL_POLICY_RULE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * VPC firewall rule. For details, see
     * [VPC firewall rules
     * overview](https://cloud.google.com/vpc/docs/firewalls).
     * </pre>
     *
     * <code>VPC_FIREWALL_RULE = 2;</code>
     */
    public static final int VPC_FIREWALL_RULE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Implied VPC firewall rule. For details, see
     * [Implied
     * rules](https://cloud.google.com/vpc/docs/firewalls#default_firewall_rules).
     * </pre>
     *
     * <code>IMPLIED_VPC_FIREWALL_RULE = 3;</code>
     */
    public static final int IMPLIED_VPC_FIREWALL_RULE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Implicit firewall rules that are managed by serverless VPC access to
     * allow ingress access. They are not visible in the Google Cloud console.
     * For details, see [VPC connector's implicit
     * rules](https://cloud.google.com/functions/docs/networking/connecting-vpc#restrict-access).
     * </pre>
     *
     * <code>SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE = 4;</code>
     */
    public static final int SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Global network firewall policy rule.
     * For details, see [Network firewall
     * policies](https://cloud.google.com/vpc/docs/network-firewall-policies).
     * </pre>
     *
     * <code>NETWORK_FIREWALL_POLICY_RULE = 5;</code>
     */
    public static final int NETWORK_FIREWALL_POLICY_RULE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Regional network firewall policy rule.
     * For details, see [Regional network firewall
     * policies](https://cloud.google.com/firewall/docs/regional-firewall-policies).
     * </pre>
     *
     * <code>NETWORK_REGIONAL_FIREWALL_POLICY_RULE = 6;</code>
     */
    public static final int NETWORK_REGIONAL_FIREWALL_POLICY_RULE_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FirewallRuleType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FirewallRuleType forNumber(int value) {
      switch (value) {
        case 0:
          return FIREWALL_RULE_TYPE_UNSPECIFIED;
        case 1:
          return HIERARCHICAL_FIREWALL_POLICY_RULE;
        case 2:
          return VPC_FIREWALL_RULE;
        case 3:
          return IMPLIED_VPC_FIREWALL_RULE;
        case 4:
          return SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE;
        case 5:
          return NETWORK_FIREWALL_POLICY_RULE;
        case 6:
          return NETWORK_REGIONAL_FIREWALL_POLICY_RULE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FirewallRuleType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FirewallRuleType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FirewallRuleType>() {
              public FirewallRuleType findValueByNumber(int number) {
                return FirewallRuleType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.FirewallInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FirewallRuleType[] VALUES = values();

    public static FirewallRuleType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FirewallRuleType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType)
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the VPC firewall rule. This field is not applicable
   * to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the VPC firewall rule. This field is not applicable
   * to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the VPC firewall rule. This field is not applicable to
   * implied firewall rules or hierarchical firewall policy rules.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the VPC firewall rule. This field is not applicable to
   * implied firewall rules or hierarchical firewall policy rules.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIRECTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object direction_ = "";
  /**
   *
   *
   * <pre>
   * Possible values: INGRESS, EGRESS
   * </pre>
   *
   * <code>string direction = 3;</code>
   *
   * @return The direction.
   */
  @java.lang.Override
  public java.lang.String getDirection() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      direction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Possible values: INGRESS, EGRESS
   * </pre>
   *
   * <code>string direction = 3;</code>
   *
   * @return The bytes for direction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirectionBytes() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      direction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";
  /**
   *
   *
   * <pre>
   * Possible values: ALLOW, DENY
   * </pre>
   *
   * <code>string action = 4;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Possible values: ALLOW, DENY
   * </pre>
   *
   * <code>string action = 4;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIORITY_FIELD_NUMBER = 5;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * The priority of the firewall rule.
   * </pre>
   *
   * <code>int32 priority = 5;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the VPC network that the firewall rule is associated with.
   * This field is not applicable to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>string network_uri = 6;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the VPC network that the firewall rule is associated with.
   * This field is not applicable to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>string network_uri = 6;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_TAGS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The target tags defined by the VPC firewall rule. This field is not
   * applicable to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>repeated string target_tags = 7;</code>
   *
   * @return A list containing the targetTags.
   */
  public com.google.protobuf.ProtocolStringList getTargetTagsList() {
    return targetTags_;
  }
  /**
   *
   *
   * <pre>
   * The target tags defined by the VPC firewall rule. This field is not
   * applicable to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>repeated string target_tags = 7;</code>
   *
   * @return The count of targetTags.
   */
  public int getTargetTagsCount() {
    return targetTags_.size();
  }
  /**
   *
   *
   * <pre>
   * The target tags defined by the VPC firewall rule. This field is not
   * applicable to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>repeated string target_tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The targetTags at the given index.
   */
  public java.lang.String getTargetTags(int index) {
    return targetTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The target tags defined by the VPC firewall rule. This field is not
   * applicable to hierarchical firewall policy rules.
   * </pre>
   *
   * <code>repeated string target_tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetTags at the given index.
   */
  public com.google.protobuf.ByteString getTargetTagsBytes(int index) {
    return targetTags_.getByteString(index);
  }

  public static final int TARGET_SERVICE_ACCOUNTS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetServiceAccounts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The target service accounts specified by the firewall rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 8;</code>
   *
   * @return A list containing the targetServiceAccounts.
   */
  public com.google.protobuf.ProtocolStringList getTargetServiceAccountsList() {
    return targetServiceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * The target service accounts specified by the firewall rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 8;</code>
   *
   * @return The count of targetServiceAccounts.
   */
  public int getTargetServiceAccountsCount() {
    return targetServiceAccounts_.size();
  }
  /**
   *
   *
   * <pre>
   * The target service accounts specified by the firewall rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The targetServiceAccounts at the given index.
   */
  public java.lang.String getTargetServiceAccounts(int index) {
    return targetServiceAccounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The target service accounts specified by the firewall rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetServiceAccounts at the given index.
   */
  public com.google.protobuf.ByteString getTargetServiceAccountsBytes(int index) {
    return targetServiceAccounts_.getByteString(index);
  }

  public static final int POLICY_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object policy_ = "";
  /**
   *
   *
   * <pre>
   * The hierarchical firewall policy that this rule is associated with.
   * This field is not applicable to VPC firewall rules.
   * </pre>
   *
   * <code>string policy = 9;</code>
   *
   * @return The policy.
   */
  @java.lang.Override
  public java.lang.String getPolicy() {
    java.lang.Object ref = policy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      policy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The hierarchical firewall policy that this rule is associated with.
   * This field is not applicable to VPC firewall rules.
   * </pre>
   *
   * <code>string policy = 9;</code>
   *
   * @return The bytes for policy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPolicyBytes() {
    java.lang.Object ref = policy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      policy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIREWALL_RULE_TYPE_FIELD_NUMBER = 10;
  private int firewallRuleType_ = 0;
  /**
   *
   *
   * <pre>
   * The firewall rule's type.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
   * </code>
   *
   * @return The enum numeric value on the wire for firewallRuleType.
   */
  @java.lang.Override
  public int getFirewallRuleTypeValue() {
    return firewallRuleType_;
  }
  /**
   *
   *
   * <pre>
   * The firewall rule's type.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
   * </code>
   *
   * @return The firewallRuleType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType getFirewallRuleType() {
    com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType result =
        com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType.forNumber(
            firewallRuleType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(direction_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, direction_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, action_);
    }
    if (priority_ != 0) {
      output.writeInt32(5, priority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, networkUri_);
    }
    for (int i = 0; i < targetTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, targetTags_.getRaw(i));
    }
    for (int i = 0; i < targetServiceAccounts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 8, targetServiceAccounts_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, policy_);
    }
    if (firewallRuleType_
        != com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
            .FIREWALL_RULE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, firewallRuleType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(direction_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, direction_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, action_);
    }
    if (priority_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, priority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, networkUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetTagsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetServiceAccounts_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetServiceAccounts_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetServiceAccountsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, policy_);
    }
    if (firewallRuleType_
        != com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
            .FIREWALL_RULE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, firewallRuleType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.FirewallInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.FirewallInfo other =
        (com.google.cloud.networkmanagement.v1.FirewallInfo) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getDirection().equals(other.getDirection())) return false;
    if (!getAction().equals(other.getAction())) return false;
    if (getPriority() != other.getPriority()) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getTargetTagsList().equals(other.getTargetTagsList())) return false;
    if (!getTargetServiceAccountsList().equals(other.getTargetServiceAccountsList())) return false;
    if (!getPolicy().equals(other.getPolicy())) return false;
    if (firewallRuleType_ != other.firewallRuleType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + DIRECTION_FIELD_NUMBER;
    hash = (53 * hash) + getDirection().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getAction().hashCode();
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + getPriority();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    if (getTargetTagsCount() > 0) {
      hash = (37 * hash) + TARGET_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetTagsList().hashCode();
    }
    if (getTargetServiceAccountsCount() > 0) {
      hash = (37 * hash) + TARGET_SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetServiceAccountsList().hashCode();
    }
    hash = (37 * hash) + POLICY_FIELD_NUMBER;
    hash = (53 * hash) + getPolicy().hashCode();
    hash = (37 * hash) + FIREWALL_RULE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + firewallRuleType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.FirewallInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a VPC firewall rule, an implied
   * VPC firewall rule, or a hierarchical firewall policy rule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.FirewallInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.FirewallInfo)
      com.google.cloud.networkmanagement.v1.FirewallInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_FirewallInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_FirewallInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.FirewallInfo.class,
              com.google.cloud.networkmanagement.v1.FirewallInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.FirewallInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      uri_ = "";
      direction_ = "";
      action_ = "";
      priority_ = 0;
      networkUri_ = "";
      targetTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      policy_ = "";
      firewallRuleType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_FirewallInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.FirewallInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.FirewallInfo build() {
      com.google.cloud.networkmanagement.v1.FirewallInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.FirewallInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.FirewallInfo result =
          new com.google.cloud.networkmanagement.v1.FirewallInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.FirewallInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.direction_ = direction_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.action_ = action_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.priority_ = priority_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.networkUri_ = networkUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        targetTags_.makeImmutable();
        result.targetTags_ = targetTags_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        targetServiceAccounts_.makeImmutable();
        result.targetServiceAccounts_ = targetServiceAccounts_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.policy_ = policy_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.firewallRuleType_ = firewallRuleType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.FirewallInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.FirewallInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.FirewallInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDirection().isEmpty()) {
        direction_ = other.direction_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getAction().isEmpty()) {
        action_ = other.action_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getPriority() != 0) {
        setPriority(other.getPriority());
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.targetTags_.isEmpty()) {
        if (targetTags_.isEmpty()) {
          targetTags_ = other.targetTags_;
          bitField0_ |= 0x00000040;
        } else {
          ensureTargetTagsIsMutable();
          targetTags_.addAll(other.targetTags_);
        }
        onChanged();
      }
      if (!other.targetServiceAccounts_.isEmpty()) {
        if (targetServiceAccounts_.isEmpty()) {
          targetServiceAccounts_ = other.targetServiceAccounts_;
          bitField0_ |= 0x00000080;
        } else {
          ensureTargetServiceAccountsIsMutable();
          targetServiceAccounts_.addAll(other.targetServiceAccounts_);
        }
        onChanged();
      }
      if (!other.getPolicy().isEmpty()) {
        policy_ = other.policy_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.firewallRuleType_ != 0) {
        setFirewallRuleTypeValue(other.getFirewallRuleTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                direction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetTagsIsMutable();
                targetTags_.add(s);
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetServiceAccountsIsMutable();
                targetServiceAccounts_.add(s);
                break;
              } // case 66
            case 74:
              {
                policy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                firewallRuleType_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the VPC firewall rule. This field is not applicable
     * to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the VPC firewall rule. This field is not applicable
     * to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the VPC firewall rule. This field is not applicable
     * to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the VPC firewall rule. This field is not applicable
     * to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the VPC firewall rule. This field is not applicable
     * to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the VPC firewall rule. This field is not applicable to
     * implied firewall rules or hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC firewall rule. This field is not applicable to
     * implied firewall rules or hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC firewall rule. This field is not applicable to
     * implied firewall rules or hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC firewall rule. This field is not applicable to
     * implied firewall rules or hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC firewall rule. This field is not applicable to
     * implied firewall rules or hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object direction_ = "";
    /**
     *
     *
     * <pre>
     * Possible values: INGRESS, EGRESS
     * </pre>
     *
     * <code>string direction = 3;</code>
     *
     * @return The direction.
     */
    public java.lang.String getDirection() {
      java.lang.Object ref = direction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        direction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Possible values: INGRESS, EGRESS
     * </pre>
     *
     * <code>string direction = 3;</code>
     *
     * @return The bytes for direction.
     */
    public com.google.protobuf.ByteString getDirectionBytes() {
      java.lang.Object ref = direction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        direction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Possible values: INGRESS, EGRESS
     * </pre>
     *
     * <code>string direction = 3;</code>
     *
     * @param value The direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirection(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      direction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Possible values: INGRESS, EGRESS
     * </pre>
     *
     * <code>string direction = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDirection() {
      direction_ = getDefaultInstance().getDirection();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Possible values: INGRESS, EGRESS
     * </pre>
     *
     * <code>string direction = 3;</code>
     *
     * @param value The bytes for direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirectionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      direction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object action_ = "";
    /**
     *
     *
     * <pre>
     * Possible values: ALLOW, DENY
     * </pre>
     *
     * <code>string action = 4;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Possible values: ALLOW, DENY
     * </pre>
     *
     * <code>string action = 4;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Possible values: ALLOW, DENY
     * </pre>
     *
     * <code>string action = 4;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Possible values: ALLOW, DENY
     * </pre>
     *
     * <code>string action = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Possible values: ALLOW, DENY
     * </pre>
     *
     * <code>string action = 4;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * The priority of the firewall rule.
     * </pre>
     *
     * <code>int32 priority = 5;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * The priority of the firewall rule.
     * </pre>
     *
     * <code>int32 priority = 5;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of the firewall rule.
     * </pre>
     *
     * <code>int32 priority = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000010);
      priority_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the VPC network that the firewall rule is associated with.
     * This field is not applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string network_uri = 6;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC network that the firewall rule is associated with.
     * This field is not applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string network_uri = 6;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC network that the firewall rule is associated with.
     * This field is not applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string network_uri = 6;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC network that the firewall rule is associated with.
     * This field is not applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string network_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the VPC network that the firewall rule is associated with.
     * This field is not applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>string network_uri = 6;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetTagsIsMutable() {
      if (!targetTags_.isModifiable()) {
        targetTags_ = new com.google.protobuf.LazyStringArrayList(targetTags_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @return A list containing the targetTags.
     */
    public com.google.protobuf.ProtocolStringList getTargetTagsList() {
      targetTags_.makeImmutable();
      return targetTags_;
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @return The count of targetTags.
     */
    public int getTargetTagsCount() {
      return targetTags_.size();
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The targetTags at the given index.
     */
    public java.lang.String getTargetTags(int index) {
      return targetTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetTags at the given index.
     */
    public com.google.protobuf.ByteString getTargetTagsBytes(int index) {
      return targetTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetTags to set.
     * @return This builder for chaining.
     */
    public Builder setTargetTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetTagsIsMutable();
      targetTags_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @param value The targetTags to add.
     * @return This builder for chaining.
     */
    public Builder addTargetTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetTagsIsMutable();
      targetTags_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @param values The targetTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetTags(java.lang.Iterable<java.lang.String> values) {
      ensureTargetTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetTags_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetTags() {
      targetTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target tags defined by the VPC firewall rule. This field is not
     * applicable to hierarchical firewall policy rules.
     * </pre>
     *
     * <code>repeated string target_tags = 7;</code>
     *
     * @param value The bytes of the targetTags to add.
     * @return This builder for chaining.
     */
    public Builder addTargetTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetTagsIsMutable();
      targetTags_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetServiceAccounts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetServiceAccountsIsMutable() {
      if (!targetServiceAccounts_.isModifiable()) {
        targetServiceAccounts_ =
            new com.google.protobuf.LazyStringArrayList(targetServiceAccounts_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @return A list containing the targetServiceAccounts.
     */
    public com.google.protobuf.ProtocolStringList getTargetServiceAccountsList() {
      targetServiceAccounts_.makeImmutable();
      return targetServiceAccounts_;
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @return The count of targetServiceAccounts.
     */
    public int getTargetServiceAccountsCount() {
      return targetServiceAccounts_.size();
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The targetServiceAccounts at the given index.
     */
    public java.lang.String getTargetServiceAccounts(int index) {
      return targetServiceAccounts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetServiceAccounts at the given index.
     */
    public com.google.protobuf.ByteString getTargetServiceAccountsBytes(int index) {
      return targetServiceAccounts_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetServiceAccounts to set.
     * @return This builder for chaining.
     */
    public Builder setTargetServiceAccounts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @param value The targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addTargetServiceAccounts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @param values The targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetServiceAccounts(java.lang.Iterable<java.lang.String> values) {
      ensureTargetServiceAccountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetServiceAccounts_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetServiceAccounts() {
      targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target service accounts specified by the firewall rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 8;</code>
     *
     * @param value The bytes of the targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addTargetServiceAccountsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object policy_ = "";
    /**
     *
     *
     * <pre>
     * The hierarchical firewall policy that this rule is associated with.
     * This field is not applicable to VPC firewall rules.
     * </pre>
     *
     * <code>string policy = 9;</code>
     *
     * @return The policy.
     */
    public java.lang.String getPolicy() {
      java.lang.Object ref = policy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The hierarchical firewall policy that this rule is associated with.
     * This field is not applicable to VPC firewall rules.
     * </pre>
     *
     * <code>string policy = 9;</code>
     *
     * @return The bytes for policy.
     */
    public com.google.protobuf.ByteString getPolicyBytes() {
      java.lang.Object ref = policy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The hierarchical firewall policy that this rule is associated with.
     * This field is not applicable to VPC firewall rules.
     * </pre>
     *
     * <code>string policy = 9;</code>
     *
     * @param value The policy to set.
     * @return This builder for chaining.
     */
    public Builder setPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      policy_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hierarchical firewall policy that this rule is associated with.
     * This field is not applicable to VPC firewall rules.
     * </pre>
     *
     * <code>string policy = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicy() {
      policy_ = getDefaultInstance().getPolicy();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hierarchical firewall policy that this rule is associated with.
     * This field is not applicable to VPC firewall rules.
     * </pre>
     *
     * <code>string policy = 9;</code>
     *
     * @param value The bytes for policy to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      policy_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int firewallRuleType_ = 0;
    /**
     *
     *
     * <pre>
     * The firewall rule's type.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
     * </code>
     *
     * @return The enum numeric value on the wire for firewallRuleType.
     */
    @java.lang.Override
    public int getFirewallRuleTypeValue() {
      return firewallRuleType_;
    }
    /**
     *
     *
     * <pre>
     * The firewall rule's type.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
     * </code>
     *
     * @param value The enum numeric value on the wire for firewallRuleType to set.
     * @return This builder for chaining.
     */
    public Builder setFirewallRuleTypeValue(int value) {
      firewallRuleType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The firewall rule's type.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
     * </code>
     *
     * @return The firewallRuleType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
        getFirewallRuleType() {
      com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType result =
          com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType.forNumber(
              firewallRuleType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The firewall rule's type.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
     * </code>
     *
     * @param value The firewallRuleType to set.
     * @return This builder for chaining.
     */
    public Builder setFirewallRuleType(
        com.google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      firewallRuleType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The firewall rule's type.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType firewall_rule_type = 10;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFirewallRuleType() {
      bitField0_ = (bitField0_ & ~0x00000200);
      firewallRuleType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.FirewallInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.FirewallInfo)
  private static final com.google.cloud.networkmanagement.v1.FirewallInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.FirewallInfo();
  }

  public static com.google.cloud.networkmanagement.v1.FirewallInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FirewallInfo> PARSER =
      new com.google.protobuf.AbstractParser<FirewallInfo>() {
        @java.lang.Override
        public FirewallInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FirewallInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FirewallInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.FirewallInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
