/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a Compute Engine instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.InstanceInfo}
 */
public final class InstanceInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.InstanceInfo)
    InstanceInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceInfo.newBuilder() to construct.
  private InstanceInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceInfo() {
    displayName_ = "";
    uri_ = "";
    interface_ = "";
    networkUri_ = "";
    internalIp_ = "";
    externalIp_ = "";
    networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_InstanceInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_InstanceInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.InstanceInfo.class,
            com.google.cloud.networkmanagement.v1.InstanceInfo.Builder.class);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine instance.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine instance.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine instance.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine instance.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERFACE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interface_ = "";
  /**
   *
   *
   * <pre>
   * Name of the network interface of a Compute Engine instance.
   * </pre>
   *
   * <code>string interface = 3;</code>
   *
   * @return The interface.
   */
  @java.lang.Override
  public java.lang.String getInterface() {
    java.lang.Object ref = interface_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interface_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the network interface of a Compute Engine instance.
   * </pre>
   *
   * <code>string interface = 3;</code>
   *
   * @return The bytes for interface.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterfaceBytes() {
    java.lang.Object ref = interface_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interface_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network.
   * </pre>
   *
   * <code>string network_uri = 4;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network.
   * </pre>
   *
   * <code>string network_uri = 4;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERNAL_IP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalIp_ = "";
  /**
   *
   *
   * <pre>
   * Internal IP address of the network interface.
   * </pre>
   *
   * <code>string internal_ip = 5;</code>
   *
   * @return The internalIp.
   */
  @java.lang.Override
  public java.lang.String getInternalIp() {
    java.lang.Object ref = internalIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Internal IP address of the network interface.
   * </pre>
   *
   * <code>string internal_ip = 5;</code>
   *
   * @return The bytes for internalIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalIpBytes() {
    java.lang.Object ref = internalIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_IP_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalIp_ = "";
  /**
   *
   *
   * <pre>
   * External IP address of the network interface.
   * </pre>
   *
   * <code>string external_ip = 6;</code>
   *
   * @return The externalIp.
   */
  @java.lang.Override
  public java.lang.String getExternalIp() {
    java.lang.Object ref = externalIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * External IP address of the network interface.
   * </pre>
   *
   * <code>string external_ip = 6;</code>
   *
   * @return The bytes for externalIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalIpBytes() {
    java.lang.Object ref = externalIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_TAGS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList networkTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Network tags configured on the instance.
   * </pre>
   *
   * <code>repeated string network_tags = 7;</code>
   *
   * @return A list containing the networkTags.
   */
  public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
    return networkTags_;
  }
  /**
   *
   *
   * <pre>
   * Network tags configured on the instance.
   * </pre>
   *
   * <code>repeated string network_tags = 7;</code>
   *
   * @return The count of networkTags.
   */
  public int getNetworkTagsCount() {
    return networkTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Network tags configured on the instance.
   * </pre>
   *
   * <code>repeated string network_tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The networkTags at the given index.
   */
  public java.lang.String getNetworkTags(int index) {
    return networkTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Network tags configured on the instance.
   * </pre>
   *
   * <code>repeated string network_tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the networkTags at the given index.
   */
  public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
    return networkTags_.getByteString(index);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Service account authorized for the instance.
   * </pre>
   *
   * <code>string service_account = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
   *     google/cloud/networkmanagement/v1/trace.proto;l=268
   * @return The serviceAccount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Service account authorized for the instance.
   * </pre>
   *
   * <code>string service_account = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
   *     google/cloud/networkmanagement/v1/trace.proto;l=268
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(interface_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, interface_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, networkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(internalIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, internalIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, externalIp_);
    }
    for (int i = 0; i < networkTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, networkTags_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, serviceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(interface_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, interface_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, networkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(internalIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, internalIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, externalIp_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < networkTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(networkTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNetworkTagsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, serviceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.InstanceInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.InstanceInfo other =
        (com.google.cloud.networkmanagement.v1.InstanceInfo) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getInterface().equals(other.getInterface())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getInternalIp().equals(other.getInternalIp())) return false;
    if (!getExternalIp().equals(other.getExternalIp())) return false;
    if (!getNetworkTagsList().equals(other.getNetworkTagsList())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + INTERFACE_FIELD_NUMBER;
    hash = (53 * hash) + getInterface().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (37 * hash) + INTERNAL_IP_FIELD_NUMBER;
    hash = (53 * hash) + getInternalIp().hashCode();
    hash = (37 * hash) + EXTERNAL_IP_FIELD_NUMBER;
    hash = (53 * hash) + getExternalIp().hashCode();
    if (getNetworkTagsCount() > 0) {
      hash = (37 * hash) + NETWORK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTagsList().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.InstanceInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a Compute Engine instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.InstanceInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.InstanceInfo)
      com.google.cloud.networkmanagement.v1.InstanceInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_InstanceInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_InstanceInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.InstanceInfo.class,
              com.google.cloud.networkmanagement.v1.InstanceInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.InstanceInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      uri_ = "";
      interface_ = "";
      networkUri_ = "";
      internalIp_ = "";
      externalIp_ = "";
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceAccount_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_InstanceInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.InstanceInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.InstanceInfo build() {
      com.google.cloud.networkmanagement.v1.InstanceInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.InstanceInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.InstanceInfo result =
          new com.google.cloud.networkmanagement.v1.InstanceInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.InstanceInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.interface_ = interface_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.networkUri_ = networkUri_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.internalIp_ = internalIp_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.externalIp_ = externalIp_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        networkTags_.makeImmutable();
        result.networkTags_ = networkTags_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.InstanceInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.InstanceInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.InstanceInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getInterface().isEmpty()) {
        interface_ = other.interface_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getInternalIp().isEmpty()) {
        internalIp_ = other.internalIp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getExternalIp().isEmpty()) {
        externalIp_ = other.externalIp_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.networkTags_.isEmpty()) {
        if (networkTags_.isEmpty()) {
          networkTags_ = other.networkTags_;
          bitField0_ |= 0x00000040;
        } else {
          ensureNetworkTagsIsMutable();
          networkTags_.addAll(other.networkTags_);
        }
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                interface_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                internalIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                externalIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNetworkTagsIsMutable();
                networkTags_.add(s);
                break;
              } // case 58
            case 66:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine instance.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine instance.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object interface_ = "";
    /**
     *
     *
     * <pre>
     * Name of the network interface of a Compute Engine instance.
     * </pre>
     *
     * <code>string interface = 3;</code>
     *
     * @return The interface.
     */
    public java.lang.String getInterface() {
      java.lang.Object ref = interface_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interface_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the network interface of a Compute Engine instance.
     * </pre>
     *
     * <code>string interface = 3;</code>
     *
     * @return The bytes for interface.
     */
    public com.google.protobuf.ByteString getInterfaceBytes() {
      java.lang.Object ref = interface_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interface_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the network interface of a Compute Engine instance.
     * </pre>
     *
     * <code>string interface = 3;</code>
     *
     * @param value The interface to set.
     * @return This builder for chaining.
     */
    public Builder setInterface(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interface_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the network interface of a Compute Engine instance.
     * </pre>
     *
     * <code>string interface = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterface() {
      interface_ = getDefaultInstance().getInterface();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the network interface of a Compute Engine instance.
     * </pre>
     *
     * <code>string interface = 3;</code>
     *
     * @param value The bytes for interface to set.
     * @return This builder for chaining.
     */
    public Builder setInterfaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interface_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 4;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 4;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 4;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 4;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object internalIp_ = "";
    /**
     *
     *
     * <pre>
     * Internal IP address of the network interface.
     * </pre>
     *
     * <code>string internal_ip = 5;</code>
     *
     * @return The internalIp.
     */
    public java.lang.String getInternalIp() {
      java.lang.Object ref = internalIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Internal IP address of the network interface.
     * </pre>
     *
     * <code>string internal_ip = 5;</code>
     *
     * @return The bytes for internalIp.
     */
    public com.google.protobuf.ByteString getInternalIpBytes() {
      java.lang.Object ref = internalIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Internal IP address of the network interface.
     * </pre>
     *
     * <code>string internal_ip = 5;</code>
     *
     * @param value The internalIp to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internal IP address of the network interface.
     * </pre>
     *
     * <code>string internal_ip = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalIp() {
      internalIp_ = getDefaultInstance().getInternalIp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internal IP address of the network interface.
     * </pre>
     *
     * <code>string internal_ip = 5;</code>
     *
     * @param value The bytes for internalIp to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object externalIp_ = "";
    /**
     *
     *
     * <pre>
     * External IP address of the network interface.
     * </pre>
     *
     * <code>string external_ip = 6;</code>
     *
     * @return The externalIp.
     */
    public java.lang.String getExternalIp() {
      java.lang.Object ref = externalIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * External IP address of the network interface.
     * </pre>
     *
     * <code>string external_ip = 6;</code>
     *
     * @return The bytes for externalIp.
     */
    public com.google.protobuf.ByteString getExternalIpBytes() {
      java.lang.Object ref = externalIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * External IP address of the network interface.
     * </pre>
     *
     * <code>string external_ip = 6;</code>
     *
     * @param value The externalIp to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalIp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * External IP address of the network interface.
     * </pre>
     *
     * <code>string external_ip = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalIp() {
      externalIp_ = getDefaultInstance().getExternalIp();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * External IP address of the network interface.
     * </pre>
     *
     * <code>string external_ip = 6;</code>
     *
     * @param value The bytes for externalIp to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalIp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList networkTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNetworkTagsIsMutable() {
      if (!networkTags_.isModifiable()) {
        networkTags_ = new com.google.protobuf.LazyStringArrayList(networkTags_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @return A list containing the networkTags.
     */
    public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
      networkTags_.makeImmutable();
      return networkTags_;
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @return The count of networkTags.
     */
    public int getNetworkTagsCount() {
      return networkTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The networkTags at the given index.
     */
    public java.lang.String getNetworkTags(int index) {
      return networkTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the networkTags at the given index.
     */
    public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
      return networkTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The networkTags to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @param value The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @param values The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllNetworkTags(java.lang.Iterable<java.lang.String> values) {
      ensureNetworkTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkTags_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTags() {
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags configured on the instance.
     * </pre>
     *
     * <code>repeated string network_tags = 7;</code>
     *
     * @param value The bytes of the networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Service account authorized for the instance.
     * </pre>
     *
     * <code>string service_account = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=268
     * @return The serviceAccount.
     */
    @java.lang.Deprecated
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service account authorized for the instance.
     * </pre>
     *
     * <code>string service_account = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=268
     * @return The bytes for serviceAccount.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service account authorized for the instance.
     * </pre>
     *
     * <code>string service_account = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=268
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service account authorized for the instance.
     * </pre>
     *
     * <code>string service_account = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=268
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service account authorized for the instance.
     * </pre>
     *
     * <code>string service_account = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.networkmanagement.v1.InstanceInfo.service_account is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=268
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.InstanceInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.InstanceInfo)
  private static final com.google.cloud.networkmanagement.v1.InstanceInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.InstanceInfo();
  }

  public static com.google.cloud.networkmanagement.v1.InstanceInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceInfo> PARSER =
      new com.google.protobuf.AbstractParser<InstanceInfo>() {
        @java.lang.Override
        public InstanceInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.InstanceInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
